/*
	test.sql

	Populates the pgjobs schema with sample entries.
	For test purpose only.

	Project: pgjobs
	Author:  Zlatko Michailov
	Created: 21-May-2004

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2004, Zlatko Michailov

*/



--------------------------------------------------------------------------------

truncate table pgj_job_schedule_;
truncate table pgj_job_;
truncate table pgj_schedule_;


-- Schedules
select pgj_create_schedule( 'd1', 'D 18:15' );
select pgj_create_schedule( 'i1', 'I 5' );
select pgj_create_schedule( 'w1', 'W 1 7:30' );
select pgj_create_schedule( 'sd', 'D 2004.06.01 0:00' );
select pgj_create_schedule( 'si', 'I 1:00' );


-- Jobs
select pgj_create_job( 'j1', 'foo1()', null, 'd1' );
select pgj_create_job( 'j2', 'foo2()', 'sd', 'w1' );
select pgj_create_job( 'j3', 'foo3()', 'si', 'i1' );
select pgj_create_startup_job( 'sj1', 'foos()' );


-- Test table
drop table pgj_test_;

create table pgj_test_
(
	func		text,
	starttime	timestamp
);


-- Job functions
create or replace function foo_common
(
	text	-- $1 topfunc
)
returns boolean
as '
	declare
		topfunc			alias for $1;

		currentTime		timestamp;
	begin
		currentTime := date_trunc( ''minute'', current_timestamp() );

		execute ''
			insert into	pgj_test_( func, starttime )
			values( '' || quote_literal( topfunc ) || '', '' ||
						  quote_literal( currentTime ) || '' );
			'';

		return TRUE;
	end;
' language 'plpgsql';


create or replace function foo1()
returns boolean
as '
	begin
		return foo_common( ''foo1()'' );
	end;
' language 'plpgsql';


create or replace function foo2()
returns boolean
as '
	begin
		return foo_common( ''foo2()'' );
	end;
' language 'plpgsql';


create or replace function foo3()
returns boolean
as '
	begin
		return foo_common( ''foo3()'' );
	end;
' language 'plpgsql';


create or replace function foos()
returns boolean
as '
	begin
		execute ''
			truncate table pgj_test_;
			'';
			
		return foo_common( ''foos()'' );
	end;
' language 'plpgsql';

