

------------------------------------------------
-- Returns the number of seconds in an interval.
------------------------------------------------
create or replace function pgj_interval_to_seconds
(
	interval	-- $1 ti
)
returns int
as '
	declare
		ti		alias for $1;

	begin
		return	extract( ''day''	from ti ) * 24 * 60 * 60 +
				extract( ''hour''	from ti ) * 60 * 60 +
				extract( ''minute''	from ti ) * 60 +
				extract( ''second''	from ti );
	end;
' language 'plpgsql';



------------------------------------------------
-- Returns the number of seconds until the next
-- trigger time.
------------------------------------------------
create or replace function pgj_trigger_seconds()
returns int
as '
	declare
		triggerTime		timestamp;
		currentTime		timestamp;

	begin
		currentTime := date_trunc( ''second'', current_timestamp() );
		triggerTime := pgj_trigger_time();

		return	pgj_interval_to_seconds( triggerTime - currentTime );
	end;
' language 'plpgsql';



