------------------------------------------------
-- Initializes a pgjobs session:
--		o records startuptime in pgj_settings
--		o records that no startup schedule is up yet
------------------------------------------------
create or replace function pgj_startup()
returns boolean
as '
	declare
		currentTime			timestamp;
		settingsRowCount	int;
		temp				text;

	begin
		currentTime := date_trunc( ''minute'', current_timestamp() );

		select	into settingsRowCount count( * )
		from	pgj_settings_;

		if settingsRowCount = 0 then
			temp := ''
				insert into pgj_settings_( startuptime )
				values( '' || quote_literal( currentTime ) || '' );
				'';
		else
			temp := ''
				update	pgj_settings_
				set		startuptime = '' || quote_literal( currentTime ) || '';
				'';
		end if;
		execute temp;

		temp := ''
			update	pgj_job_
			set		jobisstartschup = null;
			'';
		execute temp;

		return TRUE;
	end;
' language 'plpgsql';



------------------------------------------------
-- Returns a rowset of the startup jobs.
------------------------------------------------
create view pgj_jobs_startup
as
	select	distinct jobid, jobname, jobfunction
	from	pgj_job_
	where	jobisstartup;

