<?
/* application.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi (pratesi@telug.it) */

/* turn on verbose error reporting (15) to see all warnings and errors */
//error_reporting(15);

$special_th = 100;

/* define a generic object */
class object {};

/* setup the configuration object */
$CFG = new object;

$CFG->dbhost = "localhost";
$CFG->port = "5432";
$CFG->dbname = "pgmarket";
$CFG->dbuser = "postgres";
$CFG->dbpass = "postgres";

$CFG->myname = "PgMarket 1.3.x";

$frames=1;

$CFG->wwwroot     = "/~pratesi/pgmarket";	// without an ending "/"
$CFG->firstpage   = "$CFG->wwwroot/firstpage.php";
$CFG->dirroot     = "/home/pratesi/public_html/pgmarket";	// without an ending "/"
$CFG->templatedir = "$CFG->dirroot/templates/";	// with an ending "/"
$CFG->libdir      = "$CFG->dirroot/lib";	// without an ending "/"
$CFG->localedir   = "$CFG->dirroot/locale/";	// with an ending "/"
$CFG->productswww = "$CFG->wwwroot/products/";	// with an ending "/"
$CFG->productsdir = "$CFG->dirroot/products/";	// with an ending "/"
$CFG->images      = "$CFG->wwwroot/images/";	// with an ending "/"
$CFG->wordlist    = "$CFG->libdir/wordlist.txt";

$CFG->pnmpath     = "/usr/bin";	// without an ending "/"

$CFG->support     = "pratesi@localhost";	// "Technical support" at PgMarket
$subject_contact = "Contact us!";
$subject_cash_on_delivery = "New Order - Cash on Delivery";
$subject_credit_card = "New Order - Credit Card";
$CFG->seller_fullname = "Marco Pratesi";
$CFG->seller_email = "pratesi@localhost";

/* define database error handling behavior, since we are in development stages
 * we will turn on all the debugging messages to help us troubleshoot */
$DB_DEBUG = true;
$DB_DIE_ON_FAIL = true;

/* load up standard libraries */
require("$CFG->libdir/stdlib.inc.php");
require("$CFG->libdir/dblib.inc.php");
require("$CFG->libdir/pgmarket.inc.php");
require("$CFG->libdir/cart.inc.php");

/* setup some global variables */
$ME = qualified_me();

/* start up the sessions, to keep things clean and manageable we will just
 * use one array called SESSION to store our persistent variables.   */
session_start();
session_register("SESSION");

/* initialize the SESSION variable if necessary */
if (! isset($SESSION)) {
	$SESSION = array();
}

// Loaded modules
$SESSION["brand_used"] = 1;
$SESSION["iva_used"] = 0;
$SESSION["iva_value"] = 0;	// not significant if IVA is not used

$SESSION["price_must_be_integer"] = 0;
	// 1 --> the price must be integer (Italian Lit, for example)
	// 0 --> the price can be float (US Dollars, for example)
$SESSION["weightmax"] = 10000.0;

$SESSION["max_file_size_import"] = 10000000;	// upload of import files
$SESSION["max_file_size_images"] = 500000;	// upload of product images

session_register("CART");

/* initialize the CART objct if necessary */
if (! isset($CART)) {
	$CART = new Cart;
}

//$yes = "si";
$yes = "yes";
// choose the default language if not set
if (! isset($SESSION["lang"])) {
//	$SESSION["lang"] = "it";
	$SESSION["lang"] = "us";
}
$CFG->global = $CFG->localedir.$SESSION["lang"]."/global.inc.php";

include ($CFG->global);

//$dollars = "Lit";
$dollars = "$";
function print_formatted_price($price) {
	global $dollars, $lire2euro;
//	echo $dollars . " " . number_format ($price, 0, ",", ".");
	echo $dollars . " " . number_format ($price, 2, ".", ",");
}
function formatted_price($price) {
	global $dollars, $lire2euro;
//	return $dollars . " " . number_format ($price, 0, ",", ".");
	return $dollars . " " . number_format ($price, 2, ".", ",");
}
function formatted_price_text($price) {
	global $dollars, $lire2euro;
//	return $dollars . " " . number_format ($price, 0, ",", ".");
	return $dollars . " " . number_format ($price, 2, ".", ",");
}

$weightunity = "Kg";
function print_formatted_weight($weight) {
//	echo number_format ($weight, 2, ",", ".");
	echo number_format ($weight, 2, ".", ",");
}
function formatted_weight($weight) {
//	return number_format ($weight, 2, ",", ".");
	return number_format ($weight, 2, ".", ",");
}

$SESSION["username_length"] = 16;
$SESSION["username_length_min"] = 6;
$SESSION["password_length"] = 32;
$SESSION["priv_length"] = 5;
$SESSION["firstname_length"] = 64;
$SESSION["lastname_length"] = 64;
$SESSION["name_length"] = 64;
$SESSION["fiscalcode_length"] = 16;
$SESSION["partitaiva_length"] = 11;
$SESSION["address_length"] = 255;
$SESSION["number_length"] = 5;
$SESSION["city_length"] = 100;
$SESSION["state_length"] = 100;
$SESSION["zip_code_length"] = 5;
$SESSION["phone_length"] = 32;
$SESSION["phone_length_min"] = 5;
$SESSION["fax_length"] = 32;
$SESSION["fax_length_min"] = 5;
$SESSION["mobilephone_length"] = 32;
$SESSION["mobilephone_length_min"] = 5;
$SESSION["email_length"] = 128;
$SESSION["notes_length"] = 500;
$SESSION["message_length"] = 5000;
$SESSION["ournotes_length"] = 500;
$SESSION["comments_length"] = 500;

$SESSION["category_name_length"] = 100;
$SESSION["category_description_length"] = 255;
$SESSION["brand_name_length"] = 100;
$SESSION["brand_description_length"] = 255;
$SESSION["product_id_length"] = 25;
$SESSION["product_name_length"] = 100;
$SESSION["product_description_length"] = 500;
$SESSION["product_extended_description_length"] = 2000;
$SESSION["discqtymax"] = 1000;

$SESSION["products_per_page"] = 10;	// max number of products to be shown per page (search results, admin products page)
$SESSION["max_results"] = 100;		// max number of search results to accept the search request
$SESSION["users_per_page"] = 10;	// max number of users to be shown per page (admin users page)
$SESSION["orders_per_page"] = 10;	// max number of orders to be shown per page (admin orders page)
$SESSION["categories_per_page"] = 10;	// max number of categories to be shown per page (admin orders page)
$SESSION["brands_per_page"] = 10;	// max number of brands to be shown per page (admin brands page)
$SESSION["iva_per_page"] = 10;		// max number of iva percentuals to be shown per page (admin iva page)

$ordersdb[Customer]	= "Customer      :";
$ordersdb[Phone]	= "Phone Contact :";
$ordersdb[Address]	= "Address       :";
$ordersdb[Cash_On_Delivery] = "Cash on Delivery";
$ordersdb[Order] = "Order";
$ordersdb[Username] = "Username";
$ordersdb[Date] = "Date";
$ordersdb[Comments] = "Comments";
$ordersdb[TOTAL] = "TOTAL";
$ordersdb[Product] = "Product";
$ordersdb[Unit_Price] = "Unit price";
$ordersdb[Number_of_items] = "Number of items";
$ordersdb[Delivery] = "Delivery";

$contact[NameOrEnterpriseName] = "Name (Enterprise Name): ";
$contact[Address] = "Address:";
$contact[Phone]         = "Phone:        ";
$contact[Fax]           = "Fax:          ";
$contact[MobilePhone]   = "Mobile Phone: ";
$contact[EMail]         = "E-Mail:       ";
$contact[AuthData]      = "Authorization for data handling: ";
$contact[AuthAdvert]    = "Acceptance of advertising matherial: ";
$contact[Message]       = "Message:";

$myday[1] = "Monday";
$myday[2] = "Tuesday";
$myday[3] = "Wednesday";
$myday[4] = "Thursday";
$myday[5] = "Friday";
$myday[6] = "Saturday";
$myday[0] = "Sunday";
        
$mymonth[1] = "January";
$mymonth[2] = "February";
$mymonth[3] = "March";
$mymonth[4] = "April";
$mymonth[5] = "May";
$mymonth[6] = "June";
$mymonth[7] = "July";
$mymonth[8] = "August";
$mymonth[9] = "September";
$mymonth[10] = "October";
$mymonth[11] = "November";
$mymonth[12] = "December";

/* connect to the database */
db_connect($CFG->dbhost, $CFG->port, $CFG->dbname, $CFG->dbuser, $CFG->dbpass);

?>
