<?

/* (c) 2000, 2001 Marco Pratesi (pratesi@telug.it) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");

/* form has been submitted, try to send the message */
if (match_referer() && isset($HTTP_POST_VARS) && !isset($from_menu)) {
	$frm = $HTTP_POST_VARS;
	$errormsg = validate_form($frm, $errors, $usertype);

	if (empty($errormsg)) {
		send_form($frm);

		$DOC_TITLE = $Contact_Successful;
		include("$CFG->templatedir"."header.ihtml");
		include("templates/".$SESSION["lang"]."/contact_success.ihtml");
		include("$CFG->templatedir"."footer.ihtml");
		die;
	}
} else if (is_logged_in()) {
	$frm = load_user_profile();
	$frm["name"] = $frm["firstname"] . " " . $frm["lastname"];
}

$DOC_TITLE = $Contact_Us;
include("$CFG->templatedir"."header.ihtml");
include("$CFG->templatedir"."form_header.ihtml");
if (empty($errormsg)) {	// we are loading the form for the first time
	$frm["acceptadvert"] = $yes;
}
include("templates/contact_form.ihtml");
include("$CFG->templatedir"."footer.ihtml");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function validate_form(&$frm, &$errors) {
/* validate the contact form, and return the error messages in a string.  if
 * the string is empty, then there are no errors */

	global $CFG, $SESSION;

	$errors = new Object;
	$msg = "";

	validate_name($frm["name"], &$errors, &$msg);
	validate_address($frm["address"], &$errors, &$msg);
	validate_number($frm["number"], &$errors, &$msg);
	validate_city($frm["city"], &$errors, &$msg);
	validate_state($frm["state"], &$errors, &$msg);
	validate_zip_code($frm["zip_code"], &$errors, &$msg);
	validate_phone($frm["phone"], &$errors, &$msg);
	validate_fax($frm["fax"], &$errors, &$msg);
	validate_mobilephone($frm["mobilephone"], &$errors, &$msg);
	validate_email($frm["email"], &$errors, &$msg);
	validate_message($frm["message"], &$errors, &$msg);

	return $msg;
}

function send_form(&$frm) {

	global $CFG, $SESSION;
	global $subject_contact, $contact;
	include ($CFG->global);

	$emailbody = "";
	$emailbody .= $contact[NameOrEnterpriseName] . stripslashes($frm["name"]);
	$emailbody .= "\n\n" . $contact[Address] . "\n" . stripslashes($frm["address"]);
	$emailbody .= " " . stripslashes($frm["number"]);
	$emailbody .= "\n" . stripslashes($frm["city"]);
	$emailbody .= "\n" . stripslashes($frm["state"]);
	$emailbody .= "\n" .   $Zip_Code . ": " . stripslashes($frm["zip_code"]);
	$emailbody .= "\n\n" . $contact[Phone] . $frm["phone"];
	$emailbody .= "\n\n" . $contact[Fax] . $frm["fax"];
	$emailbody .= "\n\n" . $contact[MobilePhone] . $frm["mobilephone"];
	$emailbody .= "\n\n" . $contact[EMail] . $frm["email"];
	$emailbody .= "\n\n" . $contact[AuthData] . strtoupper($frm["authdata"]);
	$emailbody .= "\n\n" . $contact[AuthAdvert] . strtoupper($frm["acceptadvert"]);
	$emailbody .= "\n\n" . $contact[Message] . "\n\n" . stripslashes($frm["message"]) . "\n";

	mail(
		"$CFG->seller_fullname <$CFG->seller_email>",
		$subject_contact,
		$emailbody,
		"From: $CFG->support");
}

?>
