<?
/* cart_view.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the 
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000 Marco Pratesi (pratesi@telug.it) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");

if (isset($func)) {
	switch ($func) {
		case "remove" :
			$CART->remove($product_id);
			break;

		case "empty" :
			$CART->init();
			break;

		case "recalc" :
			update_qty($HTTP_POST_VARS);
			break;
	}

	$CART->cleanup();
	$CART->recalc_total();
}

$qid = get_cart_items();

$DOC_TITLE = $Shopping_Cart;
include("$CFG->templatedir"."header.ihtml");
include("templates/shopping_cart.ihtml");
include("$CFG->templatedir"."footer.ihtml");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function update_qty(&$form) {
/* update the product quantities, we are expecting them in the HTTP_POST_VARS
 * variable because the form does a POST.  the quantities are in an array
 * called $qty[] and the corresponding product id's are in $product_id[] */

	global $SESSION, $CART;

	foreach ($form["product_id"] as $i => $productid) {
		$qty = $form["qty"][$i];
		$CART->set($productid, $qty);
	}
}

?>
