#include <uuid.h>

#include <postgres.h>
#include <fmgr.h>

/* random base UUID */
PG_FUNCTION_INFO_V1(newid_random);
Datum newid_random(PG_FUNCTION_ARGS)
{
	uuid_p result;

	result = (uuid_p)palloc(sizeof(uuid_t));

	uuid_generate_random(result);

	PG_RETURN_POINTER(result);
}

/* Time base UUID */
PG_FUNCTION_INFO_V1(newid_time);
Datum newid_time(PG_FUNCTION_ARGS)
{
	uuid_p result;

	result = (uuid_p)palloc(sizeof(uuid_t));

	uuid_generate_time(result);

	PG_RETURN_POINTER(result);
}

/* NIL UUID */
PG_FUNCTION_INFO_V1(newid_nil);
Datum newid_nil(PG_FUNCTION_ARGS)
{
	uuid_p result;

	result = (uuid_p)palloc(sizeof(uuid_t));

	uuid_generate_nil(result);

	PG_RETURN_POINTER(result);
}

/* Name base UUID */
/*
PG_FUNCTION_INFO_V1(newid_name)
Datum newid_name(PG_FUNCTION_ARGS)
{
	.....................................................
}
*/

/* Generate UUID According parm */
PG_FUNCTION_INFO_V1(newid);
Datum newid(PG_FUNCTION_ARGS)
{
	uuid_p result;

	int type;

	if (PG_ARGISNULL(0))
	{
		type = UUID_TYPE_TIME_BASE;
	}
	else
	{
		type = PG_GETARG_INT16(0);
	}

	result = (uuid_p)palloc(sizeof(uuid_t));

	switch (type)
	{
		case UUID_TYPE_NIL: /* == 0 */
			uuid_generate_nil(result);
			break;

		case UUID_TYPE_TIME_BASE: /* == 1 */
			uuid_generate_time(result);
			break;

		case UUID_TYPE_RANDOM_BASE: /* == 4 */
			uuid_generate_random(result);
			break;

		case UUID_TYPE_NAME_BASE: /* == 3 */
			/* .................. */
		default: /* > 4 */
			elog(ERROR, "parm %d is not support in this version!", type);
	}

	PG_RETURN_POINTER(result);
}

