<?php // $Id: stats-daily.php,v 1.8 2001/07/09 16:43:05 ciaccia Exp $ - #phpAdsNew Revision: 1.7 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by the phpPgAds developers                        */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// Include required files
require ("config.php");
require ("lib-statistics.inc.php");


// Security check
phpAds_checkAccess(phpAds_Admin+phpAds_Client);



/*********************************************************/
/* Client interface security                             */
/*********************************************************/

if (phpAds_isUser(phpAds_Client))
{
	$result = db_query("
		SELECT
			clientid
		FROM
			$phpAds_tbl_banners
		WHERE
			bannerid = $bannerid
		") or pg_die();
	$row = pg_fetch_array($result, 0);
	
	if ($row["clientid"] == '' || phpAds_clientid() != phpAds_getParentID ($row["clientid"]))
	{
		phpAds_PageHeader("1");
		php_die ($strAccessDenied, $strNotAdmin);
	}
	else
	{
		$campaignid = $row["clientid"];
	}
}



/*********************************************************/
/* HTML framework                                        */
/*********************************************************/

$extra = '';

$res = db_query("
	 SELECT
		count(*) as qnt,
		DATE_FORMAT(t_stamp::date, '$date_format') as t_stamp_f,
		t_stamp::date as t_stamp_d
	 FROM
		$phpAds_tbl_adviews
	 WHERE
		bannerid = $bannerid
	 GROUP BY
		t_stamp::date
	 ORDER BY
		t_stamp_d DESC
	 LIMIT 7
") or pg_die();

for ($pgc = 0; $row = @pg_fetch_array($res, $pgc); $pgc++)
{
	if ($day == $row['t_stamp_f'])
		$extra .= "&nbsp;&nbsp;&nbsp;<img src='images/box-1.gif'>&nbsp;";
	else
		$extra .= "&nbsp;&nbsp;&nbsp;<img src='images/box-0.gif'>&nbsp;";
	
	$extra .= "<a href='stats-daily.php?day=".urlencode($row["t_stamp_f"])."&campaignid=$campaignid&bannerid=$bannerid'>".$row['t_stamp_f']."</a>";
	$extra .= "<br>\n"; 
}
$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";


if (phpAds_isUser(phpAds_Admin))
{
	$extra .= "<br><br><br><br><br>";
	$extra .= "<b>$strShortcuts</b><br>";
	$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";
	$extra .= "<img src='images/icon-client.gif' align='absmiddle'>&nbsp;<a href=client-edit.php?clientid=".phpAds_getParentID ($campaignid).">$strModifyClient</a><br>";
	$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";
	$extra .= "<img src='images/icon-edit.gif' align='absmiddle'>&nbsp;<a href=campaign-edit.php?campaignid=$campaignid>$strModifyCampaign</a><br>";
	$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";
	$extra .= "<img src='images/icon-campaign.gif' align='absmiddle'>&nbsp;<a href=campaign-index.php?campaignid=$campaignid>$strBanners</a><br>";
	$extra .= "<img src='images/break-el.gif' height='1' width='160' vspace='4'><br>";
	$extra .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src='images/icon-banner-stored.gif' align='absmiddle'>&nbsp;<a href=banner-edit.php?campaignid=$campaignid&bannerid=$bannerid>$strModifyBanner</a><br>";
		
	if ($phpAds_acl == '1')
	{
		$extra .= "<img src='images/break-el.gif' height='1' width='160' vspace='4'><br>";
		$extra .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src='images/icon-acl.gif' align='absmiddle'>&nbsp;<a href=banner-acl.php?campaignid=$campaignid&bannerid=$bannerid>$strModifyBannerAcl</a><br>";
	}
	$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";
	
	phpAds_PageHeader("2.1.1.1", $extra);
}

if (phpAds_isUser(phpAds_Client))
{
	phpAds_PageHeader("1.1.1.1", $extra);
}



/*********************************************************/
/* Show hourly statistics                                */
/*********************************************************/

function showHourlyStats($what)
{
	global $phpAds_db, $phpAds_url_prefix;
	$result = db_query("
		SELECT
			DATE_FORMAT(t_stamp, 'HH24') as hour,
			count(*) as qnt
		FROM
			$what
		WHERE
			bannerid = $GLOBALS[bannerid]
			AND DATE_FORMAT(t_stamp, '".$GLOBALS['date_format']."') = '".$GLOBALS['day']."'
		GROUP BY 
			hour
		ORDER BY hour DESC
		") or pg_die();
	$max = 0;
	$total = 0;	
	for ($pgc = 0; $row = @pg_fetch_array($result, $pgc); $pgc++)
	{
		if ($row["qnt"] > $max)
			$max = $row["qnt"];
		$total += $row["qnt"];
	}

	
	for ($i = 0; $row = @pg_fetch_array($result, $i); $i++)
	{
		$bgcolor="#FFFFFF";
		$i % 2 ? 0: $bgcolor= "#F6F6F6";
		?>
		<tr>
			<td height='25' bgcolor="<?print $bgcolor;?>">
				&nbsp;<?php print $row["hour"];?>:00
			</td>
			<td height='25' bgcolor="<?print $bgcolor;?>" align='right'>
			    <b><?print $row["qnt"];?></b>&nbsp;&nbsp;&nbsp;
			</td>
			<td height='25' bgcolor="<?print $bgcolor;?>" align='left'>
				<img src="images/bar.gif" width="<?print ($row["qnt"]*300)/$max;?>" height="11"><img src="images/bar_off.gif" width="<?print 300-(($row["qnt"]*300)/$max);?>" height="11">
			</td>
		</tr>
		<tr><td height='1' colspan='4' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
		<?php
	}
}



/*********************************************************/
/* Main code                                             */
/*********************************************************/

?>

<table width='100%' border="0" align="center" cellspacing="0" cellpadding="0">
	<tr><td height='25' colspan='4'><img src='images/icon-client.gif' align='absmiddle'>&nbsp;<?php echo phpAds_getParentName($campaignid);?>
									&nbsp;<img src='images/caret-rs.gif'>&nbsp;
									<img src='images/icon-campaign.gif' align='absmiddle'>&nbsp;<?php echo phpAds_getClientName($campaignid);?>
									&nbsp;<img src='images/caret-rs.gif'>&nbsp;
									<img src='images/icon-banner-stored.gif' align='absmiddle'>&nbsp;<b><?php echo phpAds_getBannerName($bannerid);?></b></td></tr>
  <tr><td height='1' colspan='4' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
  <tr><td colspan='4' align='left'><br><?php echo phpAds_getBannerCode($bannerid);?><br><br></td></tr>
</table>

<br><br>

<table width='100%' border="0" align="center" cellspacing="0" cellpadding="0">
  <tr><td height='25' colspan='3'><b><?print $strViews;?></b></td></tr>
  <tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
  <?php showHourlyStats("$phpAds_tbl_adviews");; ?>
</table>

<br><br>

<table width='100%' border="0" align="center" cellspacing="0" cellpadding="0">
  <tr><td height='25' colspan='3'><b><?print $strClicks;?></b></td></tr>
  <tr><td height='1' colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
  <?php showHourlyStats("$phpAds_tbl_adclicks");; ?>
</table>

<br><br>

<?php if (!$phpAds_compact_stats) { ?>
<table width='100%' border="0" align="center" cellspacing="0" cellpadding="0">
  <tr><td height='25' colspan='2'><b><?print $strTopTenHosts;?></b></td></tr>
  <tr><td height='1' colspan='2' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
  <?php
    	$result = db_query("
        		SELECT
					host,
        			count(*) as qnt
        		FROM
        			$phpAds_tbl_adviews
        		WHERE
        			bannerid = $bannerid
        			AND DATE_FORMAT(t_stamp, '$date_format') = '$day'
        		GROUP BY
        			host
        		ORDER BY
        			qnt DESC
        		LIMIT 10
        		") or pg_die();
        
        	
        	for ($i = 0; $row = @pg_fetch_array($result, $i); $i++)
        	{
        		$bgcolor="#FFFFFF";
        		$i % 2 ? 0: $bgcolor= "#F6F6F6";
        		?>
        		<tr>
        			<td height='25' bgcolor="<?print $bgcolor;?>">
        			&nbsp;<?print $row["host"];?>
        			</td>
        			<td height='25' bgcolor="<?print $bgcolor;?>">
        			<b><?print $row["qnt"];?></b>
        			</td>
        		</tr>
				<tr><td height='1' colspan='2' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
        		<?php
        	}
        }
    ?>
</table>



<?php

/*********************************************************/
/* HTML framework                                        */
/*********************************************************/

phpAds_PageFooter();

?>

