/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.ArrayList;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.NativeStruct;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.Portal;

public class ExecutionPlan
extends NativeStruct {
    private static final ArrayList s_deathRow = new ArrayList();
    private boolean m_isDurable;

    private /* synthetic */ void finit$() {
        this.m_isDurable = false;
    }

    public Portal cursorOpen(String string, Object[] objectArray) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                Portal portal = this._cursorOpen(string, objectArray);
                Object var5_5 = null;
                return portal;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    public boolean isCursorPlan() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                boolean bl = this._isCursorPlan();
                Object var3_3 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public int execp(Object[] objectArray, int n) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                int n2 = this._execp(objectArray, n);
                Object var5_5 = null;
                return n2;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    public static ExecutionPlan prepare(String string, Oid[] oidArray) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                ExecutionPlan executionPlan = ExecutionPlan._prepare(string, oidArray);
                Object var4_4 = null;
                return executionPlan;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public void invalidate() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                this._invalidate();
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void makeDurable() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                if (this.m_isDurable) {
                    Object var2_2 = null;
                    return;
                }
                this._savePlan();
                this.m_isDurable = true;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                throw throwable;
            }
            Object var2_3 = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalize() {
        if (!this.m_isDurable || !this.isValid()) return;
        long l = this.getNative();
        if (Backend.isCallingJava()) {
            this.invalidate();
            return;
        }
        ArrayList arrayList = s_deathRow;
        synchronized (arrayList) {
            try {
                s_deathRow.add(new Long(l));
                ExecutionPlan.setDeathRowFlag(true);
                return;
            }
            finally {
                Object var4_3 = null;
            }
        }
    }

    private native void _savePlan() throws SQLException;

    static long[] getDeathRow() {
        ArrayList arrayList = s_deathRow;
        synchronized (arrayList) {
            try {
                int n = s_deathRow.size();
                long[] lArray = new long[n];
                while (--n >= 0) {
                    lArray[n] = (Long)s_deathRow.get(n);
                }
                s_deathRow.clear();
                ExecutionPlan.setDeathRowFlag(false);
                long[] lArray2 = lArray;
                Object var4_4 = null;
                return lArray2;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    private static native void setDeathRowFlag(boolean var0);

    private native Portal _cursorOpen(String var1, Object[] var2) throws SQLException;

    private native boolean _isCursorPlan() throws SQLException;

    private native int _execp(Object[] var1, int var2) throws SQLException;

    private static native ExecutionPlan _prepare(String var0, Oid[] var1) throws SQLException;

    private native void _invalidate();

    public ExecutionPlan() {
        this.finit$();
    }
}

