/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.ArrayList;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.NativeStruct;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.Portal;

public class ExecutionPlan
extends NativeStruct {
    private static final ArrayList s_deathRow = new ArrayList();
    private boolean m_isDurable = false;

    public Portal cursorOpen(String cursorName, Object[] parameters) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._cursorOpen(cursorName, parameters);
        }
    }

    public boolean isCursorPlan() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._isCursorPlan();
        }
    }

    public int execp(Object[] parameters, int rowCount) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._execp(parameters, rowCount);
        }
    }

    public static ExecutionPlan prepare(String statement, Oid[] argTypes) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return ExecutionPlan._prepare(statement, argTypes);
        }
    }

    public void invalidate() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            this._invalidate();
        }
    }

    public void makeDurable() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (this.m_isDurable) {
                return;
            }
            this._savePlan();
            this.m_isDurable = true;
        }
    }

    public void finalize() {
        if (this.m_isDurable && this.isValid()) {
            long nativePtr = this.getNative();
            if (Backend.isCallingJava()) {
                this.invalidate();
            } else {
                ArrayList arrayList = s_deathRow;
                synchronized (arrayList) {
                    s_deathRow.add(new Long(nativePtr));
                    ExecutionPlan.setDeathRowFlag(true);
                }
            }
        }
    }

    private native void _savePlan() throws SQLException;

    static long[] getDeathRow() {
        ArrayList arrayList = s_deathRow;
        synchronized (arrayList) {
            int top = s_deathRow.size();
            long[] dr = new long[top];
            while (--top >= 0) {
                dr[top] = (Long)s_deathRow.get(top);
            }
            s_deathRow.clear();
            ExecutionPlan.setDeathRowFlag(false);
            return dr;
        }
    }

    private static native void setDeathRowFlag(boolean var0);

    private native Portal _cursorOpen(String var1, Object[] var2) throws SQLException;

    private native boolean _isCursorPlan() throws SQLException;

    private native int _execp(Object[] var1, int var2) throws SQLException;

    private static native ExecutionPlan _prepare(String var0, Oid[] var1) throws SQLException;

    private native void _invalidate();
}

