.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER ROLE" "" "2007-02-07" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER ROLE \- change a database role

.SH SYNOPSIS
.sp
.nf
ALTER ROLE \fIname\fR [ [ WITH ] \fIoption\fR [ ... ] ]

where \fIoption\fR can be:
    
      SUPERUSER | NOSUPERUSER
    | CREATEDB | NOCREATEDB
    | CREATEROLE | NOCREATEROLE
    | CREATEUSER | NOCREATEUSER
    | INHERIT | NOINHERIT
    | LOGIN | NOLOGIN
    | CONNECTION LIMIT \fIconnlimit\fR
    | [ ENCRYPTED | UNENCRYPTED ] PASSWORD '\fIpassword\fR'
    | VALID UNTIL '\fItimestamp\fR' 

ALTER ROLE \fIname\fR RENAME TO \fInewname\fR

ALTER ROLE \fIname\fR SET \fIparameter\fR { TO | = } { \fIvalue\fR | DEFAULT }
ALTER ROLE \fIname\fR RESET \fIparameter\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER ROLE\fR changes the attributes of a
PostgreSQL role.
.PP
The first variant of this command listed in the synopsis can change
many of the role attributes that can be specified in 
CREATE ROLE [\fBcreate_role\fR(l)],
which see for details. (All the possible attributes are covered,
except that there are no options for adding or removing memberships; use
GRANT [\fBgrant\fR(l)] and
REVOKE [\fBrevoke\fR(l)] for that.)
Attributes not mentioned in the command retain their previous settings.
Database superusers can change any of these settings for any role.
Roles having CREATEROLE privilege can change any of these
settings, but only for non-superuser roles.
Ordinary roles can only change their own password.
.PP
The second variant changes the name of the role.
Database superusers can rename any role.
Roles having CREATEROLE privilege can rename non-superuser
roles.
The current session user cannot be renamed.
(Connect as a different user if you need to do that.)
Because MD5-encrypted passwords use the role name as
cryptographic salt, renaming a role clears its password if the
password is MD5-encrypted.
.PP
The third and the fourth variant change a role's session default for
a specified configuration variable. Whenever the role subsequently
starts a new session, the specified value becomes the session default,
overriding whatever setting is present in \fIpostgresql.conf\fR
or has been received from the \fBpostmaster\fR command line.
(For a role without LOGIN privilege, session defaults have
no effect.)
Ordinary roles can change their own session defaults.
Superusers can change anyone's session defaults.
Roles having CREATEROLE privilege can change defaults for
non-superuser roles.
Certain variables cannot be set this way, or can only be
set if a superuser issues the command.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the role whose attributes are to be altered.
.TP
\fBSUPERUSER\fR
.TP
\fBNOSUPERUSER\fR
.TP
\fBCREATEDB\fR
.TP
\fBNOCREATEDB\fR
.TP
\fBCREATEROLE\fR
.TP
\fBNOCREATEROLE\fR
.TP
\fBCREATEUSER\fR
.TP
\fBNOCREATEUSER\fR
.TP
\fBINHERIT\fR
.TP
\fBNOINHERIT\fR
.TP
\fBLOGIN\fR
.TP
\fBNOLOGIN\fR
.TP
\fBCONNECTION LIMIT \fIconnlimit\fB\fR
.TP
\fBPASSWORD \fIpassword\fB\fR
.TP
\fBENCRYPTED\fR
.TP
\fBUNENCRYPTED\fR
.TP
\fBVALID UNTIL '\fItimestamp\fB'\fR
These clauses alter attributes originally set by
CREATE ROLE [\fBcreate_role\fR(l)],
which see for more information.
.TP
\fB\fInewname\fB\fR
The new name of the role.
.TP
\fB\fIparameter\fB\fR
.TP
\fB\fIvalue\fB\fR
Set this role's session default for the specified configuration
parameter to the given value. If
\fIvalue\fR is DEFAULT
or, equivalently, RESET is used, the
role-specific variable setting is removed, so the role will
inherit the system-wide default setting in new sessions. Use
RESET ALL to clear all role-specific settings.

See SET [\fBset\fR(l)] and the documentation for more information about allowed
parameter names and values.
.SH "NOTES"
.PP
Use CREATE ROLE [\fBcreate_role\fR(l)]
to add new roles, and DROP ROLE [\fBdrop_role\fR(l)] to remove a role.
.PP
\fBALTER ROLE\fR cannot change a role's memberships.
Use GRANT [\fBgrant\fR(l)] and
REVOKE [\fBrevoke\fR(l)]
to do that.
.PP
It is also possible to tie a
session default to a specific database rather than to a role; see
ALTER DATABASE [\fBalter_database\fR(l)].
Role-specific settings override database-specific
ones if there is a conflict.
.SH "EXAMPLES"
.PP
Change a role's password:
.sp
.nf
ALTER ROLE davide WITH PASSWORD 'hu8jmn3';
.sp
.fi
.PP
Change a password expiration date, specifying that the password
should expire at midday on 4th May 2015 using
the time zone which is one hour ahead of UTC:
.sp
.nf
ALTER ROLE chris VALID UNTIL 'May 4 12:00:00 2015 +1';
.sp
.fi
.PP
Make a password valid forever:
.sp
.nf
ALTER ROLE fred VALID UNTIL 'infinity';
.sp
.fi
.PP
Give a role the ability to create other roles and new databases:
.sp
.nf
ALTER ROLE miriam CREATEROLE CREATEDB;
.sp
.fi
.PP
Give a role a non-default setting of the
maintenance_work_mem parameter:
.sp
.nf
ALTER ROLE worker_bee SET maintenance_work_mem = 100000;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBALTER ROLE\fR statement is a
PostgreSQL extension.
.SH "SEE ALSO"
CREATE ROLE [\fBcreate_role\fR(l)], DROP ROLE [\fBdrop_role\fR(l)], SET [\fBset\fR(l)]
