/*--------------------------------------------------------------------
 * FILE:
 *     admin_set_cluster_status.c
 *
 * NOTE:
 *     This file is composed of the admin process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int PGC_Admin_Set_Cluster_Status(Probe_Header * header, char * packet);
int PGC_Sync_Status_Cluster(Cluster_Info * cluster);

static int set_replicate_status(ReplicateServerInfo * replicate);

int
PGC_Admin_Set_Cluster_Status(Probe_Header * header, char * packet)
{
	char * func = "PGC_Admin_Set_Cluster_Status()";
	int count = 0;
	int status = STATUS_ERROR;
	ReplicateServerInfo replicate;
	char * p = NULL;
	int size = 0;
	Cluster_Info cluster_key;
	Cluster_Info * cluster = NULL;

	if ((header == NULL ) || (packet == NULL))
	{
		show_error("%s: table is not allocated",func);
		return STATUS_ERROR;
	}
	if (ntohl(header->body_length) < sizeof(Cluster_Info))
	{
		show_error("%s: there is no packet data ",func);
		return STATUS_ERROR;
	}
	/* set status of cluster db */
	PGC_Set_Packet_2_Cluster_Info(&cluster_key, (Cluster_Info *)packet);
	cluster = PGC_Get_ClusterDbTbl_Rec(&cluster_key);
	if (cluster != NULL)
	{
		cluster->receiveStatus |= cluster_key.status;
		status = STATUS_OK;
	}

	size = sizeof(ReplicateServerInfo);
	p = packet + sizeof(Cluster_Info);
	/* set status of replication server in cluster */
	count = 0;
	while (count < ntohl(header->rec_num))
	{
		memset(&replicate, 0, size);
		PGC_Set_Packet_2_ReplicateServerInfo(&replicate, (ReplicateServerInfo*)p); 
		status = set_replicate_status(&replicate);
		count ++;
		p += sizeof(ReplicateServerInfo);
	}
	return status;
}

int
PGC_Sync_Status_Cluster(Cluster_Info * cluster)
{
	char * func ="PGC_Sync_Status_Cluster()";
	Probe_Header r_header;
	Probe_Header h_data;
	Cluster_Info body;
	int status = STATUS_OK;
	SSL_Info ssl_tbl;
	SSL_Server_Info * probe = ProbeTbl;

	if (probe == NULL)
	{
		show_error("%s:ProbeTbl is NULL",func);
		return STATUS_ERROR;
	}

	if (cluster == NULL)
	{
		show_error("%s: cluster info is null",func);
		return STATUS_ERROR;
	}
	memset(&h_data, 0, sizeof(Probe_Header));
	memset(&r_header, 0, sizeof(Probe_Header));
	memset(&body, 0, sizeof(Cluster_Info));
	memset(&ssl_tbl, 0, sizeof(SSL_Info));

	h_data.packet_no = SET_STS_REQ_PKT;
	h_data.serverType = SERVER_TYPE_CLUSTER;
	h_data.body_length = sizeof(Cluster_Info);
	h_data.rec_num = 1;
	PGC_Set_Cluster_Info_2_packet(&body, cluster);
	while (probe->status != DATA_END)
	{
		PGC_Set_Packet_Header(&r_header, &h_data);
		status = PGC_Admin_Send_Packet(&ssl_tbl, &r_header,(char *)&body, probe->physicalServerId);
		if (status == STATUS_OK)
		{
			PGC_Response_Receive(&ssl_tbl, &r_header);
			PGC_Close_SSL(&ssl_tbl);
		}
		probe ++;
	}
	PGC_Close_SSL(&ssl_tbl);
	return status;
}

static int
set_replicate_status(ReplicateServerInfo * replicate)
{
	/* char * func="set_replicate_status()";*/
	Pgrp_Info * ptr = NULL;
	if (PgrpTbl == NULL)
	{
		show_error("PgrpTbl is null");
		return STATUS_ERROR;
	}
	ptr = PgrpTbl;
	while (ptr->replicationPortNumber != 0)
	{
		if ((!strncmp(ptr->hostName, replicate->hostName, sizeof(ptr->hostName))) &&
			(ptr->replicationPortNumber == replicate->portNumber))
		{
			/* find cluster data */
			ptr->receiveStatus |= replicate->useFlag;
			break;
		}
		ptr ++;
	}
	return STATUS_OK;
}
