/*--------------------------------------------------------------------
 * FILE:
 *     probe_set_pgrp_status.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/shm.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int PGC_Set_Pgrp_Status(Probe_Header * header, char * packet);
Pgrp_Info * PGC_Get_PgrpTbl_Rec(Pgrp_Info * key);

static int set_pgrp_status_in_cluster(Pgrp_Info * pgrp);
static int sync_pgrp_status_in_cluster(ReplicateServerInfo * replicate, Pgrp_Info * pgrp);

int
PGC_Set_Pgrp_Status(Probe_Header * header, char * packet)
{
	char * func = "PGC_Set_Pgrp_Status()";
	Pgrp_Info src;
	int status;

	memset(&src, 0, sizeof(Pgrp_Info));
	if (PGC_Set_Packet_2_Pgrp_Info(&src, (Pgrp_Info *)packet) == NULL)
	{
		show_error("%s:PGC_Set_Packet_2_Pgrp_Info failed",func);
		return STATUS_ERROR;
	}
	
	status = set_pgrp_status_in_cluster(&src);

	return status;
}

Pgrp_Info *
PGC_Get_PgrpTbl_Rec(Pgrp_Info * key)
{
	char * func ="PGC_Get_PgrpTbl_Rec()";
	Pgrp_Info * pgrp = NULL;
	if (PgrpTbl == NULL)
	{
		return NULL;
	}
	pgrp = PgrpTbl;
	while (pgrp->replicationPortNumber != 0)
	{
		show_debug("%s:host[%s]-[%s]",func,pgrp->hostName,key->hostName);
		if (pgrp->serverNo == ntohs(key->serverNo))
		{
			return pgrp;
		}
		pgrp ++;
	}
	return NULL;
}

static int
set_pgrp_status_in_cluster(Pgrp_Info * pgrp)
{
	Cluster_Info * cluster = NULL;
	ReplicateServerInfo * replicate = NULL;

	if (ClusterDbTbl == NULL)
	{
		/* there is no cluster db in this physical server */
		return STATUS_OK;
	}
	cluster = ClusterDbTbl;
	while(cluster->portNumber != 0)
	{
		replicate = PGC_Get_Cluster_Shm(cluster->workPath);
		if (replicate != NULL)
		{
			sync_pgrp_status_in_cluster(replicate, pgrp);
			shmdt(replicate);
		}
		else
		{
			cluster->status = DATA_ERR;
			PGC_Send_Cluster_Status(cluster, NULL);
		}
		replicate = NULL;
		cluster ++;
	}
	return STATUS_OK;
}

static int
sync_pgrp_status_in_cluster(ReplicateServerInfo * replicate, Pgrp_Info * pgrp)
{
	int status = STATUS_ERROR;

	while (replicate->portNumber != 0)
	{
		 if ((!strncmp(replicate->hostName,pgrp->hostName,sizeof(replicate->hostName))) &&
		 	(replicate->portNumber == pgrp->replicationPortNumber))
		{
			replicate->useFlag = pgrp->status;
			status = STATUS_OK;
			break;
		}
		replicate ++;
	}
	return status;
}
