/*-------------------------------------------------------------------------
 *
 * unicode_case_table.h
 *	  Case mapping and information table.
 *
 * Portions Copyright (c) 1996-2025, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/common/unicode_case_table.h
 *
 *-------------------------------------------------------------------------
 */

/*
 * File auto-generated by src/common/unicode/generate-unicode_case_table.pl,
 * do not edit. There is deliberately not an #ifndef PG_UNICODE_CASE_TABLE_H
 * here.
 */

#include "common/unicode_case.h"
#include "mb/pg_wchar.h"

/*
 * The maximum number of codepoints that can result from case mapping
 * of a single character. See Unicode section 5.18 "Case Mappings".
 */
#define MAX_CASE_EXPANSION 3

/*
 * Case mapping condition flags. For now, only Final_Sigma is supported.
 *
 * See Unicode Context Specification for Casing.
 */
#define PG_U_FINAL_SIGMA		(1 << 0)

typedef enum
{
	CaseLower = 0,
	CaseTitle = 1,
	CaseUpper = 2,
	CaseFold = 3,
	NCaseKind
} CaseKind;

typedef struct
{
	pg_wchar	codepoint;		/* Unicode codepoint */
	int16		conditions;
	pg_wchar	map[NCaseKind][MAX_CASE_EXPANSION];
} pg_special_case;

typedef struct
{
	pg_wchar	codepoint;		/* Unicode codepoint */
	pg_wchar	simplemap[NCaseKind];
	const pg_special_case *special_case;
} pg_case_map;

/*
 * Special case mappings that aren't representable in the simple map.
 * Entries are referenced from simple_case_map.
 */
static const pg_special_case special_case[106] =
{
	{0x0000df, 0, {{0x0000df, 0x000000, 0x000000}, {0x000053, 0x000073, 0x000000}, {0x000053, 0x000053, 0x000000}, {0x000073, 0x000073, 0x000000}}},
	{0x000130, 0, {{0x000069, 0x000307, 0x000000}, {0x000130, 0x000000, 0x000000}, {0x000130, 0x000000, 0x000000}, {0x000069, 0x000307, 0x000000}}},
	{0x000149, 0, {{0x000149, 0x000000, 0x000000}, {0x0002bc, 0x00004e, 0x000000}, {0x0002bc, 0x00004e, 0x000000}, {0x0002bc, 0x00006e, 0x000000}}},
	{0x0001f0, 0, {{0x0001f0, 0x000000, 0x000000}, {0x00004a, 0x00030c, 0x000000}, {0x00004a, 0x00030c, 0x000000}, {0x00006a, 0x00030c, 0x000000}}},
	{0x000390, 0, {{0x000390, 0x000000, 0x000000}, {0x000399, 0x000308, 0x000301}, {0x000399, 0x000308, 0x000301}, {0x0003b9, 0x000308, 0x000301}}},
	{0x0003a3, PG_U_FINAL_SIGMA, {{0x0003c2, 0x000000, 0x000000}, {0x0003a3, 0x000000, 0x000000}, {0x0003a3, 0x000000, 0x000000}, {0x0003c3, 0x000000, 0x000000}}},
	{0x0003b0, 0, {{0x0003b0, 0x000000, 0x000000}, {0x0003a5, 0x000308, 0x000301}, {0x0003a5, 0x000308, 0x000301}, {0x0003c5, 0x000308, 0x000301}}},
	{0x000587, 0, {{0x000587, 0x000000, 0x000000}, {0x000535, 0x000582, 0x000000}, {0x000535, 0x000552, 0x000000}, {0x000565, 0x000582, 0x000000}}},
	{0x001e96, 0, {{0x001e96, 0x000000, 0x000000}, {0x000048, 0x000331, 0x000000}, {0x000048, 0x000331, 0x000000}, {0x000068, 0x000331, 0x000000}}},
	{0x001e97, 0, {{0x001e97, 0x000000, 0x000000}, {0x000054, 0x000308, 0x000000}, {0x000054, 0x000308, 0x000000}, {0x000074, 0x000308, 0x000000}}},
	{0x001e98, 0, {{0x001e98, 0x000000, 0x000000}, {0x000057, 0x00030a, 0x000000}, {0x000057, 0x00030a, 0x000000}, {0x000077, 0x00030a, 0x000000}}},
	{0x001e99, 0, {{0x001e99, 0x000000, 0x000000}, {0x000059, 0x00030a, 0x000000}, {0x000059, 0x00030a, 0x000000}, {0x000079, 0x00030a, 0x000000}}},
	{0x001e9a, 0, {{0x001e9a, 0x000000, 0x000000}, {0x000041, 0x0002be, 0x000000}, {0x000041, 0x0002be, 0x000000}, {0x000061, 0x0002be, 0x000000}}},
	{0x001e9e, 0, {{0x0000df, 0x000000, 0x000000}, {0x001e9e, 0x000000, 0x000000}, {0x001e9e, 0x000000, 0x000000}, {0x000073, 0x000073, 0x000000}}},
	{0x001f50, 0, {{0x001f50, 0x000000, 0x000000}, {0x0003a5, 0x000313, 0x000000}, {0x0003a5, 0x000313, 0x000000}, {0x0003c5, 0x000313, 0x000000}}},
	{0x001f52, 0, {{0x001f52, 0x000000, 0x000000}, {0x0003a5, 0x000313, 0x000300}, {0x0003a5, 0x000313, 0x000300}, {0x0003c5, 0x000313, 0x000300}}},
	{0x001f54, 0, {{0x001f54, 0x000000, 0x000000}, {0x0003a5, 0x000313, 0x000301}, {0x0003a5, 0x000313, 0x000301}, {0x0003c5, 0x000313, 0x000301}}},
	{0x001f56, 0, {{0x001f56, 0x000000, 0x000000}, {0x0003a5, 0x000313, 0x000342}, {0x0003a5, 0x000313, 0x000342}, {0x0003c5, 0x000313, 0x000342}}},
	{0x001f80, 0, {{0x001f80, 0x000000, 0x000000}, {0x001f88, 0x000000, 0x000000}, {0x001f08, 0x000399, 0x000000}, {0x001f00, 0x0003b9, 0x000000}}},
	{0x001f81, 0, {{0x001f81, 0x000000, 0x000000}, {0x001f89, 0x000000, 0x000000}, {0x001f09, 0x000399, 0x000000}, {0x001f01, 0x0003b9, 0x000000}}},
	{0x001f82, 0, {{0x001f82, 0x000000, 0x000000}, {0x001f8a, 0x000000, 0x000000}, {0x001f0a, 0x000399, 0x000000}, {0x001f02, 0x0003b9, 0x000000}}},
	{0x001f83, 0, {{0x001f83, 0x000000, 0x000000}, {0x001f8b, 0x000000, 0x000000}, {0x001f0b, 0x000399, 0x000000}, {0x001f03, 0x0003b9, 0x000000}}},
	{0x001f84, 0, {{0x001f84, 0x000000, 0x000000}, {0x001f8c, 0x000000, 0x000000}, {0x001f0c, 0x000399, 0x000000}, {0x001f04, 0x0003b9, 0x000000}}},
	{0x001f85, 0, {{0x001f85, 0x000000, 0x000000}, {0x001f8d, 0x000000, 0x000000}, {0x001f0d, 0x000399, 0x000000}, {0x001f05, 0x0003b9, 0x000000}}},
	{0x001f86, 0, {{0x001f86, 0x000000, 0x000000}, {0x001f8e, 0x000000, 0x000000}, {0x001f0e, 0x000399, 0x000000}, {0x001f06, 0x0003b9, 0x000000}}},
	{0x001f87, 0, {{0x001f87, 0x000000, 0x000000}, {0x001f8f, 0x000000, 0x000000}, {0x001f0f, 0x000399, 0x000000}, {0x001f07, 0x0003b9, 0x000000}}},
	{0x001f88, 0, {{0x001f80, 0x000000, 0x000000}, {0x001f88, 0x000000, 0x000000}, {0x001f08, 0x000399, 0x000000}, {0x001f00, 0x0003b9, 0x000000}}},
	{0x001f89, 0, {{0x001f81, 0x000000, 0x000000}, {0x001f89, 0x000000, 0x000000}, {0x001f09, 0x000399, 0x000000}, {0x001f01, 0x0003b9, 0x000000}}},
	{0x001f8a, 0, {{0x001f82, 0x000000, 0x000000}, {0x001f8a, 0x000000, 0x000000}, {0x001f0a, 0x000399, 0x000000}, {0x001f02, 0x0003b9, 0x000000}}},
	{0x001f8b, 0, {{0x001f83, 0x000000, 0x000000}, {0x001f8b, 0x000000, 0x000000}, {0x001f0b, 0x000399, 0x000000}, {0x001f03, 0x0003b9, 0x000000}}},
	{0x001f8c, 0, {{0x001f84, 0x000000, 0x000000}, {0x001f8c, 0x000000, 0x000000}, {0x001f0c, 0x000399, 0x000000}, {0x001f04, 0x0003b9, 0x000000}}},
	{0x001f8d, 0, {{0x001f85, 0x000000, 0x000000}, {0x001f8d, 0x000000, 0x000000}, {0x001f0d, 0x000399, 0x000000}, {0x001f05, 0x0003b9, 0x000000}}},
	{0x001f8e, 0, {{0x001f86, 0x000000, 0x000000}, {0x001f8e, 0x000000, 0x000000}, {0x001f0e, 0x000399, 0x000000}, {0x001f06, 0x0003b9, 0x000000}}},
	{0x001f8f, 0, {{0x001f87, 0x000000, 0x000000}, {0x001f8f, 0x000000, 0x000000}, {0x001f0f, 0x000399, 0x000000}, {0x001f07, 0x0003b9, 0x000000}}},
	{0x001f90, 0, {{0x001f90, 0x000000, 0x000000}, {0x001f98, 0x000000, 0x000000}, {0x001f28, 0x000399, 0x000000}, {0x001f20, 0x0003b9, 0x000000}}},
	{0x001f91, 0, {{0x001f91, 0x000000, 0x000000}, {0x001f99, 0x000000, 0x000000}, {0x001f29, 0x000399, 0x000000}, {0x001f21, 0x0003b9, 0x000000}}},
	{0x001f92, 0, {{0x001f92, 0x000000, 0x000000}, {0x001f9a, 0x000000, 0x000000}, {0x001f2a, 0x000399, 0x000000}, {0x001f22, 0x0003b9, 0x000000}}},
	{0x001f93, 0, {{0x001f93, 0x000000, 0x000000}, {0x001f9b, 0x000000, 0x000000}, {0x001f2b, 0x000399, 0x000000}, {0x001f23, 0x0003b9, 0x000000}}},
	{0x001f94, 0, {{0x001f94, 0x000000, 0x000000}, {0x001f9c, 0x000000, 0x000000}, {0x001f2c, 0x000399, 0x000000}, {0x001f24, 0x0003b9, 0x000000}}},
	{0x001f95, 0, {{0x001f95, 0x000000, 0x000000}, {0x001f9d, 0x000000, 0x000000}, {0x001f2d, 0x000399, 0x000000}, {0x001f25, 0x0003b9, 0x000000}}},
	{0x001f96, 0, {{0x001f96, 0x000000, 0x000000}, {0x001f9e, 0x000000, 0x000000}, {0x001f2e, 0x000399, 0x000000}, {0x001f26, 0x0003b9, 0x000000}}},
	{0x001f97, 0, {{0x001f97, 0x000000, 0x000000}, {0x001f9f, 0x000000, 0x000000}, {0x001f2f, 0x000399, 0x000000}, {0x001f27, 0x0003b9, 0x000000}}},
	{0x001f98, 0, {{0x001f90, 0x000000, 0x000000}, {0x001f98, 0x000000, 0x000000}, {0x001f28, 0x000399, 0x000000}, {0x001f20, 0x0003b9, 0x000000}}},
	{0x001f99, 0, {{0x001f91, 0x000000, 0x000000}, {0x001f99, 0x000000, 0x000000}, {0x001f29, 0x000399, 0x000000}, {0x001f21, 0x0003b9, 0x000000}}},
	{0x001f9a, 0, {{0x001f92, 0x000000, 0x000000}, {0x001f9a, 0x000000, 0x000000}, {0x001f2a, 0x000399, 0x000000}, {0x001f22, 0x0003b9, 0x000000}}},
	{0x001f9b, 0, {{0x001f93, 0x000000, 0x000000}, {0x001f9b, 0x000000, 0x000000}, {0x001f2b, 0x000399, 0x000000}, {0x001f23, 0x0003b9, 0x000000}}},
	{0x001f9c, 0, {{0x001f94, 0x000000, 0x000000}, {0x001f9c, 0x000000, 0x000000}, {0x001f2c, 0x000399, 0x000000}, {0x001f24, 0x0003b9, 0x000000}}},
	{0x001f9d, 0, {{0x001f95, 0x000000, 0x000000}, {0x001f9d, 0x000000, 0x000000}, {0x001f2d, 0x000399, 0x000000}, {0x001f25, 0x0003b9, 0x000000}}},
	{0x001f9e, 0, {{0x001f96, 0x000000, 0x000000}, {0x001f9e, 0x000000, 0x000000}, {0x001f2e, 0x000399, 0x000000}, {0x001f26, 0x0003b9, 0x000000}}},
	{0x001f9f, 0, {{0x001f97, 0x000000, 0x000000}, {0x001f9f, 0x000000, 0x000000}, {0x001f2f, 0x000399, 0x000000}, {0x001f27, 0x0003b9, 0x000000}}},
	{0x001fa0, 0, {{0x001fa0, 0x000000, 0x000000}, {0x001fa8, 0x000000, 0x000000}, {0x001f68, 0x000399, 0x000000}, {0x001f60, 0x0003b9, 0x000000}}},
	{0x001fa1, 0, {{0x001fa1, 0x000000, 0x000000}, {0x001fa9, 0x000000, 0x000000}, {0x001f69, 0x000399, 0x000000}, {0x001f61, 0x0003b9, 0x000000}}},
	{0x001fa2, 0, {{0x001fa2, 0x000000, 0x000000}, {0x001faa, 0x000000, 0x000000}, {0x001f6a, 0x000399, 0x000000}, {0x001f62, 0x0003b9, 0x000000}}},
	{0x001fa3, 0, {{0x001fa3, 0x000000, 0x000000}, {0x001fab, 0x000000, 0x000000}, {0x001f6b, 0x000399, 0x000000}, {0x001f63, 0x0003b9, 0x000000}}},
	{0x001fa4, 0, {{0x001fa4, 0x000000, 0x000000}, {0x001fac, 0x000000, 0x000000}, {0x001f6c, 0x000399, 0x000000}, {0x001f64, 0x0003b9, 0x000000}}},
	{0x001fa5, 0, {{0x001fa5, 0x000000, 0x000000}, {0x001fad, 0x000000, 0x000000}, {0x001f6d, 0x000399, 0x000000}, {0x001f65, 0x0003b9, 0x000000}}},
	{0x001fa6, 0, {{0x001fa6, 0x000000, 0x000000}, {0x001fae, 0x000000, 0x000000}, {0x001f6e, 0x000399, 0x000000}, {0x001f66, 0x0003b9, 0x000000}}},
	{0x001fa7, 0, {{0x001fa7, 0x000000, 0x000000}, {0x001faf, 0x000000, 0x000000}, {0x001f6f, 0x000399, 0x000000}, {0x001f67, 0x0003b9, 0x000000}}},
	{0x001fa8, 0, {{0x001fa0, 0x000000, 0x000000}, {0x001fa8, 0x000000, 0x000000}, {0x001f68, 0x000399, 0x000000}, {0x001f60, 0x0003b9, 0x000000}}},
	{0x001fa9, 0, {{0x001fa1, 0x000000, 0x000000}, {0x001fa9, 0x000000, 0x000000}, {0x001f69, 0x000399, 0x000000}, {0x001f61, 0x0003b9, 0x000000}}},
	{0x001faa, 0, {{0x001fa2, 0x000000, 0x000000}, {0x001faa, 0x000000, 0x000000}, {0x001f6a, 0x000399, 0x000000}, {0x001f62, 0x0003b9, 0x000000}}},
	{0x001fab, 0, {{0x001fa3, 0x000000, 0x000000}, {0x001fab, 0x000000, 0x000000}, {0x001f6b, 0x000399, 0x000000}, {0x001f63, 0x0003b9, 0x000000}}},
	{0x001fac, 0, {{0x001fa4, 0x000000, 0x000000}, {0x001fac, 0x000000, 0x000000}, {0x001f6c, 0x000399, 0x000000}, {0x001f64, 0x0003b9, 0x000000}}},
	{0x001fad, 0, {{0x001fa5, 0x000000, 0x000000}, {0x001fad, 0x000000, 0x000000}, {0x001f6d, 0x000399, 0x000000}, {0x001f65, 0x0003b9, 0x000000}}},
	{0x001fae, 0, {{0x001fa6, 0x000000, 0x000000}, {0x001fae, 0x000000, 0x000000}, {0x001f6e, 0x000399, 0x000000}, {0x001f66, 0x0003b9, 0x000000}}},
	{0x001faf, 0, {{0x001fa7, 0x000000, 0x000000}, {0x001faf, 0x000000, 0x000000}, {0x001f6f, 0x000399, 0x000000}, {0x001f67, 0x0003b9, 0x000000}}},
	{0x001fb2, 0, {{0x001fb2, 0x000000, 0x000000}, {0x001fba, 0x000345, 0x000000}, {0x001fba, 0x000399, 0x000000}, {0x001f70, 0x0003b9, 0x000000}}},
	{0x001fb3, 0, {{0x001fb3, 0x000000, 0x000000}, {0x001fbc, 0x000000, 0x000000}, {0x000391, 0x000399, 0x000000}, {0x0003b1, 0x0003b9, 0x000000}}},
	{0x001fb4, 0, {{0x001fb4, 0x000000, 0x000000}, {0x000386, 0x000345, 0x000000}, {0x000386, 0x000399, 0x000000}, {0x0003ac, 0x0003b9, 0x000000}}},
	{0x001fb6, 0, {{0x001fb6, 0x000000, 0x000000}, {0x000391, 0x000342, 0x000000}, {0x000391, 0x000342, 0x000000}, {0x0003b1, 0x000342, 0x000000}}},
	{0x001fb7, 0, {{0x001fb7, 0x000000, 0x000000}, {0x000391, 0x000342, 0x000345}, {0x000391, 0x000342, 0x000399}, {0x0003b1, 0x000342, 0x0003b9}}},
	{0x001fbc, 0, {{0x001fb3, 0x000000, 0x000000}, {0x001fbc, 0x000000, 0x000000}, {0x000391, 0x000399, 0x000000}, {0x0003b1, 0x0003b9, 0x000000}}},
	{0x001fc2, 0, {{0x001fc2, 0x000000, 0x000000}, {0x001fca, 0x000345, 0x000000}, {0x001fca, 0x000399, 0x000000}, {0x001f74, 0x0003b9, 0x000000}}},
	{0x001fc3, 0, {{0x001fc3, 0x000000, 0x000000}, {0x001fcc, 0x000000, 0x000000}, {0x000397, 0x000399, 0x000000}, {0x0003b7, 0x0003b9, 0x000000}}},
	{0x001fc4, 0, {{0x001fc4, 0x000000, 0x000000}, {0x000389, 0x000345, 0x000000}, {0x000389, 0x000399, 0x000000}, {0x0003ae, 0x0003b9, 0x000000}}},
	{0x001fc6, 0, {{0x001fc6, 0x000000, 0x000000}, {0x000397, 0x000342, 0x000000}, {0x000397, 0x000342, 0x000000}, {0x0003b7, 0x000342, 0x000000}}},
	{0x001fc7, 0, {{0x001fc7, 0x000000, 0x000000}, {0x000397, 0x000342, 0x000345}, {0x000397, 0x000342, 0x000399}, {0x0003b7, 0x000342, 0x0003b9}}},
	{0x001fcc, 0, {{0x001fc3, 0x000000, 0x000000}, {0x001fcc, 0x000000, 0x000000}, {0x000397, 0x000399, 0x000000}, {0x0003b7, 0x0003b9, 0x000000}}},
	{0x001fd2, 0, {{0x001fd2, 0x000000, 0x000000}, {0x000399, 0x000308, 0x000300}, {0x000399, 0x000308, 0x000300}, {0x0003b9, 0x000308, 0x000300}}},
	{0x001fd3, 0, {{0x001fd3, 0x000000, 0x000000}, {0x000399, 0x000308, 0x000301}, {0x000399, 0x000308, 0x000301}, {0x0003b9, 0x000308, 0x000301}}},
	{0x001fd6, 0, {{0x001fd6, 0x000000, 0x000000}, {0x000399, 0x000342, 0x000000}, {0x000399, 0x000342, 0x000000}, {0x0003b9, 0x000342, 0x000000}}},
	{0x001fd7, 0, {{0x001fd7, 0x000000, 0x000000}, {0x000399, 0x000308, 0x000342}, {0x000399, 0x000308, 0x000342}, {0x0003b9, 0x000308, 0x000342}}},
	{0x001fe2, 0, {{0x001fe2, 0x000000, 0x000000}, {0x0003a5, 0x000308, 0x000300}, {0x0003a5, 0x000308, 0x000300}, {0x0003c5, 0x000308, 0x000300}}},
	{0x001fe3, 0, {{0x001fe3, 0x000000, 0x000000}, {0x0003a5, 0x000308, 0x000301}, {0x0003a5, 0x000308, 0x000301}, {0x0003c5, 0x000308, 0x000301}}},
	{0x001fe4, 0, {{0x001fe4, 0x000000, 0x000000}, {0x0003a1, 0x000313, 0x000000}, {0x0003a1, 0x000313, 0x000000}, {0x0003c1, 0x000313, 0x000000}}},
	{0x001fe6, 0, {{0x001fe6, 0x000000, 0x000000}, {0x0003a5, 0x000342, 0x000000}, {0x0003a5, 0x000342, 0x000000}, {0x0003c5, 0x000342, 0x000000}}},
	{0x001fe7, 0, {{0x001fe7, 0x000000, 0x000000}, {0x0003a5, 0x000308, 0x000342}, {0x0003a5, 0x000308, 0x000342}, {0x0003c5, 0x000308, 0x000342}}},
	{0x001ff2, 0, {{0x001ff2, 0x000000, 0x000000}, {0x001ffa, 0x000345, 0x000000}, {0x001ffa, 0x000399, 0x000000}, {0x001f7c, 0x0003b9, 0x000000}}},
	{0x001ff3, 0, {{0x001ff3, 0x000000, 0x000000}, {0x001ffc, 0x000000, 0x000000}, {0x0003a9, 0x000399, 0x000000}, {0x0003c9, 0x0003b9, 0x000000}}},
	{0x001ff4, 0, {{0x001ff4, 0x000000, 0x000000}, {0x00038f, 0x000345, 0x000000}, {0x00038f, 0x000399, 0x000000}, {0x0003ce, 0x0003b9, 0x000000}}},
	{0x001ff6, 0, {{0x001ff6, 0x000000, 0x000000}, {0x0003a9, 0x000342, 0x000000}, {0x0003a9, 0x000342, 0x000000}, {0x0003c9, 0x000342, 0x000000}}},
	{0x001ff7, 0, {{0x001ff7, 0x000000, 0x000000}, {0x0003a9, 0x000342, 0x000345}, {0x0003a9, 0x000342, 0x000399}, {0x0003c9, 0x000342, 0x0003b9}}},
	{0x001ffc, 0, {{0x001ff3, 0x000000, 0x000000}, {0x001ffc, 0x000000, 0x000000}, {0x0003a9, 0x000399, 0x000000}, {0x0003c9, 0x0003b9, 0x000000}}},
	{0x00fb00, 0, {{0x00fb00, 0x000000, 0x000000}, {0x000046, 0x000066, 0x000000}, {0x000046, 0x000046, 0x000000}, {0x000066, 0x000066, 0x000000}}},
	{0x00fb01, 0, {{0x00fb01, 0x000000, 0x000000}, {0x000046, 0x000069, 0x000000}, {0x000046, 0x000049, 0x000000}, {0x000066, 0x000069, 0x000000}}},
	{0x00fb02, 0, {{0x00fb02, 0x000000, 0x000000}, {0x000046, 0x00006c, 0x000000}, {0x000046, 0x00004c, 0x000000}, {0x000066, 0x00006c, 0x000000}}},
	{0x00fb03, 0, {{0x00fb03, 0x000000, 0x000000}, {0x000046, 0x000066, 0x000069}, {0x000046, 0x000046, 0x000049}, {0x000066, 0x000066, 0x000069}}},
	{0x00fb04, 0, {{0x00fb04, 0x000000, 0x000000}, {0x000046, 0x000066, 0x00006c}, {0x000046, 0x000046, 0x00004c}, {0x000066, 0x000066, 0x00006c}}},
	{0x00fb05, 0, {{0x00fb05, 0x000000, 0x000000}, {0x000053, 0x000074, 0x000000}, {0x000053, 0x000054, 0x000000}, {0x000073, 0x000074, 0x000000}}},
	{0x00fb06, 0, {{0x00fb06, 0x000000, 0x000000}, {0x000053, 0x000074, 0x000000}, {0x000053, 0x000054, 0x000000}, {0x000073, 0x000074, 0x000000}}},
	{0x00fb13, 0, {{0x00fb13, 0x000000, 0x000000}, {0x000544, 0x000576, 0x000000}, {0x000544, 0x000546, 0x000000}, {0x000574, 0x000576, 0x000000}}},
	{0x00fb14, 0, {{0x00fb14, 0x000000, 0x000000}, {0x000544, 0x000565, 0x000000}, {0x000544, 0x000535, 0x000000}, {0x000574, 0x000565, 0x000000}}},
	{0x00fb15, 0, {{0x00fb15, 0x000000, 0x000000}, {0x000544, 0x00056b, 0x000000}, {0x000544, 0x00053b, 0x000000}, {0x000574, 0x00056b, 0x000000}}},
	{0x00fb16, 0, {{0x00fb16, 0x000000, 0x000000}, {0x00054e, 0x000576, 0x000000}, {0x00054e, 0x000546, 0x000000}, {0x00057e, 0x000576, 0x000000}}},
	{0x00fb17, 0, {{0x00fb17, 0x000000, 0x000000}, {0x000544, 0x00056d, 0x000000}, {0x000544, 0x00053d, 0x000000}, {0x000574, 0x00056d, 0x000000}}},
	{0, 0, {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}}
};

/*
 * Case mapping table. Dense for codepoints < 0x80 (enabling fast lookup),
 * sparse for higher codepoints (requiring scan or binary search).
 */
static const pg_case_map case_map[3003] =
{
	/* begin dense entries for codepoints < 0x80 */
	{0x000000, {[CaseLower] = 0x000000,[CaseTitle] = 0x000000,[CaseUpper] = 0x000000,[CaseFold] = 0x000000}, NULL},
	{0x000001, {[CaseLower] = 0x000001,[CaseTitle] = 0x000001,[CaseUpper] = 0x000001,[CaseFold] = 0x000001}, NULL},
	{0x000002, {[CaseLower] = 0x000002,[CaseTitle] = 0x000002,[CaseUpper] = 0x000002,[CaseFold] = 0x000002}, NULL},
	{0x000003, {[CaseLower] = 0x000003,[CaseTitle] = 0x000003,[CaseUpper] = 0x000003,[CaseFold] = 0x000003}, NULL},
	{0x000004, {[CaseLower] = 0x000004,[CaseTitle] = 0x000004,[CaseUpper] = 0x000004,[CaseFold] = 0x000004}, NULL},
	{0x000005, {[CaseLower] = 0x000005,[CaseTitle] = 0x000005,[CaseUpper] = 0x000005,[CaseFold] = 0x000005}, NULL},
	{0x000006, {[CaseLower] = 0x000006,[CaseTitle] = 0x000006,[CaseUpper] = 0x000006,[CaseFold] = 0x000006}, NULL},
	{0x000007, {[CaseLower] = 0x000007,[CaseTitle] = 0x000007,[CaseUpper] = 0x000007,[CaseFold] = 0x000007}, NULL},
	{0x000008, {[CaseLower] = 0x000008,[CaseTitle] = 0x000008,[CaseUpper] = 0x000008,[CaseFold] = 0x000008}, NULL},
	{0x000009, {[CaseLower] = 0x000009,[CaseTitle] = 0x000009,[CaseUpper] = 0x000009,[CaseFold] = 0x000009}, NULL},
	{0x00000a, {[CaseLower] = 0x00000a,[CaseTitle] = 0x00000a,[CaseUpper] = 0x00000a,[CaseFold] = 0x00000a}, NULL},
	{0x00000b, {[CaseLower] = 0x00000b,[CaseTitle] = 0x00000b,[CaseUpper] = 0x00000b,[CaseFold] = 0x00000b}, NULL},
	{0x00000c, {[CaseLower] = 0x00000c,[CaseTitle] = 0x00000c,[CaseUpper] = 0x00000c,[CaseFold] = 0x00000c}, NULL},
	{0x00000d, {[CaseLower] = 0x00000d,[CaseTitle] = 0x00000d,[CaseUpper] = 0x00000d,[CaseFold] = 0x00000d}, NULL},
	{0x00000e, {[CaseLower] = 0x00000e,[CaseTitle] = 0x00000e,[CaseUpper] = 0x00000e,[CaseFold] = 0x00000e}, NULL},
	{0x00000f, {[CaseLower] = 0x00000f,[CaseTitle] = 0x00000f,[CaseUpper] = 0x00000f,[CaseFold] = 0x00000f}, NULL},
	{0x000010, {[CaseLower] = 0x000010,[CaseTitle] = 0x000010,[CaseUpper] = 0x000010,[CaseFold] = 0x000010}, NULL},
	{0x000011, {[CaseLower] = 0x000011,[CaseTitle] = 0x000011,[CaseUpper] = 0x000011,[CaseFold] = 0x000011}, NULL},
	{0x000012, {[CaseLower] = 0x000012,[CaseTitle] = 0x000012,[CaseUpper] = 0x000012,[CaseFold] = 0x000012}, NULL},
	{0x000013, {[CaseLower] = 0x000013,[CaseTitle] = 0x000013,[CaseUpper] = 0x000013,[CaseFold] = 0x000013}, NULL},
	{0x000014, {[CaseLower] = 0x000014,[CaseTitle] = 0x000014,[CaseUpper] = 0x000014,[CaseFold] = 0x000014}, NULL},
	{0x000015, {[CaseLower] = 0x000015,[CaseTitle] = 0x000015,[CaseUpper] = 0x000015,[CaseFold] = 0x000015}, NULL},
	{0x000016, {[CaseLower] = 0x000016,[CaseTitle] = 0x000016,[CaseUpper] = 0x000016,[CaseFold] = 0x000016}, NULL},
	{0x000017, {[CaseLower] = 0x000017,[CaseTitle] = 0x000017,[CaseUpper] = 0x000017,[CaseFold] = 0x000017}, NULL},
	{0x000018, {[CaseLower] = 0x000018,[CaseTitle] = 0x000018,[CaseUpper] = 0x000018,[CaseFold] = 0x000018}, NULL},
	{0x000019, {[CaseLower] = 0x000019,[CaseTitle] = 0x000019,[CaseUpper] = 0x000019,[CaseFold] = 0x000019}, NULL},
	{0x00001a, {[CaseLower] = 0x00001a,[CaseTitle] = 0x00001a,[CaseUpper] = 0x00001a,[CaseFold] = 0x00001a}, NULL},
	{0x00001b, {[CaseLower] = 0x00001b,[CaseTitle] = 0x00001b,[CaseUpper] = 0x00001b,[CaseFold] = 0x00001b}, NULL},
	{0x00001c, {[CaseLower] = 0x00001c,[CaseTitle] = 0x00001c,[CaseUpper] = 0x00001c,[CaseFold] = 0x00001c}, NULL},
	{0x00001d, {[CaseLower] = 0x00001d,[CaseTitle] = 0x00001d,[CaseUpper] = 0x00001d,[CaseFold] = 0x00001d}, NULL},
	{0x00001e, {[CaseLower] = 0x00001e,[CaseTitle] = 0x00001e,[CaseUpper] = 0x00001e,[CaseFold] = 0x00001e}, NULL},
	{0x00001f, {[CaseLower] = 0x00001f,[CaseTitle] = 0x00001f,[CaseUpper] = 0x00001f,[CaseFold] = 0x00001f}, NULL},
	{0x000020, {[CaseLower] = 0x000020,[CaseTitle] = 0x000020,[CaseUpper] = 0x000020,[CaseFold] = 0x000020}, NULL},
	{0x000021, {[CaseLower] = 0x000021,[CaseTitle] = 0x000021,[CaseUpper] = 0x000021,[CaseFold] = 0x000021}, NULL},
	{0x000022, {[CaseLower] = 0x000022,[CaseTitle] = 0x000022,[CaseUpper] = 0x000022,[CaseFold] = 0x000022}, NULL},
	{0x000023, {[CaseLower] = 0x000023,[CaseTitle] = 0x000023,[CaseUpper] = 0x000023,[CaseFold] = 0x000023}, NULL},
	{0x000024, {[CaseLower] = 0x000024,[CaseTitle] = 0x000024,[CaseUpper] = 0x000024,[CaseFold] = 0x000024}, NULL},
	{0x000025, {[CaseLower] = 0x000025,[CaseTitle] = 0x000025,[CaseUpper] = 0x000025,[CaseFold] = 0x000025}, NULL},
	{0x000026, {[CaseLower] = 0x000026,[CaseTitle] = 0x000026,[CaseUpper] = 0x000026,[CaseFold] = 0x000026}, NULL},
	{0x000027, {[CaseLower] = 0x000027,[CaseTitle] = 0x000027,[CaseUpper] = 0x000027,[CaseFold] = 0x000027}, NULL},
	{0x000028, {[CaseLower] = 0x000028,[CaseTitle] = 0x000028,[CaseUpper] = 0x000028,[CaseFold] = 0x000028}, NULL},
	{0x000029, {[CaseLower] = 0x000029,[CaseTitle] = 0x000029,[CaseUpper] = 0x000029,[CaseFold] = 0x000029}, NULL},
	{0x00002a, {[CaseLower] = 0x00002a,[CaseTitle] = 0x00002a,[CaseUpper] = 0x00002a,[CaseFold] = 0x00002a}, NULL},
	{0x00002b, {[CaseLower] = 0x00002b,[CaseTitle] = 0x00002b,[CaseUpper] = 0x00002b,[CaseFold] = 0x00002b}, NULL},
	{0x00002c, {[CaseLower] = 0x00002c,[CaseTitle] = 0x00002c,[CaseUpper] = 0x00002c,[CaseFold] = 0x00002c}, NULL},
	{0x00002d, {[CaseLower] = 0x00002d,[CaseTitle] = 0x00002d,[CaseUpper] = 0x00002d,[CaseFold] = 0x00002d}, NULL},
	{0x00002e, {[CaseLower] = 0x00002e,[CaseTitle] = 0x00002e,[CaseUpper] = 0x00002e,[CaseFold] = 0x00002e}, NULL},
	{0x00002f, {[CaseLower] = 0x00002f,[CaseTitle] = 0x00002f,[CaseUpper] = 0x00002f,[CaseFold] = 0x00002f}, NULL},
	{0x000030, {[CaseLower] = 0x000030,[CaseTitle] = 0x000030,[CaseUpper] = 0x000030,[CaseFold] = 0x000030}, NULL},
	{0x000031, {[CaseLower] = 0x000031,[CaseTitle] = 0x000031,[CaseUpper] = 0x000031,[CaseFold] = 0x000031}, NULL},
	{0x000032, {[CaseLower] = 0x000032,[CaseTitle] = 0x000032,[CaseUpper] = 0x000032,[CaseFold] = 0x000032}, NULL},
	{0x000033, {[CaseLower] = 0x000033,[CaseTitle] = 0x000033,[CaseUpper] = 0x000033,[CaseFold] = 0x000033}, NULL},
	{0x000034, {[CaseLower] = 0x000034,[CaseTitle] = 0x000034,[CaseUpper] = 0x000034,[CaseFold] = 0x000034}, NULL},
	{0x000035, {[CaseLower] = 0x000035,[CaseTitle] = 0x000035,[CaseUpper] = 0x000035,[CaseFold] = 0x000035}, NULL},
	{0x000036, {[CaseLower] = 0x000036,[CaseTitle] = 0x000036,[CaseUpper] = 0x000036,[CaseFold] = 0x000036}, NULL},
	{0x000037, {[CaseLower] = 0x000037,[CaseTitle] = 0x000037,[CaseUpper] = 0x000037,[CaseFold] = 0x000037}, NULL},
	{0x000038, {[CaseLower] = 0x000038,[CaseTitle] = 0x000038,[CaseUpper] = 0x000038,[CaseFold] = 0x000038}, NULL},
	{0x000039, {[CaseLower] = 0x000039,[CaseTitle] = 0x000039,[CaseUpper] = 0x000039,[CaseFold] = 0x000039}, NULL},
	{0x00003a, {[CaseLower] = 0x00003a,[CaseTitle] = 0x00003a,[CaseUpper] = 0x00003a,[CaseFold] = 0x00003a}, NULL},
	{0x00003b, {[CaseLower] = 0x00003b,[CaseTitle] = 0x00003b,[CaseUpper] = 0x00003b,[CaseFold] = 0x00003b}, NULL},
	{0x00003c, {[CaseLower] = 0x00003c,[CaseTitle] = 0x00003c,[CaseUpper] = 0x00003c,[CaseFold] = 0x00003c}, NULL},
	{0x00003d, {[CaseLower] = 0x00003d,[CaseTitle] = 0x00003d,[CaseUpper] = 0x00003d,[CaseFold] = 0x00003d}, NULL},
	{0x00003e, {[CaseLower] = 0x00003e,[CaseTitle] = 0x00003e,[CaseUpper] = 0x00003e,[CaseFold] = 0x00003e}, NULL},
	{0x00003f, {[CaseLower] = 0x00003f,[CaseTitle] = 0x00003f,[CaseUpper] = 0x00003f,[CaseFold] = 0x00003f}, NULL},
	{0x000040, {[CaseLower] = 0x000040,[CaseTitle] = 0x000040,[CaseUpper] = 0x000040,[CaseFold] = 0x000040}, NULL},
	{0x000041, {[CaseLower] = 0x000061,[CaseTitle] = 0x000041,[CaseUpper] = 0x000041,[CaseFold] = 0x000061}, NULL},
	{0x000042, {[CaseLower] = 0x000062,[CaseTitle] = 0x000042,[CaseUpper] = 0x000042,[CaseFold] = 0x000062}, NULL},
	{0x000043, {[CaseLower] = 0x000063,[CaseTitle] = 0x000043,[CaseUpper] = 0x000043,[CaseFold] = 0x000063}, NULL},
	{0x000044, {[CaseLower] = 0x000064,[CaseTitle] = 0x000044,[CaseUpper] = 0x000044,[CaseFold] = 0x000064}, NULL},
	{0x000045, {[CaseLower] = 0x000065,[CaseTitle] = 0x000045,[CaseUpper] = 0x000045,[CaseFold] = 0x000065}, NULL},
	{0x000046, {[CaseLower] = 0x000066,[CaseTitle] = 0x000046,[CaseUpper] = 0x000046,[CaseFold] = 0x000066}, NULL},
	{0x000047, {[CaseLower] = 0x000067,[CaseTitle] = 0x000047,[CaseUpper] = 0x000047,[CaseFold] = 0x000067}, NULL},
	{0x000048, {[CaseLower] = 0x000068,[CaseTitle] = 0x000048,[CaseUpper] = 0x000048,[CaseFold] = 0x000068}, NULL},
	{0x000049, {[CaseLower] = 0x000069,[CaseTitle] = 0x000049,[CaseUpper] = 0x000049,[CaseFold] = 0x000069}, NULL},
	{0x00004a, {[CaseLower] = 0x00006a,[CaseTitle] = 0x00004a,[CaseUpper] = 0x00004a,[CaseFold] = 0x00006a}, NULL},
	{0x00004b, {[CaseLower] = 0x00006b,[CaseTitle] = 0x00004b,[CaseUpper] = 0x00004b,[CaseFold] = 0x00006b}, NULL},
	{0x00004c, {[CaseLower] = 0x00006c,[CaseTitle] = 0x00004c,[CaseUpper] = 0x00004c,[CaseFold] = 0x00006c}, NULL},
	{0x00004d, {[CaseLower] = 0x00006d,[CaseTitle] = 0x00004d,[CaseUpper] = 0x00004d,[CaseFold] = 0x00006d}, NULL},
	{0x00004e, {[CaseLower] = 0x00006e,[CaseTitle] = 0x00004e,[CaseUpper] = 0x00004e,[CaseFold] = 0x00006e}, NULL},
	{0x00004f, {[CaseLower] = 0x00006f,[CaseTitle] = 0x00004f,[CaseUpper] = 0x00004f,[CaseFold] = 0x00006f}, NULL},
	{0x000050, {[CaseLower] = 0x000070,[CaseTitle] = 0x000050,[CaseUpper] = 0x000050,[CaseFold] = 0x000070}, NULL},
	{0x000051, {[CaseLower] = 0x000071,[CaseTitle] = 0x000051,[CaseUpper] = 0x000051,[CaseFold] = 0x000071}, NULL},
	{0x000052, {[CaseLower] = 0x000072,[CaseTitle] = 0x000052,[CaseUpper] = 0x000052,[CaseFold] = 0x000072}, NULL},
	{0x000053, {[CaseLower] = 0x000073,[CaseTitle] = 0x000053,[CaseUpper] = 0x000053,[CaseFold] = 0x000073}, NULL},
	{0x000054, {[CaseLower] = 0x000074,[CaseTitle] = 0x000054,[CaseUpper] = 0x000054,[CaseFold] = 0x000074}, NULL},
	{0x000055, {[CaseLower] = 0x000075,[CaseTitle] = 0x000055,[CaseUpper] = 0x000055,[CaseFold] = 0x000075}, NULL},
	{0x000056, {[CaseLower] = 0x000076,[CaseTitle] = 0x000056,[CaseUpper] = 0x000056,[CaseFold] = 0x000076}, NULL},
	{0x000057, {[CaseLower] = 0x000077,[CaseTitle] = 0x000057,[CaseUpper] = 0x000057,[CaseFold] = 0x000077}, NULL},
	{0x000058, {[CaseLower] = 0x000078,[CaseTitle] = 0x000058,[CaseUpper] = 0x000058,[CaseFold] = 0x000078}, NULL},
	{0x000059, {[CaseLower] = 0x000079,[CaseTitle] = 0x000059,[CaseUpper] = 0x000059,[CaseFold] = 0x000079}, NULL},
	{0x00005a, {[CaseLower] = 0x00007a,[CaseTitle] = 0x00005a,[CaseUpper] = 0x00005a,[CaseFold] = 0x00007a}, NULL},
	{0x00005b, {[CaseLower] = 0x00005b,[CaseTitle] = 0x00005b,[CaseUpper] = 0x00005b,[CaseFold] = 0x00005b}, NULL},
	{0x00005c, {[CaseLower] = 0x00005c,[CaseTitle] = 0x00005c,[CaseUpper] = 0x00005c,[CaseFold] = 0x00005c}, NULL},
	{0x00005d, {[CaseLower] = 0x00005d,[CaseTitle] = 0x00005d,[CaseUpper] = 0x00005d,[CaseFold] = 0x00005d}, NULL},
	{0x00005e, {[CaseLower] = 0x00005e,[CaseTitle] = 0x00005e,[CaseUpper] = 0x00005e,[CaseFold] = 0x00005e}, NULL},
	{0x00005f, {[CaseLower] = 0x00005f,[CaseTitle] = 0x00005f,[CaseUpper] = 0x00005f,[CaseFold] = 0x00005f}, NULL},
	{0x000060, {[CaseLower] = 0x000060,[CaseTitle] = 0x000060,[CaseUpper] = 0x000060,[CaseFold] = 0x000060}, NULL},
	{0x000061, {[CaseLower] = 0x000061,[CaseTitle] = 0x000041,[CaseUpper] = 0x000041,[CaseFold] = 0x000061}, NULL},
	{0x000062, {[CaseLower] = 0x000062,[CaseTitle] = 0x000042,[CaseUpper] = 0x000042,[CaseFold] = 0x000062}, NULL},
	{0x000063, {[CaseLower] = 0x000063,[CaseTitle] = 0x000043,[CaseUpper] = 0x000043,[CaseFold] = 0x000063}, NULL},
	{0x000064, {[CaseLower] = 0x000064,[CaseTitle] = 0x000044,[CaseUpper] = 0x000044,[CaseFold] = 0x000064}, NULL},
	{0x000065, {[CaseLower] = 0x000065,[CaseTitle] = 0x000045,[CaseUpper] = 0x000045,[CaseFold] = 0x000065}, NULL},
	{0x000066, {[CaseLower] = 0x000066,[CaseTitle] = 0x000046,[CaseUpper] = 0x000046,[CaseFold] = 0x000066}, NULL},
	{0x000067, {[CaseLower] = 0x000067,[CaseTitle] = 0x000047,[CaseUpper] = 0x000047,[CaseFold] = 0x000067}, NULL},
	{0x000068, {[CaseLower] = 0x000068,[CaseTitle] = 0x000048,[CaseUpper] = 0x000048,[CaseFold] = 0x000068}, NULL},
	{0x000069, {[CaseLower] = 0x000069,[CaseTitle] = 0x000049,[CaseUpper] = 0x000049,[CaseFold] = 0x000069}, NULL},
	{0x00006a, {[CaseLower] = 0x00006a,[CaseTitle] = 0x00004a,[CaseUpper] = 0x00004a,[CaseFold] = 0x00006a}, NULL},
	{0x00006b, {[CaseLower] = 0x00006b,[CaseTitle] = 0x00004b,[CaseUpper] = 0x00004b,[CaseFold] = 0x00006b}, NULL},
	{0x00006c, {[CaseLower] = 0x00006c,[CaseTitle] = 0x00004c,[CaseUpper] = 0x00004c,[CaseFold] = 0x00006c}, NULL},
	{0x00006d, {[CaseLower] = 0x00006d,[CaseTitle] = 0x00004d,[CaseUpper] = 0x00004d,[CaseFold] = 0x00006d}, NULL},
	{0x00006e, {[CaseLower] = 0x00006e,[CaseTitle] = 0x00004e,[CaseUpper] = 0x00004e,[CaseFold] = 0x00006e}, NULL},
	{0x00006f, {[CaseLower] = 0x00006f,[CaseTitle] = 0x00004f,[CaseUpper] = 0x00004f,[CaseFold] = 0x00006f}, NULL},
	{0x000070, {[CaseLower] = 0x000070,[CaseTitle] = 0x000050,[CaseUpper] = 0x000050,[CaseFold] = 0x000070}, NULL},
	{0x000071, {[CaseLower] = 0x000071,[CaseTitle] = 0x000051,[CaseUpper] = 0x000051,[CaseFold] = 0x000071}, NULL},
	{0x000072, {[CaseLower] = 0x000072,[CaseTitle] = 0x000052,[CaseUpper] = 0x000052,[CaseFold] = 0x000072}, NULL},
	{0x000073, {[CaseLower] = 0x000073,[CaseTitle] = 0x000053,[CaseUpper] = 0x000053,[CaseFold] = 0x000073}, NULL},
	{0x000074, {[CaseLower] = 0x000074,[CaseTitle] = 0x000054,[CaseUpper] = 0x000054,[CaseFold] = 0x000074}, NULL},
	{0x000075, {[CaseLower] = 0x000075,[CaseTitle] = 0x000055,[CaseUpper] = 0x000055,[CaseFold] = 0x000075}, NULL},
	{0x000076, {[CaseLower] = 0x000076,[CaseTitle] = 0x000056,[CaseUpper] = 0x000056,[CaseFold] = 0x000076}, NULL},
	{0x000077, {[CaseLower] = 0x000077,[CaseTitle] = 0x000057,[CaseUpper] = 0x000057,[CaseFold] = 0x000077}, NULL},
	{0x000078, {[CaseLower] = 0x000078,[CaseTitle] = 0x000058,[CaseUpper] = 0x000058,[CaseFold] = 0x000078}, NULL},
	{0x000079, {[CaseLower] = 0x000079,[CaseTitle] = 0x000059,[CaseUpper] = 0x000059,[CaseFold] = 0x000079}, NULL},
	{0x00007a, {[CaseLower] = 0x00007a,[CaseTitle] = 0x00005a,[CaseUpper] = 0x00005a,[CaseFold] = 0x00007a}, NULL},
	{0x00007b, {[CaseLower] = 0x00007b,[CaseTitle] = 0x00007b,[CaseUpper] = 0x00007b,[CaseFold] = 0x00007b}, NULL},
	{0x00007c, {[CaseLower] = 0x00007c,[CaseTitle] = 0x00007c,[CaseUpper] = 0x00007c,[CaseFold] = 0x00007c}, NULL},
	{0x00007d, {[CaseLower] = 0x00007d,[CaseTitle] = 0x00007d,[CaseUpper] = 0x00007d,[CaseFold] = 0x00007d}, NULL},
	{0x00007e, {[CaseLower] = 0x00007e,[CaseTitle] = 0x00007e,[CaseUpper] = 0x00007e,[CaseFold] = 0x00007e}, NULL},
	{0x00007f, {[CaseLower] = 0x00007f,[CaseTitle] = 0x00007f,[CaseUpper] = 0x00007f,[CaseFold] = 0x00007f}, NULL},

	/* begin sparse entries for codepoints >= 0x80 */
	{0x0000b5, {[CaseLower] = 0x0000b5,[CaseTitle] = 0x00039c,[CaseUpper] = 0x00039c,[CaseFold] = 0x0003bc}, NULL},
	{0x0000c0, {[CaseLower] = 0x0000e0,[CaseTitle] = 0x0000c0,[CaseUpper] = 0x0000c0,[CaseFold] = 0x0000e0}, NULL},
	{0x0000c1, {[CaseLower] = 0x0000e1,[CaseTitle] = 0x0000c1,[CaseUpper] = 0x0000c1,[CaseFold] = 0x0000e1}, NULL},
	{0x0000c2, {[CaseLower] = 0x0000e2,[CaseTitle] = 0x0000c2,[CaseUpper] = 0x0000c2,[CaseFold] = 0x0000e2}, NULL},
	{0x0000c3, {[CaseLower] = 0x0000e3,[CaseTitle] = 0x0000c3,[CaseUpper] = 0x0000c3,[CaseFold] = 0x0000e3}, NULL},
	{0x0000c4, {[CaseLower] = 0x0000e4,[CaseTitle] = 0x0000c4,[CaseUpper] = 0x0000c4,[CaseFold] = 0x0000e4}, NULL},
	{0x0000c5, {[CaseLower] = 0x0000e5,[CaseTitle] = 0x0000c5,[CaseUpper] = 0x0000c5,[CaseFold] = 0x0000e5}, NULL},
	{0x0000c6, {[CaseLower] = 0x0000e6,[CaseTitle] = 0x0000c6,[CaseUpper] = 0x0000c6,[CaseFold] = 0x0000e6}, NULL},
	{0x0000c7, {[CaseLower] = 0x0000e7,[CaseTitle] = 0x0000c7,[CaseUpper] = 0x0000c7,[CaseFold] = 0x0000e7}, NULL},
	{0x0000c8, {[CaseLower] = 0x0000e8,[CaseTitle] = 0x0000c8,[CaseUpper] = 0x0000c8,[CaseFold] = 0x0000e8}, NULL},
	{0x0000c9, {[CaseLower] = 0x0000e9,[CaseTitle] = 0x0000c9,[CaseUpper] = 0x0000c9,[CaseFold] = 0x0000e9}, NULL},
	{0x0000ca, {[CaseLower] = 0x0000ea,[CaseTitle] = 0x0000ca,[CaseUpper] = 0x0000ca,[CaseFold] = 0x0000ea}, NULL},
	{0x0000cb, {[CaseLower] = 0x0000eb,[CaseTitle] = 0x0000cb,[CaseUpper] = 0x0000cb,[CaseFold] = 0x0000eb}, NULL},
	{0x0000cc, {[CaseLower] = 0x0000ec,[CaseTitle] = 0x0000cc,[CaseUpper] = 0x0000cc,[CaseFold] = 0x0000ec}, NULL},
	{0x0000cd, {[CaseLower] = 0x0000ed,[CaseTitle] = 0x0000cd,[CaseUpper] = 0x0000cd,[CaseFold] = 0x0000ed}, NULL},
	{0x0000ce, {[CaseLower] = 0x0000ee,[CaseTitle] = 0x0000ce,[CaseUpper] = 0x0000ce,[CaseFold] = 0x0000ee}, NULL},
	{0x0000cf, {[CaseLower] = 0x0000ef,[CaseTitle] = 0x0000cf,[CaseUpper] = 0x0000cf,[CaseFold] = 0x0000ef}, NULL},
	{0x0000d0, {[CaseLower] = 0x0000f0,[CaseTitle] = 0x0000d0,[CaseUpper] = 0x0000d0,[CaseFold] = 0x0000f0}, NULL},
	{0x0000d1, {[CaseLower] = 0x0000f1,[CaseTitle] = 0x0000d1,[CaseUpper] = 0x0000d1,[CaseFold] = 0x0000f1}, NULL},
	{0x0000d2, {[CaseLower] = 0x0000f2,[CaseTitle] = 0x0000d2,[CaseUpper] = 0x0000d2,[CaseFold] = 0x0000f2}, NULL},
	{0x0000d3, {[CaseLower] = 0x0000f3,[CaseTitle] = 0x0000d3,[CaseUpper] = 0x0000d3,[CaseFold] = 0x0000f3}, NULL},
	{0x0000d4, {[CaseLower] = 0x0000f4,[CaseTitle] = 0x0000d4,[CaseUpper] = 0x0000d4,[CaseFold] = 0x0000f4}, NULL},
	{0x0000d5, {[CaseLower] = 0x0000f5,[CaseTitle] = 0x0000d5,[CaseUpper] = 0x0000d5,[CaseFold] = 0x0000f5}, NULL},
	{0x0000d6, {[CaseLower] = 0x0000f6,[CaseTitle] = 0x0000d6,[CaseUpper] = 0x0000d6,[CaseFold] = 0x0000f6}, NULL},
	{0x0000d8, {[CaseLower] = 0x0000f8,[CaseTitle] = 0x0000d8,[CaseUpper] = 0x0000d8,[CaseFold] = 0x0000f8}, NULL},
	{0x0000d9, {[CaseLower] = 0x0000f9,[CaseTitle] = 0x0000d9,[CaseUpper] = 0x0000d9,[CaseFold] = 0x0000f9}, NULL},
	{0x0000da, {[CaseLower] = 0x0000fa,[CaseTitle] = 0x0000da,[CaseUpper] = 0x0000da,[CaseFold] = 0x0000fa}, NULL},
	{0x0000db, {[CaseLower] = 0x0000fb,[CaseTitle] = 0x0000db,[CaseUpper] = 0x0000db,[CaseFold] = 0x0000fb}, NULL},
	{0x0000dc, {[CaseLower] = 0x0000fc,[CaseTitle] = 0x0000dc,[CaseUpper] = 0x0000dc,[CaseFold] = 0x0000fc}, NULL},
	{0x0000dd, {[CaseLower] = 0x0000fd,[CaseTitle] = 0x0000dd,[CaseUpper] = 0x0000dd,[CaseFold] = 0x0000fd}, NULL},
	{0x0000de, {[CaseLower] = 0x0000fe,[CaseTitle] = 0x0000de,[CaseUpper] = 0x0000de,[CaseFold] = 0x0000fe}, NULL},
	{0x0000df, {[CaseLower] = 0x0000df,[CaseTitle] = 0x0000df,[CaseUpper] = 0x0000df,[CaseFold] = 0x0000df}, &special_case[0]},
	{0x0000e0, {[CaseLower] = 0x0000e0,[CaseTitle] = 0x0000c0,[CaseUpper] = 0x0000c0,[CaseFold] = 0x0000e0}, NULL},
	{0x0000e1, {[CaseLower] = 0x0000e1,[CaseTitle] = 0x0000c1,[CaseUpper] = 0x0000c1,[CaseFold] = 0x0000e1}, NULL},
	{0x0000e2, {[CaseLower] = 0x0000e2,[CaseTitle] = 0x0000c2,[CaseUpper] = 0x0000c2,[CaseFold] = 0x0000e2}, NULL},
	{0x0000e3, {[CaseLower] = 0x0000e3,[CaseTitle] = 0x0000c3,[CaseUpper] = 0x0000c3,[CaseFold] = 0x0000e3}, NULL},
	{0x0000e4, {[CaseLower] = 0x0000e4,[CaseTitle] = 0x0000c4,[CaseUpper] = 0x0000c4,[CaseFold] = 0x0000e4}, NULL},
	{0x0000e5, {[CaseLower] = 0x0000e5,[CaseTitle] = 0x0000c5,[CaseUpper] = 0x0000c5,[CaseFold] = 0x0000e5}, NULL},
	{0x0000e6, {[CaseLower] = 0x0000e6,[CaseTitle] = 0x0000c6,[CaseUpper] = 0x0000c6,[CaseFold] = 0x0000e6}, NULL},
	{0x0000e7, {[CaseLower] = 0x0000e7,[CaseTitle] = 0x0000c7,[CaseUpper] = 0x0000c7,[CaseFold] = 0x0000e7}, NULL},
	{0x0000e8, {[CaseLower] = 0x0000e8,[CaseTitle] = 0x0000c8,[CaseUpper] = 0x0000c8,[CaseFold] = 0x0000e8}, NULL},
	{0x0000e9, {[CaseLower] = 0x0000e9,[CaseTitle] = 0x0000c9,[CaseUpper] = 0x0000c9,[CaseFold] = 0x0000e9}, NULL},
	{0x0000ea, {[CaseLower] = 0x0000ea,[CaseTitle] = 0x0000ca,[CaseUpper] = 0x0000ca,[CaseFold] = 0x0000ea}, NULL},
	{0x0000eb, {[CaseLower] = 0x0000eb,[CaseTitle] = 0x0000cb,[CaseUpper] = 0x0000cb,[CaseFold] = 0x0000eb}, NULL},
	{0x0000ec, {[CaseLower] = 0x0000ec,[CaseTitle] = 0x0000cc,[CaseUpper] = 0x0000cc,[CaseFold] = 0x0000ec}, NULL},
	{0x0000ed, {[CaseLower] = 0x0000ed,[CaseTitle] = 0x0000cd,[CaseUpper] = 0x0000cd,[CaseFold] = 0x0000ed}, NULL},
	{0x0000ee, {[CaseLower] = 0x0000ee,[CaseTitle] = 0x0000ce,[CaseUpper] = 0x0000ce,[CaseFold] = 0x0000ee}, NULL},
	{0x0000ef, {[CaseLower] = 0x0000ef,[CaseTitle] = 0x0000cf,[CaseUpper] = 0x0000cf,[CaseFold] = 0x0000ef}, NULL},
	{0x0000f0, {[CaseLower] = 0x0000f0,[CaseTitle] = 0x0000d0,[CaseUpper] = 0x0000d0,[CaseFold] = 0x0000f0}, NULL},
	{0x0000f1, {[CaseLower] = 0x0000f1,[CaseTitle] = 0x0000d1,[CaseUpper] = 0x0000d1,[CaseFold] = 0x0000f1}, NULL},
	{0x0000f2, {[CaseLower] = 0x0000f2,[CaseTitle] = 0x0000d2,[CaseUpper] = 0x0000d2,[CaseFold] = 0x0000f2}, NULL},
	{0x0000f3, {[CaseLower] = 0x0000f3,[CaseTitle] = 0x0000d3,[CaseUpper] = 0x0000d3,[CaseFold] = 0x0000f3}, NULL},
	{0x0000f4, {[CaseLower] = 0x0000f4,[CaseTitle] = 0x0000d4,[CaseUpper] = 0x0000d4,[CaseFold] = 0x0000f4}, NULL},
	{0x0000f5, {[CaseLower] = 0x0000f5,[CaseTitle] = 0x0000d5,[CaseUpper] = 0x0000d5,[CaseFold] = 0x0000f5}, NULL},
	{0x0000f6, {[CaseLower] = 0x0000f6,[CaseTitle] = 0x0000d6,[CaseUpper] = 0x0000d6,[CaseFold] = 0x0000f6}, NULL},
	{0x0000f8, {[CaseLower] = 0x0000f8,[CaseTitle] = 0x0000d8,[CaseUpper] = 0x0000d8,[CaseFold] = 0x0000f8}, NULL},
	{0x0000f9, {[CaseLower] = 0x0000f9,[CaseTitle] = 0x0000d9,[CaseUpper] = 0x0000d9,[CaseFold] = 0x0000f9}, NULL},
	{0x0000fa, {[CaseLower] = 0x0000fa,[CaseTitle] = 0x0000da,[CaseUpper] = 0x0000da,[CaseFold] = 0x0000fa}, NULL},
	{0x0000fb, {[CaseLower] = 0x0000fb,[CaseTitle] = 0x0000db,[CaseUpper] = 0x0000db,[CaseFold] = 0x0000fb}, NULL},
	{0x0000fc, {[CaseLower] = 0x0000fc,[CaseTitle] = 0x0000dc,[CaseUpper] = 0x0000dc,[CaseFold] = 0x0000fc}, NULL},
	{0x0000fd, {[CaseLower] = 0x0000fd,[CaseTitle] = 0x0000dd,[CaseUpper] = 0x0000dd,[CaseFold] = 0x0000fd}, NULL},
	{0x0000fe, {[CaseLower] = 0x0000fe,[CaseTitle] = 0x0000de,[CaseUpper] = 0x0000de,[CaseFold] = 0x0000fe}, NULL},
	{0x0000ff, {[CaseLower] = 0x0000ff,[CaseTitle] = 0x000178,[CaseUpper] = 0x000178,[CaseFold] = 0x0000ff}, NULL},
	{0x000100, {[CaseLower] = 0x000101,[CaseTitle] = 0x000100,[CaseUpper] = 0x000100,[CaseFold] = 0x000101}, NULL},
	{0x000101, {[CaseLower] = 0x000101,[CaseTitle] = 0x000100,[CaseUpper] = 0x000100,[CaseFold] = 0x000101}, NULL},
	{0x000102, {[CaseLower] = 0x000103,[CaseTitle] = 0x000102,[CaseUpper] = 0x000102,[CaseFold] = 0x000103}, NULL},
	{0x000103, {[CaseLower] = 0x000103,[CaseTitle] = 0x000102,[CaseUpper] = 0x000102,[CaseFold] = 0x000103}, NULL},
	{0x000104, {[CaseLower] = 0x000105,[CaseTitle] = 0x000104,[CaseUpper] = 0x000104,[CaseFold] = 0x000105}, NULL},
	{0x000105, {[CaseLower] = 0x000105,[CaseTitle] = 0x000104,[CaseUpper] = 0x000104,[CaseFold] = 0x000105}, NULL},
	{0x000106, {[CaseLower] = 0x000107,[CaseTitle] = 0x000106,[CaseUpper] = 0x000106,[CaseFold] = 0x000107}, NULL},
	{0x000107, {[CaseLower] = 0x000107,[CaseTitle] = 0x000106,[CaseUpper] = 0x000106,[CaseFold] = 0x000107}, NULL},
	{0x000108, {[CaseLower] = 0x000109,[CaseTitle] = 0x000108,[CaseUpper] = 0x000108,[CaseFold] = 0x000109}, NULL},
	{0x000109, {[CaseLower] = 0x000109,[CaseTitle] = 0x000108,[CaseUpper] = 0x000108,[CaseFold] = 0x000109}, NULL},
	{0x00010a, {[CaseLower] = 0x00010b,[CaseTitle] = 0x00010a,[CaseUpper] = 0x00010a,[CaseFold] = 0x00010b}, NULL},
	{0x00010b, {[CaseLower] = 0x00010b,[CaseTitle] = 0x00010a,[CaseUpper] = 0x00010a,[CaseFold] = 0x00010b}, NULL},
	{0x00010c, {[CaseLower] = 0x00010d,[CaseTitle] = 0x00010c,[CaseUpper] = 0x00010c,[CaseFold] = 0x00010d}, NULL},
	{0x00010d, {[CaseLower] = 0x00010d,[CaseTitle] = 0x00010c,[CaseUpper] = 0x00010c,[CaseFold] = 0x00010d}, NULL},
	{0x00010e, {[CaseLower] = 0x00010f,[CaseTitle] = 0x00010e,[CaseUpper] = 0x00010e,[CaseFold] = 0x00010f}, NULL},
	{0x00010f, {[CaseLower] = 0x00010f,[CaseTitle] = 0x00010e,[CaseUpper] = 0x00010e,[CaseFold] = 0x00010f}, NULL},
	{0x000110, {[CaseLower] = 0x000111,[CaseTitle] = 0x000110,[CaseUpper] = 0x000110,[CaseFold] = 0x000111}, NULL},
	{0x000111, {[CaseLower] = 0x000111,[CaseTitle] = 0x000110,[CaseUpper] = 0x000110,[CaseFold] = 0x000111}, NULL},
	{0x000112, {[CaseLower] = 0x000113,[CaseTitle] = 0x000112,[CaseUpper] = 0x000112,[CaseFold] = 0x000113}, NULL},
	{0x000113, {[CaseLower] = 0x000113,[CaseTitle] = 0x000112,[CaseUpper] = 0x000112,[CaseFold] = 0x000113}, NULL},
	{0x000114, {[CaseLower] = 0x000115,[CaseTitle] = 0x000114,[CaseUpper] = 0x000114,[CaseFold] = 0x000115}, NULL},
	{0x000115, {[CaseLower] = 0x000115,[CaseTitle] = 0x000114,[CaseUpper] = 0x000114,[CaseFold] = 0x000115}, NULL},
	{0x000116, {[CaseLower] = 0x000117,[CaseTitle] = 0x000116,[CaseUpper] = 0x000116,[CaseFold] = 0x000117}, NULL},
	{0x000117, {[CaseLower] = 0x000117,[CaseTitle] = 0x000116,[CaseUpper] = 0x000116,[CaseFold] = 0x000117}, NULL},
	{0x000118, {[CaseLower] = 0x000119,[CaseTitle] = 0x000118,[CaseUpper] = 0x000118,[CaseFold] = 0x000119}, NULL},
	{0x000119, {[CaseLower] = 0x000119,[CaseTitle] = 0x000118,[CaseUpper] = 0x000118,[CaseFold] = 0x000119}, NULL},
	{0x00011a, {[CaseLower] = 0x00011b,[CaseTitle] = 0x00011a,[CaseUpper] = 0x00011a,[CaseFold] = 0x00011b}, NULL},
	{0x00011b, {[CaseLower] = 0x00011b,[CaseTitle] = 0x00011a,[CaseUpper] = 0x00011a,[CaseFold] = 0x00011b}, NULL},
	{0x00011c, {[CaseLower] = 0x00011d,[CaseTitle] = 0x00011c,[CaseUpper] = 0x00011c,[CaseFold] = 0x00011d}, NULL},
	{0x00011d, {[CaseLower] = 0x00011d,[CaseTitle] = 0x00011c,[CaseUpper] = 0x00011c,[CaseFold] = 0x00011d}, NULL},
	{0x00011e, {[CaseLower] = 0x00011f,[CaseTitle] = 0x00011e,[CaseUpper] = 0x00011e,[CaseFold] = 0x00011f}, NULL},
	{0x00011f, {[CaseLower] = 0x00011f,[CaseTitle] = 0x00011e,[CaseUpper] = 0x00011e,[CaseFold] = 0x00011f}, NULL},
	{0x000120, {[CaseLower] = 0x000121,[CaseTitle] = 0x000120,[CaseUpper] = 0x000120,[CaseFold] = 0x000121}, NULL},
	{0x000121, {[CaseLower] = 0x000121,[CaseTitle] = 0x000120,[CaseUpper] = 0x000120,[CaseFold] = 0x000121}, NULL},
	{0x000122, {[CaseLower] = 0x000123,[CaseTitle] = 0x000122,[CaseUpper] = 0x000122,[CaseFold] = 0x000123}, NULL},
	{0x000123, {[CaseLower] = 0x000123,[CaseTitle] = 0x000122,[CaseUpper] = 0x000122,[CaseFold] = 0x000123}, NULL},
	{0x000124, {[CaseLower] = 0x000125,[CaseTitle] = 0x000124,[CaseUpper] = 0x000124,[CaseFold] = 0x000125}, NULL},
	{0x000125, {[CaseLower] = 0x000125,[CaseTitle] = 0x000124,[CaseUpper] = 0x000124,[CaseFold] = 0x000125}, NULL},
	{0x000126, {[CaseLower] = 0x000127,[CaseTitle] = 0x000126,[CaseUpper] = 0x000126,[CaseFold] = 0x000127}, NULL},
	{0x000127, {[CaseLower] = 0x000127,[CaseTitle] = 0x000126,[CaseUpper] = 0x000126,[CaseFold] = 0x000127}, NULL},
	{0x000128, {[CaseLower] = 0x000129,[CaseTitle] = 0x000128,[CaseUpper] = 0x000128,[CaseFold] = 0x000129}, NULL},
	{0x000129, {[CaseLower] = 0x000129,[CaseTitle] = 0x000128,[CaseUpper] = 0x000128,[CaseFold] = 0x000129}, NULL},
	{0x00012a, {[CaseLower] = 0x00012b,[CaseTitle] = 0x00012a,[CaseUpper] = 0x00012a,[CaseFold] = 0x00012b}, NULL},
	{0x00012b, {[CaseLower] = 0x00012b,[CaseTitle] = 0x00012a,[CaseUpper] = 0x00012a,[CaseFold] = 0x00012b}, NULL},
	{0x00012c, {[CaseLower] = 0x00012d,[CaseTitle] = 0x00012c,[CaseUpper] = 0x00012c,[CaseFold] = 0x00012d}, NULL},
	{0x00012d, {[CaseLower] = 0x00012d,[CaseTitle] = 0x00012c,[CaseUpper] = 0x00012c,[CaseFold] = 0x00012d}, NULL},
	{0x00012e, {[CaseLower] = 0x00012f,[CaseTitle] = 0x00012e,[CaseUpper] = 0x00012e,[CaseFold] = 0x00012f}, NULL},
	{0x00012f, {[CaseLower] = 0x00012f,[CaseTitle] = 0x00012e,[CaseUpper] = 0x00012e,[CaseFold] = 0x00012f}, NULL},
	{0x000130, {[CaseLower] = 0x000069,[CaseTitle] = 0x000130,[CaseUpper] = 0x000130,[CaseFold] = 0x000130}, &special_case[1]},
	{0x000131, {[CaseLower] = 0x000131,[CaseTitle] = 0x000049,[CaseUpper] = 0x000049,[CaseFold] = 0x000131}, NULL},
	{0x000132, {[CaseLower] = 0x000133,[CaseTitle] = 0x000132,[CaseUpper] = 0x000132,[CaseFold] = 0x000133}, NULL},
	{0x000133, {[CaseLower] = 0x000133,[CaseTitle] = 0x000132,[CaseUpper] = 0x000132,[CaseFold] = 0x000133}, NULL},
	{0x000134, {[CaseLower] = 0x000135,[CaseTitle] = 0x000134,[CaseUpper] = 0x000134,[CaseFold] = 0x000135}, NULL},
	{0x000135, {[CaseLower] = 0x000135,[CaseTitle] = 0x000134,[CaseUpper] = 0x000134,[CaseFold] = 0x000135}, NULL},
	{0x000136, {[CaseLower] = 0x000137,[CaseTitle] = 0x000136,[CaseUpper] = 0x000136,[CaseFold] = 0x000137}, NULL},
	{0x000137, {[CaseLower] = 0x000137,[CaseTitle] = 0x000136,[CaseUpper] = 0x000136,[CaseFold] = 0x000137}, NULL},
	{0x000139, {[CaseLower] = 0x00013a,[CaseTitle] = 0x000139,[CaseUpper] = 0x000139,[CaseFold] = 0x00013a}, NULL},
	{0x00013a, {[CaseLower] = 0x00013a,[CaseTitle] = 0x000139,[CaseUpper] = 0x000139,[CaseFold] = 0x00013a}, NULL},
	{0x00013b, {[CaseLower] = 0x00013c,[CaseTitle] = 0x00013b,[CaseUpper] = 0x00013b,[CaseFold] = 0x00013c}, NULL},
	{0x00013c, {[CaseLower] = 0x00013c,[CaseTitle] = 0x00013b,[CaseUpper] = 0x00013b,[CaseFold] = 0x00013c}, NULL},
	{0x00013d, {[CaseLower] = 0x00013e,[CaseTitle] = 0x00013d,[CaseUpper] = 0x00013d,[CaseFold] = 0x00013e}, NULL},
	{0x00013e, {[CaseLower] = 0x00013e,[CaseTitle] = 0x00013d,[CaseUpper] = 0x00013d,[CaseFold] = 0x00013e}, NULL},
	{0x00013f, {[CaseLower] = 0x000140,[CaseTitle] = 0x00013f,[CaseUpper] = 0x00013f,[CaseFold] = 0x000140}, NULL},
	{0x000140, {[CaseLower] = 0x000140,[CaseTitle] = 0x00013f,[CaseUpper] = 0x00013f,[CaseFold] = 0x000140}, NULL},
	{0x000141, {[CaseLower] = 0x000142,[CaseTitle] = 0x000141,[CaseUpper] = 0x000141,[CaseFold] = 0x000142}, NULL},
	{0x000142, {[CaseLower] = 0x000142,[CaseTitle] = 0x000141,[CaseUpper] = 0x000141,[CaseFold] = 0x000142}, NULL},
	{0x000143, {[CaseLower] = 0x000144,[CaseTitle] = 0x000143,[CaseUpper] = 0x000143,[CaseFold] = 0x000144}, NULL},
	{0x000144, {[CaseLower] = 0x000144,[CaseTitle] = 0x000143,[CaseUpper] = 0x000143,[CaseFold] = 0x000144}, NULL},
	{0x000145, {[CaseLower] = 0x000146,[CaseTitle] = 0x000145,[CaseUpper] = 0x000145,[CaseFold] = 0x000146}, NULL},
	{0x000146, {[CaseLower] = 0x000146,[CaseTitle] = 0x000145,[CaseUpper] = 0x000145,[CaseFold] = 0x000146}, NULL},
	{0x000147, {[CaseLower] = 0x000148,[CaseTitle] = 0x000147,[CaseUpper] = 0x000147,[CaseFold] = 0x000148}, NULL},
	{0x000148, {[CaseLower] = 0x000148,[CaseTitle] = 0x000147,[CaseUpper] = 0x000147,[CaseFold] = 0x000148}, NULL},
	{0x000149, {[CaseLower] = 0x000149,[CaseTitle] = 0x000149,[CaseUpper] = 0x000149,[CaseFold] = 0x000149}, &special_case[2]},
	{0x00014a, {[CaseLower] = 0x00014b,[CaseTitle] = 0x00014a,[CaseUpper] = 0x00014a,[CaseFold] = 0x00014b}, NULL},
	{0x00014b, {[CaseLower] = 0x00014b,[CaseTitle] = 0x00014a,[CaseUpper] = 0x00014a,[CaseFold] = 0x00014b}, NULL},
	{0x00014c, {[CaseLower] = 0x00014d,[CaseTitle] = 0x00014c,[CaseUpper] = 0x00014c,[CaseFold] = 0x00014d}, NULL},
	{0x00014d, {[CaseLower] = 0x00014d,[CaseTitle] = 0x00014c,[CaseUpper] = 0x00014c,[CaseFold] = 0x00014d}, NULL},
	{0x00014e, {[CaseLower] = 0x00014f,[CaseTitle] = 0x00014e,[CaseUpper] = 0x00014e,[CaseFold] = 0x00014f}, NULL},
	{0x00014f, {[CaseLower] = 0x00014f,[CaseTitle] = 0x00014e,[CaseUpper] = 0x00014e,[CaseFold] = 0x00014f}, NULL},
	{0x000150, {[CaseLower] = 0x000151,[CaseTitle] = 0x000150,[CaseUpper] = 0x000150,[CaseFold] = 0x000151}, NULL},
	{0x000151, {[CaseLower] = 0x000151,[CaseTitle] = 0x000150,[CaseUpper] = 0x000150,[CaseFold] = 0x000151}, NULL},
	{0x000152, {[CaseLower] = 0x000153,[CaseTitle] = 0x000152,[CaseUpper] = 0x000152,[CaseFold] = 0x000153}, NULL},
	{0x000153, {[CaseLower] = 0x000153,[CaseTitle] = 0x000152,[CaseUpper] = 0x000152,[CaseFold] = 0x000153}, NULL},
	{0x000154, {[CaseLower] = 0x000155,[CaseTitle] = 0x000154,[CaseUpper] = 0x000154,[CaseFold] = 0x000155}, NULL},
	{0x000155, {[CaseLower] = 0x000155,[CaseTitle] = 0x000154,[CaseUpper] = 0x000154,[CaseFold] = 0x000155}, NULL},
	{0x000156, {[CaseLower] = 0x000157,[CaseTitle] = 0x000156,[CaseUpper] = 0x000156,[CaseFold] = 0x000157}, NULL},
	{0x000157, {[CaseLower] = 0x000157,[CaseTitle] = 0x000156,[CaseUpper] = 0x000156,[CaseFold] = 0x000157}, NULL},
	{0x000158, {[CaseLower] = 0x000159,[CaseTitle] = 0x000158,[CaseUpper] = 0x000158,[CaseFold] = 0x000159}, NULL},
	{0x000159, {[CaseLower] = 0x000159,[CaseTitle] = 0x000158,[CaseUpper] = 0x000158,[CaseFold] = 0x000159}, NULL},
	{0x00015a, {[CaseLower] = 0x00015b,[CaseTitle] = 0x00015a,[CaseUpper] = 0x00015a,[CaseFold] = 0x00015b}, NULL},
	{0x00015b, {[CaseLower] = 0x00015b,[CaseTitle] = 0x00015a,[CaseUpper] = 0x00015a,[CaseFold] = 0x00015b}, NULL},
	{0x00015c, {[CaseLower] = 0x00015d,[CaseTitle] = 0x00015c,[CaseUpper] = 0x00015c,[CaseFold] = 0x00015d}, NULL},
	{0x00015d, {[CaseLower] = 0x00015d,[CaseTitle] = 0x00015c,[CaseUpper] = 0x00015c,[CaseFold] = 0x00015d}, NULL},
	{0x00015e, {[CaseLower] = 0x00015f,[CaseTitle] = 0x00015e,[CaseUpper] = 0x00015e,[CaseFold] = 0x00015f}, NULL},
	{0x00015f, {[CaseLower] = 0x00015f,[CaseTitle] = 0x00015e,[CaseUpper] = 0x00015e,[CaseFold] = 0x00015f}, NULL},
	{0x000160, {[CaseLower] = 0x000161,[CaseTitle] = 0x000160,[CaseUpper] = 0x000160,[CaseFold] = 0x000161}, NULL},
	{0x000161, {[CaseLower] = 0x000161,[CaseTitle] = 0x000160,[CaseUpper] = 0x000160,[CaseFold] = 0x000161}, NULL},
	{0x000162, {[CaseLower] = 0x000163,[CaseTitle] = 0x000162,[CaseUpper] = 0x000162,[CaseFold] = 0x000163}, NULL},
	{0x000163, {[CaseLower] = 0x000163,[CaseTitle] = 0x000162,[CaseUpper] = 0x000162,[CaseFold] = 0x000163}, NULL},
	{0x000164, {[CaseLower] = 0x000165,[CaseTitle] = 0x000164,[CaseUpper] = 0x000164,[CaseFold] = 0x000165}, NULL},
	{0x000165, {[CaseLower] = 0x000165,[CaseTitle] = 0x000164,[CaseUpper] = 0x000164,[CaseFold] = 0x000165}, NULL},
	{0x000166, {[CaseLower] = 0x000167,[CaseTitle] = 0x000166,[CaseUpper] = 0x000166,[CaseFold] = 0x000167}, NULL},
	{0x000167, {[CaseLower] = 0x000167,[CaseTitle] = 0x000166,[CaseUpper] = 0x000166,[CaseFold] = 0x000167}, NULL},
	{0x000168, {[CaseLower] = 0x000169,[CaseTitle] = 0x000168,[CaseUpper] = 0x000168,[CaseFold] = 0x000169}, NULL},
	{0x000169, {[CaseLower] = 0x000169,[CaseTitle] = 0x000168,[CaseUpper] = 0x000168,[CaseFold] = 0x000169}, NULL},
	{0x00016a, {[CaseLower] = 0x00016b,[CaseTitle] = 0x00016a,[CaseUpper] = 0x00016a,[CaseFold] = 0x00016b}, NULL},
	{0x00016b, {[CaseLower] = 0x00016b,[CaseTitle] = 0x00016a,[CaseUpper] = 0x00016a,[CaseFold] = 0x00016b}, NULL},
	{0x00016c, {[CaseLower] = 0x00016d,[CaseTitle] = 0x00016c,[CaseUpper] = 0x00016c,[CaseFold] = 0x00016d}, NULL},
	{0x00016d, {[CaseLower] = 0x00016d,[CaseTitle] = 0x00016c,[CaseUpper] = 0x00016c,[CaseFold] = 0x00016d}, NULL},
	{0x00016e, {[CaseLower] = 0x00016f,[CaseTitle] = 0x00016e,[CaseUpper] = 0x00016e,[CaseFold] = 0x00016f}, NULL},
	{0x00016f, {[CaseLower] = 0x00016f,[CaseTitle] = 0x00016e,[CaseUpper] = 0x00016e,[CaseFold] = 0x00016f}, NULL},
	{0x000170, {[CaseLower] = 0x000171,[CaseTitle] = 0x000170,[CaseUpper] = 0x000170,[CaseFold] = 0x000171}, NULL},
	{0x000171, {[CaseLower] = 0x000171,[CaseTitle] = 0x000170,[CaseUpper] = 0x000170,[CaseFold] = 0x000171}, NULL},
	{0x000172, {[CaseLower] = 0x000173,[CaseTitle] = 0x000172,[CaseUpper] = 0x000172,[CaseFold] = 0x000173}, NULL},
	{0x000173, {[CaseLower] = 0x000173,[CaseTitle] = 0x000172,[CaseUpper] = 0x000172,[CaseFold] = 0x000173}, NULL},
	{0x000174, {[CaseLower] = 0x000175,[CaseTitle] = 0x000174,[CaseUpper] = 0x000174,[CaseFold] = 0x000175}, NULL},
	{0x000175, {[CaseLower] = 0x000175,[CaseTitle] = 0x000174,[CaseUpper] = 0x000174,[CaseFold] = 0x000175}, NULL},
	{0x000176, {[CaseLower] = 0x000177,[CaseTitle] = 0x000176,[CaseUpper] = 0x000176,[CaseFold] = 0x000177}, NULL},
	{0x000177, {[CaseLower] = 0x000177,[CaseTitle] = 0x000176,[CaseUpper] = 0x000176,[CaseFold] = 0x000177}, NULL},
	{0x000178, {[CaseLower] = 0x0000ff,[CaseTitle] = 0x000178,[CaseUpper] = 0x000178,[CaseFold] = 0x0000ff}, NULL},
	{0x000179, {[CaseLower] = 0x00017a,[CaseTitle] = 0x000179,[CaseUpper] = 0x000179,[CaseFold] = 0x00017a}, NULL},
	{0x00017a, {[CaseLower] = 0x00017a,[CaseTitle] = 0x000179,[CaseUpper] = 0x000179,[CaseFold] = 0x00017a}, NULL},
	{0x00017b, {[CaseLower] = 0x00017c,[CaseTitle] = 0x00017b,[CaseUpper] = 0x00017b,[CaseFold] = 0x00017c}, NULL},
	{0x00017c, {[CaseLower] = 0x00017c,[CaseTitle] = 0x00017b,[CaseUpper] = 0x00017b,[CaseFold] = 0x00017c}, NULL},
	{0x00017d, {[CaseLower] = 0x00017e,[CaseTitle] = 0x00017d,[CaseUpper] = 0x00017d,[CaseFold] = 0x00017e}, NULL},
	{0x00017e, {[CaseLower] = 0x00017e,[CaseTitle] = 0x00017d,[CaseUpper] = 0x00017d,[CaseFold] = 0x00017e}, NULL},
	{0x00017f, {[CaseLower] = 0x00017f,[CaseTitle] = 0x000053,[CaseUpper] = 0x000053,[CaseFold] = 0x000073}, NULL},
	{0x000180, {[CaseLower] = 0x000180,[CaseTitle] = 0x000243,[CaseUpper] = 0x000243,[CaseFold] = 0x000180}, NULL},
	{0x000181, {[CaseLower] = 0x000253,[CaseTitle] = 0x000181,[CaseUpper] = 0x000181,[CaseFold] = 0x000253}, NULL},
	{0x000182, {[CaseLower] = 0x000183,[CaseTitle] = 0x000182,[CaseUpper] = 0x000182,[CaseFold] = 0x000183}, NULL},
	{0x000183, {[CaseLower] = 0x000183,[CaseTitle] = 0x000182,[CaseUpper] = 0x000182,[CaseFold] = 0x000183}, NULL},
	{0x000184, {[CaseLower] = 0x000185,[CaseTitle] = 0x000184,[CaseUpper] = 0x000184,[CaseFold] = 0x000185}, NULL},
	{0x000185, {[CaseLower] = 0x000185,[CaseTitle] = 0x000184,[CaseUpper] = 0x000184,[CaseFold] = 0x000185}, NULL},
	{0x000186, {[CaseLower] = 0x000254,[CaseTitle] = 0x000186,[CaseUpper] = 0x000186,[CaseFold] = 0x000254}, NULL},
	{0x000187, {[CaseLower] = 0x000188,[CaseTitle] = 0x000187,[CaseUpper] = 0x000187,[CaseFold] = 0x000188}, NULL},
	{0x000188, {[CaseLower] = 0x000188,[CaseTitle] = 0x000187,[CaseUpper] = 0x000187,[CaseFold] = 0x000188}, NULL},
	{0x000189, {[CaseLower] = 0x000256,[CaseTitle] = 0x000189,[CaseUpper] = 0x000189,[CaseFold] = 0x000256}, NULL},
	{0x00018a, {[CaseLower] = 0x000257,[CaseTitle] = 0x00018a,[CaseUpper] = 0x00018a,[CaseFold] = 0x000257}, NULL},
	{0x00018b, {[CaseLower] = 0x00018c,[CaseTitle] = 0x00018b,[CaseUpper] = 0x00018b,[CaseFold] = 0x00018c}, NULL},
	{0x00018c, {[CaseLower] = 0x00018c,[CaseTitle] = 0x00018b,[CaseUpper] = 0x00018b,[CaseFold] = 0x00018c}, NULL},
	{0x00018e, {[CaseLower] = 0x0001dd,[CaseTitle] = 0x00018e,[CaseUpper] = 0x00018e,[CaseFold] = 0x0001dd}, NULL},
	{0x00018f, {[CaseLower] = 0x000259,[CaseTitle] = 0x00018f,[CaseUpper] = 0x00018f,[CaseFold] = 0x000259}, NULL},
	{0x000190, {[CaseLower] = 0x00025b,[CaseTitle] = 0x000190,[CaseUpper] = 0x000190,[CaseFold] = 0x00025b}, NULL},
	{0x000191, {[CaseLower] = 0x000192,[CaseTitle] = 0x000191,[CaseUpper] = 0x000191,[CaseFold] = 0x000192}, NULL},
	{0x000192, {[CaseLower] = 0x000192,[CaseTitle] = 0x000191,[CaseUpper] = 0x000191,[CaseFold] = 0x000192}, NULL},
	{0x000193, {[CaseLower] = 0x000260,[CaseTitle] = 0x000193,[CaseUpper] = 0x000193,[CaseFold] = 0x000260}, NULL},
	{0x000194, {[CaseLower] = 0x000263,[CaseTitle] = 0x000194,[CaseUpper] = 0x000194,[CaseFold] = 0x000263}, NULL},
	{0x000195, {[CaseLower] = 0x000195,[CaseTitle] = 0x0001f6,[CaseUpper] = 0x0001f6,[CaseFold] = 0x000195}, NULL},
	{0x000196, {[CaseLower] = 0x000269,[CaseTitle] = 0x000196,[CaseUpper] = 0x000196,[CaseFold] = 0x000269}, NULL},
	{0x000197, {[CaseLower] = 0x000268,[CaseTitle] = 0x000197,[CaseUpper] = 0x000197,[CaseFold] = 0x000268}, NULL},
	{0x000198, {[CaseLower] = 0x000199,[CaseTitle] = 0x000198,[CaseUpper] = 0x000198,[CaseFold] = 0x000199}, NULL},
	{0x000199, {[CaseLower] = 0x000199,[CaseTitle] = 0x000198,[CaseUpper] = 0x000198,[CaseFold] = 0x000199}, NULL},
	{0x00019a, {[CaseLower] = 0x00019a,[CaseTitle] = 0x00023d,[CaseUpper] = 0x00023d,[CaseFold] = 0x00019a}, NULL},
	{0x00019c, {[CaseLower] = 0x00026f,[CaseTitle] = 0x00019c,[CaseUpper] = 0x00019c,[CaseFold] = 0x00026f}, NULL},
	{0x00019d, {[CaseLower] = 0x000272,[CaseTitle] = 0x00019d,[CaseUpper] = 0x00019d,[CaseFold] = 0x000272}, NULL},
	{0x00019e, {[CaseLower] = 0x00019e,[CaseTitle] = 0x000220,[CaseUpper] = 0x000220,[CaseFold] = 0x00019e}, NULL},
	{0x00019f, {[CaseLower] = 0x000275,[CaseTitle] = 0x00019f,[CaseUpper] = 0x00019f,[CaseFold] = 0x000275}, NULL},
	{0x0001a0, {[CaseLower] = 0x0001a1,[CaseTitle] = 0x0001a0,[CaseUpper] = 0x0001a0,[CaseFold] = 0x0001a1}, NULL},
	{0x0001a1, {[CaseLower] = 0x0001a1,[CaseTitle] = 0x0001a0,[CaseUpper] = 0x0001a0,[CaseFold] = 0x0001a1}, NULL},
	{0x0001a2, {[CaseLower] = 0x0001a3,[CaseTitle] = 0x0001a2,[CaseUpper] = 0x0001a2,[CaseFold] = 0x0001a3}, NULL},
	{0x0001a3, {[CaseLower] = 0x0001a3,[CaseTitle] = 0x0001a2,[CaseUpper] = 0x0001a2,[CaseFold] = 0x0001a3}, NULL},
	{0x0001a4, {[CaseLower] = 0x0001a5,[CaseTitle] = 0x0001a4,[CaseUpper] = 0x0001a4,[CaseFold] = 0x0001a5}, NULL},
	{0x0001a5, {[CaseLower] = 0x0001a5,[CaseTitle] = 0x0001a4,[CaseUpper] = 0x0001a4,[CaseFold] = 0x0001a5}, NULL},
	{0x0001a6, {[CaseLower] = 0x000280,[CaseTitle] = 0x0001a6,[CaseUpper] = 0x0001a6,[CaseFold] = 0x000280}, NULL},
	{0x0001a7, {[CaseLower] = 0x0001a8,[CaseTitle] = 0x0001a7,[CaseUpper] = 0x0001a7,[CaseFold] = 0x0001a8}, NULL},
	{0x0001a8, {[CaseLower] = 0x0001a8,[CaseTitle] = 0x0001a7,[CaseUpper] = 0x0001a7,[CaseFold] = 0x0001a8}, NULL},
	{0x0001a9, {[CaseLower] = 0x000283,[CaseTitle] = 0x0001a9,[CaseUpper] = 0x0001a9,[CaseFold] = 0x000283}, NULL},
	{0x0001ac, {[CaseLower] = 0x0001ad,[CaseTitle] = 0x0001ac,[CaseUpper] = 0x0001ac,[CaseFold] = 0x0001ad}, NULL},
	{0x0001ad, {[CaseLower] = 0x0001ad,[CaseTitle] = 0x0001ac,[CaseUpper] = 0x0001ac,[CaseFold] = 0x0001ad}, NULL},
	{0x0001ae, {[CaseLower] = 0x000288,[CaseTitle] = 0x0001ae,[CaseUpper] = 0x0001ae,[CaseFold] = 0x000288}, NULL},
	{0x0001af, {[CaseLower] = 0x0001b0,[CaseTitle] = 0x0001af,[CaseUpper] = 0x0001af,[CaseFold] = 0x0001b0}, NULL},
	{0x0001b0, {[CaseLower] = 0x0001b0,[CaseTitle] = 0x0001af,[CaseUpper] = 0x0001af,[CaseFold] = 0x0001b0}, NULL},
	{0x0001b1, {[CaseLower] = 0x00028a,[CaseTitle] = 0x0001b1,[CaseUpper] = 0x0001b1,[CaseFold] = 0x00028a}, NULL},
	{0x0001b2, {[CaseLower] = 0x00028b,[CaseTitle] = 0x0001b2,[CaseUpper] = 0x0001b2,[CaseFold] = 0x00028b}, NULL},
	{0x0001b3, {[CaseLower] = 0x0001b4,[CaseTitle] = 0x0001b3,[CaseUpper] = 0x0001b3,[CaseFold] = 0x0001b4}, NULL},
	{0x0001b4, {[CaseLower] = 0x0001b4,[CaseTitle] = 0x0001b3,[CaseUpper] = 0x0001b3,[CaseFold] = 0x0001b4}, NULL},
	{0x0001b5, {[CaseLower] = 0x0001b6,[CaseTitle] = 0x0001b5,[CaseUpper] = 0x0001b5,[CaseFold] = 0x0001b6}, NULL},
	{0x0001b6, {[CaseLower] = 0x0001b6,[CaseTitle] = 0x0001b5,[CaseUpper] = 0x0001b5,[CaseFold] = 0x0001b6}, NULL},
	{0x0001b7, {[CaseLower] = 0x000292,[CaseTitle] = 0x0001b7,[CaseUpper] = 0x0001b7,[CaseFold] = 0x000292}, NULL},
	{0x0001b8, {[CaseLower] = 0x0001b9,[CaseTitle] = 0x0001b8,[CaseUpper] = 0x0001b8,[CaseFold] = 0x0001b9}, NULL},
	{0x0001b9, {[CaseLower] = 0x0001b9,[CaseTitle] = 0x0001b8,[CaseUpper] = 0x0001b8,[CaseFold] = 0x0001b9}, NULL},
	{0x0001bc, {[CaseLower] = 0x0001bd,[CaseTitle] = 0x0001bc,[CaseUpper] = 0x0001bc,[CaseFold] = 0x0001bd}, NULL},
	{0x0001bd, {[CaseLower] = 0x0001bd,[CaseTitle] = 0x0001bc,[CaseUpper] = 0x0001bc,[CaseFold] = 0x0001bd}, NULL},
	{0x0001bf, {[CaseLower] = 0x0001bf,[CaseTitle] = 0x0001f7,[CaseUpper] = 0x0001f7,[CaseFold] = 0x0001bf}, NULL},
	{0x0001c4, {[CaseLower] = 0x0001c6,[CaseTitle] = 0x0001c5,[CaseUpper] = 0x0001c4,[CaseFold] = 0x0001c6}, NULL},
	{0x0001c5, {[CaseLower] = 0x0001c6,[CaseTitle] = 0x0001c5,[CaseUpper] = 0x0001c4,[CaseFold] = 0x0001c6}, NULL},
	{0x0001c6, {[CaseLower] = 0x0001c6,[CaseTitle] = 0x0001c5,[CaseUpper] = 0x0001c4,[CaseFold] = 0x0001c6}, NULL},
	{0x0001c7, {[CaseLower] = 0x0001c9,[CaseTitle] = 0x0001c8,[CaseUpper] = 0x0001c7,[CaseFold] = 0x0001c9}, NULL},
	{0x0001c8, {[CaseLower] = 0x0001c9,[CaseTitle] = 0x0001c8,[CaseUpper] = 0x0001c7,[CaseFold] = 0x0001c9}, NULL},
	{0x0001c9, {[CaseLower] = 0x0001c9,[CaseTitle] = 0x0001c8,[CaseUpper] = 0x0001c7,[CaseFold] = 0x0001c9}, NULL},
	{0x0001ca, {[CaseLower] = 0x0001cc,[CaseTitle] = 0x0001cb,[CaseUpper] = 0x0001ca,[CaseFold] = 0x0001cc}, NULL},
	{0x0001cb, {[CaseLower] = 0x0001cc,[CaseTitle] = 0x0001cb,[CaseUpper] = 0x0001ca,[CaseFold] = 0x0001cc}, NULL},
	{0x0001cc, {[CaseLower] = 0x0001cc,[CaseTitle] = 0x0001cb,[CaseUpper] = 0x0001ca,[CaseFold] = 0x0001cc}, NULL},
	{0x0001cd, {[CaseLower] = 0x0001ce,[CaseTitle] = 0x0001cd,[CaseUpper] = 0x0001cd,[CaseFold] = 0x0001ce}, NULL},
	{0x0001ce, {[CaseLower] = 0x0001ce,[CaseTitle] = 0x0001cd,[CaseUpper] = 0x0001cd,[CaseFold] = 0x0001ce}, NULL},
	{0x0001cf, {[CaseLower] = 0x0001d0,[CaseTitle] = 0x0001cf,[CaseUpper] = 0x0001cf,[CaseFold] = 0x0001d0}, NULL},
	{0x0001d0, {[CaseLower] = 0x0001d0,[CaseTitle] = 0x0001cf,[CaseUpper] = 0x0001cf,[CaseFold] = 0x0001d0}, NULL},
	{0x0001d1, {[CaseLower] = 0x0001d2,[CaseTitle] = 0x0001d1,[CaseUpper] = 0x0001d1,[CaseFold] = 0x0001d2}, NULL},
	{0x0001d2, {[CaseLower] = 0x0001d2,[CaseTitle] = 0x0001d1,[CaseUpper] = 0x0001d1,[CaseFold] = 0x0001d2}, NULL},
	{0x0001d3, {[CaseLower] = 0x0001d4,[CaseTitle] = 0x0001d3,[CaseUpper] = 0x0001d3,[CaseFold] = 0x0001d4}, NULL},
	{0x0001d4, {[CaseLower] = 0x0001d4,[CaseTitle] = 0x0001d3,[CaseUpper] = 0x0001d3,[CaseFold] = 0x0001d4}, NULL},
	{0x0001d5, {[CaseLower] = 0x0001d6,[CaseTitle] = 0x0001d5,[CaseUpper] = 0x0001d5,[CaseFold] = 0x0001d6}, NULL},
	{0x0001d6, {[CaseLower] = 0x0001d6,[CaseTitle] = 0x0001d5,[CaseUpper] = 0x0001d5,[CaseFold] = 0x0001d6}, NULL},
	{0x0001d7, {[CaseLower] = 0x0001d8,[CaseTitle] = 0x0001d7,[CaseUpper] = 0x0001d7,[CaseFold] = 0x0001d8}, NULL},
	{0x0001d8, {[CaseLower] = 0x0001d8,[CaseTitle] = 0x0001d7,[CaseUpper] = 0x0001d7,[CaseFold] = 0x0001d8}, NULL},
	{0x0001d9, {[CaseLower] = 0x0001da,[CaseTitle] = 0x0001d9,[CaseUpper] = 0x0001d9,[CaseFold] = 0x0001da}, NULL},
	{0x0001da, {[CaseLower] = 0x0001da,[CaseTitle] = 0x0001d9,[CaseUpper] = 0x0001d9,[CaseFold] = 0x0001da}, NULL},
	{0x0001db, {[CaseLower] = 0x0001dc,[CaseTitle] = 0x0001db,[CaseUpper] = 0x0001db,[CaseFold] = 0x0001dc}, NULL},
	{0x0001dc, {[CaseLower] = 0x0001dc,[CaseTitle] = 0x0001db,[CaseUpper] = 0x0001db,[CaseFold] = 0x0001dc}, NULL},
	{0x0001dd, {[CaseLower] = 0x0001dd,[CaseTitle] = 0x00018e,[CaseUpper] = 0x00018e,[CaseFold] = 0x0001dd}, NULL},
	{0x0001de, {[CaseLower] = 0x0001df,[CaseTitle] = 0x0001de,[CaseUpper] = 0x0001de,[CaseFold] = 0x0001df}, NULL},
	{0x0001df, {[CaseLower] = 0x0001df,[CaseTitle] = 0x0001de,[CaseUpper] = 0x0001de,[CaseFold] = 0x0001df}, NULL},
	{0x0001e0, {[CaseLower] = 0x0001e1,[CaseTitle] = 0x0001e0,[CaseUpper] = 0x0001e0,[CaseFold] = 0x0001e1}, NULL},
	{0x0001e1, {[CaseLower] = 0x0001e1,[CaseTitle] = 0x0001e0,[CaseUpper] = 0x0001e0,[CaseFold] = 0x0001e1}, NULL},
	{0x0001e2, {[CaseLower] = 0x0001e3,[CaseTitle] = 0x0001e2,[CaseUpper] = 0x0001e2,[CaseFold] = 0x0001e3}, NULL},
	{0x0001e3, {[CaseLower] = 0x0001e3,[CaseTitle] = 0x0001e2,[CaseUpper] = 0x0001e2,[CaseFold] = 0x0001e3}, NULL},
	{0x0001e4, {[CaseLower] = 0x0001e5,[CaseTitle] = 0x0001e4,[CaseUpper] = 0x0001e4,[CaseFold] = 0x0001e5}, NULL},
	{0x0001e5, {[CaseLower] = 0x0001e5,[CaseTitle] = 0x0001e4,[CaseUpper] = 0x0001e4,[CaseFold] = 0x0001e5}, NULL},
	{0x0001e6, {[CaseLower] = 0x0001e7,[CaseTitle] = 0x0001e6,[CaseUpper] = 0x0001e6,[CaseFold] = 0x0001e7}, NULL},
	{0x0001e7, {[CaseLower] = 0x0001e7,[CaseTitle] = 0x0001e6,[CaseUpper] = 0x0001e6,[CaseFold] = 0x0001e7}, NULL},
	{0x0001e8, {[CaseLower] = 0x0001e9,[CaseTitle] = 0x0001e8,[CaseUpper] = 0x0001e8,[CaseFold] = 0x0001e9}, NULL},
	{0x0001e9, {[CaseLower] = 0x0001e9,[CaseTitle] = 0x0001e8,[CaseUpper] = 0x0001e8,[CaseFold] = 0x0001e9}, NULL},
	{0x0001ea, {[CaseLower] = 0x0001eb,[CaseTitle] = 0x0001ea,[CaseUpper] = 0x0001ea,[CaseFold] = 0x0001eb}, NULL},
	{0x0001eb, {[CaseLower] = 0x0001eb,[CaseTitle] = 0x0001ea,[CaseUpper] = 0x0001ea,[CaseFold] = 0x0001eb}, NULL},
	{0x0001ec, {[CaseLower] = 0x0001ed,[CaseTitle] = 0x0001ec,[CaseUpper] = 0x0001ec,[CaseFold] = 0x0001ed}, NULL},
	{0x0001ed, {[CaseLower] = 0x0001ed,[CaseTitle] = 0x0001ec,[CaseUpper] = 0x0001ec,[CaseFold] = 0x0001ed}, NULL},
	{0x0001ee, {[CaseLower] = 0x0001ef,[CaseTitle] = 0x0001ee,[CaseUpper] = 0x0001ee,[CaseFold] = 0x0001ef}, NULL},
	{0x0001ef, {[CaseLower] = 0x0001ef,[CaseTitle] = 0x0001ee,[CaseUpper] = 0x0001ee,[CaseFold] = 0x0001ef}, NULL},
	{0x0001f0, {[CaseLower] = 0x0001f0,[CaseTitle] = 0x0001f0,[CaseUpper] = 0x0001f0,[CaseFold] = 0x0001f0}, &special_case[3]},
	{0x0001f1, {[CaseLower] = 0x0001f3,[CaseTitle] = 0x0001f2,[CaseUpper] = 0x0001f1,[CaseFold] = 0x0001f3}, NULL},
	{0x0001f2, {[CaseLower] = 0x0001f3,[CaseTitle] = 0x0001f2,[CaseUpper] = 0x0001f1,[CaseFold] = 0x0001f3}, NULL},
	{0x0001f3, {[CaseLower] = 0x0001f3,[CaseTitle] = 0x0001f2,[CaseUpper] = 0x0001f1,[CaseFold] = 0x0001f3}, NULL},
	{0x0001f4, {[CaseLower] = 0x0001f5,[CaseTitle] = 0x0001f4,[CaseUpper] = 0x0001f4,[CaseFold] = 0x0001f5}, NULL},
	{0x0001f5, {[CaseLower] = 0x0001f5,[CaseTitle] = 0x0001f4,[CaseUpper] = 0x0001f4,[CaseFold] = 0x0001f5}, NULL},
	{0x0001f6, {[CaseLower] = 0x000195,[CaseTitle] = 0x0001f6,[CaseUpper] = 0x0001f6,[CaseFold] = 0x000195}, NULL},
	{0x0001f7, {[CaseLower] = 0x0001bf,[CaseTitle] = 0x0001f7,[CaseUpper] = 0x0001f7,[CaseFold] = 0x0001bf}, NULL},
	{0x0001f8, {[CaseLower] = 0x0001f9,[CaseTitle] = 0x0001f8,[CaseUpper] = 0x0001f8,[CaseFold] = 0x0001f9}, NULL},
	{0x0001f9, {[CaseLower] = 0x0001f9,[CaseTitle] = 0x0001f8,[CaseUpper] = 0x0001f8,[CaseFold] = 0x0001f9}, NULL},
	{0x0001fa, {[CaseLower] = 0x0001fb,[CaseTitle] = 0x0001fa,[CaseUpper] = 0x0001fa,[CaseFold] = 0x0001fb}, NULL},
	{0x0001fb, {[CaseLower] = 0x0001fb,[CaseTitle] = 0x0001fa,[CaseUpper] = 0x0001fa,[CaseFold] = 0x0001fb}, NULL},
	{0x0001fc, {[CaseLower] = 0x0001fd,[CaseTitle] = 0x0001fc,[CaseUpper] = 0x0001fc,[CaseFold] = 0x0001fd}, NULL},
	{0x0001fd, {[CaseLower] = 0x0001fd,[CaseTitle] = 0x0001fc,[CaseUpper] = 0x0001fc,[CaseFold] = 0x0001fd}, NULL},
	{0x0001fe, {[CaseLower] = 0x0001ff,[CaseTitle] = 0x0001fe,[CaseUpper] = 0x0001fe,[CaseFold] = 0x0001ff}, NULL},
	{0x0001ff, {[CaseLower] = 0x0001ff,[CaseTitle] = 0x0001fe,[CaseUpper] = 0x0001fe,[CaseFold] = 0x0001ff}, NULL},
	{0x000200, {[CaseLower] = 0x000201,[CaseTitle] = 0x000200,[CaseUpper] = 0x000200,[CaseFold] = 0x000201}, NULL},
	{0x000201, {[CaseLower] = 0x000201,[CaseTitle] = 0x000200,[CaseUpper] = 0x000200,[CaseFold] = 0x000201}, NULL},
	{0x000202, {[CaseLower] = 0x000203,[CaseTitle] = 0x000202,[CaseUpper] = 0x000202,[CaseFold] = 0x000203}, NULL},
	{0x000203, {[CaseLower] = 0x000203,[CaseTitle] = 0x000202,[CaseUpper] = 0x000202,[CaseFold] = 0x000203}, NULL},
	{0x000204, {[CaseLower] = 0x000205,[CaseTitle] = 0x000204,[CaseUpper] = 0x000204,[CaseFold] = 0x000205}, NULL},
	{0x000205, {[CaseLower] = 0x000205,[CaseTitle] = 0x000204,[CaseUpper] = 0x000204,[CaseFold] = 0x000205}, NULL},
	{0x000206, {[CaseLower] = 0x000207,[CaseTitle] = 0x000206,[CaseUpper] = 0x000206,[CaseFold] = 0x000207}, NULL},
	{0x000207, {[CaseLower] = 0x000207,[CaseTitle] = 0x000206,[CaseUpper] = 0x000206,[CaseFold] = 0x000207}, NULL},
	{0x000208, {[CaseLower] = 0x000209,[CaseTitle] = 0x000208,[CaseUpper] = 0x000208,[CaseFold] = 0x000209}, NULL},
	{0x000209, {[CaseLower] = 0x000209,[CaseTitle] = 0x000208,[CaseUpper] = 0x000208,[CaseFold] = 0x000209}, NULL},
	{0x00020a, {[CaseLower] = 0x00020b,[CaseTitle] = 0x00020a,[CaseUpper] = 0x00020a,[CaseFold] = 0x00020b}, NULL},
	{0x00020b, {[CaseLower] = 0x00020b,[CaseTitle] = 0x00020a,[CaseUpper] = 0x00020a,[CaseFold] = 0x00020b}, NULL},
	{0x00020c, {[CaseLower] = 0x00020d,[CaseTitle] = 0x00020c,[CaseUpper] = 0x00020c,[CaseFold] = 0x00020d}, NULL},
	{0x00020d, {[CaseLower] = 0x00020d,[CaseTitle] = 0x00020c,[CaseUpper] = 0x00020c,[CaseFold] = 0x00020d}, NULL},
	{0x00020e, {[CaseLower] = 0x00020f,[CaseTitle] = 0x00020e,[CaseUpper] = 0x00020e,[CaseFold] = 0x00020f}, NULL},
	{0x00020f, {[CaseLower] = 0x00020f,[CaseTitle] = 0x00020e,[CaseUpper] = 0x00020e,[CaseFold] = 0x00020f}, NULL},
	{0x000210, {[CaseLower] = 0x000211,[CaseTitle] = 0x000210,[CaseUpper] = 0x000210,[CaseFold] = 0x000211}, NULL},
	{0x000211, {[CaseLower] = 0x000211,[CaseTitle] = 0x000210,[CaseUpper] = 0x000210,[CaseFold] = 0x000211}, NULL},
	{0x000212, {[CaseLower] = 0x000213,[CaseTitle] = 0x000212,[CaseUpper] = 0x000212,[CaseFold] = 0x000213}, NULL},
	{0x000213, {[CaseLower] = 0x000213,[CaseTitle] = 0x000212,[CaseUpper] = 0x000212,[CaseFold] = 0x000213}, NULL},
	{0x000214, {[CaseLower] = 0x000215,[CaseTitle] = 0x000214,[CaseUpper] = 0x000214,[CaseFold] = 0x000215}, NULL},
	{0x000215, {[CaseLower] = 0x000215,[CaseTitle] = 0x000214,[CaseUpper] = 0x000214,[CaseFold] = 0x000215}, NULL},
	{0x000216, {[CaseLower] = 0x000217,[CaseTitle] = 0x000216,[CaseUpper] = 0x000216,[CaseFold] = 0x000217}, NULL},
	{0x000217, {[CaseLower] = 0x000217,[CaseTitle] = 0x000216,[CaseUpper] = 0x000216,[CaseFold] = 0x000217}, NULL},
	{0x000218, {[CaseLower] = 0x000219,[CaseTitle] = 0x000218,[CaseUpper] = 0x000218,[CaseFold] = 0x000219}, NULL},
	{0x000219, {[CaseLower] = 0x000219,[CaseTitle] = 0x000218,[CaseUpper] = 0x000218,[CaseFold] = 0x000219}, NULL},
	{0x00021a, {[CaseLower] = 0x00021b,[CaseTitle] = 0x00021a,[CaseUpper] = 0x00021a,[CaseFold] = 0x00021b}, NULL},
	{0x00021b, {[CaseLower] = 0x00021b,[CaseTitle] = 0x00021a,[CaseUpper] = 0x00021a,[CaseFold] = 0x00021b}, NULL},
	{0x00021c, {[CaseLower] = 0x00021d,[CaseTitle] = 0x00021c,[CaseUpper] = 0x00021c,[CaseFold] = 0x00021d}, NULL},
	{0x00021d, {[CaseLower] = 0x00021d,[CaseTitle] = 0x00021c,[CaseUpper] = 0x00021c,[CaseFold] = 0x00021d}, NULL},
	{0x00021e, {[CaseLower] = 0x00021f,[CaseTitle] = 0x00021e,[CaseUpper] = 0x00021e,[CaseFold] = 0x00021f}, NULL},
	{0x00021f, {[CaseLower] = 0x00021f,[CaseTitle] = 0x00021e,[CaseUpper] = 0x00021e,[CaseFold] = 0x00021f}, NULL},
	{0x000220, {[CaseLower] = 0x00019e,[CaseTitle] = 0x000220,[CaseUpper] = 0x000220,[CaseFold] = 0x00019e}, NULL},
	{0x000222, {[CaseLower] = 0x000223,[CaseTitle] = 0x000222,[CaseUpper] = 0x000222,[CaseFold] = 0x000223}, NULL},
	{0x000223, {[CaseLower] = 0x000223,[CaseTitle] = 0x000222,[CaseUpper] = 0x000222,[CaseFold] = 0x000223}, NULL},
	{0x000224, {[CaseLower] = 0x000225,[CaseTitle] = 0x000224,[CaseUpper] = 0x000224,[CaseFold] = 0x000225}, NULL},
	{0x000225, {[CaseLower] = 0x000225,[CaseTitle] = 0x000224,[CaseUpper] = 0x000224,[CaseFold] = 0x000225}, NULL},
	{0x000226, {[CaseLower] = 0x000227,[CaseTitle] = 0x000226,[CaseUpper] = 0x000226,[CaseFold] = 0x000227}, NULL},
	{0x000227, {[CaseLower] = 0x000227,[CaseTitle] = 0x000226,[CaseUpper] = 0x000226,[CaseFold] = 0x000227}, NULL},
	{0x000228, {[CaseLower] = 0x000229,[CaseTitle] = 0x000228,[CaseUpper] = 0x000228,[CaseFold] = 0x000229}, NULL},
	{0x000229, {[CaseLower] = 0x000229,[CaseTitle] = 0x000228,[CaseUpper] = 0x000228,[CaseFold] = 0x000229}, NULL},
	{0x00022a, {[CaseLower] = 0x00022b,[CaseTitle] = 0x00022a,[CaseUpper] = 0x00022a,[CaseFold] = 0x00022b}, NULL},
	{0x00022b, {[CaseLower] = 0x00022b,[CaseTitle] = 0x00022a,[CaseUpper] = 0x00022a,[CaseFold] = 0x00022b}, NULL},
	{0x00022c, {[CaseLower] = 0x00022d,[CaseTitle] = 0x00022c,[CaseUpper] = 0x00022c,[CaseFold] = 0x00022d}, NULL},
	{0x00022d, {[CaseLower] = 0x00022d,[CaseTitle] = 0x00022c,[CaseUpper] = 0x00022c,[CaseFold] = 0x00022d}, NULL},
	{0x00022e, {[CaseLower] = 0x00022f,[CaseTitle] = 0x00022e,[CaseUpper] = 0x00022e,[CaseFold] = 0x00022f}, NULL},
	{0x00022f, {[CaseLower] = 0x00022f,[CaseTitle] = 0x00022e,[CaseUpper] = 0x00022e,[CaseFold] = 0x00022f}, NULL},
	{0x000230, {[CaseLower] = 0x000231,[CaseTitle] = 0x000230,[CaseUpper] = 0x000230,[CaseFold] = 0x000231}, NULL},
	{0x000231, {[CaseLower] = 0x000231,[CaseTitle] = 0x000230,[CaseUpper] = 0x000230,[CaseFold] = 0x000231}, NULL},
	{0x000232, {[CaseLower] = 0x000233,[CaseTitle] = 0x000232,[CaseUpper] = 0x000232,[CaseFold] = 0x000233}, NULL},
	{0x000233, {[CaseLower] = 0x000233,[CaseTitle] = 0x000232,[CaseUpper] = 0x000232,[CaseFold] = 0x000233}, NULL},
	{0x00023a, {[CaseLower] = 0x002c65,[CaseTitle] = 0x00023a,[CaseUpper] = 0x00023a,[CaseFold] = 0x002c65}, NULL},
	{0x00023b, {[CaseLower] = 0x00023c,[CaseTitle] = 0x00023b,[CaseUpper] = 0x00023b,[CaseFold] = 0x00023c}, NULL},
	{0x00023c, {[CaseLower] = 0x00023c,[CaseTitle] = 0x00023b,[CaseUpper] = 0x00023b,[CaseFold] = 0x00023c}, NULL},
	{0x00023d, {[CaseLower] = 0x00019a,[CaseTitle] = 0x00023d,[CaseUpper] = 0x00023d,[CaseFold] = 0x00019a}, NULL},
	{0x00023e, {[CaseLower] = 0x002c66,[CaseTitle] = 0x00023e,[CaseUpper] = 0x00023e,[CaseFold] = 0x002c66}, NULL},
	{0x00023f, {[CaseLower] = 0x00023f,[CaseTitle] = 0x002c7e,[CaseUpper] = 0x002c7e,[CaseFold] = 0x00023f}, NULL},
	{0x000240, {[CaseLower] = 0x000240,[CaseTitle] = 0x002c7f,[CaseUpper] = 0x002c7f,[CaseFold] = 0x000240}, NULL},
	{0x000241, {[CaseLower] = 0x000242,[CaseTitle] = 0x000241,[CaseUpper] = 0x000241,[CaseFold] = 0x000242}, NULL},
	{0x000242, {[CaseLower] = 0x000242,[CaseTitle] = 0x000241,[CaseUpper] = 0x000241,[CaseFold] = 0x000242}, NULL},
	{0x000243, {[CaseLower] = 0x000180,[CaseTitle] = 0x000243,[CaseUpper] = 0x000243,[CaseFold] = 0x000180}, NULL},
	{0x000244, {[CaseLower] = 0x000289,[CaseTitle] = 0x000244,[CaseUpper] = 0x000244,[CaseFold] = 0x000289}, NULL},
	{0x000245, {[CaseLower] = 0x00028c,[CaseTitle] = 0x000245,[CaseUpper] = 0x000245,[CaseFold] = 0x00028c}, NULL},
	{0x000246, {[CaseLower] = 0x000247,[CaseTitle] = 0x000246,[CaseUpper] = 0x000246,[CaseFold] = 0x000247}, NULL},
	{0x000247, {[CaseLower] = 0x000247,[CaseTitle] = 0x000246,[CaseUpper] = 0x000246,[CaseFold] = 0x000247}, NULL},
	{0x000248, {[CaseLower] = 0x000249,[CaseTitle] = 0x000248,[CaseUpper] = 0x000248,[CaseFold] = 0x000249}, NULL},
	{0x000249, {[CaseLower] = 0x000249,[CaseTitle] = 0x000248,[CaseUpper] = 0x000248,[CaseFold] = 0x000249}, NULL},
	{0x00024a, {[CaseLower] = 0x00024b,[CaseTitle] = 0x00024a,[CaseUpper] = 0x00024a,[CaseFold] = 0x00024b}, NULL},
	{0x00024b, {[CaseLower] = 0x00024b,[CaseTitle] = 0x00024a,[CaseUpper] = 0x00024a,[CaseFold] = 0x00024b}, NULL},
	{0x00024c, {[CaseLower] = 0x00024d,[CaseTitle] = 0x00024c,[CaseUpper] = 0x00024c,[CaseFold] = 0x00024d}, NULL},
	{0x00024d, {[CaseLower] = 0x00024d,[CaseTitle] = 0x00024c,[CaseUpper] = 0x00024c,[CaseFold] = 0x00024d}, NULL},
	{0x00024e, {[CaseLower] = 0x00024f,[CaseTitle] = 0x00024e,[CaseUpper] = 0x00024e,[CaseFold] = 0x00024f}, NULL},
	{0x00024f, {[CaseLower] = 0x00024f,[CaseTitle] = 0x00024e,[CaseUpper] = 0x00024e,[CaseFold] = 0x00024f}, NULL},
	{0x000250, {[CaseLower] = 0x000250,[CaseTitle] = 0x002c6f,[CaseUpper] = 0x002c6f,[CaseFold] = 0x000250}, NULL},
	{0x000251, {[CaseLower] = 0x000251,[CaseTitle] = 0x002c6d,[CaseUpper] = 0x002c6d,[CaseFold] = 0x000251}, NULL},
	{0x000252, {[CaseLower] = 0x000252,[CaseTitle] = 0x002c70,[CaseUpper] = 0x002c70,[CaseFold] = 0x000252}, NULL},
	{0x000253, {[CaseLower] = 0x000253,[CaseTitle] = 0x000181,[CaseUpper] = 0x000181,[CaseFold] = 0x000253}, NULL},
	{0x000254, {[CaseLower] = 0x000254,[CaseTitle] = 0x000186,[CaseUpper] = 0x000186,[CaseFold] = 0x000254}, NULL},
	{0x000256, {[CaseLower] = 0x000256,[CaseTitle] = 0x000189,[CaseUpper] = 0x000189,[CaseFold] = 0x000256}, NULL},
	{0x000257, {[CaseLower] = 0x000257,[CaseTitle] = 0x00018a,[CaseUpper] = 0x00018a,[CaseFold] = 0x000257}, NULL},
	{0x000259, {[CaseLower] = 0x000259,[CaseTitle] = 0x00018f,[CaseUpper] = 0x00018f,[CaseFold] = 0x000259}, NULL},
	{0x00025b, {[CaseLower] = 0x00025b,[CaseTitle] = 0x000190,[CaseUpper] = 0x000190,[CaseFold] = 0x00025b}, NULL},
	{0x00025c, {[CaseLower] = 0x00025c,[CaseTitle] = 0x00a7ab,[CaseUpper] = 0x00a7ab,[CaseFold] = 0x00025c}, NULL},
	{0x000260, {[CaseLower] = 0x000260,[CaseTitle] = 0x000193,[CaseUpper] = 0x000193,[CaseFold] = 0x000260}, NULL},
	{0x000261, {[CaseLower] = 0x000261,[CaseTitle] = 0x00a7ac,[CaseUpper] = 0x00a7ac,[CaseFold] = 0x000261}, NULL},
	{0x000263, {[CaseLower] = 0x000263,[CaseTitle] = 0x000194,[CaseUpper] = 0x000194,[CaseFold] = 0x000263}, NULL},
	{0x000265, {[CaseLower] = 0x000265,[CaseTitle] = 0x00a78d,[CaseUpper] = 0x00a78d,[CaseFold] = 0x000265}, NULL},
	{0x000266, {[CaseLower] = 0x000266,[CaseTitle] = 0x00a7aa,[CaseUpper] = 0x00a7aa,[CaseFold] = 0x000266}, NULL},
	{0x000268, {[CaseLower] = 0x000268,[CaseTitle] = 0x000197,[CaseUpper] = 0x000197,[CaseFold] = 0x000268}, NULL},
	{0x000269, {[CaseLower] = 0x000269,[CaseTitle] = 0x000196,[CaseUpper] = 0x000196,[CaseFold] = 0x000269}, NULL},
	{0x00026a, {[CaseLower] = 0x00026a,[CaseTitle] = 0x00a7ae,[CaseUpper] = 0x00a7ae,[CaseFold] = 0x00026a}, NULL},
	{0x00026b, {[CaseLower] = 0x00026b,[CaseTitle] = 0x002c62,[CaseUpper] = 0x002c62,[CaseFold] = 0x00026b}, NULL},
	{0x00026c, {[CaseLower] = 0x00026c,[CaseTitle] = 0x00a7ad,[CaseUpper] = 0x00a7ad,[CaseFold] = 0x00026c}, NULL},
	{0x00026f, {[CaseLower] = 0x00026f,[CaseTitle] = 0x00019c,[CaseUpper] = 0x00019c,[CaseFold] = 0x00026f}, NULL},
	{0x000271, {[CaseLower] = 0x000271,[CaseTitle] = 0x002c6e,[CaseUpper] = 0x002c6e,[CaseFold] = 0x000271}, NULL},
	{0x000272, {[CaseLower] = 0x000272,[CaseTitle] = 0x00019d,[CaseUpper] = 0x00019d,[CaseFold] = 0x000272}, NULL},
	{0x000275, {[CaseLower] = 0x000275,[CaseTitle] = 0x00019f,[CaseUpper] = 0x00019f,[CaseFold] = 0x000275}, NULL},
	{0x00027d, {[CaseLower] = 0x00027d,[CaseTitle] = 0x002c64,[CaseUpper] = 0x002c64,[CaseFold] = 0x00027d}, NULL},
	{0x000280, {[CaseLower] = 0x000280,[CaseTitle] = 0x0001a6,[CaseUpper] = 0x0001a6,[CaseFold] = 0x000280}, NULL},
	{0x000282, {[CaseLower] = 0x000282,[CaseTitle] = 0x00a7c5,[CaseUpper] = 0x00a7c5,[CaseFold] = 0x000282}, NULL},
	{0x000283, {[CaseLower] = 0x000283,[CaseTitle] = 0x0001a9,[CaseUpper] = 0x0001a9,[CaseFold] = 0x000283}, NULL},
	{0x000287, {[CaseLower] = 0x000287,[CaseTitle] = 0x00a7b1,[CaseUpper] = 0x00a7b1,[CaseFold] = 0x000287}, NULL},
	{0x000288, {[CaseLower] = 0x000288,[CaseTitle] = 0x0001ae,[CaseUpper] = 0x0001ae,[CaseFold] = 0x000288}, NULL},
	{0x000289, {[CaseLower] = 0x000289,[CaseTitle] = 0x000244,[CaseUpper] = 0x000244,[CaseFold] = 0x000289}, NULL},
	{0x00028a, {[CaseLower] = 0x00028a,[CaseTitle] = 0x0001b1,[CaseUpper] = 0x0001b1,[CaseFold] = 0x00028a}, NULL},
	{0x00028b, {[CaseLower] = 0x00028b,[CaseTitle] = 0x0001b2,[CaseUpper] = 0x0001b2,[CaseFold] = 0x00028b}, NULL},
	{0x00028c, {[CaseLower] = 0x00028c,[CaseTitle] = 0x000245,[CaseUpper] = 0x000245,[CaseFold] = 0x00028c}, NULL},
	{0x000292, {[CaseLower] = 0x000292,[CaseTitle] = 0x0001b7,[CaseUpper] = 0x0001b7,[CaseFold] = 0x000292}, NULL},
	{0x00029d, {[CaseLower] = 0x00029d,[CaseTitle] = 0x00a7b2,[CaseUpper] = 0x00a7b2,[CaseFold] = 0x00029d}, NULL},
	{0x00029e, {[CaseLower] = 0x00029e,[CaseTitle] = 0x00a7b0,[CaseUpper] = 0x00a7b0,[CaseFold] = 0x00029e}, NULL},
	{0x000345, {[CaseLower] = 0x000345,[CaseTitle] = 0x000399,[CaseUpper] = 0x000399,[CaseFold] = 0x0003b9}, NULL},
	{0x000370, {[CaseLower] = 0x000371,[CaseTitle] = 0x000370,[CaseUpper] = 0x000370,[CaseFold] = 0x000371}, NULL},
	{0x000371, {[CaseLower] = 0x000371,[CaseTitle] = 0x000370,[CaseUpper] = 0x000370,[CaseFold] = 0x000371}, NULL},
	{0x000372, {[CaseLower] = 0x000373,[CaseTitle] = 0x000372,[CaseUpper] = 0x000372,[CaseFold] = 0x000373}, NULL},
	{0x000373, {[CaseLower] = 0x000373,[CaseTitle] = 0x000372,[CaseUpper] = 0x000372,[CaseFold] = 0x000373}, NULL},
	{0x000376, {[CaseLower] = 0x000377,[CaseTitle] = 0x000376,[CaseUpper] = 0x000376,[CaseFold] = 0x000377}, NULL},
	{0x000377, {[CaseLower] = 0x000377,[CaseTitle] = 0x000376,[CaseUpper] = 0x000376,[CaseFold] = 0x000377}, NULL},
	{0x00037b, {[CaseLower] = 0x00037b,[CaseTitle] = 0x0003fd,[CaseUpper] = 0x0003fd,[CaseFold] = 0x00037b}, NULL},
	{0x00037c, {[CaseLower] = 0x00037c,[CaseTitle] = 0x0003fe,[CaseUpper] = 0x0003fe,[CaseFold] = 0x00037c}, NULL},
	{0x00037d, {[CaseLower] = 0x00037d,[CaseTitle] = 0x0003ff,[CaseUpper] = 0x0003ff,[CaseFold] = 0x00037d}, NULL},
	{0x00037f, {[CaseLower] = 0x0003f3,[CaseTitle] = 0x00037f,[CaseUpper] = 0x00037f,[CaseFold] = 0x0003f3}, NULL},
	{0x000386, {[CaseLower] = 0x0003ac,[CaseTitle] = 0x000386,[CaseUpper] = 0x000386,[CaseFold] = 0x0003ac}, NULL},
	{0x000388, {[CaseLower] = 0x0003ad,[CaseTitle] = 0x000388,[CaseUpper] = 0x000388,[CaseFold] = 0x0003ad}, NULL},
	{0x000389, {[CaseLower] = 0x0003ae,[CaseTitle] = 0x000389,[CaseUpper] = 0x000389,[CaseFold] = 0x0003ae}, NULL},
	{0x00038a, {[CaseLower] = 0x0003af,[CaseTitle] = 0x00038a,[CaseUpper] = 0x00038a,[CaseFold] = 0x0003af}, NULL},
	{0x00038c, {[CaseLower] = 0x0003cc,[CaseTitle] = 0x00038c,[CaseUpper] = 0x00038c,[CaseFold] = 0x0003cc}, NULL},
	{0x00038e, {[CaseLower] = 0x0003cd,[CaseTitle] = 0x00038e,[CaseUpper] = 0x00038e,[CaseFold] = 0x0003cd}, NULL},
	{0x00038f, {[CaseLower] = 0x0003ce,[CaseTitle] = 0x00038f,[CaseUpper] = 0x00038f,[CaseFold] = 0x0003ce}, NULL},
	{0x000390, {[CaseLower] = 0x000390,[CaseTitle] = 0x000390,[CaseUpper] = 0x000390,[CaseFold] = 0x000390}, &special_case[4]},
	{0x000391, {[CaseLower] = 0x0003b1,[CaseTitle] = 0x000391,[CaseUpper] = 0x000391,[CaseFold] = 0x0003b1}, NULL},
	{0x000392, {[CaseLower] = 0x0003b2,[CaseTitle] = 0x000392,[CaseUpper] = 0x000392,[CaseFold] = 0x0003b2}, NULL},
	{0x000393, {[CaseLower] = 0x0003b3,[CaseTitle] = 0x000393,[CaseUpper] = 0x000393,[CaseFold] = 0x0003b3}, NULL},
	{0x000394, {[CaseLower] = 0x0003b4,[CaseTitle] = 0x000394,[CaseUpper] = 0x000394,[CaseFold] = 0x0003b4}, NULL},
	{0x000395, {[CaseLower] = 0x0003b5,[CaseTitle] = 0x000395,[CaseUpper] = 0x000395,[CaseFold] = 0x0003b5}, NULL},
	{0x000396, {[CaseLower] = 0x0003b6,[CaseTitle] = 0x000396,[CaseUpper] = 0x000396,[CaseFold] = 0x0003b6}, NULL},
	{0x000397, {[CaseLower] = 0x0003b7,[CaseTitle] = 0x000397,[CaseUpper] = 0x000397,[CaseFold] = 0x0003b7}, NULL},
	{0x000398, {[CaseLower] = 0x0003b8,[CaseTitle] = 0x000398,[CaseUpper] = 0x000398,[CaseFold] = 0x0003b8}, NULL},
	{0x000399, {[CaseLower] = 0x0003b9,[CaseTitle] = 0x000399,[CaseUpper] = 0x000399,[CaseFold] = 0x0003b9}, NULL},
	{0x00039a, {[CaseLower] = 0x0003ba,[CaseTitle] = 0x00039a,[CaseUpper] = 0x00039a,[CaseFold] = 0x0003ba}, NULL},
	{0x00039b, {[CaseLower] = 0x0003bb,[CaseTitle] = 0x00039b,[CaseUpper] = 0x00039b,[CaseFold] = 0x0003bb}, NULL},
	{0x00039c, {[CaseLower] = 0x0003bc,[CaseTitle] = 0x00039c,[CaseUpper] = 0x00039c,[CaseFold] = 0x0003bc}, NULL},
	{0x00039d, {[CaseLower] = 0x0003bd,[CaseTitle] = 0x00039d,[CaseUpper] = 0x00039d,[CaseFold] = 0x0003bd}, NULL},
	{0x00039e, {[CaseLower] = 0x0003be,[CaseTitle] = 0x00039e,[CaseUpper] = 0x00039e,[CaseFold] = 0x0003be}, NULL},
	{0x00039f, {[CaseLower] = 0x0003bf,[CaseTitle] = 0x00039f,[CaseUpper] = 0x00039f,[CaseFold] = 0x0003bf}, NULL},
	{0x0003a0, {[CaseLower] = 0x0003c0,[CaseTitle] = 0x0003a0,[CaseUpper] = 0x0003a0,[CaseFold] = 0x0003c0}, NULL},
	{0x0003a1, {[CaseLower] = 0x0003c1,[CaseTitle] = 0x0003a1,[CaseUpper] = 0x0003a1,[CaseFold] = 0x0003c1}, NULL},
	{0x0003a3, {[CaseLower] = 0x0003c3,[CaseTitle] = 0x0003a3,[CaseUpper] = 0x0003a3,[CaseFold] = 0x0003c3}, &special_case[5]},
	{0x0003a4, {[CaseLower] = 0x0003c4,[CaseTitle] = 0x0003a4,[CaseUpper] = 0x0003a4,[CaseFold] = 0x0003c4}, NULL},
	{0x0003a5, {[CaseLower] = 0x0003c5,[CaseTitle] = 0x0003a5,[CaseUpper] = 0x0003a5,[CaseFold] = 0x0003c5}, NULL},
	{0x0003a6, {[CaseLower] = 0x0003c6,[CaseTitle] = 0x0003a6,[CaseUpper] = 0x0003a6,[CaseFold] = 0x0003c6}, NULL},
	{0x0003a7, {[CaseLower] = 0x0003c7,[CaseTitle] = 0x0003a7,[CaseUpper] = 0x0003a7,[CaseFold] = 0x0003c7}, NULL},
	{0x0003a8, {[CaseLower] = 0x0003c8,[CaseTitle] = 0x0003a8,[CaseUpper] = 0x0003a8,[CaseFold] = 0x0003c8}, NULL},
	{0x0003a9, {[CaseLower] = 0x0003c9,[CaseTitle] = 0x0003a9,[CaseUpper] = 0x0003a9,[CaseFold] = 0x0003c9}, NULL},
	{0x0003aa, {[CaseLower] = 0x0003ca,[CaseTitle] = 0x0003aa,[CaseUpper] = 0x0003aa,[CaseFold] = 0x0003ca}, NULL},
	{0x0003ab, {[CaseLower] = 0x0003cb,[CaseTitle] = 0x0003ab,[CaseUpper] = 0x0003ab,[CaseFold] = 0x0003cb}, NULL},
	{0x0003ac, {[CaseLower] = 0x0003ac,[CaseTitle] = 0x000386,[CaseUpper] = 0x000386,[CaseFold] = 0x0003ac}, NULL},
	{0x0003ad, {[CaseLower] = 0x0003ad,[CaseTitle] = 0x000388,[CaseUpper] = 0x000388,[CaseFold] = 0x0003ad}, NULL},
	{0x0003ae, {[CaseLower] = 0x0003ae,[CaseTitle] = 0x000389,[CaseUpper] = 0x000389,[CaseFold] = 0x0003ae}, NULL},
	{0x0003af, {[CaseLower] = 0x0003af,[CaseTitle] = 0x00038a,[CaseUpper] = 0x00038a,[CaseFold] = 0x0003af}, NULL},
	{0x0003b0, {[CaseLower] = 0x0003b0,[CaseTitle] = 0x0003b0,[CaseUpper] = 0x0003b0,[CaseFold] = 0x0003b0}, &special_case[6]},
	{0x0003b1, {[CaseLower] = 0x0003b1,[CaseTitle] = 0x000391,[CaseUpper] = 0x000391,[CaseFold] = 0x0003b1}, NULL},
	{0x0003b2, {[CaseLower] = 0x0003b2,[CaseTitle] = 0x000392,[CaseUpper] = 0x000392,[CaseFold] = 0x0003b2}, NULL},
	{0x0003b3, {[CaseLower] = 0x0003b3,[CaseTitle] = 0x000393,[CaseUpper] = 0x000393,[CaseFold] = 0x0003b3}, NULL},
	{0x0003b4, {[CaseLower] = 0x0003b4,[CaseTitle] = 0x000394,[CaseUpper] = 0x000394,[CaseFold] = 0x0003b4}, NULL},
	{0x0003b5, {[CaseLower] = 0x0003b5,[CaseTitle] = 0x000395,[CaseUpper] = 0x000395,[CaseFold] = 0x0003b5}, NULL},
	{0x0003b6, {[CaseLower] = 0x0003b6,[CaseTitle] = 0x000396,[CaseUpper] = 0x000396,[CaseFold] = 0x0003b6}, NULL},
	{0x0003b7, {[CaseLower] = 0x0003b7,[CaseTitle] = 0x000397,[CaseUpper] = 0x000397,[CaseFold] = 0x0003b7}, NULL},
	{0x0003b8, {[CaseLower] = 0x0003b8,[CaseTitle] = 0x000398,[CaseUpper] = 0x000398,[CaseFold] = 0x0003b8}, NULL},
	{0x0003b9, {[CaseLower] = 0x0003b9,[CaseTitle] = 0x000399,[CaseUpper] = 0x000399,[CaseFold] = 0x0003b9}, NULL},
	{0x0003ba, {[CaseLower] = 0x0003ba,[CaseTitle] = 0x00039a,[CaseUpper] = 0x00039a,[CaseFold] = 0x0003ba}, NULL},
	{0x0003bb, {[CaseLower] = 0x0003bb,[CaseTitle] = 0x00039b,[CaseUpper] = 0x00039b,[CaseFold] = 0x0003bb}, NULL},
	{0x0003bc, {[CaseLower] = 0x0003bc,[CaseTitle] = 0x00039c,[CaseUpper] = 0x00039c,[CaseFold] = 0x0003bc}, NULL},
	{0x0003bd, {[CaseLower] = 0x0003bd,[CaseTitle] = 0x00039d,[CaseUpper] = 0x00039d,[CaseFold] = 0x0003bd}, NULL},
	{0x0003be, {[CaseLower] = 0x0003be,[CaseTitle] = 0x00039e,[CaseUpper] = 0x00039e,[CaseFold] = 0x0003be}, NULL},
	{0x0003bf, {[CaseLower] = 0x0003bf,[CaseTitle] = 0x00039f,[CaseUpper] = 0x00039f,[CaseFold] = 0x0003bf}, NULL},
	{0x0003c0, {[CaseLower] = 0x0003c0,[CaseTitle] = 0x0003a0,[CaseUpper] = 0x0003a0,[CaseFold] = 0x0003c0}, NULL},
	{0x0003c1, {[CaseLower] = 0x0003c1,[CaseTitle] = 0x0003a1,[CaseUpper] = 0x0003a1,[CaseFold] = 0x0003c1}, NULL},
	{0x0003c2, {[CaseLower] = 0x0003c2,[CaseTitle] = 0x0003a3,[CaseUpper] = 0x0003a3,[CaseFold] = 0x0003c3}, NULL},
	{0x0003c3, {[CaseLower] = 0x0003c3,[CaseTitle] = 0x0003a3,[CaseUpper] = 0x0003a3,[CaseFold] = 0x0003c3}, NULL},
	{0x0003c4, {[CaseLower] = 0x0003c4,[CaseTitle] = 0x0003a4,[CaseUpper] = 0x0003a4,[CaseFold] = 0x0003c4}, NULL},
	{0x0003c5, {[CaseLower] = 0x0003c5,[CaseTitle] = 0x0003a5,[CaseUpper] = 0x0003a5,[CaseFold] = 0x0003c5}, NULL},
	{0x0003c6, {[CaseLower] = 0x0003c6,[CaseTitle] = 0x0003a6,[CaseUpper] = 0x0003a6,[CaseFold] = 0x0003c6}, NULL},
	{0x0003c7, {[CaseLower] = 0x0003c7,[CaseTitle] = 0x0003a7,[CaseUpper] = 0x0003a7,[CaseFold] = 0x0003c7}, NULL},
	{0x0003c8, {[CaseLower] = 0x0003c8,[CaseTitle] = 0x0003a8,[CaseUpper] = 0x0003a8,[CaseFold] = 0x0003c8}, NULL},
	{0x0003c9, {[CaseLower] = 0x0003c9,[CaseTitle] = 0x0003a9,[CaseUpper] = 0x0003a9,[CaseFold] = 0x0003c9}, NULL},
	{0x0003ca, {[CaseLower] = 0x0003ca,[CaseTitle] = 0x0003aa,[CaseUpper] = 0x0003aa,[CaseFold] = 0x0003ca}, NULL},
	{0x0003cb, {[CaseLower] = 0x0003cb,[CaseTitle] = 0x0003ab,[CaseUpper] = 0x0003ab,[CaseFold] = 0x0003cb}, NULL},
	{0x0003cc, {[CaseLower] = 0x0003cc,[CaseTitle] = 0x00038c,[CaseUpper] = 0x00038c,[CaseFold] = 0x0003cc}, NULL},
	{0x0003cd, {[CaseLower] = 0x0003cd,[CaseTitle] = 0x00038e,[CaseUpper] = 0x00038e,[CaseFold] = 0x0003cd}, NULL},
	{0x0003ce, {[CaseLower] = 0x0003ce,[CaseTitle] = 0x00038f,[CaseUpper] = 0x00038f,[CaseFold] = 0x0003ce}, NULL},
	{0x0003cf, {[CaseLower] = 0x0003d7,[CaseTitle] = 0x0003cf,[CaseUpper] = 0x0003cf,[CaseFold] = 0x0003d7}, NULL},
	{0x0003d0, {[CaseLower] = 0x0003d0,[CaseTitle] = 0x000392,[CaseUpper] = 0x000392,[CaseFold] = 0x0003b2}, NULL},
	{0x0003d1, {[CaseLower] = 0x0003d1,[CaseTitle] = 0x000398,[CaseUpper] = 0x000398,[CaseFold] = 0x0003b8}, NULL},
	{0x0003d5, {[CaseLower] = 0x0003d5,[CaseTitle] = 0x0003a6,[CaseUpper] = 0x0003a6,[CaseFold] = 0x0003c6}, NULL},
	{0x0003d6, {[CaseLower] = 0x0003d6,[CaseTitle] = 0x0003a0,[CaseUpper] = 0x0003a0,[CaseFold] = 0x0003c0}, NULL},
	{0x0003d7, {[CaseLower] = 0x0003d7,[CaseTitle] = 0x0003cf,[CaseUpper] = 0x0003cf,[CaseFold] = 0x0003d7}, NULL},
	{0x0003d8, {[CaseLower] = 0x0003d9,[CaseTitle] = 0x0003d8,[CaseUpper] = 0x0003d8,[CaseFold] = 0x0003d9}, NULL},
	{0x0003d9, {[CaseLower] = 0x0003d9,[CaseTitle] = 0x0003d8,[CaseUpper] = 0x0003d8,[CaseFold] = 0x0003d9}, NULL},
	{0x0003da, {[CaseLower] = 0x0003db,[CaseTitle] = 0x0003da,[CaseUpper] = 0x0003da,[CaseFold] = 0x0003db}, NULL},
	{0x0003db, {[CaseLower] = 0x0003db,[CaseTitle] = 0x0003da,[CaseUpper] = 0x0003da,[CaseFold] = 0x0003db}, NULL},
	{0x0003dc, {[CaseLower] = 0x0003dd,[CaseTitle] = 0x0003dc,[CaseUpper] = 0x0003dc,[CaseFold] = 0x0003dd}, NULL},
	{0x0003dd, {[CaseLower] = 0x0003dd,[CaseTitle] = 0x0003dc,[CaseUpper] = 0x0003dc,[CaseFold] = 0x0003dd}, NULL},
	{0x0003de, {[CaseLower] = 0x0003df,[CaseTitle] = 0x0003de,[CaseUpper] = 0x0003de,[CaseFold] = 0x0003df}, NULL},
	{0x0003df, {[CaseLower] = 0x0003df,[CaseTitle] = 0x0003de,[CaseUpper] = 0x0003de,[CaseFold] = 0x0003df}, NULL},
	{0x0003e0, {[CaseLower] = 0x0003e1,[CaseTitle] = 0x0003e0,[CaseUpper] = 0x0003e0,[CaseFold] = 0x0003e1}, NULL},
	{0x0003e1, {[CaseLower] = 0x0003e1,[CaseTitle] = 0x0003e0,[CaseUpper] = 0x0003e0,[CaseFold] = 0x0003e1}, NULL},
	{0x0003e2, {[CaseLower] = 0x0003e3,[CaseTitle] = 0x0003e2,[CaseUpper] = 0x0003e2,[CaseFold] = 0x0003e3}, NULL},
	{0x0003e3, {[CaseLower] = 0x0003e3,[CaseTitle] = 0x0003e2,[CaseUpper] = 0x0003e2,[CaseFold] = 0x0003e3}, NULL},
	{0x0003e4, {[CaseLower] = 0x0003e5,[CaseTitle] = 0x0003e4,[CaseUpper] = 0x0003e4,[CaseFold] = 0x0003e5}, NULL},
	{0x0003e5, {[CaseLower] = 0x0003e5,[CaseTitle] = 0x0003e4,[CaseUpper] = 0x0003e4,[CaseFold] = 0x0003e5}, NULL},
	{0x0003e6, {[CaseLower] = 0x0003e7,[CaseTitle] = 0x0003e6,[CaseUpper] = 0x0003e6,[CaseFold] = 0x0003e7}, NULL},
	{0x0003e7, {[CaseLower] = 0x0003e7,[CaseTitle] = 0x0003e6,[CaseUpper] = 0x0003e6,[CaseFold] = 0x0003e7}, NULL},
	{0x0003e8, {[CaseLower] = 0x0003e9,[CaseTitle] = 0x0003e8,[CaseUpper] = 0x0003e8,[CaseFold] = 0x0003e9}, NULL},
	{0x0003e9, {[CaseLower] = 0x0003e9,[CaseTitle] = 0x0003e8,[CaseUpper] = 0x0003e8,[CaseFold] = 0x0003e9}, NULL},
	{0x0003ea, {[CaseLower] = 0x0003eb,[CaseTitle] = 0x0003ea,[CaseUpper] = 0x0003ea,[CaseFold] = 0x0003eb}, NULL},
	{0x0003eb, {[CaseLower] = 0x0003eb,[CaseTitle] = 0x0003ea,[CaseUpper] = 0x0003ea,[CaseFold] = 0x0003eb}, NULL},
	{0x0003ec, {[CaseLower] = 0x0003ed,[CaseTitle] = 0x0003ec,[CaseUpper] = 0x0003ec,[CaseFold] = 0x0003ed}, NULL},
	{0x0003ed, {[CaseLower] = 0x0003ed,[CaseTitle] = 0x0003ec,[CaseUpper] = 0x0003ec,[CaseFold] = 0x0003ed}, NULL},
	{0x0003ee, {[CaseLower] = 0x0003ef,[CaseTitle] = 0x0003ee,[CaseUpper] = 0x0003ee,[CaseFold] = 0x0003ef}, NULL},
	{0x0003ef, {[CaseLower] = 0x0003ef,[CaseTitle] = 0x0003ee,[CaseUpper] = 0x0003ee,[CaseFold] = 0x0003ef}, NULL},
	{0x0003f0, {[CaseLower] = 0x0003f0,[CaseTitle] = 0x00039a,[CaseUpper] = 0x00039a,[CaseFold] = 0x0003ba}, NULL},
	{0x0003f1, {[CaseLower] = 0x0003f1,[CaseTitle] = 0x0003a1,[CaseUpper] = 0x0003a1,[CaseFold] = 0x0003c1}, NULL},
	{0x0003f2, {[CaseLower] = 0x0003f2,[CaseTitle] = 0x0003f9,[CaseUpper] = 0x0003f9,[CaseFold] = 0x0003f2}, NULL},
	{0x0003f3, {[CaseLower] = 0x0003f3,[CaseTitle] = 0x00037f,[CaseUpper] = 0x00037f,[CaseFold] = 0x0003f3}, NULL},
	{0x0003f4, {[CaseLower] = 0x0003b8,[CaseTitle] = 0x0003f4,[CaseUpper] = 0x0003f4,[CaseFold] = 0x0003b8}, NULL},
	{0x0003f5, {[CaseLower] = 0x0003f5,[CaseTitle] = 0x000395,[CaseUpper] = 0x000395,[CaseFold] = 0x0003b5}, NULL},
	{0x0003f7, {[CaseLower] = 0x0003f8,[CaseTitle] = 0x0003f7,[CaseUpper] = 0x0003f7,[CaseFold] = 0x0003f8}, NULL},
	{0x0003f8, {[CaseLower] = 0x0003f8,[CaseTitle] = 0x0003f7,[CaseUpper] = 0x0003f7,[CaseFold] = 0x0003f8}, NULL},
	{0x0003f9, {[CaseLower] = 0x0003f2,[CaseTitle] = 0x0003f9,[CaseUpper] = 0x0003f9,[CaseFold] = 0x0003f2}, NULL},
	{0x0003fa, {[CaseLower] = 0x0003fb,[CaseTitle] = 0x0003fa,[CaseUpper] = 0x0003fa,[CaseFold] = 0x0003fb}, NULL},
	{0x0003fb, {[CaseLower] = 0x0003fb,[CaseTitle] = 0x0003fa,[CaseUpper] = 0x0003fa,[CaseFold] = 0x0003fb}, NULL},
	{0x0003fd, {[CaseLower] = 0x00037b,[CaseTitle] = 0x0003fd,[CaseUpper] = 0x0003fd,[CaseFold] = 0x00037b}, NULL},
	{0x0003fe, {[CaseLower] = 0x00037c,[CaseTitle] = 0x0003fe,[CaseUpper] = 0x0003fe,[CaseFold] = 0x00037c}, NULL},
	{0x0003ff, {[CaseLower] = 0x00037d,[CaseTitle] = 0x0003ff,[CaseUpper] = 0x0003ff,[CaseFold] = 0x00037d}, NULL},
	{0x000400, {[CaseLower] = 0x000450,[CaseTitle] = 0x000400,[CaseUpper] = 0x000400,[CaseFold] = 0x000450}, NULL},
	{0x000401, {[CaseLower] = 0x000451,[CaseTitle] = 0x000401,[CaseUpper] = 0x000401,[CaseFold] = 0x000451}, NULL},
	{0x000402, {[CaseLower] = 0x000452,[CaseTitle] = 0x000402,[CaseUpper] = 0x000402,[CaseFold] = 0x000452}, NULL},
	{0x000403, {[CaseLower] = 0x000453,[CaseTitle] = 0x000403,[CaseUpper] = 0x000403,[CaseFold] = 0x000453}, NULL},
	{0x000404, {[CaseLower] = 0x000454,[CaseTitle] = 0x000404,[CaseUpper] = 0x000404,[CaseFold] = 0x000454}, NULL},
	{0x000405, {[CaseLower] = 0x000455,[CaseTitle] = 0x000405,[CaseUpper] = 0x000405,[CaseFold] = 0x000455}, NULL},
	{0x000406, {[CaseLower] = 0x000456,[CaseTitle] = 0x000406,[CaseUpper] = 0x000406,[CaseFold] = 0x000456}, NULL},
	{0x000407, {[CaseLower] = 0x000457,[CaseTitle] = 0x000407,[CaseUpper] = 0x000407,[CaseFold] = 0x000457}, NULL},
	{0x000408, {[CaseLower] = 0x000458,[CaseTitle] = 0x000408,[CaseUpper] = 0x000408,[CaseFold] = 0x000458}, NULL},
	{0x000409, {[CaseLower] = 0x000459,[CaseTitle] = 0x000409,[CaseUpper] = 0x000409,[CaseFold] = 0x000459}, NULL},
	{0x00040a, {[CaseLower] = 0x00045a,[CaseTitle] = 0x00040a,[CaseUpper] = 0x00040a,[CaseFold] = 0x00045a}, NULL},
	{0x00040b, {[CaseLower] = 0x00045b,[CaseTitle] = 0x00040b,[CaseUpper] = 0x00040b,[CaseFold] = 0x00045b}, NULL},
	{0x00040c, {[CaseLower] = 0x00045c,[CaseTitle] = 0x00040c,[CaseUpper] = 0x00040c,[CaseFold] = 0x00045c}, NULL},
	{0x00040d, {[CaseLower] = 0x00045d,[CaseTitle] = 0x00040d,[CaseUpper] = 0x00040d,[CaseFold] = 0x00045d}, NULL},
	{0x00040e, {[CaseLower] = 0x00045e,[CaseTitle] = 0x00040e,[CaseUpper] = 0x00040e,[CaseFold] = 0x00045e}, NULL},
	{0x00040f, {[CaseLower] = 0x00045f,[CaseTitle] = 0x00040f,[CaseUpper] = 0x00040f,[CaseFold] = 0x00045f}, NULL},
	{0x000410, {[CaseLower] = 0x000430,[CaseTitle] = 0x000410,[CaseUpper] = 0x000410,[CaseFold] = 0x000430}, NULL},
	{0x000411, {[CaseLower] = 0x000431,[CaseTitle] = 0x000411,[CaseUpper] = 0x000411,[CaseFold] = 0x000431}, NULL},
	{0x000412, {[CaseLower] = 0x000432,[CaseTitle] = 0x000412,[CaseUpper] = 0x000412,[CaseFold] = 0x000432}, NULL},
	{0x000413, {[CaseLower] = 0x000433,[CaseTitle] = 0x000413,[CaseUpper] = 0x000413,[CaseFold] = 0x000433}, NULL},
	{0x000414, {[CaseLower] = 0x000434,[CaseTitle] = 0x000414,[CaseUpper] = 0x000414,[CaseFold] = 0x000434}, NULL},
	{0x000415, {[CaseLower] = 0x000435,[CaseTitle] = 0x000415,[CaseUpper] = 0x000415,[CaseFold] = 0x000435}, NULL},
	{0x000416, {[CaseLower] = 0x000436,[CaseTitle] = 0x000416,[CaseUpper] = 0x000416,[CaseFold] = 0x000436}, NULL},
	{0x000417, {[CaseLower] = 0x000437,[CaseTitle] = 0x000417,[CaseUpper] = 0x000417,[CaseFold] = 0x000437}, NULL},
	{0x000418, {[CaseLower] = 0x000438,[CaseTitle] = 0x000418,[CaseUpper] = 0x000418,[CaseFold] = 0x000438}, NULL},
	{0x000419, {[CaseLower] = 0x000439,[CaseTitle] = 0x000419,[CaseUpper] = 0x000419,[CaseFold] = 0x000439}, NULL},
	{0x00041a, {[CaseLower] = 0x00043a,[CaseTitle] = 0x00041a,[CaseUpper] = 0x00041a,[CaseFold] = 0x00043a}, NULL},
	{0x00041b, {[CaseLower] = 0x00043b,[CaseTitle] = 0x00041b,[CaseUpper] = 0x00041b,[CaseFold] = 0x00043b}, NULL},
	{0x00041c, {[CaseLower] = 0x00043c,[CaseTitle] = 0x00041c,[CaseUpper] = 0x00041c,[CaseFold] = 0x00043c}, NULL},
	{0x00041d, {[CaseLower] = 0x00043d,[CaseTitle] = 0x00041d,[CaseUpper] = 0x00041d,[CaseFold] = 0x00043d}, NULL},
	{0x00041e, {[CaseLower] = 0x00043e,[CaseTitle] = 0x00041e,[CaseUpper] = 0x00041e,[CaseFold] = 0x00043e}, NULL},
	{0x00041f, {[CaseLower] = 0x00043f,[CaseTitle] = 0x00041f,[CaseUpper] = 0x00041f,[CaseFold] = 0x00043f}, NULL},
	{0x000420, {[CaseLower] = 0x000440,[CaseTitle] = 0x000420,[CaseUpper] = 0x000420,[CaseFold] = 0x000440}, NULL},
	{0x000421, {[CaseLower] = 0x000441,[CaseTitle] = 0x000421,[CaseUpper] = 0x000421,[CaseFold] = 0x000441}, NULL},
	{0x000422, {[CaseLower] = 0x000442,[CaseTitle] = 0x000422,[CaseUpper] = 0x000422,[CaseFold] = 0x000442}, NULL},
	{0x000423, {[CaseLower] = 0x000443,[CaseTitle] = 0x000423,[CaseUpper] = 0x000423,[CaseFold] = 0x000443}, NULL},
	{0x000424, {[CaseLower] = 0x000444,[CaseTitle] = 0x000424,[CaseUpper] = 0x000424,[CaseFold] = 0x000444}, NULL},
	{0x000425, {[CaseLower] = 0x000445,[CaseTitle] = 0x000425,[CaseUpper] = 0x000425,[CaseFold] = 0x000445}, NULL},
	{0x000426, {[CaseLower] = 0x000446,[CaseTitle] = 0x000426,[CaseUpper] = 0x000426,[CaseFold] = 0x000446}, NULL},
	{0x000427, {[CaseLower] = 0x000447,[CaseTitle] = 0x000427,[CaseUpper] = 0x000427,[CaseFold] = 0x000447}, NULL},
	{0x000428, {[CaseLower] = 0x000448,[CaseTitle] = 0x000428,[CaseUpper] = 0x000428,[CaseFold] = 0x000448}, NULL},
	{0x000429, {[CaseLower] = 0x000449,[CaseTitle] = 0x000429,[CaseUpper] = 0x000429,[CaseFold] = 0x000449}, NULL},
	{0x00042a, {[CaseLower] = 0x00044a,[CaseTitle] = 0x00042a,[CaseUpper] = 0x00042a,[CaseFold] = 0x00044a}, NULL},
	{0x00042b, {[CaseLower] = 0x00044b,[CaseTitle] = 0x00042b,[CaseUpper] = 0x00042b,[CaseFold] = 0x00044b}, NULL},
	{0x00042c, {[CaseLower] = 0x00044c,[CaseTitle] = 0x00042c,[CaseUpper] = 0x00042c,[CaseFold] = 0x00044c}, NULL},
	{0x00042d, {[CaseLower] = 0x00044d,[CaseTitle] = 0x00042d,[CaseUpper] = 0x00042d,[CaseFold] = 0x00044d}, NULL},
	{0x00042e, {[CaseLower] = 0x00044e,[CaseTitle] = 0x00042e,[CaseUpper] = 0x00042e,[CaseFold] = 0x00044e}, NULL},
	{0x00042f, {[CaseLower] = 0x00044f,[CaseTitle] = 0x00042f,[CaseUpper] = 0x00042f,[CaseFold] = 0x00044f}, NULL},
	{0x000430, {[CaseLower] = 0x000430,[CaseTitle] = 0x000410,[CaseUpper] = 0x000410,[CaseFold] = 0x000430}, NULL},
	{0x000431, {[CaseLower] = 0x000431,[CaseTitle] = 0x000411,[CaseUpper] = 0x000411,[CaseFold] = 0x000431}, NULL},
	{0x000432, {[CaseLower] = 0x000432,[CaseTitle] = 0x000412,[CaseUpper] = 0x000412,[CaseFold] = 0x000432}, NULL},
	{0x000433, {[CaseLower] = 0x000433,[CaseTitle] = 0x000413,[CaseUpper] = 0x000413,[CaseFold] = 0x000433}, NULL},
	{0x000434, {[CaseLower] = 0x000434,[CaseTitle] = 0x000414,[CaseUpper] = 0x000414,[CaseFold] = 0x000434}, NULL},
	{0x000435, {[CaseLower] = 0x000435,[CaseTitle] = 0x000415,[CaseUpper] = 0x000415,[CaseFold] = 0x000435}, NULL},
	{0x000436, {[CaseLower] = 0x000436,[CaseTitle] = 0x000416,[CaseUpper] = 0x000416,[CaseFold] = 0x000436}, NULL},
	{0x000437, {[CaseLower] = 0x000437,[CaseTitle] = 0x000417,[CaseUpper] = 0x000417,[CaseFold] = 0x000437}, NULL},
	{0x000438, {[CaseLower] = 0x000438,[CaseTitle] = 0x000418,[CaseUpper] = 0x000418,[CaseFold] = 0x000438}, NULL},
	{0x000439, {[CaseLower] = 0x000439,[CaseTitle] = 0x000419,[CaseUpper] = 0x000419,[CaseFold] = 0x000439}, NULL},
	{0x00043a, {[CaseLower] = 0x00043a,[CaseTitle] = 0x00041a,[CaseUpper] = 0x00041a,[CaseFold] = 0x00043a}, NULL},
	{0x00043b, {[CaseLower] = 0x00043b,[CaseTitle] = 0x00041b,[CaseUpper] = 0x00041b,[CaseFold] = 0x00043b}, NULL},
	{0x00043c, {[CaseLower] = 0x00043c,[CaseTitle] = 0x00041c,[CaseUpper] = 0x00041c,[CaseFold] = 0x00043c}, NULL},
	{0x00043d, {[CaseLower] = 0x00043d,[CaseTitle] = 0x00041d,[CaseUpper] = 0x00041d,[CaseFold] = 0x00043d}, NULL},
	{0x00043e, {[CaseLower] = 0x00043e,[CaseTitle] = 0x00041e,[CaseUpper] = 0x00041e,[CaseFold] = 0x00043e}, NULL},
	{0x00043f, {[CaseLower] = 0x00043f,[CaseTitle] = 0x00041f,[CaseUpper] = 0x00041f,[CaseFold] = 0x00043f}, NULL},
	{0x000440, {[CaseLower] = 0x000440,[CaseTitle] = 0x000420,[CaseUpper] = 0x000420,[CaseFold] = 0x000440}, NULL},
	{0x000441, {[CaseLower] = 0x000441,[CaseTitle] = 0x000421,[CaseUpper] = 0x000421,[CaseFold] = 0x000441}, NULL},
	{0x000442, {[CaseLower] = 0x000442,[CaseTitle] = 0x000422,[CaseUpper] = 0x000422,[CaseFold] = 0x000442}, NULL},
	{0x000443, {[CaseLower] = 0x000443,[CaseTitle] = 0x000423,[CaseUpper] = 0x000423,[CaseFold] = 0x000443}, NULL},
	{0x000444, {[CaseLower] = 0x000444,[CaseTitle] = 0x000424,[CaseUpper] = 0x000424,[CaseFold] = 0x000444}, NULL},
	{0x000445, {[CaseLower] = 0x000445,[CaseTitle] = 0x000425,[CaseUpper] = 0x000425,[CaseFold] = 0x000445}, NULL},
	{0x000446, {[CaseLower] = 0x000446,[CaseTitle] = 0x000426,[CaseUpper] = 0x000426,[CaseFold] = 0x000446}, NULL},
	{0x000447, {[CaseLower] = 0x000447,[CaseTitle] = 0x000427,[CaseUpper] = 0x000427,[CaseFold] = 0x000447}, NULL},
	{0x000448, {[CaseLower] = 0x000448,[CaseTitle] = 0x000428,[CaseUpper] = 0x000428,[CaseFold] = 0x000448}, NULL},
	{0x000449, {[CaseLower] = 0x000449,[CaseTitle] = 0x000429,[CaseUpper] = 0x000429,[CaseFold] = 0x000449}, NULL},
	{0x00044a, {[CaseLower] = 0x00044a,[CaseTitle] = 0x00042a,[CaseUpper] = 0x00042a,[CaseFold] = 0x00044a}, NULL},
	{0x00044b, {[CaseLower] = 0x00044b,[CaseTitle] = 0x00042b,[CaseUpper] = 0x00042b,[CaseFold] = 0x00044b}, NULL},
	{0x00044c, {[CaseLower] = 0x00044c,[CaseTitle] = 0x00042c,[CaseUpper] = 0x00042c,[CaseFold] = 0x00044c}, NULL},
	{0x00044d, {[CaseLower] = 0x00044d,[CaseTitle] = 0x00042d,[CaseUpper] = 0x00042d,[CaseFold] = 0x00044d}, NULL},
	{0x00044e, {[CaseLower] = 0x00044e,[CaseTitle] = 0x00042e,[CaseUpper] = 0x00042e,[CaseFold] = 0x00044e}, NULL},
	{0x00044f, {[CaseLower] = 0x00044f,[CaseTitle] = 0x00042f,[CaseUpper] = 0x00042f,[CaseFold] = 0x00044f}, NULL},
	{0x000450, {[CaseLower] = 0x000450,[CaseTitle] = 0x000400,[CaseUpper] = 0x000400,[CaseFold] = 0x000450}, NULL},
	{0x000451, {[CaseLower] = 0x000451,[CaseTitle] = 0x000401,[CaseUpper] = 0x000401,[CaseFold] = 0x000451}, NULL},
	{0x000452, {[CaseLower] = 0x000452,[CaseTitle] = 0x000402,[CaseUpper] = 0x000402,[CaseFold] = 0x000452}, NULL},
	{0x000453, {[CaseLower] = 0x000453,[CaseTitle] = 0x000403,[CaseUpper] = 0x000403,[CaseFold] = 0x000453}, NULL},
	{0x000454, {[CaseLower] = 0x000454,[CaseTitle] = 0x000404,[CaseUpper] = 0x000404,[CaseFold] = 0x000454}, NULL},
	{0x000455, {[CaseLower] = 0x000455,[CaseTitle] = 0x000405,[CaseUpper] = 0x000405,[CaseFold] = 0x000455}, NULL},
	{0x000456, {[CaseLower] = 0x000456,[CaseTitle] = 0x000406,[CaseUpper] = 0x000406,[CaseFold] = 0x000456}, NULL},
	{0x000457, {[CaseLower] = 0x000457,[CaseTitle] = 0x000407,[CaseUpper] = 0x000407,[CaseFold] = 0x000457}, NULL},
	{0x000458, {[CaseLower] = 0x000458,[CaseTitle] = 0x000408,[CaseUpper] = 0x000408,[CaseFold] = 0x000458}, NULL},
	{0x000459, {[CaseLower] = 0x000459,[CaseTitle] = 0x000409,[CaseUpper] = 0x000409,[CaseFold] = 0x000459}, NULL},
	{0x00045a, {[CaseLower] = 0x00045a,[CaseTitle] = 0x00040a,[CaseUpper] = 0x00040a,[CaseFold] = 0x00045a}, NULL},
	{0x00045b, {[CaseLower] = 0x00045b,[CaseTitle] = 0x00040b,[CaseUpper] = 0x00040b,[CaseFold] = 0x00045b}, NULL},
	{0x00045c, {[CaseLower] = 0x00045c,[CaseTitle] = 0x00040c,[CaseUpper] = 0x00040c,[CaseFold] = 0x00045c}, NULL},
	{0x00045d, {[CaseLower] = 0x00045d,[CaseTitle] = 0x00040d,[CaseUpper] = 0x00040d,[CaseFold] = 0x00045d}, NULL},
	{0x00045e, {[CaseLower] = 0x00045e,[CaseTitle] = 0x00040e,[CaseUpper] = 0x00040e,[CaseFold] = 0x00045e}, NULL},
	{0x00045f, {[CaseLower] = 0x00045f,[CaseTitle] = 0x00040f,[CaseUpper] = 0x00040f,[CaseFold] = 0x00045f}, NULL},
	{0x000460, {[CaseLower] = 0x000461,[CaseTitle] = 0x000460,[CaseUpper] = 0x000460,[CaseFold] = 0x000461}, NULL},
	{0x000461, {[CaseLower] = 0x000461,[CaseTitle] = 0x000460,[CaseUpper] = 0x000460,[CaseFold] = 0x000461}, NULL},
	{0x000462, {[CaseLower] = 0x000463,[CaseTitle] = 0x000462,[CaseUpper] = 0x000462,[CaseFold] = 0x000463}, NULL},
	{0x000463, {[CaseLower] = 0x000463,[CaseTitle] = 0x000462,[CaseUpper] = 0x000462,[CaseFold] = 0x000463}, NULL},
	{0x000464, {[CaseLower] = 0x000465,[CaseTitle] = 0x000464,[CaseUpper] = 0x000464,[CaseFold] = 0x000465}, NULL},
	{0x000465, {[CaseLower] = 0x000465,[CaseTitle] = 0x000464,[CaseUpper] = 0x000464,[CaseFold] = 0x000465}, NULL},
	{0x000466, {[CaseLower] = 0x000467,[CaseTitle] = 0x000466,[CaseUpper] = 0x000466,[CaseFold] = 0x000467}, NULL},
	{0x000467, {[CaseLower] = 0x000467,[CaseTitle] = 0x000466,[CaseUpper] = 0x000466,[CaseFold] = 0x000467}, NULL},
	{0x000468, {[CaseLower] = 0x000469,[CaseTitle] = 0x000468,[CaseUpper] = 0x000468,[CaseFold] = 0x000469}, NULL},
	{0x000469, {[CaseLower] = 0x000469,[CaseTitle] = 0x000468,[CaseUpper] = 0x000468,[CaseFold] = 0x000469}, NULL},
	{0x00046a, {[CaseLower] = 0x00046b,[CaseTitle] = 0x00046a,[CaseUpper] = 0x00046a,[CaseFold] = 0x00046b}, NULL},
	{0x00046b, {[CaseLower] = 0x00046b,[CaseTitle] = 0x00046a,[CaseUpper] = 0x00046a,[CaseFold] = 0x00046b}, NULL},
	{0x00046c, {[CaseLower] = 0x00046d,[CaseTitle] = 0x00046c,[CaseUpper] = 0x00046c,[CaseFold] = 0x00046d}, NULL},
	{0x00046d, {[CaseLower] = 0x00046d,[CaseTitle] = 0x00046c,[CaseUpper] = 0x00046c,[CaseFold] = 0x00046d}, NULL},
	{0x00046e, {[CaseLower] = 0x00046f,[CaseTitle] = 0x00046e,[CaseUpper] = 0x00046e,[CaseFold] = 0x00046f}, NULL},
	{0x00046f, {[CaseLower] = 0x00046f,[CaseTitle] = 0x00046e,[CaseUpper] = 0x00046e,[CaseFold] = 0x00046f}, NULL},
	{0x000470, {[CaseLower] = 0x000471,[CaseTitle] = 0x000470,[CaseUpper] = 0x000470,[CaseFold] = 0x000471}, NULL},
	{0x000471, {[CaseLower] = 0x000471,[CaseTitle] = 0x000470,[CaseUpper] = 0x000470,[CaseFold] = 0x000471}, NULL},
	{0x000472, {[CaseLower] = 0x000473,[CaseTitle] = 0x000472,[CaseUpper] = 0x000472,[CaseFold] = 0x000473}, NULL},
	{0x000473, {[CaseLower] = 0x000473,[CaseTitle] = 0x000472,[CaseUpper] = 0x000472,[CaseFold] = 0x000473}, NULL},
	{0x000474, {[CaseLower] = 0x000475,[CaseTitle] = 0x000474,[CaseUpper] = 0x000474,[CaseFold] = 0x000475}, NULL},
	{0x000475, {[CaseLower] = 0x000475,[CaseTitle] = 0x000474,[CaseUpper] = 0x000474,[CaseFold] = 0x000475}, NULL},
	{0x000476, {[CaseLower] = 0x000477,[CaseTitle] = 0x000476,[CaseUpper] = 0x000476,[CaseFold] = 0x000477}, NULL},
	{0x000477, {[CaseLower] = 0x000477,[CaseTitle] = 0x000476,[CaseUpper] = 0x000476,[CaseFold] = 0x000477}, NULL},
	{0x000478, {[CaseLower] = 0x000479,[CaseTitle] = 0x000478,[CaseUpper] = 0x000478,[CaseFold] = 0x000479}, NULL},
	{0x000479, {[CaseLower] = 0x000479,[CaseTitle] = 0x000478,[CaseUpper] = 0x000478,[CaseFold] = 0x000479}, NULL},
	{0x00047a, {[CaseLower] = 0x00047b,[CaseTitle] = 0x00047a,[CaseUpper] = 0x00047a,[CaseFold] = 0x00047b}, NULL},
	{0x00047b, {[CaseLower] = 0x00047b,[CaseTitle] = 0x00047a,[CaseUpper] = 0x00047a,[CaseFold] = 0x00047b}, NULL},
	{0x00047c, {[CaseLower] = 0x00047d,[CaseTitle] = 0x00047c,[CaseUpper] = 0x00047c,[CaseFold] = 0x00047d}, NULL},
	{0x00047d, {[CaseLower] = 0x00047d,[CaseTitle] = 0x00047c,[CaseUpper] = 0x00047c,[CaseFold] = 0x00047d}, NULL},
	{0x00047e, {[CaseLower] = 0x00047f,[CaseTitle] = 0x00047e,[CaseUpper] = 0x00047e,[CaseFold] = 0x00047f}, NULL},
	{0x00047f, {[CaseLower] = 0x00047f,[CaseTitle] = 0x00047e,[CaseUpper] = 0x00047e,[CaseFold] = 0x00047f}, NULL},
	{0x000480, {[CaseLower] = 0x000481,[CaseTitle] = 0x000480,[CaseUpper] = 0x000480,[CaseFold] = 0x000481}, NULL},
	{0x000481, {[CaseLower] = 0x000481,[CaseTitle] = 0x000480,[CaseUpper] = 0x000480,[CaseFold] = 0x000481}, NULL},
	{0x00048a, {[CaseLower] = 0x00048b,[CaseTitle] = 0x00048a,[CaseUpper] = 0x00048a,[CaseFold] = 0x00048b}, NULL},
	{0x00048b, {[CaseLower] = 0x00048b,[CaseTitle] = 0x00048a,[CaseUpper] = 0x00048a,[CaseFold] = 0x00048b}, NULL},
	{0x00048c, {[CaseLower] = 0x00048d,[CaseTitle] = 0x00048c,[CaseUpper] = 0x00048c,[CaseFold] = 0x00048d}, NULL},
	{0x00048d, {[CaseLower] = 0x00048d,[CaseTitle] = 0x00048c,[CaseUpper] = 0x00048c,[CaseFold] = 0x00048d}, NULL},
	{0x00048e, {[CaseLower] = 0x00048f,[CaseTitle] = 0x00048e,[CaseUpper] = 0x00048e,[CaseFold] = 0x00048f}, NULL},
	{0x00048f, {[CaseLower] = 0x00048f,[CaseTitle] = 0x00048e,[CaseUpper] = 0x00048e,[CaseFold] = 0x00048f}, NULL},
	{0x000490, {[CaseLower] = 0x000491,[CaseTitle] = 0x000490,[CaseUpper] = 0x000490,[CaseFold] = 0x000491}, NULL},
	{0x000491, {[CaseLower] = 0x000491,[CaseTitle] = 0x000490,[CaseUpper] = 0x000490,[CaseFold] = 0x000491}, NULL},
	{0x000492, {[CaseLower] = 0x000493,[CaseTitle] = 0x000492,[CaseUpper] = 0x000492,[CaseFold] = 0x000493}, NULL},
	{0x000493, {[CaseLower] = 0x000493,[CaseTitle] = 0x000492,[CaseUpper] = 0x000492,[CaseFold] = 0x000493}, NULL},
	{0x000494, {[CaseLower] = 0x000495,[CaseTitle] = 0x000494,[CaseUpper] = 0x000494,[CaseFold] = 0x000495}, NULL},
	{0x000495, {[CaseLower] = 0x000495,[CaseTitle] = 0x000494,[CaseUpper] = 0x000494,[CaseFold] = 0x000495}, NULL},
	{0x000496, {[CaseLower] = 0x000497,[CaseTitle] = 0x000496,[CaseUpper] = 0x000496,[CaseFold] = 0x000497}, NULL},
	{0x000497, {[CaseLower] = 0x000497,[CaseTitle] = 0x000496,[CaseUpper] = 0x000496,[CaseFold] = 0x000497}, NULL},
	{0x000498, {[CaseLower] = 0x000499,[CaseTitle] = 0x000498,[CaseUpper] = 0x000498,[CaseFold] = 0x000499}, NULL},
	{0x000499, {[CaseLower] = 0x000499,[CaseTitle] = 0x000498,[CaseUpper] = 0x000498,[CaseFold] = 0x000499}, NULL},
	{0x00049a, {[CaseLower] = 0x00049b,[CaseTitle] = 0x00049a,[CaseUpper] = 0x00049a,[CaseFold] = 0x00049b}, NULL},
	{0x00049b, {[CaseLower] = 0x00049b,[CaseTitle] = 0x00049a,[CaseUpper] = 0x00049a,[CaseFold] = 0x00049b}, NULL},
	{0x00049c, {[CaseLower] = 0x00049d,[CaseTitle] = 0x00049c,[CaseUpper] = 0x00049c,[CaseFold] = 0x00049d}, NULL},
	{0x00049d, {[CaseLower] = 0x00049d,[CaseTitle] = 0x00049c,[CaseUpper] = 0x00049c,[CaseFold] = 0x00049d}, NULL},
	{0x00049e, {[CaseLower] = 0x00049f,[CaseTitle] = 0x00049e,[CaseUpper] = 0x00049e,[CaseFold] = 0x00049f}, NULL},
	{0x00049f, {[CaseLower] = 0x00049f,[CaseTitle] = 0x00049e,[CaseUpper] = 0x00049e,[CaseFold] = 0x00049f}, NULL},
	{0x0004a0, {[CaseLower] = 0x0004a1,[CaseTitle] = 0x0004a0,[CaseUpper] = 0x0004a0,[CaseFold] = 0x0004a1}, NULL},
	{0x0004a1, {[CaseLower] = 0x0004a1,[CaseTitle] = 0x0004a0,[CaseUpper] = 0x0004a0,[CaseFold] = 0x0004a1}, NULL},
	{0x0004a2, {[CaseLower] = 0x0004a3,[CaseTitle] = 0x0004a2,[CaseUpper] = 0x0004a2,[CaseFold] = 0x0004a3}, NULL},
	{0x0004a3, {[CaseLower] = 0x0004a3,[CaseTitle] = 0x0004a2,[CaseUpper] = 0x0004a2,[CaseFold] = 0x0004a3}, NULL},
	{0x0004a4, {[CaseLower] = 0x0004a5,[CaseTitle] = 0x0004a4,[CaseUpper] = 0x0004a4,[CaseFold] = 0x0004a5}, NULL},
	{0x0004a5, {[CaseLower] = 0x0004a5,[CaseTitle] = 0x0004a4,[CaseUpper] = 0x0004a4,[CaseFold] = 0x0004a5}, NULL},
	{0x0004a6, {[CaseLower] = 0x0004a7,[CaseTitle] = 0x0004a6,[CaseUpper] = 0x0004a6,[CaseFold] = 0x0004a7}, NULL},
	{0x0004a7, {[CaseLower] = 0x0004a7,[CaseTitle] = 0x0004a6,[CaseUpper] = 0x0004a6,[CaseFold] = 0x0004a7}, NULL},
	{0x0004a8, {[CaseLower] = 0x0004a9,[CaseTitle] = 0x0004a8,[CaseUpper] = 0x0004a8,[CaseFold] = 0x0004a9}, NULL},
	{0x0004a9, {[CaseLower] = 0x0004a9,[CaseTitle] = 0x0004a8,[CaseUpper] = 0x0004a8,[CaseFold] = 0x0004a9}, NULL},
	{0x0004aa, {[CaseLower] = 0x0004ab,[CaseTitle] = 0x0004aa,[CaseUpper] = 0x0004aa,[CaseFold] = 0x0004ab}, NULL},
	{0x0004ab, {[CaseLower] = 0x0004ab,[CaseTitle] = 0x0004aa,[CaseUpper] = 0x0004aa,[CaseFold] = 0x0004ab}, NULL},
	{0x0004ac, {[CaseLower] = 0x0004ad,[CaseTitle] = 0x0004ac,[CaseUpper] = 0x0004ac,[CaseFold] = 0x0004ad}, NULL},
	{0x0004ad, {[CaseLower] = 0x0004ad,[CaseTitle] = 0x0004ac,[CaseUpper] = 0x0004ac,[CaseFold] = 0x0004ad}, NULL},
	{0x0004ae, {[CaseLower] = 0x0004af,[CaseTitle] = 0x0004ae,[CaseUpper] = 0x0004ae,[CaseFold] = 0x0004af}, NULL},
	{0x0004af, {[CaseLower] = 0x0004af,[CaseTitle] = 0x0004ae,[CaseUpper] = 0x0004ae,[CaseFold] = 0x0004af}, NULL},
	{0x0004b0, {[CaseLower] = 0x0004b1,[CaseTitle] = 0x0004b0,[CaseUpper] = 0x0004b0,[CaseFold] = 0x0004b1}, NULL},
	{0x0004b1, {[CaseLower] = 0x0004b1,[CaseTitle] = 0x0004b0,[CaseUpper] = 0x0004b0,[CaseFold] = 0x0004b1}, NULL},
	{0x0004b2, {[CaseLower] = 0x0004b3,[CaseTitle] = 0x0004b2,[CaseUpper] = 0x0004b2,[CaseFold] = 0x0004b3}, NULL},
	{0x0004b3, {[CaseLower] = 0x0004b3,[CaseTitle] = 0x0004b2,[CaseUpper] = 0x0004b2,[CaseFold] = 0x0004b3}, NULL},
	{0x0004b4, {[CaseLower] = 0x0004b5,[CaseTitle] = 0x0004b4,[CaseUpper] = 0x0004b4,[CaseFold] = 0x0004b5}, NULL},
	{0x0004b5, {[CaseLower] = 0x0004b5,[CaseTitle] = 0x0004b4,[CaseUpper] = 0x0004b4,[CaseFold] = 0x0004b5}, NULL},
	{0x0004b6, {[CaseLower] = 0x0004b7,[CaseTitle] = 0x0004b6,[CaseUpper] = 0x0004b6,[CaseFold] = 0x0004b7}, NULL},
	{0x0004b7, {[CaseLower] = 0x0004b7,[CaseTitle] = 0x0004b6,[CaseUpper] = 0x0004b6,[CaseFold] = 0x0004b7}, NULL},
	{0x0004b8, {[CaseLower] = 0x0004b9,[CaseTitle] = 0x0004b8,[CaseUpper] = 0x0004b8,[CaseFold] = 0x0004b9}, NULL},
	{0x0004b9, {[CaseLower] = 0x0004b9,[CaseTitle] = 0x0004b8,[CaseUpper] = 0x0004b8,[CaseFold] = 0x0004b9}, NULL},
	{0x0004ba, {[CaseLower] = 0x0004bb,[CaseTitle] = 0x0004ba,[CaseUpper] = 0x0004ba,[CaseFold] = 0x0004bb}, NULL},
	{0x0004bb, {[CaseLower] = 0x0004bb,[CaseTitle] = 0x0004ba,[CaseUpper] = 0x0004ba,[CaseFold] = 0x0004bb}, NULL},
	{0x0004bc, {[CaseLower] = 0x0004bd,[CaseTitle] = 0x0004bc,[CaseUpper] = 0x0004bc,[CaseFold] = 0x0004bd}, NULL},
	{0x0004bd, {[CaseLower] = 0x0004bd,[CaseTitle] = 0x0004bc,[CaseUpper] = 0x0004bc,[CaseFold] = 0x0004bd}, NULL},
	{0x0004be, {[CaseLower] = 0x0004bf,[CaseTitle] = 0x0004be,[CaseUpper] = 0x0004be,[CaseFold] = 0x0004bf}, NULL},
	{0x0004bf, {[CaseLower] = 0x0004bf,[CaseTitle] = 0x0004be,[CaseUpper] = 0x0004be,[CaseFold] = 0x0004bf}, NULL},
	{0x0004c0, {[CaseLower] = 0x0004cf,[CaseTitle] = 0x0004c0,[CaseUpper] = 0x0004c0,[CaseFold] = 0x0004cf}, NULL},
	{0x0004c1, {[CaseLower] = 0x0004c2,[CaseTitle] = 0x0004c1,[CaseUpper] = 0x0004c1,[CaseFold] = 0x0004c2}, NULL},
	{0x0004c2, {[CaseLower] = 0x0004c2,[CaseTitle] = 0x0004c1,[CaseUpper] = 0x0004c1,[CaseFold] = 0x0004c2}, NULL},
	{0x0004c3, {[CaseLower] = 0x0004c4,[CaseTitle] = 0x0004c3,[CaseUpper] = 0x0004c3,[CaseFold] = 0x0004c4}, NULL},
	{0x0004c4, {[CaseLower] = 0x0004c4,[CaseTitle] = 0x0004c3,[CaseUpper] = 0x0004c3,[CaseFold] = 0x0004c4}, NULL},
	{0x0004c5, {[CaseLower] = 0x0004c6,[CaseTitle] = 0x0004c5,[CaseUpper] = 0x0004c5,[CaseFold] = 0x0004c6}, NULL},
	{0x0004c6, {[CaseLower] = 0x0004c6,[CaseTitle] = 0x0004c5,[CaseUpper] = 0x0004c5,[CaseFold] = 0x0004c6}, NULL},
	{0x0004c7, {[CaseLower] = 0x0004c8,[CaseTitle] = 0x0004c7,[CaseUpper] = 0x0004c7,[CaseFold] = 0x0004c8}, NULL},
	{0x0004c8, {[CaseLower] = 0x0004c8,[CaseTitle] = 0x0004c7,[CaseUpper] = 0x0004c7,[CaseFold] = 0x0004c8}, NULL},
	{0x0004c9, {[CaseLower] = 0x0004ca,[CaseTitle] = 0x0004c9,[CaseUpper] = 0x0004c9,[CaseFold] = 0x0004ca}, NULL},
	{0x0004ca, {[CaseLower] = 0x0004ca,[CaseTitle] = 0x0004c9,[CaseUpper] = 0x0004c9,[CaseFold] = 0x0004ca}, NULL},
	{0x0004cb, {[CaseLower] = 0x0004cc,[CaseTitle] = 0x0004cb,[CaseUpper] = 0x0004cb,[CaseFold] = 0x0004cc}, NULL},
	{0x0004cc, {[CaseLower] = 0x0004cc,[CaseTitle] = 0x0004cb,[CaseUpper] = 0x0004cb,[CaseFold] = 0x0004cc}, NULL},
	{0x0004cd, {[CaseLower] = 0x0004ce,[CaseTitle] = 0x0004cd,[CaseUpper] = 0x0004cd,[CaseFold] = 0x0004ce}, NULL},
	{0x0004ce, {[CaseLower] = 0x0004ce,[CaseTitle] = 0x0004cd,[CaseUpper] = 0x0004cd,[CaseFold] = 0x0004ce}, NULL},
	{0x0004cf, {[CaseLower] = 0x0004cf,[CaseTitle] = 0x0004c0,[CaseUpper] = 0x0004c0,[CaseFold] = 0x0004cf}, NULL},
	{0x0004d0, {[CaseLower] = 0x0004d1,[CaseTitle] = 0x0004d0,[CaseUpper] = 0x0004d0,[CaseFold] = 0x0004d1}, NULL},
	{0x0004d1, {[CaseLower] = 0x0004d1,[CaseTitle] = 0x0004d0,[CaseUpper] = 0x0004d0,[CaseFold] = 0x0004d1}, NULL},
	{0x0004d2, {[CaseLower] = 0x0004d3,[CaseTitle] = 0x0004d2,[CaseUpper] = 0x0004d2,[CaseFold] = 0x0004d3}, NULL},
	{0x0004d3, {[CaseLower] = 0x0004d3,[CaseTitle] = 0x0004d2,[CaseUpper] = 0x0004d2,[CaseFold] = 0x0004d3}, NULL},
	{0x0004d4, {[CaseLower] = 0x0004d5,[CaseTitle] = 0x0004d4,[CaseUpper] = 0x0004d4,[CaseFold] = 0x0004d5}, NULL},
	{0x0004d5, {[CaseLower] = 0x0004d5,[CaseTitle] = 0x0004d4,[CaseUpper] = 0x0004d4,[CaseFold] = 0x0004d5}, NULL},
	{0x0004d6, {[CaseLower] = 0x0004d7,[CaseTitle] = 0x0004d6,[CaseUpper] = 0x0004d6,[CaseFold] = 0x0004d7}, NULL},
	{0x0004d7, {[CaseLower] = 0x0004d7,[CaseTitle] = 0x0004d6,[CaseUpper] = 0x0004d6,[CaseFold] = 0x0004d7}, NULL},
	{0x0004d8, {[CaseLower] = 0x0004d9,[CaseTitle] = 0x0004d8,[CaseUpper] = 0x0004d8,[CaseFold] = 0x0004d9}, NULL},
	{0x0004d9, {[CaseLower] = 0x0004d9,[CaseTitle] = 0x0004d8,[CaseUpper] = 0x0004d8,[CaseFold] = 0x0004d9}, NULL},
	{0x0004da, {[CaseLower] = 0x0004db,[CaseTitle] = 0x0004da,[CaseUpper] = 0x0004da,[CaseFold] = 0x0004db}, NULL},
	{0x0004db, {[CaseLower] = 0x0004db,[CaseTitle] = 0x0004da,[CaseUpper] = 0x0004da,[CaseFold] = 0x0004db}, NULL},
	{0x0004dc, {[CaseLower] = 0x0004dd,[CaseTitle] = 0x0004dc,[CaseUpper] = 0x0004dc,[CaseFold] = 0x0004dd}, NULL},
	{0x0004dd, {[CaseLower] = 0x0004dd,[CaseTitle] = 0x0004dc,[CaseUpper] = 0x0004dc,[CaseFold] = 0x0004dd}, NULL},
	{0x0004de, {[CaseLower] = 0x0004df,[CaseTitle] = 0x0004de,[CaseUpper] = 0x0004de,[CaseFold] = 0x0004df}, NULL},
	{0x0004df, {[CaseLower] = 0x0004df,[CaseTitle] = 0x0004de,[CaseUpper] = 0x0004de,[CaseFold] = 0x0004df}, NULL},
	{0x0004e0, {[CaseLower] = 0x0004e1,[CaseTitle] = 0x0004e0,[CaseUpper] = 0x0004e0,[CaseFold] = 0x0004e1}, NULL},
	{0x0004e1, {[CaseLower] = 0x0004e1,[CaseTitle] = 0x0004e0,[CaseUpper] = 0x0004e0,[CaseFold] = 0x0004e1}, NULL},
	{0x0004e2, {[CaseLower] = 0x0004e3,[CaseTitle] = 0x0004e2,[CaseUpper] = 0x0004e2,[CaseFold] = 0x0004e3}, NULL},
	{0x0004e3, {[CaseLower] = 0x0004e3,[CaseTitle] = 0x0004e2,[CaseUpper] = 0x0004e2,[CaseFold] = 0x0004e3}, NULL},
	{0x0004e4, {[CaseLower] = 0x0004e5,[CaseTitle] = 0x0004e4,[CaseUpper] = 0x0004e4,[CaseFold] = 0x0004e5}, NULL},
	{0x0004e5, {[CaseLower] = 0x0004e5,[CaseTitle] = 0x0004e4,[CaseUpper] = 0x0004e4,[CaseFold] = 0x0004e5}, NULL},
	{0x0004e6, {[CaseLower] = 0x0004e7,[CaseTitle] = 0x0004e6,[CaseUpper] = 0x0004e6,[CaseFold] = 0x0004e7}, NULL},
	{0x0004e7, {[CaseLower] = 0x0004e7,[CaseTitle] = 0x0004e6,[CaseUpper] = 0x0004e6,[CaseFold] = 0x0004e7}, NULL},
	{0x0004e8, {[CaseLower] = 0x0004e9,[CaseTitle] = 0x0004e8,[CaseUpper] = 0x0004e8,[CaseFold] = 0x0004e9}, NULL},
	{0x0004e9, {[CaseLower] = 0x0004e9,[CaseTitle] = 0x0004e8,[CaseUpper] = 0x0004e8,[CaseFold] = 0x0004e9}, NULL},
	{0x0004ea, {[CaseLower] = 0x0004eb,[CaseTitle] = 0x0004ea,[CaseUpper] = 0x0004ea,[CaseFold] = 0x0004eb}, NULL},
	{0x0004eb, {[CaseLower] = 0x0004eb,[CaseTitle] = 0x0004ea,[CaseUpper] = 0x0004ea,[CaseFold] = 0x0004eb}, NULL},
	{0x0004ec, {[CaseLower] = 0x0004ed,[CaseTitle] = 0x0004ec,[CaseUpper] = 0x0004ec,[CaseFold] = 0x0004ed}, NULL},
	{0x0004ed, {[CaseLower] = 0x0004ed,[CaseTitle] = 0x0004ec,[CaseUpper] = 0x0004ec,[CaseFold] = 0x0004ed}, NULL},
	{0x0004ee, {[CaseLower] = 0x0004ef,[CaseTitle] = 0x0004ee,[CaseUpper] = 0x0004ee,[CaseFold] = 0x0004ef}, NULL},
	{0x0004ef, {[CaseLower] = 0x0004ef,[CaseTitle] = 0x0004ee,[CaseUpper] = 0x0004ee,[CaseFold] = 0x0004ef}, NULL},
	{0x0004f0, {[CaseLower] = 0x0004f1,[CaseTitle] = 0x0004f0,[CaseUpper] = 0x0004f0,[CaseFold] = 0x0004f1}, NULL},
	{0x0004f1, {[CaseLower] = 0x0004f1,[CaseTitle] = 0x0004f0,[CaseUpper] = 0x0004f0,[CaseFold] = 0x0004f1}, NULL},
	{0x0004f2, {[CaseLower] = 0x0004f3,[CaseTitle] = 0x0004f2,[CaseUpper] = 0x0004f2,[CaseFold] = 0x0004f3}, NULL},
	{0x0004f3, {[CaseLower] = 0x0004f3,[CaseTitle] = 0x0004f2,[CaseUpper] = 0x0004f2,[CaseFold] = 0x0004f3}, NULL},
	{0x0004f4, {[CaseLower] = 0x0004f5,[CaseTitle] = 0x0004f4,[CaseUpper] = 0x0004f4,[CaseFold] = 0x0004f5}, NULL},
	{0x0004f5, {[CaseLower] = 0x0004f5,[CaseTitle] = 0x0004f4,[CaseUpper] = 0x0004f4,[CaseFold] = 0x0004f5}, NULL},
	{0x0004f6, {[CaseLower] = 0x0004f7,[CaseTitle] = 0x0004f6,[CaseUpper] = 0x0004f6,[CaseFold] = 0x0004f7}, NULL},
	{0x0004f7, {[CaseLower] = 0x0004f7,[CaseTitle] = 0x0004f6,[CaseUpper] = 0x0004f6,[CaseFold] = 0x0004f7}, NULL},
	{0x0004f8, {[CaseLower] = 0x0004f9,[CaseTitle] = 0x0004f8,[CaseUpper] = 0x0004f8,[CaseFold] = 0x0004f9}, NULL},
	{0x0004f9, {[CaseLower] = 0x0004f9,[CaseTitle] = 0x0004f8,[CaseUpper] = 0x0004f8,[CaseFold] = 0x0004f9}, NULL},
	{0x0004fa, {[CaseLower] = 0x0004fb,[CaseTitle] = 0x0004fa,[CaseUpper] = 0x0004fa,[CaseFold] = 0x0004fb}, NULL},
	{0x0004fb, {[CaseLower] = 0x0004fb,[CaseTitle] = 0x0004fa,[CaseUpper] = 0x0004fa,[CaseFold] = 0x0004fb}, NULL},
	{0x0004fc, {[CaseLower] = 0x0004fd,[CaseTitle] = 0x0004fc,[CaseUpper] = 0x0004fc,[CaseFold] = 0x0004fd}, NULL},
	{0x0004fd, {[CaseLower] = 0x0004fd,[CaseTitle] = 0x0004fc,[CaseUpper] = 0x0004fc,[CaseFold] = 0x0004fd}, NULL},
	{0x0004fe, {[CaseLower] = 0x0004ff,[CaseTitle] = 0x0004fe,[CaseUpper] = 0x0004fe,[CaseFold] = 0x0004ff}, NULL},
	{0x0004ff, {[CaseLower] = 0x0004ff,[CaseTitle] = 0x0004fe,[CaseUpper] = 0x0004fe,[CaseFold] = 0x0004ff}, NULL},
	{0x000500, {[CaseLower] = 0x000501,[CaseTitle] = 0x000500,[CaseUpper] = 0x000500,[CaseFold] = 0x000501}, NULL},
	{0x000501, {[CaseLower] = 0x000501,[CaseTitle] = 0x000500,[CaseUpper] = 0x000500,[CaseFold] = 0x000501}, NULL},
	{0x000502, {[CaseLower] = 0x000503,[CaseTitle] = 0x000502,[CaseUpper] = 0x000502,[CaseFold] = 0x000503}, NULL},
	{0x000503, {[CaseLower] = 0x000503,[CaseTitle] = 0x000502,[CaseUpper] = 0x000502,[CaseFold] = 0x000503}, NULL},
	{0x000504, {[CaseLower] = 0x000505,[CaseTitle] = 0x000504,[CaseUpper] = 0x000504,[CaseFold] = 0x000505}, NULL},
	{0x000505, {[CaseLower] = 0x000505,[CaseTitle] = 0x000504,[CaseUpper] = 0x000504,[CaseFold] = 0x000505}, NULL},
	{0x000506, {[CaseLower] = 0x000507,[CaseTitle] = 0x000506,[CaseUpper] = 0x000506,[CaseFold] = 0x000507}, NULL},
	{0x000507, {[CaseLower] = 0x000507,[CaseTitle] = 0x000506,[CaseUpper] = 0x000506,[CaseFold] = 0x000507}, NULL},
	{0x000508, {[CaseLower] = 0x000509,[CaseTitle] = 0x000508,[CaseUpper] = 0x000508,[CaseFold] = 0x000509}, NULL},
	{0x000509, {[CaseLower] = 0x000509,[CaseTitle] = 0x000508,[CaseUpper] = 0x000508,[CaseFold] = 0x000509}, NULL},
	{0x00050a, {[CaseLower] = 0x00050b,[CaseTitle] = 0x00050a,[CaseUpper] = 0x00050a,[CaseFold] = 0x00050b}, NULL},
	{0x00050b, {[CaseLower] = 0x00050b,[CaseTitle] = 0x00050a,[CaseUpper] = 0x00050a,[CaseFold] = 0x00050b}, NULL},
	{0x00050c, {[CaseLower] = 0x00050d,[CaseTitle] = 0x00050c,[CaseUpper] = 0x00050c,[CaseFold] = 0x00050d}, NULL},
	{0x00050d, {[CaseLower] = 0x00050d,[CaseTitle] = 0x00050c,[CaseUpper] = 0x00050c,[CaseFold] = 0x00050d}, NULL},
	{0x00050e, {[CaseLower] = 0x00050f,[CaseTitle] = 0x00050e,[CaseUpper] = 0x00050e,[CaseFold] = 0x00050f}, NULL},
	{0x00050f, {[CaseLower] = 0x00050f,[CaseTitle] = 0x00050e,[CaseUpper] = 0x00050e,[CaseFold] = 0x00050f}, NULL},
	{0x000510, {[CaseLower] = 0x000511,[CaseTitle] = 0x000510,[CaseUpper] = 0x000510,[CaseFold] = 0x000511}, NULL},
	{0x000511, {[CaseLower] = 0x000511,[CaseTitle] = 0x000510,[CaseUpper] = 0x000510,[CaseFold] = 0x000511}, NULL},
	{0x000512, {[CaseLower] = 0x000513,[CaseTitle] = 0x000512,[CaseUpper] = 0x000512,[CaseFold] = 0x000513}, NULL},
	{0x000513, {[CaseLower] = 0x000513,[CaseTitle] = 0x000512,[CaseUpper] = 0x000512,[CaseFold] = 0x000513}, NULL},
	{0x000514, {[CaseLower] = 0x000515,[CaseTitle] = 0x000514,[CaseUpper] = 0x000514,[CaseFold] = 0x000515}, NULL},
	{0x000515, {[CaseLower] = 0x000515,[CaseTitle] = 0x000514,[CaseUpper] = 0x000514,[CaseFold] = 0x000515}, NULL},
	{0x000516, {[CaseLower] = 0x000517,[CaseTitle] = 0x000516,[CaseUpper] = 0x000516,[CaseFold] = 0x000517}, NULL},
	{0x000517, {[CaseLower] = 0x000517,[CaseTitle] = 0x000516,[CaseUpper] = 0x000516,[CaseFold] = 0x000517}, NULL},
	{0x000518, {[CaseLower] = 0x000519,[CaseTitle] = 0x000518,[CaseUpper] = 0x000518,[CaseFold] = 0x000519}, NULL},
	{0x000519, {[CaseLower] = 0x000519,[CaseTitle] = 0x000518,[CaseUpper] = 0x000518,[CaseFold] = 0x000519}, NULL},
	{0x00051a, {[CaseLower] = 0x00051b,[CaseTitle] = 0x00051a,[CaseUpper] = 0x00051a,[CaseFold] = 0x00051b}, NULL},
	{0x00051b, {[CaseLower] = 0x00051b,[CaseTitle] = 0x00051a,[CaseUpper] = 0x00051a,[CaseFold] = 0x00051b}, NULL},
	{0x00051c, {[CaseLower] = 0x00051d,[CaseTitle] = 0x00051c,[CaseUpper] = 0x00051c,[CaseFold] = 0x00051d}, NULL},
	{0x00051d, {[CaseLower] = 0x00051d,[CaseTitle] = 0x00051c,[CaseUpper] = 0x00051c,[CaseFold] = 0x00051d}, NULL},
	{0x00051e, {[CaseLower] = 0x00051f,[CaseTitle] = 0x00051e,[CaseUpper] = 0x00051e,[CaseFold] = 0x00051f}, NULL},
	{0x00051f, {[CaseLower] = 0x00051f,[CaseTitle] = 0x00051e,[CaseUpper] = 0x00051e,[CaseFold] = 0x00051f}, NULL},
	{0x000520, {[CaseLower] = 0x000521,[CaseTitle] = 0x000520,[CaseUpper] = 0x000520,[CaseFold] = 0x000521}, NULL},
	{0x000521, {[CaseLower] = 0x000521,[CaseTitle] = 0x000520,[CaseUpper] = 0x000520,[CaseFold] = 0x000521}, NULL},
	{0x000522, {[CaseLower] = 0x000523,[CaseTitle] = 0x000522,[CaseUpper] = 0x000522,[CaseFold] = 0x000523}, NULL},
	{0x000523, {[CaseLower] = 0x000523,[CaseTitle] = 0x000522,[CaseUpper] = 0x000522,[CaseFold] = 0x000523}, NULL},
	{0x000524, {[CaseLower] = 0x000525,[CaseTitle] = 0x000524,[CaseUpper] = 0x000524,[CaseFold] = 0x000525}, NULL},
	{0x000525, {[CaseLower] = 0x000525,[CaseTitle] = 0x000524,[CaseUpper] = 0x000524,[CaseFold] = 0x000525}, NULL},
	{0x000526, {[CaseLower] = 0x000527,[CaseTitle] = 0x000526,[CaseUpper] = 0x000526,[CaseFold] = 0x000527}, NULL},
	{0x000527, {[CaseLower] = 0x000527,[CaseTitle] = 0x000526,[CaseUpper] = 0x000526,[CaseFold] = 0x000527}, NULL},
	{0x000528, {[CaseLower] = 0x000529,[CaseTitle] = 0x000528,[CaseUpper] = 0x000528,[CaseFold] = 0x000529}, NULL},
	{0x000529, {[CaseLower] = 0x000529,[CaseTitle] = 0x000528,[CaseUpper] = 0x000528,[CaseFold] = 0x000529}, NULL},
	{0x00052a, {[CaseLower] = 0x00052b,[CaseTitle] = 0x00052a,[CaseUpper] = 0x00052a,[CaseFold] = 0x00052b}, NULL},
	{0x00052b, {[CaseLower] = 0x00052b,[CaseTitle] = 0x00052a,[CaseUpper] = 0x00052a,[CaseFold] = 0x00052b}, NULL},
	{0x00052c, {[CaseLower] = 0x00052d,[CaseTitle] = 0x00052c,[CaseUpper] = 0x00052c,[CaseFold] = 0x00052d}, NULL},
	{0x00052d, {[CaseLower] = 0x00052d,[CaseTitle] = 0x00052c,[CaseUpper] = 0x00052c,[CaseFold] = 0x00052d}, NULL},
	{0x00052e, {[CaseLower] = 0x00052f,[CaseTitle] = 0x00052e,[CaseUpper] = 0x00052e,[CaseFold] = 0x00052f}, NULL},
	{0x00052f, {[CaseLower] = 0x00052f,[CaseTitle] = 0x00052e,[CaseUpper] = 0x00052e,[CaseFold] = 0x00052f}, NULL},
	{0x000531, {[CaseLower] = 0x000561,[CaseTitle] = 0x000531,[CaseUpper] = 0x000531,[CaseFold] = 0x000561}, NULL},
	{0x000532, {[CaseLower] = 0x000562,[CaseTitle] = 0x000532,[CaseUpper] = 0x000532,[CaseFold] = 0x000562}, NULL},
	{0x000533, {[CaseLower] = 0x000563,[CaseTitle] = 0x000533,[CaseUpper] = 0x000533,[CaseFold] = 0x000563}, NULL},
	{0x000534, {[CaseLower] = 0x000564,[CaseTitle] = 0x000534,[CaseUpper] = 0x000534,[CaseFold] = 0x000564}, NULL},
	{0x000535, {[CaseLower] = 0x000565,[CaseTitle] = 0x000535,[CaseUpper] = 0x000535,[CaseFold] = 0x000565}, NULL},
	{0x000536, {[CaseLower] = 0x000566,[CaseTitle] = 0x000536,[CaseUpper] = 0x000536,[CaseFold] = 0x000566}, NULL},
	{0x000537, {[CaseLower] = 0x000567,[CaseTitle] = 0x000537,[CaseUpper] = 0x000537,[CaseFold] = 0x000567}, NULL},
	{0x000538, {[CaseLower] = 0x000568,[CaseTitle] = 0x000538,[CaseUpper] = 0x000538,[CaseFold] = 0x000568}, NULL},
	{0x000539, {[CaseLower] = 0x000569,[CaseTitle] = 0x000539,[CaseUpper] = 0x000539,[CaseFold] = 0x000569}, NULL},
	{0x00053a, {[CaseLower] = 0x00056a,[CaseTitle] = 0x00053a,[CaseUpper] = 0x00053a,[CaseFold] = 0x00056a}, NULL},
	{0x00053b, {[CaseLower] = 0x00056b,[CaseTitle] = 0x00053b,[CaseUpper] = 0x00053b,[CaseFold] = 0x00056b}, NULL},
	{0x00053c, {[CaseLower] = 0x00056c,[CaseTitle] = 0x00053c,[CaseUpper] = 0x00053c,[CaseFold] = 0x00056c}, NULL},
	{0x00053d, {[CaseLower] = 0x00056d,[CaseTitle] = 0x00053d,[CaseUpper] = 0x00053d,[CaseFold] = 0x00056d}, NULL},
	{0x00053e, {[CaseLower] = 0x00056e,[CaseTitle] = 0x00053e,[CaseUpper] = 0x00053e,[CaseFold] = 0x00056e}, NULL},
	{0x00053f, {[CaseLower] = 0x00056f,[CaseTitle] = 0x00053f,[CaseUpper] = 0x00053f,[CaseFold] = 0x00056f}, NULL},
	{0x000540, {[CaseLower] = 0x000570,[CaseTitle] = 0x000540,[CaseUpper] = 0x000540,[CaseFold] = 0x000570}, NULL},
	{0x000541, {[CaseLower] = 0x000571,[CaseTitle] = 0x000541,[CaseUpper] = 0x000541,[CaseFold] = 0x000571}, NULL},
	{0x000542, {[CaseLower] = 0x000572,[CaseTitle] = 0x000542,[CaseUpper] = 0x000542,[CaseFold] = 0x000572}, NULL},
	{0x000543, {[CaseLower] = 0x000573,[CaseTitle] = 0x000543,[CaseUpper] = 0x000543,[CaseFold] = 0x000573}, NULL},
	{0x000544, {[CaseLower] = 0x000574,[CaseTitle] = 0x000544,[CaseUpper] = 0x000544,[CaseFold] = 0x000574}, NULL},
	{0x000545, {[CaseLower] = 0x000575,[CaseTitle] = 0x000545,[CaseUpper] = 0x000545,[CaseFold] = 0x000575}, NULL},
	{0x000546, {[CaseLower] = 0x000576,[CaseTitle] = 0x000546,[CaseUpper] = 0x000546,[CaseFold] = 0x000576}, NULL},
	{0x000547, {[CaseLower] = 0x000577,[CaseTitle] = 0x000547,[CaseUpper] = 0x000547,[CaseFold] = 0x000577}, NULL},
	{0x000548, {[CaseLower] = 0x000578,[CaseTitle] = 0x000548,[CaseUpper] = 0x000548,[CaseFold] = 0x000578}, NULL},
	{0x000549, {[CaseLower] = 0x000579,[CaseTitle] = 0x000549,[CaseUpper] = 0x000549,[CaseFold] = 0x000579}, NULL},
	{0x00054a, {[CaseLower] = 0x00057a,[CaseTitle] = 0x00054a,[CaseUpper] = 0x00054a,[CaseFold] = 0x00057a}, NULL},
	{0x00054b, {[CaseLower] = 0x00057b,[CaseTitle] = 0x00054b,[CaseUpper] = 0x00054b,[CaseFold] = 0x00057b}, NULL},
	{0x00054c, {[CaseLower] = 0x00057c,[CaseTitle] = 0x00054c,[CaseUpper] = 0x00054c,[CaseFold] = 0x00057c}, NULL},
	{0x00054d, {[CaseLower] = 0x00057d,[CaseTitle] = 0x00054d,[CaseUpper] = 0x00054d,[CaseFold] = 0x00057d}, NULL},
	{0x00054e, {[CaseLower] = 0x00057e,[CaseTitle] = 0x00054e,[CaseUpper] = 0x00054e,[CaseFold] = 0x00057e}, NULL},
	{0x00054f, {[CaseLower] = 0x00057f,[CaseTitle] = 0x00054f,[CaseUpper] = 0x00054f,[CaseFold] = 0x00057f}, NULL},
	{0x000550, {[CaseLower] = 0x000580,[CaseTitle] = 0x000550,[CaseUpper] = 0x000550,[CaseFold] = 0x000580}, NULL},
	{0x000551, {[CaseLower] = 0x000581,[CaseTitle] = 0x000551,[CaseUpper] = 0x000551,[CaseFold] = 0x000581}, NULL},
	{0x000552, {[CaseLower] = 0x000582,[CaseTitle] = 0x000552,[CaseUpper] = 0x000552,[CaseFold] = 0x000582}, NULL},
	{0x000553, {[CaseLower] = 0x000583,[CaseTitle] = 0x000553,[CaseUpper] = 0x000553,[CaseFold] = 0x000583}, NULL},
	{0x000554, {[CaseLower] = 0x000584,[CaseTitle] = 0x000554,[CaseUpper] = 0x000554,[CaseFold] = 0x000584}, NULL},
	{0x000555, {[CaseLower] = 0x000585,[CaseTitle] = 0x000555,[CaseUpper] = 0x000555,[CaseFold] = 0x000585}, NULL},
	{0x000556, {[CaseLower] = 0x000586,[CaseTitle] = 0x000556,[CaseUpper] = 0x000556,[CaseFold] = 0x000586}, NULL},
	{0x000561, {[CaseLower] = 0x000561,[CaseTitle] = 0x000531,[CaseUpper] = 0x000531,[CaseFold] = 0x000561}, NULL},
	{0x000562, {[CaseLower] = 0x000562,[CaseTitle] = 0x000532,[CaseUpper] = 0x000532,[CaseFold] = 0x000562}, NULL},
	{0x000563, {[CaseLower] = 0x000563,[CaseTitle] = 0x000533,[CaseUpper] = 0x000533,[CaseFold] = 0x000563}, NULL},
	{0x000564, {[CaseLower] = 0x000564,[CaseTitle] = 0x000534,[CaseUpper] = 0x000534,[CaseFold] = 0x000564}, NULL},
	{0x000565, {[CaseLower] = 0x000565,[CaseTitle] = 0x000535,[CaseUpper] = 0x000535,[CaseFold] = 0x000565}, NULL},
	{0x000566, {[CaseLower] = 0x000566,[CaseTitle] = 0x000536,[CaseUpper] = 0x000536,[CaseFold] = 0x000566}, NULL},
	{0x000567, {[CaseLower] = 0x000567,[CaseTitle] = 0x000537,[CaseUpper] = 0x000537,[CaseFold] = 0x000567}, NULL},
	{0x000568, {[CaseLower] = 0x000568,[CaseTitle] = 0x000538,[CaseUpper] = 0x000538,[CaseFold] = 0x000568}, NULL},
	{0x000569, {[CaseLower] = 0x000569,[CaseTitle] = 0x000539,[CaseUpper] = 0x000539,[CaseFold] = 0x000569}, NULL},
	{0x00056a, {[CaseLower] = 0x00056a,[CaseTitle] = 0x00053a,[CaseUpper] = 0x00053a,[CaseFold] = 0x00056a}, NULL},
	{0x00056b, {[CaseLower] = 0x00056b,[CaseTitle] = 0x00053b,[CaseUpper] = 0x00053b,[CaseFold] = 0x00056b}, NULL},
	{0x00056c, {[CaseLower] = 0x00056c,[CaseTitle] = 0x00053c,[CaseUpper] = 0x00053c,[CaseFold] = 0x00056c}, NULL},
	{0x00056d, {[CaseLower] = 0x00056d,[CaseTitle] = 0x00053d,[CaseUpper] = 0x00053d,[CaseFold] = 0x00056d}, NULL},
	{0x00056e, {[CaseLower] = 0x00056e,[CaseTitle] = 0x00053e,[CaseUpper] = 0x00053e,[CaseFold] = 0x00056e}, NULL},
	{0x00056f, {[CaseLower] = 0x00056f,[CaseTitle] = 0x00053f,[CaseUpper] = 0x00053f,[CaseFold] = 0x00056f}, NULL},
	{0x000570, {[CaseLower] = 0x000570,[CaseTitle] = 0x000540,[CaseUpper] = 0x000540,[CaseFold] = 0x000570}, NULL},
	{0x000571, {[CaseLower] = 0x000571,[CaseTitle] = 0x000541,[CaseUpper] = 0x000541,[CaseFold] = 0x000571}, NULL},
	{0x000572, {[CaseLower] = 0x000572,[CaseTitle] = 0x000542,[CaseUpper] = 0x000542,[CaseFold] = 0x000572}, NULL},
	{0x000573, {[CaseLower] = 0x000573,[CaseTitle] = 0x000543,[CaseUpper] = 0x000543,[CaseFold] = 0x000573}, NULL},
	{0x000574, {[CaseLower] = 0x000574,[CaseTitle] = 0x000544,[CaseUpper] = 0x000544,[CaseFold] = 0x000574}, NULL},
	{0x000575, {[CaseLower] = 0x000575,[CaseTitle] = 0x000545,[CaseUpper] = 0x000545,[CaseFold] = 0x000575}, NULL},
	{0x000576, {[CaseLower] = 0x000576,[CaseTitle] = 0x000546,[CaseUpper] = 0x000546,[CaseFold] = 0x000576}, NULL},
	{0x000577, {[CaseLower] = 0x000577,[CaseTitle] = 0x000547,[CaseUpper] = 0x000547,[CaseFold] = 0x000577}, NULL},
	{0x000578, {[CaseLower] = 0x000578,[CaseTitle] = 0x000548,[CaseUpper] = 0x000548,[CaseFold] = 0x000578}, NULL},
	{0x000579, {[CaseLower] = 0x000579,[CaseTitle] = 0x000549,[CaseUpper] = 0x000549,[CaseFold] = 0x000579}, NULL},
	{0x00057a, {[CaseLower] = 0x00057a,[CaseTitle] = 0x00054a,[CaseUpper] = 0x00054a,[CaseFold] = 0x00057a}, NULL},
	{0x00057b, {[CaseLower] = 0x00057b,[CaseTitle] = 0x00054b,[CaseUpper] = 0x00054b,[CaseFold] = 0x00057b}, NULL},
	{0x00057c, {[CaseLower] = 0x00057c,[CaseTitle] = 0x00054c,[CaseUpper] = 0x00054c,[CaseFold] = 0x00057c}, NULL},
	{0x00057d, {[CaseLower] = 0x00057d,[CaseTitle] = 0x00054d,[CaseUpper] = 0x00054d,[CaseFold] = 0x00057d}, NULL},
	{0x00057e, {[CaseLower] = 0x00057e,[CaseTitle] = 0x00054e,[CaseUpper] = 0x00054e,[CaseFold] = 0x00057e}, NULL},
	{0x00057f, {[CaseLower] = 0x00057f,[CaseTitle] = 0x00054f,[CaseUpper] = 0x00054f,[CaseFold] = 0x00057f}, NULL},
	{0x000580, {[CaseLower] = 0x000580,[CaseTitle] = 0x000550,[CaseUpper] = 0x000550,[CaseFold] = 0x000580}, NULL},
	{0x000581, {[CaseLower] = 0x000581,[CaseTitle] = 0x000551,[CaseUpper] = 0x000551,[CaseFold] = 0x000581}, NULL},
	{0x000582, {[CaseLower] = 0x000582,[CaseTitle] = 0x000552,[CaseUpper] = 0x000552,[CaseFold] = 0x000582}, NULL},
	{0x000583, {[CaseLower] = 0x000583,[CaseTitle] = 0x000553,[CaseUpper] = 0x000553,[CaseFold] = 0x000583}, NULL},
	{0x000584, {[CaseLower] = 0x000584,[CaseTitle] = 0x000554,[CaseUpper] = 0x000554,[CaseFold] = 0x000584}, NULL},
	{0x000585, {[CaseLower] = 0x000585,[CaseTitle] = 0x000555,[CaseUpper] = 0x000555,[CaseFold] = 0x000585}, NULL},
	{0x000586, {[CaseLower] = 0x000586,[CaseTitle] = 0x000556,[CaseUpper] = 0x000556,[CaseFold] = 0x000586}, NULL},
	{0x000587, {[CaseLower] = 0x000587,[CaseTitle] = 0x000587,[CaseUpper] = 0x000587,[CaseFold] = 0x000587}, &special_case[7]},
	{0x0010a0, {[CaseLower] = 0x002d00,[CaseTitle] = 0x0010a0,[CaseUpper] = 0x0010a0,[CaseFold] = 0x002d00}, NULL},
	{0x0010a1, {[CaseLower] = 0x002d01,[CaseTitle] = 0x0010a1,[CaseUpper] = 0x0010a1,[CaseFold] = 0x002d01}, NULL},
	{0x0010a2, {[CaseLower] = 0x002d02,[CaseTitle] = 0x0010a2,[CaseUpper] = 0x0010a2,[CaseFold] = 0x002d02}, NULL},
	{0x0010a3, {[CaseLower] = 0x002d03,[CaseTitle] = 0x0010a3,[CaseUpper] = 0x0010a3,[CaseFold] = 0x002d03}, NULL},
	{0x0010a4, {[CaseLower] = 0x002d04,[CaseTitle] = 0x0010a4,[CaseUpper] = 0x0010a4,[CaseFold] = 0x002d04}, NULL},
	{0x0010a5, {[CaseLower] = 0x002d05,[CaseTitle] = 0x0010a5,[CaseUpper] = 0x0010a5,[CaseFold] = 0x002d05}, NULL},
	{0x0010a6, {[CaseLower] = 0x002d06,[CaseTitle] = 0x0010a6,[CaseUpper] = 0x0010a6,[CaseFold] = 0x002d06}, NULL},
	{0x0010a7, {[CaseLower] = 0x002d07,[CaseTitle] = 0x0010a7,[CaseUpper] = 0x0010a7,[CaseFold] = 0x002d07}, NULL},
	{0x0010a8, {[CaseLower] = 0x002d08,[CaseTitle] = 0x0010a8,[CaseUpper] = 0x0010a8,[CaseFold] = 0x002d08}, NULL},
	{0x0010a9, {[CaseLower] = 0x002d09,[CaseTitle] = 0x0010a9,[CaseUpper] = 0x0010a9,[CaseFold] = 0x002d09}, NULL},
	{0x0010aa, {[CaseLower] = 0x002d0a,[CaseTitle] = 0x0010aa,[CaseUpper] = 0x0010aa,[CaseFold] = 0x002d0a}, NULL},
	{0x0010ab, {[CaseLower] = 0x002d0b,[CaseTitle] = 0x0010ab,[CaseUpper] = 0x0010ab,[CaseFold] = 0x002d0b}, NULL},
	{0x0010ac, {[CaseLower] = 0x002d0c,[CaseTitle] = 0x0010ac,[CaseUpper] = 0x0010ac,[CaseFold] = 0x002d0c}, NULL},
	{0x0010ad, {[CaseLower] = 0x002d0d,[CaseTitle] = 0x0010ad,[CaseUpper] = 0x0010ad,[CaseFold] = 0x002d0d}, NULL},
	{0x0010ae, {[CaseLower] = 0x002d0e,[CaseTitle] = 0x0010ae,[CaseUpper] = 0x0010ae,[CaseFold] = 0x002d0e}, NULL},
	{0x0010af, {[CaseLower] = 0x002d0f,[CaseTitle] = 0x0010af,[CaseUpper] = 0x0010af,[CaseFold] = 0x002d0f}, NULL},
	{0x0010b0, {[CaseLower] = 0x002d10,[CaseTitle] = 0x0010b0,[CaseUpper] = 0x0010b0,[CaseFold] = 0x002d10}, NULL},
	{0x0010b1, {[CaseLower] = 0x002d11,[CaseTitle] = 0x0010b1,[CaseUpper] = 0x0010b1,[CaseFold] = 0x002d11}, NULL},
	{0x0010b2, {[CaseLower] = 0x002d12,[CaseTitle] = 0x0010b2,[CaseUpper] = 0x0010b2,[CaseFold] = 0x002d12}, NULL},
	{0x0010b3, {[CaseLower] = 0x002d13,[CaseTitle] = 0x0010b3,[CaseUpper] = 0x0010b3,[CaseFold] = 0x002d13}, NULL},
	{0x0010b4, {[CaseLower] = 0x002d14,[CaseTitle] = 0x0010b4,[CaseUpper] = 0x0010b4,[CaseFold] = 0x002d14}, NULL},
	{0x0010b5, {[CaseLower] = 0x002d15,[CaseTitle] = 0x0010b5,[CaseUpper] = 0x0010b5,[CaseFold] = 0x002d15}, NULL},
	{0x0010b6, {[CaseLower] = 0x002d16,[CaseTitle] = 0x0010b6,[CaseUpper] = 0x0010b6,[CaseFold] = 0x002d16}, NULL},
	{0x0010b7, {[CaseLower] = 0x002d17,[CaseTitle] = 0x0010b7,[CaseUpper] = 0x0010b7,[CaseFold] = 0x002d17}, NULL},
	{0x0010b8, {[CaseLower] = 0x002d18,[CaseTitle] = 0x0010b8,[CaseUpper] = 0x0010b8,[CaseFold] = 0x002d18}, NULL},
	{0x0010b9, {[CaseLower] = 0x002d19,[CaseTitle] = 0x0010b9,[CaseUpper] = 0x0010b9,[CaseFold] = 0x002d19}, NULL},
	{0x0010ba, {[CaseLower] = 0x002d1a,[CaseTitle] = 0x0010ba,[CaseUpper] = 0x0010ba,[CaseFold] = 0x002d1a}, NULL},
	{0x0010bb, {[CaseLower] = 0x002d1b,[CaseTitle] = 0x0010bb,[CaseUpper] = 0x0010bb,[CaseFold] = 0x002d1b}, NULL},
	{0x0010bc, {[CaseLower] = 0x002d1c,[CaseTitle] = 0x0010bc,[CaseUpper] = 0x0010bc,[CaseFold] = 0x002d1c}, NULL},
	{0x0010bd, {[CaseLower] = 0x002d1d,[CaseTitle] = 0x0010bd,[CaseUpper] = 0x0010bd,[CaseFold] = 0x002d1d}, NULL},
	{0x0010be, {[CaseLower] = 0x002d1e,[CaseTitle] = 0x0010be,[CaseUpper] = 0x0010be,[CaseFold] = 0x002d1e}, NULL},
	{0x0010bf, {[CaseLower] = 0x002d1f,[CaseTitle] = 0x0010bf,[CaseUpper] = 0x0010bf,[CaseFold] = 0x002d1f}, NULL},
	{0x0010c0, {[CaseLower] = 0x002d20,[CaseTitle] = 0x0010c0,[CaseUpper] = 0x0010c0,[CaseFold] = 0x002d20}, NULL},
	{0x0010c1, {[CaseLower] = 0x002d21,[CaseTitle] = 0x0010c1,[CaseUpper] = 0x0010c1,[CaseFold] = 0x002d21}, NULL},
	{0x0010c2, {[CaseLower] = 0x002d22,[CaseTitle] = 0x0010c2,[CaseUpper] = 0x0010c2,[CaseFold] = 0x002d22}, NULL},
	{0x0010c3, {[CaseLower] = 0x002d23,[CaseTitle] = 0x0010c3,[CaseUpper] = 0x0010c3,[CaseFold] = 0x002d23}, NULL},
	{0x0010c4, {[CaseLower] = 0x002d24,[CaseTitle] = 0x0010c4,[CaseUpper] = 0x0010c4,[CaseFold] = 0x002d24}, NULL},
	{0x0010c5, {[CaseLower] = 0x002d25,[CaseTitle] = 0x0010c5,[CaseUpper] = 0x0010c5,[CaseFold] = 0x002d25}, NULL},
	{0x0010c7, {[CaseLower] = 0x002d27,[CaseTitle] = 0x0010c7,[CaseUpper] = 0x0010c7,[CaseFold] = 0x002d27}, NULL},
	{0x0010cd, {[CaseLower] = 0x002d2d,[CaseTitle] = 0x0010cd,[CaseUpper] = 0x0010cd,[CaseFold] = 0x002d2d}, NULL},
	{0x0010d0, {[CaseLower] = 0x0010d0,[CaseTitle] = 0x0010d0,[CaseUpper] = 0x001c90,[CaseFold] = 0x0010d0}, NULL},
	{0x0010d1, {[CaseLower] = 0x0010d1,[CaseTitle] = 0x0010d1,[CaseUpper] = 0x001c91,[CaseFold] = 0x0010d1}, NULL},
	{0x0010d2, {[CaseLower] = 0x0010d2,[CaseTitle] = 0x0010d2,[CaseUpper] = 0x001c92,[CaseFold] = 0x0010d2}, NULL},
	{0x0010d3, {[CaseLower] = 0x0010d3,[CaseTitle] = 0x0010d3,[CaseUpper] = 0x001c93,[CaseFold] = 0x0010d3}, NULL},
	{0x0010d4, {[CaseLower] = 0x0010d4,[CaseTitle] = 0x0010d4,[CaseUpper] = 0x001c94,[CaseFold] = 0x0010d4}, NULL},
	{0x0010d5, {[CaseLower] = 0x0010d5,[CaseTitle] = 0x0010d5,[CaseUpper] = 0x001c95,[CaseFold] = 0x0010d5}, NULL},
	{0x0010d6, {[CaseLower] = 0x0010d6,[CaseTitle] = 0x0010d6,[CaseUpper] = 0x001c96,[CaseFold] = 0x0010d6}, NULL},
	{0x0010d7, {[CaseLower] = 0x0010d7,[CaseTitle] = 0x0010d7,[CaseUpper] = 0x001c97,[CaseFold] = 0x0010d7}, NULL},
	{0x0010d8, {[CaseLower] = 0x0010d8,[CaseTitle] = 0x0010d8,[CaseUpper] = 0x001c98,[CaseFold] = 0x0010d8}, NULL},
	{0x0010d9, {[CaseLower] = 0x0010d9,[CaseTitle] = 0x0010d9,[CaseUpper] = 0x001c99,[CaseFold] = 0x0010d9}, NULL},
	{0x0010da, {[CaseLower] = 0x0010da,[CaseTitle] = 0x0010da,[CaseUpper] = 0x001c9a,[CaseFold] = 0x0010da}, NULL},
	{0x0010db, {[CaseLower] = 0x0010db,[CaseTitle] = 0x0010db,[CaseUpper] = 0x001c9b,[CaseFold] = 0x0010db}, NULL},
	{0x0010dc, {[CaseLower] = 0x0010dc,[CaseTitle] = 0x0010dc,[CaseUpper] = 0x001c9c,[CaseFold] = 0x0010dc}, NULL},
	{0x0010dd, {[CaseLower] = 0x0010dd,[CaseTitle] = 0x0010dd,[CaseUpper] = 0x001c9d,[CaseFold] = 0x0010dd}, NULL},
	{0x0010de, {[CaseLower] = 0x0010de,[CaseTitle] = 0x0010de,[CaseUpper] = 0x001c9e,[CaseFold] = 0x0010de}, NULL},
	{0x0010df, {[CaseLower] = 0x0010df,[CaseTitle] = 0x0010df,[CaseUpper] = 0x001c9f,[CaseFold] = 0x0010df}, NULL},
	{0x0010e0, {[CaseLower] = 0x0010e0,[CaseTitle] = 0x0010e0,[CaseUpper] = 0x001ca0,[CaseFold] = 0x0010e0}, NULL},
	{0x0010e1, {[CaseLower] = 0x0010e1,[CaseTitle] = 0x0010e1,[CaseUpper] = 0x001ca1,[CaseFold] = 0x0010e1}, NULL},
	{0x0010e2, {[CaseLower] = 0x0010e2,[CaseTitle] = 0x0010e2,[CaseUpper] = 0x001ca2,[CaseFold] = 0x0010e2}, NULL},
	{0x0010e3, {[CaseLower] = 0x0010e3,[CaseTitle] = 0x0010e3,[CaseUpper] = 0x001ca3,[CaseFold] = 0x0010e3}, NULL},
	{0x0010e4, {[CaseLower] = 0x0010e4,[CaseTitle] = 0x0010e4,[CaseUpper] = 0x001ca4,[CaseFold] = 0x0010e4}, NULL},
	{0x0010e5, {[CaseLower] = 0x0010e5,[CaseTitle] = 0x0010e5,[CaseUpper] = 0x001ca5,[CaseFold] = 0x0010e5}, NULL},
	{0x0010e6, {[CaseLower] = 0x0010e6,[CaseTitle] = 0x0010e6,[CaseUpper] = 0x001ca6,[CaseFold] = 0x0010e6}, NULL},
	{0x0010e7, {[CaseLower] = 0x0010e7,[CaseTitle] = 0x0010e7,[CaseUpper] = 0x001ca7,[CaseFold] = 0x0010e7}, NULL},
	{0x0010e8, {[CaseLower] = 0x0010e8,[CaseTitle] = 0x0010e8,[CaseUpper] = 0x001ca8,[CaseFold] = 0x0010e8}, NULL},
	{0x0010e9, {[CaseLower] = 0x0010e9,[CaseTitle] = 0x0010e9,[CaseUpper] = 0x001ca9,[CaseFold] = 0x0010e9}, NULL},
	{0x0010ea, {[CaseLower] = 0x0010ea,[CaseTitle] = 0x0010ea,[CaseUpper] = 0x001caa,[CaseFold] = 0x0010ea}, NULL},
	{0x0010eb, {[CaseLower] = 0x0010eb,[CaseTitle] = 0x0010eb,[CaseUpper] = 0x001cab,[CaseFold] = 0x0010eb}, NULL},
	{0x0010ec, {[CaseLower] = 0x0010ec,[CaseTitle] = 0x0010ec,[CaseUpper] = 0x001cac,[CaseFold] = 0x0010ec}, NULL},
	{0x0010ed, {[CaseLower] = 0x0010ed,[CaseTitle] = 0x0010ed,[CaseUpper] = 0x001cad,[CaseFold] = 0x0010ed}, NULL},
	{0x0010ee, {[CaseLower] = 0x0010ee,[CaseTitle] = 0x0010ee,[CaseUpper] = 0x001cae,[CaseFold] = 0x0010ee}, NULL},
	{0x0010ef, {[CaseLower] = 0x0010ef,[CaseTitle] = 0x0010ef,[CaseUpper] = 0x001caf,[CaseFold] = 0x0010ef}, NULL},
	{0x0010f0, {[CaseLower] = 0x0010f0,[CaseTitle] = 0x0010f0,[CaseUpper] = 0x001cb0,[CaseFold] = 0x0010f0}, NULL},
	{0x0010f1, {[CaseLower] = 0x0010f1,[CaseTitle] = 0x0010f1,[CaseUpper] = 0x001cb1,[CaseFold] = 0x0010f1}, NULL},
	{0x0010f2, {[CaseLower] = 0x0010f2,[CaseTitle] = 0x0010f2,[CaseUpper] = 0x001cb2,[CaseFold] = 0x0010f2}, NULL},
	{0x0010f3, {[CaseLower] = 0x0010f3,[CaseTitle] = 0x0010f3,[CaseUpper] = 0x001cb3,[CaseFold] = 0x0010f3}, NULL},
	{0x0010f4, {[CaseLower] = 0x0010f4,[CaseTitle] = 0x0010f4,[CaseUpper] = 0x001cb4,[CaseFold] = 0x0010f4}, NULL},
	{0x0010f5, {[CaseLower] = 0x0010f5,[CaseTitle] = 0x0010f5,[CaseUpper] = 0x001cb5,[CaseFold] = 0x0010f5}, NULL},
	{0x0010f6, {[CaseLower] = 0x0010f6,[CaseTitle] = 0x0010f6,[CaseUpper] = 0x001cb6,[CaseFold] = 0x0010f6}, NULL},
	{0x0010f7, {[CaseLower] = 0x0010f7,[CaseTitle] = 0x0010f7,[CaseUpper] = 0x001cb7,[CaseFold] = 0x0010f7}, NULL},
	{0x0010f8, {[CaseLower] = 0x0010f8,[CaseTitle] = 0x0010f8,[CaseUpper] = 0x001cb8,[CaseFold] = 0x0010f8}, NULL},
	{0x0010f9, {[CaseLower] = 0x0010f9,[CaseTitle] = 0x0010f9,[CaseUpper] = 0x001cb9,[CaseFold] = 0x0010f9}, NULL},
	{0x0010fa, {[CaseLower] = 0x0010fa,[CaseTitle] = 0x0010fa,[CaseUpper] = 0x001cba,[CaseFold] = 0x0010fa}, NULL},
	{0x0010fd, {[CaseLower] = 0x0010fd,[CaseTitle] = 0x0010fd,[CaseUpper] = 0x001cbd,[CaseFold] = 0x0010fd}, NULL},
	{0x0010fe, {[CaseLower] = 0x0010fe,[CaseTitle] = 0x0010fe,[CaseUpper] = 0x001cbe,[CaseFold] = 0x0010fe}, NULL},
	{0x0010ff, {[CaseLower] = 0x0010ff,[CaseTitle] = 0x0010ff,[CaseUpper] = 0x001cbf,[CaseFold] = 0x0010ff}, NULL},
	{0x0013a0, {[CaseLower] = 0x00ab70,[CaseTitle] = 0x0013a0,[CaseUpper] = 0x0013a0,[CaseFold] = 0x0013a0}, NULL},
	{0x0013a1, {[CaseLower] = 0x00ab71,[CaseTitle] = 0x0013a1,[CaseUpper] = 0x0013a1,[CaseFold] = 0x0013a1}, NULL},
	{0x0013a2, {[CaseLower] = 0x00ab72,[CaseTitle] = 0x0013a2,[CaseUpper] = 0x0013a2,[CaseFold] = 0x0013a2}, NULL},
	{0x0013a3, {[CaseLower] = 0x00ab73,[CaseTitle] = 0x0013a3,[CaseUpper] = 0x0013a3,[CaseFold] = 0x0013a3}, NULL},
	{0x0013a4, {[CaseLower] = 0x00ab74,[CaseTitle] = 0x0013a4,[CaseUpper] = 0x0013a4,[CaseFold] = 0x0013a4}, NULL},
	{0x0013a5, {[CaseLower] = 0x00ab75,[CaseTitle] = 0x0013a5,[CaseUpper] = 0x0013a5,[CaseFold] = 0x0013a5}, NULL},
	{0x0013a6, {[CaseLower] = 0x00ab76,[CaseTitle] = 0x0013a6,[CaseUpper] = 0x0013a6,[CaseFold] = 0x0013a6}, NULL},
	{0x0013a7, {[CaseLower] = 0x00ab77,[CaseTitle] = 0x0013a7,[CaseUpper] = 0x0013a7,[CaseFold] = 0x0013a7}, NULL},
	{0x0013a8, {[CaseLower] = 0x00ab78,[CaseTitle] = 0x0013a8,[CaseUpper] = 0x0013a8,[CaseFold] = 0x0013a8}, NULL},
	{0x0013a9, {[CaseLower] = 0x00ab79,[CaseTitle] = 0x0013a9,[CaseUpper] = 0x0013a9,[CaseFold] = 0x0013a9}, NULL},
	{0x0013aa, {[CaseLower] = 0x00ab7a,[CaseTitle] = 0x0013aa,[CaseUpper] = 0x0013aa,[CaseFold] = 0x0013aa}, NULL},
	{0x0013ab, {[CaseLower] = 0x00ab7b,[CaseTitle] = 0x0013ab,[CaseUpper] = 0x0013ab,[CaseFold] = 0x0013ab}, NULL},
	{0x0013ac, {[CaseLower] = 0x00ab7c,[CaseTitle] = 0x0013ac,[CaseUpper] = 0x0013ac,[CaseFold] = 0x0013ac}, NULL},
	{0x0013ad, {[CaseLower] = 0x00ab7d,[CaseTitle] = 0x0013ad,[CaseUpper] = 0x0013ad,[CaseFold] = 0x0013ad}, NULL},
	{0x0013ae, {[CaseLower] = 0x00ab7e,[CaseTitle] = 0x0013ae,[CaseUpper] = 0x0013ae,[CaseFold] = 0x0013ae}, NULL},
	{0x0013af, {[CaseLower] = 0x00ab7f,[CaseTitle] = 0x0013af,[CaseUpper] = 0x0013af,[CaseFold] = 0x0013af}, NULL},
	{0x0013b0, {[CaseLower] = 0x00ab80,[CaseTitle] = 0x0013b0,[CaseUpper] = 0x0013b0,[CaseFold] = 0x0013b0}, NULL},
	{0x0013b1, {[CaseLower] = 0x00ab81,[CaseTitle] = 0x0013b1,[CaseUpper] = 0x0013b1,[CaseFold] = 0x0013b1}, NULL},
	{0x0013b2, {[CaseLower] = 0x00ab82,[CaseTitle] = 0x0013b2,[CaseUpper] = 0x0013b2,[CaseFold] = 0x0013b2}, NULL},
	{0x0013b3, {[CaseLower] = 0x00ab83,[CaseTitle] = 0x0013b3,[CaseUpper] = 0x0013b3,[CaseFold] = 0x0013b3}, NULL},
	{0x0013b4, {[CaseLower] = 0x00ab84,[CaseTitle] = 0x0013b4,[CaseUpper] = 0x0013b4,[CaseFold] = 0x0013b4}, NULL},
	{0x0013b5, {[CaseLower] = 0x00ab85,[CaseTitle] = 0x0013b5,[CaseUpper] = 0x0013b5,[CaseFold] = 0x0013b5}, NULL},
	{0x0013b6, {[CaseLower] = 0x00ab86,[CaseTitle] = 0x0013b6,[CaseUpper] = 0x0013b6,[CaseFold] = 0x0013b6}, NULL},
	{0x0013b7, {[CaseLower] = 0x00ab87,[CaseTitle] = 0x0013b7,[CaseUpper] = 0x0013b7,[CaseFold] = 0x0013b7}, NULL},
	{0x0013b8, {[CaseLower] = 0x00ab88,[CaseTitle] = 0x0013b8,[CaseUpper] = 0x0013b8,[CaseFold] = 0x0013b8}, NULL},
	{0x0013b9, {[CaseLower] = 0x00ab89,[CaseTitle] = 0x0013b9,[CaseUpper] = 0x0013b9,[CaseFold] = 0x0013b9}, NULL},
	{0x0013ba, {[CaseLower] = 0x00ab8a,[CaseTitle] = 0x0013ba,[CaseUpper] = 0x0013ba,[CaseFold] = 0x0013ba}, NULL},
	{0x0013bb, {[CaseLower] = 0x00ab8b,[CaseTitle] = 0x0013bb,[CaseUpper] = 0x0013bb,[CaseFold] = 0x0013bb}, NULL},
	{0x0013bc, {[CaseLower] = 0x00ab8c,[CaseTitle] = 0x0013bc,[CaseUpper] = 0x0013bc,[CaseFold] = 0x0013bc}, NULL},
	{0x0013bd, {[CaseLower] = 0x00ab8d,[CaseTitle] = 0x0013bd,[CaseUpper] = 0x0013bd,[CaseFold] = 0x0013bd}, NULL},
	{0x0013be, {[CaseLower] = 0x00ab8e,[CaseTitle] = 0x0013be,[CaseUpper] = 0x0013be,[CaseFold] = 0x0013be}, NULL},
	{0x0013bf, {[CaseLower] = 0x00ab8f,[CaseTitle] = 0x0013bf,[CaseUpper] = 0x0013bf,[CaseFold] = 0x0013bf}, NULL},
	{0x0013c0, {[CaseLower] = 0x00ab90,[CaseTitle] = 0x0013c0,[CaseUpper] = 0x0013c0,[CaseFold] = 0x0013c0}, NULL},
	{0x0013c1, {[CaseLower] = 0x00ab91,[CaseTitle] = 0x0013c1,[CaseUpper] = 0x0013c1,[CaseFold] = 0x0013c1}, NULL},
	{0x0013c2, {[CaseLower] = 0x00ab92,[CaseTitle] = 0x0013c2,[CaseUpper] = 0x0013c2,[CaseFold] = 0x0013c2}, NULL},
	{0x0013c3, {[CaseLower] = 0x00ab93,[CaseTitle] = 0x0013c3,[CaseUpper] = 0x0013c3,[CaseFold] = 0x0013c3}, NULL},
	{0x0013c4, {[CaseLower] = 0x00ab94,[CaseTitle] = 0x0013c4,[CaseUpper] = 0x0013c4,[CaseFold] = 0x0013c4}, NULL},
	{0x0013c5, {[CaseLower] = 0x00ab95,[CaseTitle] = 0x0013c5,[CaseUpper] = 0x0013c5,[CaseFold] = 0x0013c5}, NULL},
	{0x0013c6, {[CaseLower] = 0x00ab96,[CaseTitle] = 0x0013c6,[CaseUpper] = 0x0013c6,[CaseFold] = 0x0013c6}, NULL},
	{0x0013c7, {[CaseLower] = 0x00ab97,[CaseTitle] = 0x0013c7,[CaseUpper] = 0x0013c7,[CaseFold] = 0x0013c7}, NULL},
	{0x0013c8, {[CaseLower] = 0x00ab98,[CaseTitle] = 0x0013c8,[CaseUpper] = 0x0013c8,[CaseFold] = 0x0013c8}, NULL},
	{0x0013c9, {[CaseLower] = 0x00ab99,[CaseTitle] = 0x0013c9,[CaseUpper] = 0x0013c9,[CaseFold] = 0x0013c9}, NULL},
	{0x0013ca, {[CaseLower] = 0x00ab9a,[CaseTitle] = 0x0013ca,[CaseUpper] = 0x0013ca,[CaseFold] = 0x0013ca}, NULL},
	{0x0013cb, {[CaseLower] = 0x00ab9b,[CaseTitle] = 0x0013cb,[CaseUpper] = 0x0013cb,[CaseFold] = 0x0013cb}, NULL},
	{0x0013cc, {[CaseLower] = 0x00ab9c,[CaseTitle] = 0x0013cc,[CaseUpper] = 0x0013cc,[CaseFold] = 0x0013cc}, NULL},
	{0x0013cd, {[CaseLower] = 0x00ab9d,[CaseTitle] = 0x0013cd,[CaseUpper] = 0x0013cd,[CaseFold] = 0x0013cd}, NULL},
	{0x0013ce, {[CaseLower] = 0x00ab9e,[CaseTitle] = 0x0013ce,[CaseUpper] = 0x0013ce,[CaseFold] = 0x0013ce}, NULL},
	{0x0013cf, {[CaseLower] = 0x00ab9f,[CaseTitle] = 0x0013cf,[CaseUpper] = 0x0013cf,[CaseFold] = 0x0013cf}, NULL},
	{0x0013d0, {[CaseLower] = 0x00aba0,[CaseTitle] = 0x0013d0,[CaseUpper] = 0x0013d0,[CaseFold] = 0x0013d0}, NULL},
	{0x0013d1, {[CaseLower] = 0x00aba1,[CaseTitle] = 0x0013d1,[CaseUpper] = 0x0013d1,[CaseFold] = 0x0013d1}, NULL},
	{0x0013d2, {[CaseLower] = 0x00aba2,[CaseTitle] = 0x0013d2,[CaseUpper] = 0x0013d2,[CaseFold] = 0x0013d2}, NULL},
	{0x0013d3, {[CaseLower] = 0x00aba3,[CaseTitle] = 0x0013d3,[CaseUpper] = 0x0013d3,[CaseFold] = 0x0013d3}, NULL},
	{0x0013d4, {[CaseLower] = 0x00aba4,[CaseTitle] = 0x0013d4,[CaseUpper] = 0x0013d4,[CaseFold] = 0x0013d4}, NULL},
	{0x0013d5, {[CaseLower] = 0x00aba5,[CaseTitle] = 0x0013d5,[CaseUpper] = 0x0013d5,[CaseFold] = 0x0013d5}, NULL},
	{0x0013d6, {[CaseLower] = 0x00aba6,[CaseTitle] = 0x0013d6,[CaseUpper] = 0x0013d6,[CaseFold] = 0x0013d6}, NULL},
	{0x0013d7, {[CaseLower] = 0x00aba7,[CaseTitle] = 0x0013d7,[CaseUpper] = 0x0013d7,[CaseFold] = 0x0013d7}, NULL},
	{0x0013d8, {[CaseLower] = 0x00aba8,[CaseTitle] = 0x0013d8,[CaseUpper] = 0x0013d8,[CaseFold] = 0x0013d8}, NULL},
	{0x0013d9, {[CaseLower] = 0x00aba9,[CaseTitle] = 0x0013d9,[CaseUpper] = 0x0013d9,[CaseFold] = 0x0013d9}, NULL},
	{0x0013da, {[CaseLower] = 0x00abaa,[CaseTitle] = 0x0013da,[CaseUpper] = 0x0013da,[CaseFold] = 0x0013da}, NULL},
	{0x0013db, {[CaseLower] = 0x00abab,[CaseTitle] = 0x0013db,[CaseUpper] = 0x0013db,[CaseFold] = 0x0013db}, NULL},
	{0x0013dc, {[CaseLower] = 0x00abac,[CaseTitle] = 0x0013dc,[CaseUpper] = 0x0013dc,[CaseFold] = 0x0013dc}, NULL},
	{0x0013dd, {[CaseLower] = 0x00abad,[CaseTitle] = 0x0013dd,[CaseUpper] = 0x0013dd,[CaseFold] = 0x0013dd}, NULL},
	{0x0013de, {[CaseLower] = 0x00abae,[CaseTitle] = 0x0013de,[CaseUpper] = 0x0013de,[CaseFold] = 0x0013de}, NULL},
	{0x0013df, {[CaseLower] = 0x00abaf,[CaseTitle] = 0x0013df,[CaseUpper] = 0x0013df,[CaseFold] = 0x0013df}, NULL},
	{0x0013e0, {[CaseLower] = 0x00abb0,[CaseTitle] = 0x0013e0,[CaseUpper] = 0x0013e0,[CaseFold] = 0x0013e0}, NULL},
	{0x0013e1, {[CaseLower] = 0x00abb1,[CaseTitle] = 0x0013e1,[CaseUpper] = 0x0013e1,[CaseFold] = 0x0013e1}, NULL},
	{0x0013e2, {[CaseLower] = 0x00abb2,[CaseTitle] = 0x0013e2,[CaseUpper] = 0x0013e2,[CaseFold] = 0x0013e2}, NULL},
	{0x0013e3, {[CaseLower] = 0x00abb3,[CaseTitle] = 0x0013e3,[CaseUpper] = 0x0013e3,[CaseFold] = 0x0013e3}, NULL},
	{0x0013e4, {[CaseLower] = 0x00abb4,[CaseTitle] = 0x0013e4,[CaseUpper] = 0x0013e4,[CaseFold] = 0x0013e4}, NULL},
	{0x0013e5, {[CaseLower] = 0x00abb5,[CaseTitle] = 0x0013e5,[CaseUpper] = 0x0013e5,[CaseFold] = 0x0013e5}, NULL},
	{0x0013e6, {[CaseLower] = 0x00abb6,[CaseTitle] = 0x0013e6,[CaseUpper] = 0x0013e6,[CaseFold] = 0x0013e6}, NULL},
	{0x0013e7, {[CaseLower] = 0x00abb7,[CaseTitle] = 0x0013e7,[CaseUpper] = 0x0013e7,[CaseFold] = 0x0013e7}, NULL},
	{0x0013e8, {[CaseLower] = 0x00abb8,[CaseTitle] = 0x0013e8,[CaseUpper] = 0x0013e8,[CaseFold] = 0x0013e8}, NULL},
	{0x0013e9, {[CaseLower] = 0x00abb9,[CaseTitle] = 0x0013e9,[CaseUpper] = 0x0013e9,[CaseFold] = 0x0013e9}, NULL},
	{0x0013ea, {[CaseLower] = 0x00abba,[CaseTitle] = 0x0013ea,[CaseUpper] = 0x0013ea,[CaseFold] = 0x0013ea}, NULL},
	{0x0013eb, {[CaseLower] = 0x00abbb,[CaseTitle] = 0x0013eb,[CaseUpper] = 0x0013eb,[CaseFold] = 0x0013eb}, NULL},
	{0x0013ec, {[CaseLower] = 0x00abbc,[CaseTitle] = 0x0013ec,[CaseUpper] = 0x0013ec,[CaseFold] = 0x0013ec}, NULL},
	{0x0013ed, {[CaseLower] = 0x00abbd,[CaseTitle] = 0x0013ed,[CaseUpper] = 0x0013ed,[CaseFold] = 0x0013ed}, NULL},
	{0x0013ee, {[CaseLower] = 0x00abbe,[CaseTitle] = 0x0013ee,[CaseUpper] = 0x0013ee,[CaseFold] = 0x0013ee}, NULL},
	{0x0013ef, {[CaseLower] = 0x00abbf,[CaseTitle] = 0x0013ef,[CaseUpper] = 0x0013ef,[CaseFold] = 0x0013ef}, NULL},
	{0x0013f0, {[CaseLower] = 0x0013f8,[CaseTitle] = 0x0013f0,[CaseUpper] = 0x0013f0,[CaseFold] = 0x0013f0}, NULL},
	{0x0013f1, {[CaseLower] = 0x0013f9,[CaseTitle] = 0x0013f1,[CaseUpper] = 0x0013f1,[CaseFold] = 0x0013f1}, NULL},
	{0x0013f2, {[CaseLower] = 0x0013fa,[CaseTitle] = 0x0013f2,[CaseUpper] = 0x0013f2,[CaseFold] = 0x0013f2}, NULL},
	{0x0013f3, {[CaseLower] = 0x0013fb,[CaseTitle] = 0x0013f3,[CaseUpper] = 0x0013f3,[CaseFold] = 0x0013f3}, NULL},
	{0x0013f4, {[CaseLower] = 0x0013fc,[CaseTitle] = 0x0013f4,[CaseUpper] = 0x0013f4,[CaseFold] = 0x0013f4}, NULL},
	{0x0013f5, {[CaseLower] = 0x0013fd,[CaseTitle] = 0x0013f5,[CaseUpper] = 0x0013f5,[CaseFold] = 0x0013f5}, NULL},
	{0x0013f8, {[CaseLower] = 0x0013f8,[CaseTitle] = 0x0013f0,[CaseUpper] = 0x0013f0,[CaseFold] = 0x0013f0}, NULL},
	{0x0013f9, {[CaseLower] = 0x0013f9,[CaseTitle] = 0x0013f1,[CaseUpper] = 0x0013f1,[CaseFold] = 0x0013f1}, NULL},
	{0x0013fa, {[CaseLower] = 0x0013fa,[CaseTitle] = 0x0013f2,[CaseUpper] = 0x0013f2,[CaseFold] = 0x0013f2}, NULL},
	{0x0013fb, {[CaseLower] = 0x0013fb,[CaseTitle] = 0x0013f3,[CaseUpper] = 0x0013f3,[CaseFold] = 0x0013f3}, NULL},
	{0x0013fc, {[CaseLower] = 0x0013fc,[CaseTitle] = 0x0013f4,[CaseUpper] = 0x0013f4,[CaseFold] = 0x0013f4}, NULL},
	{0x0013fd, {[CaseLower] = 0x0013fd,[CaseTitle] = 0x0013f5,[CaseUpper] = 0x0013f5,[CaseFold] = 0x0013f5}, NULL},
	{0x001c80, {[CaseLower] = 0x001c80,[CaseTitle] = 0x000412,[CaseUpper] = 0x000412,[CaseFold] = 0x000432}, NULL},
	{0x001c81, {[CaseLower] = 0x001c81,[CaseTitle] = 0x000414,[CaseUpper] = 0x000414,[CaseFold] = 0x000434}, NULL},
	{0x001c82, {[CaseLower] = 0x001c82,[CaseTitle] = 0x00041e,[CaseUpper] = 0x00041e,[CaseFold] = 0x00043e}, NULL},
	{0x001c83, {[CaseLower] = 0x001c83,[CaseTitle] = 0x000421,[CaseUpper] = 0x000421,[CaseFold] = 0x000441}, NULL},
	{0x001c84, {[CaseLower] = 0x001c84,[CaseTitle] = 0x000422,[CaseUpper] = 0x000422,[CaseFold] = 0x000442}, NULL},
	{0x001c85, {[CaseLower] = 0x001c85,[CaseTitle] = 0x000422,[CaseUpper] = 0x000422,[CaseFold] = 0x000442}, NULL},
	{0x001c86, {[CaseLower] = 0x001c86,[CaseTitle] = 0x00042a,[CaseUpper] = 0x00042a,[CaseFold] = 0x00044a}, NULL},
	{0x001c87, {[CaseLower] = 0x001c87,[CaseTitle] = 0x000462,[CaseUpper] = 0x000462,[CaseFold] = 0x000463}, NULL},
	{0x001c88, {[CaseLower] = 0x001c88,[CaseTitle] = 0x00a64a,[CaseUpper] = 0x00a64a,[CaseFold] = 0x00a64b}, NULL},
	{0x001c90, {[CaseLower] = 0x0010d0,[CaseTitle] = 0x001c90,[CaseUpper] = 0x001c90,[CaseFold] = 0x0010d0}, NULL},
	{0x001c91, {[CaseLower] = 0x0010d1,[CaseTitle] = 0x001c91,[CaseUpper] = 0x001c91,[CaseFold] = 0x0010d1}, NULL},
	{0x001c92, {[CaseLower] = 0x0010d2,[CaseTitle] = 0x001c92,[CaseUpper] = 0x001c92,[CaseFold] = 0x0010d2}, NULL},
	{0x001c93, {[CaseLower] = 0x0010d3,[CaseTitle] = 0x001c93,[CaseUpper] = 0x001c93,[CaseFold] = 0x0010d3}, NULL},
	{0x001c94, {[CaseLower] = 0x0010d4,[CaseTitle] = 0x001c94,[CaseUpper] = 0x001c94,[CaseFold] = 0x0010d4}, NULL},
	{0x001c95, {[CaseLower] = 0x0010d5,[CaseTitle] = 0x001c95,[CaseUpper] = 0x001c95,[CaseFold] = 0x0010d5}, NULL},
	{0x001c96, {[CaseLower] = 0x0010d6,[CaseTitle] = 0x001c96,[CaseUpper] = 0x001c96,[CaseFold] = 0x0010d6}, NULL},
	{0x001c97, {[CaseLower] = 0x0010d7,[CaseTitle] = 0x001c97,[CaseUpper] = 0x001c97,[CaseFold] = 0x0010d7}, NULL},
	{0x001c98, {[CaseLower] = 0x0010d8,[CaseTitle] = 0x001c98,[CaseUpper] = 0x001c98,[CaseFold] = 0x0010d8}, NULL},
	{0x001c99, {[CaseLower] = 0x0010d9,[CaseTitle] = 0x001c99,[CaseUpper] = 0x001c99,[CaseFold] = 0x0010d9}, NULL},
	{0x001c9a, {[CaseLower] = 0x0010da,[CaseTitle] = 0x001c9a,[CaseUpper] = 0x001c9a,[CaseFold] = 0x0010da}, NULL},
	{0x001c9b, {[CaseLower] = 0x0010db,[CaseTitle] = 0x001c9b,[CaseUpper] = 0x001c9b,[CaseFold] = 0x0010db}, NULL},
	{0x001c9c, {[CaseLower] = 0x0010dc,[CaseTitle] = 0x001c9c,[CaseUpper] = 0x001c9c,[CaseFold] = 0x0010dc}, NULL},
	{0x001c9d, {[CaseLower] = 0x0010dd,[CaseTitle] = 0x001c9d,[CaseUpper] = 0x001c9d,[CaseFold] = 0x0010dd}, NULL},
	{0x001c9e, {[CaseLower] = 0x0010de,[CaseTitle] = 0x001c9e,[CaseUpper] = 0x001c9e,[CaseFold] = 0x0010de}, NULL},
	{0x001c9f, {[CaseLower] = 0x0010df,[CaseTitle] = 0x001c9f,[CaseUpper] = 0x001c9f,[CaseFold] = 0x0010df}, NULL},
	{0x001ca0, {[CaseLower] = 0x0010e0,[CaseTitle] = 0x001ca0,[CaseUpper] = 0x001ca0,[CaseFold] = 0x0010e0}, NULL},
	{0x001ca1, {[CaseLower] = 0x0010e1,[CaseTitle] = 0x001ca1,[CaseUpper] = 0x001ca1,[CaseFold] = 0x0010e1}, NULL},
	{0x001ca2, {[CaseLower] = 0x0010e2,[CaseTitle] = 0x001ca2,[CaseUpper] = 0x001ca2,[CaseFold] = 0x0010e2}, NULL},
	{0x001ca3, {[CaseLower] = 0x0010e3,[CaseTitle] = 0x001ca3,[CaseUpper] = 0x001ca3,[CaseFold] = 0x0010e3}, NULL},
	{0x001ca4, {[CaseLower] = 0x0010e4,[CaseTitle] = 0x001ca4,[CaseUpper] = 0x001ca4,[CaseFold] = 0x0010e4}, NULL},
	{0x001ca5, {[CaseLower] = 0x0010e5,[CaseTitle] = 0x001ca5,[CaseUpper] = 0x001ca5,[CaseFold] = 0x0010e5}, NULL},
	{0x001ca6, {[CaseLower] = 0x0010e6,[CaseTitle] = 0x001ca6,[CaseUpper] = 0x001ca6,[CaseFold] = 0x0010e6}, NULL},
	{0x001ca7, {[CaseLower] = 0x0010e7,[CaseTitle] = 0x001ca7,[CaseUpper] = 0x001ca7,[CaseFold] = 0x0010e7}, NULL},
	{0x001ca8, {[CaseLower] = 0x0010e8,[CaseTitle] = 0x001ca8,[CaseUpper] = 0x001ca8,[CaseFold] = 0x0010e8}, NULL},
	{0x001ca9, {[CaseLower] = 0x0010e9,[CaseTitle] = 0x001ca9,[CaseUpper] = 0x001ca9,[CaseFold] = 0x0010e9}, NULL},
	{0x001caa, {[CaseLower] = 0x0010ea,[CaseTitle] = 0x001caa,[CaseUpper] = 0x001caa,[CaseFold] = 0x0010ea}, NULL},
	{0x001cab, {[CaseLower] = 0x0010eb,[CaseTitle] = 0x001cab,[CaseUpper] = 0x001cab,[CaseFold] = 0x0010eb}, NULL},
	{0x001cac, {[CaseLower] = 0x0010ec,[CaseTitle] = 0x001cac,[CaseUpper] = 0x001cac,[CaseFold] = 0x0010ec}, NULL},
	{0x001cad, {[CaseLower] = 0x0010ed,[CaseTitle] = 0x001cad,[CaseUpper] = 0x001cad,[CaseFold] = 0x0010ed}, NULL},
	{0x001cae, {[CaseLower] = 0x0010ee,[CaseTitle] = 0x001cae,[CaseUpper] = 0x001cae,[CaseFold] = 0x0010ee}, NULL},
	{0x001caf, {[CaseLower] = 0x0010ef,[CaseTitle] = 0x001caf,[CaseUpper] = 0x001caf,[CaseFold] = 0x0010ef}, NULL},
	{0x001cb0, {[CaseLower] = 0x0010f0,[CaseTitle] = 0x001cb0,[CaseUpper] = 0x001cb0,[CaseFold] = 0x0010f0}, NULL},
	{0x001cb1, {[CaseLower] = 0x0010f1,[CaseTitle] = 0x001cb1,[CaseUpper] = 0x001cb1,[CaseFold] = 0x0010f1}, NULL},
	{0x001cb2, {[CaseLower] = 0x0010f2,[CaseTitle] = 0x001cb2,[CaseUpper] = 0x001cb2,[CaseFold] = 0x0010f2}, NULL},
	{0x001cb3, {[CaseLower] = 0x0010f3,[CaseTitle] = 0x001cb3,[CaseUpper] = 0x001cb3,[CaseFold] = 0x0010f3}, NULL},
	{0x001cb4, {[CaseLower] = 0x0010f4,[CaseTitle] = 0x001cb4,[CaseUpper] = 0x001cb4,[CaseFold] = 0x0010f4}, NULL},
	{0x001cb5, {[CaseLower] = 0x0010f5,[CaseTitle] = 0x001cb5,[CaseUpper] = 0x001cb5,[CaseFold] = 0x0010f5}, NULL},
	{0x001cb6, {[CaseLower] = 0x0010f6,[CaseTitle] = 0x001cb6,[CaseUpper] = 0x001cb6,[CaseFold] = 0x0010f6}, NULL},
	{0x001cb7, {[CaseLower] = 0x0010f7,[CaseTitle] = 0x001cb7,[CaseUpper] = 0x001cb7,[CaseFold] = 0x0010f7}, NULL},
	{0x001cb8, {[CaseLower] = 0x0010f8,[CaseTitle] = 0x001cb8,[CaseUpper] = 0x001cb8,[CaseFold] = 0x0010f8}, NULL},
	{0x001cb9, {[CaseLower] = 0x0010f9,[CaseTitle] = 0x001cb9,[CaseUpper] = 0x001cb9,[CaseFold] = 0x0010f9}, NULL},
	{0x001cba, {[CaseLower] = 0x0010fa,[CaseTitle] = 0x001cba,[CaseUpper] = 0x001cba,[CaseFold] = 0x0010fa}, NULL},
	{0x001cbd, {[CaseLower] = 0x0010fd,[CaseTitle] = 0x001cbd,[CaseUpper] = 0x001cbd,[CaseFold] = 0x0010fd}, NULL},
	{0x001cbe, {[CaseLower] = 0x0010fe,[CaseTitle] = 0x001cbe,[CaseUpper] = 0x001cbe,[CaseFold] = 0x0010fe}, NULL},
	{0x001cbf, {[CaseLower] = 0x0010ff,[CaseTitle] = 0x001cbf,[CaseUpper] = 0x001cbf,[CaseFold] = 0x0010ff}, NULL},
	{0x001d79, {[CaseLower] = 0x001d79,[CaseTitle] = 0x00a77d,[CaseUpper] = 0x00a77d,[CaseFold] = 0x001d79}, NULL},
	{0x001d7d, {[CaseLower] = 0x001d7d,[CaseTitle] = 0x002c63,[CaseUpper] = 0x002c63,[CaseFold] = 0x001d7d}, NULL},
	{0x001d8e, {[CaseLower] = 0x001d8e,[CaseTitle] = 0x00a7c6,[CaseUpper] = 0x00a7c6,[CaseFold] = 0x001d8e}, NULL},
	{0x001e00, {[CaseLower] = 0x001e01,[CaseTitle] = 0x001e00,[CaseUpper] = 0x001e00,[CaseFold] = 0x001e01}, NULL},
	{0x001e01, {[CaseLower] = 0x001e01,[CaseTitle] = 0x001e00,[CaseUpper] = 0x001e00,[CaseFold] = 0x001e01}, NULL},
	{0x001e02, {[CaseLower] = 0x001e03,[CaseTitle] = 0x001e02,[CaseUpper] = 0x001e02,[CaseFold] = 0x001e03}, NULL},
	{0x001e03, {[CaseLower] = 0x001e03,[CaseTitle] = 0x001e02,[CaseUpper] = 0x001e02,[CaseFold] = 0x001e03}, NULL},
	{0x001e04, {[CaseLower] = 0x001e05,[CaseTitle] = 0x001e04,[CaseUpper] = 0x001e04,[CaseFold] = 0x001e05}, NULL},
	{0x001e05, {[CaseLower] = 0x001e05,[CaseTitle] = 0x001e04,[CaseUpper] = 0x001e04,[CaseFold] = 0x001e05}, NULL},
	{0x001e06, {[CaseLower] = 0x001e07,[CaseTitle] = 0x001e06,[CaseUpper] = 0x001e06,[CaseFold] = 0x001e07}, NULL},
	{0x001e07, {[CaseLower] = 0x001e07,[CaseTitle] = 0x001e06,[CaseUpper] = 0x001e06,[CaseFold] = 0x001e07}, NULL},
	{0x001e08, {[CaseLower] = 0x001e09,[CaseTitle] = 0x001e08,[CaseUpper] = 0x001e08,[CaseFold] = 0x001e09}, NULL},
	{0x001e09, {[CaseLower] = 0x001e09,[CaseTitle] = 0x001e08,[CaseUpper] = 0x001e08,[CaseFold] = 0x001e09}, NULL},
	{0x001e0a, {[CaseLower] = 0x001e0b,[CaseTitle] = 0x001e0a,[CaseUpper] = 0x001e0a,[CaseFold] = 0x001e0b}, NULL},
	{0x001e0b, {[CaseLower] = 0x001e0b,[CaseTitle] = 0x001e0a,[CaseUpper] = 0x001e0a,[CaseFold] = 0x001e0b}, NULL},
	{0x001e0c, {[CaseLower] = 0x001e0d,[CaseTitle] = 0x001e0c,[CaseUpper] = 0x001e0c,[CaseFold] = 0x001e0d}, NULL},
	{0x001e0d, {[CaseLower] = 0x001e0d,[CaseTitle] = 0x001e0c,[CaseUpper] = 0x001e0c,[CaseFold] = 0x001e0d}, NULL},
	{0x001e0e, {[CaseLower] = 0x001e0f,[CaseTitle] = 0x001e0e,[CaseUpper] = 0x001e0e,[CaseFold] = 0x001e0f}, NULL},
	{0x001e0f, {[CaseLower] = 0x001e0f,[CaseTitle] = 0x001e0e,[CaseUpper] = 0x001e0e,[CaseFold] = 0x001e0f}, NULL},
	{0x001e10, {[CaseLower] = 0x001e11,[CaseTitle] = 0x001e10,[CaseUpper] = 0x001e10,[CaseFold] = 0x001e11}, NULL},
	{0x001e11, {[CaseLower] = 0x001e11,[CaseTitle] = 0x001e10,[CaseUpper] = 0x001e10,[CaseFold] = 0x001e11}, NULL},
	{0x001e12, {[CaseLower] = 0x001e13,[CaseTitle] = 0x001e12,[CaseUpper] = 0x001e12,[CaseFold] = 0x001e13}, NULL},
	{0x001e13, {[CaseLower] = 0x001e13,[CaseTitle] = 0x001e12,[CaseUpper] = 0x001e12,[CaseFold] = 0x001e13}, NULL},
	{0x001e14, {[CaseLower] = 0x001e15,[CaseTitle] = 0x001e14,[CaseUpper] = 0x001e14,[CaseFold] = 0x001e15}, NULL},
	{0x001e15, {[CaseLower] = 0x001e15,[CaseTitle] = 0x001e14,[CaseUpper] = 0x001e14,[CaseFold] = 0x001e15}, NULL},
	{0x001e16, {[CaseLower] = 0x001e17,[CaseTitle] = 0x001e16,[CaseUpper] = 0x001e16,[CaseFold] = 0x001e17}, NULL},
	{0x001e17, {[CaseLower] = 0x001e17,[CaseTitle] = 0x001e16,[CaseUpper] = 0x001e16,[CaseFold] = 0x001e17}, NULL},
	{0x001e18, {[CaseLower] = 0x001e19,[CaseTitle] = 0x001e18,[CaseUpper] = 0x001e18,[CaseFold] = 0x001e19}, NULL},
	{0x001e19, {[CaseLower] = 0x001e19,[CaseTitle] = 0x001e18,[CaseUpper] = 0x001e18,[CaseFold] = 0x001e19}, NULL},
	{0x001e1a, {[CaseLower] = 0x001e1b,[CaseTitle] = 0x001e1a,[CaseUpper] = 0x001e1a,[CaseFold] = 0x001e1b}, NULL},
	{0x001e1b, {[CaseLower] = 0x001e1b,[CaseTitle] = 0x001e1a,[CaseUpper] = 0x001e1a,[CaseFold] = 0x001e1b}, NULL},
	{0x001e1c, {[CaseLower] = 0x001e1d,[CaseTitle] = 0x001e1c,[CaseUpper] = 0x001e1c,[CaseFold] = 0x001e1d}, NULL},
	{0x001e1d, {[CaseLower] = 0x001e1d,[CaseTitle] = 0x001e1c,[CaseUpper] = 0x001e1c,[CaseFold] = 0x001e1d}, NULL},
	{0x001e1e, {[CaseLower] = 0x001e1f,[CaseTitle] = 0x001e1e,[CaseUpper] = 0x001e1e,[CaseFold] = 0x001e1f}, NULL},
	{0x001e1f, {[CaseLower] = 0x001e1f,[CaseTitle] = 0x001e1e,[CaseUpper] = 0x001e1e,[CaseFold] = 0x001e1f}, NULL},
	{0x001e20, {[CaseLower] = 0x001e21,[CaseTitle] = 0x001e20,[CaseUpper] = 0x001e20,[CaseFold] = 0x001e21}, NULL},
	{0x001e21, {[CaseLower] = 0x001e21,[CaseTitle] = 0x001e20,[CaseUpper] = 0x001e20,[CaseFold] = 0x001e21}, NULL},
	{0x001e22, {[CaseLower] = 0x001e23,[CaseTitle] = 0x001e22,[CaseUpper] = 0x001e22,[CaseFold] = 0x001e23}, NULL},
	{0x001e23, {[CaseLower] = 0x001e23,[CaseTitle] = 0x001e22,[CaseUpper] = 0x001e22,[CaseFold] = 0x001e23}, NULL},
	{0x001e24, {[CaseLower] = 0x001e25,[CaseTitle] = 0x001e24,[CaseUpper] = 0x001e24,[CaseFold] = 0x001e25}, NULL},
	{0x001e25, {[CaseLower] = 0x001e25,[CaseTitle] = 0x001e24,[CaseUpper] = 0x001e24,[CaseFold] = 0x001e25}, NULL},
	{0x001e26, {[CaseLower] = 0x001e27,[CaseTitle] = 0x001e26,[CaseUpper] = 0x001e26,[CaseFold] = 0x001e27}, NULL},
	{0x001e27, {[CaseLower] = 0x001e27,[CaseTitle] = 0x001e26,[CaseUpper] = 0x001e26,[CaseFold] = 0x001e27}, NULL},
	{0x001e28, {[CaseLower] = 0x001e29,[CaseTitle] = 0x001e28,[CaseUpper] = 0x001e28,[CaseFold] = 0x001e29}, NULL},
	{0x001e29, {[CaseLower] = 0x001e29,[CaseTitle] = 0x001e28,[CaseUpper] = 0x001e28,[CaseFold] = 0x001e29}, NULL},
	{0x001e2a, {[CaseLower] = 0x001e2b,[CaseTitle] = 0x001e2a,[CaseUpper] = 0x001e2a,[CaseFold] = 0x001e2b}, NULL},
	{0x001e2b, {[CaseLower] = 0x001e2b,[CaseTitle] = 0x001e2a,[CaseUpper] = 0x001e2a,[CaseFold] = 0x001e2b}, NULL},
	{0x001e2c, {[CaseLower] = 0x001e2d,[CaseTitle] = 0x001e2c,[CaseUpper] = 0x001e2c,[CaseFold] = 0x001e2d}, NULL},
	{0x001e2d, {[CaseLower] = 0x001e2d,[CaseTitle] = 0x001e2c,[CaseUpper] = 0x001e2c,[CaseFold] = 0x001e2d}, NULL},
	{0x001e2e, {[CaseLower] = 0x001e2f,[CaseTitle] = 0x001e2e,[CaseUpper] = 0x001e2e,[CaseFold] = 0x001e2f}, NULL},
	{0x001e2f, {[CaseLower] = 0x001e2f,[CaseTitle] = 0x001e2e,[CaseUpper] = 0x001e2e,[CaseFold] = 0x001e2f}, NULL},
	{0x001e30, {[CaseLower] = 0x001e31,[CaseTitle] = 0x001e30,[CaseUpper] = 0x001e30,[CaseFold] = 0x001e31}, NULL},
	{0x001e31, {[CaseLower] = 0x001e31,[CaseTitle] = 0x001e30,[CaseUpper] = 0x001e30,[CaseFold] = 0x001e31}, NULL},
	{0x001e32, {[CaseLower] = 0x001e33,[CaseTitle] = 0x001e32,[CaseUpper] = 0x001e32,[CaseFold] = 0x001e33}, NULL},
	{0x001e33, {[CaseLower] = 0x001e33,[CaseTitle] = 0x001e32,[CaseUpper] = 0x001e32,[CaseFold] = 0x001e33}, NULL},
	{0x001e34, {[CaseLower] = 0x001e35,[CaseTitle] = 0x001e34,[CaseUpper] = 0x001e34,[CaseFold] = 0x001e35}, NULL},
	{0x001e35, {[CaseLower] = 0x001e35,[CaseTitle] = 0x001e34,[CaseUpper] = 0x001e34,[CaseFold] = 0x001e35}, NULL},
	{0x001e36, {[CaseLower] = 0x001e37,[CaseTitle] = 0x001e36,[CaseUpper] = 0x001e36,[CaseFold] = 0x001e37}, NULL},
	{0x001e37, {[CaseLower] = 0x001e37,[CaseTitle] = 0x001e36,[CaseUpper] = 0x001e36,[CaseFold] = 0x001e37}, NULL},
	{0x001e38, {[CaseLower] = 0x001e39,[CaseTitle] = 0x001e38,[CaseUpper] = 0x001e38,[CaseFold] = 0x001e39}, NULL},
	{0x001e39, {[CaseLower] = 0x001e39,[CaseTitle] = 0x001e38,[CaseUpper] = 0x001e38,[CaseFold] = 0x001e39}, NULL},
	{0x001e3a, {[CaseLower] = 0x001e3b,[CaseTitle] = 0x001e3a,[CaseUpper] = 0x001e3a,[CaseFold] = 0x001e3b}, NULL},
	{0x001e3b, {[CaseLower] = 0x001e3b,[CaseTitle] = 0x001e3a,[CaseUpper] = 0x001e3a,[CaseFold] = 0x001e3b}, NULL},
	{0x001e3c, {[CaseLower] = 0x001e3d,[CaseTitle] = 0x001e3c,[CaseUpper] = 0x001e3c,[CaseFold] = 0x001e3d}, NULL},
	{0x001e3d, {[CaseLower] = 0x001e3d,[CaseTitle] = 0x001e3c,[CaseUpper] = 0x001e3c,[CaseFold] = 0x001e3d}, NULL},
	{0x001e3e, {[CaseLower] = 0x001e3f,[CaseTitle] = 0x001e3e,[CaseUpper] = 0x001e3e,[CaseFold] = 0x001e3f}, NULL},
	{0x001e3f, {[CaseLower] = 0x001e3f,[CaseTitle] = 0x001e3e,[CaseUpper] = 0x001e3e,[CaseFold] = 0x001e3f}, NULL},
	{0x001e40, {[CaseLower] = 0x001e41,[CaseTitle] = 0x001e40,[CaseUpper] = 0x001e40,[CaseFold] = 0x001e41}, NULL},
	{0x001e41, {[CaseLower] = 0x001e41,[CaseTitle] = 0x001e40,[CaseUpper] = 0x001e40,[CaseFold] = 0x001e41}, NULL},
	{0x001e42, {[CaseLower] = 0x001e43,[CaseTitle] = 0x001e42,[CaseUpper] = 0x001e42,[CaseFold] = 0x001e43}, NULL},
	{0x001e43, {[CaseLower] = 0x001e43,[CaseTitle] = 0x001e42,[CaseUpper] = 0x001e42,[CaseFold] = 0x001e43}, NULL},
	{0x001e44, {[CaseLower] = 0x001e45,[CaseTitle] = 0x001e44,[CaseUpper] = 0x001e44,[CaseFold] = 0x001e45}, NULL},
	{0x001e45, {[CaseLower] = 0x001e45,[CaseTitle] = 0x001e44,[CaseUpper] = 0x001e44,[CaseFold] = 0x001e45}, NULL},
	{0x001e46, {[CaseLower] = 0x001e47,[CaseTitle] = 0x001e46,[CaseUpper] = 0x001e46,[CaseFold] = 0x001e47}, NULL},
	{0x001e47, {[CaseLower] = 0x001e47,[CaseTitle] = 0x001e46,[CaseUpper] = 0x001e46,[CaseFold] = 0x001e47}, NULL},
	{0x001e48, {[CaseLower] = 0x001e49,[CaseTitle] = 0x001e48,[CaseUpper] = 0x001e48,[CaseFold] = 0x001e49}, NULL},
	{0x001e49, {[CaseLower] = 0x001e49,[CaseTitle] = 0x001e48,[CaseUpper] = 0x001e48,[CaseFold] = 0x001e49}, NULL},
	{0x001e4a, {[CaseLower] = 0x001e4b,[CaseTitle] = 0x001e4a,[CaseUpper] = 0x001e4a,[CaseFold] = 0x001e4b}, NULL},
	{0x001e4b, {[CaseLower] = 0x001e4b,[CaseTitle] = 0x001e4a,[CaseUpper] = 0x001e4a,[CaseFold] = 0x001e4b}, NULL},
	{0x001e4c, {[CaseLower] = 0x001e4d,[CaseTitle] = 0x001e4c,[CaseUpper] = 0x001e4c,[CaseFold] = 0x001e4d}, NULL},
	{0x001e4d, {[CaseLower] = 0x001e4d,[CaseTitle] = 0x001e4c,[CaseUpper] = 0x001e4c,[CaseFold] = 0x001e4d}, NULL},
	{0x001e4e, {[CaseLower] = 0x001e4f,[CaseTitle] = 0x001e4e,[CaseUpper] = 0x001e4e,[CaseFold] = 0x001e4f}, NULL},
	{0x001e4f, {[CaseLower] = 0x001e4f,[CaseTitle] = 0x001e4e,[CaseUpper] = 0x001e4e,[CaseFold] = 0x001e4f}, NULL},
	{0x001e50, {[CaseLower] = 0x001e51,[CaseTitle] = 0x001e50,[CaseUpper] = 0x001e50,[CaseFold] = 0x001e51}, NULL},
	{0x001e51, {[CaseLower] = 0x001e51,[CaseTitle] = 0x001e50,[CaseUpper] = 0x001e50,[CaseFold] = 0x001e51}, NULL},
	{0x001e52, {[CaseLower] = 0x001e53,[CaseTitle] = 0x001e52,[CaseUpper] = 0x001e52,[CaseFold] = 0x001e53}, NULL},
	{0x001e53, {[CaseLower] = 0x001e53,[CaseTitle] = 0x001e52,[CaseUpper] = 0x001e52,[CaseFold] = 0x001e53}, NULL},
	{0x001e54, {[CaseLower] = 0x001e55,[CaseTitle] = 0x001e54,[CaseUpper] = 0x001e54,[CaseFold] = 0x001e55}, NULL},
	{0x001e55, {[CaseLower] = 0x001e55,[CaseTitle] = 0x001e54,[CaseUpper] = 0x001e54,[CaseFold] = 0x001e55}, NULL},
	{0x001e56, {[CaseLower] = 0x001e57,[CaseTitle] = 0x001e56,[CaseUpper] = 0x001e56,[CaseFold] = 0x001e57}, NULL},
	{0x001e57, {[CaseLower] = 0x001e57,[CaseTitle] = 0x001e56,[CaseUpper] = 0x001e56,[CaseFold] = 0x001e57}, NULL},
	{0x001e58, {[CaseLower] = 0x001e59,[CaseTitle] = 0x001e58,[CaseUpper] = 0x001e58,[CaseFold] = 0x001e59}, NULL},
	{0x001e59, {[CaseLower] = 0x001e59,[CaseTitle] = 0x001e58,[CaseUpper] = 0x001e58,[CaseFold] = 0x001e59}, NULL},
	{0x001e5a, {[CaseLower] = 0x001e5b,[CaseTitle] = 0x001e5a,[CaseUpper] = 0x001e5a,[CaseFold] = 0x001e5b}, NULL},
	{0x001e5b, {[CaseLower] = 0x001e5b,[CaseTitle] = 0x001e5a,[CaseUpper] = 0x001e5a,[CaseFold] = 0x001e5b}, NULL},
	{0x001e5c, {[CaseLower] = 0x001e5d,[CaseTitle] = 0x001e5c,[CaseUpper] = 0x001e5c,[CaseFold] = 0x001e5d}, NULL},
	{0x001e5d, {[CaseLower] = 0x001e5d,[CaseTitle] = 0x001e5c,[CaseUpper] = 0x001e5c,[CaseFold] = 0x001e5d}, NULL},
	{0x001e5e, {[CaseLower] = 0x001e5f,[CaseTitle] = 0x001e5e,[CaseUpper] = 0x001e5e,[CaseFold] = 0x001e5f}, NULL},
	{0x001e5f, {[CaseLower] = 0x001e5f,[CaseTitle] = 0x001e5e,[CaseUpper] = 0x001e5e,[CaseFold] = 0x001e5f}, NULL},
	{0x001e60, {[CaseLower] = 0x001e61,[CaseTitle] = 0x001e60,[CaseUpper] = 0x001e60,[CaseFold] = 0x001e61}, NULL},
	{0x001e61, {[CaseLower] = 0x001e61,[CaseTitle] = 0x001e60,[CaseUpper] = 0x001e60,[CaseFold] = 0x001e61}, NULL},
	{0x001e62, {[CaseLower] = 0x001e63,[CaseTitle] = 0x001e62,[CaseUpper] = 0x001e62,[CaseFold] = 0x001e63}, NULL},
	{0x001e63, {[CaseLower] = 0x001e63,[CaseTitle] = 0x001e62,[CaseUpper] = 0x001e62,[CaseFold] = 0x001e63}, NULL},
	{0x001e64, {[CaseLower] = 0x001e65,[CaseTitle] = 0x001e64,[CaseUpper] = 0x001e64,[CaseFold] = 0x001e65}, NULL},
	{0x001e65, {[CaseLower] = 0x001e65,[CaseTitle] = 0x001e64,[CaseUpper] = 0x001e64,[CaseFold] = 0x001e65}, NULL},
	{0x001e66, {[CaseLower] = 0x001e67,[CaseTitle] = 0x001e66,[CaseUpper] = 0x001e66,[CaseFold] = 0x001e67}, NULL},
	{0x001e67, {[CaseLower] = 0x001e67,[CaseTitle] = 0x001e66,[CaseUpper] = 0x001e66,[CaseFold] = 0x001e67}, NULL},
	{0x001e68, {[CaseLower] = 0x001e69,[CaseTitle] = 0x001e68,[CaseUpper] = 0x001e68,[CaseFold] = 0x001e69}, NULL},
	{0x001e69, {[CaseLower] = 0x001e69,[CaseTitle] = 0x001e68,[CaseUpper] = 0x001e68,[CaseFold] = 0x001e69}, NULL},
	{0x001e6a, {[CaseLower] = 0x001e6b,[CaseTitle] = 0x001e6a,[CaseUpper] = 0x001e6a,[CaseFold] = 0x001e6b}, NULL},
	{0x001e6b, {[CaseLower] = 0x001e6b,[CaseTitle] = 0x001e6a,[CaseUpper] = 0x001e6a,[CaseFold] = 0x001e6b}, NULL},
	{0x001e6c, {[CaseLower] = 0x001e6d,[CaseTitle] = 0x001e6c,[CaseUpper] = 0x001e6c,[CaseFold] = 0x001e6d}, NULL},
	{0x001e6d, {[CaseLower] = 0x001e6d,[CaseTitle] = 0x001e6c,[CaseUpper] = 0x001e6c,[CaseFold] = 0x001e6d}, NULL},
	{0x001e6e, {[CaseLower] = 0x001e6f,[CaseTitle] = 0x001e6e,[CaseUpper] = 0x001e6e,[CaseFold] = 0x001e6f}, NULL},
	{0x001e6f, {[CaseLower] = 0x001e6f,[CaseTitle] = 0x001e6e,[CaseUpper] = 0x001e6e,[CaseFold] = 0x001e6f}, NULL},
	{0x001e70, {[CaseLower] = 0x001e71,[CaseTitle] = 0x001e70,[CaseUpper] = 0x001e70,[CaseFold] = 0x001e71}, NULL},
	{0x001e71, {[CaseLower] = 0x001e71,[CaseTitle] = 0x001e70,[CaseUpper] = 0x001e70,[CaseFold] = 0x001e71}, NULL},
	{0x001e72, {[CaseLower] = 0x001e73,[CaseTitle] = 0x001e72,[CaseUpper] = 0x001e72,[CaseFold] = 0x001e73}, NULL},
	{0x001e73, {[CaseLower] = 0x001e73,[CaseTitle] = 0x001e72,[CaseUpper] = 0x001e72,[CaseFold] = 0x001e73}, NULL},
	{0x001e74, {[CaseLower] = 0x001e75,[CaseTitle] = 0x001e74,[CaseUpper] = 0x001e74,[CaseFold] = 0x001e75}, NULL},
	{0x001e75, {[CaseLower] = 0x001e75,[CaseTitle] = 0x001e74,[CaseUpper] = 0x001e74,[CaseFold] = 0x001e75}, NULL},
	{0x001e76, {[CaseLower] = 0x001e77,[CaseTitle] = 0x001e76,[CaseUpper] = 0x001e76,[CaseFold] = 0x001e77}, NULL},
	{0x001e77, {[CaseLower] = 0x001e77,[CaseTitle] = 0x001e76,[CaseUpper] = 0x001e76,[CaseFold] = 0x001e77}, NULL},
	{0x001e78, {[CaseLower] = 0x001e79,[CaseTitle] = 0x001e78,[CaseUpper] = 0x001e78,[CaseFold] = 0x001e79}, NULL},
	{0x001e79, {[CaseLower] = 0x001e79,[CaseTitle] = 0x001e78,[CaseUpper] = 0x001e78,[CaseFold] = 0x001e79}, NULL},
	{0x001e7a, {[CaseLower] = 0x001e7b,[CaseTitle] = 0x001e7a,[CaseUpper] = 0x001e7a,[CaseFold] = 0x001e7b}, NULL},
	{0x001e7b, {[CaseLower] = 0x001e7b,[CaseTitle] = 0x001e7a,[CaseUpper] = 0x001e7a,[CaseFold] = 0x001e7b}, NULL},
	{0x001e7c, {[CaseLower] = 0x001e7d,[CaseTitle] = 0x001e7c,[CaseUpper] = 0x001e7c,[CaseFold] = 0x001e7d}, NULL},
	{0x001e7d, {[CaseLower] = 0x001e7d,[CaseTitle] = 0x001e7c,[CaseUpper] = 0x001e7c,[CaseFold] = 0x001e7d}, NULL},
	{0x001e7e, {[CaseLower] = 0x001e7f,[CaseTitle] = 0x001e7e,[CaseUpper] = 0x001e7e,[CaseFold] = 0x001e7f}, NULL},
	{0x001e7f, {[CaseLower] = 0x001e7f,[CaseTitle] = 0x001e7e,[CaseUpper] = 0x001e7e,[CaseFold] = 0x001e7f}, NULL},
	{0x001e80, {[CaseLower] = 0x001e81,[CaseTitle] = 0x001e80,[CaseUpper] = 0x001e80,[CaseFold] = 0x001e81}, NULL},
	{0x001e81, {[CaseLower] = 0x001e81,[CaseTitle] = 0x001e80,[CaseUpper] = 0x001e80,[CaseFold] = 0x001e81}, NULL},
	{0x001e82, {[CaseLower] = 0x001e83,[CaseTitle] = 0x001e82,[CaseUpper] = 0x001e82,[CaseFold] = 0x001e83}, NULL},
	{0x001e83, {[CaseLower] = 0x001e83,[CaseTitle] = 0x001e82,[CaseUpper] = 0x001e82,[CaseFold] = 0x001e83}, NULL},
	{0x001e84, {[CaseLower] = 0x001e85,[CaseTitle] = 0x001e84,[CaseUpper] = 0x001e84,[CaseFold] = 0x001e85}, NULL},
	{0x001e85, {[CaseLower] = 0x001e85,[CaseTitle] = 0x001e84,[CaseUpper] = 0x001e84,[CaseFold] = 0x001e85}, NULL},
	{0x001e86, {[CaseLower] = 0x001e87,[CaseTitle] = 0x001e86,[CaseUpper] = 0x001e86,[CaseFold] = 0x001e87}, NULL},
	{0x001e87, {[CaseLower] = 0x001e87,[CaseTitle] = 0x001e86,[CaseUpper] = 0x001e86,[CaseFold] = 0x001e87}, NULL},
	{0x001e88, {[CaseLower] = 0x001e89,[CaseTitle] = 0x001e88,[CaseUpper] = 0x001e88,[CaseFold] = 0x001e89}, NULL},
	{0x001e89, {[CaseLower] = 0x001e89,[CaseTitle] = 0x001e88,[CaseUpper] = 0x001e88,[CaseFold] = 0x001e89}, NULL},
	{0x001e8a, {[CaseLower] = 0x001e8b,[CaseTitle] = 0x001e8a,[CaseUpper] = 0x001e8a,[CaseFold] = 0x001e8b}, NULL},
	{0x001e8b, {[CaseLower] = 0x001e8b,[CaseTitle] = 0x001e8a,[CaseUpper] = 0x001e8a,[CaseFold] = 0x001e8b}, NULL},
	{0x001e8c, {[CaseLower] = 0x001e8d,[CaseTitle] = 0x001e8c,[CaseUpper] = 0x001e8c,[CaseFold] = 0x001e8d}, NULL},
	{0x001e8d, {[CaseLower] = 0x001e8d,[CaseTitle] = 0x001e8c,[CaseUpper] = 0x001e8c,[CaseFold] = 0x001e8d}, NULL},
	{0x001e8e, {[CaseLower] = 0x001e8f,[CaseTitle] = 0x001e8e,[CaseUpper] = 0x001e8e,[CaseFold] = 0x001e8f}, NULL},
	{0x001e8f, {[CaseLower] = 0x001e8f,[CaseTitle] = 0x001e8e,[CaseUpper] = 0x001e8e,[CaseFold] = 0x001e8f}, NULL},
	{0x001e90, {[CaseLower] = 0x001e91,[CaseTitle] = 0x001e90,[CaseUpper] = 0x001e90,[CaseFold] = 0x001e91}, NULL},
	{0x001e91, {[CaseLower] = 0x001e91,[CaseTitle] = 0x001e90,[CaseUpper] = 0x001e90,[CaseFold] = 0x001e91}, NULL},
	{0x001e92, {[CaseLower] = 0x001e93,[CaseTitle] = 0x001e92,[CaseUpper] = 0x001e92,[CaseFold] = 0x001e93}, NULL},
	{0x001e93, {[CaseLower] = 0x001e93,[CaseTitle] = 0x001e92,[CaseUpper] = 0x001e92,[CaseFold] = 0x001e93}, NULL},
	{0x001e94, {[CaseLower] = 0x001e95,[CaseTitle] = 0x001e94,[CaseUpper] = 0x001e94,[CaseFold] = 0x001e95}, NULL},
	{0x001e95, {[CaseLower] = 0x001e95,[CaseTitle] = 0x001e94,[CaseUpper] = 0x001e94,[CaseFold] = 0x001e95}, NULL},
	{0x001e96, {[CaseLower] = 0x001e96,[CaseTitle] = 0x001e96,[CaseUpper] = 0x001e96,[CaseFold] = 0x001e96}, &special_case[8]},
	{0x001e97, {[CaseLower] = 0x001e97,[CaseTitle] = 0x001e97,[CaseUpper] = 0x001e97,[CaseFold] = 0x001e97}, &special_case[9]},
	{0x001e98, {[CaseLower] = 0x001e98,[CaseTitle] = 0x001e98,[CaseUpper] = 0x001e98,[CaseFold] = 0x001e98}, &special_case[10]},
	{0x001e99, {[CaseLower] = 0x001e99,[CaseTitle] = 0x001e99,[CaseUpper] = 0x001e99,[CaseFold] = 0x001e99}, &special_case[11]},
	{0x001e9a, {[CaseLower] = 0x001e9a,[CaseTitle] = 0x001e9a,[CaseUpper] = 0x001e9a,[CaseFold] = 0x001e9a}, &special_case[12]},
	{0x001e9b, {[CaseLower] = 0x001e9b,[CaseTitle] = 0x001e60,[CaseUpper] = 0x001e60,[CaseFold] = 0x001e61}, NULL},
	{0x001e9e, {[CaseLower] = 0x0000df,[CaseTitle] = 0x001e9e,[CaseUpper] = 0x001e9e,[CaseFold] = 0x0000df}, &special_case[13]},
	{0x001ea0, {[CaseLower] = 0x001ea1,[CaseTitle] = 0x001ea0,[CaseUpper] = 0x001ea0,[CaseFold] = 0x001ea1}, NULL},
	{0x001ea1, {[CaseLower] = 0x001ea1,[CaseTitle] = 0x001ea0,[CaseUpper] = 0x001ea0,[CaseFold] = 0x001ea1}, NULL},
	{0x001ea2, {[CaseLower] = 0x001ea3,[CaseTitle] = 0x001ea2,[CaseUpper] = 0x001ea2,[CaseFold] = 0x001ea3}, NULL},
	{0x001ea3, {[CaseLower] = 0x001ea3,[CaseTitle] = 0x001ea2,[CaseUpper] = 0x001ea2,[CaseFold] = 0x001ea3}, NULL},
	{0x001ea4, {[CaseLower] = 0x001ea5,[CaseTitle] = 0x001ea4,[CaseUpper] = 0x001ea4,[CaseFold] = 0x001ea5}, NULL},
	{0x001ea5, {[CaseLower] = 0x001ea5,[CaseTitle] = 0x001ea4,[CaseUpper] = 0x001ea4,[CaseFold] = 0x001ea5}, NULL},
	{0x001ea6, {[CaseLower] = 0x001ea7,[CaseTitle] = 0x001ea6,[CaseUpper] = 0x001ea6,[CaseFold] = 0x001ea7}, NULL},
	{0x001ea7, {[CaseLower] = 0x001ea7,[CaseTitle] = 0x001ea6,[CaseUpper] = 0x001ea6,[CaseFold] = 0x001ea7}, NULL},
	{0x001ea8, {[CaseLower] = 0x001ea9,[CaseTitle] = 0x001ea8,[CaseUpper] = 0x001ea8,[CaseFold] = 0x001ea9}, NULL},
	{0x001ea9, {[CaseLower] = 0x001ea9,[CaseTitle] = 0x001ea8,[CaseUpper] = 0x001ea8,[CaseFold] = 0x001ea9}, NULL},
	{0x001eaa, {[CaseLower] = 0x001eab,[CaseTitle] = 0x001eaa,[CaseUpper] = 0x001eaa,[CaseFold] = 0x001eab}, NULL},
	{0x001eab, {[CaseLower] = 0x001eab,[CaseTitle] = 0x001eaa,[CaseUpper] = 0x001eaa,[CaseFold] = 0x001eab}, NULL},
	{0x001eac, {[CaseLower] = 0x001ead,[CaseTitle] = 0x001eac,[CaseUpper] = 0x001eac,[CaseFold] = 0x001ead}, NULL},
	{0x001ead, {[CaseLower] = 0x001ead,[CaseTitle] = 0x001eac,[CaseUpper] = 0x001eac,[CaseFold] = 0x001ead}, NULL},
	{0x001eae, {[CaseLower] = 0x001eaf,[CaseTitle] = 0x001eae,[CaseUpper] = 0x001eae,[CaseFold] = 0x001eaf}, NULL},
	{0x001eaf, {[CaseLower] = 0x001eaf,[CaseTitle] = 0x001eae,[CaseUpper] = 0x001eae,[CaseFold] = 0x001eaf}, NULL},
	{0x001eb0, {[CaseLower] = 0x001eb1,[CaseTitle] = 0x001eb0,[CaseUpper] = 0x001eb0,[CaseFold] = 0x001eb1}, NULL},
	{0x001eb1, {[CaseLower] = 0x001eb1,[CaseTitle] = 0x001eb0,[CaseUpper] = 0x001eb0,[CaseFold] = 0x001eb1}, NULL},
	{0x001eb2, {[CaseLower] = 0x001eb3,[CaseTitle] = 0x001eb2,[CaseUpper] = 0x001eb2,[CaseFold] = 0x001eb3}, NULL},
	{0x001eb3, {[CaseLower] = 0x001eb3,[CaseTitle] = 0x001eb2,[CaseUpper] = 0x001eb2,[CaseFold] = 0x001eb3}, NULL},
	{0x001eb4, {[CaseLower] = 0x001eb5,[CaseTitle] = 0x001eb4,[CaseUpper] = 0x001eb4,[CaseFold] = 0x001eb5}, NULL},
	{0x001eb5, {[CaseLower] = 0x001eb5,[CaseTitle] = 0x001eb4,[CaseUpper] = 0x001eb4,[CaseFold] = 0x001eb5}, NULL},
	{0x001eb6, {[CaseLower] = 0x001eb7,[CaseTitle] = 0x001eb6,[CaseUpper] = 0x001eb6,[CaseFold] = 0x001eb7}, NULL},
	{0x001eb7, {[CaseLower] = 0x001eb7,[CaseTitle] = 0x001eb6,[CaseUpper] = 0x001eb6,[CaseFold] = 0x001eb7}, NULL},
	{0x001eb8, {[CaseLower] = 0x001eb9,[CaseTitle] = 0x001eb8,[CaseUpper] = 0x001eb8,[CaseFold] = 0x001eb9}, NULL},
	{0x001eb9, {[CaseLower] = 0x001eb9,[CaseTitle] = 0x001eb8,[CaseUpper] = 0x001eb8,[CaseFold] = 0x001eb9}, NULL},
	{0x001eba, {[CaseLower] = 0x001ebb,[CaseTitle] = 0x001eba,[CaseUpper] = 0x001eba,[CaseFold] = 0x001ebb}, NULL},
	{0x001ebb, {[CaseLower] = 0x001ebb,[CaseTitle] = 0x001eba,[CaseUpper] = 0x001eba,[CaseFold] = 0x001ebb}, NULL},
	{0x001ebc, {[CaseLower] = 0x001ebd,[CaseTitle] = 0x001ebc,[CaseUpper] = 0x001ebc,[CaseFold] = 0x001ebd}, NULL},
	{0x001ebd, {[CaseLower] = 0x001ebd,[CaseTitle] = 0x001ebc,[CaseUpper] = 0x001ebc,[CaseFold] = 0x001ebd}, NULL},
	{0x001ebe, {[CaseLower] = 0x001ebf,[CaseTitle] = 0x001ebe,[CaseUpper] = 0x001ebe,[CaseFold] = 0x001ebf}, NULL},
	{0x001ebf, {[CaseLower] = 0x001ebf,[CaseTitle] = 0x001ebe,[CaseUpper] = 0x001ebe,[CaseFold] = 0x001ebf}, NULL},
	{0x001ec0, {[CaseLower] = 0x001ec1,[CaseTitle] = 0x001ec0,[CaseUpper] = 0x001ec0,[CaseFold] = 0x001ec1}, NULL},
	{0x001ec1, {[CaseLower] = 0x001ec1,[CaseTitle] = 0x001ec0,[CaseUpper] = 0x001ec0,[CaseFold] = 0x001ec1}, NULL},
	{0x001ec2, {[CaseLower] = 0x001ec3,[CaseTitle] = 0x001ec2,[CaseUpper] = 0x001ec2,[CaseFold] = 0x001ec3}, NULL},
	{0x001ec3, {[CaseLower] = 0x001ec3,[CaseTitle] = 0x001ec2,[CaseUpper] = 0x001ec2,[CaseFold] = 0x001ec3}, NULL},
	{0x001ec4, {[CaseLower] = 0x001ec5,[CaseTitle] = 0x001ec4,[CaseUpper] = 0x001ec4,[CaseFold] = 0x001ec5}, NULL},
	{0x001ec5, {[CaseLower] = 0x001ec5,[CaseTitle] = 0x001ec4,[CaseUpper] = 0x001ec4,[CaseFold] = 0x001ec5}, NULL},
	{0x001ec6, {[CaseLower] = 0x001ec7,[CaseTitle] = 0x001ec6,[CaseUpper] = 0x001ec6,[CaseFold] = 0x001ec7}, NULL},
	{0x001ec7, {[CaseLower] = 0x001ec7,[CaseTitle] = 0x001ec6,[CaseUpper] = 0x001ec6,[CaseFold] = 0x001ec7}, NULL},
	{0x001ec8, {[CaseLower] = 0x001ec9,[CaseTitle] = 0x001ec8,[CaseUpper] = 0x001ec8,[CaseFold] = 0x001ec9}, NULL},
	{0x001ec9, {[CaseLower] = 0x001ec9,[CaseTitle] = 0x001ec8,[CaseUpper] = 0x001ec8,[CaseFold] = 0x001ec9}, NULL},
	{0x001eca, {[CaseLower] = 0x001ecb,[CaseTitle] = 0x001eca,[CaseUpper] = 0x001eca,[CaseFold] = 0x001ecb}, NULL},
	{0x001ecb, {[CaseLower] = 0x001ecb,[CaseTitle] = 0x001eca,[CaseUpper] = 0x001eca,[CaseFold] = 0x001ecb}, NULL},
	{0x001ecc, {[CaseLower] = 0x001ecd,[CaseTitle] = 0x001ecc,[CaseUpper] = 0x001ecc,[CaseFold] = 0x001ecd}, NULL},
	{0x001ecd, {[CaseLower] = 0x001ecd,[CaseTitle] = 0x001ecc,[CaseUpper] = 0x001ecc,[CaseFold] = 0x001ecd}, NULL},
	{0x001ece, {[CaseLower] = 0x001ecf,[CaseTitle] = 0x001ece,[CaseUpper] = 0x001ece,[CaseFold] = 0x001ecf}, NULL},
	{0x001ecf, {[CaseLower] = 0x001ecf,[CaseTitle] = 0x001ece,[CaseUpper] = 0x001ece,[CaseFold] = 0x001ecf}, NULL},
	{0x001ed0, {[CaseLower] = 0x001ed1,[CaseTitle] = 0x001ed0,[CaseUpper] = 0x001ed0,[CaseFold] = 0x001ed1}, NULL},
	{0x001ed1, {[CaseLower] = 0x001ed1,[CaseTitle] = 0x001ed0,[CaseUpper] = 0x001ed0,[CaseFold] = 0x001ed1}, NULL},
	{0x001ed2, {[CaseLower] = 0x001ed3,[CaseTitle] = 0x001ed2,[CaseUpper] = 0x001ed2,[CaseFold] = 0x001ed3}, NULL},
	{0x001ed3, {[CaseLower] = 0x001ed3,[CaseTitle] = 0x001ed2,[CaseUpper] = 0x001ed2,[CaseFold] = 0x001ed3}, NULL},
	{0x001ed4, {[CaseLower] = 0x001ed5,[CaseTitle] = 0x001ed4,[CaseUpper] = 0x001ed4,[CaseFold] = 0x001ed5}, NULL},
	{0x001ed5, {[CaseLower] = 0x001ed5,[CaseTitle] = 0x001ed4,[CaseUpper] = 0x001ed4,[CaseFold] = 0x001ed5}, NULL},
	{0x001ed6, {[CaseLower] = 0x001ed7,[CaseTitle] = 0x001ed6,[CaseUpper] = 0x001ed6,[CaseFold] = 0x001ed7}, NULL},
	{0x001ed7, {[CaseLower] = 0x001ed7,[CaseTitle] = 0x001ed6,[CaseUpper] = 0x001ed6,[CaseFold] = 0x001ed7}, NULL},
	{0x001ed8, {[CaseLower] = 0x001ed9,[CaseTitle] = 0x001ed8,[CaseUpper] = 0x001ed8,[CaseFold] = 0x001ed9}, NULL},
	{0x001ed9, {[CaseLower] = 0x001ed9,[CaseTitle] = 0x001ed8,[CaseUpper] = 0x001ed8,[CaseFold] = 0x001ed9}, NULL},
	{0x001eda, {[CaseLower] = 0x001edb,[CaseTitle] = 0x001eda,[CaseUpper] = 0x001eda,[CaseFold] = 0x001edb}, NULL},
	{0x001edb, {[CaseLower] = 0x001edb,[CaseTitle] = 0x001eda,[CaseUpper] = 0x001eda,[CaseFold] = 0x001edb}, NULL},
	{0x001edc, {[CaseLower] = 0x001edd,[CaseTitle] = 0x001edc,[CaseUpper] = 0x001edc,[CaseFold] = 0x001edd}, NULL},
	{0x001edd, {[CaseLower] = 0x001edd,[CaseTitle] = 0x001edc,[CaseUpper] = 0x001edc,[CaseFold] = 0x001edd}, NULL},
	{0x001ede, {[CaseLower] = 0x001edf,[CaseTitle] = 0x001ede,[CaseUpper] = 0x001ede,[CaseFold] = 0x001edf}, NULL},
	{0x001edf, {[CaseLower] = 0x001edf,[CaseTitle] = 0x001ede,[CaseUpper] = 0x001ede,[CaseFold] = 0x001edf}, NULL},
	{0x001ee0, {[CaseLower] = 0x001ee1,[CaseTitle] = 0x001ee0,[CaseUpper] = 0x001ee0,[CaseFold] = 0x001ee1}, NULL},
	{0x001ee1, {[CaseLower] = 0x001ee1,[CaseTitle] = 0x001ee0,[CaseUpper] = 0x001ee0,[CaseFold] = 0x001ee1}, NULL},
	{0x001ee2, {[CaseLower] = 0x001ee3,[CaseTitle] = 0x001ee2,[CaseUpper] = 0x001ee2,[CaseFold] = 0x001ee3}, NULL},
	{0x001ee3, {[CaseLower] = 0x001ee3,[CaseTitle] = 0x001ee2,[CaseUpper] = 0x001ee2,[CaseFold] = 0x001ee3}, NULL},
	{0x001ee4, {[CaseLower] = 0x001ee5,[CaseTitle] = 0x001ee4,[CaseUpper] = 0x001ee4,[CaseFold] = 0x001ee5}, NULL},
	{0x001ee5, {[CaseLower] = 0x001ee5,[CaseTitle] = 0x001ee4,[CaseUpper] = 0x001ee4,[CaseFold] = 0x001ee5}, NULL},
	{0x001ee6, {[CaseLower] = 0x001ee7,[CaseTitle] = 0x001ee6,[CaseUpper] = 0x001ee6,[CaseFold] = 0x001ee7}, NULL},
	{0x001ee7, {[CaseLower] = 0x001ee7,[CaseTitle] = 0x001ee6,[CaseUpper] = 0x001ee6,[CaseFold] = 0x001ee7}, NULL},
	{0x001ee8, {[CaseLower] = 0x001ee9,[CaseTitle] = 0x001ee8,[CaseUpper] = 0x001ee8,[CaseFold] = 0x001ee9}, NULL},
	{0x001ee9, {[CaseLower] = 0x001ee9,[CaseTitle] = 0x001ee8,[CaseUpper] = 0x001ee8,[CaseFold] = 0x001ee9}, NULL},
	{0x001eea, {[CaseLower] = 0x001eeb,[CaseTitle] = 0x001eea,[CaseUpper] = 0x001eea,[CaseFold] = 0x001eeb}, NULL},
	{0x001eeb, {[CaseLower] = 0x001eeb,[CaseTitle] = 0x001eea,[CaseUpper] = 0x001eea,[CaseFold] = 0x001eeb}, NULL},
	{0x001eec, {[CaseLower] = 0x001eed,[CaseTitle] = 0x001eec,[CaseUpper] = 0x001eec,[CaseFold] = 0x001eed}, NULL},
	{0x001eed, {[CaseLower] = 0x001eed,[CaseTitle] = 0x001eec,[CaseUpper] = 0x001eec,[CaseFold] = 0x001eed}, NULL},
	{0x001eee, {[CaseLower] = 0x001eef,[CaseTitle] = 0x001eee,[CaseUpper] = 0x001eee,[CaseFold] = 0x001eef}, NULL},
	{0x001eef, {[CaseLower] = 0x001eef,[CaseTitle] = 0x001eee,[CaseUpper] = 0x001eee,[CaseFold] = 0x001eef}, NULL},
	{0x001ef0, {[CaseLower] = 0x001ef1,[CaseTitle] = 0x001ef0,[CaseUpper] = 0x001ef0,[CaseFold] = 0x001ef1}, NULL},
	{0x001ef1, {[CaseLower] = 0x001ef1,[CaseTitle] = 0x001ef0,[CaseUpper] = 0x001ef0,[CaseFold] = 0x001ef1}, NULL},
	{0x001ef2, {[CaseLower] = 0x001ef3,[CaseTitle] = 0x001ef2,[CaseUpper] = 0x001ef2,[CaseFold] = 0x001ef3}, NULL},
	{0x001ef3, {[CaseLower] = 0x001ef3,[CaseTitle] = 0x001ef2,[CaseUpper] = 0x001ef2,[CaseFold] = 0x001ef3}, NULL},
	{0x001ef4, {[CaseLower] = 0x001ef5,[CaseTitle] = 0x001ef4,[CaseUpper] = 0x001ef4,[CaseFold] = 0x001ef5}, NULL},
	{0x001ef5, {[CaseLower] = 0x001ef5,[CaseTitle] = 0x001ef4,[CaseUpper] = 0x001ef4,[CaseFold] = 0x001ef5}, NULL},
	{0x001ef6, {[CaseLower] = 0x001ef7,[CaseTitle] = 0x001ef6,[CaseUpper] = 0x001ef6,[CaseFold] = 0x001ef7}, NULL},
	{0x001ef7, {[CaseLower] = 0x001ef7,[CaseTitle] = 0x001ef6,[CaseUpper] = 0x001ef6,[CaseFold] = 0x001ef7}, NULL},
	{0x001ef8, {[CaseLower] = 0x001ef9,[CaseTitle] = 0x001ef8,[CaseUpper] = 0x001ef8,[CaseFold] = 0x001ef9}, NULL},
	{0x001ef9, {[CaseLower] = 0x001ef9,[CaseTitle] = 0x001ef8,[CaseUpper] = 0x001ef8,[CaseFold] = 0x001ef9}, NULL},
	{0x001efa, {[CaseLower] = 0x001efb,[CaseTitle] = 0x001efa,[CaseUpper] = 0x001efa,[CaseFold] = 0x001efb}, NULL},
	{0x001efb, {[CaseLower] = 0x001efb,[CaseTitle] = 0x001efa,[CaseUpper] = 0x001efa,[CaseFold] = 0x001efb}, NULL},
	{0x001efc, {[CaseLower] = 0x001efd,[CaseTitle] = 0x001efc,[CaseUpper] = 0x001efc,[CaseFold] = 0x001efd}, NULL},
	{0x001efd, {[CaseLower] = 0x001efd,[CaseTitle] = 0x001efc,[CaseUpper] = 0x001efc,[CaseFold] = 0x001efd}, NULL},
	{0x001efe, {[CaseLower] = 0x001eff,[CaseTitle] = 0x001efe,[CaseUpper] = 0x001efe,[CaseFold] = 0x001eff}, NULL},
	{0x001eff, {[CaseLower] = 0x001eff,[CaseTitle] = 0x001efe,[CaseUpper] = 0x001efe,[CaseFold] = 0x001eff}, NULL},
	{0x001f00, {[CaseLower] = 0x001f00,[CaseTitle] = 0x001f08,[CaseUpper] = 0x001f08,[CaseFold] = 0x001f00}, NULL},
	{0x001f01, {[CaseLower] = 0x001f01,[CaseTitle] = 0x001f09,[CaseUpper] = 0x001f09,[CaseFold] = 0x001f01}, NULL},
	{0x001f02, {[CaseLower] = 0x001f02,[CaseTitle] = 0x001f0a,[CaseUpper] = 0x001f0a,[CaseFold] = 0x001f02}, NULL},
	{0x001f03, {[CaseLower] = 0x001f03,[CaseTitle] = 0x001f0b,[CaseUpper] = 0x001f0b,[CaseFold] = 0x001f03}, NULL},
	{0x001f04, {[CaseLower] = 0x001f04,[CaseTitle] = 0x001f0c,[CaseUpper] = 0x001f0c,[CaseFold] = 0x001f04}, NULL},
	{0x001f05, {[CaseLower] = 0x001f05,[CaseTitle] = 0x001f0d,[CaseUpper] = 0x001f0d,[CaseFold] = 0x001f05}, NULL},
	{0x001f06, {[CaseLower] = 0x001f06,[CaseTitle] = 0x001f0e,[CaseUpper] = 0x001f0e,[CaseFold] = 0x001f06}, NULL},
	{0x001f07, {[CaseLower] = 0x001f07,[CaseTitle] = 0x001f0f,[CaseUpper] = 0x001f0f,[CaseFold] = 0x001f07}, NULL},
	{0x001f08, {[CaseLower] = 0x001f00,[CaseTitle] = 0x001f08,[CaseUpper] = 0x001f08,[CaseFold] = 0x001f00}, NULL},
	{0x001f09, {[CaseLower] = 0x001f01,[CaseTitle] = 0x001f09,[CaseUpper] = 0x001f09,[CaseFold] = 0x001f01}, NULL},
	{0x001f0a, {[CaseLower] = 0x001f02,[CaseTitle] = 0x001f0a,[CaseUpper] = 0x001f0a,[CaseFold] = 0x001f02}, NULL},
	{0x001f0b, {[CaseLower] = 0x001f03,[CaseTitle] = 0x001f0b,[CaseUpper] = 0x001f0b,[CaseFold] = 0x001f03}, NULL},
	{0x001f0c, {[CaseLower] = 0x001f04,[CaseTitle] = 0x001f0c,[CaseUpper] = 0x001f0c,[CaseFold] = 0x001f04}, NULL},
	{0x001f0d, {[CaseLower] = 0x001f05,[CaseTitle] = 0x001f0d,[CaseUpper] = 0x001f0d,[CaseFold] = 0x001f05}, NULL},
	{0x001f0e, {[CaseLower] = 0x001f06,[CaseTitle] = 0x001f0e,[CaseUpper] = 0x001f0e,[CaseFold] = 0x001f06}, NULL},
	{0x001f0f, {[CaseLower] = 0x001f07,[CaseTitle] = 0x001f0f,[CaseUpper] = 0x001f0f,[CaseFold] = 0x001f07}, NULL},
	{0x001f10, {[CaseLower] = 0x001f10,[CaseTitle] = 0x001f18,[CaseUpper] = 0x001f18,[CaseFold] = 0x001f10}, NULL},
	{0x001f11, {[CaseLower] = 0x001f11,[CaseTitle] = 0x001f19,[CaseUpper] = 0x001f19,[CaseFold] = 0x001f11}, NULL},
	{0x001f12, {[CaseLower] = 0x001f12,[CaseTitle] = 0x001f1a,[CaseUpper] = 0x001f1a,[CaseFold] = 0x001f12}, NULL},
	{0x001f13, {[CaseLower] = 0x001f13,[CaseTitle] = 0x001f1b,[CaseUpper] = 0x001f1b,[CaseFold] = 0x001f13}, NULL},
	{0x001f14, {[CaseLower] = 0x001f14,[CaseTitle] = 0x001f1c,[CaseUpper] = 0x001f1c,[CaseFold] = 0x001f14}, NULL},
	{0x001f15, {[CaseLower] = 0x001f15,[CaseTitle] = 0x001f1d,[CaseUpper] = 0x001f1d,[CaseFold] = 0x001f15}, NULL},
	{0x001f18, {[CaseLower] = 0x001f10,[CaseTitle] = 0x001f18,[CaseUpper] = 0x001f18,[CaseFold] = 0x001f10}, NULL},
	{0x001f19, {[CaseLower] = 0x001f11,[CaseTitle] = 0x001f19,[CaseUpper] = 0x001f19,[CaseFold] = 0x001f11}, NULL},
	{0x001f1a, {[CaseLower] = 0x001f12,[CaseTitle] = 0x001f1a,[CaseUpper] = 0x001f1a,[CaseFold] = 0x001f12}, NULL},
	{0x001f1b, {[CaseLower] = 0x001f13,[CaseTitle] = 0x001f1b,[CaseUpper] = 0x001f1b,[CaseFold] = 0x001f13}, NULL},
	{0x001f1c, {[CaseLower] = 0x001f14,[CaseTitle] = 0x001f1c,[CaseUpper] = 0x001f1c,[CaseFold] = 0x001f14}, NULL},
	{0x001f1d, {[CaseLower] = 0x001f15,[CaseTitle] = 0x001f1d,[CaseUpper] = 0x001f1d,[CaseFold] = 0x001f15}, NULL},
	{0x001f20, {[CaseLower] = 0x001f20,[CaseTitle] = 0x001f28,[CaseUpper] = 0x001f28,[CaseFold] = 0x001f20}, NULL},
	{0x001f21, {[CaseLower] = 0x001f21,[CaseTitle] = 0x001f29,[CaseUpper] = 0x001f29,[CaseFold] = 0x001f21}, NULL},
	{0x001f22, {[CaseLower] = 0x001f22,[CaseTitle] = 0x001f2a,[CaseUpper] = 0x001f2a,[CaseFold] = 0x001f22}, NULL},
	{0x001f23, {[CaseLower] = 0x001f23,[CaseTitle] = 0x001f2b,[CaseUpper] = 0x001f2b,[CaseFold] = 0x001f23}, NULL},
	{0x001f24, {[CaseLower] = 0x001f24,[CaseTitle] = 0x001f2c,[CaseUpper] = 0x001f2c,[CaseFold] = 0x001f24}, NULL},
	{0x001f25, {[CaseLower] = 0x001f25,[CaseTitle] = 0x001f2d,[CaseUpper] = 0x001f2d,[CaseFold] = 0x001f25}, NULL},
	{0x001f26, {[CaseLower] = 0x001f26,[CaseTitle] = 0x001f2e,[CaseUpper] = 0x001f2e,[CaseFold] = 0x001f26}, NULL},
	{0x001f27, {[CaseLower] = 0x001f27,[CaseTitle] = 0x001f2f,[CaseUpper] = 0x001f2f,[CaseFold] = 0x001f27}, NULL},
	{0x001f28, {[CaseLower] = 0x001f20,[CaseTitle] = 0x001f28,[CaseUpper] = 0x001f28,[CaseFold] = 0x001f20}, NULL},
	{0x001f29, {[CaseLower] = 0x001f21,[CaseTitle] = 0x001f29,[CaseUpper] = 0x001f29,[CaseFold] = 0x001f21}, NULL},
	{0x001f2a, {[CaseLower] = 0x001f22,[CaseTitle] = 0x001f2a,[CaseUpper] = 0x001f2a,[CaseFold] = 0x001f22}, NULL},
	{0x001f2b, {[CaseLower] = 0x001f23,[CaseTitle] = 0x001f2b,[CaseUpper] = 0x001f2b,[CaseFold] = 0x001f23}, NULL},
	{0x001f2c, {[CaseLower] = 0x001f24,[CaseTitle] = 0x001f2c,[CaseUpper] = 0x001f2c,[CaseFold] = 0x001f24}, NULL},
	{0x001f2d, {[CaseLower] = 0x001f25,[CaseTitle] = 0x001f2d,[CaseUpper] = 0x001f2d,[CaseFold] = 0x001f25}, NULL},
	{0x001f2e, {[CaseLower] = 0x001f26,[CaseTitle] = 0x001f2e,[CaseUpper] = 0x001f2e,[CaseFold] = 0x001f26}, NULL},
	{0x001f2f, {[CaseLower] = 0x001f27,[CaseTitle] = 0x001f2f,[CaseUpper] = 0x001f2f,[CaseFold] = 0x001f27}, NULL},
	{0x001f30, {[CaseLower] = 0x001f30,[CaseTitle] = 0x001f38,[CaseUpper] = 0x001f38,[CaseFold] = 0x001f30}, NULL},
	{0x001f31, {[CaseLower] = 0x001f31,[CaseTitle] = 0x001f39,[CaseUpper] = 0x001f39,[CaseFold] = 0x001f31}, NULL},
	{0x001f32, {[CaseLower] = 0x001f32,[CaseTitle] = 0x001f3a,[CaseUpper] = 0x001f3a,[CaseFold] = 0x001f32}, NULL},
	{0x001f33, {[CaseLower] = 0x001f33,[CaseTitle] = 0x001f3b,[CaseUpper] = 0x001f3b,[CaseFold] = 0x001f33}, NULL},
	{0x001f34, {[CaseLower] = 0x001f34,[CaseTitle] = 0x001f3c,[CaseUpper] = 0x001f3c,[CaseFold] = 0x001f34}, NULL},
	{0x001f35, {[CaseLower] = 0x001f35,[CaseTitle] = 0x001f3d,[CaseUpper] = 0x001f3d,[CaseFold] = 0x001f35}, NULL},
	{0x001f36, {[CaseLower] = 0x001f36,[CaseTitle] = 0x001f3e,[CaseUpper] = 0x001f3e,[CaseFold] = 0x001f36}, NULL},
	{0x001f37, {[CaseLower] = 0x001f37,[CaseTitle] = 0x001f3f,[CaseUpper] = 0x001f3f,[CaseFold] = 0x001f37}, NULL},
	{0x001f38, {[CaseLower] = 0x001f30,[CaseTitle] = 0x001f38,[CaseUpper] = 0x001f38,[CaseFold] = 0x001f30}, NULL},
	{0x001f39, {[CaseLower] = 0x001f31,[CaseTitle] = 0x001f39,[CaseUpper] = 0x001f39,[CaseFold] = 0x001f31}, NULL},
	{0x001f3a, {[CaseLower] = 0x001f32,[CaseTitle] = 0x001f3a,[CaseUpper] = 0x001f3a,[CaseFold] = 0x001f32}, NULL},
	{0x001f3b, {[CaseLower] = 0x001f33,[CaseTitle] = 0x001f3b,[CaseUpper] = 0x001f3b,[CaseFold] = 0x001f33}, NULL},
	{0x001f3c, {[CaseLower] = 0x001f34,[CaseTitle] = 0x001f3c,[CaseUpper] = 0x001f3c,[CaseFold] = 0x001f34}, NULL},
	{0x001f3d, {[CaseLower] = 0x001f35,[CaseTitle] = 0x001f3d,[CaseUpper] = 0x001f3d,[CaseFold] = 0x001f35}, NULL},
	{0x001f3e, {[CaseLower] = 0x001f36,[CaseTitle] = 0x001f3e,[CaseUpper] = 0x001f3e,[CaseFold] = 0x001f36}, NULL},
	{0x001f3f, {[CaseLower] = 0x001f37,[CaseTitle] = 0x001f3f,[CaseUpper] = 0x001f3f,[CaseFold] = 0x001f37}, NULL},
	{0x001f40, {[CaseLower] = 0x001f40,[CaseTitle] = 0x001f48,[CaseUpper] = 0x001f48,[CaseFold] = 0x001f40}, NULL},
	{0x001f41, {[CaseLower] = 0x001f41,[CaseTitle] = 0x001f49,[CaseUpper] = 0x001f49,[CaseFold] = 0x001f41}, NULL},
	{0x001f42, {[CaseLower] = 0x001f42,[CaseTitle] = 0x001f4a,[CaseUpper] = 0x001f4a,[CaseFold] = 0x001f42}, NULL},
	{0x001f43, {[CaseLower] = 0x001f43,[CaseTitle] = 0x001f4b,[CaseUpper] = 0x001f4b,[CaseFold] = 0x001f43}, NULL},
	{0x001f44, {[CaseLower] = 0x001f44,[CaseTitle] = 0x001f4c,[CaseUpper] = 0x001f4c,[CaseFold] = 0x001f44}, NULL},
	{0x001f45, {[CaseLower] = 0x001f45,[CaseTitle] = 0x001f4d,[CaseUpper] = 0x001f4d,[CaseFold] = 0x001f45}, NULL},
	{0x001f48, {[CaseLower] = 0x001f40,[CaseTitle] = 0x001f48,[CaseUpper] = 0x001f48,[CaseFold] = 0x001f40}, NULL},
	{0x001f49, {[CaseLower] = 0x001f41,[CaseTitle] = 0x001f49,[CaseUpper] = 0x001f49,[CaseFold] = 0x001f41}, NULL},
	{0x001f4a, {[CaseLower] = 0x001f42,[CaseTitle] = 0x001f4a,[CaseUpper] = 0x001f4a,[CaseFold] = 0x001f42}, NULL},
	{0x001f4b, {[CaseLower] = 0x001f43,[CaseTitle] = 0x001f4b,[CaseUpper] = 0x001f4b,[CaseFold] = 0x001f43}, NULL},
	{0x001f4c, {[CaseLower] = 0x001f44,[CaseTitle] = 0x001f4c,[CaseUpper] = 0x001f4c,[CaseFold] = 0x001f44}, NULL},
	{0x001f4d, {[CaseLower] = 0x001f45,[CaseTitle] = 0x001f4d,[CaseUpper] = 0x001f4d,[CaseFold] = 0x001f45}, NULL},
	{0x001f50, {[CaseLower] = 0x001f50,[CaseTitle] = 0x001f50,[CaseUpper] = 0x001f50,[CaseFold] = 0x001f50}, &special_case[14]},
	{0x001f51, {[CaseLower] = 0x001f51,[CaseTitle] = 0x001f59,[CaseUpper] = 0x001f59,[CaseFold] = 0x001f51}, NULL},
	{0x001f52, {[CaseLower] = 0x001f52,[CaseTitle] = 0x001f52,[CaseUpper] = 0x001f52,[CaseFold] = 0x001f52}, &special_case[15]},
	{0x001f53, {[CaseLower] = 0x001f53,[CaseTitle] = 0x001f5b,[CaseUpper] = 0x001f5b,[CaseFold] = 0x001f53}, NULL},
	{0x001f54, {[CaseLower] = 0x001f54,[CaseTitle] = 0x001f54,[CaseUpper] = 0x001f54,[CaseFold] = 0x001f54}, &special_case[16]},
	{0x001f55, {[CaseLower] = 0x001f55,[CaseTitle] = 0x001f5d,[CaseUpper] = 0x001f5d,[CaseFold] = 0x001f55}, NULL},
	{0x001f56, {[CaseLower] = 0x001f56,[CaseTitle] = 0x001f56,[CaseUpper] = 0x001f56,[CaseFold] = 0x001f56}, &special_case[17]},
	{0x001f57, {[CaseLower] = 0x001f57,[CaseTitle] = 0x001f5f,[CaseUpper] = 0x001f5f,[CaseFold] = 0x001f57}, NULL},
	{0x001f59, {[CaseLower] = 0x001f51,[CaseTitle] = 0x001f59,[CaseUpper] = 0x001f59,[CaseFold] = 0x001f51}, NULL},
	{0x001f5b, {[CaseLower] = 0x001f53,[CaseTitle] = 0x001f5b,[CaseUpper] = 0x001f5b,[CaseFold] = 0x001f53}, NULL},
	{0x001f5d, {[CaseLower] = 0x001f55,[CaseTitle] = 0x001f5d,[CaseUpper] = 0x001f5d,[CaseFold] = 0x001f55}, NULL},
	{0x001f5f, {[CaseLower] = 0x001f57,[CaseTitle] = 0x001f5f,[CaseUpper] = 0x001f5f,[CaseFold] = 0x001f57}, NULL},
	{0x001f60, {[CaseLower] = 0x001f60,[CaseTitle] = 0x001f68,[CaseUpper] = 0x001f68,[CaseFold] = 0x001f60}, NULL},
	{0x001f61, {[CaseLower] = 0x001f61,[CaseTitle] = 0x001f69,[CaseUpper] = 0x001f69,[CaseFold] = 0x001f61}, NULL},
	{0x001f62, {[CaseLower] = 0x001f62,[CaseTitle] = 0x001f6a,[CaseUpper] = 0x001f6a,[CaseFold] = 0x001f62}, NULL},
	{0x001f63, {[CaseLower] = 0x001f63,[CaseTitle] = 0x001f6b,[CaseUpper] = 0x001f6b,[CaseFold] = 0x001f63}, NULL},
	{0x001f64, {[CaseLower] = 0x001f64,[CaseTitle] = 0x001f6c,[CaseUpper] = 0x001f6c,[CaseFold] = 0x001f64}, NULL},
	{0x001f65, {[CaseLower] = 0x001f65,[CaseTitle] = 0x001f6d,[CaseUpper] = 0x001f6d,[CaseFold] = 0x001f65}, NULL},
	{0x001f66, {[CaseLower] = 0x001f66,[CaseTitle] = 0x001f6e,[CaseUpper] = 0x001f6e,[CaseFold] = 0x001f66}, NULL},
	{0x001f67, {[CaseLower] = 0x001f67,[CaseTitle] = 0x001f6f,[CaseUpper] = 0x001f6f,[CaseFold] = 0x001f67}, NULL},
	{0x001f68, {[CaseLower] = 0x001f60,[CaseTitle] = 0x001f68,[CaseUpper] = 0x001f68,[CaseFold] = 0x001f60}, NULL},
	{0x001f69, {[CaseLower] = 0x001f61,[CaseTitle] = 0x001f69,[CaseUpper] = 0x001f69,[CaseFold] = 0x001f61}, NULL},
	{0x001f6a, {[CaseLower] = 0x001f62,[CaseTitle] = 0x001f6a,[CaseUpper] = 0x001f6a,[CaseFold] = 0x001f62}, NULL},
	{0x001f6b, {[CaseLower] = 0x001f63,[CaseTitle] = 0x001f6b,[CaseUpper] = 0x001f6b,[CaseFold] = 0x001f63}, NULL},
	{0x001f6c, {[CaseLower] = 0x001f64,[CaseTitle] = 0x001f6c,[CaseUpper] = 0x001f6c,[CaseFold] = 0x001f64}, NULL},
	{0x001f6d, {[CaseLower] = 0x001f65,[CaseTitle] = 0x001f6d,[CaseUpper] = 0x001f6d,[CaseFold] = 0x001f65}, NULL},
	{0x001f6e, {[CaseLower] = 0x001f66,[CaseTitle] = 0x001f6e,[CaseUpper] = 0x001f6e,[CaseFold] = 0x001f66}, NULL},
	{0x001f6f, {[CaseLower] = 0x001f67,[CaseTitle] = 0x001f6f,[CaseUpper] = 0x001f6f,[CaseFold] = 0x001f67}, NULL},
	{0x001f70, {[CaseLower] = 0x001f70,[CaseTitle] = 0x001fba,[CaseUpper] = 0x001fba,[CaseFold] = 0x001f70}, NULL},
	{0x001f71, {[CaseLower] = 0x001f71,[CaseTitle] = 0x001fbb,[CaseUpper] = 0x001fbb,[CaseFold] = 0x001f71}, NULL},
	{0x001f72, {[CaseLower] = 0x001f72,[CaseTitle] = 0x001fc8,[CaseUpper] = 0x001fc8,[CaseFold] = 0x001f72}, NULL},
	{0x001f73, {[CaseLower] = 0x001f73,[CaseTitle] = 0x001fc9,[CaseUpper] = 0x001fc9,[CaseFold] = 0x001f73}, NULL},
	{0x001f74, {[CaseLower] = 0x001f74,[CaseTitle] = 0x001fca,[CaseUpper] = 0x001fca,[CaseFold] = 0x001f74}, NULL},
	{0x001f75, {[CaseLower] = 0x001f75,[CaseTitle] = 0x001fcb,[CaseUpper] = 0x001fcb,[CaseFold] = 0x001f75}, NULL},
	{0x001f76, {[CaseLower] = 0x001f76,[CaseTitle] = 0x001fda,[CaseUpper] = 0x001fda,[CaseFold] = 0x001f76}, NULL},
	{0x001f77, {[CaseLower] = 0x001f77,[CaseTitle] = 0x001fdb,[CaseUpper] = 0x001fdb,[CaseFold] = 0x001f77}, NULL},
	{0x001f78, {[CaseLower] = 0x001f78,[CaseTitle] = 0x001ff8,[CaseUpper] = 0x001ff8,[CaseFold] = 0x001f78}, NULL},
	{0x001f79, {[CaseLower] = 0x001f79,[CaseTitle] = 0x001ff9,[CaseUpper] = 0x001ff9,[CaseFold] = 0x001f79}, NULL},
	{0x001f7a, {[CaseLower] = 0x001f7a,[CaseTitle] = 0x001fea,[CaseUpper] = 0x001fea,[CaseFold] = 0x001f7a}, NULL},
	{0x001f7b, {[CaseLower] = 0x001f7b,[CaseTitle] = 0x001feb,[CaseUpper] = 0x001feb,[CaseFold] = 0x001f7b}, NULL},
	{0x001f7c, {[CaseLower] = 0x001f7c,[CaseTitle] = 0x001ffa,[CaseUpper] = 0x001ffa,[CaseFold] = 0x001f7c}, NULL},
	{0x001f7d, {[CaseLower] = 0x001f7d,[CaseTitle] = 0x001ffb,[CaseUpper] = 0x001ffb,[CaseFold] = 0x001f7d}, NULL},
	{0x001f80, {[CaseLower] = 0x001f80,[CaseTitle] = 0x001f88,[CaseUpper] = 0x001f88,[CaseFold] = 0x001f80}, &special_case[18]},
	{0x001f81, {[CaseLower] = 0x001f81,[CaseTitle] = 0x001f89,[CaseUpper] = 0x001f89,[CaseFold] = 0x001f81}, &special_case[19]},
	{0x001f82, {[CaseLower] = 0x001f82,[CaseTitle] = 0x001f8a,[CaseUpper] = 0x001f8a,[CaseFold] = 0x001f82}, &special_case[20]},
	{0x001f83, {[CaseLower] = 0x001f83,[CaseTitle] = 0x001f8b,[CaseUpper] = 0x001f8b,[CaseFold] = 0x001f83}, &special_case[21]},
	{0x001f84, {[CaseLower] = 0x001f84,[CaseTitle] = 0x001f8c,[CaseUpper] = 0x001f8c,[CaseFold] = 0x001f84}, &special_case[22]},
	{0x001f85, {[CaseLower] = 0x001f85,[CaseTitle] = 0x001f8d,[CaseUpper] = 0x001f8d,[CaseFold] = 0x001f85}, &special_case[23]},
	{0x001f86, {[CaseLower] = 0x001f86,[CaseTitle] = 0x001f8e,[CaseUpper] = 0x001f8e,[CaseFold] = 0x001f86}, &special_case[24]},
	{0x001f87, {[CaseLower] = 0x001f87,[CaseTitle] = 0x001f8f,[CaseUpper] = 0x001f8f,[CaseFold] = 0x001f87}, &special_case[25]},
	{0x001f88, {[CaseLower] = 0x001f80,[CaseTitle] = 0x001f88,[CaseUpper] = 0x001f88,[CaseFold] = 0x001f80}, &special_case[26]},
	{0x001f89, {[CaseLower] = 0x001f81,[CaseTitle] = 0x001f89,[CaseUpper] = 0x001f89,[CaseFold] = 0x001f81}, &special_case[27]},
	{0x001f8a, {[CaseLower] = 0x001f82,[CaseTitle] = 0x001f8a,[CaseUpper] = 0x001f8a,[CaseFold] = 0x001f82}, &special_case[28]},
	{0x001f8b, {[CaseLower] = 0x001f83,[CaseTitle] = 0x001f8b,[CaseUpper] = 0x001f8b,[CaseFold] = 0x001f83}, &special_case[29]},
	{0x001f8c, {[CaseLower] = 0x001f84,[CaseTitle] = 0x001f8c,[CaseUpper] = 0x001f8c,[CaseFold] = 0x001f84}, &special_case[30]},
	{0x001f8d, {[CaseLower] = 0x001f85,[CaseTitle] = 0x001f8d,[CaseUpper] = 0x001f8d,[CaseFold] = 0x001f85}, &special_case[31]},
	{0x001f8e, {[CaseLower] = 0x001f86,[CaseTitle] = 0x001f8e,[CaseUpper] = 0x001f8e,[CaseFold] = 0x001f86}, &special_case[32]},
	{0x001f8f, {[CaseLower] = 0x001f87,[CaseTitle] = 0x001f8f,[CaseUpper] = 0x001f8f,[CaseFold] = 0x001f87}, &special_case[33]},
	{0x001f90, {[CaseLower] = 0x001f90,[CaseTitle] = 0x001f98,[CaseUpper] = 0x001f98,[CaseFold] = 0x001f90}, &special_case[34]},
	{0x001f91, {[CaseLower] = 0x001f91,[CaseTitle] = 0x001f99,[CaseUpper] = 0x001f99,[CaseFold] = 0x001f91}, &special_case[35]},
	{0x001f92, {[CaseLower] = 0x001f92,[CaseTitle] = 0x001f9a,[CaseUpper] = 0x001f9a,[CaseFold] = 0x001f92}, &special_case[36]},
	{0x001f93, {[CaseLower] = 0x001f93,[CaseTitle] = 0x001f9b,[CaseUpper] = 0x001f9b,[CaseFold] = 0x001f93}, &special_case[37]},
	{0x001f94, {[CaseLower] = 0x001f94,[CaseTitle] = 0x001f9c,[CaseUpper] = 0x001f9c,[CaseFold] = 0x001f94}, &special_case[38]},
	{0x001f95, {[CaseLower] = 0x001f95,[CaseTitle] = 0x001f9d,[CaseUpper] = 0x001f9d,[CaseFold] = 0x001f95}, &special_case[39]},
	{0x001f96, {[CaseLower] = 0x001f96,[CaseTitle] = 0x001f9e,[CaseUpper] = 0x001f9e,[CaseFold] = 0x001f96}, &special_case[40]},
	{0x001f97, {[CaseLower] = 0x001f97,[CaseTitle] = 0x001f9f,[CaseUpper] = 0x001f9f,[CaseFold] = 0x001f97}, &special_case[41]},
	{0x001f98, {[CaseLower] = 0x001f90,[CaseTitle] = 0x001f98,[CaseUpper] = 0x001f98,[CaseFold] = 0x001f90}, &special_case[42]},
	{0x001f99, {[CaseLower] = 0x001f91,[CaseTitle] = 0x001f99,[CaseUpper] = 0x001f99,[CaseFold] = 0x001f91}, &special_case[43]},
	{0x001f9a, {[CaseLower] = 0x001f92,[CaseTitle] = 0x001f9a,[CaseUpper] = 0x001f9a,[CaseFold] = 0x001f92}, &special_case[44]},
	{0x001f9b, {[CaseLower] = 0x001f93,[CaseTitle] = 0x001f9b,[CaseUpper] = 0x001f9b,[CaseFold] = 0x001f93}, &special_case[45]},
	{0x001f9c, {[CaseLower] = 0x001f94,[CaseTitle] = 0x001f9c,[CaseUpper] = 0x001f9c,[CaseFold] = 0x001f94}, &special_case[46]},
	{0x001f9d, {[CaseLower] = 0x001f95,[CaseTitle] = 0x001f9d,[CaseUpper] = 0x001f9d,[CaseFold] = 0x001f95}, &special_case[47]},
	{0x001f9e, {[CaseLower] = 0x001f96,[CaseTitle] = 0x001f9e,[CaseUpper] = 0x001f9e,[CaseFold] = 0x001f96}, &special_case[48]},
	{0x001f9f, {[CaseLower] = 0x001f97,[CaseTitle] = 0x001f9f,[CaseUpper] = 0x001f9f,[CaseFold] = 0x001f97}, &special_case[49]},
	{0x001fa0, {[CaseLower] = 0x001fa0,[CaseTitle] = 0x001fa8,[CaseUpper] = 0x001fa8,[CaseFold] = 0x001fa0}, &special_case[50]},
	{0x001fa1, {[CaseLower] = 0x001fa1,[CaseTitle] = 0x001fa9,[CaseUpper] = 0x001fa9,[CaseFold] = 0x001fa1}, &special_case[51]},
	{0x001fa2, {[CaseLower] = 0x001fa2,[CaseTitle] = 0x001faa,[CaseUpper] = 0x001faa,[CaseFold] = 0x001fa2}, &special_case[52]},
	{0x001fa3, {[CaseLower] = 0x001fa3,[CaseTitle] = 0x001fab,[CaseUpper] = 0x001fab,[CaseFold] = 0x001fa3}, &special_case[53]},
	{0x001fa4, {[CaseLower] = 0x001fa4,[CaseTitle] = 0x001fac,[CaseUpper] = 0x001fac,[CaseFold] = 0x001fa4}, &special_case[54]},
	{0x001fa5, {[CaseLower] = 0x001fa5,[CaseTitle] = 0x001fad,[CaseUpper] = 0x001fad,[CaseFold] = 0x001fa5}, &special_case[55]},
	{0x001fa6, {[CaseLower] = 0x001fa6,[CaseTitle] = 0x001fae,[CaseUpper] = 0x001fae,[CaseFold] = 0x001fa6}, &special_case[56]},
	{0x001fa7, {[CaseLower] = 0x001fa7,[CaseTitle] = 0x001faf,[CaseUpper] = 0x001faf,[CaseFold] = 0x001fa7}, &special_case[57]},
	{0x001fa8, {[CaseLower] = 0x001fa0,[CaseTitle] = 0x001fa8,[CaseUpper] = 0x001fa8,[CaseFold] = 0x001fa0}, &special_case[58]},
	{0x001fa9, {[CaseLower] = 0x001fa1,[CaseTitle] = 0x001fa9,[CaseUpper] = 0x001fa9,[CaseFold] = 0x001fa1}, &special_case[59]},
	{0x001faa, {[CaseLower] = 0x001fa2,[CaseTitle] = 0x001faa,[CaseUpper] = 0x001faa,[CaseFold] = 0x001fa2}, &special_case[60]},
	{0x001fab, {[CaseLower] = 0x001fa3,[CaseTitle] = 0x001fab,[CaseUpper] = 0x001fab,[CaseFold] = 0x001fa3}, &special_case[61]},
	{0x001fac, {[CaseLower] = 0x001fa4,[CaseTitle] = 0x001fac,[CaseUpper] = 0x001fac,[CaseFold] = 0x001fa4}, &special_case[62]},
	{0x001fad, {[CaseLower] = 0x001fa5,[CaseTitle] = 0x001fad,[CaseUpper] = 0x001fad,[CaseFold] = 0x001fa5}, &special_case[63]},
	{0x001fae, {[CaseLower] = 0x001fa6,[CaseTitle] = 0x001fae,[CaseUpper] = 0x001fae,[CaseFold] = 0x001fa6}, &special_case[64]},
	{0x001faf, {[CaseLower] = 0x001fa7,[CaseTitle] = 0x001faf,[CaseUpper] = 0x001faf,[CaseFold] = 0x001fa7}, &special_case[65]},
	{0x001fb0, {[CaseLower] = 0x001fb0,[CaseTitle] = 0x001fb8,[CaseUpper] = 0x001fb8,[CaseFold] = 0x001fb0}, NULL},
	{0x001fb1, {[CaseLower] = 0x001fb1,[CaseTitle] = 0x001fb9,[CaseUpper] = 0x001fb9,[CaseFold] = 0x001fb1}, NULL},
	{0x001fb2, {[CaseLower] = 0x001fb2,[CaseTitle] = 0x001fb2,[CaseUpper] = 0x001fb2,[CaseFold] = 0x001fb2}, &special_case[66]},
	{0x001fb3, {[CaseLower] = 0x001fb3,[CaseTitle] = 0x001fbc,[CaseUpper] = 0x001fbc,[CaseFold] = 0x001fb3}, &special_case[67]},
	{0x001fb4, {[CaseLower] = 0x001fb4,[CaseTitle] = 0x001fb4,[CaseUpper] = 0x001fb4,[CaseFold] = 0x001fb4}, &special_case[68]},
	{0x001fb6, {[CaseLower] = 0x001fb6,[CaseTitle] = 0x001fb6,[CaseUpper] = 0x001fb6,[CaseFold] = 0x001fb6}, &special_case[69]},
	{0x001fb7, {[CaseLower] = 0x001fb7,[CaseTitle] = 0x001fb7,[CaseUpper] = 0x001fb7,[CaseFold] = 0x001fb7}, &special_case[70]},
	{0x001fb8, {[CaseLower] = 0x001fb0,[CaseTitle] = 0x001fb8,[CaseUpper] = 0x001fb8,[CaseFold] = 0x001fb0}, NULL},
	{0x001fb9, {[CaseLower] = 0x001fb1,[CaseTitle] = 0x001fb9,[CaseUpper] = 0x001fb9,[CaseFold] = 0x001fb1}, NULL},
	{0x001fba, {[CaseLower] = 0x001f70,[CaseTitle] = 0x001fba,[CaseUpper] = 0x001fba,[CaseFold] = 0x001f70}, NULL},
	{0x001fbb, {[CaseLower] = 0x001f71,[CaseTitle] = 0x001fbb,[CaseUpper] = 0x001fbb,[CaseFold] = 0x001f71}, NULL},
	{0x001fbc, {[CaseLower] = 0x001fb3,[CaseTitle] = 0x001fbc,[CaseUpper] = 0x001fbc,[CaseFold] = 0x001fb3}, &special_case[71]},
	{0x001fbe, {[CaseLower] = 0x001fbe,[CaseTitle] = 0x000399,[CaseUpper] = 0x000399,[CaseFold] = 0x0003b9}, NULL},
	{0x001fc2, {[CaseLower] = 0x001fc2,[CaseTitle] = 0x001fc2,[CaseUpper] = 0x001fc2,[CaseFold] = 0x001fc2}, &special_case[72]},
	{0x001fc3, {[CaseLower] = 0x001fc3,[CaseTitle] = 0x001fcc,[CaseUpper] = 0x001fcc,[CaseFold] = 0x001fc3}, &special_case[73]},
	{0x001fc4, {[CaseLower] = 0x001fc4,[CaseTitle] = 0x001fc4,[CaseUpper] = 0x001fc4,[CaseFold] = 0x001fc4}, &special_case[74]},
	{0x001fc6, {[CaseLower] = 0x001fc6,[CaseTitle] = 0x001fc6,[CaseUpper] = 0x001fc6,[CaseFold] = 0x001fc6}, &special_case[75]},
	{0x001fc7, {[CaseLower] = 0x001fc7,[CaseTitle] = 0x001fc7,[CaseUpper] = 0x001fc7,[CaseFold] = 0x001fc7}, &special_case[76]},
	{0x001fc8, {[CaseLower] = 0x001f72,[CaseTitle] = 0x001fc8,[CaseUpper] = 0x001fc8,[CaseFold] = 0x001f72}, NULL},
	{0x001fc9, {[CaseLower] = 0x001f73,[CaseTitle] = 0x001fc9,[CaseUpper] = 0x001fc9,[CaseFold] = 0x001f73}, NULL},
	{0x001fca, {[CaseLower] = 0x001f74,[CaseTitle] = 0x001fca,[CaseUpper] = 0x001fca,[CaseFold] = 0x001f74}, NULL},
	{0x001fcb, {[CaseLower] = 0x001f75,[CaseTitle] = 0x001fcb,[CaseUpper] = 0x001fcb,[CaseFold] = 0x001f75}, NULL},
	{0x001fcc, {[CaseLower] = 0x001fc3,[CaseTitle] = 0x001fcc,[CaseUpper] = 0x001fcc,[CaseFold] = 0x001fc3}, &special_case[77]},
	{0x001fd0, {[CaseLower] = 0x001fd0,[CaseTitle] = 0x001fd8,[CaseUpper] = 0x001fd8,[CaseFold] = 0x001fd0}, NULL},
	{0x001fd1, {[CaseLower] = 0x001fd1,[CaseTitle] = 0x001fd9,[CaseUpper] = 0x001fd9,[CaseFold] = 0x001fd1}, NULL},
	{0x001fd2, {[CaseLower] = 0x001fd2,[CaseTitle] = 0x001fd2,[CaseUpper] = 0x001fd2,[CaseFold] = 0x001fd2}, &special_case[78]},
	{0x001fd3, {[CaseLower] = 0x001fd3,[CaseTitle] = 0x001fd3,[CaseUpper] = 0x001fd3,[CaseFold] = 0x000390}, &special_case[79]},
	{0x001fd6, {[CaseLower] = 0x001fd6,[CaseTitle] = 0x001fd6,[CaseUpper] = 0x001fd6,[CaseFold] = 0x001fd6}, &special_case[80]},
	{0x001fd7, {[CaseLower] = 0x001fd7,[CaseTitle] = 0x001fd7,[CaseUpper] = 0x001fd7,[CaseFold] = 0x001fd7}, &special_case[81]},
	{0x001fd8, {[CaseLower] = 0x001fd0,[CaseTitle] = 0x001fd8,[CaseUpper] = 0x001fd8,[CaseFold] = 0x001fd0}, NULL},
	{0x001fd9, {[CaseLower] = 0x001fd1,[CaseTitle] = 0x001fd9,[CaseUpper] = 0x001fd9,[CaseFold] = 0x001fd1}, NULL},
	{0x001fda, {[CaseLower] = 0x001f76,[CaseTitle] = 0x001fda,[CaseUpper] = 0x001fda,[CaseFold] = 0x001f76}, NULL},
	{0x001fdb, {[CaseLower] = 0x001f77,[CaseTitle] = 0x001fdb,[CaseUpper] = 0x001fdb,[CaseFold] = 0x001f77}, NULL},
	{0x001fe0, {[CaseLower] = 0x001fe0,[CaseTitle] = 0x001fe8,[CaseUpper] = 0x001fe8,[CaseFold] = 0x001fe0}, NULL},
	{0x001fe1, {[CaseLower] = 0x001fe1,[CaseTitle] = 0x001fe9,[CaseUpper] = 0x001fe9,[CaseFold] = 0x001fe1}, NULL},
	{0x001fe2, {[CaseLower] = 0x001fe2,[CaseTitle] = 0x001fe2,[CaseUpper] = 0x001fe2,[CaseFold] = 0x001fe2}, &special_case[82]},
	{0x001fe3, {[CaseLower] = 0x001fe3,[CaseTitle] = 0x001fe3,[CaseUpper] = 0x001fe3,[CaseFold] = 0x0003b0}, &special_case[83]},
	{0x001fe4, {[CaseLower] = 0x001fe4,[CaseTitle] = 0x001fe4,[CaseUpper] = 0x001fe4,[CaseFold] = 0x001fe4}, &special_case[84]},
	{0x001fe5, {[CaseLower] = 0x001fe5,[CaseTitle] = 0x001fec,[CaseUpper] = 0x001fec,[CaseFold] = 0x001fe5}, NULL},
	{0x001fe6, {[CaseLower] = 0x001fe6,[CaseTitle] = 0x001fe6,[CaseUpper] = 0x001fe6,[CaseFold] = 0x001fe6}, &special_case[85]},
	{0x001fe7, {[CaseLower] = 0x001fe7,[CaseTitle] = 0x001fe7,[CaseUpper] = 0x001fe7,[CaseFold] = 0x001fe7}, &special_case[86]},
	{0x001fe8, {[CaseLower] = 0x001fe0,[CaseTitle] = 0x001fe8,[CaseUpper] = 0x001fe8,[CaseFold] = 0x001fe0}, NULL},
	{0x001fe9, {[CaseLower] = 0x001fe1,[CaseTitle] = 0x001fe9,[CaseUpper] = 0x001fe9,[CaseFold] = 0x001fe1}, NULL},
	{0x001fea, {[CaseLower] = 0x001f7a,[CaseTitle] = 0x001fea,[CaseUpper] = 0x001fea,[CaseFold] = 0x001f7a}, NULL},
	{0x001feb, {[CaseLower] = 0x001f7b,[CaseTitle] = 0x001feb,[CaseUpper] = 0x001feb,[CaseFold] = 0x001f7b}, NULL},
	{0x001fec, {[CaseLower] = 0x001fe5,[CaseTitle] = 0x001fec,[CaseUpper] = 0x001fec,[CaseFold] = 0x001fe5}, NULL},
	{0x001ff2, {[CaseLower] = 0x001ff2,[CaseTitle] = 0x001ff2,[CaseUpper] = 0x001ff2,[CaseFold] = 0x001ff2}, &special_case[87]},
	{0x001ff3, {[CaseLower] = 0x001ff3,[CaseTitle] = 0x001ffc,[CaseUpper] = 0x001ffc,[CaseFold] = 0x001ff3}, &special_case[88]},
	{0x001ff4, {[CaseLower] = 0x001ff4,[CaseTitle] = 0x001ff4,[CaseUpper] = 0x001ff4,[CaseFold] = 0x001ff4}, &special_case[89]},
	{0x001ff6, {[CaseLower] = 0x001ff6,[CaseTitle] = 0x001ff6,[CaseUpper] = 0x001ff6,[CaseFold] = 0x001ff6}, &special_case[90]},
	{0x001ff7, {[CaseLower] = 0x001ff7,[CaseTitle] = 0x001ff7,[CaseUpper] = 0x001ff7,[CaseFold] = 0x001ff7}, &special_case[91]},
	{0x001ff8, {[CaseLower] = 0x001f78,[CaseTitle] = 0x001ff8,[CaseUpper] = 0x001ff8,[CaseFold] = 0x001f78}, NULL},
	{0x001ff9, {[CaseLower] = 0x001f79,[CaseTitle] = 0x001ff9,[CaseUpper] = 0x001ff9,[CaseFold] = 0x001f79}, NULL},
	{0x001ffa, {[CaseLower] = 0x001f7c,[CaseTitle] = 0x001ffa,[CaseUpper] = 0x001ffa,[CaseFold] = 0x001f7c}, NULL},
	{0x001ffb, {[CaseLower] = 0x001f7d,[CaseTitle] = 0x001ffb,[CaseUpper] = 0x001ffb,[CaseFold] = 0x001f7d}, NULL},
	{0x001ffc, {[CaseLower] = 0x001ff3,[CaseTitle] = 0x001ffc,[CaseUpper] = 0x001ffc,[CaseFold] = 0x001ff3}, &special_case[92]},
	{0x002126, {[CaseLower] = 0x0003c9,[CaseTitle] = 0x002126,[CaseUpper] = 0x002126,[CaseFold] = 0x0003c9}, NULL},
	{0x00212a, {[CaseLower] = 0x00006b,[CaseTitle] = 0x00212a,[CaseUpper] = 0x00212a,[CaseFold] = 0x00006b}, NULL},
	{0x00212b, {[CaseLower] = 0x0000e5,[CaseTitle] = 0x00212b,[CaseUpper] = 0x00212b,[CaseFold] = 0x0000e5}, NULL},
	{0x002132, {[CaseLower] = 0x00214e,[CaseTitle] = 0x002132,[CaseUpper] = 0x002132,[CaseFold] = 0x00214e}, NULL},
	{0x00214e, {[CaseLower] = 0x00214e,[CaseTitle] = 0x002132,[CaseUpper] = 0x002132,[CaseFold] = 0x00214e}, NULL},
	{0x002160, {[CaseLower] = 0x002170,[CaseTitle] = 0x002160,[CaseUpper] = 0x002160,[CaseFold] = 0x002170}, NULL},
	{0x002161, {[CaseLower] = 0x002171,[CaseTitle] = 0x002161,[CaseUpper] = 0x002161,[CaseFold] = 0x002171}, NULL},
	{0x002162, {[CaseLower] = 0x002172,[CaseTitle] = 0x002162,[CaseUpper] = 0x002162,[CaseFold] = 0x002172}, NULL},
	{0x002163, {[CaseLower] = 0x002173,[CaseTitle] = 0x002163,[CaseUpper] = 0x002163,[CaseFold] = 0x002173}, NULL},
	{0x002164, {[CaseLower] = 0x002174,[CaseTitle] = 0x002164,[CaseUpper] = 0x002164,[CaseFold] = 0x002174}, NULL},
	{0x002165, {[CaseLower] = 0x002175,[CaseTitle] = 0x002165,[CaseUpper] = 0x002165,[CaseFold] = 0x002175}, NULL},
	{0x002166, {[CaseLower] = 0x002176,[CaseTitle] = 0x002166,[CaseUpper] = 0x002166,[CaseFold] = 0x002176}, NULL},
	{0x002167, {[CaseLower] = 0x002177,[CaseTitle] = 0x002167,[CaseUpper] = 0x002167,[CaseFold] = 0x002177}, NULL},
	{0x002168, {[CaseLower] = 0x002178,[CaseTitle] = 0x002168,[CaseUpper] = 0x002168,[CaseFold] = 0x002178}, NULL},
	{0x002169, {[CaseLower] = 0x002179,[CaseTitle] = 0x002169,[CaseUpper] = 0x002169,[CaseFold] = 0x002179}, NULL},
	{0x00216a, {[CaseLower] = 0x00217a,[CaseTitle] = 0x00216a,[CaseUpper] = 0x00216a,[CaseFold] = 0x00217a}, NULL},
	{0x00216b, {[CaseLower] = 0x00217b,[CaseTitle] = 0x00216b,[CaseUpper] = 0x00216b,[CaseFold] = 0x00217b}, NULL},
	{0x00216c, {[CaseLower] = 0x00217c,[CaseTitle] = 0x00216c,[CaseUpper] = 0x00216c,[CaseFold] = 0x00217c}, NULL},
	{0x00216d, {[CaseLower] = 0x00217d,[CaseTitle] = 0x00216d,[CaseUpper] = 0x00216d,[CaseFold] = 0x00217d}, NULL},
	{0x00216e, {[CaseLower] = 0x00217e,[CaseTitle] = 0x00216e,[CaseUpper] = 0x00216e,[CaseFold] = 0x00217e}, NULL},
	{0x00216f, {[CaseLower] = 0x00217f,[CaseTitle] = 0x00216f,[CaseUpper] = 0x00216f,[CaseFold] = 0x00217f}, NULL},
	{0x002170, {[CaseLower] = 0x002170,[CaseTitle] = 0x002160,[CaseUpper] = 0x002160,[CaseFold] = 0x002170}, NULL},
	{0x002171, {[CaseLower] = 0x002171,[CaseTitle] = 0x002161,[CaseUpper] = 0x002161,[CaseFold] = 0x002171}, NULL},
	{0x002172, {[CaseLower] = 0x002172,[CaseTitle] = 0x002162,[CaseUpper] = 0x002162,[CaseFold] = 0x002172}, NULL},
	{0x002173, {[CaseLower] = 0x002173,[CaseTitle] = 0x002163,[CaseUpper] = 0x002163,[CaseFold] = 0x002173}, NULL},
	{0x002174, {[CaseLower] = 0x002174,[CaseTitle] = 0x002164,[CaseUpper] = 0x002164,[CaseFold] = 0x002174}, NULL},
	{0x002175, {[CaseLower] = 0x002175,[CaseTitle] = 0x002165,[CaseUpper] = 0x002165,[CaseFold] = 0x002175}, NULL},
	{0x002176, {[CaseLower] = 0x002176,[CaseTitle] = 0x002166,[CaseUpper] = 0x002166,[CaseFold] = 0x002176}, NULL},
	{0x002177, {[CaseLower] = 0x002177,[CaseTitle] = 0x002167,[CaseUpper] = 0x002167,[CaseFold] = 0x002177}, NULL},
	{0x002178, {[CaseLower] = 0x002178,[CaseTitle] = 0x002168,[CaseUpper] = 0x002168,[CaseFold] = 0x002178}, NULL},
	{0x002179, {[CaseLower] = 0x002179,[CaseTitle] = 0x002169,[CaseUpper] = 0x002169,[CaseFold] = 0x002179}, NULL},
	{0x00217a, {[CaseLower] = 0x00217a,[CaseTitle] = 0x00216a,[CaseUpper] = 0x00216a,[CaseFold] = 0x00217a}, NULL},
	{0x00217b, {[CaseLower] = 0x00217b,[CaseTitle] = 0x00216b,[CaseUpper] = 0x00216b,[CaseFold] = 0x00217b}, NULL},
	{0x00217c, {[CaseLower] = 0x00217c,[CaseTitle] = 0x00216c,[CaseUpper] = 0x00216c,[CaseFold] = 0x00217c}, NULL},
	{0x00217d, {[CaseLower] = 0x00217d,[CaseTitle] = 0x00216d,[CaseUpper] = 0x00216d,[CaseFold] = 0x00217d}, NULL},
	{0x00217e, {[CaseLower] = 0x00217e,[CaseTitle] = 0x00216e,[CaseUpper] = 0x00216e,[CaseFold] = 0x00217e}, NULL},
	{0x00217f, {[CaseLower] = 0x00217f,[CaseTitle] = 0x00216f,[CaseUpper] = 0x00216f,[CaseFold] = 0x00217f}, NULL},
	{0x002183, {[CaseLower] = 0x002184,[CaseTitle] = 0x002183,[CaseUpper] = 0x002183,[CaseFold] = 0x002184}, NULL},
	{0x002184, {[CaseLower] = 0x002184,[CaseTitle] = 0x002183,[CaseUpper] = 0x002183,[CaseFold] = 0x002184}, NULL},
	{0x0024b6, {[CaseLower] = 0x0024d0,[CaseTitle] = 0x0024b6,[CaseUpper] = 0x0024b6,[CaseFold] = 0x0024d0}, NULL},
	{0x0024b7, {[CaseLower] = 0x0024d1,[CaseTitle] = 0x0024b7,[CaseUpper] = 0x0024b7,[CaseFold] = 0x0024d1}, NULL},
	{0x0024b8, {[CaseLower] = 0x0024d2,[CaseTitle] = 0x0024b8,[CaseUpper] = 0x0024b8,[CaseFold] = 0x0024d2}, NULL},
	{0x0024b9, {[CaseLower] = 0x0024d3,[CaseTitle] = 0x0024b9,[CaseUpper] = 0x0024b9,[CaseFold] = 0x0024d3}, NULL},
	{0x0024ba, {[CaseLower] = 0x0024d4,[CaseTitle] = 0x0024ba,[CaseUpper] = 0x0024ba,[CaseFold] = 0x0024d4}, NULL},
	{0x0024bb, {[CaseLower] = 0x0024d5,[CaseTitle] = 0x0024bb,[CaseUpper] = 0x0024bb,[CaseFold] = 0x0024d5}, NULL},
	{0x0024bc, {[CaseLower] = 0x0024d6,[CaseTitle] = 0x0024bc,[CaseUpper] = 0x0024bc,[CaseFold] = 0x0024d6}, NULL},
	{0x0024bd, {[CaseLower] = 0x0024d7,[CaseTitle] = 0x0024bd,[CaseUpper] = 0x0024bd,[CaseFold] = 0x0024d7}, NULL},
	{0x0024be, {[CaseLower] = 0x0024d8,[CaseTitle] = 0x0024be,[CaseUpper] = 0x0024be,[CaseFold] = 0x0024d8}, NULL},
	{0x0024bf, {[CaseLower] = 0x0024d9,[CaseTitle] = 0x0024bf,[CaseUpper] = 0x0024bf,[CaseFold] = 0x0024d9}, NULL},
	{0x0024c0, {[CaseLower] = 0x0024da,[CaseTitle] = 0x0024c0,[CaseUpper] = 0x0024c0,[CaseFold] = 0x0024da}, NULL},
	{0x0024c1, {[CaseLower] = 0x0024db,[CaseTitle] = 0x0024c1,[CaseUpper] = 0x0024c1,[CaseFold] = 0x0024db}, NULL},
	{0x0024c2, {[CaseLower] = 0x0024dc,[CaseTitle] = 0x0024c2,[CaseUpper] = 0x0024c2,[CaseFold] = 0x0024dc}, NULL},
	{0x0024c3, {[CaseLower] = 0x0024dd,[CaseTitle] = 0x0024c3,[CaseUpper] = 0x0024c3,[CaseFold] = 0x0024dd}, NULL},
	{0x0024c4, {[CaseLower] = 0x0024de,[CaseTitle] = 0x0024c4,[CaseUpper] = 0x0024c4,[CaseFold] = 0x0024de}, NULL},
	{0x0024c5, {[CaseLower] = 0x0024df,[CaseTitle] = 0x0024c5,[CaseUpper] = 0x0024c5,[CaseFold] = 0x0024df}, NULL},
	{0x0024c6, {[CaseLower] = 0x0024e0,[CaseTitle] = 0x0024c6,[CaseUpper] = 0x0024c6,[CaseFold] = 0x0024e0}, NULL},
	{0x0024c7, {[CaseLower] = 0x0024e1,[CaseTitle] = 0x0024c7,[CaseUpper] = 0x0024c7,[CaseFold] = 0x0024e1}, NULL},
	{0x0024c8, {[CaseLower] = 0x0024e2,[CaseTitle] = 0x0024c8,[CaseUpper] = 0x0024c8,[CaseFold] = 0x0024e2}, NULL},
	{0x0024c9, {[CaseLower] = 0x0024e3,[CaseTitle] = 0x0024c9,[CaseUpper] = 0x0024c9,[CaseFold] = 0x0024e3}, NULL},
	{0x0024ca, {[CaseLower] = 0x0024e4,[CaseTitle] = 0x0024ca,[CaseUpper] = 0x0024ca,[CaseFold] = 0x0024e4}, NULL},
	{0x0024cb, {[CaseLower] = 0x0024e5,[CaseTitle] = 0x0024cb,[CaseUpper] = 0x0024cb,[CaseFold] = 0x0024e5}, NULL},
	{0x0024cc, {[CaseLower] = 0x0024e6,[CaseTitle] = 0x0024cc,[CaseUpper] = 0x0024cc,[CaseFold] = 0x0024e6}, NULL},
	{0x0024cd, {[CaseLower] = 0x0024e7,[CaseTitle] = 0x0024cd,[CaseUpper] = 0x0024cd,[CaseFold] = 0x0024e7}, NULL},
	{0x0024ce, {[CaseLower] = 0x0024e8,[CaseTitle] = 0x0024ce,[CaseUpper] = 0x0024ce,[CaseFold] = 0x0024e8}, NULL},
	{0x0024cf, {[CaseLower] = 0x0024e9,[CaseTitle] = 0x0024cf,[CaseUpper] = 0x0024cf,[CaseFold] = 0x0024e9}, NULL},
	{0x0024d0, {[CaseLower] = 0x0024d0,[CaseTitle] = 0x0024b6,[CaseUpper] = 0x0024b6,[CaseFold] = 0x0024d0}, NULL},
	{0x0024d1, {[CaseLower] = 0x0024d1,[CaseTitle] = 0x0024b7,[CaseUpper] = 0x0024b7,[CaseFold] = 0x0024d1}, NULL},
	{0x0024d2, {[CaseLower] = 0x0024d2,[CaseTitle] = 0x0024b8,[CaseUpper] = 0x0024b8,[CaseFold] = 0x0024d2}, NULL},
	{0x0024d3, {[CaseLower] = 0x0024d3,[CaseTitle] = 0x0024b9,[CaseUpper] = 0x0024b9,[CaseFold] = 0x0024d3}, NULL},
	{0x0024d4, {[CaseLower] = 0x0024d4,[CaseTitle] = 0x0024ba,[CaseUpper] = 0x0024ba,[CaseFold] = 0x0024d4}, NULL},
	{0x0024d5, {[CaseLower] = 0x0024d5,[CaseTitle] = 0x0024bb,[CaseUpper] = 0x0024bb,[CaseFold] = 0x0024d5}, NULL},
	{0x0024d6, {[CaseLower] = 0x0024d6,[CaseTitle] = 0x0024bc,[CaseUpper] = 0x0024bc,[CaseFold] = 0x0024d6}, NULL},
	{0x0024d7, {[CaseLower] = 0x0024d7,[CaseTitle] = 0x0024bd,[CaseUpper] = 0x0024bd,[CaseFold] = 0x0024d7}, NULL},
	{0x0024d8, {[CaseLower] = 0x0024d8,[CaseTitle] = 0x0024be,[CaseUpper] = 0x0024be,[CaseFold] = 0x0024d8}, NULL},
	{0x0024d9, {[CaseLower] = 0x0024d9,[CaseTitle] = 0x0024bf,[CaseUpper] = 0x0024bf,[CaseFold] = 0x0024d9}, NULL},
	{0x0024da, {[CaseLower] = 0x0024da,[CaseTitle] = 0x0024c0,[CaseUpper] = 0x0024c0,[CaseFold] = 0x0024da}, NULL},
	{0x0024db, {[CaseLower] = 0x0024db,[CaseTitle] = 0x0024c1,[CaseUpper] = 0x0024c1,[CaseFold] = 0x0024db}, NULL},
	{0x0024dc, {[CaseLower] = 0x0024dc,[CaseTitle] = 0x0024c2,[CaseUpper] = 0x0024c2,[CaseFold] = 0x0024dc}, NULL},
	{0x0024dd, {[CaseLower] = 0x0024dd,[CaseTitle] = 0x0024c3,[CaseUpper] = 0x0024c3,[CaseFold] = 0x0024dd}, NULL},
	{0x0024de, {[CaseLower] = 0x0024de,[CaseTitle] = 0x0024c4,[CaseUpper] = 0x0024c4,[CaseFold] = 0x0024de}, NULL},
	{0x0024df, {[CaseLower] = 0x0024df,[CaseTitle] = 0x0024c5,[CaseUpper] = 0x0024c5,[CaseFold] = 0x0024df}, NULL},
	{0x0024e0, {[CaseLower] = 0x0024e0,[CaseTitle] = 0x0024c6,[CaseUpper] = 0x0024c6,[CaseFold] = 0x0024e0}, NULL},
	{0x0024e1, {[CaseLower] = 0x0024e1,[CaseTitle] = 0x0024c7,[CaseUpper] = 0x0024c7,[CaseFold] = 0x0024e1}, NULL},
	{0x0024e2, {[CaseLower] = 0x0024e2,[CaseTitle] = 0x0024c8,[CaseUpper] = 0x0024c8,[CaseFold] = 0x0024e2}, NULL},
	{0x0024e3, {[CaseLower] = 0x0024e3,[CaseTitle] = 0x0024c9,[CaseUpper] = 0x0024c9,[CaseFold] = 0x0024e3}, NULL},
	{0x0024e4, {[CaseLower] = 0x0024e4,[CaseTitle] = 0x0024ca,[CaseUpper] = 0x0024ca,[CaseFold] = 0x0024e4}, NULL},
	{0x0024e5, {[CaseLower] = 0x0024e5,[CaseTitle] = 0x0024cb,[CaseUpper] = 0x0024cb,[CaseFold] = 0x0024e5}, NULL},
	{0x0024e6, {[CaseLower] = 0x0024e6,[CaseTitle] = 0x0024cc,[CaseUpper] = 0x0024cc,[CaseFold] = 0x0024e6}, NULL},
	{0x0024e7, {[CaseLower] = 0x0024e7,[CaseTitle] = 0x0024cd,[CaseUpper] = 0x0024cd,[CaseFold] = 0x0024e7}, NULL},
	{0x0024e8, {[CaseLower] = 0x0024e8,[CaseTitle] = 0x0024ce,[CaseUpper] = 0x0024ce,[CaseFold] = 0x0024e8}, NULL},
	{0x0024e9, {[CaseLower] = 0x0024e9,[CaseTitle] = 0x0024cf,[CaseUpper] = 0x0024cf,[CaseFold] = 0x0024e9}, NULL},
	{0x002c00, {[CaseLower] = 0x002c30,[CaseTitle] = 0x002c00,[CaseUpper] = 0x002c00,[CaseFold] = 0x002c30}, NULL},
	{0x002c01, {[CaseLower] = 0x002c31,[CaseTitle] = 0x002c01,[CaseUpper] = 0x002c01,[CaseFold] = 0x002c31}, NULL},
	{0x002c02, {[CaseLower] = 0x002c32,[CaseTitle] = 0x002c02,[CaseUpper] = 0x002c02,[CaseFold] = 0x002c32}, NULL},
	{0x002c03, {[CaseLower] = 0x002c33,[CaseTitle] = 0x002c03,[CaseUpper] = 0x002c03,[CaseFold] = 0x002c33}, NULL},
	{0x002c04, {[CaseLower] = 0x002c34,[CaseTitle] = 0x002c04,[CaseUpper] = 0x002c04,[CaseFold] = 0x002c34}, NULL},
	{0x002c05, {[CaseLower] = 0x002c35,[CaseTitle] = 0x002c05,[CaseUpper] = 0x002c05,[CaseFold] = 0x002c35}, NULL},
	{0x002c06, {[CaseLower] = 0x002c36,[CaseTitle] = 0x002c06,[CaseUpper] = 0x002c06,[CaseFold] = 0x002c36}, NULL},
	{0x002c07, {[CaseLower] = 0x002c37,[CaseTitle] = 0x002c07,[CaseUpper] = 0x002c07,[CaseFold] = 0x002c37}, NULL},
	{0x002c08, {[CaseLower] = 0x002c38,[CaseTitle] = 0x002c08,[CaseUpper] = 0x002c08,[CaseFold] = 0x002c38}, NULL},
	{0x002c09, {[CaseLower] = 0x002c39,[CaseTitle] = 0x002c09,[CaseUpper] = 0x002c09,[CaseFold] = 0x002c39}, NULL},
	{0x002c0a, {[CaseLower] = 0x002c3a,[CaseTitle] = 0x002c0a,[CaseUpper] = 0x002c0a,[CaseFold] = 0x002c3a}, NULL},
	{0x002c0b, {[CaseLower] = 0x002c3b,[CaseTitle] = 0x002c0b,[CaseUpper] = 0x002c0b,[CaseFold] = 0x002c3b}, NULL},
	{0x002c0c, {[CaseLower] = 0x002c3c,[CaseTitle] = 0x002c0c,[CaseUpper] = 0x002c0c,[CaseFold] = 0x002c3c}, NULL},
	{0x002c0d, {[CaseLower] = 0x002c3d,[CaseTitle] = 0x002c0d,[CaseUpper] = 0x002c0d,[CaseFold] = 0x002c3d}, NULL},
	{0x002c0e, {[CaseLower] = 0x002c3e,[CaseTitle] = 0x002c0e,[CaseUpper] = 0x002c0e,[CaseFold] = 0x002c3e}, NULL},
	{0x002c0f, {[CaseLower] = 0x002c3f,[CaseTitle] = 0x002c0f,[CaseUpper] = 0x002c0f,[CaseFold] = 0x002c3f}, NULL},
	{0x002c10, {[CaseLower] = 0x002c40,[CaseTitle] = 0x002c10,[CaseUpper] = 0x002c10,[CaseFold] = 0x002c40}, NULL},
	{0x002c11, {[CaseLower] = 0x002c41,[CaseTitle] = 0x002c11,[CaseUpper] = 0x002c11,[CaseFold] = 0x002c41}, NULL},
	{0x002c12, {[CaseLower] = 0x002c42,[CaseTitle] = 0x002c12,[CaseUpper] = 0x002c12,[CaseFold] = 0x002c42}, NULL},
	{0x002c13, {[CaseLower] = 0x002c43,[CaseTitle] = 0x002c13,[CaseUpper] = 0x002c13,[CaseFold] = 0x002c43}, NULL},
	{0x002c14, {[CaseLower] = 0x002c44,[CaseTitle] = 0x002c14,[CaseUpper] = 0x002c14,[CaseFold] = 0x002c44}, NULL},
	{0x002c15, {[CaseLower] = 0x002c45,[CaseTitle] = 0x002c15,[CaseUpper] = 0x002c15,[CaseFold] = 0x002c45}, NULL},
	{0x002c16, {[CaseLower] = 0x002c46,[CaseTitle] = 0x002c16,[CaseUpper] = 0x002c16,[CaseFold] = 0x002c46}, NULL},
	{0x002c17, {[CaseLower] = 0x002c47,[CaseTitle] = 0x002c17,[CaseUpper] = 0x002c17,[CaseFold] = 0x002c47}, NULL},
	{0x002c18, {[CaseLower] = 0x002c48,[CaseTitle] = 0x002c18,[CaseUpper] = 0x002c18,[CaseFold] = 0x002c48}, NULL},
	{0x002c19, {[CaseLower] = 0x002c49,[CaseTitle] = 0x002c19,[CaseUpper] = 0x002c19,[CaseFold] = 0x002c49}, NULL},
	{0x002c1a, {[CaseLower] = 0x002c4a,[CaseTitle] = 0x002c1a,[CaseUpper] = 0x002c1a,[CaseFold] = 0x002c4a}, NULL},
	{0x002c1b, {[CaseLower] = 0x002c4b,[CaseTitle] = 0x002c1b,[CaseUpper] = 0x002c1b,[CaseFold] = 0x002c4b}, NULL},
	{0x002c1c, {[CaseLower] = 0x002c4c,[CaseTitle] = 0x002c1c,[CaseUpper] = 0x002c1c,[CaseFold] = 0x002c4c}, NULL},
	{0x002c1d, {[CaseLower] = 0x002c4d,[CaseTitle] = 0x002c1d,[CaseUpper] = 0x002c1d,[CaseFold] = 0x002c4d}, NULL},
	{0x002c1e, {[CaseLower] = 0x002c4e,[CaseTitle] = 0x002c1e,[CaseUpper] = 0x002c1e,[CaseFold] = 0x002c4e}, NULL},
	{0x002c1f, {[CaseLower] = 0x002c4f,[CaseTitle] = 0x002c1f,[CaseUpper] = 0x002c1f,[CaseFold] = 0x002c4f}, NULL},
	{0x002c20, {[CaseLower] = 0x002c50,[CaseTitle] = 0x002c20,[CaseUpper] = 0x002c20,[CaseFold] = 0x002c50}, NULL},
	{0x002c21, {[CaseLower] = 0x002c51,[CaseTitle] = 0x002c21,[CaseUpper] = 0x002c21,[CaseFold] = 0x002c51}, NULL},
	{0x002c22, {[CaseLower] = 0x002c52,[CaseTitle] = 0x002c22,[CaseUpper] = 0x002c22,[CaseFold] = 0x002c52}, NULL},
	{0x002c23, {[CaseLower] = 0x002c53,[CaseTitle] = 0x002c23,[CaseUpper] = 0x002c23,[CaseFold] = 0x002c53}, NULL},
	{0x002c24, {[CaseLower] = 0x002c54,[CaseTitle] = 0x002c24,[CaseUpper] = 0x002c24,[CaseFold] = 0x002c54}, NULL},
	{0x002c25, {[CaseLower] = 0x002c55,[CaseTitle] = 0x002c25,[CaseUpper] = 0x002c25,[CaseFold] = 0x002c55}, NULL},
	{0x002c26, {[CaseLower] = 0x002c56,[CaseTitle] = 0x002c26,[CaseUpper] = 0x002c26,[CaseFold] = 0x002c56}, NULL},
	{0x002c27, {[CaseLower] = 0x002c57,[CaseTitle] = 0x002c27,[CaseUpper] = 0x002c27,[CaseFold] = 0x002c57}, NULL},
	{0x002c28, {[CaseLower] = 0x002c58,[CaseTitle] = 0x002c28,[CaseUpper] = 0x002c28,[CaseFold] = 0x002c58}, NULL},
	{0x002c29, {[CaseLower] = 0x002c59,[CaseTitle] = 0x002c29,[CaseUpper] = 0x002c29,[CaseFold] = 0x002c59}, NULL},
	{0x002c2a, {[CaseLower] = 0x002c5a,[CaseTitle] = 0x002c2a,[CaseUpper] = 0x002c2a,[CaseFold] = 0x002c5a}, NULL},
	{0x002c2b, {[CaseLower] = 0x002c5b,[CaseTitle] = 0x002c2b,[CaseUpper] = 0x002c2b,[CaseFold] = 0x002c5b}, NULL},
	{0x002c2c, {[CaseLower] = 0x002c5c,[CaseTitle] = 0x002c2c,[CaseUpper] = 0x002c2c,[CaseFold] = 0x002c5c}, NULL},
	{0x002c2d, {[CaseLower] = 0x002c5d,[CaseTitle] = 0x002c2d,[CaseUpper] = 0x002c2d,[CaseFold] = 0x002c5d}, NULL},
	{0x002c2e, {[CaseLower] = 0x002c5e,[CaseTitle] = 0x002c2e,[CaseUpper] = 0x002c2e,[CaseFold] = 0x002c5e}, NULL},
	{0x002c2f, {[CaseLower] = 0x002c5f,[CaseTitle] = 0x002c2f,[CaseUpper] = 0x002c2f,[CaseFold] = 0x002c5f}, NULL},
	{0x002c30, {[CaseLower] = 0x002c30,[CaseTitle] = 0x002c00,[CaseUpper] = 0x002c00,[CaseFold] = 0x002c30}, NULL},
	{0x002c31, {[CaseLower] = 0x002c31,[CaseTitle] = 0x002c01,[CaseUpper] = 0x002c01,[CaseFold] = 0x002c31}, NULL},
	{0x002c32, {[CaseLower] = 0x002c32,[CaseTitle] = 0x002c02,[CaseUpper] = 0x002c02,[CaseFold] = 0x002c32}, NULL},
	{0x002c33, {[CaseLower] = 0x002c33,[CaseTitle] = 0x002c03,[CaseUpper] = 0x002c03,[CaseFold] = 0x002c33}, NULL},
	{0x002c34, {[CaseLower] = 0x002c34,[CaseTitle] = 0x002c04,[CaseUpper] = 0x002c04,[CaseFold] = 0x002c34}, NULL},
	{0x002c35, {[CaseLower] = 0x002c35,[CaseTitle] = 0x002c05,[CaseUpper] = 0x002c05,[CaseFold] = 0x002c35}, NULL},
	{0x002c36, {[CaseLower] = 0x002c36,[CaseTitle] = 0x002c06,[CaseUpper] = 0x002c06,[CaseFold] = 0x002c36}, NULL},
	{0x002c37, {[CaseLower] = 0x002c37,[CaseTitle] = 0x002c07,[CaseUpper] = 0x002c07,[CaseFold] = 0x002c37}, NULL},
	{0x002c38, {[CaseLower] = 0x002c38,[CaseTitle] = 0x002c08,[CaseUpper] = 0x002c08,[CaseFold] = 0x002c38}, NULL},
	{0x002c39, {[CaseLower] = 0x002c39,[CaseTitle] = 0x002c09,[CaseUpper] = 0x002c09,[CaseFold] = 0x002c39}, NULL},
	{0x002c3a, {[CaseLower] = 0x002c3a,[CaseTitle] = 0x002c0a,[CaseUpper] = 0x002c0a,[CaseFold] = 0x002c3a}, NULL},
	{0x002c3b, {[CaseLower] = 0x002c3b,[CaseTitle] = 0x002c0b,[CaseUpper] = 0x002c0b,[CaseFold] = 0x002c3b}, NULL},
	{0x002c3c, {[CaseLower] = 0x002c3c,[CaseTitle] = 0x002c0c,[CaseUpper] = 0x002c0c,[CaseFold] = 0x002c3c}, NULL},
	{0x002c3d, {[CaseLower] = 0x002c3d,[CaseTitle] = 0x002c0d,[CaseUpper] = 0x002c0d,[CaseFold] = 0x002c3d}, NULL},
	{0x002c3e, {[CaseLower] = 0x002c3e,[CaseTitle] = 0x002c0e,[CaseUpper] = 0x002c0e,[CaseFold] = 0x002c3e}, NULL},
	{0x002c3f, {[CaseLower] = 0x002c3f,[CaseTitle] = 0x002c0f,[CaseUpper] = 0x002c0f,[CaseFold] = 0x002c3f}, NULL},
	{0x002c40, {[CaseLower] = 0x002c40,[CaseTitle] = 0x002c10,[CaseUpper] = 0x002c10,[CaseFold] = 0x002c40}, NULL},
	{0x002c41, {[CaseLower] = 0x002c41,[CaseTitle] = 0x002c11,[CaseUpper] = 0x002c11,[CaseFold] = 0x002c41}, NULL},
	{0x002c42, {[CaseLower] = 0x002c42,[CaseTitle] = 0x002c12,[CaseUpper] = 0x002c12,[CaseFold] = 0x002c42}, NULL},
	{0x002c43, {[CaseLower] = 0x002c43,[CaseTitle] = 0x002c13,[CaseUpper] = 0x002c13,[CaseFold] = 0x002c43}, NULL},
	{0x002c44, {[CaseLower] = 0x002c44,[CaseTitle] = 0x002c14,[CaseUpper] = 0x002c14,[CaseFold] = 0x002c44}, NULL},
	{0x002c45, {[CaseLower] = 0x002c45,[CaseTitle] = 0x002c15,[CaseUpper] = 0x002c15,[CaseFold] = 0x002c45}, NULL},
	{0x002c46, {[CaseLower] = 0x002c46,[CaseTitle] = 0x002c16,[CaseUpper] = 0x002c16,[CaseFold] = 0x002c46}, NULL},
	{0x002c47, {[CaseLower] = 0x002c47,[CaseTitle] = 0x002c17,[CaseUpper] = 0x002c17,[CaseFold] = 0x002c47}, NULL},
	{0x002c48, {[CaseLower] = 0x002c48,[CaseTitle] = 0x002c18,[CaseUpper] = 0x002c18,[CaseFold] = 0x002c48}, NULL},
	{0x002c49, {[CaseLower] = 0x002c49,[CaseTitle] = 0x002c19,[CaseUpper] = 0x002c19,[CaseFold] = 0x002c49}, NULL},
	{0x002c4a, {[CaseLower] = 0x002c4a,[CaseTitle] = 0x002c1a,[CaseUpper] = 0x002c1a,[CaseFold] = 0x002c4a}, NULL},
	{0x002c4b, {[CaseLower] = 0x002c4b,[CaseTitle] = 0x002c1b,[CaseUpper] = 0x002c1b,[CaseFold] = 0x002c4b}, NULL},
	{0x002c4c, {[CaseLower] = 0x002c4c,[CaseTitle] = 0x002c1c,[CaseUpper] = 0x002c1c,[CaseFold] = 0x002c4c}, NULL},
	{0x002c4d, {[CaseLower] = 0x002c4d,[CaseTitle] = 0x002c1d,[CaseUpper] = 0x002c1d,[CaseFold] = 0x002c4d}, NULL},
	{0x002c4e, {[CaseLower] = 0x002c4e,[CaseTitle] = 0x002c1e,[CaseUpper] = 0x002c1e,[CaseFold] = 0x002c4e}, NULL},
	{0x002c4f, {[CaseLower] = 0x002c4f,[CaseTitle] = 0x002c1f,[CaseUpper] = 0x002c1f,[CaseFold] = 0x002c4f}, NULL},
	{0x002c50, {[CaseLower] = 0x002c50,[CaseTitle] = 0x002c20,[CaseUpper] = 0x002c20,[CaseFold] = 0x002c50}, NULL},
	{0x002c51, {[CaseLower] = 0x002c51,[CaseTitle] = 0x002c21,[CaseUpper] = 0x002c21,[CaseFold] = 0x002c51}, NULL},
	{0x002c52, {[CaseLower] = 0x002c52,[CaseTitle] = 0x002c22,[CaseUpper] = 0x002c22,[CaseFold] = 0x002c52}, NULL},
	{0x002c53, {[CaseLower] = 0x002c53,[CaseTitle] = 0x002c23,[CaseUpper] = 0x002c23,[CaseFold] = 0x002c53}, NULL},
	{0x002c54, {[CaseLower] = 0x002c54,[CaseTitle] = 0x002c24,[CaseUpper] = 0x002c24,[CaseFold] = 0x002c54}, NULL},
	{0x002c55, {[CaseLower] = 0x002c55,[CaseTitle] = 0x002c25,[CaseUpper] = 0x002c25,[CaseFold] = 0x002c55}, NULL},
	{0x002c56, {[CaseLower] = 0x002c56,[CaseTitle] = 0x002c26,[CaseUpper] = 0x002c26,[CaseFold] = 0x002c56}, NULL},
	{0x002c57, {[CaseLower] = 0x002c57,[CaseTitle] = 0x002c27,[CaseUpper] = 0x002c27,[CaseFold] = 0x002c57}, NULL},
	{0x002c58, {[CaseLower] = 0x002c58,[CaseTitle] = 0x002c28,[CaseUpper] = 0x002c28,[CaseFold] = 0x002c58}, NULL},
	{0x002c59, {[CaseLower] = 0x002c59,[CaseTitle] = 0x002c29,[CaseUpper] = 0x002c29,[CaseFold] = 0x002c59}, NULL},
	{0x002c5a, {[CaseLower] = 0x002c5a,[CaseTitle] = 0x002c2a,[CaseUpper] = 0x002c2a,[CaseFold] = 0x002c5a}, NULL},
	{0x002c5b, {[CaseLower] = 0x002c5b,[CaseTitle] = 0x002c2b,[CaseUpper] = 0x002c2b,[CaseFold] = 0x002c5b}, NULL},
	{0x002c5c, {[CaseLower] = 0x002c5c,[CaseTitle] = 0x002c2c,[CaseUpper] = 0x002c2c,[CaseFold] = 0x002c5c}, NULL},
	{0x002c5d, {[CaseLower] = 0x002c5d,[CaseTitle] = 0x002c2d,[CaseUpper] = 0x002c2d,[CaseFold] = 0x002c5d}, NULL},
	{0x002c5e, {[CaseLower] = 0x002c5e,[CaseTitle] = 0x002c2e,[CaseUpper] = 0x002c2e,[CaseFold] = 0x002c5e}, NULL},
	{0x002c5f, {[CaseLower] = 0x002c5f,[CaseTitle] = 0x002c2f,[CaseUpper] = 0x002c2f,[CaseFold] = 0x002c5f}, NULL},
	{0x002c60, {[CaseLower] = 0x002c61,[CaseTitle] = 0x002c60,[CaseUpper] = 0x002c60,[CaseFold] = 0x002c61}, NULL},
	{0x002c61, {[CaseLower] = 0x002c61,[CaseTitle] = 0x002c60,[CaseUpper] = 0x002c60,[CaseFold] = 0x002c61}, NULL},
	{0x002c62, {[CaseLower] = 0x00026b,[CaseTitle] = 0x002c62,[CaseUpper] = 0x002c62,[CaseFold] = 0x00026b}, NULL},
	{0x002c63, {[CaseLower] = 0x001d7d,[CaseTitle] = 0x002c63,[CaseUpper] = 0x002c63,[CaseFold] = 0x001d7d}, NULL},
	{0x002c64, {[CaseLower] = 0x00027d,[CaseTitle] = 0x002c64,[CaseUpper] = 0x002c64,[CaseFold] = 0x00027d}, NULL},
	{0x002c65, {[CaseLower] = 0x002c65,[CaseTitle] = 0x00023a,[CaseUpper] = 0x00023a,[CaseFold] = 0x002c65}, NULL},
	{0x002c66, {[CaseLower] = 0x002c66,[CaseTitle] = 0x00023e,[CaseUpper] = 0x00023e,[CaseFold] = 0x002c66}, NULL},
	{0x002c67, {[CaseLower] = 0x002c68,[CaseTitle] = 0x002c67,[CaseUpper] = 0x002c67,[CaseFold] = 0x002c68}, NULL},
	{0x002c68, {[CaseLower] = 0x002c68,[CaseTitle] = 0x002c67,[CaseUpper] = 0x002c67,[CaseFold] = 0x002c68}, NULL},
	{0x002c69, {[CaseLower] = 0x002c6a,[CaseTitle] = 0x002c69,[CaseUpper] = 0x002c69,[CaseFold] = 0x002c6a}, NULL},
	{0x002c6a, {[CaseLower] = 0x002c6a,[CaseTitle] = 0x002c69,[CaseUpper] = 0x002c69,[CaseFold] = 0x002c6a}, NULL},
	{0x002c6b, {[CaseLower] = 0x002c6c,[CaseTitle] = 0x002c6b,[CaseUpper] = 0x002c6b,[CaseFold] = 0x002c6c}, NULL},
	{0x002c6c, {[CaseLower] = 0x002c6c,[CaseTitle] = 0x002c6b,[CaseUpper] = 0x002c6b,[CaseFold] = 0x002c6c}, NULL},
	{0x002c6d, {[CaseLower] = 0x000251,[CaseTitle] = 0x002c6d,[CaseUpper] = 0x002c6d,[CaseFold] = 0x000251}, NULL},
	{0x002c6e, {[CaseLower] = 0x000271,[CaseTitle] = 0x002c6e,[CaseUpper] = 0x002c6e,[CaseFold] = 0x000271}, NULL},
	{0x002c6f, {[CaseLower] = 0x000250,[CaseTitle] = 0x002c6f,[CaseUpper] = 0x002c6f,[CaseFold] = 0x000250}, NULL},
	{0x002c70, {[CaseLower] = 0x000252,[CaseTitle] = 0x002c70,[CaseUpper] = 0x002c70,[CaseFold] = 0x000252}, NULL},
	{0x002c72, {[CaseLower] = 0x002c73,[CaseTitle] = 0x002c72,[CaseUpper] = 0x002c72,[CaseFold] = 0x002c73}, NULL},
	{0x002c73, {[CaseLower] = 0x002c73,[CaseTitle] = 0x002c72,[CaseUpper] = 0x002c72,[CaseFold] = 0x002c73}, NULL},
	{0x002c75, {[CaseLower] = 0x002c76,[CaseTitle] = 0x002c75,[CaseUpper] = 0x002c75,[CaseFold] = 0x002c76}, NULL},
	{0x002c76, {[CaseLower] = 0x002c76,[CaseTitle] = 0x002c75,[CaseUpper] = 0x002c75,[CaseFold] = 0x002c76}, NULL},
	{0x002c7e, {[CaseLower] = 0x00023f,[CaseTitle] = 0x002c7e,[CaseUpper] = 0x002c7e,[CaseFold] = 0x00023f}, NULL},
	{0x002c7f, {[CaseLower] = 0x000240,[CaseTitle] = 0x002c7f,[CaseUpper] = 0x002c7f,[CaseFold] = 0x000240}, NULL},
	{0x002c80, {[CaseLower] = 0x002c81,[CaseTitle] = 0x002c80,[CaseUpper] = 0x002c80,[CaseFold] = 0x002c81}, NULL},
	{0x002c81, {[CaseLower] = 0x002c81,[CaseTitle] = 0x002c80,[CaseUpper] = 0x002c80,[CaseFold] = 0x002c81}, NULL},
	{0x002c82, {[CaseLower] = 0x002c83,[CaseTitle] = 0x002c82,[CaseUpper] = 0x002c82,[CaseFold] = 0x002c83}, NULL},
	{0x002c83, {[CaseLower] = 0x002c83,[CaseTitle] = 0x002c82,[CaseUpper] = 0x002c82,[CaseFold] = 0x002c83}, NULL},
	{0x002c84, {[CaseLower] = 0x002c85,[CaseTitle] = 0x002c84,[CaseUpper] = 0x002c84,[CaseFold] = 0x002c85}, NULL},
	{0x002c85, {[CaseLower] = 0x002c85,[CaseTitle] = 0x002c84,[CaseUpper] = 0x002c84,[CaseFold] = 0x002c85}, NULL},
	{0x002c86, {[CaseLower] = 0x002c87,[CaseTitle] = 0x002c86,[CaseUpper] = 0x002c86,[CaseFold] = 0x002c87}, NULL},
	{0x002c87, {[CaseLower] = 0x002c87,[CaseTitle] = 0x002c86,[CaseUpper] = 0x002c86,[CaseFold] = 0x002c87}, NULL},
	{0x002c88, {[CaseLower] = 0x002c89,[CaseTitle] = 0x002c88,[CaseUpper] = 0x002c88,[CaseFold] = 0x002c89}, NULL},
	{0x002c89, {[CaseLower] = 0x002c89,[CaseTitle] = 0x002c88,[CaseUpper] = 0x002c88,[CaseFold] = 0x002c89}, NULL},
	{0x002c8a, {[CaseLower] = 0x002c8b,[CaseTitle] = 0x002c8a,[CaseUpper] = 0x002c8a,[CaseFold] = 0x002c8b}, NULL},
	{0x002c8b, {[CaseLower] = 0x002c8b,[CaseTitle] = 0x002c8a,[CaseUpper] = 0x002c8a,[CaseFold] = 0x002c8b}, NULL},
	{0x002c8c, {[CaseLower] = 0x002c8d,[CaseTitle] = 0x002c8c,[CaseUpper] = 0x002c8c,[CaseFold] = 0x002c8d}, NULL},
	{0x002c8d, {[CaseLower] = 0x002c8d,[CaseTitle] = 0x002c8c,[CaseUpper] = 0x002c8c,[CaseFold] = 0x002c8d}, NULL},
	{0x002c8e, {[CaseLower] = 0x002c8f,[CaseTitle] = 0x002c8e,[CaseUpper] = 0x002c8e,[CaseFold] = 0x002c8f}, NULL},
	{0x002c8f, {[CaseLower] = 0x002c8f,[CaseTitle] = 0x002c8e,[CaseUpper] = 0x002c8e,[CaseFold] = 0x002c8f}, NULL},
	{0x002c90, {[CaseLower] = 0x002c91,[CaseTitle] = 0x002c90,[CaseUpper] = 0x002c90,[CaseFold] = 0x002c91}, NULL},
	{0x002c91, {[CaseLower] = 0x002c91,[CaseTitle] = 0x002c90,[CaseUpper] = 0x002c90,[CaseFold] = 0x002c91}, NULL},
	{0x002c92, {[CaseLower] = 0x002c93,[CaseTitle] = 0x002c92,[CaseUpper] = 0x002c92,[CaseFold] = 0x002c93}, NULL},
	{0x002c93, {[CaseLower] = 0x002c93,[CaseTitle] = 0x002c92,[CaseUpper] = 0x002c92,[CaseFold] = 0x002c93}, NULL},
	{0x002c94, {[CaseLower] = 0x002c95,[CaseTitle] = 0x002c94,[CaseUpper] = 0x002c94,[CaseFold] = 0x002c95}, NULL},
	{0x002c95, {[CaseLower] = 0x002c95,[CaseTitle] = 0x002c94,[CaseUpper] = 0x002c94,[CaseFold] = 0x002c95}, NULL},
	{0x002c96, {[CaseLower] = 0x002c97,[CaseTitle] = 0x002c96,[CaseUpper] = 0x002c96,[CaseFold] = 0x002c97}, NULL},
	{0x002c97, {[CaseLower] = 0x002c97,[CaseTitle] = 0x002c96,[CaseUpper] = 0x002c96,[CaseFold] = 0x002c97}, NULL},
	{0x002c98, {[CaseLower] = 0x002c99,[CaseTitle] = 0x002c98,[CaseUpper] = 0x002c98,[CaseFold] = 0x002c99}, NULL},
	{0x002c99, {[CaseLower] = 0x002c99,[CaseTitle] = 0x002c98,[CaseUpper] = 0x002c98,[CaseFold] = 0x002c99}, NULL},
	{0x002c9a, {[CaseLower] = 0x002c9b,[CaseTitle] = 0x002c9a,[CaseUpper] = 0x002c9a,[CaseFold] = 0x002c9b}, NULL},
	{0x002c9b, {[CaseLower] = 0x002c9b,[CaseTitle] = 0x002c9a,[CaseUpper] = 0x002c9a,[CaseFold] = 0x002c9b}, NULL},
	{0x002c9c, {[CaseLower] = 0x002c9d,[CaseTitle] = 0x002c9c,[CaseUpper] = 0x002c9c,[CaseFold] = 0x002c9d}, NULL},
	{0x002c9d, {[CaseLower] = 0x002c9d,[CaseTitle] = 0x002c9c,[CaseUpper] = 0x002c9c,[CaseFold] = 0x002c9d}, NULL},
	{0x002c9e, {[CaseLower] = 0x002c9f,[CaseTitle] = 0x002c9e,[CaseUpper] = 0x002c9e,[CaseFold] = 0x002c9f}, NULL},
	{0x002c9f, {[CaseLower] = 0x002c9f,[CaseTitle] = 0x002c9e,[CaseUpper] = 0x002c9e,[CaseFold] = 0x002c9f}, NULL},
	{0x002ca0, {[CaseLower] = 0x002ca1,[CaseTitle] = 0x002ca0,[CaseUpper] = 0x002ca0,[CaseFold] = 0x002ca1}, NULL},
	{0x002ca1, {[CaseLower] = 0x002ca1,[CaseTitle] = 0x002ca0,[CaseUpper] = 0x002ca0,[CaseFold] = 0x002ca1}, NULL},
	{0x002ca2, {[CaseLower] = 0x002ca3,[CaseTitle] = 0x002ca2,[CaseUpper] = 0x002ca2,[CaseFold] = 0x002ca3}, NULL},
	{0x002ca3, {[CaseLower] = 0x002ca3,[CaseTitle] = 0x002ca2,[CaseUpper] = 0x002ca2,[CaseFold] = 0x002ca3}, NULL},
	{0x002ca4, {[CaseLower] = 0x002ca5,[CaseTitle] = 0x002ca4,[CaseUpper] = 0x002ca4,[CaseFold] = 0x002ca5}, NULL},
	{0x002ca5, {[CaseLower] = 0x002ca5,[CaseTitle] = 0x002ca4,[CaseUpper] = 0x002ca4,[CaseFold] = 0x002ca5}, NULL},
	{0x002ca6, {[CaseLower] = 0x002ca7,[CaseTitle] = 0x002ca6,[CaseUpper] = 0x002ca6,[CaseFold] = 0x002ca7}, NULL},
	{0x002ca7, {[CaseLower] = 0x002ca7,[CaseTitle] = 0x002ca6,[CaseUpper] = 0x002ca6,[CaseFold] = 0x002ca7}, NULL},
	{0x002ca8, {[CaseLower] = 0x002ca9,[CaseTitle] = 0x002ca8,[CaseUpper] = 0x002ca8,[CaseFold] = 0x002ca9}, NULL},
	{0x002ca9, {[CaseLower] = 0x002ca9,[CaseTitle] = 0x002ca8,[CaseUpper] = 0x002ca8,[CaseFold] = 0x002ca9}, NULL},
	{0x002caa, {[CaseLower] = 0x002cab,[CaseTitle] = 0x002caa,[CaseUpper] = 0x002caa,[CaseFold] = 0x002cab}, NULL},
	{0x002cab, {[CaseLower] = 0x002cab,[CaseTitle] = 0x002caa,[CaseUpper] = 0x002caa,[CaseFold] = 0x002cab}, NULL},
	{0x002cac, {[CaseLower] = 0x002cad,[CaseTitle] = 0x002cac,[CaseUpper] = 0x002cac,[CaseFold] = 0x002cad}, NULL},
	{0x002cad, {[CaseLower] = 0x002cad,[CaseTitle] = 0x002cac,[CaseUpper] = 0x002cac,[CaseFold] = 0x002cad}, NULL},
	{0x002cae, {[CaseLower] = 0x002caf,[CaseTitle] = 0x002cae,[CaseUpper] = 0x002cae,[CaseFold] = 0x002caf}, NULL},
	{0x002caf, {[CaseLower] = 0x002caf,[CaseTitle] = 0x002cae,[CaseUpper] = 0x002cae,[CaseFold] = 0x002caf}, NULL},
	{0x002cb0, {[CaseLower] = 0x002cb1,[CaseTitle] = 0x002cb0,[CaseUpper] = 0x002cb0,[CaseFold] = 0x002cb1}, NULL},
	{0x002cb1, {[CaseLower] = 0x002cb1,[CaseTitle] = 0x002cb0,[CaseUpper] = 0x002cb0,[CaseFold] = 0x002cb1}, NULL},
	{0x002cb2, {[CaseLower] = 0x002cb3,[CaseTitle] = 0x002cb2,[CaseUpper] = 0x002cb2,[CaseFold] = 0x002cb3}, NULL},
	{0x002cb3, {[CaseLower] = 0x002cb3,[CaseTitle] = 0x002cb2,[CaseUpper] = 0x002cb2,[CaseFold] = 0x002cb3}, NULL},
	{0x002cb4, {[CaseLower] = 0x002cb5,[CaseTitle] = 0x002cb4,[CaseUpper] = 0x002cb4,[CaseFold] = 0x002cb5}, NULL},
	{0x002cb5, {[CaseLower] = 0x002cb5,[CaseTitle] = 0x002cb4,[CaseUpper] = 0x002cb4,[CaseFold] = 0x002cb5}, NULL},
	{0x002cb6, {[CaseLower] = 0x002cb7,[CaseTitle] = 0x002cb6,[CaseUpper] = 0x002cb6,[CaseFold] = 0x002cb7}, NULL},
	{0x002cb7, {[CaseLower] = 0x002cb7,[CaseTitle] = 0x002cb6,[CaseUpper] = 0x002cb6,[CaseFold] = 0x002cb7}, NULL},
	{0x002cb8, {[CaseLower] = 0x002cb9,[CaseTitle] = 0x002cb8,[CaseUpper] = 0x002cb8,[CaseFold] = 0x002cb9}, NULL},
	{0x002cb9, {[CaseLower] = 0x002cb9,[CaseTitle] = 0x002cb8,[CaseUpper] = 0x002cb8,[CaseFold] = 0x002cb9}, NULL},
	{0x002cba, {[CaseLower] = 0x002cbb,[CaseTitle] = 0x002cba,[CaseUpper] = 0x002cba,[CaseFold] = 0x002cbb}, NULL},
	{0x002cbb, {[CaseLower] = 0x002cbb,[CaseTitle] = 0x002cba,[CaseUpper] = 0x002cba,[CaseFold] = 0x002cbb}, NULL},
	{0x002cbc, {[CaseLower] = 0x002cbd,[CaseTitle] = 0x002cbc,[CaseUpper] = 0x002cbc,[CaseFold] = 0x002cbd}, NULL},
	{0x002cbd, {[CaseLower] = 0x002cbd,[CaseTitle] = 0x002cbc,[CaseUpper] = 0x002cbc,[CaseFold] = 0x002cbd}, NULL},
	{0x002cbe, {[CaseLower] = 0x002cbf,[CaseTitle] = 0x002cbe,[CaseUpper] = 0x002cbe,[CaseFold] = 0x002cbf}, NULL},
	{0x002cbf, {[CaseLower] = 0x002cbf,[CaseTitle] = 0x002cbe,[CaseUpper] = 0x002cbe,[CaseFold] = 0x002cbf}, NULL},
	{0x002cc0, {[CaseLower] = 0x002cc1,[CaseTitle] = 0x002cc0,[CaseUpper] = 0x002cc0,[CaseFold] = 0x002cc1}, NULL},
	{0x002cc1, {[CaseLower] = 0x002cc1,[CaseTitle] = 0x002cc0,[CaseUpper] = 0x002cc0,[CaseFold] = 0x002cc1}, NULL},
	{0x002cc2, {[CaseLower] = 0x002cc3,[CaseTitle] = 0x002cc2,[CaseUpper] = 0x002cc2,[CaseFold] = 0x002cc3}, NULL},
	{0x002cc3, {[CaseLower] = 0x002cc3,[CaseTitle] = 0x002cc2,[CaseUpper] = 0x002cc2,[CaseFold] = 0x002cc3}, NULL},
	{0x002cc4, {[CaseLower] = 0x002cc5,[CaseTitle] = 0x002cc4,[CaseUpper] = 0x002cc4,[CaseFold] = 0x002cc5}, NULL},
	{0x002cc5, {[CaseLower] = 0x002cc5,[CaseTitle] = 0x002cc4,[CaseUpper] = 0x002cc4,[CaseFold] = 0x002cc5}, NULL},
	{0x002cc6, {[CaseLower] = 0x002cc7,[CaseTitle] = 0x002cc6,[CaseUpper] = 0x002cc6,[CaseFold] = 0x002cc7}, NULL},
	{0x002cc7, {[CaseLower] = 0x002cc7,[CaseTitle] = 0x002cc6,[CaseUpper] = 0x002cc6,[CaseFold] = 0x002cc7}, NULL},
	{0x002cc8, {[CaseLower] = 0x002cc9,[CaseTitle] = 0x002cc8,[CaseUpper] = 0x002cc8,[CaseFold] = 0x002cc9}, NULL},
	{0x002cc9, {[CaseLower] = 0x002cc9,[CaseTitle] = 0x002cc8,[CaseUpper] = 0x002cc8,[CaseFold] = 0x002cc9}, NULL},
	{0x002cca, {[CaseLower] = 0x002ccb,[CaseTitle] = 0x002cca,[CaseUpper] = 0x002cca,[CaseFold] = 0x002ccb}, NULL},
	{0x002ccb, {[CaseLower] = 0x002ccb,[CaseTitle] = 0x002cca,[CaseUpper] = 0x002cca,[CaseFold] = 0x002ccb}, NULL},
	{0x002ccc, {[CaseLower] = 0x002ccd,[CaseTitle] = 0x002ccc,[CaseUpper] = 0x002ccc,[CaseFold] = 0x002ccd}, NULL},
	{0x002ccd, {[CaseLower] = 0x002ccd,[CaseTitle] = 0x002ccc,[CaseUpper] = 0x002ccc,[CaseFold] = 0x002ccd}, NULL},
	{0x002cce, {[CaseLower] = 0x002ccf,[CaseTitle] = 0x002cce,[CaseUpper] = 0x002cce,[CaseFold] = 0x002ccf}, NULL},
	{0x002ccf, {[CaseLower] = 0x002ccf,[CaseTitle] = 0x002cce,[CaseUpper] = 0x002cce,[CaseFold] = 0x002ccf}, NULL},
	{0x002cd0, {[CaseLower] = 0x002cd1,[CaseTitle] = 0x002cd0,[CaseUpper] = 0x002cd0,[CaseFold] = 0x002cd1}, NULL},
	{0x002cd1, {[CaseLower] = 0x002cd1,[CaseTitle] = 0x002cd0,[CaseUpper] = 0x002cd0,[CaseFold] = 0x002cd1}, NULL},
	{0x002cd2, {[CaseLower] = 0x002cd3,[CaseTitle] = 0x002cd2,[CaseUpper] = 0x002cd2,[CaseFold] = 0x002cd3}, NULL},
	{0x002cd3, {[CaseLower] = 0x002cd3,[CaseTitle] = 0x002cd2,[CaseUpper] = 0x002cd2,[CaseFold] = 0x002cd3}, NULL},
	{0x002cd4, {[CaseLower] = 0x002cd5,[CaseTitle] = 0x002cd4,[CaseUpper] = 0x002cd4,[CaseFold] = 0x002cd5}, NULL},
	{0x002cd5, {[CaseLower] = 0x002cd5,[CaseTitle] = 0x002cd4,[CaseUpper] = 0x002cd4,[CaseFold] = 0x002cd5}, NULL},
	{0x002cd6, {[CaseLower] = 0x002cd7,[CaseTitle] = 0x002cd6,[CaseUpper] = 0x002cd6,[CaseFold] = 0x002cd7}, NULL},
	{0x002cd7, {[CaseLower] = 0x002cd7,[CaseTitle] = 0x002cd6,[CaseUpper] = 0x002cd6,[CaseFold] = 0x002cd7}, NULL},
	{0x002cd8, {[CaseLower] = 0x002cd9,[CaseTitle] = 0x002cd8,[CaseUpper] = 0x002cd8,[CaseFold] = 0x002cd9}, NULL},
	{0x002cd9, {[CaseLower] = 0x002cd9,[CaseTitle] = 0x002cd8,[CaseUpper] = 0x002cd8,[CaseFold] = 0x002cd9}, NULL},
	{0x002cda, {[CaseLower] = 0x002cdb,[CaseTitle] = 0x002cda,[CaseUpper] = 0x002cda,[CaseFold] = 0x002cdb}, NULL},
	{0x002cdb, {[CaseLower] = 0x002cdb,[CaseTitle] = 0x002cda,[CaseUpper] = 0x002cda,[CaseFold] = 0x002cdb}, NULL},
	{0x002cdc, {[CaseLower] = 0x002cdd,[CaseTitle] = 0x002cdc,[CaseUpper] = 0x002cdc,[CaseFold] = 0x002cdd}, NULL},
	{0x002cdd, {[CaseLower] = 0x002cdd,[CaseTitle] = 0x002cdc,[CaseUpper] = 0x002cdc,[CaseFold] = 0x002cdd}, NULL},
	{0x002cde, {[CaseLower] = 0x002cdf,[CaseTitle] = 0x002cde,[CaseUpper] = 0x002cde,[CaseFold] = 0x002cdf}, NULL},
	{0x002cdf, {[CaseLower] = 0x002cdf,[CaseTitle] = 0x002cde,[CaseUpper] = 0x002cde,[CaseFold] = 0x002cdf}, NULL},
	{0x002ce0, {[CaseLower] = 0x002ce1,[CaseTitle] = 0x002ce0,[CaseUpper] = 0x002ce0,[CaseFold] = 0x002ce1}, NULL},
	{0x002ce1, {[CaseLower] = 0x002ce1,[CaseTitle] = 0x002ce0,[CaseUpper] = 0x002ce0,[CaseFold] = 0x002ce1}, NULL},
	{0x002ce2, {[CaseLower] = 0x002ce3,[CaseTitle] = 0x002ce2,[CaseUpper] = 0x002ce2,[CaseFold] = 0x002ce3}, NULL},
	{0x002ce3, {[CaseLower] = 0x002ce3,[CaseTitle] = 0x002ce2,[CaseUpper] = 0x002ce2,[CaseFold] = 0x002ce3}, NULL},
	{0x002ceb, {[CaseLower] = 0x002cec,[CaseTitle] = 0x002ceb,[CaseUpper] = 0x002ceb,[CaseFold] = 0x002cec}, NULL},
	{0x002cec, {[CaseLower] = 0x002cec,[CaseTitle] = 0x002ceb,[CaseUpper] = 0x002ceb,[CaseFold] = 0x002cec}, NULL},
	{0x002ced, {[CaseLower] = 0x002cee,[CaseTitle] = 0x002ced,[CaseUpper] = 0x002ced,[CaseFold] = 0x002cee}, NULL},
	{0x002cee, {[CaseLower] = 0x002cee,[CaseTitle] = 0x002ced,[CaseUpper] = 0x002ced,[CaseFold] = 0x002cee}, NULL},
	{0x002cf2, {[CaseLower] = 0x002cf3,[CaseTitle] = 0x002cf2,[CaseUpper] = 0x002cf2,[CaseFold] = 0x002cf3}, NULL},
	{0x002cf3, {[CaseLower] = 0x002cf3,[CaseTitle] = 0x002cf2,[CaseUpper] = 0x002cf2,[CaseFold] = 0x002cf3}, NULL},
	{0x002d00, {[CaseLower] = 0x002d00,[CaseTitle] = 0x0010a0,[CaseUpper] = 0x0010a0,[CaseFold] = 0x002d00}, NULL},
	{0x002d01, {[CaseLower] = 0x002d01,[CaseTitle] = 0x0010a1,[CaseUpper] = 0x0010a1,[CaseFold] = 0x002d01}, NULL},
	{0x002d02, {[CaseLower] = 0x002d02,[CaseTitle] = 0x0010a2,[CaseUpper] = 0x0010a2,[CaseFold] = 0x002d02}, NULL},
	{0x002d03, {[CaseLower] = 0x002d03,[CaseTitle] = 0x0010a3,[CaseUpper] = 0x0010a3,[CaseFold] = 0x002d03}, NULL},
	{0x002d04, {[CaseLower] = 0x002d04,[CaseTitle] = 0x0010a4,[CaseUpper] = 0x0010a4,[CaseFold] = 0x002d04}, NULL},
	{0x002d05, {[CaseLower] = 0x002d05,[CaseTitle] = 0x0010a5,[CaseUpper] = 0x0010a5,[CaseFold] = 0x002d05}, NULL},
	{0x002d06, {[CaseLower] = 0x002d06,[CaseTitle] = 0x0010a6,[CaseUpper] = 0x0010a6,[CaseFold] = 0x002d06}, NULL},
	{0x002d07, {[CaseLower] = 0x002d07,[CaseTitle] = 0x0010a7,[CaseUpper] = 0x0010a7,[CaseFold] = 0x002d07}, NULL},
	{0x002d08, {[CaseLower] = 0x002d08,[CaseTitle] = 0x0010a8,[CaseUpper] = 0x0010a8,[CaseFold] = 0x002d08}, NULL},
	{0x002d09, {[CaseLower] = 0x002d09,[CaseTitle] = 0x0010a9,[CaseUpper] = 0x0010a9,[CaseFold] = 0x002d09}, NULL},
	{0x002d0a, {[CaseLower] = 0x002d0a,[CaseTitle] = 0x0010aa,[CaseUpper] = 0x0010aa,[CaseFold] = 0x002d0a}, NULL},
	{0x002d0b, {[CaseLower] = 0x002d0b,[CaseTitle] = 0x0010ab,[CaseUpper] = 0x0010ab,[CaseFold] = 0x002d0b}, NULL},
	{0x002d0c, {[CaseLower] = 0x002d0c,[CaseTitle] = 0x0010ac,[CaseUpper] = 0x0010ac,[CaseFold] = 0x002d0c}, NULL},
	{0x002d0d, {[CaseLower] = 0x002d0d,[CaseTitle] = 0x0010ad,[CaseUpper] = 0x0010ad,[CaseFold] = 0x002d0d}, NULL},
	{0x002d0e, {[CaseLower] = 0x002d0e,[CaseTitle] = 0x0010ae,[CaseUpper] = 0x0010ae,[CaseFold] = 0x002d0e}, NULL},
	{0x002d0f, {[CaseLower] = 0x002d0f,[CaseTitle] = 0x0010af,[CaseUpper] = 0x0010af,[CaseFold] = 0x002d0f}, NULL},
	{0x002d10, {[CaseLower] = 0x002d10,[CaseTitle] = 0x0010b0,[CaseUpper] = 0x0010b0,[CaseFold] = 0x002d10}, NULL},
	{0x002d11, {[CaseLower] = 0x002d11,[CaseTitle] = 0x0010b1,[CaseUpper] = 0x0010b1,[CaseFold] = 0x002d11}, NULL},
	{0x002d12, {[CaseLower] = 0x002d12,[CaseTitle] = 0x0010b2,[CaseUpper] = 0x0010b2,[CaseFold] = 0x002d12}, NULL},
	{0x002d13, {[CaseLower] = 0x002d13,[CaseTitle] = 0x0010b3,[CaseUpper] = 0x0010b3,[CaseFold] = 0x002d13}, NULL},
	{0x002d14, {[CaseLower] = 0x002d14,[CaseTitle] = 0x0010b4,[CaseUpper] = 0x0010b4,[CaseFold] = 0x002d14}, NULL},
	{0x002d15, {[CaseLower] = 0x002d15,[CaseTitle] = 0x0010b5,[CaseUpper] = 0x0010b5,[CaseFold] = 0x002d15}, NULL},
	{0x002d16, {[CaseLower] = 0x002d16,[CaseTitle] = 0x0010b6,[CaseUpper] = 0x0010b6,[CaseFold] = 0x002d16}, NULL},
	{0x002d17, {[CaseLower] = 0x002d17,[CaseTitle] = 0x0010b7,[CaseUpper] = 0x0010b7,[CaseFold] = 0x002d17}, NULL},
	{0x002d18, {[CaseLower] = 0x002d18,[CaseTitle] = 0x0010b8,[CaseUpper] = 0x0010b8,[CaseFold] = 0x002d18}, NULL},
	{0x002d19, {[CaseLower] = 0x002d19,[CaseTitle] = 0x0010b9,[CaseUpper] = 0x0010b9,[CaseFold] = 0x002d19}, NULL},
	{0x002d1a, {[CaseLower] = 0x002d1a,[CaseTitle] = 0x0010ba,[CaseUpper] = 0x0010ba,[CaseFold] = 0x002d1a}, NULL},
	{0x002d1b, {[CaseLower] = 0x002d1b,[CaseTitle] = 0x0010bb,[CaseUpper] = 0x0010bb,[CaseFold] = 0x002d1b}, NULL},
	{0x002d1c, {[CaseLower] = 0x002d1c,[CaseTitle] = 0x0010bc,[CaseUpper] = 0x0010bc,[CaseFold] = 0x002d1c}, NULL},
	{0x002d1d, {[CaseLower] = 0x002d1d,[CaseTitle] = 0x0010bd,[CaseUpper] = 0x0010bd,[CaseFold] = 0x002d1d}, NULL},
	{0x002d1e, {[CaseLower] = 0x002d1e,[CaseTitle] = 0x0010be,[CaseUpper] = 0x0010be,[CaseFold] = 0x002d1e}, NULL},
	{0x002d1f, {[CaseLower] = 0x002d1f,[CaseTitle] = 0x0010bf,[CaseUpper] = 0x0010bf,[CaseFold] = 0x002d1f}, NULL},
	{0x002d20, {[CaseLower] = 0x002d20,[CaseTitle] = 0x0010c0,[CaseUpper] = 0x0010c0,[CaseFold] = 0x002d20}, NULL},
	{0x002d21, {[CaseLower] = 0x002d21,[CaseTitle] = 0x0010c1,[CaseUpper] = 0x0010c1,[CaseFold] = 0x002d21}, NULL},
	{0x002d22, {[CaseLower] = 0x002d22,[CaseTitle] = 0x0010c2,[CaseUpper] = 0x0010c2,[CaseFold] = 0x002d22}, NULL},
	{0x002d23, {[CaseLower] = 0x002d23,[CaseTitle] = 0x0010c3,[CaseUpper] = 0x0010c3,[CaseFold] = 0x002d23}, NULL},
	{0x002d24, {[CaseLower] = 0x002d24,[CaseTitle] = 0x0010c4,[CaseUpper] = 0x0010c4,[CaseFold] = 0x002d24}, NULL},
	{0x002d25, {[CaseLower] = 0x002d25,[CaseTitle] = 0x0010c5,[CaseUpper] = 0x0010c5,[CaseFold] = 0x002d25}, NULL},
	{0x002d27, {[CaseLower] = 0x002d27,[CaseTitle] = 0x0010c7,[CaseUpper] = 0x0010c7,[CaseFold] = 0x002d27}, NULL},
	{0x002d2d, {[CaseLower] = 0x002d2d,[CaseTitle] = 0x0010cd,[CaseUpper] = 0x0010cd,[CaseFold] = 0x002d2d}, NULL},
	{0x00a640, {[CaseLower] = 0x00a641,[CaseTitle] = 0x00a640,[CaseUpper] = 0x00a640,[CaseFold] = 0x00a641}, NULL},
	{0x00a641, {[CaseLower] = 0x00a641,[CaseTitle] = 0x00a640,[CaseUpper] = 0x00a640,[CaseFold] = 0x00a641}, NULL},
	{0x00a642, {[CaseLower] = 0x00a643,[CaseTitle] = 0x00a642,[CaseUpper] = 0x00a642,[CaseFold] = 0x00a643}, NULL},
	{0x00a643, {[CaseLower] = 0x00a643,[CaseTitle] = 0x00a642,[CaseUpper] = 0x00a642,[CaseFold] = 0x00a643}, NULL},
	{0x00a644, {[CaseLower] = 0x00a645,[CaseTitle] = 0x00a644,[CaseUpper] = 0x00a644,[CaseFold] = 0x00a645}, NULL},
	{0x00a645, {[CaseLower] = 0x00a645,[CaseTitle] = 0x00a644,[CaseUpper] = 0x00a644,[CaseFold] = 0x00a645}, NULL},
	{0x00a646, {[CaseLower] = 0x00a647,[CaseTitle] = 0x00a646,[CaseUpper] = 0x00a646,[CaseFold] = 0x00a647}, NULL},
	{0x00a647, {[CaseLower] = 0x00a647,[CaseTitle] = 0x00a646,[CaseUpper] = 0x00a646,[CaseFold] = 0x00a647}, NULL},
	{0x00a648, {[CaseLower] = 0x00a649,[CaseTitle] = 0x00a648,[CaseUpper] = 0x00a648,[CaseFold] = 0x00a649}, NULL},
	{0x00a649, {[CaseLower] = 0x00a649,[CaseTitle] = 0x00a648,[CaseUpper] = 0x00a648,[CaseFold] = 0x00a649}, NULL},
	{0x00a64a, {[CaseLower] = 0x00a64b,[CaseTitle] = 0x00a64a,[CaseUpper] = 0x00a64a,[CaseFold] = 0x00a64b}, NULL},
	{0x00a64b, {[CaseLower] = 0x00a64b,[CaseTitle] = 0x00a64a,[CaseUpper] = 0x00a64a,[CaseFold] = 0x00a64b}, NULL},
	{0x00a64c, {[CaseLower] = 0x00a64d,[CaseTitle] = 0x00a64c,[CaseUpper] = 0x00a64c,[CaseFold] = 0x00a64d}, NULL},
	{0x00a64d, {[CaseLower] = 0x00a64d,[CaseTitle] = 0x00a64c,[CaseUpper] = 0x00a64c,[CaseFold] = 0x00a64d}, NULL},
	{0x00a64e, {[CaseLower] = 0x00a64f,[CaseTitle] = 0x00a64e,[CaseUpper] = 0x00a64e,[CaseFold] = 0x00a64f}, NULL},
	{0x00a64f, {[CaseLower] = 0x00a64f,[CaseTitle] = 0x00a64e,[CaseUpper] = 0x00a64e,[CaseFold] = 0x00a64f}, NULL},
	{0x00a650, {[CaseLower] = 0x00a651,[CaseTitle] = 0x00a650,[CaseUpper] = 0x00a650,[CaseFold] = 0x00a651}, NULL},
	{0x00a651, {[CaseLower] = 0x00a651,[CaseTitle] = 0x00a650,[CaseUpper] = 0x00a650,[CaseFold] = 0x00a651}, NULL},
	{0x00a652, {[CaseLower] = 0x00a653,[CaseTitle] = 0x00a652,[CaseUpper] = 0x00a652,[CaseFold] = 0x00a653}, NULL},
	{0x00a653, {[CaseLower] = 0x00a653,[CaseTitle] = 0x00a652,[CaseUpper] = 0x00a652,[CaseFold] = 0x00a653}, NULL},
	{0x00a654, {[CaseLower] = 0x00a655,[CaseTitle] = 0x00a654,[CaseUpper] = 0x00a654,[CaseFold] = 0x00a655}, NULL},
	{0x00a655, {[CaseLower] = 0x00a655,[CaseTitle] = 0x00a654,[CaseUpper] = 0x00a654,[CaseFold] = 0x00a655}, NULL},
	{0x00a656, {[CaseLower] = 0x00a657,[CaseTitle] = 0x00a656,[CaseUpper] = 0x00a656,[CaseFold] = 0x00a657}, NULL},
	{0x00a657, {[CaseLower] = 0x00a657,[CaseTitle] = 0x00a656,[CaseUpper] = 0x00a656,[CaseFold] = 0x00a657}, NULL},
	{0x00a658, {[CaseLower] = 0x00a659,[CaseTitle] = 0x00a658,[CaseUpper] = 0x00a658,[CaseFold] = 0x00a659}, NULL},
	{0x00a659, {[CaseLower] = 0x00a659,[CaseTitle] = 0x00a658,[CaseUpper] = 0x00a658,[CaseFold] = 0x00a659}, NULL},
	{0x00a65a, {[CaseLower] = 0x00a65b,[CaseTitle] = 0x00a65a,[CaseUpper] = 0x00a65a,[CaseFold] = 0x00a65b}, NULL},
	{0x00a65b, {[CaseLower] = 0x00a65b,[CaseTitle] = 0x00a65a,[CaseUpper] = 0x00a65a,[CaseFold] = 0x00a65b}, NULL},
	{0x00a65c, {[CaseLower] = 0x00a65d,[CaseTitle] = 0x00a65c,[CaseUpper] = 0x00a65c,[CaseFold] = 0x00a65d}, NULL},
	{0x00a65d, {[CaseLower] = 0x00a65d,[CaseTitle] = 0x00a65c,[CaseUpper] = 0x00a65c,[CaseFold] = 0x00a65d}, NULL},
	{0x00a65e, {[CaseLower] = 0x00a65f,[CaseTitle] = 0x00a65e,[CaseUpper] = 0x00a65e,[CaseFold] = 0x00a65f}, NULL},
	{0x00a65f, {[CaseLower] = 0x00a65f,[CaseTitle] = 0x00a65e,[CaseUpper] = 0x00a65e,[CaseFold] = 0x00a65f}, NULL},
	{0x00a660, {[CaseLower] = 0x00a661,[CaseTitle] = 0x00a660,[CaseUpper] = 0x00a660,[CaseFold] = 0x00a661}, NULL},
	{0x00a661, {[CaseLower] = 0x00a661,[CaseTitle] = 0x00a660,[CaseUpper] = 0x00a660,[CaseFold] = 0x00a661}, NULL},
	{0x00a662, {[CaseLower] = 0x00a663,[CaseTitle] = 0x00a662,[CaseUpper] = 0x00a662,[CaseFold] = 0x00a663}, NULL},
	{0x00a663, {[CaseLower] = 0x00a663,[CaseTitle] = 0x00a662,[CaseUpper] = 0x00a662,[CaseFold] = 0x00a663}, NULL},
	{0x00a664, {[CaseLower] = 0x00a665,[CaseTitle] = 0x00a664,[CaseUpper] = 0x00a664,[CaseFold] = 0x00a665}, NULL},
	{0x00a665, {[CaseLower] = 0x00a665,[CaseTitle] = 0x00a664,[CaseUpper] = 0x00a664,[CaseFold] = 0x00a665}, NULL},
	{0x00a666, {[CaseLower] = 0x00a667,[CaseTitle] = 0x00a666,[CaseUpper] = 0x00a666,[CaseFold] = 0x00a667}, NULL},
	{0x00a667, {[CaseLower] = 0x00a667,[CaseTitle] = 0x00a666,[CaseUpper] = 0x00a666,[CaseFold] = 0x00a667}, NULL},
	{0x00a668, {[CaseLower] = 0x00a669,[CaseTitle] = 0x00a668,[CaseUpper] = 0x00a668,[CaseFold] = 0x00a669}, NULL},
	{0x00a669, {[CaseLower] = 0x00a669,[CaseTitle] = 0x00a668,[CaseUpper] = 0x00a668,[CaseFold] = 0x00a669}, NULL},
	{0x00a66a, {[CaseLower] = 0x00a66b,[CaseTitle] = 0x00a66a,[CaseUpper] = 0x00a66a,[CaseFold] = 0x00a66b}, NULL},
	{0x00a66b, {[CaseLower] = 0x00a66b,[CaseTitle] = 0x00a66a,[CaseUpper] = 0x00a66a,[CaseFold] = 0x00a66b}, NULL},
	{0x00a66c, {[CaseLower] = 0x00a66d,[CaseTitle] = 0x00a66c,[CaseUpper] = 0x00a66c,[CaseFold] = 0x00a66d}, NULL},
	{0x00a66d, {[CaseLower] = 0x00a66d,[CaseTitle] = 0x00a66c,[CaseUpper] = 0x00a66c,[CaseFold] = 0x00a66d}, NULL},
	{0x00a680, {[CaseLower] = 0x00a681,[CaseTitle] = 0x00a680,[CaseUpper] = 0x00a680,[CaseFold] = 0x00a681}, NULL},
	{0x00a681, {[CaseLower] = 0x00a681,[CaseTitle] = 0x00a680,[CaseUpper] = 0x00a680,[CaseFold] = 0x00a681}, NULL},
	{0x00a682, {[CaseLower] = 0x00a683,[CaseTitle] = 0x00a682,[CaseUpper] = 0x00a682,[CaseFold] = 0x00a683}, NULL},
	{0x00a683, {[CaseLower] = 0x00a683,[CaseTitle] = 0x00a682,[CaseUpper] = 0x00a682,[CaseFold] = 0x00a683}, NULL},
	{0x00a684, {[CaseLower] = 0x00a685,[CaseTitle] = 0x00a684,[CaseUpper] = 0x00a684,[CaseFold] = 0x00a685}, NULL},
	{0x00a685, {[CaseLower] = 0x00a685,[CaseTitle] = 0x00a684,[CaseUpper] = 0x00a684,[CaseFold] = 0x00a685}, NULL},
	{0x00a686, {[CaseLower] = 0x00a687,[CaseTitle] = 0x00a686,[CaseUpper] = 0x00a686,[CaseFold] = 0x00a687}, NULL},
	{0x00a687, {[CaseLower] = 0x00a687,[CaseTitle] = 0x00a686,[CaseUpper] = 0x00a686,[CaseFold] = 0x00a687}, NULL},
	{0x00a688, {[CaseLower] = 0x00a689,[CaseTitle] = 0x00a688,[CaseUpper] = 0x00a688,[CaseFold] = 0x00a689}, NULL},
	{0x00a689, {[CaseLower] = 0x00a689,[CaseTitle] = 0x00a688,[CaseUpper] = 0x00a688,[CaseFold] = 0x00a689}, NULL},
	{0x00a68a, {[CaseLower] = 0x00a68b,[CaseTitle] = 0x00a68a,[CaseUpper] = 0x00a68a,[CaseFold] = 0x00a68b}, NULL},
	{0x00a68b, {[CaseLower] = 0x00a68b,[CaseTitle] = 0x00a68a,[CaseUpper] = 0x00a68a,[CaseFold] = 0x00a68b}, NULL},
	{0x00a68c, {[CaseLower] = 0x00a68d,[CaseTitle] = 0x00a68c,[CaseUpper] = 0x00a68c,[CaseFold] = 0x00a68d}, NULL},
	{0x00a68d, {[CaseLower] = 0x00a68d,[CaseTitle] = 0x00a68c,[CaseUpper] = 0x00a68c,[CaseFold] = 0x00a68d}, NULL},
	{0x00a68e, {[CaseLower] = 0x00a68f,[CaseTitle] = 0x00a68e,[CaseUpper] = 0x00a68e,[CaseFold] = 0x00a68f}, NULL},
	{0x00a68f, {[CaseLower] = 0x00a68f,[CaseTitle] = 0x00a68e,[CaseUpper] = 0x00a68e,[CaseFold] = 0x00a68f}, NULL},
	{0x00a690, {[CaseLower] = 0x00a691,[CaseTitle] = 0x00a690,[CaseUpper] = 0x00a690,[CaseFold] = 0x00a691}, NULL},
	{0x00a691, {[CaseLower] = 0x00a691,[CaseTitle] = 0x00a690,[CaseUpper] = 0x00a690,[CaseFold] = 0x00a691}, NULL},
	{0x00a692, {[CaseLower] = 0x00a693,[CaseTitle] = 0x00a692,[CaseUpper] = 0x00a692,[CaseFold] = 0x00a693}, NULL},
	{0x00a693, {[CaseLower] = 0x00a693,[CaseTitle] = 0x00a692,[CaseUpper] = 0x00a692,[CaseFold] = 0x00a693}, NULL},
	{0x00a694, {[CaseLower] = 0x00a695,[CaseTitle] = 0x00a694,[CaseUpper] = 0x00a694,[CaseFold] = 0x00a695}, NULL},
	{0x00a695, {[CaseLower] = 0x00a695,[CaseTitle] = 0x00a694,[CaseUpper] = 0x00a694,[CaseFold] = 0x00a695}, NULL},
	{0x00a696, {[CaseLower] = 0x00a697,[CaseTitle] = 0x00a696,[CaseUpper] = 0x00a696,[CaseFold] = 0x00a697}, NULL},
	{0x00a697, {[CaseLower] = 0x00a697,[CaseTitle] = 0x00a696,[CaseUpper] = 0x00a696,[CaseFold] = 0x00a697}, NULL},
	{0x00a698, {[CaseLower] = 0x00a699,[CaseTitle] = 0x00a698,[CaseUpper] = 0x00a698,[CaseFold] = 0x00a699}, NULL},
	{0x00a699, {[CaseLower] = 0x00a699,[CaseTitle] = 0x00a698,[CaseUpper] = 0x00a698,[CaseFold] = 0x00a699}, NULL},
	{0x00a69a, {[CaseLower] = 0x00a69b,[CaseTitle] = 0x00a69a,[CaseUpper] = 0x00a69a,[CaseFold] = 0x00a69b}, NULL},
	{0x00a69b, {[CaseLower] = 0x00a69b,[CaseTitle] = 0x00a69a,[CaseUpper] = 0x00a69a,[CaseFold] = 0x00a69b}, NULL},
	{0x00a722, {[CaseLower] = 0x00a723,[CaseTitle] = 0x00a722,[CaseUpper] = 0x00a722,[CaseFold] = 0x00a723}, NULL},
	{0x00a723, {[CaseLower] = 0x00a723,[CaseTitle] = 0x00a722,[CaseUpper] = 0x00a722,[CaseFold] = 0x00a723}, NULL},
	{0x00a724, {[CaseLower] = 0x00a725,[CaseTitle] = 0x00a724,[CaseUpper] = 0x00a724,[CaseFold] = 0x00a725}, NULL},
	{0x00a725, {[CaseLower] = 0x00a725,[CaseTitle] = 0x00a724,[CaseUpper] = 0x00a724,[CaseFold] = 0x00a725}, NULL},
	{0x00a726, {[CaseLower] = 0x00a727,[CaseTitle] = 0x00a726,[CaseUpper] = 0x00a726,[CaseFold] = 0x00a727}, NULL},
	{0x00a727, {[CaseLower] = 0x00a727,[CaseTitle] = 0x00a726,[CaseUpper] = 0x00a726,[CaseFold] = 0x00a727}, NULL},
	{0x00a728, {[CaseLower] = 0x00a729,[CaseTitle] = 0x00a728,[CaseUpper] = 0x00a728,[CaseFold] = 0x00a729}, NULL},
	{0x00a729, {[CaseLower] = 0x00a729,[CaseTitle] = 0x00a728,[CaseUpper] = 0x00a728,[CaseFold] = 0x00a729}, NULL},
	{0x00a72a, {[CaseLower] = 0x00a72b,[CaseTitle] = 0x00a72a,[CaseUpper] = 0x00a72a,[CaseFold] = 0x00a72b}, NULL},
	{0x00a72b, {[CaseLower] = 0x00a72b,[CaseTitle] = 0x00a72a,[CaseUpper] = 0x00a72a,[CaseFold] = 0x00a72b}, NULL},
	{0x00a72c, {[CaseLower] = 0x00a72d,[CaseTitle] = 0x00a72c,[CaseUpper] = 0x00a72c,[CaseFold] = 0x00a72d}, NULL},
	{0x00a72d, {[CaseLower] = 0x00a72d,[CaseTitle] = 0x00a72c,[CaseUpper] = 0x00a72c,[CaseFold] = 0x00a72d}, NULL},
	{0x00a72e, {[CaseLower] = 0x00a72f,[CaseTitle] = 0x00a72e,[CaseUpper] = 0x00a72e,[CaseFold] = 0x00a72f}, NULL},
	{0x00a72f, {[CaseLower] = 0x00a72f,[CaseTitle] = 0x00a72e,[CaseUpper] = 0x00a72e,[CaseFold] = 0x00a72f}, NULL},
	{0x00a732, {[CaseLower] = 0x00a733,[CaseTitle] = 0x00a732,[CaseUpper] = 0x00a732,[CaseFold] = 0x00a733}, NULL},
	{0x00a733, {[CaseLower] = 0x00a733,[CaseTitle] = 0x00a732,[CaseUpper] = 0x00a732,[CaseFold] = 0x00a733}, NULL},
	{0x00a734, {[CaseLower] = 0x00a735,[CaseTitle] = 0x00a734,[CaseUpper] = 0x00a734,[CaseFold] = 0x00a735}, NULL},
	{0x00a735, {[CaseLower] = 0x00a735,[CaseTitle] = 0x00a734,[CaseUpper] = 0x00a734,[CaseFold] = 0x00a735}, NULL},
	{0x00a736, {[CaseLower] = 0x00a737,[CaseTitle] = 0x00a736,[CaseUpper] = 0x00a736,[CaseFold] = 0x00a737}, NULL},
	{0x00a737, {[CaseLower] = 0x00a737,[CaseTitle] = 0x00a736,[CaseUpper] = 0x00a736,[CaseFold] = 0x00a737}, NULL},
	{0x00a738, {[CaseLower] = 0x00a739,[CaseTitle] = 0x00a738,[CaseUpper] = 0x00a738,[CaseFold] = 0x00a739}, NULL},
	{0x00a739, {[CaseLower] = 0x00a739,[CaseTitle] = 0x00a738,[CaseUpper] = 0x00a738,[CaseFold] = 0x00a739}, NULL},
	{0x00a73a, {[CaseLower] = 0x00a73b,[CaseTitle] = 0x00a73a,[CaseUpper] = 0x00a73a,[CaseFold] = 0x00a73b}, NULL},
	{0x00a73b, {[CaseLower] = 0x00a73b,[CaseTitle] = 0x00a73a,[CaseUpper] = 0x00a73a,[CaseFold] = 0x00a73b}, NULL},
	{0x00a73c, {[CaseLower] = 0x00a73d,[CaseTitle] = 0x00a73c,[CaseUpper] = 0x00a73c,[CaseFold] = 0x00a73d}, NULL},
	{0x00a73d, {[CaseLower] = 0x00a73d,[CaseTitle] = 0x00a73c,[CaseUpper] = 0x00a73c,[CaseFold] = 0x00a73d}, NULL},
	{0x00a73e, {[CaseLower] = 0x00a73f,[CaseTitle] = 0x00a73e,[CaseUpper] = 0x00a73e,[CaseFold] = 0x00a73f}, NULL},
	{0x00a73f, {[CaseLower] = 0x00a73f,[CaseTitle] = 0x00a73e,[CaseUpper] = 0x00a73e,[CaseFold] = 0x00a73f}, NULL},
	{0x00a740, {[CaseLower] = 0x00a741,[CaseTitle] = 0x00a740,[CaseUpper] = 0x00a740,[CaseFold] = 0x00a741}, NULL},
	{0x00a741, {[CaseLower] = 0x00a741,[CaseTitle] = 0x00a740,[CaseUpper] = 0x00a740,[CaseFold] = 0x00a741}, NULL},
	{0x00a742, {[CaseLower] = 0x00a743,[CaseTitle] = 0x00a742,[CaseUpper] = 0x00a742,[CaseFold] = 0x00a743}, NULL},
	{0x00a743, {[CaseLower] = 0x00a743,[CaseTitle] = 0x00a742,[CaseUpper] = 0x00a742,[CaseFold] = 0x00a743}, NULL},
	{0x00a744, {[CaseLower] = 0x00a745,[CaseTitle] = 0x00a744,[CaseUpper] = 0x00a744,[CaseFold] = 0x00a745}, NULL},
	{0x00a745, {[CaseLower] = 0x00a745,[CaseTitle] = 0x00a744,[CaseUpper] = 0x00a744,[CaseFold] = 0x00a745}, NULL},
	{0x00a746, {[CaseLower] = 0x00a747,[CaseTitle] = 0x00a746,[CaseUpper] = 0x00a746,[CaseFold] = 0x00a747}, NULL},
	{0x00a747, {[CaseLower] = 0x00a747,[CaseTitle] = 0x00a746,[CaseUpper] = 0x00a746,[CaseFold] = 0x00a747}, NULL},
	{0x00a748, {[CaseLower] = 0x00a749,[CaseTitle] = 0x00a748,[CaseUpper] = 0x00a748,[CaseFold] = 0x00a749}, NULL},
	{0x00a749, {[CaseLower] = 0x00a749,[CaseTitle] = 0x00a748,[CaseUpper] = 0x00a748,[CaseFold] = 0x00a749}, NULL},
	{0x00a74a, {[CaseLower] = 0x00a74b,[CaseTitle] = 0x00a74a,[CaseUpper] = 0x00a74a,[CaseFold] = 0x00a74b}, NULL},
	{0x00a74b, {[CaseLower] = 0x00a74b,[CaseTitle] = 0x00a74a,[CaseUpper] = 0x00a74a,[CaseFold] = 0x00a74b}, NULL},
	{0x00a74c, {[CaseLower] = 0x00a74d,[CaseTitle] = 0x00a74c,[CaseUpper] = 0x00a74c,[CaseFold] = 0x00a74d}, NULL},
	{0x00a74d, {[CaseLower] = 0x00a74d,[CaseTitle] = 0x00a74c,[CaseUpper] = 0x00a74c,[CaseFold] = 0x00a74d}, NULL},
	{0x00a74e, {[CaseLower] = 0x00a74f,[CaseTitle] = 0x00a74e,[CaseUpper] = 0x00a74e,[CaseFold] = 0x00a74f}, NULL},
	{0x00a74f, {[CaseLower] = 0x00a74f,[CaseTitle] = 0x00a74e,[CaseUpper] = 0x00a74e,[CaseFold] = 0x00a74f}, NULL},
	{0x00a750, {[CaseLower] = 0x00a751,[CaseTitle] = 0x00a750,[CaseUpper] = 0x00a750,[CaseFold] = 0x00a751}, NULL},
	{0x00a751, {[CaseLower] = 0x00a751,[CaseTitle] = 0x00a750,[CaseUpper] = 0x00a750,[CaseFold] = 0x00a751}, NULL},
	{0x00a752, {[CaseLower] = 0x00a753,[CaseTitle] = 0x00a752,[CaseUpper] = 0x00a752,[CaseFold] = 0x00a753}, NULL},
	{0x00a753, {[CaseLower] = 0x00a753,[CaseTitle] = 0x00a752,[CaseUpper] = 0x00a752,[CaseFold] = 0x00a753}, NULL},
	{0x00a754, {[CaseLower] = 0x00a755,[CaseTitle] = 0x00a754,[CaseUpper] = 0x00a754,[CaseFold] = 0x00a755}, NULL},
	{0x00a755, {[CaseLower] = 0x00a755,[CaseTitle] = 0x00a754,[CaseUpper] = 0x00a754,[CaseFold] = 0x00a755}, NULL},
	{0x00a756, {[CaseLower] = 0x00a757,[CaseTitle] = 0x00a756,[CaseUpper] = 0x00a756,[CaseFold] = 0x00a757}, NULL},
	{0x00a757, {[CaseLower] = 0x00a757,[CaseTitle] = 0x00a756,[CaseUpper] = 0x00a756,[CaseFold] = 0x00a757}, NULL},
	{0x00a758, {[CaseLower] = 0x00a759,[CaseTitle] = 0x00a758,[CaseUpper] = 0x00a758,[CaseFold] = 0x00a759}, NULL},
	{0x00a759, {[CaseLower] = 0x00a759,[CaseTitle] = 0x00a758,[CaseUpper] = 0x00a758,[CaseFold] = 0x00a759}, NULL},
	{0x00a75a, {[CaseLower] = 0x00a75b,[CaseTitle] = 0x00a75a,[CaseUpper] = 0x00a75a,[CaseFold] = 0x00a75b}, NULL},
	{0x00a75b, {[CaseLower] = 0x00a75b,[CaseTitle] = 0x00a75a,[CaseUpper] = 0x00a75a,[CaseFold] = 0x00a75b}, NULL},
	{0x00a75c, {[CaseLower] = 0x00a75d,[CaseTitle] = 0x00a75c,[CaseUpper] = 0x00a75c,[CaseFold] = 0x00a75d}, NULL},
	{0x00a75d, {[CaseLower] = 0x00a75d,[CaseTitle] = 0x00a75c,[CaseUpper] = 0x00a75c,[CaseFold] = 0x00a75d}, NULL},
	{0x00a75e, {[CaseLower] = 0x00a75f,[CaseTitle] = 0x00a75e,[CaseUpper] = 0x00a75e,[CaseFold] = 0x00a75f}, NULL},
	{0x00a75f, {[CaseLower] = 0x00a75f,[CaseTitle] = 0x00a75e,[CaseUpper] = 0x00a75e,[CaseFold] = 0x00a75f}, NULL},
	{0x00a760, {[CaseLower] = 0x00a761,[CaseTitle] = 0x00a760,[CaseUpper] = 0x00a760,[CaseFold] = 0x00a761}, NULL},
	{0x00a761, {[CaseLower] = 0x00a761,[CaseTitle] = 0x00a760,[CaseUpper] = 0x00a760,[CaseFold] = 0x00a761}, NULL},
	{0x00a762, {[CaseLower] = 0x00a763,[CaseTitle] = 0x00a762,[CaseUpper] = 0x00a762,[CaseFold] = 0x00a763}, NULL},
	{0x00a763, {[CaseLower] = 0x00a763,[CaseTitle] = 0x00a762,[CaseUpper] = 0x00a762,[CaseFold] = 0x00a763}, NULL},
	{0x00a764, {[CaseLower] = 0x00a765,[CaseTitle] = 0x00a764,[CaseUpper] = 0x00a764,[CaseFold] = 0x00a765}, NULL},
	{0x00a765, {[CaseLower] = 0x00a765,[CaseTitle] = 0x00a764,[CaseUpper] = 0x00a764,[CaseFold] = 0x00a765}, NULL},
	{0x00a766, {[CaseLower] = 0x00a767,[CaseTitle] = 0x00a766,[CaseUpper] = 0x00a766,[CaseFold] = 0x00a767}, NULL},
	{0x00a767, {[CaseLower] = 0x00a767,[CaseTitle] = 0x00a766,[CaseUpper] = 0x00a766,[CaseFold] = 0x00a767}, NULL},
	{0x00a768, {[CaseLower] = 0x00a769,[CaseTitle] = 0x00a768,[CaseUpper] = 0x00a768,[CaseFold] = 0x00a769}, NULL},
	{0x00a769, {[CaseLower] = 0x00a769,[CaseTitle] = 0x00a768,[CaseUpper] = 0x00a768,[CaseFold] = 0x00a769}, NULL},
	{0x00a76a, {[CaseLower] = 0x00a76b,[CaseTitle] = 0x00a76a,[CaseUpper] = 0x00a76a,[CaseFold] = 0x00a76b}, NULL},
	{0x00a76b, {[CaseLower] = 0x00a76b,[CaseTitle] = 0x00a76a,[CaseUpper] = 0x00a76a,[CaseFold] = 0x00a76b}, NULL},
	{0x00a76c, {[CaseLower] = 0x00a76d,[CaseTitle] = 0x00a76c,[CaseUpper] = 0x00a76c,[CaseFold] = 0x00a76d}, NULL},
	{0x00a76d, {[CaseLower] = 0x00a76d,[CaseTitle] = 0x00a76c,[CaseUpper] = 0x00a76c,[CaseFold] = 0x00a76d}, NULL},
	{0x00a76e, {[CaseLower] = 0x00a76f,[CaseTitle] = 0x00a76e,[CaseUpper] = 0x00a76e,[CaseFold] = 0x00a76f}, NULL},
	{0x00a76f, {[CaseLower] = 0x00a76f,[CaseTitle] = 0x00a76e,[CaseUpper] = 0x00a76e,[CaseFold] = 0x00a76f}, NULL},
	{0x00a779, {[CaseLower] = 0x00a77a,[CaseTitle] = 0x00a779,[CaseUpper] = 0x00a779,[CaseFold] = 0x00a77a}, NULL},
	{0x00a77a, {[CaseLower] = 0x00a77a,[CaseTitle] = 0x00a779,[CaseUpper] = 0x00a779,[CaseFold] = 0x00a77a}, NULL},
	{0x00a77b, {[CaseLower] = 0x00a77c,[CaseTitle] = 0x00a77b,[CaseUpper] = 0x00a77b,[CaseFold] = 0x00a77c}, NULL},
	{0x00a77c, {[CaseLower] = 0x00a77c,[CaseTitle] = 0x00a77b,[CaseUpper] = 0x00a77b,[CaseFold] = 0x00a77c}, NULL},
	{0x00a77d, {[CaseLower] = 0x001d79,[CaseTitle] = 0x00a77d,[CaseUpper] = 0x00a77d,[CaseFold] = 0x001d79}, NULL},
	{0x00a77e, {[CaseLower] = 0x00a77f,[CaseTitle] = 0x00a77e,[CaseUpper] = 0x00a77e,[CaseFold] = 0x00a77f}, NULL},
	{0x00a77f, {[CaseLower] = 0x00a77f,[CaseTitle] = 0x00a77e,[CaseUpper] = 0x00a77e,[CaseFold] = 0x00a77f}, NULL},
	{0x00a780, {[CaseLower] = 0x00a781,[CaseTitle] = 0x00a780,[CaseUpper] = 0x00a780,[CaseFold] = 0x00a781}, NULL},
	{0x00a781, {[CaseLower] = 0x00a781,[CaseTitle] = 0x00a780,[CaseUpper] = 0x00a780,[CaseFold] = 0x00a781}, NULL},
	{0x00a782, {[CaseLower] = 0x00a783,[CaseTitle] = 0x00a782,[CaseUpper] = 0x00a782,[CaseFold] = 0x00a783}, NULL},
	{0x00a783, {[CaseLower] = 0x00a783,[CaseTitle] = 0x00a782,[CaseUpper] = 0x00a782,[CaseFold] = 0x00a783}, NULL},
	{0x00a784, {[CaseLower] = 0x00a785,[CaseTitle] = 0x00a784,[CaseUpper] = 0x00a784,[CaseFold] = 0x00a785}, NULL},
	{0x00a785, {[CaseLower] = 0x00a785,[CaseTitle] = 0x00a784,[CaseUpper] = 0x00a784,[CaseFold] = 0x00a785}, NULL},
	{0x00a786, {[CaseLower] = 0x00a787,[CaseTitle] = 0x00a786,[CaseUpper] = 0x00a786,[CaseFold] = 0x00a787}, NULL},
	{0x00a787, {[CaseLower] = 0x00a787,[CaseTitle] = 0x00a786,[CaseUpper] = 0x00a786,[CaseFold] = 0x00a787}, NULL},
	{0x00a78b, {[CaseLower] = 0x00a78c,[CaseTitle] = 0x00a78b,[CaseUpper] = 0x00a78b,[CaseFold] = 0x00a78c}, NULL},
	{0x00a78c, {[CaseLower] = 0x00a78c,[CaseTitle] = 0x00a78b,[CaseUpper] = 0x00a78b,[CaseFold] = 0x00a78c}, NULL},
	{0x00a78d, {[CaseLower] = 0x000265,[CaseTitle] = 0x00a78d,[CaseUpper] = 0x00a78d,[CaseFold] = 0x000265}, NULL},
	{0x00a790, {[CaseLower] = 0x00a791,[CaseTitle] = 0x00a790,[CaseUpper] = 0x00a790,[CaseFold] = 0x00a791}, NULL},
	{0x00a791, {[CaseLower] = 0x00a791,[CaseTitle] = 0x00a790,[CaseUpper] = 0x00a790,[CaseFold] = 0x00a791}, NULL},
	{0x00a792, {[CaseLower] = 0x00a793,[CaseTitle] = 0x00a792,[CaseUpper] = 0x00a792,[CaseFold] = 0x00a793}, NULL},
	{0x00a793, {[CaseLower] = 0x00a793,[CaseTitle] = 0x00a792,[CaseUpper] = 0x00a792,[CaseFold] = 0x00a793}, NULL},
	{0x00a794, {[CaseLower] = 0x00a794,[CaseTitle] = 0x00a7c4,[CaseUpper] = 0x00a7c4,[CaseFold] = 0x00a794}, NULL},
	{0x00a796, {[CaseLower] = 0x00a797,[CaseTitle] = 0x00a796,[CaseUpper] = 0x00a796,[CaseFold] = 0x00a797}, NULL},
	{0x00a797, {[CaseLower] = 0x00a797,[CaseTitle] = 0x00a796,[CaseUpper] = 0x00a796,[CaseFold] = 0x00a797}, NULL},
	{0x00a798, {[CaseLower] = 0x00a799,[CaseTitle] = 0x00a798,[CaseUpper] = 0x00a798,[CaseFold] = 0x00a799}, NULL},
	{0x00a799, {[CaseLower] = 0x00a799,[CaseTitle] = 0x00a798,[CaseUpper] = 0x00a798,[CaseFold] = 0x00a799}, NULL},
	{0x00a79a, {[CaseLower] = 0x00a79b,[CaseTitle] = 0x00a79a,[CaseUpper] = 0x00a79a,[CaseFold] = 0x00a79b}, NULL},
	{0x00a79b, {[CaseLower] = 0x00a79b,[CaseTitle] = 0x00a79a,[CaseUpper] = 0x00a79a,[CaseFold] = 0x00a79b}, NULL},
	{0x00a79c, {[CaseLower] = 0x00a79d,[CaseTitle] = 0x00a79c,[CaseUpper] = 0x00a79c,[CaseFold] = 0x00a79d}, NULL},
	{0x00a79d, {[CaseLower] = 0x00a79d,[CaseTitle] = 0x00a79c,[CaseUpper] = 0x00a79c,[CaseFold] = 0x00a79d}, NULL},
	{0x00a79e, {[CaseLower] = 0x00a79f,[CaseTitle] = 0x00a79e,[CaseUpper] = 0x00a79e,[CaseFold] = 0x00a79f}, NULL},
	{0x00a79f, {[CaseLower] = 0x00a79f,[CaseTitle] = 0x00a79e,[CaseUpper] = 0x00a79e,[CaseFold] = 0x00a79f}, NULL},
	{0x00a7a0, {[CaseLower] = 0x00a7a1,[CaseTitle] = 0x00a7a0,[CaseUpper] = 0x00a7a0,[CaseFold] = 0x00a7a1}, NULL},
	{0x00a7a1, {[CaseLower] = 0x00a7a1,[CaseTitle] = 0x00a7a0,[CaseUpper] = 0x00a7a0,[CaseFold] = 0x00a7a1}, NULL},
	{0x00a7a2, {[CaseLower] = 0x00a7a3,[CaseTitle] = 0x00a7a2,[CaseUpper] = 0x00a7a2,[CaseFold] = 0x00a7a3}, NULL},
	{0x00a7a3, {[CaseLower] = 0x00a7a3,[CaseTitle] = 0x00a7a2,[CaseUpper] = 0x00a7a2,[CaseFold] = 0x00a7a3}, NULL},
	{0x00a7a4, {[CaseLower] = 0x00a7a5,[CaseTitle] = 0x00a7a4,[CaseUpper] = 0x00a7a4,[CaseFold] = 0x00a7a5}, NULL},
	{0x00a7a5, {[CaseLower] = 0x00a7a5,[CaseTitle] = 0x00a7a4,[CaseUpper] = 0x00a7a4,[CaseFold] = 0x00a7a5}, NULL},
	{0x00a7a6, {[CaseLower] = 0x00a7a7,[CaseTitle] = 0x00a7a6,[CaseUpper] = 0x00a7a6,[CaseFold] = 0x00a7a7}, NULL},
	{0x00a7a7, {[CaseLower] = 0x00a7a7,[CaseTitle] = 0x00a7a6,[CaseUpper] = 0x00a7a6,[CaseFold] = 0x00a7a7}, NULL},
	{0x00a7a8, {[CaseLower] = 0x00a7a9,[CaseTitle] = 0x00a7a8,[CaseUpper] = 0x00a7a8,[CaseFold] = 0x00a7a9}, NULL},
	{0x00a7a9, {[CaseLower] = 0x00a7a9,[CaseTitle] = 0x00a7a8,[CaseUpper] = 0x00a7a8,[CaseFold] = 0x00a7a9}, NULL},
	{0x00a7aa, {[CaseLower] = 0x000266,[CaseTitle] = 0x00a7aa,[CaseUpper] = 0x00a7aa,[CaseFold] = 0x000266}, NULL},
	{0x00a7ab, {[CaseLower] = 0x00025c,[CaseTitle] = 0x00a7ab,[CaseUpper] = 0x00a7ab,[CaseFold] = 0x00025c}, NULL},
	{0x00a7ac, {[CaseLower] = 0x000261,[CaseTitle] = 0x00a7ac,[CaseUpper] = 0x00a7ac,[CaseFold] = 0x000261}, NULL},
	{0x00a7ad, {[CaseLower] = 0x00026c,[CaseTitle] = 0x00a7ad,[CaseUpper] = 0x00a7ad,[CaseFold] = 0x00026c}, NULL},
	{0x00a7ae, {[CaseLower] = 0x00026a,[CaseTitle] = 0x00a7ae,[CaseUpper] = 0x00a7ae,[CaseFold] = 0x00026a}, NULL},
	{0x00a7b0, {[CaseLower] = 0x00029e,[CaseTitle] = 0x00a7b0,[CaseUpper] = 0x00a7b0,[CaseFold] = 0x00029e}, NULL},
	{0x00a7b1, {[CaseLower] = 0x000287,[CaseTitle] = 0x00a7b1,[CaseUpper] = 0x00a7b1,[CaseFold] = 0x000287}, NULL},
	{0x00a7b2, {[CaseLower] = 0x00029d,[CaseTitle] = 0x00a7b2,[CaseUpper] = 0x00a7b2,[CaseFold] = 0x00029d}, NULL},
	{0x00a7b3, {[CaseLower] = 0x00ab53,[CaseTitle] = 0x00a7b3,[CaseUpper] = 0x00a7b3,[CaseFold] = 0x00ab53}, NULL},
	{0x00a7b4, {[CaseLower] = 0x00a7b5,[CaseTitle] = 0x00a7b4,[CaseUpper] = 0x00a7b4,[CaseFold] = 0x00a7b5}, NULL},
	{0x00a7b5, {[CaseLower] = 0x00a7b5,[CaseTitle] = 0x00a7b4,[CaseUpper] = 0x00a7b4,[CaseFold] = 0x00a7b5}, NULL},
	{0x00a7b6, {[CaseLower] = 0x00a7b7,[CaseTitle] = 0x00a7b6,[CaseUpper] = 0x00a7b6,[CaseFold] = 0x00a7b7}, NULL},
	{0x00a7b7, {[CaseLower] = 0x00a7b7,[CaseTitle] = 0x00a7b6,[CaseUpper] = 0x00a7b6,[CaseFold] = 0x00a7b7}, NULL},
	{0x00a7b8, {[CaseLower] = 0x00a7b9,[CaseTitle] = 0x00a7b8,[CaseUpper] = 0x00a7b8,[CaseFold] = 0x00a7b9}, NULL},
	{0x00a7b9, {[CaseLower] = 0x00a7b9,[CaseTitle] = 0x00a7b8,[CaseUpper] = 0x00a7b8,[CaseFold] = 0x00a7b9}, NULL},
	{0x00a7ba, {[CaseLower] = 0x00a7bb,[CaseTitle] = 0x00a7ba,[CaseUpper] = 0x00a7ba,[CaseFold] = 0x00a7bb}, NULL},
	{0x00a7bb, {[CaseLower] = 0x00a7bb,[CaseTitle] = 0x00a7ba,[CaseUpper] = 0x00a7ba,[CaseFold] = 0x00a7bb}, NULL},
	{0x00a7bc, {[CaseLower] = 0x00a7bd,[CaseTitle] = 0x00a7bc,[CaseUpper] = 0x00a7bc,[CaseFold] = 0x00a7bd}, NULL},
	{0x00a7bd, {[CaseLower] = 0x00a7bd,[CaseTitle] = 0x00a7bc,[CaseUpper] = 0x00a7bc,[CaseFold] = 0x00a7bd}, NULL},
	{0x00a7be, {[CaseLower] = 0x00a7bf,[CaseTitle] = 0x00a7be,[CaseUpper] = 0x00a7be,[CaseFold] = 0x00a7bf}, NULL},
	{0x00a7bf, {[CaseLower] = 0x00a7bf,[CaseTitle] = 0x00a7be,[CaseUpper] = 0x00a7be,[CaseFold] = 0x00a7bf}, NULL},
	{0x00a7c0, {[CaseLower] = 0x00a7c1,[CaseTitle] = 0x00a7c0,[CaseUpper] = 0x00a7c0,[CaseFold] = 0x00a7c1}, NULL},
	{0x00a7c1, {[CaseLower] = 0x00a7c1,[CaseTitle] = 0x00a7c0,[CaseUpper] = 0x00a7c0,[CaseFold] = 0x00a7c1}, NULL},
	{0x00a7c2, {[CaseLower] = 0x00a7c3,[CaseTitle] = 0x00a7c2,[CaseUpper] = 0x00a7c2,[CaseFold] = 0x00a7c3}, NULL},
	{0x00a7c3, {[CaseLower] = 0x00a7c3,[CaseTitle] = 0x00a7c2,[CaseUpper] = 0x00a7c2,[CaseFold] = 0x00a7c3}, NULL},
	{0x00a7c4, {[CaseLower] = 0x00a794,[CaseTitle] = 0x00a7c4,[CaseUpper] = 0x00a7c4,[CaseFold] = 0x00a794}, NULL},
	{0x00a7c5, {[CaseLower] = 0x000282,[CaseTitle] = 0x00a7c5,[CaseUpper] = 0x00a7c5,[CaseFold] = 0x000282}, NULL},
	{0x00a7c6, {[CaseLower] = 0x001d8e,[CaseTitle] = 0x00a7c6,[CaseUpper] = 0x00a7c6,[CaseFold] = 0x001d8e}, NULL},
	{0x00a7c7, {[CaseLower] = 0x00a7c8,[CaseTitle] = 0x00a7c7,[CaseUpper] = 0x00a7c7,[CaseFold] = 0x00a7c8}, NULL},
	{0x00a7c8, {[CaseLower] = 0x00a7c8,[CaseTitle] = 0x00a7c7,[CaseUpper] = 0x00a7c7,[CaseFold] = 0x00a7c8}, NULL},
	{0x00a7c9, {[CaseLower] = 0x00a7ca,[CaseTitle] = 0x00a7c9,[CaseUpper] = 0x00a7c9,[CaseFold] = 0x00a7ca}, NULL},
	{0x00a7ca, {[CaseLower] = 0x00a7ca,[CaseTitle] = 0x00a7c9,[CaseUpper] = 0x00a7c9,[CaseFold] = 0x00a7ca}, NULL},
	{0x00a7d0, {[CaseLower] = 0x00a7d1,[CaseTitle] = 0x00a7d0,[CaseUpper] = 0x00a7d0,[CaseFold] = 0x00a7d1}, NULL},
	{0x00a7d1, {[CaseLower] = 0x00a7d1,[CaseTitle] = 0x00a7d0,[CaseUpper] = 0x00a7d0,[CaseFold] = 0x00a7d1}, NULL},
	{0x00a7d6, {[CaseLower] = 0x00a7d7,[CaseTitle] = 0x00a7d6,[CaseUpper] = 0x00a7d6,[CaseFold] = 0x00a7d7}, NULL},
	{0x00a7d7, {[CaseLower] = 0x00a7d7,[CaseTitle] = 0x00a7d6,[CaseUpper] = 0x00a7d6,[CaseFold] = 0x00a7d7}, NULL},
	{0x00a7d8, {[CaseLower] = 0x00a7d9,[CaseTitle] = 0x00a7d8,[CaseUpper] = 0x00a7d8,[CaseFold] = 0x00a7d9}, NULL},
	{0x00a7d9, {[CaseLower] = 0x00a7d9,[CaseTitle] = 0x00a7d8,[CaseUpper] = 0x00a7d8,[CaseFold] = 0x00a7d9}, NULL},
	{0x00a7f5, {[CaseLower] = 0x00a7f6,[CaseTitle] = 0x00a7f5,[CaseUpper] = 0x00a7f5,[CaseFold] = 0x00a7f6}, NULL},
	{0x00a7f6, {[CaseLower] = 0x00a7f6,[CaseTitle] = 0x00a7f5,[CaseUpper] = 0x00a7f5,[CaseFold] = 0x00a7f6}, NULL},
	{0x00ab53, {[CaseLower] = 0x00ab53,[CaseTitle] = 0x00a7b3,[CaseUpper] = 0x00a7b3,[CaseFold] = 0x00ab53}, NULL},
	{0x00ab70, {[CaseLower] = 0x00ab70,[CaseTitle] = 0x0013a0,[CaseUpper] = 0x0013a0,[CaseFold] = 0x0013a0}, NULL},
	{0x00ab71, {[CaseLower] = 0x00ab71,[CaseTitle] = 0x0013a1,[CaseUpper] = 0x0013a1,[CaseFold] = 0x0013a1}, NULL},
	{0x00ab72, {[CaseLower] = 0x00ab72,[CaseTitle] = 0x0013a2,[CaseUpper] = 0x0013a2,[CaseFold] = 0x0013a2}, NULL},
	{0x00ab73, {[CaseLower] = 0x00ab73,[CaseTitle] = 0x0013a3,[CaseUpper] = 0x0013a3,[CaseFold] = 0x0013a3}, NULL},
	{0x00ab74, {[CaseLower] = 0x00ab74,[CaseTitle] = 0x0013a4,[CaseUpper] = 0x0013a4,[CaseFold] = 0x0013a4}, NULL},
	{0x00ab75, {[CaseLower] = 0x00ab75,[CaseTitle] = 0x0013a5,[CaseUpper] = 0x0013a5,[CaseFold] = 0x0013a5}, NULL},
	{0x00ab76, {[CaseLower] = 0x00ab76,[CaseTitle] = 0x0013a6,[CaseUpper] = 0x0013a6,[CaseFold] = 0x0013a6}, NULL},
	{0x00ab77, {[CaseLower] = 0x00ab77,[CaseTitle] = 0x0013a7,[CaseUpper] = 0x0013a7,[CaseFold] = 0x0013a7}, NULL},
	{0x00ab78, {[CaseLower] = 0x00ab78,[CaseTitle] = 0x0013a8,[CaseUpper] = 0x0013a8,[CaseFold] = 0x0013a8}, NULL},
	{0x00ab79, {[CaseLower] = 0x00ab79,[CaseTitle] = 0x0013a9,[CaseUpper] = 0x0013a9,[CaseFold] = 0x0013a9}, NULL},
	{0x00ab7a, {[CaseLower] = 0x00ab7a,[CaseTitle] = 0x0013aa,[CaseUpper] = 0x0013aa,[CaseFold] = 0x0013aa}, NULL},
	{0x00ab7b, {[CaseLower] = 0x00ab7b,[CaseTitle] = 0x0013ab,[CaseUpper] = 0x0013ab,[CaseFold] = 0x0013ab}, NULL},
	{0x00ab7c, {[CaseLower] = 0x00ab7c,[CaseTitle] = 0x0013ac,[CaseUpper] = 0x0013ac,[CaseFold] = 0x0013ac}, NULL},
	{0x00ab7d, {[CaseLower] = 0x00ab7d,[CaseTitle] = 0x0013ad,[CaseUpper] = 0x0013ad,[CaseFold] = 0x0013ad}, NULL},
	{0x00ab7e, {[CaseLower] = 0x00ab7e,[CaseTitle] = 0x0013ae,[CaseUpper] = 0x0013ae,[CaseFold] = 0x0013ae}, NULL},
	{0x00ab7f, {[CaseLower] = 0x00ab7f,[CaseTitle] = 0x0013af,[CaseUpper] = 0x0013af,[CaseFold] = 0x0013af}, NULL},
	{0x00ab80, {[CaseLower] = 0x00ab80,[CaseTitle] = 0x0013b0,[CaseUpper] = 0x0013b0,[CaseFold] = 0x0013b0}, NULL},
	{0x00ab81, {[CaseLower] = 0x00ab81,[CaseTitle] = 0x0013b1,[CaseUpper] = 0x0013b1,[CaseFold] = 0x0013b1}, NULL},
	{0x00ab82, {[CaseLower] = 0x00ab82,[CaseTitle] = 0x0013b2,[CaseUpper] = 0x0013b2,[CaseFold] = 0x0013b2}, NULL},
	{0x00ab83, {[CaseLower] = 0x00ab83,[CaseTitle] = 0x0013b3,[CaseUpper] = 0x0013b3,[CaseFold] = 0x0013b3}, NULL},
	{0x00ab84, {[CaseLower] = 0x00ab84,[CaseTitle] = 0x0013b4,[CaseUpper] = 0x0013b4,[CaseFold] = 0x0013b4}, NULL},
	{0x00ab85, {[CaseLower] = 0x00ab85,[CaseTitle] = 0x0013b5,[CaseUpper] = 0x0013b5,[CaseFold] = 0x0013b5}, NULL},
	{0x00ab86, {[CaseLower] = 0x00ab86,[CaseTitle] = 0x0013b6,[CaseUpper] = 0x0013b6,[CaseFold] = 0x0013b6}, NULL},
	{0x00ab87, {[CaseLower] = 0x00ab87,[CaseTitle] = 0x0013b7,[CaseUpper] = 0x0013b7,[CaseFold] = 0x0013b7}, NULL},
	{0x00ab88, {[CaseLower] = 0x00ab88,[CaseTitle] = 0x0013b8,[CaseUpper] = 0x0013b8,[CaseFold] = 0x0013b8}, NULL},
	{0x00ab89, {[CaseLower] = 0x00ab89,[CaseTitle] = 0x0013b9,[CaseUpper] = 0x0013b9,[CaseFold] = 0x0013b9}, NULL},
	{0x00ab8a, {[CaseLower] = 0x00ab8a,[CaseTitle] = 0x0013ba,[CaseUpper] = 0x0013ba,[CaseFold] = 0x0013ba}, NULL},
	{0x00ab8b, {[CaseLower] = 0x00ab8b,[CaseTitle] = 0x0013bb,[CaseUpper] = 0x0013bb,[CaseFold] = 0x0013bb}, NULL},
	{0x00ab8c, {[CaseLower] = 0x00ab8c,[CaseTitle] = 0x0013bc,[CaseUpper] = 0x0013bc,[CaseFold] = 0x0013bc}, NULL},
	{0x00ab8d, {[CaseLower] = 0x00ab8d,[CaseTitle] = 0x0013bd,[CaseUpper] = 0x0013bd,[CaseFold] = 0x0013bd}, NULL},
	{0x00ab8e, {[CaseLower] = 0x00ab8e,[CaseTitle] = 0x0013be,[CaseUpper] = 0x0013be,[CaseFold] = 0x0013be}, NULL},
	{0x00ab8f, {[CaseLower] = 0x00ab8f,[CaseTitle] = 0x0013bf,[CaseUpper] = 0x0013bf,[CaseFold] = 0x0013bf}, NULL},
	{0x00ab90, {[CaseLower] = 0x00ab90,[CaseTitle] = 0x0013c0,[CaseUpper] = 0x0013c0,[CaseFold] = 0x0013c0}, NULL},
	{0x00ab91, {[CaseLower] = 0x00ab91,[CaseTitle] = 0x0013c1,[CaseUpper] = 0x0013c1,[CaseFold] = 0x0013c1}, NULL},
	{0x00ab92, {[CaseLower] = 0x00ab92,[CaseTitle] = 0x0013c2,[CaseUpper] = 0x0013c2,[CaseFold] = 0x0013c2}, NULL},
	{0x00ab93, {[CaseLower] = 0x00ab93,[CaseTitle] = 0x0013c3,[CaseUpper] = 0x0013c3,[CaseFold] = 0x0013c3}, NULL},
	{0x00ab94, {[CaseLower] = 0x00ab94,[CaseTitle] = 0x0013c4,[CaseUpper] = 0x0013c4,[CaseFold] = 0x0013c4}, NULL},
	{0x00ab95, {[CaseLower] = 0x00ab95,[CaseTitle] = 0x0013c5,[CaseUpper] = 0x0013c5,[CaseFold] = 0x0013c5}, NULL},
	{0x00ab96, {[CaseLower] = 0x00ab96,[CaseTitle] = 0x0013c6,[CaseUpper] = 0x0013c6,[CaseFold] = 0x0013c6}, NULL},
	{0x00ab97, {[CaseLower] = 0x00ab97,[CaseTitle] = 0x0013c7,[CaseUpper] = 0x0013c7,[CaseFold] = 0x0013c7}, NULL},
	{0x00ab98, {[CaseLower] = 0x00ab98,[CaseTitle] = 0x0013c8,[CaseUpper] = 0x0013c8,[CaseFold] = 0x0013c8}, NULL},
	{0x00ab99, {[CaseLower] = 0x00ab99,[CaseTitle] = 0x0013c9,[CaseUpper] = 0x0013c9,[CaseFold] = 0x0013c9}, NULL},
	{0x00ab9a, {[CaseLower] = 0x00ab9a,[CaseTitle] = 0x0013ca,[CaseUpper] = 0x0013ca,[CaseFold] = 0x0013ca}, NULL},
	{0x00ab9b, {[CaseLower] = 0x00ab9b,[CaseTitle] = 0x0013cb,[CaseUpper] = 0x0013cb,[CaseFold] = 0x0013cb}, NULL},
	{0x00ab9c, {[CaseLower] = 0x00ab9c,[CaseTitle] = 0x0013cc,[CaseUpper] = 0x0013cc,[CaseFold] = 0x0013cc}, NULL},
	{0x00ab9d, {[CaseLower] = 0x00ab9d,[CaseTitle] = 0x0013cd,[CaseUpper] = 0x0013cd,[CaseFold] = 0x0013cd}, NULL},
	{0x00ab9e, {[CaseLower] = 0x00ab9e,[CaseTitle] = 0x0013ce,[CaseUpper] = 0x0013ce,[CaseFold] = 0x0013ce}, NULL},
	{0x00ab9f, {[CaseLower] = 0x00ab9f,[CaseTitle] = 0x0013cf,[CaseUpper] = 0x0013cf,[CaseFold] = 0x0013cf}, NULL},
	{0x00aba0, {[CaseLower] = 0x00aba0,[CaseTitle] = 0x0013d0,[CaseUpper] = 0x0013d0,[CaseFold] = 0x0013d0}, NULL},
	{0x00aba1, {[CaseLower] = 0x00aba1,[CaseTitle] = 0x0013d1,[CaseUpper] = 0x0013d1,[CaseFold] = 0x0013d1}, NULL},
	{0x00aba2, {[CaseLower] = 0x00aba2,[CaseTitle] = 0x0013d2,[CaseUpper] = 0x0013d2,[CaseFold] = 0x0013d2}, NULL},
	{0x00aba3, {[CaseLower] = 0x00aba3,[CaseTitle] = 0x0013d3,[CaseUpper] = 0x0013d3,[CaseFold] = 0x0013d3}, NULL},
	{0x00aba4, {[CaseLower] = 0x00aba4,[CaseTitle] = 0x0013d4,[CaseUpper] = 0x0013d4,[CaseFold] = 0x0013d4}, NULL},
	{0x00aba5, {[CaseLower] = 0x00aba5,[CaseTitle] = 0x0013d5,[CaseUpper] = 0x0013d5,[CaseFold] = 0x0013d5}, NULL},
	{0x00aba6, {[CaseLower] = 0x00aba6,[CaseTitle] = 0x0013d6,[CaseUpper] = 0x0013d6,[CaseFold] = 0x0013d6}, NULL},
	{0x00aba7, {[CaseLower] = 0x00aba7,[CaseTitle] = 0x0013d7,[CaseUpper] = 0x0013d7,[CaseFold] = 0x0013d7}, NULL},
	{0x00aba8, {[CaseLower] = 0x00aba8,[CaseTitle] = 0x0013d8,[CaseUpper] = 0x0013d8,[CaseFold] = 0x0013d8}, NULL},
	{0x00aba9, {[CaseLower] = 0x00aba9,[CaseTitle] = 0x0013d9,[CaseUpper] = 0x0013d9,[CaseFold] = 0x0013d9}, NULL},
	{0x00abaa, {[CaseLower] = 0x00abaa,[CaseTitle] = 0x0013da,[CaseUpper] = 0x0013da,[CaseFold] = 0x0013da}, NULL},
	{0x00abab, {[CaseLower] = 0x00abab,[CaseTitle] = 0x0013db,[CaseUpper] = 0x0013db,[CaseFold] = 0x0013db}, NULL},
	{0x00abac, {[CaseLower] = 0x00abac,[CaseTitle] = 0x0013dc,[CaseUpper] = 0x0013dc,[CaseFold] = 0x0013dc}, NULL},
	{0x00abad, {[CaseLower] = 0x00abad,[CaseTitle] = 0x0013dd,[CaseUpper] = 0x0013dd,[CaseFold] = 0x0013dd}, NULL},
	{0x00abae, {[CaseLower] = 0x00abae,[CaseTitle] = 0x0013de,[CaseUpper] = 0x0013de,[CaseFold] = 0x0013de}, NULL},
	{0x00abaf, {[CaseLower] = 0x00abaf,[CaseTitle] = 0x0013df,[CaseUpper] = 0x0013df,[CaseFold] = 0x0013df}, NULL},
	{0x00abb0, {[CaseLower] = 0x00abb0,[CaseTitle] = 0x0013e0,[CaseUpper] = 0x0013e0,[CaseFold] = 0x0013e0}, NULL},
	{0x00abb1, {[CaseLower] = 0x00abb1,[CaseTitle] = 0x0013e1,[CaseUpper] = 0x0013e1,[CaseFold] = 0x0013e1}, NULL},
	{0x00abb2, {[CaseLower] = 0x00abb2,[CaseTitle] = 0x0013e2,[CaseUpper] = 0x0013e2,[CaseFold] = 0x0013e2}, NULL},
	{0x00abb3, {[CaseLower] = 0x00abb3,[CaseTitle] = 0x0013e3,[CaseUpper] = 0x0013e3,[CaseFold] = 0x0013e3}, NULL},
	{0x00abb4, {[CaseLower] = 0x00abb4,[CaseTitle] = 0x0013e4,[CaseUpper] = 0x0013e4,[CaseFold] = 0x0013e4}, NULL},
	{0x00abb5, {[CaseLower] = 0x00abb5,[CaseTitle] = 0x0013e5,[CaseUpper] = 0x0013e5,[CaseFold] = 0x0013e5}, NULL},
	{0x00abb6, {[CaseLower] = 0x00abb6,[CaseTitle] = 0x0013e6,[CaseUpper] = 0x0013e6,[CaseFold] = 0x0013e6}, NULL},
	{0x00abb7, {[CaseLower] = 0x00abb7,[CaseTitle] = 0x0013e7,[CaseUpper] = 0x0013e7,[CaseFold] = 0x0013e7}, NULL},
	{0x00abb8, {[CaseLower] = 0x00abb8,[CaseTitle] = 0x0013e8,[CaseUpper] = 0x0013e8,[CaseFold] = 0x0013e8}, NULL},
	{0x00abb9, {[CaseLower] = 0x00abb9,[CaseTitle] = 0x0013e9,[CaseUpper] = 0x0013e9,[CaseFold] = 0x0013e9}, NULL},
	{0x00abba, {[CaseLower] = 0x00abba,[CaseTitle] = 0x0013ea,[CaseUpper] = 0x0013ea,[CaseFold] = 0x0013ea}, NULL},
	{0x00abbb, {[CaseLower] = 0x00abbb,[CaseTitle] = 0x0013eb,[CaseUpper] = 0x0013eb,[CaseFold] = 0x0013eb}, NULL},
	{0x00abbc, {[CaseLower] = 0x00abbc,[CaseTitle] = 0x0013ec,[CaseUpper] = 0x0013ec,[CaseFold] = 0x0013ec}, NULL},
	{0x00abbd, {[CaseLower] = 0x00abbd,[CaseTitle] = 0x0013ed,[CaseUpper] = 0x0013ed,[CaseFold] = 0x0013ed}, NULL},
	{0x00abbe, {[CaseLower] = 0x00abbe,[CaseTitle] = 0x0013ee,[CaseUpper] = 0x0013ee,[CaseFold] = 0x0013ee}, NULL},
	{0x00abbf, {[CaseLower] = 0x00abbf,[CaseTitle] = 0x0013ef,[CaseUpper] = 0x0013ef,[CaseFold] = 0x0013ef}, NULL},
	{0x00fb00, {[CaseLower] = 0x00fb00,[CaseTitle] = 0x00fb00,[CaseUpper] = 0x00fb00,[CaseFold] = 0x00fb00}, &special_case[93]},
	{0x00fb01, {[CaseLower] = 0x00fb01,[CaseTitle] = 0x00fb01,[CaseUpper] = 0x00fb01,[CaseFold] = 0x00fb01}, &special_case[94]},
	{0x00fb02, {[CaseLower] = 0x00fb02,[CaseTitle] = 0x00fb02,[CaseUpper] = 0x00fb02,[CaseFold] = 0x00fb02}, &special_case[95]},
	{0x00fb03, {[CaseLower] = 0x00fb03,[CaseTitle] = 0x00fb03,[CaseUpper] = 0x00fb03,[CaseFold] = 0x00fb03}, &special_case[96]},
	{0x00fb04, {[CaseLower] = 0x00fb04,[CaseTitle] = 0x00fb04,[CaseUpper] = 0x00fb04,[CaseFold] = 0x00fb04}, &special_case[97]},
	{0x00fb05, {[CaseLower] = 0x00fb05,[CaseTitle] = 0x00fb05,[CaseUpper] = 0x00fb05,[CaseFold] = 0x00fb06}, &special_case[98]},
	{0x00fb06, {[CaseLower] = 0x00fb06,[CaseTitle] = 0x00fb06,[CaseUpper] = 0x00fb06,[CaseFold] = 0x00fb06}, &special_case[99]},
	{0x00fb13, {[CaseLower] = 0x00fb13,[CaseTitle] = 0x00fb13,[CaseUpper] = 0x00fb13,[CaseFold] = 0x00fb13}, &special_case[100]},
	{0x00fb14, {[CaseLower] = 0x00fb14,[CaseTitle] = 0x00fb14,[CaseUpper] = 0x00fb14,[CaseFold] = 0x00fb14}, &special_case[101]},
	{0x00fb15, {[CaseLower] = 0x00fb15,[CaseTitle] = 0x00fb15,[CaseUpper] = 0x00fb15,[CaseFold] = 0x00fb15}, &special_case[102]},
	{0x00fb16, {[CaseLower] = 0x00fb16,[CaseTitle] = 0x00fb16,[CaseUpper] = 0x00fb16,[CaseFold] = 0x00fb16}, &special_case[103]},
	{0x00fb17, {[CaseLower] = 0x00fb17,[CaseTitle] = 0x00fb17,[CaseUpper] = 0x00fb17,[CaseFold] = 0x00fb17}, &special_case[104]},
	{0x00ff21, {[CaseLower] = 0x00ff41,[CaseTitle] = 0x00ff21,[CaseUpper] = 0x00ff21,[CaseFold] = 0x00ff41}, NULL},
	{0x00ff22, {[CaseLower] = 0x00ff42,[CaseTitle] = 0x00ff22,[CaseUpper] = 0x00ff22,[CaseFold] = 0x00ff42}, NULL},
	{0x00ff23, {[CaseLower] = 0x00ff43,[CaseTitle] = 0x00ff23,[CaseUpper] = 0x00ff23,[CaseFold] = 0x00ff43}, NULL},
	{0x00ff24, {[CaseLower] = 0x00ff44,[CaseTitle] = 0x00ff24,[CaseUpper] = 0x00ff24,[CaseFold] = 0x00ff44}, NULL},
	{0x00ff25, {[CaseLower] = 0x00ff45,[CaseTitle] = 0x00ff25,[CaseUpper] = 0x00ff25,[CaseFold] = 0x00ff45}, NULL},
	{0x00ff26, {[CaseLower] = 0x00ff46,[CaseTitle] = 0x00ff26,[CaseUpper] = 0x00ff26,[CaseFold] = 0x00ff46}, NULL},
	{0x00ff27, {[CaseLower] = 0x00ff47,[CaseTitle] = 0x00ff27,[CaseUpper] = 0x00ff27,[CaseFold] = 0x00ff47}, NULL},
	{0x00ff28, {[CaseLower] = 0x00ff48,[CaseTitle] = 0x00ff28,[CaseUpper] = 0x00ff28,[CaseFold] = 0x00ff48}, NULL},
	{0x00ff29, {[CaseLower] = 0x00ff49,[CaseTitle] = 0x00ff29,[CaseUpper] = 0x00ff29,[CaseFold] = 0x00ff49}, NULL},
	{0x00ff2a, {[CaseLower] = 0x00ff4a,[CaseTitle] = 0x00ff2a,[CaseUpper] = 0x00ff2a,[CaseFold] = 0x00ff4a}, NULL},
	{0x00ff2b, {[CaseLower] = 0x00ff4b,[CaseTitle] = 0x00ff2b,[CaseUpper] = 0x00ff2b,[CaseFold] = 0x00ff4b}, NULL},
	{0x00ff2c, {[CaseLower] = 0x00ff4c,[CaseTitle] = 0x00ff2c,[CaseUpper] = 0x00ff2c,[CaseFold] = 0x00ff4c}, NULL},
	{0x00ff2d, {[CaseLower] = 0x00ff4d,[CaseTitle] = 0x00ff2d,[CaseUpper] = 0x00ff2d,[CaseFold] = 0x00ff4d}, NULL},
	{0x00ff2e, {[CaseLower] = 0x00ff4e,[CaseTitle] = 0x00ff2e,[CaseUpper] = 0x00ff2e,[CaseFold] = 0x00ff4e}, NULL},
	{0x00ff2f, {[CaseLower] = 0x00ff4f,[CaseTitle] = 0x00ff2f,[CaseUpper] = 0x00ff2f,[CaseFold] = 0x00ff4f}, NULL},
	{0x00ff30, {[CaseLower] = 0x00ff50,[CaseTitle] = 0x00ff30,[CaseUpper] = 0x00ff30,[CaseFold] = 0x00ff50}, NULL},
	{0x00ff31, {[CaseLower] = 0x00ff51,[CaseTitle] = 0x00ff31,[CaseUpper] = 0x00ff31,[CaseFold] = 0x00ff51}, NULL},
	{0x00ff32, {[CaseLower] = 0x00ff52,[CaseTitle] = 0x00ff32,[CaseUpper] = 0x00ff32,[CaseFold] = 0x00ff52}, NULL},
	{0x00ff33, {[CaseLower] = 0x00ff53,[CaseTitle] = 0x00ff33,[CaseUpper] = 0x00ff33,[CaseFold] = 0x00ff53}, NULL},
	{0x00ff34, {[CaseLower] = 0x00ff54,[CaseTitle] = 0x00ff34,[CaseUpper] = 0x00ff34,[CaseFold] = 0x00ff54}, NULL},
	{0x00ff35, {[CaseLower] = 0x00ff55,[CaseTitle] = 0x00ff35,[CaseUpper] = 0x00ff35,[CaseFold] = 0x00ff55}, NULL},
	{0x00ff36, {[CaseLower] = 0x00ff56,[CaseTitle] = 0x00ff36,[CaseUpper] = 0x00ff36,[CaseFold] = 0x00ff56}, NULL},
	{0x00ff37, {[CaseLower] = 0x00ff57,[CaseTitle] = 0x00ff37,[CaseUpper] = 0x00ff37,[CaseFold] = 0x00ff57}, NULL},
	{0x00ff38, {[CaseLower] = 0x00ff58,[CaseTitle] = 0x00ff38,[CaseUpper] = 0x00ff38,[CaseFold] = 0x00ff58}, NULL},
	{0x00ff39, {[CaseLower] = 0x00ff59,[CaseTitle] = 0x00ff39,[CaseUpper] = 0x00ff39,[CaseFold] = 0x00ff59}, NULL},
	{0x00ff3a, {[CaseLower] = 0x00ff5a,[CaseTitle] = 0x00ff3a,[CaseUpper] = 0x00ff3a,[CaseFold] = 0x00ff5a}, NULL},
	{0x00ff41, {[CaseLower] = 0x00ff41,[CaseTitle] = 0x00ff21,[CaseUpper] = 0x00ff21,[CaseFold] = 0x00ff41}, NULL},
	{0x00ff42, {[CaseLower] = 0x00ff42,[CaseTitle] = 0x00ff22,[CaseUpper] = 0x00ff22,[CaseFold] = 0x00ff42}, NULL},
	{0x00ff43, {[CaseLower] = 0x00ff43,[CaseTitle] = 0x00ff23,[CaseUpper] = 0x00ff23,[CaseFold] = 0x00ff43}, NULL},
	{0x00ff44, {[CaseLower] = 0x00ff44,[CaseTitle] = 0x00ff24,[CaseUpper] = 0x00ff24,[CaseFold] = 0x00ff44}, NULL},
	{0x00ff45, {[CaseLower] = 0x00ff45,[CaseTitle] = 0x00ff25,[CaseUpper] = 0x00ff25,[CaseFold] = 0x00ff45}, NULL},
	{0x00ff46, {[CaseLower] = 0x00ff46,[CaseTitle] = 0x00ff26,[CaseUpper] = 0x00ff26,[CaseFold] = 0x00ff46}, NULL},
	{0x00ff47, {[CaseLower] = 0x00ff47,[CaseTitle] = 0x00ff27,[CaseUpper] = 0x00ff27,[CaseFold] = 0x00ff47}, NULL},
	{0x00ff48, {[CaseLower] = 0x00ff48,[CaseTitle] = 0x00ff28,[CaseUpper] = 0x00ff28,[CaseFold] = 0x00ff48}, NULL},
	{0x00ff49, {[CaseLower] = 0x00ff49,[CaseTitle] = 0x00ff29,[CaseUpper] = 0x00ff29,[CaseFold] = 0x00ff49}, NULL},
	{0x00ff4a, {[CaseLower] = 0x00ff4a,[CaseTitle] = 0x00ff2a,[CaseUpper] = 0x00ff2a,[CaseFold] = 0x00ff4a}, NULL},
	{0x00ff4b, {[CaseLower] = 0x00ff4b,[CaseTitle] = 0x00ff2b,[CaseUpper] = 0x00ff2b,[CaseFold] = 0x00ff4b}, NULL},
	{0x00ff4c, {[CaseLower] = 0x00ff4c,[CaseTitle] = 0x00ff2c,[CaseUpper] = 0x00ff2c,[CaseFold] = 0x00ff4c}, NULL},
	{0x00ff4d, {[CaseLower] = 0x00ff4d,[CaseTitle] = 0x00ff2d,[CaseUpper] = 0x00ff2d,[CaseFold] = 0x00ff4d}, NULL},
	{0x00ff4e, {[CaseLower] = 0x00ff4e,[CaseTitle] = 0x00ff2e,[CaseUpper] = 0x00ff2e,[CaseFold] = 0x00ff4e}, NULL},
	{0x00ff4f, {[CaseLower] = 0x00ff4f,[CaseTitle] = 0x00ff2f,[CaseUpper] = 0x00ff2f,[CaseFold] = 0x00ff4f}, NULL},
	{0x00ff50, {[CaseLower] = 0x00ff50,[CaseTitle] = 0x00ff30,[CaseUpper] = 0x00ff30,[CaseFold] = 0x00ff50}, NULL},
	{0x00ff51, {[CaseLower] = 0x00ff51,[CaseTitle] = 0x00ff31,[CaseUpper] = 0x00ff31,[CaseFold] = 0x00ff51}, NULL},
	{0x00ff52, {[CaseLower] = 0x00ff52,[CaseTitle] = 0x00ff32,[CaseUpper] = 0x00ff32,[CaseFold] = 0x00ff52}, NULL},
	{0x00ff53, {[CaseLower] = 0x00ff53,[CaseTitle] = 0x00ff33,[CaseUpper] = 0x00ff33,[CaseFold] = 0x00ff53}, NULL},
	{0x00ff54, {[CaseLower] = 0x00ff54,[CaseTitle] = 0x00ff34,[CaseUpper] = 0x00ff34,[CaseFold] = 0x00ff54}, NULL},
	{0x00ff55, {[CaseLower] = 0x00ff55,[CaseTitle] = 0x00ff35,[CaseUpper] = 0x00ff35,[CaseFold] = 0x00ff55}, NULL},
	{0x00ff56, {[CaseLower] = 0x00ff56,[CaseTitle] = 0x00ff36,[CaseUpper] = 0x00ff36,[CaseFold] = 0x00ff56}, NULL},
	{0x00ff57, {[CaseLower] = 0x00ff57,[CaseTitle] = 0x00ff37,[CaseUpper] = 0x00ff37,[CaseFold] = 0x00ff57}, NULL},
	{0x00ff58, {[CaseLower] = 0x00ff58,[CaseTitle] = 0x00ff38,[CaseUpper] = 0x00ff38,[CaseFold] = 0x00ff58}, NULL},
	{0x00ff59, {[CaseLower] = 0x00ff59,[CaseTitle] = 0x00ff39,[CaseUpper] = 0x00ff39,[CaseFold] = 0x00ff59}, NULL},
	{0x00ff5a, {[CaseLower] = 0x00ff5a,[CaseTitle] = 0x00ff3a,[CaseUpper] = 0x00ff3a,[CaseFold] = 0x00ff5a}, NULL},
	{0x010400, {[CaseLower] = 0x010428,[CaseTitle] = 0x010400,[CaseUpper] = 0x010400,[CaseFold] = 0x010428}, NULL},
	{0x010401, {[CaseLower] = 0x010429,[CaseTitle] = 0x010401,[CaseUpper] = 0x010401,[CaseFold] = 0x010429}, NULL},
	{0x010402, {[CaseLower] = 0x01042a,[CaseTitle] = 0x010402,[CaseUpper] = 0x010402,[CaseFold] = 0x01042a}, NULL},
	{0x010403, {[CaseLower] = 0x01042b,[CaseTitle] = 0x010403,[CaseUpper] = 0x010403,[CaseFold] = 0x01042b}, NULL},
	{0x010404, {[CaseLower] = 0x01042c,[CaseTitle] = 0x010404,[CaseUpper] = 0x010404,[CaseFold] = 0x01042c}, NULL},
	{0x010405, {[CaseLower] = 0x01042d,[CaseTitle] = 0x010405,[CaseUpper] = 0x010405,[CaseFold] = 0x01042d}, NULL},
	{0x010406, {[CaseLower] = 0x01042e,[CaseTitle] = 0x010406,[CaseUpper] = 0x010406,[CaseFold] = 0x01042e}, NULL},
	{0x010407, {[CaseLower] = 0x01042f,[CaseTitle] = 0x010407,[CaseUpper] = 0x010407,[CaseFold] = 0x01042f}, NULL},
	{0x010408, {[CaseLower] = 0x010430,[CaseTitle] = 0x010408,[CaseUpper] = 0x010408,[CaseFold] = 0x010430}, NULL},
	{0x010409, {[CaseLower] = 0x010431,[CaseTitle] = 0x010409,[CaseUpper] = 0x010409,[CaseFold] = 0x010431}, NULL},
	{0x01040a, {[CaseLower] = 0x010432,[CaseTitle] = 0x01040a,[CaseUpper] = 0x01040a,[CaseFold] = 0x010432}, NULL},
	{0x01040b, {[CaseLower] = 0x010433,[CaseTitle] = 0x01040b,[CaseUpper] = 0x01040b,[CaseFold] = 0x010433}, NULL},
	{0x01040c, {[CaseLower] = 0x010434,[CaseTitle] = 0x01040c,[CaseUpper] = 0x01040c,[CaseFold] = 0x010434}, NULL},
	{0x01040d, {[CaseLower] = 0x010435,[CaseTitle] = 0x01040d,[CaseUpper] = 0x01040d,[CaseFold] = 0x010435}, NULL},
	{0x01040e, {[CaseLower] = 0x010436,[CaseTitle] = 0x01040e,[CaseUpper] = 0x01040e,[CaseFold] = 0x010436}, NULL},
	{0x01040f, {[CaseLower] = 0x010437,[CaseTitle] = 0x01040f,[CaseUpper] = 0x01040f,[CaseFold] = 0x010437}, NULL},
	{0x010410, {[CaseLower] = 0x010438,[CaseTitle] = 0x010410,[CaseUpper] = 0x010410,[CaseFold] = 0x010438}, NULL},
	{0x010411, {[CaseLower] = 0x010439,[CaseTitle] = 0x010411,[CaseUpper] = 0x010411,[CaseFold] = 0x010439}, NULL},
	{0x010412, {[CaseLower] = 0x01043a,[CaseTitle] = 0x010412,[CaseUpper] = 0x010412,[CaseFold] = 0x01043a}, NULL},
	{0x010413, {[CaseLower] = 0x01043b,[CaseTitle] = 0x010413,[CaseUpper] = 0x010413,[CaseFold] = 0x01043b}, NULL},
	{0x010414, {[CaseLower] = 0x01043c,[CaseTitle] = 0x010414,[CaseUpper] = 0x010414,[CaseFold] = 0x01043c}, NULL},
	{0x010415, {[CaseLower] = 0x01043d,[CaseTitle] = 0x010415,[CaseUpper] = 0x010415,[CaseFold] = 0x01043d}, NULL},
	{0x010416, {[CaseLower] = 0x01043e,[CaseTitle] = 0x010416,[CaseUpper] = 0x010416,[CaseFold] = 0x01043e}, NULL},
	{0x010417, {[CaseLower] = 0x01043f,[CaseTitle] = 0x010417,[CaseUpper] = 0x010417,[CaseFold] = 0x01043f}, NULL},
	{0x010418, {[CaseLower] = 0x010440,[CaseTitle] = 0x010418,[CaseUpper] = 0x010418,[CaseFold] = 0x010440}, NULL},
	{0x010419, {[CaseLower] = 0x010441,[CaseTitle] = 0x010419,[CaseUpper] = 0x010419,[CaseFold] = 0x010441}, NULL},
	{0x01041a, {[CaseLower] = 0x010442,[CaseTitle] = 0x01041a,[CaseUpper] = 0x01041a,[CaseFold] = 0x010442}, NULL},
	{0x01041b, {[CaseLower] = 0x010443,[CaseTitle] = 0x01041b,[CaseUpper] = 0x01041b,[CaseFold] = 0x010443}, NULL},
	{0x01041c, {[CaseLower] = 0x010444,[CaseTitle] = 0x01041c,[CaseUpper] = 0x01041c,[CaseFold] = 0x010444}, NULL},
	{0x01041d, {[CaseLower] = 0x010445,[CaseTitle] = 0x01041d,[CaseUpper] = 0x01041d,[CaseFold] = 0x010445}, NULL},
	{0x01041e, {[CaseLower] = 0x010446,[CaseTitle] = 0x01041e,[CaseUpper] = 0x01041e,[CaseFold] = 0x010446}, NULL},
	{0x01041f, {[CaseLower] = 0x010447,[CaseTitle] = 0x01041f,[CaseUpper] = 0x01041f,[CaseFold] = 0x010447}, NULL},
	{0x010420, {[CaseLower] = 0x010448,[CaseTitle] = 0x010420,[CaseUpper] = 0x010420,[CaseFold] = 0x010448}, NULL},
	{0x010421, {[CaseLower] = 0x010449,[CaseTitle] = 0x010421,[CaseUpper] = 0x010421,[CaseFold] = 0x010449}, NULL},
	{0x010422, {[CaseLower] = 0x01044a,[CaseTitle] = 0x010422,[CaseUpper] = 0x010422,[CaseFold] = 0x01044a}, NULL},
	{0x010423, {[CaseLower] = 0x01044b,[CaseTitle] = 0x010423,[CaseUpper] = 0x010423,[CaseFold] = 0x01044b}, NULL},
	{0x010424, {[CaseLower] = 0x01044c,[CaseTitle] = 0x010424,[CaseUpper] = 0x010424,[CaseFold] = 0x01044c}, NULL},
	{0x010425, {[CaseLower] = 0x01044d,[CaseTitle] = 0x010425,[CaseUpper] = 0x010425,[CaseFold] = 0x01044d}, NULL},
	{0x010426, {[CaseLower] = 0x01044e,[CaseTitle] = 0x010426,[CaseUpper] = 0x010426,[CaseFold] = 0x01044e}, NULL},
	{0x010427, {[CaseLower] = 0x01044f,[CaseTitle] = 0x010427,[CaseUpper] = 0x010427,[CaseFold] = 0x01044f}, NULL},
	{0x010428, {[CaseLower] = 0x010428,[CaseTitle] = 0x010400,[CaseUpper] = 0x010400,[CaseFold] = 0x010428}, NULL},
	{0x010429, {[CaseLower] = 0x010429,[CaseTitle] = 0x010401,[CaseUpper] = 0x010401,[CaseFold] = 0x010429}, NULL},
	{0x01042a, {[CaseLower] = 0x01042a,[CaseTitle] = 0x010402,[CaseUpper] = 0x010402,[CaseFold] = 0x01042a}, NULL},
	{0x01042b, {[CaseLower] = 0x01042b,[CaseTitle] = 0x010403,[CaseUpper] = 0x010403,[CaseFold] = 0x01042b}, NULL},
	{0x01042c, {[CaseLower] = 0x01042c,[CaseTitle] = 0x010404,[CaseUpper] = 0x010404,[CaseFold] = 0x01042c}, NULL},
	{0x01042d, {[CaseLower] = 0x01042d,[CaseTitle] = 0x010405,[CaseUpper] = 0x010405,[CaseFold] = 0x01042d}, NULL},
	{0x01042e, {[CaseLower] = 0x01042e,[CaseTitle] = 0x010406,[CaseUpper] = 0x010406,[CaseFold] = 0x01042e}, NULL},
	{0x01042f, {[CaseLower] = 0x01042f,[CaseTitle] = 0x010407,[CaseUpper] = 0x010407,[CaseFold] = 0x01042f}, NULL},
	{0x010430, {[CaseLower] = 0x010430,[CaseTitle] = 0x010408,[CaseUpper] = 0x010408,[CaseFold] = 0x010430}, NULL},
	{0x010431, {[CaseLower] = 0x010431,[CaseTitle] = 0x010409,[CaseUpper] = 0x010409,[CaseFold] = 0x010431}, NULL},
	{0x010432, {[CaseLower] = 0x010432,[CaseTitle] = 0x01040a,[CaseUpper] = 0x01040a,[CaseFold] = 0x010432}, NULL},
	{0x010433, {[CaseLower] = 0x010433,[CaseTitle] = 0x01040b,[CaseUpper] = 0x01040b,[CaseFold] = 0x010433}, NULL},
	{0x010434, {[CaseLower] = 0x010434,[CaseTitle] = 0x01040c,[CaseUpper] = 0x01040c,[CaseFold] = 0x010434}, NULL},
	{0x010435, {[CaseLower] = 0x010435,[CaseTitle] = 0x01040d,[CaseUpper] = 0x01040d,[CaseFold] = 0x010435}, NULL},
	{0x010436, {[CaseLower] = 0x010436,[CaseTitle] = 0x01040e,[CaseUpper] = 0x01040e,[CaseFold] = 0x010436}, NULL},
	{0x010437, {[CaseLower] = 0x010437,[CaseTitle] = 0x01040f,[CaseUpper] = 0x01040f,[CaseFold] = 0x010437}, NULL},
	{0x010438, {[CaseLower] = 0x010438,[CaseTitle] = 0x010410,[CaseUpper] = 0x010410,[CaseFold] = 0x010438}, NULL},
	{0x010439, {[CaseLower] = 0x010439,[CaseTitle] = 0x010411,[CaseUpper] = 0x010411,[CaseFold] = 0x010439}, NULL},
	{0x01043a, {[CaseLower] = 0x01043a,[CaseTitle] = 0x010412,[CaseUpper] = 0x010412,[CaseFold] = 0x01043a}, NULL},
	{0x01043b, {[CaseLower] = 0x01043b,[CaseTitle] = 0x010413,[CaseUpper] = 0x010413,[CaseFold] = 0x01043b}, NULL},
	{0x01043c, {[CaseLower] = 0x01043c,[CaseTitle] = 0x010414,[CaseUpper] = 0x010414,[CaseFold] = 0x01043c}, NULL},
	{0x01043d, {[CaseLower] = 0x01043d,[CaseTitle] = 0x010415,[CaseUpper] = 0x010415,[CaseFold] = 0x01043d}, NULL},
	{0x01043e, {[CaseLower] = 0x01043e,[CaseTitle] = 0x010416,[CaseUpper] = 0x010416,[CaseFold] = 0x01043e}, NULL},
	{0x01043f, {[CaseLower] = 0x01043f,[CaseTitle] = 0x010417,[CaseUpper] = 0x010417,[CaseFold] = 0x01043f}, NULL},
	{0x010440, {[CaseLower] = 0x010440,[CaseTitle] = 0x010418,[CaseUpper] = 0x010418,[CaseFold] = 0x010440}, NULL},
	{0x010441, {[CaseLower] = 0x010441,[CaseTitle] = 0x010419,[CaseUpper] = 0x010419,[CaseFold] = 0x010441}, NULL},
	{0x010442, {[CaseLower] = 0x010442,[CaseTitle] = 0x01041a,[CaseUpper] = 0x01041a,[CaseFold] = 0x010442}, NULL},
	{0x010443, {[CaseLower] = 0x010443,[CaseTitle] = 0x01041b,[CaseUpper] = 0x01041b,[CaseFold] = 0x010443}, NULL},
	{0x010444, {[CaseLower] = 0x010444,[CaseTitle] = 0x01041c,[CaseUpper] = 0x01041c,[CaseFold] = 0x010444}, NULL},
	{0x010445, {[CaseLower] = 0x010445,[CaseTitle] = 0x01041d,[CaseUpper] = 0x01041d,[CaseFold] = 0x010445}, NULL},
	{0x010446, {[CaseLower] = 0x010446,[CaseTitle] = 0x01041e,[CaseUpper] = 0x01041e,[CaseFold] = 0x010446}, NULL},
	{0x010447, {[CaseLower] = 0x010447,[CaseTitle] = 0x01041f,[CaseUpper] = 0x01041f,[CaseFold] = 0x010447}, NULL},
	{0x010448, {[CaseLower] = 0x010448,[CaseTitle] = 0x010420,[CaseUpper] = 0x010420,[CaseFold] = 0x010448}, NULL},
	{0x010449, {[CaseLower] = 0x010449,[CaseTitle] = 0x010421,[CaseUpper] = 0x010421,[CaseFold] = 0x010449}, NULL},
	{0x01044a, {[CaseLower] = 0x01044a,[CaseTitle] = 0x010422,[CaseUpper] = 0x010422,[CaseFold] = 0x01044a}, NULL},
	{0x01044b, {[CaseLower] = 0x01044b,[CaseTitle] = 0x010423,[CaseUpper] = 0x010423,[CaseFold] = 0x01044b}, NULL},
	{0x01044c, {[CaseLower] = 0x01044c,[CaseTitle] = 0x010424,[CaseUpper] = 0x010424,[CaseFold] = 0x01044c}, NULL},
	{0x01044d, {[CaseLower] = 0x01044d,[CaseTitle] = 0x010425,[CaseUpper] = 0x010425,[CaseFold] = 0x01044d}, NULL},
	{0x01044e, {[CaseLower] = 0x01044e,[CaseTitle] = 0x010426,[CaseUpper] = 0x010426,[CaseFold] = 0x01044e}, NULL},
	{0x01044f, {[CaseLower] = 0x01044f,[CaseTitle] = 0x010427,[CaseUpper] = 0x010427,[CaseFold] = 0x01044f}, NULL},
	{0x0104b0, {[CaseLower] = 0x0104d8,[CaseTitle] = 0x0104b0,[CaseUpper] = 0x0104b0,[CaseFold] = 0x0104d8}, NULL},
	{0x0104b1, {[CaseLower] = 0x0104d9,[CaseTitle] = 0x0104b1,[CaseUpper] = 0x0104b1,[CaseFold] = 0x0104d9}, NULL},
	{0x0104b2, {[CaseLower] = 0x0104da,[CaseTitle] = 0x0104b2,[CaseUpper] = 0x0104b2,[CaseFold] = 0x0104da}, NULL},
	{0x0104b3, {[CaseLower] = 0x0104db,[CaseTitle] = 0x0104b3,[CaseUpper] = 0x0104b3,[CaseFold] = 0x0104db}, NULL},
	{0x0104b4, {[CaseLower] = 0x0104dc,[CaseTitle] = 0x0104b4,[CaseUpper] = 0x0104b4,[CaseFold] = 0x0104dc}, NULL},
	{0x0104b5, {[CaseLower] = 0x0104dd,[CaseTitle] = 0x0104b5,[CaseUpper] = 0x0104b5,[CaseFold] = 0x0104dd}, NULL},
	{0x0104b6, {[CaseLower] = 0x0104de,[CaseTitle] = 0x0104b6,[CaseUpper] = 0x0104b6,[CaseFold] = 0x0104de}, NULL},
	{0x0104b7, {[CaseLower] = 0x0104df,[CaseTitle] = 0x0104b7,[CaseUpper] = 0x0104b7,[CaseFold] = 0x0104df}, NULL},
	{0x0104b8, {[CaseLower] = 0x0104e0,[CaseTitle] = 0x0104b8,[CaseUpper] = 0x0104b8,[CaseFold] = 0x0104e0}, NULL},
	{0x0104b9, {[CaseLower] = 0x0104e1,[CaseTitle] = 0x0104b9,[CaseUpper] = 0x0104b9,[CaseFold] = 0x0104e1}, NULL},
	{0x0104ba, {[CaseLower] = 0x0104e2,[CaseTitle] = 0x0104ba,[CaseUpper] = 0x0104ba,[CaseFold] = 0x0104e2}, NULL},
	{0x0104bb, {[CaseLower] = 0x0104e3,[CaseTitle] = 0x0104bb,[CaseUpper] = 0x0104bb,[CaseFold] = 0x0104e3}, NULL},
	{0x0104bc, {[CaseLower] = 0x0104e4,[CaseTitle] = 0x0104bc,[CaseUpper] = 0x0104bc,[CaseFold] = 0x0104e4}, NULL},
	{0x0104bd, {[CaseLower] = 0x0104e5,[CaseTitle] = 0x0104bd,[CaseUpper] = 0x0104bd,[CaseFold] = 0x0104e5}, NULL},
	{0x0104be, {[CaseLower] = 0x0104e6,[CaseTitle] = 0x0104be,[CaseUpper] = 0x0104be,[CaseFold] = 0x0104e6}, NULL},
	{0x0104bf, {[CaseLower] = 0x0104e7,[CaseTitle] = 0x0104bf,[CaseUpper] = 0x0104bf,[CaseFold] = 0x0104e7}, NULL},
	{0x0104c0, {[CaseLower] = 0x0104e8,[CaseTitle] = 0x0104c0,[CaseUpper] = 0x0104c0,[CaseFold] = 0x0104e8}, NULL},
	{0x0104c1, {[CaseLower] = 0x0104e9,[CaseTitle] = 0x0104c1,[CaseUpper] = 0x0104c1,[CaseFold] = 0x0104e9}, NULL},
	{0x0104c2, {[CaseLower] = 0x0104ea,[CaseTitle] = 0x0104c2,[CaseUpper] = 0x0104c2,[CaseFold] = 0x0104ea}, NULL},
	{0x0104c3, {[CaseLower] = 0x0104eb,[CaseTitle] = 0x0104c3,[CaseUpper] = 0x0104c3,[CaseFold] = 0x0104eb}, NULL},
	{0x0104c4, {[CaseLower] = 0x0104ec,[CaseTitle] = 0x0104c4,[CaseUpper] = 0x0104c4,[CaseFold] = 0x0104ec}, NULL},
	{0x0104c5, {[CaseLower] = 0x0104ed,[CaseTitle] = 0x0104c5,[CaseUpper] = 0x0104c5,[CaseFold] = 0x0104ed}, NULL},
	{0x0104c6, {[CaseLower] = 0x0104ee,[CaseTitle] = 0x0104c6,[CaseUpper] = 0x0104c6,[CaseFold] = 0x0104ee}, NULL},
	{0x0104c7, {[CaseLower] = 0x0104ef,[CaseTitle] = 0x0104c7,[CaseUpper] = 0x0104c7,[CaseFold] = 0x0104ef}, NULL},
	{0x0104c8, {[CaseLower] = 0x0104f0,[CaseTitle] = 0x0104c8,[CaseUpper] = 0x0104c8,[CaseFold] = 0x0104f0}, NULL},
	{0x0104c9, {[CaseLower] = 0x0104f1,[CaseTitle] = 0x0104c9,[CaseUpper] = 0x0104c9,[CaseFold] = 0x0104f1}, NULL},
	{0x0104ca, {[CaseLower] = 0x0104f2,[CaseTitle] = 0x0104ca,[CaseUpper] = 0x0104ca,[CaseFold] = 0x0104f2}, NULL},
	{0x0104cb, {[CaseLower] = 0x0104f3,[CaseTitle] = 0x0104cb,[CaseUpper] = 0x0104cb,[CaseFold] = 0x0104f3}, NULL},
	{0x0104cc, {[CaseLower] = 0x0104f4,[CaseTitle] = 0x0104cc,[CaseUpper] = 0x0104cc,[CaseFold] = 0x0104f4}, NULL},
	{0x0104cd, {[CaseLower] = 0x0104f5,[CaseTitle] = 0x0104cd,[CaseUpper] = 0x0104cd,[CaseFold] = 0x0104f5}, NULL},
	{0x0104ce, {[CaseLower] = 0x0104f6,[CaseTitle] = 0x0104ce,[CaseUpper] = 0x0104ce,[CaseFold] = 0x0104f6}, NULL},
	{0x0104cf, {[CaseLower] = 0x0104f7,[CaseTitle] = 0x0104cf,[CaseUpper] = 0x0104cf,[CaseFold] = 0x0104f7}, NULL},
	{0x0104d0, {[CaseLower] = 0x0104f8,[CaseTitle] = 0x0104d0,[CaseUpper] = 0x0104d0,[CaseFold] = 0x0104f8}, NULL},
	{0x0104d1, {[CaseLower] = 0x0104f9,[CaseTitle] = 0x0104d1,[CaseUpper] = 0x0104d1,[CaseFold] = 0x0104f9}, NULL},
	{0x0104d2, {[CaseLower] = 0x0104fa,[CaseTitle] = 0x0104d2,[CaseUpper] = 0x0104d2,[CaseFold] = 0x0104fa}, NULL},
	{0x0104d3, {[CaseLower] = 0x0104fb,[CaseTitle] = 0x0104d3,[CaseUpper] = 0x0104d3,[CaseFold] = 0x0104fb}, NULL},
	{0x0104d8, {[CaseLower] = 0x0104d8,[CaseTitle] = 0x0104b0,[CaseUpper] = 0x0104b0,[CaseFold] = 0x0104d8}, NULL},
	{0x0104d9, {[CaseLower] = 0x0104d9,[CaseTitle] = 0x0104b1,[CaseUpper] = 0x0104b1,[CaseFold] = 0x0104d9}, NULL},
	{0x0104da, {[CaseLower] = 0x0104da,[CaseTitle] = 0x0104b2,[CaseUpper] = 0x0104b2,[CaseFold] = 0x0104da}, NULL},
	{0x0104db, {[CaseLower] = 0x0104db,[CaseTitle] = 0x0104b3,[CaseUpper] = 0x0104b3,[CaseFold] = 0x0104db}, NULL},
	{0x0104dc, {[CaseLower] = 0x0104dc,[CaseTitle] = 0x0104b4,[CaseUpper] = 0x0104b4,[CaseFold] = 0x0104dc}, NULL},
	{0x0104dd, {[CaseLower] = 0x0104dd,[CaseTitle] = 0x0104b5,[CaseUpper] = 0x0104b5,[CaseFold] = 0x0104dd}, NULL},
	{0x0104de, {[CaseLower] = 0x0104de,[CaseTitle] = 0x0104b6,[CaseUpper] = 0x0104b6,[CaseFold] = 0x0104de}, NULL},
	{0x0104df, {[CaseLower] = 0x0104df,[CaseTitle] = 0x0104b7,[CaseUpper] = 0x0104b7,[CaseFold] = 0x0104df}, NULL},
	{0x0104e0, {[CaseLower] = 0x0104e0,[CaseTitle] = 0x0104b8,[CaseUpper] = 0x0104b8,[CaseFold] = 0x0104e0}, NULL},
	{0x0104e1, {[CaseLower] = 0x0104e1,[CaseTitle] = 0x0104b9,[CaseUpper] = 0x0104b9,[CaseFold] = 0x0104e1}, NULL},
	{0x0104e2, {[CaseLower] = 0x0104e2,[CaseTitle] = 0x0104ba,[CaseUpper] = 0x0104ba,[CaseFold] = 0x0104e2}, NULL},
	{0x0104e3, {[CaseLower] = 0x0104e3,[CaseTitle] = 0x0104bb,[CaseUpper] = 0x0104bb,[CaseFold] = 0x0104e3}, NULL},
	{0x0104e4, {[CaseLower] = 0x0104e4,[CaseTitle] = 0x0104bc,[CaseUpper] = 0x0104bc,[CaseFold] = 0x0104e4}, NULL},
	{0x0104e5, {[CaseLower] = 0x0104e5,[CaseTitle] = 0x0104bd,[CaseUpper] = 0x0104bd,[CaseFold] = 0x0104e5}, NULL},
	{0x0104e6, {[CaseLower] = 0x0104e6,[CaseTitle] = 0x0104be,[CaseUpper] = 0x0104be,[CaseFold] = 0x0104e6}, NULL},
	{0x0104e7, {[CaseLower] = 0x0104e7,[CaseTitle] = 0x0104bf,[CaseUpper] = 0x0104bf,[CaseFold] = 0x0104e7}, NULL},
	{0x0104e8, {[CaseLower] = 0x0104e8,[CaseTitle] = 0x0104c0,[CaseUpper] = 0x0104c0,[CaseFold] = 0x0104e8}, NULL},
	{0x0104e9, {[CaseLower] = 0x0104e9,[CaseTitle] = 0x0104c1,[CaseUpper] = 0x0104c1,[CaseFold] = 0x0104e9}, NULL},
	{0x0104ea, {[CaseLower] = 0x0104ea,[CaseTitle] = 0x0104c2,[CaseUpper] = 0x0104c2,[CaseFold] = 0x0104ea}, NULL},
	{0x0104eb, {[CaseLower] = 0x0104eb,[CaseTitle] = 0x0104c3,[CaseUpper] = 0x0104c3,[CaseFold] = 0x0104eb}, NULL},
	{0x0104ec, {[CaseLower] = 0x0104ec,[CaseTitle] = 0x0104c4,[CaseUpper] = 0x0104c4,[CaseFold] = 0x0104ec}, NULL},
	{0x0104ed, {[CaseLower] = 0x0104ed,[CaseTitle] = 0x0104c5,[CaseUpper] = 0x0104c5,[CaseFold] = 0x0104ed}, NULL},
	{0x0104ee, {[CaseLower] = 0x0104ee,[CaseTitle] = 0x0104c6,[CaseUpper] = 0x0104c6,[CaseFold] = 0x0104ee}, NULL},
	{0x0104ef, {[CaseLower] = 0x0104ef,[CaseTitle] = 0x0104c7,[CaseUpper] = 0x0104c7,[CaseFold] = 0x0104ef}, NULL},
	{0x0104f0, {[CaseLower] = 0x0104f0,[CaseTitle] = 0x0104c8,[CaseUpper] = 0x0104c8,[CaseFold] = 0x0104f0}, NULL},
	{0x0104f1, {[CaseLower] = 0x0104f1,[CaseTitle] = 0x0104c9,[CaseUpper] = 0x0104c9,[CaseFold] = 0x0104f1}, NULL},
	{0x0104f2, {[CaseLower] = 0x0104f2,[CaseTitle] = 0x0104ca,[CaseUpper] = 0x0104ca,[CaseFold] = 0x0104f2}, NULL},
	{0x0104f3, {[CaseLower] = 0x0104f3,[CaseTitle] = 0x0104cb,[CaseUpper] = 0x0104cb,[CaseFold] = 0x0104f3}, NULL},
	{0x0104f4, {[CaseLower] = 0x0104f4,[CaseTitle] = 0x0104cc,[CaseUpper] = 0x0104cc,[CaseFold] = 0x0104f4}, NULL},
	{0x0104f5, {[CaseLower] = 0x0104f5,[CaseTitle] = 0x0104cd,[CaseUpper] = 0x0104cd,[CaseFold] = 0x0104f5}, NULL},
	{0x0104f6, {[CaseLower] = 0x0104f6,[CaseTitle] = 0x0104ce,[CaseUpper] = 0x0104ce,[CaseFold] = 0x0104f6}, NULL},
	{0x0104f7, {[CaseLower] = 0x0104f7,[CaseTitle] = 0x0104cf,[CaseUpper] = 0x0104cf,[CaseFold] = 0x0104f7}, NULL},
	{0x0104f8, {[CaseLower] = 0x0104f8,[CaseTitle] = 0x0104d0,[CaseUpper] = 0x0104d0,[CaseFold] = 0x0104f8}, NULL},
	{0x0104f9, {[CaseLower] = 0x0104f9,[CaseTitle] = 0x0104d1,[CaseUpper] = 0x0104d1,[CaseFold] = 0x0104f9}, NULL},
	{0x0104fa, {[CaseLower] = 0x0104fa,[CaseTitle] = 0x0104d2,[CaseUpper] = 0x0104d2,[CaseFold] = 0x0104fa}, NULL},
	{0x0104fb, {[CaseLower] = 0x0104fb,[CaseTitle] = 0x0104d3,[CaseUpper] = 0x0104d3,[CaseFold] = 0x0104fb}, NULL},
	{0x010570, {[CaseLower] = 0x010597,[CaseTitle] = 0x010570,[CaseUpper] = 0x010570,[CaseFold] = 0x010597}, NULL},
	{0x010571, {[CaseLower] = 0x010598,[CaseTitle] = 0x010571,[CaseUpper] = 0x010571,[CaseFold] = 0x010598}, NULL},
	{0x010572, {[CaseLower] = 0x010599,[CaseTitle] = 0x010572,[CaseUpper] = 0x010572,[CaseFold] = 0x010599}, NULL},
	{0x010573, {[CaseLower] = 0x01059a,[CaseTitle] = 0x010573,[CaseUpper] = 0x010573,[CaseFold] = 0x01059a}, NULL},
	{0x010574, {[CaseLower] = 0x01059b,[CaseTitle] = 0x010574,[CaseUpper] = 0x010574,[CaseFold] = 0x01059b}, NULL},
	{0x010575, {[CaseLower] = 0x01059c,[CaseTitle] = 0x010575,[CaseUpper] = 0x010575,[CaseFold] = 0x01059c}, NULL},
	{0x010576, {[CaseLower] = 0x01059d,[CaseTitle] = 0x010576,[CaseUpper] = 0x010576,[CaseFold] = 0x01059d}, NULL},
	{0x010577, {[CaseLower] = 0x01059e,[CaseTitle] = 0x010577,[CaseUpper] = 0x010577,[CaseFold] = 0x01059e}, NULL},
	{0x010578, {[CaseLower] = 0x01059f,[CaseTitle] = 0x010578,[CaseUpper] = 0x010578,[CaseFold] = 0x01059f}, NULL},
	{0x010579, {[CaseLower] = 0x0105a0,[CaseTitle] = 0x010579,[CaseUpper] = 0x010579,[CaseFold] = 0x0105a0}, NULL},
	{0x01057a, {[CaseLower] = 0x0105a1,[CaseTitle] = 0x01057a,[CaseUpper] = 0x01057a,[CaseFold] = 0x0105a1}, NULL},
	{0x01057c, {[CaseLower] = 0x0105a3,[CaseTitle] = 0x01057c,[CaseUpper] = 0x01057c,[CaseFold] = 0x0105a3}, NULL},
	{0x01057d, {[CaseLower] = 0x0105a4,[CaseTitle] = 0x01057d,[CaseUpper] = 0x01057d,[CaseFold] = 0x0105a4}, NULL},
	{0x01057e, {[CaseLower] = 0x0105a5,[CaseTitle] = 0x01057e,[CaseUpper] = 0x01057e,[CaseFold] = 0x0105a5}, NULL},
	{0x01057f, {[CaseLower] = 0x0105a6,[CaseTitle] = 0x01057f,[CaseUpper] = 0x01057f,[CaseFold] = 0x0105a6}, NULL},
	{0x010580, {[CaseLower] = 0x0105a7,[CaseTitle] = 0x010580,[CaseUpper] = 0x010580,[CaseFold] = 0x0105a7}, NULL},
	{0x010581, {[CaseLower] = 0x0105a8,[CaseTitle] = 0x010581,[CaseUpper] = 0x010581,[CaseFold] = 0x0105a8}, NULL},
	{0x010582, {[CaseLower] = 0x0105a9,[CaseTitle] = 0x010582,[CaseUpper] = 0x010582,[CaseFold] = 0x0105a9}, NULL},
	{0x010583, {[CaseLower] = 0x0105aa,[CaseTitle] = 0x010583,[CaseUpper] = 0x010583,[CaseFold] = 0x0105aa}, NULL},
	{0x010584, {[CaseLower] = 0x0105ab,[CaseTitle] = 0x010584,[CaseUpper] = 0x010584,[CaseFold] = 0x0105ab}, NULL},
	{0x010585, {[CaseLower] = 0x0105ac,[CaseTitle] = 0x010585,[CaseUpper] = 0x010585,[CaseFold] = 0x0105ac}, NULL},
	{0x010586, {[CaseLower] = 0x0105ad,[CaseTitle] = 0x010586,[CaseUpper] = 0x010586,[CaseFold] = 0x0105ad}, NULL},
	{0x010587, {[CaseLower] = 0x0105ae,[CaseTitle] = 0x010587,[CaseUpper] = 0x010587,[CaseFold] = 0x0105ae}, NULL},
	{0x010588, {[CaseLower] = 0x0105af,[CaseTitle] = 0x010588,[CaseUpper] = 0x010588,[CaseFold] = 0x0105af}, NULL},
	{0x010589, {[CaseLower] = 0x0105b0,[CaseTitle] = 0x010589,[CaseUpper] = 0x010589,[CaseFold] = 0x0105b0}, NULL},
	{0x01058a, {[CaseLower] = 0x0105b1,[CaseTitle] = 0x01058a,[CaseUpper] = 0x01058a,[CaseFold] = 0x0105b1}, NULL},
	{0x01058c, {[CaseLower] = 0x0105b3,[CaseTitle] = 0x01058c,[CaseUpper] = 0x01058c,[CaseFold] = 0x0105b3}, NULL},
	{0x01058d, {[CaseLower] = 0x0105b4,[CaseTitle] = 0x01058d,[CaseUpper] = 0x01058d,[CaseFold] = 0x0105b4}, NULL},
	{0x01058e, {[CaseLower] = 0x0105b5,[CaseTitle] = 0x01058e,[CaseUpper] = 0x01058e,[CaseFold] = 0x0105b5}, NULL},
	{0x01058f, {[CaseLower] = 0x0105b6,[CaseTitle] = 0x01058f,[CaseUpper] = 0x01058f,[CaseFold] = 0x0105b6}, NULL},
	{0x010590, {[CaseLower] = 0x0105b7,[CaseTitle] = 0x010590,[CaseUpper] = 0x010590,[CaseFold] = 0x0105b7}, NULL},
	{0x010591, {[CaseLower] = 0x0105b8,[CaseTitle] = 0x010591,[CaseUpper] = 0x010591,[CaseFold] = 0x0105b8}, NULL},
	{0x010592, {[CaseLower] = 0x0105b9,[CaseTitle] = 0x010592,[CaseUpper] = 0x010592,[CaseFold] = 0x0105b9}, NULL},
	{0x010594, {[CaseLower] = 0x0105bb,[CaseTitle] = 0x010594,[CaseUpper] = 0x010594,[CaseFold] = 0x0105bb}, NULL},
	{0x010595, {[CaseLower] = 0x0105bc,[CaseTitle] = 0x010595,[CaseUpper] = 0x010595,[CaseFold] = 0x0105bc}, NULL},
	{0x010597, {[CaseLower] = 0x010597,[CaseTitle] = 0x010570,[CaseUpper] = 0x010570,[CaseFold] = 0x010597}, NULL},
	{0x010598, {[CaseLower] = 0x010598,[CaseTitle] = 0x010571,[CaseUpper] = 0x010571,[CaseFold] = 0x010598}, NULL},
	{0x010599, {[CaseLower] = 0x010599,[CaseTitle] = 0x010572,[CaseUpper] = 0x010572,[CaseFold] = 0x010599}, NULL},
	{0x01059a, {[CaseLower] = 0x01059a,[CaseTitle] = 0x010573,[CaseUpper] = 0x010573,[CaseFold] = 0x01059a}, NULL},
	{0x01059b, {[CaseLower] = 0x01059b,[CaseTitle] = 0x010574,[CaseUpper] = 0x010574,[CaseFold] = 0x01059b}, NULL},
	{0x01059c, {[CaseLower] = 0x01059c,[CaseTitle] = 0x010575,[CaseUpper] = 0x010575,[CaseFold] = 0x01059c}, NULL},
	{0x01059d, {[CaseLower] = 0x01059d,[CaseTitle] = 0x010576,[CaseUpper] = 0x010576,[CaseFold] = 0x01059d}, NULL},
	{0x01059e, {[CaseLower] = 0x01059e,[CaseTitle] = 0x010577,[CaseUpper] = 0x010577,[CaseFold] = 0x01059e}, NULL},
	{0x01059f, {[CaseLower] = 0x01059f,[CaseTitle] = 0x010578,[CaseUpper] = 0x010578,[CaseFold] = 0x01059f}, NULL},
	{0x0105a0, {[CaseLower] = 0x0105a0,[CaseTitle] = 0x010579,[CaseUpper] = 0x010579,[CaseFold] = 0x0105a0}, NULL},
	{0x0105a1, {[CaseLower] = 0x0105a1,[CaseTitle] = 0x01057a,[CaseUpper] = 0x01057a,[CaseFold] = 0x0105a1}, NULL},
	{0x0105a3, {[CaseLower] = 0x0105a3,[CaseTitle] = 0x01057c,[CaseUpper] = 0x01057c,[CaseFold] = 0x0105a3}, NULL},
	{0x0105a4, {[CaseLower] = 0x0105a4,[CaseTitle] = 0x01057d,[CaseUpper] = 0x01057d,[CaseFold] = 0x0105a4}, NULL},
	{0x0105a5, {[CaseLower] = 0x0105a5,[CaseTitle] = 0x01057e,[CaseUpper] = 0x01057e,[CaseFold] = 0x0105a5}, NULL},
	{0x0105a6, {[CaseLower] = 0x0105a6,[CaseTitle] = 0x01057f,[CaseUpper] = 0x01057f,[CaseFold] = 0x0105a6}, NULL},
	{0x0105a7, {[CaseLower] = 0x0105a7,[CaseTitle] = 0x010580,[CaseUpper] = 0x010580,[CaseFold] = 0x0105a7}, NULL},
	{0x0105a8, {[CaseLower] = 0x0105a8,[CaseTitle] = 0x010581,[CaseUpper] = 0x010581,[CaseFold] = 0x0105a8}, NULL},
	{0x0105a9, {[CaseLower] = 0x0105a9,[CaseTitle] = 0x010582,[CaseUpper] = 0x010582,[CaseFold] = 0x0105a9}, NULL},
	{0x0105aa, {[CaseLower] = 0x0105aa,[CaseTitle] = 0x010583,[CaseUpper] = 0x010583,[CaseFold] = 0x0105aa}, NULL},
	{0x0105ab, {[CaseLower] = 0x0105ab,[CaseTitle] = 0x010584,[CaseUpper] = 0x010584,[CaseFold] = 0x0105ab}, NULL},
	{0x0105ac, {[CaseLower] = 0x0105ac,[CaseTitle] = 0x010585,[CaseUpper] = 0x010585,[CaseFold] = 0x0105ac}, NULL},
	{0x0105ad, {[CaseLower] = 0x0105ad,[CaseTitle] = 0x010586,[CaseUpper] = 0x010586,[CaseFold] = 0x0105ad}, NULL},
	{0x0105ae, {[CaseLower] = 0x0105ae,[CaseTitle] = 0x010587,[CaseUpper] = 0x010587,[CaseFold] = 0x0105ae}, NULL},
	{0x0105af, {[CaseLower] = 0x0105af,[CaseTitle] = 0x010588,[CaseUpper] = 0x010588,[CaseFold] = 0x0105af}, NULL},
	{0x0105b0, {[CaseLower] = 0x0105b0,[CaseTitle] = 0x010589,[CaseUpper] = 0x010589,[CaseFold] = 0x0105b0}, NULL},
	{0x0105b1, {[CaseLower] = 0x0105b1,[CaseTitle] = 0x01058a,[CaseUpper] = 0x01058a,[CaseFold] = 0x0105b1}, NULL},
	{0x0105b3, {[CaseLower] = 0x0105b3,[CaseTitle] = 0x01058c,[CaseUpper] = 0x01058c,[CaseFold] = 0x0105b3}, NULL},
	{0x0105b4, {[CaseLower] = 0x0105b4,[CaseTitle] = 0x01058d,[CaseUpper] = 0x01058d,[CaseFold] = 0x0105b4}, NULL},
	{0x0105b5, {[CaseLower] = 0x0105b5,[CaseTitle] = 0x01058e,[CaseUpper] = 0x01058e,[CaseFold] = 0x0105b5}, NULL},
	{0x0105b6, {[CaseLower] = 0x0105b6,[CaseTitle] = 0x01058f,[CaseUpper] = 0x01058f,[CaseFold] = 0x0105b6}, NULL},
	{0x0105b7, {[CaseLower] = 0x0105b7,[CaseTitle] = 0x010590,[CaseUpper] = 0x010590,[CaseFold] = 0x0105b7}, NULL},
	{0x0105b8, {[CaseLower] = 0x0105b8,[CaseTitle] = 0x010591,[CaseUpper] = 0x010591,[CaseFold] = 0x0105b8}, NULL},
	{0x0105b9, {[CaseLower] = 0x0105b9,[CaseTitle] = 0x010592,[CaseUpper] = 0x010592,[CaseFold] = 0x0105b9}, NULL},
	{0x0105bb, {[CaseLower] = 0x0105bb,[CaseTitle] = 0x010594,[CaseUpper] = 0x010594,[CaseFold] = 0x0105bb}, NULL},
	{0x0105bc, {[CaseLower] = 0x0105bc,[CaseTitle] = 0x010595,[CaseUpper] = 0x010595,[CaseFold] = 0x0105bc}, NULL},
	{0x010c80, {[CaseLower] = 0x010cc0,[CaseTitle] = 0x010c80,[CaseUpper] = 0x010c80,[CaseFold] = 0x010cc0}, NULL},
	{0x010c81, {[CaseLower] = 0x010cc1,[CaseTitle] = 0x010c81,[CaseUpper] = 0x010c81,[CaseFold] = 0x010cc1}, NULL},
	{0x010c82, {[CaseLower] = 0x010cc2,[CaseTitle] = 0x010c82,[CaseUpper] = 0x010c82,[CaseFold] = 0x010cc2}, NULL},
	{0x010c83, {[CaseLower] = 0x010cc3,[CaseTitle] = 0x010c83,[CaseUpper] = 0x010c83,[CaseFold] = 0x010cc3}, NULL},
	{0x010c84, {[CaseLower] = 0x010cc4,[CaseTitle] = 0x010c84,[CaseUpper] = 0x010c84,[CaseFold] = 0x010cc4}, NULL},
	{0x010c85, {[CaseLower] = 0x010cc5,[CaseTitle] = 0x010c85,[CaseUpper] = 0x010c85,[CaseFold] = 0x010cc5}, NULL},
	{0x010c86, {[CaseLower] = 0x010cc6,[CaseTitle] = 0x010c86,[CaseUpper] = 0x010c86,[CaseFold] = 0x010cc6}, NULL},
	{0x010c87, {[CaseLower] = 0x010cc7,[CaseTitle] = 0x010c87,[CaseUpper] = 0x010c87,[CaseFold] = 0x010cc7}, NULL},
	{0x010c88, {[CaseLower] = 0x010cc8,[CaseTitle] = 0x010c88,[CaseUpper] = 0x010c88,[CaseFold] = 0x010cc8}, NULL},
	{0x010c89, {[CaseLower] = 0x010cc9,[CaseTitle] = 0x010c89,[CaseUpper] = 0x010c89,[CaseFold] = 0x010cc9}, NULL},
	{0x010c8a, {[CaseLower] = 0x010cca,[CaseTitle] = 0x010c8a,[CaseUpper] = 0x010c8a,[CaseFold] = 0x010cca}, NULL},
	{0x010c8b, {[CaseLower] = 0x010ccb,[CaseTitle] = 0x010c8b,[CaseUpper] = 0x010c8b,[CaseFold] = 0x010ccb}, NULL},
	{0x010c8c, {[CaseLower] = 0x010ccc,[CaseTitle] = 0x010c8c,[CaseUpper] = 0x010c8c,[CaseFold] = 0x010ccc}, NULL},
	{0x010c8d, {[CaseLower] = 0x010ccd,[CaseTitle] = 0x010c8d,[CaseUpper] = 0x010c8d,[CaseFold] = 0x010ccd}, NULL},
	{0x010c8e, {[CaseLower] = 0x010cce,[CaseTitle] = 0x010c8e,[CaseUpper] = 0x010c8e,[CaseFold] = 0x010cce}, NULL},
	{0x010c8f, {[CaseLower] = 0x010ccf,[CaseTitle] = 0x010c8f,[CaseUpper] = 0x010c8f,[CaseFold] = 0x010ccf}, NULL},
	{0x010c90, {[CaseLower] = 0x010cd0,[CaseTitle] = 0x010c90,[CaseUpper] = 0x010c90,[CaseFold] = 0x010cd0}, NULL},
	{0x010c91, {[CaseLower] = 0x010cd1,[CaseTitle] = 0x010c91,[CaseUpper] = 0x010c91,[CaseFold] = 0x010cd1}, NULL},
	{0x010c92, {[CaseLower] = 0x010cd2,[CaseTitle] = 0x010c92,[CaseUpper] = 0x010c92,[CaseFold] = 0x010cd2}, NULL},
	{0x010c93, {[CaseLower] = 0x010cd3,[CaseTitle] = 0x010c93,[CaseUpper] = 0x010c93,[CaseFold] = 0x010cd3}, NULL},
	{0x010c94, {[CaseLower] = 0x010cd4,[CaseTitle] = 0x010c94,[CaseUpper] = 0x010c94,[CaseFold] = 0x010cd4}, NULL},
	{0x010c95, {[CaseLower] = 0x010cd5,[CaseTitle] = 0x010c95,[CaseUpper] = 0x010c95,[CaseFold] = 0x010cd5}, NULL},
	{0x010c96, {[CaseLower] = 0x010cd6,[CaseTitle] = 0x010c96,[CaseUpper] = 0x010c96,[CaseFold] = 0x010cd6}, NULL},
	{0x010c97, {[CaseLower] = 0x010cd7,[CaseTitle] = 0x010c97,[CaseUpper] = 0x010c97,[CaseFold] = 0x010cd7}, NULL},
	{0x010c98, {[CaseLower] = 0x010cd8,[CaseTitle] = 0x010c98,[CaseUpper] = 0x010c98,[CaseFold] = 0x010cd8}, NULL},
	{0x010c99, {[CaseLower] = 0x010cd9,[CaseTitle] = 0x010c99,[CaseUpper] = 0x010c99,[CaseFold] = 0x010cd9}, NULL},
	{0x010c9a, {[CaseLower] = 0x010cda,[CaseTitle] = 0x010c9a,[CaseUpper] = 0x010c9a,[CaseFold] = 0x010cda}, NULL},
	{0x010c9b, {[CaseLower] = 0x010cdb,[CaseTitle] = 0x010c9b,[CaseUpper] = 0x010c9b,[CaseFold] = 0x010cdb}, NULL},
	{0x010c9c, {[CaseLower] = 0x010cdc,[CaseTitle] = 0x010c9c,[CaseUpper] = 0x010c9c,[CaseFold] = 0x010cdc}, NULL},
	{0x010c9d, {[CaseLower] = 0x010cdd,[CaseTitle] = 0x010c9d,[CaseUpper] = 0x010c9d,[CaseFold] = 0x010cdd}, NULL},
	{0x010c9e, {[CaseLower] = 0x010cde,[CaseTitle] = 0x010c9e,[CaseUpper] = 0x010c9e,[CaseFold] = 0x010cde}, NULL},
	{0x010c9f, {[CaseLower] = 0x010cdf,[CaseTitle] = 0x010c9f,[CaseUpper] = 0x010c9f,[CaseFold] = 0x010cdf}, NULL},
	{0x010ca0, {[CaseLower] = 0x010ce0,[CaseTitle] = 0x010ca0,[CaseUpper] = 0x010ca0,[CaseFold] = 0x010ce0}, NULL},
	{0x010ca1, {[CaseLower] = 0x010ce1,[CaseTitle] = 0x010ca1,[CaseUpper] = 0x010ca1,[CaseFold] = 0x010ce1}, NULL},
	{0x010ca2, {[CaseLower] = 0x010ce2,[CaseTitle] = 0x010ca2,[CaseUpper] = 0x010ca2,[CaseFold] = 0x010ce2}, NULL},
	{0x010ca3, {[CaseLower] = 0x010ce3,[CaseTitle] = 0x010ca3,[CaseUpper] = 0x010ca3,[CaseFold] = 0x010ce3}, NULL},
	{0x010ca4, {[CaseLower] = 0x010ce4,[CaseTitle] = 0x010ca4,[CaseUpper] = 0x010ca4,[CaseFold] = 0x010ce4}, NULL},
	{0x010ca5, {[CaseLower] = 0x010ce5,[CaseTitle] = 0x010ca5,[CaseUpper] = 0x010ca5,[CaseFold] = 0x010ce5}, NULL},
	{0x010ca6, {[CaseLower] = 0x010ce6,[CaseTitle] = 0x010ca6,[CaseUpper] = 0x010ca6,[CaseFold] = 0x010ce6}, NULL},
	{0x010ca7, {[CaseLower] = 0x010ce7,[CaseTitle] = 0x010ca7,[CaseUpper] = 0x010ca7,[CaseFold] = 0x010ce7}, NULL},
	{0x010ca8, {[CaseLower] = 0x010ce8,[CaseTitle] = 0x010ca8,[CaseUpper] = 0x010ca8,[CaseFold] = 0x010ce8}, NULL},
	{0x010ca9, {[CaseLower] = 0x010ce9,[CaseTitle] = 0x010ca9,[CaseUpper] = 0x010ca9,[CaseFold] = 0x010ce9}, NULL},
	{0x010caa, {[CaseLower] = 0x010cea,[CaseTitle] = 0x010caa,[CaseUpper] = 0x010caa,[CaseFold] = 0x010cea}, NULL},
	{0x010cab, {[CaseLower] = 0x010ceb,[CaseTitle] = 0x010cab,[CaseUpper] = 0x010cab,[CaseFold] = 0x010ceb}, NULL},
	{0x010cac, {[CaseLower] = 0x010cec,[CaseTitle] = 0x010cac,[CaseUpper] = 0x010cac,[CaseFold] = 0x010cec}, NULL},
	{0x010cad, {[CaseLower] = 0x010ced,[CaseTitle] = 0x010cad,[CaseUpper] = 0x010cad,[CaseFold] = 0x010ced}, NULL},
	{0x010cae, {[CaseLower] = 0x010cee,[CaseTitle] = 0x010cae,[CaseUpper] = 0x010cae,[CaseFold] = 0x010cee}, NULL},
	{0x010caf, {[CaseLower] = 0x010cef,[CaseTitle] = 0x010caf,[CaseUpper] = 0x010caf,[CaseFold] = 0x010cef}, NULL},
	{0x010cb0, {[CaseLower] = 0x010cf0,[CaseTitle] = 0x010cb0,[CaseUpper] = 0x010cb0,[CaseFold] = 0x010cf0}, NULL},
	{0x010cb1, {[CaseLower] = 0x010cf1,[CaseTitle] = 0x010cb1,[CaseUpper] = 0x010cb1,[CaseFold] = 0x010cf1}, NULL},
	{0x010cb2, {[CaseLower] = 0x010cf2,[CaseTitle] = 0x010cb2,[CaseUpper] = 0x010cb2,[CaseFold] = 0x010cf2}, NULL},
	{0x010cc0, {[CaseLower] = 0x010cc0,[CaseTitle] = 0x010c80,[CaseUpper] = 0x010c80,[CaseFold] = 0x010cc0}, NULL},
	{0x010cc1, {[CaseLower] = 0x010cc1,[CaseTitle] = 0x010c81,[CaseUpper] = 0x010c81,[CaseFold] = 0x010cc1}, NULL},
	{0x010cc2, {[CaseLower] = 0x010cc2,[CaseTitle] = 0x010c82,[CaseUpper] = 0x010c82,[CaseFold] = 0x010cc2}, NULL},
	{0x010cc3, {[CaseLower] = 0x010cc3,[CaseTitle] = 0x010c83,[CaseUpper] = 0x010c83,[CaseFold] = 0x010cc3}, NULL},
	{0x010cc4, {[CaseLower] = 0x010cc4,[CaseTitle] = 0x010c84,[CaseUpper] = 0x010c84,[CaseFold] = 0x010cc4}, NULL},
	{0x010cc5, {[CaseLower] = 0x010cc5,[CaseTitle] = 0x010c85,[CaseUpper] = 0x010c85,[CaseFold] = 0x010cc5}, NULL},
	{0x010cc6, {[CaseLower] = 0x010cc6,[CaseTitle] = 0x010c86,[CaseUpper] = 0x010c86,[CaseFold] = 0x010cc6}, NULL},
	{0x010cc7, {[CaseLower] = 0x010cc7,[CaseTitle] = 0x010c87,[CaseUpper] = 0x010c87,[CaseFold] = 0x010cc7}, NULL},
	{0x010cc8, {[CaseLower] = 0x010cc8,[CaseTitle] = 0x010c88,[CaseUpper] = 0x010c88,[CaseFold] = 0x010cc8}, NULL},
	{0x010cc9, {[CaseLower] = 0x010cc9,[CaseTitle] = 0x010c89,[CaseUpper] = 0x010c89,[CaseFold] = 0x010cc9}, NULL},
	{0x010cca, {[CaseLower] = 0x010cca,[CaseTitle] = 0x010c8a,[CaseUpper] = 0x010c8a,[CaseFold] = 0x010cca}, NULL},
	{0x010ccb, {[CaseLower] = 0x010ccb,[CaseTitle] = 0x010c8b,[CaseUpper] = 0x010c8b,[CaseFold] = 0x010ccb}, NULL},
	{0x010ccc, {[CaseLower] = 0x010ccc,[CaseTitle] = 0x010c8c,[CaseUpper] = 0x010c8c,[CaseFold] = 0x010ccc}, NULL},
	{0x010ccd, {[CaseLower] = 0x010ccd,[CaseTitle] = 0x010c8d,[CaseUpper] = 0x010c8d,[CaseFold] = 0x010ccd}, NULL},
	{0x010cce, {[CaseLower] = 0x010cce,[CaseTitle] = 0x010c8e,[CaseUpper] = 0x010c8e,[CaseFold] = 0x010cce}, NULL},
	{0x010ccf, {[CaseLower] = 0x010ccf,[CaseTitle] = 0x010c8f,[CaseUpper] = 0x010c8f,[CaseFold] = 0x010ccf}, NULL},
	{0x010cd0, {[CaseLower] = 0x010cd0,[CaseTitle] = 0x010c90,[CaseUpper] = 0x010c90,[CaseFold] = 0x010cd0}, NULL},
	{0x010cd1, {[CaseLower] = 0x010cd1,[CaseTitle] = 0x010c91,[CaseUpper] = 0x010c91,[CaseFold] = 0x010cd1}, NULL},
	{0x010cd2, {[CaseLower] = 0x010cd2,[CaseTitle] = 0x010c92,[CaseUpper] = 0x010c92,[CaseFold] = 0x010cd2}, NULL},
	{0x010cd3, {[CaseLower] = 0x010cd3,[CaseTitle] = 0x010c93,[CaseUpper] = 0x010c93,[CaseFold] = 0x010cd3}, NULL},
	{0x010cd4, {[CaseLower] = 0x010cd4,[CaseTitle] = 0x010c94,[CaseUpper] = 0x010c94,[CaseFold] = 0x010cd4}, NULL},
	{0x010cd5, {[CaseLower] = 0x010cd5,[CaseTitle] = 0x010c95,[CaseUpper] = 0x010c95,[CaseFold] = 0x010cd5}, NULL},
	{0x010cd6, {[CaseLower] = 0x010cd6,[CaseTitle] = 0x010c96,[CaseUpper] = 0x010c96,[CaseFold] = 0x010cd6}, NULL},
	{0x010cd7, {[CaseLower] = 0x010cd7,[CaseTitle] = 0x010c97,[CaseUpper] = 0x010c97,[CaseFold] = 0x010cd7}, NULL},
	{0x010cd8, {[CaseLower] = 0x010cd8,[CaseTitle] = 0x010c98,[CaseUpper] = 0x010c98,[CaseFold] = 0x010cd8}, NULL},
	{0x010cd9, {[CaseLower] = 0x010cd9,[CaseTitle] = 0x010c99,[CaseUpper] = 0x010c99,[CaseFold] = 0x010cd9}, NULL},
	{0x010cda, {[CaseLower] = 0x010cda,[CaseTitle] = 0x010c9a,[CaseUpper] = 0x010c9a,[CaseFold] = 0x010cda}, NULL},
	{0x010cdb, {[CaseLower] = 0x010cdb,[CaseTitle] = 0x010c9b,[CaseUpper] = 0x010c9b,[CaseFold] = 0x010cdb}, NULL},
	{0x010cdc, {[CaseLower] = 0x010cdc,[CaseTitle] = 0x010c9c,[CaseUpper] = 0x010c9c,[CaseFold] = 0x010cdc}, NULL},
	{0x010cdd, {[CaseLower] = 0x010cdd,[CaseTitle] = 0x010c9d,[CaseUpper] = 0x010c9d,[CaseFold] = 0x010cdd}, NULL},
	{0x010cde, {[CaseLower] = 0x010cde,[CaseTitle] = 0x010c9e,[CaseUpper] = 0x010c9e,[CaseFold] = 0x010cde}, NULL},
	{0x010cdf, {[CaseLower] = 0x010cdf,[CaseTitle] = 0x010c9f,[CaseUpper] = 0x010c9f,[CaseFold] = 0x010cdf}, NULL},
	{0x010ce0, {[CaseLower] = 0x010ce0,[CaseTitle] = 0x010ca0,[CaseUpper] = 0x010ca0,[CaseFold] = 0x010ce0}, NULL},
	{0x010ce1, {[CaseLower] = 0x010ce1,[CaseTitle] = 0x010ca1,[CaseUpper] = 0x010ca1,[CaseFold] = 0x010ce1}, NULL},
	{0x010ce2, {[CaseLower] = 0x010ce2,[CaseTitle] = 0x010ca2,[CaseUpper] = 0x010ca2,[CaseFold] = 0x010ce2}, NULL},
	{0x010ce3, {[CaseLower] = 0x010ce3,[CaseTitle] = 0x010ca3,[CaseUpper] = 0x010ca3,[CaseFold] = 0x010ce3}, NULL},
	{0x010ce4, {[CaseLower] = 0x010ce4,[CaseTitle] = 0x010ca4,[CaseUpper] = 0x010ca4,[CaseFold] = 0x010ce4}, NULL},
	{0x010ce5, {[CaseLower] = 0x010ce5,[CaseTitle] = 0x010ca5,[CaseUpper] = 0x010ca5,[CaseFold] = 0x010ce5}, NULL},
	{0x010ce6, {[CaseLower] = 0x010ce6,[CaseTitle] = 0x010ca6,[CaseUpper] = 0x010ca6,[CaseFold] = 0x010ce6}, NULL},
	{0x010ce7, {[CaseLower] = 0x010ce7,[CaseTitle] = 0x010ca7,[CaseUpper] = 0x010ca7,[CaseFold] = 0x010ce7}, NULL},
	{0x010ce8, {[CaseLower] = 0x010ce8,[CaseTitle] = 0x010ca8,[CaseUpper] = 0x010ca8,[CaseFold] = 0x010ce8}, NULL},
	{0x010ce9, {[CaseLower] = 0x010ce9,[CaseTitle] = 0x010ca9,[CaseUpper] = 0x010ca9,[CaseFold] = 0x010ce9}, NULL},
	{0x010cea, {[CaseLower] = 0x010cea,[CaseTitle] = 0x010caa,[CaseUpper] = 0x010caa,[CaseFold] = 0x010cea}, NULL},
	{0x010ceb, {[CaseLower] = 0x010ceb,[CaseTitle] = 0x010cab,[CaseUpper] = 0x010cab,[CaseFold] = 0x010ceb}, NULL},
	{0x010cec, {[CaseLower] = 0x010cec,[CaseTitle] = 0x010cac,[CaseUpper] = 0x010cac,[CaseFold] = 0x010cec}, NULL},
	{0x010ced, {[CaseLower] = 0x010ced,[CaseTitle] = 0x010cad,[CaseUpper] = 0x010cad,[CaseFold] = 0x010ced}, NULL},
	{0x010cee, {[CaseLower] = 0x010cee,[CaseTitle] = 0x010cae,[CaseUpper] = 0x010cae,[CaseFold] = 0x010cee}, NULL},
	{0x010cef, {[CaseLower] = 0x010cef,[CaseTitle] = 0x010caf,[CaseUpper] = 0x010caf,[CaseFold] = 0x010cef}, NULL},
	{0x010cf0, {[CaseLower] = 0x010cf0,[CaseTitle] = 0x010cb0,[CaseUpper] = 0x010cb0,[CaseFold] = 0x010cf0}, NULL},
	{0x010cf1, {[CaseLower] = 0x010cf1,[CaseTitle] = 0x010cb1,[CaseUpper] = 0x010cb1,[CaseFold] = 0x010cf1}, NULL},
	{0x010cf2, {[CaseLower] = 0x010cf2,[CaseTitle] = 0x010cb2,[CaseUpper] = 0x010cb2,[CaseFold] = 0x010cf2}, NULL},
	{0x0118a0, {[CaseLower] = 0x0118c0,[CaseTitle] = 0x0118a0,[CaseUpper] = 0x0118a0,[CaseFold] = 0x0118c0}, NULL},
	{0x0118a1, {[CaseLower] = 0x0118c1,[CaseTitle] = 0x0118a1,[CaseUpper] = 0x0118a1,[CaseFold] = 0x0118c1}, NULL},
	{0x0118a2, {[CaseLower] = 0x0118c2,[CaseTitle] = 0x0118a2,[CaseUpper] = 0x0118a2,[CaseFold] = 0x0118c2}, NULL},
	{0x0118a3, {[CaseLower] = 0x0118c3,[CaseTitle] = 0x0118a3,[CaseUpper] = 0x0118a3,[CaseFold] = 0x0118c3}, NULL},
	{0x0118a4, {[CaseLower] = 0x0118c4,[CaseTitle] = 0x0118a4,[CaseUpper] = 0x0118a4,[CaseFold] = 0x0118c4}, NULL},
	{0x0118a5, {[CaseLower] = 0x0118c5,[CaseTitle] = 0x0118a5,[CaseUpper] = 0x0118a5,[CaseFold] = 0x0118c5}, NULL},
	{0x0118a6, {[CaseLower] = 0x0118c6,[CaseTitle] = 0x0118a6,[CaseUpper] = 0x0118a6,[CaseFold] = 0x0118c6}, NULL},
	{0x0118a7, {[CaseLower] = 0x0118c7,[CaseTitle] = 0x0118a7,[CaseUpper] = 0x0118a7,[CaseFold] = 0x0118c7}, NULL},
	{0x0118a8, {[CaseLower] = 0x0118c8,[CaseTitle] = 0x0118a8,[CaseUpper] = 0x0118a8,[CaseFold] = 0x0118c8}, NULL},
	{0x0118a9, {[CaseLower] = 0x0118c9,[CaseTitle] = 0x0118a9,[CaseUpper] = 0x0118a9,[CaseFold] = 0x0118c9}, NULL},
	{0x0118aa, {[CaseLower] = 0x0118ca,[CaseTitle] = 0x0118aa,[CaseUpper] = 0x0118aa,[CaseFold] = 0x0118ca}, NULL},
	{0x0118ab, {[CaseLower] = 0x0118cb,[CaseTitle] = 0x0118ab,[CaseUpper] = 0x0118ab,[CaseFold] = 0x0118cb}, NULL},
	{0x0118ac, {[CaseLower] = 0x0118cc,[CaseTitle] = 0x0118ac,[CaseUpper] = 0x0118ac,[CaseFold] = 0x0118cc}, NULL},
	{0x0118ad, {[CaseLower] = 0x0118cd,[CaseTitle] = 0x0118ad,[CaseUpper] = 0x0118ad,[CaseFold] = 0x0118cd}, NULL},
	{0x0118ae, {[CaseLower] = 0x0118ce,[CaseTitle] = 0x0118ae,[CaseUpper] = 0x0118ae,[CaseFold] = 0x0118ce}, NULL},
	{0x0118af, {[CaseLower] = 0x0118cf,[CaseTitle] = 0x0118af,[CaseUpper] = 0x0118af,[CaseFold] = 0x0118cf}, NULL},
	{0x0118b0, {[CaseLower] = 0x0118d0,[CaseTitle] = 0x0118b0,[CaseUpper] = 0x0118b0,[CaseFold] = 0x0118d0}, NULL},
	{0x0118b1, {[CaseLower] = 0x0118d1,[CaseTitle] = 0x0118b1,[CaseUpper] = 0x0118b1,[CaseFold] = 0x0118d1}, NULL},
	{0x0118b2, {[CaseLower] = 0x0118d2,[CaseTitle] = 0x0118b2,[CaseUpper] = 0x0118b2,[CaseFold] = 0x0118d2}, NULL},
	{0x0118b3, {[CaseLower] = 0x0118d3,[CaseTitle] = 0x0118b3,[CaseUpper] = 0x0118b3,[CaseFold] = 0x0118d3}, NULL},
	{0x0118b4, {[CaseLower] = 0x0118d4,[CaseTitle] = 0x0118b4,[CaseUpper] = 0x0118b4,[CaseFold] = 0x0118d4}, NULL},
	{0x0118b5, {[CaseLower] = 0x0118d5,[CaseTitle] = 0x0118b5,[CaseUpper] = 0x0118b5,[CaseFold] = 0x0118d5}, NULL},
	{0x0118b6, {[CaseLower] = 0x0118d6,[CaseTitle] = 0x0118b6,[CaseUpper] = 0x0118b6,[CaseFold] = 0x0118d6}, NULL},
	{0x0118b7, {[CaseLower] = 0x0118d7,[CaseTitle] = 0x0118b7,[CaseUpper] = 0x0118b7,[CaseFold] = 0x0118d7}, NULL},
	{0x0118b8, {[CaseLower] = 0x0118d8,[CaseTitle] = 0x0118b8,[CaseUpper] = 0x0118b8,[CaseFold] = 0x0118d8}, NULL},
	{0x0118b9, {[CaseLower] = 0x0118d9,[CaseTitle] = 0x0118b9,[CaseUpper] = 0x0118b9,[CaseFold] = 0x0118d9}, NULL},
	{0x0118ba, {[CaseLower] = 0x0118da,[CaseTitle] = 0x0118ba,[CaseUpper] = 0x0118ba,[CaseFold] = 0x0118da}, NULL},
	{0x0118bb, {[CaseLower] = 0x0118db,[CaseTitle] = 0x0118bb,[CaseUpper] = 0x0118bb,[CaseFold] = 0x0118db}, NULL},
	{0x0118bc, {[CaseLower] = 0x0118dc,[CaseTitle] = 0x0118bc,[CaseUpper] = 0x0118bc,[CaseFold] = 0x0118dc}, NULL},
	{0x0118bd, {[CaseLower] = 0x0118dd,[CaseTitle] = 0x0118bd,[CaseUpper] = 0x0118bd,[CaseFold] = 0x0118dd}, NULL},
	{0x0118be, {[CaseLower] = 0x0118de,[CaseTitle] = 0x0118be,[CaseUpper] = 0x0118be,[CaseFold] = 0x0118de}, NULL},
	{0x0118bf, {[CaseLower] = 0x0118df,[CaseTitle] = 0x0118bf,[CaseUpper] = 0x0118bf,[CaseFold] = 0x0118df}, NULL},
	{0x0118c0, {[CaseLower] = 0x0118c0,[CaseTitle] = 0x0118a0,[CaseUpper] = 0x0118a0,[CaseFold] = 0x0118c0}, NULL},
	{0x0118c1, {[CaseLower] = 0x0118c1,[CaseTitle] = 0x0118a1,[CaseUpper] = 0x0118a1,[CaseFold] = 0x0118c1}, NULL},
	{0x0118c2, {[CaseLower] = 0x0118c2,[CaseTitle] = 0x0118a2,[CaseUpper] = 0x0118a2,[CaseFold] = 0x0118c2}, NULL},
	{0x0118c3, {[CaseLower] = 0x0118c3,[CaseTitle] = 0x0118a3,[CaseUpper] = 0x0118a3,[CaseFold] = 0x0118c3}, NULL},
	{0x0118c4, {[CaseLower] = 0x0118c4,[CaseTitle] = 0x0118a4,[CaseUpper] = 0x0118a4,[CaseFold] = 0x0118c4}, NULL},
	{0x0118c5, {[CaseLower] = 0x0118c5,[CaseTitle] = 0x0118a5,[CaseUpper] = 0x0118a5,[CaseFold] = 0x0118c5}, NULL},
	{0x0118c6, {[CaseLower] = 0x0118c6,[CaseTitle] = 0x0118a6,[CaseUpper] = 0x0118a6,[CaseFold] = 0x0118c6}, NULL},
	{0x0118c7, {[CaseLower] = 0x0118c7,[CaseTitle] = 0x0118a7,[CaseUpper] = 0x0118a7,[CaseFold] = 0x0118c7}, NULL},
	{0x0118c8, {[CaseLower] = 0x0118c8,[CaseTitle] = 0x0118a8,[CaseUpper] = 0x0118a8,[CaseFold] = 0x0118c8}, NULL},
	{0x0118c9, {[CaseLower] = 0x0118c9,[CaseTitle] = 0x0118a9,[CaseUpper] = 0x0118a9,[CaseFold] = 0x0118c9}, NULL},
	{0x0118ca, {[CaseLower] = 0x0118ca,[CaseTitle] = 0x0118aa,[CaseUpper] = 0x0118aa,[CaseFold] = 0x0118ca}, NULL},
	{0x0118cb, {[CaseLower] = 0x0118cb,[CaseTitle] = 0x0118ab,[CaseUpper] = 0x0118ab,[CaseFold] = 0x0118cb}, NULL},
	{0x0118cc, {[CaseLower] = 0x0118cc,[CaseTitle] = 0x0118ac,[CaseUpper] = 0x0118ac,[CaseFold] = 0x0118cc}, NULL},
	{0x0118cd, {[CaseLower] = 0x0118cd,[CaseTitle] = 0x0118ad,[CaseUpper] = 0x0118ad,[CaseFold] = 0x0118cd}, NULL},
	{0x0118ce, {[CaseLower] = 0x0118ce,[CaseTitle] = 0x0118ae,[CaseUpper] = 0x0118ae,[CaseFold] = 0x0118ce}, NULL},
	{0x0118cf, {[CaseLower] = 0x0118cf,[CaseTitle] = 0x0118af,[CaseUpper] = 0x0118af,[CaseFold] = 0x0118cf}, NULL},
	{0x0118d0, {[CaseLower] = 0x0118d0,[CaseTitle] = 0x0118b0,[CaseUpper] = 0x0118b0,[CaseFold] = 0x0118d0}, NULL},
	{0x0118d1, {[CaseLower] = 0x0118d1,[CaseTitle] = 0x0118b1,[CaseUpper] = 0x0118b1,[CaseFold] = 0x0118d1}, NULL},
	{0x0118d2, {[CaseLower] = 0x0118d2,[CaseTitle] = 0x0118b2,[CaseUpper] = 0x0118b2,[CaseFold] = 0x0118d2}, NULL},
	{0x0118d3, {[CaseLower] = 0x0118d3,[CaseTitle] = 0x0118b3,[CaseUpper] = 0x0118b3,[CaseFold] = 0x0118d3}, NULL},
	{0x0118d4, {[CaseLower] = 0x0118d4,[CaseTitle] = 0x0118b4,[CaseUpper] = 0x0118b4,[CaseFold] = 0x0118d4}, NULL},
	{0x0118d5, {[CaseLower] = 0x0118d5,[CaseTitle] = 0x0118b5,[CaseUpper] = 0x0118b5,[CaseFold] = 0x0118d5}, NULL},
	{0x0118d6, {[CaseLower] = 0x0118d6,[CaseTitle] = 0x0118b6,[CaseUpper] = 0x0118b6,[CaseFold] = 0x0118d6}, NULL},
	{0x0118d7, {[CaseLower] = 0x0118d7,[CaseTitle] = 0x0118b7,[CaseUpper] = 0x0118b7,[CaseFold] = 0x0118d7}, NULL},
	{0x0118d8, {[CaseLower] = 0x0118d8,[CaseTitle] = 0x0118b8,[CaseUpper] = 0x0118b8,[CaseFold] = 0x0118d8}, NULL},
	{0x0118d9, {[CaseLower] = 0x0118d9,[CaseTitle] = 0x0118b9,[CaseUpper] = 0x0118b9,[CaseFold] = 0x0118d9}, NULL},
	{0x0118da, {[CaseLower] = 0x0118da,[CaseTitle] = 0x0118ba,[CaseUpper] = 0x0118ba,[CaseFold] = 0x0118da}, NULL},
	{0x0118db, {[CaseLower] = 0x0118db,[CaseTitle] = 0x0118bb,[CaseUpper] = 0x0118bb,[CaseFold] = 0x0118db}, NULL},
	{0x0118dc, {[CaseLower] = 0x0118dc,[CaseTitle] = 0x0118bc,[CaseUpper] = 0x0118bc,[CaseFold] = 0x0118dc}, NULL},
	{0x0118dd, {[CaseLower] = 0x0118dd,[CaseTitle] = 0x0118bd,[CaseUpper] = 0x0118bd,[CaseFold] = 0x0118dd}, NULL},
	{0x0118de, {[CaseLower] = 0x0118de,[CaseTitle] = 0x0118be,[CaseUpper] = 0x0118be,[CaseFold] = 0x0118de}, NULL},
	{0x0118df, {[CaseLower] = 0x0118df,[CaseTitle] = 0x0118bf,[CaseUpper] = 0x0118bf,[CaseFold] = 0x0118df}, NULL},
	{0x016e40, {[CaseLower] = 0x016e60,[CaseTitle] = 0x016e40,[CaseUpper] = 0x016e40,[CaseFold] = 0x016e60}, NULL},
	{0x016e41, {[CaseLower] = 0x016e61,[CaseTitle] = 0x016e41,[CaseUpper] = 0x016e41,[CaseFold] = 0x016e61}, NULL},
	{0x016e42, {[CaseLower] = 0x016e62,[CaseTitle] = 0x016e42,[CaseUpper] = 0x016e42,[CaseFold] = 0x016e62}, NULL},
	{0x016e43, {[CaseLower] = 0x016e63,[CaseTitle] = 0x016e43,[CaseUpper] = 0x016e43,[CaseFold] = 0x016e63}, NULL},
	{0x016e44, {[CaseLower] = 0x016e64,[CaseTitle] = 0x016e44,[CaseUpper] = 0x016e44,[CaseFold] = 0x016e64}, NULL},
	{0x016e45, {[CaseLower] = 0x016e65,[CaseTitle] = 0x016e45,[CaseUpper] = 0x016e45,[CaseFold] = 0x016e65}, NULL},
	{0x016e46, {[CaseLower] = 0x016e66,[CaseTitle] = 0x016e46,[CaseUpper] = 0x016e46,[CaseFold] = 0x016e66}, NULL},
	{0x016e47, {[CaseLower] = 0x016e67,[CaseTitle] = 0x016e47,[CaseUpper] = 0x016e47,[CaseFold] = 0x016e67}, NULL},
	{0x016e48, {[CaseLower] = 0x016e68,[CaseTitle] = 0x016e48,[CaseUpper] = 0x016e48,[CaseFold] = 0x016e68}, NULL},
	{0x016e49, {[CaseLower] = 0x016e69,[CaseTitle] = 0x016e49,[CaseUpper] = 0x016e49,[CaseFold] = 0x016e69}, NULL},
	{0x016e4a, {[CaseLower] = 0x016e6a,[CaseTitle] = 0x016e4a,[CaseUpper] = 0x016e4a,[CaseFold] = 0x016e6a}, NULL},
	{0x016e4b, {[CaseLower] = 0x016e6b,[CaseTitle] = 0x016e4b,[CaseUpper] = 0x016e4b,[CaseFold] = 0x016e6b}, NULL},
	{0x016e4c, {[CaseLower] = 0x016e6c,[CaseTitle] = 0x016e4c,[CaseUpper] = 0x016e4c,[CaseFold] = 0x016e6c}, NULL},
	{0x016e4d, {[CaseLower] = 0x016e6d,[CaseTitle] = 0x016e4d,[CaseUpper] = 0x016e4d,[CaseFold] = 0x016e6d}, NULL},
	{0x016e4e, {[CaseLower] = 0x016e6e,[CaseTitle] = 0x016e4e,[CaseUpper] = 0x016e4e,[CaseFold] = 0x016e6e}, NULL},
	{0x016e4f, {[CaseLower] = 0x016e6f,[CaseTitle] = 0x016e4f,[CaseUpper] = 0x016e4f,[CaseFold] = 0x016e6f}, NULL},
	{0x016e50, {[CaseLower] = 0x016e70,[CaseTitle] = 0x016e50,[CaseUpper] = 0x016e50,[CaseFold] = 0x016e70}, NULL},
	{0x016e51, {[CaseLower] = 0x016e71,[CaseTitle] = 0x016e51,[CaseUpper] = 0x016e51,[CaseFold] = 0x016e71}, NULL},
	{0x016e52, {[CaseLower] = 0x016e72,[CaseTitle] = 0x016e52,[CaseUpper] = 0x016e52,[CaseFold] = 0x016e72}, NULL},
	{0x016e53, {[CaseLower] = 0x016e73,[CaseTitle] = 0x016e53,[CaseUpper] = 0x016e53,[CaseFold] = 0x016e73}, NULL},
	{0x016e54, {[CaseLower] = 0x016e74,[CaseTitle] = 0x016e54,[CaseUpper] = 0x016e54,[CaseFold] = 0x016e74}, NULL},
	{0x016e55, {[CaseLower] = 0x016e75,[CaseTitle] = 0x016e55,[CaseUpper] = 0x016e55,[CaseFold] = 0x016e75}, NULL},
	{0x016e56, {[CaseLower] = 0x016e76,[CaseTitle] = 0x016e56,[CaseUpper] = 0x016e56,[CaseFold] = 0x016e76}, NULL},
	{0x016e57, {[CaseLower] = 0x016e77,[CaseTitle] = 0x016e57,[CaseUpper] = 0x016e57,[CaseFold] = 0x016e77}, NULL},
	{0x016e58, {[CaseLower] = 0x016e78,[CaseTitle] = 0x016e58,[CaseUpper] = 0x016e58,[CaseFold] = 0x016e78}, NULL},
	{0x016e59, {[CaseLower] = 0x016e79,[CaseTitle] = 0x016e59,[CaseUpper] = 0x016e59,[CaseFold] = 0x016e79}, NULL},
	{0x016e5a, {[CaseLower] = 0x016e7a,[CaseTitle] = 0x016e5a,[CaseUpper] = 0x016e5a,[CaseFold] = 0x016e7a}, NULL},
	{0x016e5b, {[CaseLower] = 0x016e7b,[CaseTitle] = 0x016e5b,[CaseUpper] = 0x016e5b,[CaseFold] = 0x016e7b}, NULL},
	{0x016e5c, {[CaseLower] = 0x016e7c,[CaseTitle] = 0x016e5c,[CaseUpper] = 0x016e5c,[CaseFold] = 0x016e7c}, NULL},
	{0x016e5d, {[CaseLower] = 0x016e7d,[CaseTitle] = 0x016e5d,[CaseUpper] = 0x016e5d,[CaseFold] = 0x016e7d}, NULL},
	{0x016e5e, {[CaseLower] = 0x016e7e,[CaseTitle] = 0x016e5e,[CaseUpper] = 0x016e5e,[CaseFold] = 0x016e7e}, NULL},
	{0x016e5f, {[CaseLower] = 0x016e7f,[CaseTitle] = 0x016e5f,[CaseUpper] = 0x016e5f,[CaseFold] = 0x016e7f}, NULL},
	{0x016e60, {[CaseLower] = 0x016e60,[CaseTitle] = 0x016e40,[CaseUpper] = 0x016e40,[CaseFold] = 0x016e60}, NULL},
	{0x016e61, {[CaseLower] = 0x016e61,[CaseTitle] = 0x016e41,[CaseUpper] = 0x016e41,[CaseFold] = 0x016e61}, NULL},
	{0x016e62, {[CaseLower] = 0x016e62,[CaseTitle] = 0x016e42,[CaseUpper] = 0x016e42,[CaseFold] = 0x016e62}, NULL},
	{0x016e63, {[CaseLower] = 0x016e63,[CaseTitle] = 0x016e43,[CaseUpper] = 0x016e43,[CaseFold] = 0x016e63}, NULL},
	{0x016e64, {[CaseLower] = 0x016e64,[CaseTitle] = 0x016e44,[CaseUpper] = 0x016e44,[CaseFold] = 0x016e64}, NULL},
	{0x016e65, {[CaseLower] = 0x016e65,[CaseTitle] = 0x016e45,[CaseUpper] = 0x016e45,[CaseFold] = 0x016e65}, NULL},
	{0x016e66, {[CaseLower] = 0x016e66,[CaseTitle] = 0x016e46,[CaseUpper] = 0x016e46,[CaseFold] = 0x016e66}, NULL},
	{0x016e67, {[CaseLower] = 0x016e67,[CaseTitle] = 0x016e47,[CaseUpper] = 0x016e47,[CaseFold] = 0x016e67}, NULL},
	{0x016e68, {[CaseLower] = 0x016e68,[CaseTitle] = 0x016e48,[CaseUpper] = 0x016e48,[CaseFold] = 0x016e68}, NULL},
	{0x016e69, {[CaseLower] = 0x016e69,[CaseTitle] = 0x016e49,[CaseUpper] = 0x016e49,[CaseFold] = 0x016e69}, NULL},
	{0x016e6a, {[CaseLower] = 0x016e6a,[CaseTitle] = 0x016e4a,[CaseUpper] = 0x016e4a,[CaseFold] = 0x016e6a}, NULL},
	{0x016e6b, {[CaseLower] = 0x016e6b,[CaseTitle] = 0x016e4b,[CaseUpper] = 0x016e4b,[CaseFold] = 0x016e6b}, NULL},
	{0x016e6c, {[CaseLower] = 0x016e6c,[CaseTitle] = 0x016e4c,[CaseUpper] = 0x016e4c,[CaseFold] = 0x016e6c}, NULL},
	{0x016e6d, {[CaseLower] = 0x016e6d,[CaseTitle] = 0x016e4d,[CaseUpper] = 0x016e4d,[CaseFold] = 0x016e6d}, NULL},
	{0x016e6e, {[CaseLower] = 0x016e6e,[CaseTitle] = 0x016e4e,[CaseUpper] = 0x016e4e,[CaseFold] = 0x016e6e}, NULL},
	{0x016e6f, {[CaseLower] = 0x016e6f,[CaseTitle] = 0x016e4f,[CaseUpper] = 0x016e4f,[CaseFold] = 0x016e6f}, NULL},
	{0x016e70, {[CaseLower] = 0x016e70,[CaseTitle] = 0x016e50,[CaseUpper] = 0x016e50,[CaseFold] = 0x016e70}, NULL},
	{0x016e71, {[CaseLower] = 0x016e71,[CaseTitle] = 0x016e51,[CaseUpper] = 0x016e51,[CaseFold] = 0x016e71}, NULL},
	{0x016e72, {[CaseLower] = 0x016e72,[CaseTitle] = 0x016e52,[CaseUpper] = 0x016e52,[CaseFold] = 0x016e72}, NULL},
	{0x016e73, {[CaseLower] = 0x016e73,[CaseTitle] = 0x016e53,[CaseUpper] = 0x016e53,[CaseFold] = 0x016e73}, NULL},
	{0x016e74, {[CaseLower] = 0x016e74,[CaseTitle] = 0x016e54,[CaseUpper] = 0x016e54,[CaseFold] = 0x016e74}, NULL},
	{0x016e75, {[CaseLower] = 0x016e75,[CaseTitle] = 0x016e55,[CaseUpper] = 0x016e55,[CaseFold] = 0x016e75}, NULL},
	{0x016e76, {[CaseLower] = 0x016e76,[CaseTitle] = 0x016e56,[CaseUpper] = 0x016e56,[CaseFold] = 0x016e76}, NULL},
	{0x016e77, {[CaseLower] = 0x016e77,[CaseTitle] = 0x016e57,[CaseUpper] = 0x016e57,[CaseFold] = 0x016e77}, NULL},
	{0x016e78, {[CaseLower] = 0x016e78,[CaseTitle] = 0x016e58,[CaseUpper] = 0x016e58,[CaseFold] = 0x016e78}, NULL},
	{0x016e79, {[CaseLower] = 0x016e79,[CaseTitle] = 0x016e59,[CaseUpper] = 0x016e59,[CaseFold] = 0x016e79}, NULL},
	{0x016e7a, {[CaseLower] = 0x016e7a,[CaseTitle] = 0x016e5a,[CaseUpper] = 0x016e5a,[CaseFold] = 0x016e7a}, NULL},
	{0x016e7b, {[CaseLower] = 0x016e7b,[CaseTitle] = 0x016e5b,[CaseUpper] = 0x016e5b,[CaseFold] = 0x016e7b}, NULL},
	{0x016e7c, {[CaseLower] = 0x016e7c,[CaseTitle] = 0x016e5c,[CaseUpper] = 0x016e5c,[CaseFold] = 0x016e7c}, NULL},
	{0x016e7d, {[CaseLower] = 0x016e7d,[CaseTitle] = 0x016e5d,[CaseUpper] = 0x016e5d,[CaseFold] = 0x016e7d}, NULL},
	{0x016e7e, {[CaseLower] = 0x016e7e,[CaseTitle] = 0x016e5e,[CaseUpper] = 0x016e5e,[CaseFold] = 0x016e7e}, NULL},
	{0x016e7f, {[CaseLower] = 0x016e7f,[CaseTitle] = 0x016e5f,[CaseUpper] = 0x016e5f,[CaseFold] = 0x016e7f}, NULL},
	{0x01e900, {[CaseLower] = 0x01e922,[CaseTitle] = 0x01e900,[CaseUpper] = 0x01e900,[CaseFold] = 0x01e922}, NULL},
	{0x01e901, {[CaseLower] = 0x01e923,[CaseTitle] = 0x01e901,[CaseUpper] = 0x01e901,[CaseFold] = 0x01e923}, NULL},
	{0x01e902, {[CaseLower] = 0x01e924,[CaseTitle] = 0x01e902,[CaseUpper] = 0x01e902,[CaseFold] = 0x01e924}, NULL},
	{0x01e903, {[CaseLower] = 0x01e925,[CaseTitle] = 0x01e903,[CaseUpper] = 0x01e903,[CaseFold] = 0x01e925}, NULL},
	{0x01e904, {[CaseLower] = 0x01e926,[CaseTitle] = 0x01e904,[CaseUpper] = 0x01e904,[CaseFold] = 0x01e926}, NULL},
	{0x01e905, {[CaseLower] = 0x01e927,[CaseTitle] = 0x01e905,[CaseUpper] = 0x01e905,[CaseFold] = 0x01e927}, NULL},
	{0x01e906, {[CaseLower] = 0x01e928,[CaseTitle] = 0x01e906,[CaseUpper] = 0x01e906,[CaseFold] = 0x01e928}, NULL},
	{0x01e907, {[CaseLower] = 0x01e929,[CaseTitle] = 0x01e907,[CaseUpper] = 0x01e907,[CaseFold] = 0x01e929}, NULL},
	{0x01e908, {[CaseLower] = 0x01e92a,[CaseTitle] = 0x01e908,[CaseUpper] = 0x01e908,[CaseFold] = 0x01e92a}, NULL},
	{0x01e909, {[CaseLower] = 0x01e92b,[CaseTitle] = 0x01e909,[CaseUpper] = 0x01e909,[CaseFold] = 0x01e92b}, NULL},
	{0x01e90a, {[CaseLower] = 0x01e92c,[CaseTitle] = 0x01e90a,[CaseUpper] = 0x01e90a,[CaseFold] = 0x01e92c}, NULL},
	{0x01e90b, {[CaseLower] = 0x01e92d,[CaseTitle] = 0x01e90b,[CaseUpper] = 0x01e90b,[CaseFold] = 0x01e92d}, NULL},
	{0x01e90c, {[CaseLower] = 0x01e92e,[CaseTitle] = 0x01e90c,[CaseUpper] = 0x01e90c,[CaseFold] = 0x01e92e}, NULL},
	{0x01e90d, {[CaseLower] = 0x01e92f,[CaseTitle] = 0x01e90d,[CaseUpper] = 0x01e90d,[CaseFold] = 0x01e92f}, NULL},
	{0x01e90e, {[CaseLower] = 0x01e930,[CaseTitle] = 0x01e90e,[CaseUpper] = 0x01e90e,[CaseFold] = 0x01e930}, NULL},
	{0x01e90f, {[CaseLower] = 0x01e931,[CaseTitle] = 0x01e90f,[CaseUpper] = 0x01e90f,[CaseFold] = 0x01e931}, NULL},
	{0x01e910, {[CaseLower] = 0x01e932,[CaseTitle] = 0x01e910,[CaseUpper] = 0x01e910,[CaseFold] = 0x01e932}, NULL},
	{0x01e911, {[CaseLower] = 0x01e933,[CaseTitle] = 0x01e911,[CaseUpper] = 0x01e911,[CaseFold] = 0x01e933}, NULL},
	{0x01e912, {[CaseLower] = 0x01e934,[CaseTitle] = 0x01e912,[CaseUpper] = 0x01e912,[CaseFold] = 0x01e934}, NULL},
	{0x01e913, {[CaseLower] = 0x01e935,[CaseTitle] = 0x01e913,[CaseUpper] = 0x01e913,[CaseFold] = 0x01e935}, NULL},
	{0x01e914, {[CaseLower] = 0x01e936,[CaseTitle] = 0x01e914,[CaseUpper] = 0x01e914,[CaseFold] = 0x01e936}, NULL},
	{0x01e915, {[CaseLower] = 0x01e937,[CaseTitle] = 0x01e915,[CaseUpper] = 0x01e915,[CaseFold] = 0x01e937}, NULL},
	{0x01e916, {[CaseLower] = 0x01e938,[CaseTitle] = 0x01e916,[CaseUpper] = 0x01e916,[CaseFold] = 0x01e938}, NULL},
	{0x01e917, {[CaseLower] = 0x01e939,[CaseTitle] = 0x01e917,[CaseUpper] = 0x01e917,[CaseFold] = 0x01e939}, NULL},
	{0x01e918, {[CaseLower] = 0x01e93a,[CaseTitle] = 0x01e918,[CaseUpper] = 0x01e918,[CaseFold] = 0x01e93a}, NULL},
	{0x01e919, {[CaseLower] = 0x01e93b,[CaseTitle] = 0x01e919,[CaseUpper] = 0x01e919,[CaseFold] = 0x01e93b}, NULL},
	{0x01e91a, {[CaseLower] = 0x01e93c,[CaseTitle] = 0x01e91a,[CaseUpper] = 0x01e91a,[CaseFold] = 0x01e93c}, NULL},
	{0x01e91b, {[CaseLower] = 0x01e93d,[CaseTitle] = 0x01e91b,[CaseUpper] = 0x01e91b,[CaseFold] = 0x01e93d}, NULL},
	{0x01e91c, {[CaseLower] = 0x01e93e,[CaseTitle] = 0x01e91c,[CaseUpper] = 0x01e91c,[CaseFold] = 0x01e93e}, NULL},
	{0x01e91d, {[CaseLower] = 0x01e93f,[CaseTitle] = 0x01e91d,[CaseUpper] = 0x01e91d,[CaseFold] = 0x01e93f}, NULL},
	{0x01e91e, {[CaseLower] = 0x01e940,[CaseTitle] = 0x01e91e,[CaseUpper] = 0x01e91e,[CaseFold] = 0x01e940}, NULL},
	{0x01e91f, {[CaseLower] = 0x01e941,[CaseTitle] = 0x01e91f,[CaseUpper] = 0x01e91f,[CaseFold] = 0x01e941}, NULL},
	{0x01e920, {[CaseLower] = 0x01e942,[CaseTitle] = 0x01e920,[CaseUpper] = 0x01e920,[CaseFold] = 0x01e942}, NULL},
	{0x01e921, {[CaseLower] = 0x01e943,[CaseTitle] = 0x01e921,[CaseUpper] = 0x01e921,[CaseFold] = 0x01e943}, NULL},
	{0x01e922, {[CaseLower] = 0x01e922,[CaseTitle] = 0x01e900,[CaseUpper] = 0x01e900,[CaseFold] = 0x01e922}, NULL},
	{0x01e923, {[CaseLower] = 0x01e923,[CaseTitle] = 0x01e901,[CaseUpper] = 0x01e901,[CaseFold] = 0x01e923}, NULL},
	{0x01e924, {[CaseLower] = 0x01e924,[CaseTitle] = 0x01e902,[CaseUpper] = 0x01e902,[CaseFold] = 0x01e924}, NULL},
	{0x01e925, {[CaseLower] = 0x01e925,[CaseTitle] = 0x01e903,[CaseUpper] = 0x01e903,[CaseFold] = 0x01e925}, NULL},
	{0x01e926, {[CaseLower] = 0x01e926,[CaseTitle] = 0x01e904,[CaseUpper] = 0x01e904,[CaseFold] = 0x01e926}, NULL},
	{0x01e927, {[CaseLower] = 0x01e927,[CaseTitle] = 0x01e905,[CaseUpper] = 0x01e905,[CaseFold] = 0x01e927}, NULL},
	{0x01e928, {[CaseLower] = 0x01e928,[CaseTitle] = 0x01e906,[CaseUpper] = 0x01e906,[CaseFold] = 0x01e928}, NULL},
	{0x01e929, {[CaseLower] = 0x01e929,[CaseTitle] = 0x01e907,[CaseUpper] = 0x01e907,[CaseFold] = 0x01e929}, NULL},
	{0x01e92a, {[CaseLower] = 0x01e92a,[CaseTitle] = 0x01e908,[CaseUpper] = 0x01e908,[CaseFold] = 0x01e92a}, NULL},
	{0x01e92b, {[CaseLower] = 0x01e92b,[CaseTitle] = 0x01e909,[CaseUpper] = 0x01e909,[CaseFold] = 0x01e92b}, NULL},
	{0x01e92c, {[CaseLower] = 0x01e92c,[CaseTitle] = 0x01e90a,[CaseUpper] = 0x01e90a,[CaseFold] = 0x01e92c}, NULL},
	{0x01e92d, {[CaseLower] = 0x01e92d,[CaseTitle] = 0x01e90b,[CaseUpper] = 0x01e90b,[CaseFold] = 0x01e92d}, NULL},
	{0x01e92e, {[CaseLower] = 0x01e92e,[CaseTitle] = 0x01e90c,[CaseUpper] = 0x01e90c,[CaseFold] = 0x01e92e}, NULL},
	{0x01e92f, {[CaseLower] = 0x01e92f,[CaseTitle] = 0x01e90d,[CaseUpper] = 0x01e90d,[CaseFold] = 0x01e92f}, NULL},
	{0x01e930, {[CaseLower] = 0x01e930,[CaseTitle] = 0x01e90e,[CaseUpper] = 0x01e90e,[CaseFold] = 0x01e930}, NULL},
	{0x01e931, {[CaseLower] = 0x01e931,[CaseTitle] = 0x01e90f,[CaseUpper] = 0x01e90f,[CaseFold] = 0x01e931}, NULL},
	{0x01e932, {[CaseLower] = 0x01e932,[CaseTitle] = 0x01e910,[CaseUpper] = 0x01e910,[CaseFold] = 0x01e932}, NULL},
	{0x01e933, {[CaseLower] = 0x01e933,[CaseTitle] = 0x01e911,[CaseUpper] = 0x01e911,[CaseFold] = 0x01e933}, NULL},
	{0x01e934, {[CaseLower] = 0x01e934,[CaseTitle] = 0x01e912,[CaseUpper] = 0x01e912,[CaseFold] = 0x01e934}, NULL},
	{0x01e935, {[CaseLower] = 0x01e935,[CaseTitle] = 0x01e913,[CaseUpper] = 0x01e913,[CaseFold] = 0x01e935}, NULL},
	{0x01e936, {[CaseLower] = 0x01e936,[CaseTitle] = 0x01e914,[CaseUpper] = 0x01e914,[CaseFold] = 0x01e936}, NULL},
	{0x01e937, {[CaseLower] = 0x01e937,[CaseTitle] = 0x01e915,[CaseUpper] = 0x01e915,[CaseFold] = 0x01e937}, NULL},
	{0x01e938, {[CaseLower] = 0x01e938,[CaseTitle] = 0x01e916,[CaseUpper] = 0x01e916,[CaseFold] = 0x01e938}, NULL},
	{0x01e939, {[CaseLower] = 0x01e939,[CaseTitle] = 0x01e917,[CaseUpper] = 0x01e917,[CaseFold] = 0x01e939}, NULL},
	{0x01e93a, {[CaseLower] = 0x01e93a,[CaseTitle] = 0x01e918,[CaseUpper] = 0x01e918,[CaseFold] = 0x01e93a}, NULL},
	{0x01e93b, {[CaseLower] = 0x01e93b,[CaseTitle] = 0x01e919,[CaseUpper] = 0x01e919,[CaseFold] = 0x01e93b}, NULL},
	{0x01e93c, {[CaseLower] = 0x01e93c,[CaseTitle] = 0x01e91a,[CaseUpper] = 0x01e91a,[CaseFold] = 0x01e93c}, NULL},
	{0x01e93d, {[CaseLower] = 0x01e93d,[CaseTitle] = 0x01e91b,[CaseUpper] = 0x01e91b,[CaseFold] = 0x01e93d}, NULL},
	{0x01e93e, {[CaseLower] = 0x01e93e,[CaseTitle] = 0x01e91c,[CaseUpper] = 0x01e91c,[CaseFold] = 0x01e93e}, NULL},
	{0x01e93f, {[CaseLower] = 0x01e93f,[CaseTitle] = 0x01e91d,[CaseUpper] = 0x01e91d,[CaseFold] = 0x01e93f}, NULL},
	{0x01e940, {[CaseLower] = 0x01e940,[CaseTitle] = 0x01e91e,[CaseUpper] = 0x01e91e,[CaseFold] = 0x01e940}, NULL},
	{0x01e941, {[CaseLower] = 0x01e941,[CaseTitle] = 0x01e91f,[CaseUpper] = 0x01e91f,[CaseFold] = 0x01e941}, NULL},
	{0x01e942, {[CaseLower] = 0x01e942,[CaseTitle] = 0x01e920,[CaseUpper] = 0x01e920,[CaseFold] = 0x01e942}, NULL},
	{0x01e943, {[CaseLower] = 0x01e943,[CaseTitle] = 0x01e921,[CaseUpper] = 0x01e921,[CaseFold] = 0x01e943}, NULL},
};
