/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.Pair;
import cz.startnet.utils.pgdiff.PgDiffArguments;
import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgColumnPrivilege;
import cz.startnet.utils.pgdiff.schema.PgColumnUtils;
import cz.startnet.utils.pgdiff.schema.PgInheritedColumn;
import cz.startnet.utils.pgdiff.schema.PgRelationPrivilege;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTable;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgDiffTables {
    public static void dropClusters(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgTable pgTable : pgSchema2.getTables()) {
            PgTable pgTable2 = pgSchema == null ? null : pgSchema.getTable(pgTable.getName());
            String string = pgTable2 == null ? null : pgTable2.getClusterIndexName();
            String string2 = pgTable.getClusterIndexName();
            if (string == null || string2 != null || !pgTable.containsIndex(string)) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("ALTER TABLE ");
            printWriter.print(PgDiffUtils.getQuotedName(pgTable.getName()));
            printWriter.println(" SET WITHOUT CLUSTER;");
        }
    }

    public static void createClusters(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgTable pgTable : pgSchema2.getTables()) {
            PgTable pgTable2 = pgSchema == null ? null : pgSchema.getTable(pgTable.getName());
            String string = pgTable2 == null ? null : pgTable2.getClusterIndexName();
            String string2 = pgTable.getClusterIndexName();
            if ((string != null || string2 == null) && (string == null || string2 == null || string2.compareTo(string) == 0)) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("ALTER TABLE ");
            printWriter.print(PgDiffUtils.getQuotedName(pgTable.getName()));
            printWriter.print(" CLUSTER ON ");
            printWriter.print(PgDiffUtils.getQuotedName(string2));
            printWriter.println(';');
        }
    }

    public static void alterTables(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgTable pgTable : pgSchema2.getTables()) {
            if (pgSchema == null || !pgSchema.containsTable(pgTable.getName())) continue;
            PgTable pgTable2 = pgSchema.getTable(pgTable.getName());
            PgDiffTables.updateTableColumns(printWriter, pgDiffArguments, pgTable2, pgTable, searchPathHelper);
            PgDiffTables.checkWithOIDS(printWriter, pgTable2, pgTable, searchPathHelper);
            PgDiffTables.checkInherits(printWriter, pgTable2, pgTable, pgSchema2, searchPathHelper);
            PgDiffTables.addInheritedColumnDefaults(printWriter, pgDiffArguments, pgTable2, pgTable, searchPathHelper);
            PgDiffTables.checkTablespace(printWriter, pgTable2, pgTable, searchPathHelper);
            PgDiffTables.addAlterStatistics(printWriter, pgTable2, pgTable, searchPathHelper);
            PgDiffTables.addAlterStorage(printWriter, pgTable2, pgTable, searchPathHelper);
            PgDiffTables.alterComments(printWriter, pgTable2, pgTable, searchPathHelper);
            PgDiffTables.alterOwnerTo(printWriter, pgTable2, pgTable, searchPathHelper);
            PgDiffTables.alterPrivileges(printWriter, pgTable2, pgTable, searchPathHelper);
            PgDiffTables.alterPrivilegesColumns(printWriter, pgTable2, pgTable, searchPathHelper);
            PgDiffTables.alterRLS(printWriter, pgTable2, pgTable, searchPathHelper);
        }
    }

    private static void addAlterStatistics(PrintWriter printWriter, PgTable pgTable, PgTable pgTable2, SearchPathHelper searchPathHelper) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (PgColumn object : pgTable2.getColumns()) {
            PgColumn pgColumn = pgTable.getColumn(object.getName());
            if (pgColumn == null) continue;
            Integer n = pgColumn.getStatistics();
            Integer n2 = object.getStatistics();
            Integer n3 = null;
            if (!(n2 == null || n != null && n2.equals(n))) {
                n3 = n2;
            } else if (n != null && n2 == null) {
                n3 = -1;
            }
            if (n3 == null) continue;
            hashMap.put(object.getName(), n3);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("ALTER TABLE ONLY ");
            printWriter.print(PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.print(" ALTER COLUMN ");
            printWriter.print(PgDiffUtils.getQuotedName((String)entry.getKey()));
            printWriter.print(" SET STATISTICS ");
            printWriter.print(entry.getValue());
            printWriter.println(';');
        }
    }

    private static void addAlterStorage(PrintWriter printWriter, PgTable pgTable, PgTable pgTable2, SearchPathHelper searchPathHelper) {
        for (PgColumn pgColumn : pgTable2.getColumns()) {
            String string;
            PgColumn pgColumn2 = pgTable.getColumn(pgColumn.getName());
            String string2 = pgColumn2 == null || pgColumn2.getStorage() == null || pgColumn2.getStorage().isEmpty() ? null : pgColumn2.getStorage();
            String string3 = string = pgColumn.getStorage() == null || pgColumn.getStorage().isEmpty() ? null : pgColumn.getStorage();
            if (string == null && string2 != null) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.println(MessageFormat.format(Resources.getString("WarningUnableToDetermineStorageType"), pgTable2.getName() + '.' + pgColumn.getName()));
                continue;
            }
            if (string == null || string.equalsIgnoreCase(string2)) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("ALTER TABLE ONLY ");
            printWriter.print(PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.print(" ALTER COLUMN ");
            printWriter.print(PgDiffUtils.getQuotedName(pgColumn.getName()));
            printWriter.print(" SET STORAGE ");
            printWriter.print(string);
            printWriter.print(';');
        }
    }

    private static void addCreateTableColumns(List<String> list, PgDiffArguments pgDiffArguments, PgTable pgTable, PgTable pgTable2, List<PgColumn> list2) {
        for (PgColumn pgColumn : pgTable2.getColumns()) {
            if (pgTable.containsColumn(pgColumn.getName())) continue;
            list.add("\tADD COLUMN " + PgDiffUtils.getCreateIfNotExists() + pgColumn.getFullDefinition(pgDiffArguments.isAddDefaults()));
            if (!pgDiffArguments.isAddDefaults() || pgColumn.getNullValue() || pgColumn.getDefaultValue() != null && !pgColumn.getDefaultValue().isEmpty()) continue;
            list2.add(pgColumn);
        }
    }

    private static void addDropTableColumns(List<String> list, PgTable pgTable, PgTable pgTable2) {
        for (PgColumn pgColumn : pgTable.getColumns()) {
            if (pgTable2.containsColumn(pgColumn.getName())) continue;
            list.add("\tDROP COLUMN " + PgDiffUtils.getDropIfExists() + PgDiffUtils.getQuotedName(pgColumn.getName()));
        }
    }

    private static void addModifyTableColumns(List<String> list, PgDiffArguments pgDiffArguments, PgTable pgTable, PgTable pgTable2, List<PgColumn> list2) {
        for (PgColumn pgColumn : pgTable2.getColumns()) {
            String string;
            String string2;
            if (!pgTable.containsColumn(pgColumn.getName())) continue;
            PgColumn pgColumn2 = pgTable.getColumn(pgColumn.getName());
            String string3 = PgDiffUtils.getQuotedName(pgColumn.getName());
            if (!pgColumn2.getType().equals(pgColumn.getType())) {
                list.add("\tALTER COLUMN " + string3 + " TYPE " + pgColumn.getType() + " USING " + string3 + "::" + pgColumn.getType() + " /* " + MessageFormat.format(Resources.getString("TypeParameterChange"), pgTable2.getName(), pgColumn2.getType(), pgColumn.getType()) + " */");
            }
            String string4 = pgColumn2.getDefaultValue() == null ? "" : pgColumn2.getDefaultValue();
            String string5 = string2 = pgColumn.getDefaultValue() == null ? "" : pgColumn.getDefaultValue();
            if (!string4.equals(string2)) {
                if (string2.length() == 0) {
                    list.add("\tALTER COLUMN " + string3 + " DROP DEFAULT");
                } else {
                    list.add("\tALTER COLUMN " + string3 + " SET DEFAULT " + string2);
                }
            }
            if (pgColumn2.getNullValue() == pgColumn.getNullValue()) continue;
            if (pgColumn.getNullValue()) {
                list.add("\tALTER COLUMN " + string3 + " DROP NOT NULL");
                continue;
            }
            if (pgDiffArguments.isAddDefaults() && (string = PgColumnUtils.getDefaultValue(pgColumn.getType())) != null) {
                list.add("\tALTER COLUMN " + string3 + " SET DEFAULT " + string);
                list2.add(pgColumn);
            }
            list.add("\tALTER COLUMN " + string3 + " SET NOT NULL");
        }
    }

    private static void checkInherits(PrintWriter printWriter, PgTable pgTable, PgTable pgTable2, PgSchema pgSchema, SearchPathHelper searchPathHelper) {
        Object object;
        boolean bl;
        String string;
        String string2;
        for (Pair<String, String> pair : pgTable.getInherits()) {
            string2 = pair.getL();
            string = pair.getR();
            bl = false;
            for (Pair<String, String> pair2 : pgTable2.getInherits()) {
                if (!string2.equals(pair2.getL()) || !string.equals(pair2.getR())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            object = null;
            object = pgSchema.getName().equals(string2) ? PgDiffUtils.getQuotedName(string) : String.format("%s.%s", PgDiffUtils.getQuotedName(string2), PgDiffUtils.getQuotedName(string));
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println("ALTER TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.println("\tNO INHERIT " + (String)object + ';');
        }
        for (Pair<String, String> pair : pgTable2.getInherits()) {
            string2 = pair.getL();
            string = pair.getR();
            bl = false;
            for (Pair<String, String> pair2 : pgTable.getInherits()) {
                if (!string2.equals(pair2.getL()) || !string.equals(pair2.getR())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            object = null;
            object = pgSchema.getName().equals(string2) ? PgDiffUtils.getQuotedName(string) : String.format("%s.%s", PgDiffUtils.getQuotedName(string2), PgDiffUtils.getQuotedName(string));
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println("ALTER TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.println("\tINHERIT " + (String)object + ';');
        }
    }

    private static void addInheritedColumnDefaults(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgTable pgTable, PgTable pgTable2, SearchPathHelper searchPathHelper) {
        for (PgInheritedColumn pgInheritedColumn : pgTable2.getInheritedColumns()) {
            String string;
            if (!pgTable.containsInheritedColumn(pgInheritedColumn.getInheritedColumn().getName())) continue;
            PgInheritedColumn pgInheritedColumn2 = pgTable.getInheritedColumn(pgInheritedColumn.getInheritedColumn().getName());
            String string2 = PgDiffUtils.getQuotedName(pgInheritedColumn.getInheritedColumn().getName());
            String string3 = pgInheritedColumn2.getDefaultValue() == null ? "" : pgInheritedColumn2.getDefaultValue();
            if (string3.equals(string = pgInheritedColumn.getDefaultValue() == null ? "" : pgInheritedColumn.getDefaultValue())) continue;
            printWriter.println();
            printWriter.print("ALTER TABLE ONLY ");
            printWriter.println(PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.print("\tALTER COLUMN ");
            printWriter.print(PgDiffUtils.getQuotedName(pgInheritedColumn.getInheritedColumn().getName()));
            if (string.length() == 0) {
                printWriter.print(" DROP DEFAULT");
            } else {
                printWriter.print(" SET DEFAULT ");
                printWriter.print(string);
            }
            printWriter.println(";");
        }
    }

    private static void checkWithOIDS(PrintWriter printWriter, PgTable pgTable, PgTable pgTable2, SearchPathHelper searchPathHelper) {
        if (pgTable.getWith() == null && pgTable2.getWith() == null || pgTable.getWith() != null && pgTable.getWith().equals(pgTable2.getWith())) {
            return;
        }
        searchPathHelper.outputSearchPath(printWriter);
        printWriter.println();
        printWriter.println("ALTER TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()));
        if (pgTable2.getWith() == null || "OIDS=false".equalsIgnoreCase(pgTable2.getWith())) {
            printWriter.println("\tSET WITHOUT OIDS;");
        } else if ("OIDS".equalsIgnoreCase(pgTable2.getWith()) || "OIDS=true".equalsIgnoreCase(pgTable2.getWith())) {
            printWriter.println("\tSET WITH OIDS;");
        } else {
            printWriter.println("\tSET " + pgTable2.getWith() + ";");
        }
    }

    private static void checkTablespace(PrintWriter printWriter, PgTable pgTable, PgTable pgTable2, SearchPathHelper searchPathHelper) {
        if (pgTable.getTablespace() == null && pgTable2.getTablespace() == null || pgTable.getTablespace() != null && pgTable.getTablespace().equals(pgTable2.getTablespace())) {
            return;
        }
        searchPathHelper.outputSearchPath(printWriter);
        printWriter.println();
        printWriter.println("ALTER TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()));
        printWriter.println("\tTABLESPACE " + pgTable2.getTablespace() + ';');
    }

    public static void createTables(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgTable pgTable : pgSchema2.getTables()) {
            if (pgSchema != null && pgSchema.containsTable(pgTable.getName())) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgTable.getCreationSQL(pgSchema2));
            printWriter.println();
            if (pgTable.getOwnerTo() != null) {
                printWriter.println("ALTER TABLE " + PgDiffUtils.getQuotedName(pgTable.getName()) + " OWNER TO " + pgTable.getOwnerTo() + ";");
            }
            for (PgRelationPrivilege pgRelationPrivilege : pgTable.getPrivileges()) {
                printWriter.println("REVOKE ALL ON TABLE " + PgDiffUtils.getQuotedName(pgTable.getName()) + " FROM " + pgRelationPrivilege.getRoleName() + ";");
                if (!"".equals(pgRelationPrivilege.getPrivilegesSQL(true))) {
                    printWriter.println("GRANT " + pgRelationPrivilege.getPrivilegesSQL(true) + " ON TABLE " + PgDiffUtils.getQuotedName(pgTable.getName()) + " TO " + pgRelationPrivilege.getRoleName() + " WITH GRANT OPTION;");
                }
                if ("".equals(pgRelationPrivilege.getPrivilegesSQL(false))) continue;
                printWriter.println("GRANT " + pgRelationPrivilege.getPrivilegesSQL(false) + " ON TABLE " + PgDiffUtils.getQuotedName(pgTable.getName()) + " TO " + pgRelationPrivilege.getRoleName() + ";");
            }
            if (pgTable.hasRLSEnabled() != null && pgTable.hasRLSEnabled().booleanValue()) {
                printWriter.println("ALTER TABLE " + PgDiffUtils.getQuotedName(pgTable.getName()) + "  ENABLE ROW LEVEL SECURITY;");
            }
            if (pgTable.hasRLSForced() == null || !pgTable.hasRLSForced().booleanValue()) continue;
            printWriter.println("ALTER TABLE " + PgDiffUtils.getQuotedName(pgTable.getName()) + "  FORCE ROW LEVEL SECURITY;");
        }
    }

    public static void dropTables(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgTable pgTable : pgSchema.getTables()) {
            if (pgSchema2.containsTable(pgTable.getName())) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgTable.getDropSQL());
        }
    }

    private static void updateTableColumns(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgTable pgTable, PgTable pgTable2, SearchPathHelper searchPathHelper) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<PgColumn> arrayList2 = new ArrayList<PgColumn>();
        PgDiffTables.addDropTableColumns(arrayList, pgTable, pgTable2);
        PgDiffTables.addCreateTableColumns(arrayList, pgDiffArguments, pgTable, pgTable2, arrayList2);
        PgDiffTables.addModifyTableColumns(arrayList, pgDiffArguments, pgTable, pgTable2, arrayList2);
        if (!arrayList.isEmpty()) {
            int n;
            String string = PgDiffUtils.getQuotedName(pgTable2.getName());
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println("ALTER " + (pgTable2.isForeign() ? "FOREIGN " : "") + "TABLE " + string);
            for (n = 0; n < arrayList.size(); ++n) {
                printWriter.print((String)arrayList.get(n));
                printWriter.println(n + 1 < arrayList.size() ? "," : ";");
            }
            if (!arrayList2.isEmpty()) {
                printWriter.println();
                printWriter.println("ALTER " + (pgTable2.isForeign() ? "FOREIGN " : "") + "TABLE " + string);
                for (n = 0; n < arrayList2.size(); ++n) {
                    printWriter.print("\tALTER COLUMN ");
                    printWriter.print(PgDiffUtils.getQuotedName(((PgColumn)arrayList2.get(n)).getName()));
                    printWriter.print(" DROP DEFAULT");
                    printWriter.println(n + 1 < arrayList2.size() ? "," : ";");
                }
            }
        }
    }

    private static void alterPrivilegesColumns(PrintWriter printWriter, PgTable pgTable, PgTable pgTable2, SearchPathHelper searchPathHelper) {
        boolean bl = false;
        for (PgColumn pgColumn : pgTable2.getColumns()) {
            PgColumnPrivilege pgColumnPrivilege;
            PgColumn pgColumn2 = pgTable.getColumn(pgColumn.getName());
            if (pgColumn2 != null) {
                for (PgColumnPrivilege pgColumnPrivilege2 : pgColumn2.getPrivileges()) {
                    pgColumnPrivilege = pgColumn.getPrivilege(pgColumnPrivilege2.getRoleName());
                    if (pgColumnPrivilege != null) continue;
                    if (!bl) {
                        bl = true;
                        printWriter.println();
                    }
                    printWriter.println("REVOKE ALL (" + PgDiffUtils.getQuotedName(pgColumn.getName()) + ") ON TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()) + " FROM " + pgColumnPrivilege2.getRoleName() + ";");
                }
            }
            if (pgColumn == null) continue;
            for (PgColumnPrivilege pgColumnPrivilege2 : pgColumn.getPrivileges()) {
                pgColumnPrivilege = null;
                if (pgColumn2 != null) {
                    pgColumnPrivilege = pgColumn2.getPrivilege(pgColumnPrivilege2.getRoleName());
                }
                if (pgColumnPrivilege2.isSimilar(pgColumnPrivilege)) continue;
                if (!bl) {
                    bl = true;
                    printWriter.println();
                }
                printWriter.println("REVOKE ALL (" + PgDiffUtils.getQuotedName(pgColumn.getName()) + ") ON TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()) + " FROM " + pgColumnPrivilege2.getRoleName() + ";");
                if (!"".equals(pgColumnPrivilege2.getPrivilegesSQL(true, PgDiffUtils.getQuotedName(pgColumn.getName())))) {
                    printWriter.println("GRANT " + pgColumnPrivilege2.getPrivilegesSQL(true, PgDiffUtils.getQuotedName(pgColumn.getName())) + " ON TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()) + " TO " + pgColumnPrivilege2.getRoleName() + " WITH GRANT OPTION;");
                }
                if ("".equals(pgColumnPrivilege2.getPrivilegesSQL(false, PgDiffUtils.getQuotedName(pgColumn.getName())))) continue;
                printWriter.println("GRANT " + pgColumnPrivilege2.getPrivilegesSQL(false, PgDiffUtils.getQuotedName(pgColumn.getName())) + " ON TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()) + " TO " + pgColumnPrivilege2.getRoleName() + ";");
            }
        }
    }

    private static void alterComments(PrintWriter printWriter, PgTable pgTable, PgTable pgTable2, SearchPathHelper searchPathHelper) {
        if (pgTable.getComment() == null && pgTable2.getComment() != null || pgTable.getComment() != null && pgTable2.getComment() != null && !pgTable.getComment().equals(pgTable2.getComment())) {
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("COMMENT ON TABLE ");
            printWriter.print(PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.print(" IS ");
            printWriter.print(pgTable2.getComment());
            printWriter.println(';');
        } else if (pgTable.getComment() != null && pgTable2.getComment() == null) {
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("COMMENT ON TABLE ");
            printWriter.print(PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.println(" IS NULL;");
        }
        for (PgColumn pgColumn : pgTable2.getColumns()) {
            PgColumn pgColumn2 = pgTable.getColumn(pgColumn.getName());
            String string = pgColumn2 == null ? null : pgColumn2.getComment();
            String string2 = pgColumn.getComment();
            if (string2 != null && (string == null ? string2 != null : !string.equals(string2))) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("COMMENT ON COLUMN ");
                printWriter.print(PgDiffUtils.getQuotedName(pgTable2.getName()));
                printWriter.print('.');
                printWriter.print(PgDiffUtils.getQuotedName(pgColumn.getName()));
                printWriter.print(" IS ");
                printWriter.print(pgColumn.getComment());
                printWriter.println(';');
                continue;
            }
            if (string == null || string2 != null) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("COMMENT ON COLUMN ");
            printWriter.print(PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.print('.');
            printWriter.print(PgDiffUtils.getQuotedName(pgColumn.getName()));
            printWriter.println(" IS NULL;");
        }
    }

    private static void alterPrivileges(PrintWriter printWriter, PgTable pgTable, PgTable pgTable2, SearchPathHelper searchPathHelper) {
        PgRelationPrivilege pgRelationPrivilege;
        boolean bl = false;
        for (PgRelationPrivilege pgRelationPrivilege2 : pgTable.getPrivileges()) {
            pgRelationPrivilege = pgTable2.getPrivilege(pgRelationPrivilege2.getRoleName());
            if (pgRelationPrivilege == null) {
                if (!bl) {
                    bl = true;
                    printWriter.println();
                }
                printWriter.println("REVOKE ALL ON TABLE " + PgDiffUtils.getQuotedName(pgTable.getName()) + " FROM " + pgRelationPrivilege2.getRoleName() + ";");
                continue;
            }
            if (pgRelationPrivilege2.isSimilar(pgRelationPrivilege)) continue;
            if (!bl) {
                bl = true;
                printWriter.println();
            }
            printWriter.println("REVOKE ALL ON TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()) + " FROM " + pgRelationPrivilege.getRoleName() + ";");
            if (!"".equals(pgRelationPrivilege.getPrivilegesSQL(true))) {
                printWriter.println("GRANT " + pgRelationPrivilege.getPrivilegesSQL(true) + " ON TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()) + " TO " + pgRelationPrivilege.getRoleName() + " WITH GRANT OPTION;");
            }
            if ("".equals(pgRelationPrivilege.getPrivilegesSQL(false))) continue;
            printWriter.println("GRANT " + pgRelationPrivilege.getPrivilegesSQL(false) + " ON TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()) + " TO " + pgRelationPrivilege.getRoleName() + ";");
        }
        for (PgRelationPrivilege pgRelationPrivilege2 : pgTable2.getPrivileges()) {
            pgRelationPrivilege = pgTable.getPrivilege(pgRelationPrivilege2.getRoleName());
            if (pgRelationPrivilege != null) continue;
            if (!bl) {
                printWriter.println();
            }
            printWriter.println("REVOKE ALL ON TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()) + " FROM " + pgRelationPrivilege2.getRoleName() + ";");
            if (!"".equals(pgRelationPrivilege2.getPrivilegesSQL(true))) {
                printWriter.println("GRANT " + pgRelationPrivilege2.getPrivilegesSQL(true) + " ON TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()) + " TO " + pgRelationPrivilege2.getRoleName() + " WITH GRANT OPTION;");
            }
            if ("".equals(pgRelationPrivilege2.getPrivilegesSQL(false))) continue;
            printWriter.println("GRANT " + pgRelationPrivilege2.getPrivilegesSQL(false) + " ON TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()) + " TO " + pgRelationPrivilege2.getRoleName() + ";");
        }
    }

    private static void alterOwnerTo(PrintWriter printWriter, PgTable pgTable, PgTable pgTable2, SearchPathHelper searchPathHelper) {
        String string = pgTable.getOwnerTo();
        String string2 = pgTable2.getOwnerTo();
        if (string2 != null && !string2.equals(string)) {
            printWriter.println();
            printWriter.println("ALTER " + (pgTable2.isForeign() ? "FOREIGN " : "") + "TABLE " + PgDiffUtils.getQuotedName(pgTable2.getName()) + " OWNER TO " + pgTable2.getOwnerTo() + ";");
        }
    }

    private static void alterRLS(PrintWriter printWriter, PgTable pgTable, PgTable pgTable2, SearchPathHelper searchPathHelper) {
        if ((pgTable.hasRLSEnabled() == null || pgTable.hasRLSEnabled() != null && !pgTable.hasRLSEnabled().booleanValue()) && pgTable2.hasRLSEnabled() != null && pgTable2.hasRLSEnabled().booleanValue()) {
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("ALTER TABLE ");
            printWriter.print(PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.println(" ENABLE ROW LEVEL SECURITY;");
        }
        if (pgTable.hasRLSEnabled() != null && pgTable.hasRLSEnabled().booleanValue() && (pgTable2.hasRLSEnabled() == null || pgTable2.hasRLSEnabled() != null && !pgTable2.hasRLSEnabled().booleanValue())) {
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("ALTER TABLE ");
            printWriter.print(PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.println(" DISABLE ROW LEVEL SECURITY;");
        }
        if ((pgTable.hasRLSForced() == null || pgTable.hasRLSForced() != null && !pgTable.hasRLSForced().booleanValue()) && pgTable2.hasRLSForced() != null && pgTable2.hasRLSForced().booleanValue()) {
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("ALTER TABLE ");
            printWriter.print(PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.println(" FORCE ROW LEVEL SECURITY;");
        }
        if (pgTable.hasRLSForced() != null && pgTable.hasRLSForced().booleanValue() && (pgTable2.hasRLSForced() == null || pgTable2.hasRLSForced() != null && !pgTable2.hasRLSForced().booleanValue())) {
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("ALTER TABLE ");
            printWriter.print(PgDiffUtils.getQuotedName(pgTable2.getName()));
            printWriter.println(" NO FORCE ROW LEVEL SECURITY;");
        }
    }

    private PgDiffTables() {
    }
}

