/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgSequence;
import java.text.MessageFormat;

public class AlterSequenceParser {
    public static void parse(PgDatabase pgDatabase, String string, boolean bl) {
        Parser parser = new Parser(string);
        parser.expect("ALTER", "SEQUENCE");
        String string2 = parser.parseIdentifier();
        String string3 = ParserUtils.getSchemaName(string2, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string3);
        if (pgSchema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string3, string));
        }
        String string4 = ParserUtils.getObjectName(string2);
        PgSequence pgSequence = pgSchema.getSequence(string4);
        if (pgSequence == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSequence"), string2, string));
        }
        while (!parser.expectOptional(";")) {
            if (parser.expectOptional("OWNED", "BY")) {
                if (parser.expectOptional("NONE")) {
                    pgSequence.setOwnedBy(null);
                    continue;
                }
                pgSequence.setOwnedBy(parser.getExpression());
                continue;
            }
            parser.throwUnsupportedCommand();
        }
    }

    private AlterSequenceParser() {
    }
}

