COMMENT ON ACCESS METHOD rtree IS 'R-Tree access method'

COMMENT ON AGGREGATE my_aggregate (double precision) IS 'Computes sample variance'

COMMENT ON CAST (text AS int4) IS 'Allow casts from text to int4'

COMMENT ON COLLATION "fr_CA" IS 'Canadian French'

COMMENT ON COLUMN my_table.my_column IS 'Employee ID number'

COMMENT ON CONVERSION my_conv IS 'Conversion to UTF8'

COMMENT ON CONSTRAINT bar_col_cons ON bar IS 'Constrains column col'

COMMENT ON CONSTRAINT dom_col_constr ON DOMAIN dom IS 'Constrains col of domain'

COMMENT ON DATABASE my_database IS 'Development Database'

COMMENT ON DOMAIN my_domain IS 'Email Address Domain'

COMMENT ON EXTENSION hstore IS 'implements the hstore data type'

COMMENT ON FOREIGN DATA WRAPPER mywrapper IS 'my foreign data wrapper'

COMMENT ON FOREIGN TABLE my_foreign_table IS 'Employee Information in other database'

COMMENT ON FUNCTION my_function (timestamp) IS 'Returns Roman Numeral'

COMMENT ON INDEX my_index IS 'Enforces uniqueness on employee ID'

COMMENT ON LANGUAGE plpython IS 'Python support for stored procedures'

COMMENT ON LARGE OBJECT 346344 IS 'Planning document'

COMMENT ON MATERIALIZED VIEW my_matview IS 'Summary of order history'

COMMENT ON OPERATOR ^ (text, text) IS 'Performs intersection of two texts'

COMMENT ON OPERATOR - (NONE, integer) IS 'Unary minus'

COMMENT ON OPERATOR CLASS int4ops USING btree IS '4 byte integer operators for btrees'

COMMENT ON OPERATOR FAMILY integer_ops USING btree IS 'all integer operators for btrees'

COMMENT ON POLICY my_policy ON mytable IS 'Filter rows by users'

COMMENT ON ROLE my_role IS 'Administration group for finance tables'

COMMENT ON RULE my_rule ON my_table IS 'Logs updates of employee records'

COMMENT ON SCHEMA my_schema IS 'Departmental data'

COMMENT ON SEQUENCE my_sequence IS 'Used to generate primary keys'

COMMENT ON SERVER myserver IS 'my foreign server'

COMMENT ON STATISTICS my_statistics IS 'Improves planner row estimations'

COMMENT ON TABLE my_schema.my_table IS 'Employee Information'

COMMENT ON TABLESPACE my_tablespace IS 'Tablespace for indexes'

COMMENT ON TEXT SEARCH CONFIGURATION my_config IS 'Special word filtering'

COMMENT ON TEXT SEARCH DICTIONARY swedish IS 'Snowball stemmer for Swedish language'

COMMENT ON TEXT SEARCH PARSER my_parser IS 'Splits text into words'

COMMENT ON TEXT SEARCH TEMPLATE snowball IS 'Snowball stemmer'

COMMENT ON TRANSFORM FOR hstore LANGUAGE plpythonu
        IS 'Transform between hstore and Python dict'

COMMENT ON TRIGGER my_trigger ON my_table IS 'Used for RI'

COMMENT ON TYPE complex IS 'Complex number data type'

COMMENT ON VIEW my_view IS
  'Lorem ipsum dolor sit amet, consectetur adipisicing elit,'
  ' sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
  ' Ut enimad minim veniam, quis nostrud exercitation ullamco laboris.'
