/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.apache.maven.shared.utils.PathTool;
import org.apache.maven.shared.utils.ReaderFactory;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.IOUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

@Component(role=MavenResourcesFiltering.class, hint="default")
public class DefaultMavenResourcesFiltering
extends AbstractLogEnabled
implements MavenResourcesFiltering,
Initializable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private List<String> defaultNonFilteredFileExtensions;
    @Requirement
    private BuildContext buildContext;
    @Requirement
    private MavenFileFilter mavenFileFilter;

    public void initialize() throws InitializationException {
        this.defaultNonFilteredFileExtensions = new ArrayList<String>(5);
        this.defaultNonFilteredFileExtensions.add("jpg");
        this.defaultNonFilteredFileExtensions.add("jpeg");
        this.defaultNonFilteredFileExtensions.add("gif");
        this.defaultNonFilteredFileExtensions.add("bmp");
        this.defaultNonFilteredFileExtensions.add("png");
    }

    @Override
    public boolean filteredFileExtension(String fileName, List<String> userNonFilteredFileExtensions) {
        boolean filteredFileExtension;
        ArrayList<String> nonFilteredFileExtensions = new ArrayList<String>(this.getDefaultNonFilteredFileExtensions());
        if (userNonFilteredFileExtensions != null) {
            nonFilteredFileExtensions.addAll(userNonFilteredFileExtensions);
        }
        boolean bl = filteredFileExtension = !nonFilteredFileExtensions.contains(StringUtils.lowerCase((String)FileUtils.extension((String)fileName)));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("file " + fileName + " has a" + (filteredFileExtension ? " " : " non ") + "filtered file extension");
        }
        return filteredFileExtension;
    }

    @Override
    public List<String> getDefaultNonFilteredFileExtensions() {
        if (this.defaultNonFilteredFileExtensions == null) {
            this.defaultNonFilteredFileExtensions = new ArrayList<String>();
        }
        return this.defaultNonFilteredFileExtensions;
    }

    @Override
    public void filterResources(MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        if (mavenResourcesExecution == null) {
            throw new MavenFilteringException("mavenResourcesExecution cannot be null");
        }
        if (mavenResourcesExecution.getResources() == null) {
            this.getLogger().info("No resources configured skip copying/filtering");
            return;
        }
        if (mavenResourcesExecution.getOutputDirectory() == null) {
            throw new MavenFilteringException("outputDirectory cannot be null");
        }
        if (mavenResourcesExecution.isUseDefaultFilterWrappers()) {
            this.handleDefaultFilterWrappers(mavenResourcesExecution);
        }
        if (mavenResourcesExecution.getEncoding() == null || mavenResourcesExecution.getEncoding().length() < 1) {
            this.getLogger().warn("Using platform encoding (" + ReaderFactory.FILE_ENCODING + " actually) to copy filtered resources, i.e. build is platform dependent!");
        } else {
            this.getLogger().info("Using '" + mavenResourcesExecution.getEncoding() + "' encoding to copy filtered resources.");
        }
        for (Resource resource : mavenResourcesExecution.getResources()) {
            File destinationFile;
            if (this.getLogger().isDebugEnabled()) {
                String ls = System.getProperty("line.separator");
                StringBuilder debugMessage = new StringBuilder("resource with targetPath ").append(resource.getTargetPath()).append(ls);
                debugMessage.append("directory ").append(resource.getDirectory()).append(ls);
                debugMessage.append("excludes ").append(resource.getExcludes() == null ? " empty " : resource.getExcludes().toString()).append(ls);
                debugMessage.append("includes ").append(resource.getIncludes() == null ? " empty " : resource.getIncludes().toString());
                this.getLogger().debug(debugMessage.toString());
            }
            String targetPath = resource.getTargetPath();
            File resourceDirectory = new File(resource.getDirectory());
            if (!resourceDirectory.isAbsolute()) {
                resourceDirectory = new File(mavenResourcesExecution.getResourcesBaseDirectory(), resourceDirectory.getPath());
            }
            if (!resourceDirectory.exists()) {
                this.getLogger().info("skip non existing resourceDirectory " + resourceDirectory.getPath());
                continue;
            }
            File outputDirectory = mavenResourcesExecution.getOutputDirectory();
            boolean outputExists = outputDirectory.exists();
            if (!outputExists && !outputDirectory.mkdirs()) {
                throw new MavenFilteringException("Cannot create resource output directory: " + outputDirectory);
            }
            boolean ignoreDelta = !outputExists || this.buildContext.hasDelta(mavenResourcesExecution.getFileFilters()) || this.buildContext.hasDelta(this.getRelativeOutputDirectory(mavenResourcesExecution));
            this.getLogger().debug("ignoreDelta " + ignoreDelta);
            Scanner scanner = this.buildContext.newScanner(resourceDirectory, ignoreDelta);
            this.setupScanner(resource, scanner, mavenResourcesExecution.isAddDefaultExcludes());
            scanner.scan();
            if (mavenResourcesExecution.isIncludeEmptyDirs()) {
                try {
                    File targetDirectory = targetPath == null ? outputDirectory : new File(outputDirectory, targetPath);
                    this.copyDirectoryLayout(resourceDirectory, targetDirectory, scanner);
                }
                catch (IOException e) {
                    throw new MavenFilteringException("Cannot copy directory structure from " + resourceDirectory.getPath() + " to " + outputDirectory.getPath());
                }
            }
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            this.getLogger().info("Copying " + includedFiles.size() + " resource" + (includedFiles.size() > 1 ? "s" : "") + (targetPath == null ? "" : " to " + targetPath));
            for (String name : includedFiles) {
                this.getLogger().debug("Copying file " + name);
                File source = new File(resourceDirectory, name);
                destinationFile = this.getDestinationFile(outputDirectory, targetPath, name, mavenResourcesExecution);
                boolean filteredExt = this.filteredFileExtension(source.getName(), mavenResourcesExecution.getNonFilteredFileExtensions());
                this.mavenFileFilter.copyFile(source, destinationFile, resource.isFiltering() && filteredExt, mavenResourcesExecution.getFilterWrappers(), mavenResourcesExecution.getEncoding(), mavenResourcesExecution.isOverwrite());
            }
            scanner = this.buildContext.newDeleteScanner(resourceDirectory);
            this.setupScanner(resource, scanner, mavenResourcesExecution.isAddDefaultExcludes());
            scanner.scan();
            List<String> deletedFiles = Arrays.asList(scanner.getIncludedFiles());
            for (String name : deletedFiles) {
                destinationFile = this.getDestinationFile(outputDirectory, targetPath, name, mavenResourcesExecution);
                destinationFile.delete();
                this.buildContext.refresh(destinationFile);
            }
        }
    }

    private void handleDefaultFilterWrappers(MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        ArrayList<FileUtils.FilterWrapper> filterWrappers = new ArrayList<FileUtils.FilterWrapper>();
        if (mavenResourcesExecution.getFilterWrappers() != null) {
            filterWrappers.addAll(mavenResourcesExecution.getFilterWrappers());
        }
        filterWrappers.addAll(this.mavenFileFilter.getDefaultFilterWrappers(mavenResourcesExecution));
        mavenResourcesExecution.setFilterWrappers(filterWrappers);
    }

    private File getDestinationFile(File outputDirectory, String targetPath, String name, MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        File destinationFile;
        String destination = name;
        if (mavenResourcesExecution.isFilterFilenames() && mavenResourcesExecution.getFilterWrappers().size() > 0) {
            destination = this.filterFileName(destination, mavenResourcesExecution.getFilterWrappers());
        }
        if (targetPath != null) {
            destination = targetPath + "/" + destination;
        }
        if (!(destinationFile = new File(destination)).isAbsolute()) {
            destinationFile = new File(outputDirectory, destination);
        }
        if (!destinationFile.getParentFile().exists()) {
            destinationFile.getParentFile().mkdirs();
        }
        return destinationFile;
    }

    private String[] setupScanner(Resource resource, Scanner scanner, boolean addDefaultExcludes) {
        String[] includes = null;
        includes = resource.getIncludes() != null && !resource.getIncludes().isEmpty() ? resource.getIncludes().toArray(EMPTY_STRING_ARRAY) : DEFAULT_INCLUDES;
        scanner.setIncludes(includes);
        String[] excludes = null;
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            excludes = resource.getExcludes().toArray(EMPTY_STRING_ARRAY);
            scanner.setExcludes(excludes);
        }
        if (addDefaultExcludes) {
            scanner.addDefaultExcludes();
        }
        return includes;
    }

    private void copyDirectoryLayout(File sourceDirectory, File destinationDirectory, Scanner scanner) throws IOException {
        if (sourceDirectory == null) {
            throw new IOException("source directory can't be null.");
        }
        if (destinationDirectory == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        List<String> includedDirectories = Arrays.asList(scanner.getIncludedDirectories());
        for (String name : includedDirectories) {
            File source = new File(sourceDirectory, name);
            if (source.equals(sourceDirectory)) continue;
            File destination = new File(destinationDirectory, name);
            destination.mkdirs();
        }
    }

    private String getRelativeOutputDirectory(MavenResourcesExecution execution) {
        String relOutDir = execution.getOutputDirectory().getAbsolutePath();
        if (execution.getMavenProject() != null && execution.getMavenProject().getBasedir() != null) {
            String basedir = execution.getMavenProject().getBasedir().getAbsolutePath();
            relOutDir = PathTool.getRelativeFilePath((String)basedir, (String)relOutDir);
            relOutDir = relOutDir == null ? execution.getOutputDirectory().getPath() : relOutDir.replace('\\', '/');
        }
        return relOutDir;
    }

    private String filterFileName(String name, List<FileUtils.FilterWrapper> wrappers) throws MavenFilteringException {
        Reader reader = new StringReader(name);
        for (FileUtils.FilterWrapper wrapper : wrappers) {
            reader = wrapper.getReader(reader);
        }
        StringWriter writer = new StringWriter();
        try {
            IOUtil.copy((Reader)reader, (Writer)writer);
        }
        catch (IOException e) {
            throw new MavenFilteringException("Failed filtering filename" + name, e);
        }
        String filteredFilename = writer.toString();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("renaming filename " + name + " to " + filteredFilename);
        }
        return filteredFilename;
    }
}

