/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.LocalePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSLocale;

public final class LocalePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<LocalePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new LocalePrototypeBuiltins();

    protected LocalePrototypeBuiltins() {
        super("Locale.prototype", LocalePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, LocalePrototype builtinEnum) {
        switch (builtinEnum) {
            case maximize: {
                return LocalePrototypeBuiltinsFactory.JSLocaleMaximizeNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case minimize: {
                return LocalePrototypeBuiltinsFactory.JSLocaleMinimizeNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toString: {
                return LocalePrototypeBuiltinsFactory.JSLocaleToStringNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class JSLocaleToStringNode
    extends JSBuiltinNode {
        public JSLocaleToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public String doLocale(DynamicObject localeObject) {
            return JSLocale.getInternalState(localeObject).getLocale();
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public String doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleMinimizeNode
    extends JSBuiltinNode {
        public JSLocaleMinimizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            String minimizedLocale = JSLocale.getInternalState(localeObject).minimize();
            return JSFunction.construct(this.getContext().getRealm().getLocaleConstructor(), new Object[]{minimizedLocale});
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleMaximizeNode
    extends JSBuiltinNode {
        public JSLocaleMaximizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSLocale(localeObject)"})
        public Object doLocale(DynamicObject localeObject) {
            String maximizedLocale = JSLocale.getInternalState(localeObject).maximize();
            return JSFunction.construct(this.getContext().getRealm().getLocaleConstructor(), new Object[]{maximizedLocale});
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static enum LocalePrototype implements BuiltinEnum<LocalePrototype>
    {
        maximize(0),
        minimize(0),
        toString(0);

        private final int length;

        private LocalePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

