/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNodeGen;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.util.JSClassProfile;

public abstract class JSGetOwnPropertyNode
extends JavaScriptBaseNode {
    private final boolean needValue;
    private final boolean needEnumerability;
    private final boolean needConfigurability;
    private final boolean needWritability;
    final boolean allowCaching;
    @CompilerDirectives.CompilationFinal
    private boolean seenNonArrayIndex;
    private final ConditionProfile hasPropertyBranch = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isDataPropertyBranch = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isAccessorPropertyBranch = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isProxyPropertyBranch = ConditionProfile.createBinaryProfile();

    protected JSGetOwnPropertyNode(boolean needValue, boolean needEnumerability, boolean needConfigurability, boolean needWritability, boolean allowCaching) {
        this.needValue = needValue;
        this.needEnumerability = needEnumerability;
        this.needConfigurability = needConfigurability;
        this.needWritability = needWritability;
        this.allowCaching = allowCaching;
    }

    public static JSGetOwnPropertyNode create() {
        return JSGetOwnPropertyNode.create(true);
    }

    public static JSGetOwnPropertyNode create(boolean needValue) {
        return JSGetOwnPropertyNode.create(needValue, true, true, true, true);
    }

    public static JSGetOwnPropertyNode create(boolean needValue, boolean needEnumerability, boolean needConfigurability, boolean needWritability, boolean allowCaching) {
        return JSGetOwnPropertyNodeGen.create(needValue, needEnumerability, needConfigurability, needWritability, allowCaching);
    }

    public abstract PropertyDescriptor execute(DynamicObject var1, Object var2);

    @Specialization(guards={"isJSArray(thisObj)"})
    PropertyDescriptor array(DynamicObject thisObj, Object propertyKey, @Cached ToArrayIndexNode toArrayIndexNode, @Cached BranchProfile noSuchElementBranch, @Cached(value="createIdentityProfile()") ValueProfile typeProfile) {
        ScriptArray array;
        assert (JSRuntime.isPropertyKey(propertyKey));
        long idx = this.toArrayIndex(propertyKey, toArrayIndexNode);
        if (JSRuntime.isArrayIndex(idx) && (array = (ScriptArray)typeProfile.profile((Object)JSAbstractArray.arrayGetArrayType(thisObj, false))).hasElement(thisObj, idx)) {
            Object value = this.needValue ? array.getElement(thisObj, idx, JSArray.isJSArray(thisObj)) : null;
            return PropertyDescriptor.createData(value, true, this.needWritability && !array.isFrozen(), this.needConfigurability && !array.isSealed());
        }
        noSuchElementBranch.enter();
        Property prop = thisObj.getShape().getProperty(propertyKey);
        return this.ordinaryGetOwnProperty(thisObj, prop);
    }

    @Specialization(guards={"isJSString(thisObj)"})
    protected PropertyDescriptor getOwnPropertyString(DynamicObject thisObj, Object key, @Cached(value="createBinaryProfile()") ConditionProfile stringCaseProfile) {
        assert (JSRuntime.isPropertyKey(key));
        Property prop = thisObj.getShape().getProperty(key);
        PropertyDescriptor desc = this.ordinaryGetOwnProperty(thisObj, prop);
        if (stringCaseProfile.profile(desc == null)) {
            return JSString.stringGetIndexProperty(thisObj, key);
        }
        return desc;
    }

    @Specialization(guards={"allowCaching", "cachedJSClass != null", "cachedJSClass.isInstance(thisObj)", "cachedPropertyKey.equals(propertyKey)", "cachedShape == thisObj.getShape()"}, assumptions={"cachedShape.getValidAssumption()"}, limit="3")
    PropertyDescriptor cachedOrdinary(DynamicObject thisObj, Object propertyKey, @Cached(value="getJSClassIfOrdinary(thisObj)") JSClass cachedJSClass, @Cached(value="thisObj.getShape()") Shape cachedShape, @Cached(value="propertyKey") Object cachedPropertyKey, @Cached(value="cachedShape.getProperty(propertyKey)") Property cachedProperty) {
        assert (JSRuntime.isPropertyKey(propertyKey) && JSObject.getJSClass(thisObj).usesOrdinaryGetOwnProperty());
        return this.ordinaryGetOwnProperty(thisObj, cachedProperty);
    }

    @Specialization(guards={"usesOrdinaryGetOwnProperty.execute(thisObj)"}, replaces={"cachedOrdinary"}, limit="1")
    PropertyDescriptor uncachedOrdinary(DynamicObject thisObj, Object propertyKey, @Cached UsesOrdinaryGetOwnPropertyNode usesOrdinaryGetOwnProperty) {
        assert (JSRuntime.isPropertyKey(propertyKey) && JSObject.getJSClass(thisObj).usesOrdinaryGetOwnProperty());
        Property prop = thisObj.getShape().getProperty(propertyKey);
        return this.ordinaryGetOwnProperty(thisObj, prop);
    }

    static JSClass getJSClassIfOrdinary(DynamicObject obj) {
        JSClass jsclass = JSObject.getJSClass(obj);
        if (jsclass.usesOrdinaryGetOwnProperty()) {
            return jsclass;
        }
        return null;
    }

    private PropertyDescriptor ordinaryGetOwnProperty(DynamicObject thisObj, Property prop) {
        PropertyDescriptor d;
        assert (!JSProxy.isProxy(thisObj));
        if (this.hasPropertyBranch.profile(prop == null)) {
            return null;
        }
        if (this.isDataPropertyBranch.profile(JSProperty.isData(prop))) {
            Object value = this.needValue ? this.getDataPropertyValue(thisObj, prop) : null;
            d = PropertyDescriptor.createData(value);
            if (this.needWritability) {
                d.setWritable(JSProperty.isWritable(prop));
            }
        } else if (this.isAccessorPropertyBranch.profile(JSProperty.isAccessor(prop))) {
            if (this.needValue) {
                Accessor acc = (Accessor)prop.get(thisObj, false);
                d = PropertyDescriptor.createAccessor(acc.getGetter(), acc.getSetter());
            } else {
                d = PropertyDescriptor.createAccessor(null, null);
            }
        } else {
            d = PropertyDescriptor.createEmpty();
        }
        if (this.needEnumerability) {
            d.setEnumerable(JSProperty.isEnumerable(prop));
        }
        if (this.needConfigurability) {
            d.setConfigurable(JSProperty.isConfigurable(prop));
        }
        return d;
    }

    private Object getDataPropertyValue(DynamicObject thisObj, Property prop) {
        assert (JSProperty.isData(prop));
        Object value = prop.get(thisObj, false);
        if (this.isProxyPropertyBranch.profile(JSProperty.isProxy(prop))) {
            return ((PropertyProxy)value).get(thisObj);
        }
        return value;
    }

    @Specialization(guards={"!jsclassProfile.getJSClass(thisObj).usesOrdinaryGetOwnProperty()", "!isJSArray(thisObj)", "!isJSString(thisObj)"}, limit="1")
    static PropertyDescriptor generic(DynamicObject thisObj, Object key, @Cached(value="create()") JSClassProfile jsclassProfile) {
        return JSObject.getOwnProperty(thisObj, key, jsclassProfile);
    }

    private long toArrayIndex(Object propertyKey, ToArrayIndexNode toArrayIndexNode) {
        if (this.seenNonArrayIndex) {
            Object result = toArrayIndexNode.execute(propertyKey);
            return result instanceof Long ? (Long)result : -1L;
        }
        try {
            return toArrayIndexNode.executeLong(propertyKey);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.seenNonArrayIndex = true;
            return -1L;
        }
    }

    public static abstract class UsesOrdinaryGetOwnPropertyNode
    extends JavaScriptBaseNode {
        protected UsesOrdinaryGetOwnPropertyNode() {
        }

        public static UsesOrdinaryGetOwnPropertyNode create() {
            return JSGetOwnPropertyNodeGen.UsesOrdinaryGetOwnPropertyNodeGen.create();
        }

        public final boolean execute(DynamicObject object) {
            return this.execute(JSObject.getJSClass(object));
        }

        public abstract boolean execute(JSClass var1);

        @Specialization(guards={"jsclass == cachedJSClass"}, limit="3")
        static boolean doCached(JSClass jsclass, @Cached(value="jsclass") JSClass cachedJSClass) {
            return cachedJSClass.usesOrdinaryGetOwnProperty();
        }

        @Specialization(replaces={"doCached"})
        static boolean doObjectPrototype(JSClass jsclass) {
            return jsclass.usesOrdinaryGetOwnProperty();
        }
    }
}

