/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSPrepareThisNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSPrepareThisNode.class)
public final class JSPrepareThisNodeGen
extends JSPrepareThisNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private JSClass jSObjectCached_cachedClass_;

    private JSPrepareThisNodeGen(JSContext context, JavaScriptNode child) {
        super(context, child);
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        Object operandNodeValue_;
        int state = this.state_;
        if ((state & 1) != 0 && JSGuards.isNullOrUndefined(operandNodeValue)) {
            return this.doJSObject(operandNodeValue);
        }
        if ((state & 6) != 0 && JSTypes.isDynamicObject(operandNodeValue)) {
            operandNodeValue_ = (DynamicObject)operandNodeValue;
            if ((state & 2) != 0) {
                assert (this.jSObjectCached_cachedClass_ != null);
                if (this.jSObjectCached_cachedClass_.isInstance((DynamicObject)operandNodeValue_)) {
                    return this.doJSObjectCached((DynamicObject)operandNodeValue_, this.jSObjectCached_cachedClass_);
                }
            }
            if ((state & 4) != 0 && JSGuards.isJSObject(operandNodeValue_)) {
                return this.doJSObject((DynamicObject)operandNodeValue_);
            }
        }
        if ((state & 8) != 0 && operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_2 = (Boolean)operandNodeValue;
            return this.doBoolean(operandNodeValue_2);
        }
        if ((state & 0x10) != 0 && operandNodeValue instanceof JSLazyString) {
            operandNodeValue_ = (JSLazyString)operandNodeValue;
            return this.doJSLazyString((JSLazyString)operandNodeValue_);
        }
        if ((state & 0x20) != 0 && JSTypesGen.isImplicitString((state & 0xF000) >>> 12, operandNodeValue)) {
            operandNodeValue_ = JSTypesGen.asImplicitString((state & 0xF000) >>> 12, operandNodeValue);
            return this.doString((String)operandNodeValue_);
        }
        if ((state & 0x40) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_3 = (Integer)operandNodeValue;
            return this.doInt(operandNodeValue_3);
        }
        if ((state & 0x80) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0000) >>> 16, operandNodeValue)) {
            double operandNodeValue_4 = JSTypesGen.asImplicitDouble((state & 0xF0000) >>> 16, operandNodeValue);
            return this.doDouble(operandNodeValue_4);
        }
        if ((state & 0x100) != 0 && operandNodeValue instanceof BigInt) {
            operandNodeValue_ = (BigInt)operandNodeValue;
            return this.doBigInt((BigInt)operandNodeValue_);
        }
        if ((state & 0x200) != 0 && JSGuards.isJavaNumber(operandNodeValue)) {
            return this.doNumber(operandNodeValue);
        }
        if ((state & 0x400) != 0 && operandNodeValue instanceof Symbol) {
            operandNodeValue_ = (Symbol)operandNodeValue;
            return this.doSymbol((Symbol)operandNodeValue_);
        }
        if ((state & 0x800) != 0 && JSGuards.isForeignObject(operandNodeValue)) {
            return this.doForeignObject(operandNodeValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0xFF7) == 0 && (state & 0xFFF) != 0) {
            return this.execute_boolean0(frameValue, state);
        }
        if ((state & 0xFBF) == 0 && (state & 0xFFF) != 0) {
            return this.execute_int1(frameValue, state);
        }
        if ((state & 0xF7F) == 0 && (state & 0xFFF) != 0) {
            return this.execute_double2(frameValue, state);
        }
        return this.execute_generic3(frameValue, state);
    }

    private Object execute_boolean0(VirtualFrame frameValue, int state) {
        boolean operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 8) != 0);
        return this.doBoolean(operandNodeValue_);
    }

    private Object execute_int1(VirtualFrame frameValue, int state) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 0x40) != 0);
        return this.doInt(operandNodeValue_);
    }

    private Object execute_double2(VirtualFrame frameValue, int state) {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0xE0000) == 0 && (state & 0xFFF) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0xD0000) == 0 && (state & 0xFFF) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0xB0000) == 0 && (state & 0xFFF) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0xF0000) >>> 16, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 0x80) != 0);
        return this.doDouble(operandNodeValue_);
    }

    private Object execute_generic3(VirtualFrame frameValue, int state) {
        Object operandNodeValue__;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && JSGuards.isNullOrUndefined(operandNodeValue_)) {
            return this.doJSObject(operandNodeValue_);
        }
        if ((state & 6) != 0 && JSTypes.isDynamicObject(operandNodeValue_)) {
            operandNodeValue__ = (DynamicObject)operandNodeValue_;
            if ((state & 2) != 0) {
                assert (this.jSObjectCached_cachedClass_ != null);
                if (this.jSObjectCached_cachedClass_.isInstance((DynamicObject)operandNodeValue__)) {
                    return this.doJSObjectCached((DynamicObject)operandNodeValue__, this.jSObjectCached_cachedClass_);
                }
            }
            if ((state & 4) != 0 && JSGuards.isJSObject(operandNodeValue__)) {
                return this.doJSObject((DynamicObject)operandNodeValue__);
            }
        }
        if ((state & 8) != 0 && operandNodeValue_ instanceof Boolean) {
            boolean operandNodeValue__2 = (Boolean)operandNodeValue_;
            return this.doBoolean(operandNodeValue__2);
        }
        if ((state & 0x10) != 0 && operandNodeValue_ instanceof JSLazyString) {
            operandNodeValue__ = (JSLazyString)operandNodeValue_;
            return this.doJSLazyString((JSLazyString)operandNodeValue__);
        }
        if ((state & 0x20) != 0 && JSTypesGen.isImplicitString((state & 0xF000) >>> 12, operandNodeValue_)) {
            operandNodeValue__ = JSTypesGen.asImplicitString((state & 0xF000) >>> 12, operandNodeValue_);
            return this.doString((String)operandNodeValue__);
        }
        if ((state & 0x40) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__3 = (Integer)operandNodeValue_;
            return this.doInt(operandNodeValue__3);
        }
        if ((state & 0x80) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0000) >>> 16, operandNodeValue_)) {
            double operandNodeValue__4 = JSTypesGen.asImplicitDouble((state & 0xF0000) >>> 16, operandNodeValue_);
            return this.doDouble(operandNodeValue__4);
        }
        if ((state & 0x100) != 0 && operandNodeValue_ instanceof BigInt) {
            operandNodeValue__ = (BigInt)operandNodeValue_;
            return this.doBigInt((BigInt)operandNodeValue__);
        }
        if ((state & 0x200) != 0 && JSGuards.isJavaNumber(operandNodeValue_)) {
            return this.doNumber(operandNodeValue_);
        }
        if ((state & 0x400) != 0 && operandNodeValue_ instanceof Symbol) {
            operandNodeValue__ = (Symbol)operandNodeValue_;
            return this.doSymbol((Symbol)operandNodeValue__);
        }
        if ((state & 0x800) != 0 && JSGuards.isForeignObject(operandNodeValue_)) {
            return this.doForeignObject(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private Object executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            DynamicObject dynamicObject;
            Object operandNodeValue_;
            if (JSGuards.isNullOrUndefined(operandNodeValue)) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject2 = this.doJSObject(operandNodeValue);
                return dynamicObject2;
            }
            if (JSTypes.isDynamicObject(operandNodeValue)) {
                operandNodeValue_ = (DynamicObject)operandNodeValue;
                if (exclude == 0) {
                    JSClass jSObjectCached_cachedClass__;
                    boolean JSObjectCached_duplicateFound_ = false;
                    if ((state & 2) != 0) {
                        assert (this.jSObjectCached_cachedClass_ != null);
                        if (this.jSObjectCached_cachedClass_.isInstance((DynamicObject)operandNodeValue_)) {
                            JSObjectCached_duplicateFound_ = true;
                        }
                    }
                    if (!JSObjectCached_duplicateFound_ && (jSObjectCached_cachedClass__ = JSGuards.getJSClassIfObject(operandNodeValue_)) != null && jSObjectCached_cachedClass__.isInstance((DynamicObject)operandNodeValue_) && (state & 2) == 0) {
                        this.jSObjectCached_cachedClass_ = jSObjectCached_cachedClass__;
                        this.state_ = state |= 2;
                        JSObjectCached_duplicateFound_ = true;
                    }
                    if (JSObjectCached_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        dynamicObject = this.doJSObjectCached((DynamicObject)operandNodeValue_, this.jSObjectCached_cachedClass_);
                        return dynamicObject;
                    }
                }
                if (JSGuards.isJSObject(operandNodeValue_)) {
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFFD;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject JSObjectCached_duplicateFound_ = this.doJSObject((DynamicObject)operandNodeValue_);
                    return JSObjectCached_duplicateFound_;
                }
            }
            if (operandNodeValue instanceof Boolean) {
                boolean operandNodeValue_2 = (Boolean)operandNodeValue;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                DynamicObject JSObjectCached_duplicateFound_ = this.doBoolean(operandNodeValue_2);
                return JSObjectCached_duplicateFound_;
            }
            if (operandNodeValue instanceof JSLazyString) {
                operandNodeValue_ = (JSLazyString)operandNodeValue;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                DynamicObject JSObjectCached_duplicateFound_ = this.doJSLazyString((JSLazyString)operandNodeValue_);
                return JSObjectCached_duplicateFound_;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(operandNodeValue);
            if (stringCast0 != 0) {
                String operandNodeValue_3 = JSTypesGen.asImplicitString(stringCast0, operandNodeValue);
                state |= stringCast0 << 12;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                dynamicObject = this.doString(operandNodeValue_3);
                return dynamicObject;
            }
            if (operandNodeValue instanceof Integer) {
                int operandNodeValue_4 = (Integer)operandNodeValue;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                DynamicObject operandNodeValue_3 = this.doInt(operandNodeValue_4);
                return operandNodeValue_3;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue);
            if (doubleCast0 != 0) {
                double operandNodeValue_5 = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                state |= doubleCast0 << 16;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject3 = this.doDouble(operandNodeValue_5);
                return dynamicObject3;
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_6 = (BigInt)operandNodeValue;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject4 = this.doBigInt(operandNodeValue_6);
                return dynamicObject4;
            }
            if (JSGuards.isJavaNumber(operandNodeValue)) {
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                DynamicObject operandNodeValue_6 = this.doNumber(operandNodeValue);
                return operandNodeValue_6;
            }
            if (operandNodeValue instanceof Symbol) {
                Symbol operandNodeValue_7 = (Symbol)operandNodeValue;
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject5 = this.doSymbol(operandNodeValue_7);
                return dynamicObject5;
            }
            if (JSGuards.isForeignObject(operandNodeValue)) {
                this.state_ = state |= 0x800;
                lock.unlock();
                hasLock = false;
                Object object = this.doForeignObject(operandNodeValue);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode}, new Object[]{operandNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0xFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0xFFF & (state & 0xFFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[13];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doJSObject";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doJSObjectCached";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            ArrayList<List<JSClass>> cached = new ArrayList<List<JSClass>>();
            cached.add(Arrays.asList(this.jSObjectCached_cachedClass_));
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doJSLazyString";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        s[1] = (state & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSPrepareThisNode create(JSContext context, JavaScriptNode child) {
        return new JSPrepareThisNodeGen(context, child);
    }
}

