/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;

public abstract class PerformPromiseCombinatorNode
extends JavaScriptBaseNode {
    protected final JSContext context;
    @Node.Child
    private PropertyGetNode getResolve;
    @Node.Child
    private IsCallableNode isCallable;
    @Node.Child
    private IteratorStepNode iteratorStep;
    @Node.Child
    private IteratorValueNode iteratorValue;

    protected PerformPromiseCombinatorNode(JSContext context) {
        this.context = context;
        this.getResolve = PropertyGetNode.create("resolve", false, context);
        this.isCallable = IsCallableNode.create();
        this.iteratorStep = IteratorStepNode.create(context);
        this.iteratorValue = IteratorValueNode.create(context);
    }

    public abstract DynamicObject execute(IteratorRecord var1, DynamicObject var2, PromiseCapabilityRecord var3);

    protected final Object getPromiseResolve(DynamicObject constructor) {
        Object promiseResolve = this.getResolve.getValue(constructor);
        if (!this.isCallable.executeBoolean(promiseResolve)) {
            throw Errors.createTypeErrorNotAFunction(promiseResolve);
        }
        return promiseResolve;
    }

    protected final Object iteratorStepOrSetDone(IteratorRecord iteratorRecord) {
        Object next;
        try {
            next = this.iteratorStep.execute(iteratorRecord);
        }
        catch (Throwable error) {
            iteratorRecord.setDone(true);
            throw error;
        }
        return next;
    }

    protected final Object iteratorValueOrSetDone(IteratorRecord iteratorRecord, Object next) {
        Object nextValue;
        try {
            nextValue = this.iteratorValue.execute((DynamicObject)next);
        }
        catch (Throwable error) {
            iteratorRecord.setDone(true);
            throw error;
        }
        return nextValue;
    }
}

