/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java.adapter;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.runtime.java.adapter.JavaSuperAdapter;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JavaSuperAdapter.class)
final class JavaSuperAdapterGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private JavaSuperAdapterGen() {
    }

    static {
        LibraryExport.register(JavaSuperAdapter.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JavaSuperAdapter.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JavaSuperAdapter.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JavaSuperAdapter);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JavaSuperAdapter);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JavaSuperAdapter.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JavaSuperAdapter) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.js.runtime.java.adapter.JavaSuperAdapter'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof JavaSuperAdapter;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaSuperAdapter)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JavaSuperAdapter arg0Value = (JavaSuperAdapter)arg0Value_;
                return arg0Value.readMember(arg1Value, JavaSuperAdapter.NameCache.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.adapter));
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JavaSuperAdapter arg0Value = (JavaSuperAdapter)arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, JavaSuperAdapter.NameCache.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.adapter));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JavaSuperAdapter arg0Value = (JavaSuperAdapter)arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, JavaSuperAdapter.NameCache.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.adapter));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JavaSuperAdapter arg0Value = (JavaSuperAdapter)arg0Value_;
                return arg0Value.isMemberInvocable(arg1Value, JavaSuperAdapter.NameCache.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.adapter));
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JavaSuperAdapter)receiver).getMembers(includeInternal);
            }
        }

        @GeneratedBy(value=JavaSuperAdapter.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private InteropLibrary receiverAdapterInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private JavaSuperAdapter.NameCache cache;

            Cached(Object originalReceiver) {
                JavaSuperAdapter receiver = (JavaSuperAdapter)originalReceiver;
                this.receiverAdapterInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(receiver.adapter));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JavaSuperAdapter) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.js.runtime.java.adapter.JavaSuperAdapter'. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof JavaSuperAdapter)) {
                    return false;
                }
                return this.receiverAdapterInteropLibrary_.accepts(((JavaSuperAdapter)receiver).adapter);
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JavaSuperAdapter)receiver).hasMembers();
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JavaSuperAdapter arg0Value = (JavaSuperAdapter)arg0Value_;
                int state = this.state_;
                if ((state & 1) != 0) {
                    return arg0Value.readMember(arg1Value, this.cache, this.receiverAdapterInteropLibrary_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(JavaSuperAdapter arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.cache == null) {
                        this.cache = JavaSuperAdapter.NameCache.create();
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.readMember(arg1Value, this.cache, this.receiverAdapterInteropLibrary_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JavaSuperAdapter arg0Value = (JavaSuperAdapter)arg0Value_;
                int state = this.state_;
                if ((state & 2) != 0) {
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.cache, this.receiverAdapterInteropLibrary_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberNode_AndSpecialize(JavaSuperAdapter arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.cache == null) {
                        this.cache = JavaSuperAdapter.NameCache.create();
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.invokeMember(arg1Value, arg2Value, this.cache, this.receiverAdapterInteropLibrary_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JavaSuperAdapter arg0Value = (JavaSuperAdapter)arg0Value_;
                int state = this.state_;
                if ((state & 4) != 0) {
                    return arg0Value.isMemberReadable(arg1Value, this.cache, this.receiverAdapterInteropLibrary_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(JavaSuperAdapter arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.cache == null) {
                        this.cache = JavaSuperAdapter.NameCache.create();
                    }
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isMemberReadable(arg1Value, this.cache, this.receiverAdapterInteropLibrary_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JavaSuperAdapter arg0Value = (JavaSuperAdapter)arg0Value_;
                int state = this.state_;
                if ((state & 8) != 0) {
                    return arg0Value.isMemberInvocable(arg1Value, this.cache, this.receiverAdapterInteropLibrary_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberInvocableNode_AndSpecialize(JavaSuperAdapter arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.cache == null) {
                        this.cache = JavaSuperAdapter.NameCache.create();
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isMemberInvocable(arg1Value, this.cache, this.receiverAdapterInteropLibrary_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JavaSuperAdapter)receiver).getMembers(includeInternal);
            }
        }
    }
}

