/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.inject.Key;
import com.google.inject.internal.Errors;
import com.google.inject.internal.State;
import com.google.inject.internal.util.SourceProvider;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;

final class WeakKeySet {
    private Map<Key<?>, Multiset<Object>> backingMap;
    private final Object lock;
    private final Cache<State, Set<KeyAndSource>> evictionCache = CacheBuilder.newBuilder().weakKeys().removalListener((RemovalListener)new RemovalListener<State, Set<KeyAndSource>>(){

        public void onRemoval(RemovalNotification<State, Set<KeyAndSource>> notification) {
            Preconditions.checkState((boolean)RemovalCause.COLLECTED.equals((Object)notification.getCause()));
            WeakKeySet.this.cleanUpForCollectedState((Set)notification.getValue());
        }
    }).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpForCollectedState(Set<KeyAndSource> keysAndSources) {
        Object object = this.lock;
        synchronized (object) {
            for (KeyAndSource keyAndSource : keysAndSources) {
                Multiset<Object> set = this.backingMap.get(keyAndSource.key);
                if (set == null) continue;
                set.remove(keyAndSource.source);
                if (!set.isEmpty()) continue;
                this.backingMap.remove(keyAndSource.key);
            }
        }
    }

    WeakKeySet(Object lock) {
        this.lock = lock;
    }

    public void add(Key<?> key, State state, Object source) {
        LinkedHashMultiset sources;
        if (this.backingMap == null) {
            this.backingMap = Maps.newHashMap();
        }
        if (source instanceof Class || source == SourceProvider.UNKNOWN_SOURCE) {
            source = null;
        }
        if ((sources = this.backingMap.get(key)) == null) {
            sources = LinkedHashMultiset.create();
            this.backingMap.put(key, (Multiset<Object>)sources);
        }
        Object convertedSource = Errors.convert(source);
        sources.add(convertedSource);
        if (state.parent() != State.NONE) {
            Set keyAndSources = (Set)this.evictionCache.getIfPresent((Object)state);
            if (keyAndSources == null) {
                keyAndSources = Sets.newHashSet();
                this.evictionCache.put((Object)state, (Object)keyAndSources);
            }
            keyAndSources.add(new KeyAndSource(key, convertedSource));
        }
    }

    public boolean contains(Key<?> key) {
        this.evictionCache.cleanUp();
        return this.backingMap != null && this.backingMap.containsKey(key);
    }

    public Set<Object> getSources(Key<?> key) {
        this.evictionCache.cleanUp();
        Multiset<Object> sources = this.backingMap == null ? null : this.backingMap.get(key);
        return sources == null ? null : sources.elementSet();
    }

    private static boolean isMultiBinderKey(Key<?> key) {
        Annotation annotation = key.getAnnotation();
        return annotation != null && "com.google.inject.multibindings.RealElement".equals(annotation.getClass().getName());
    }

    private static final class KeyAndSource {
        final Key<?> key;
        final Object source;

        KeyAndSource(Key<?> key, Object source) {
            this.key = key;
            this.source = source;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.key, this.source});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof KeyAndSource)) {
                return false;
            }
            KeyAndSource other = (KeyAndSource)obj;
            return Objects.equal(this.key, other.key) && Objects.equal((Object)this.source, (Object)other.source);
        }
    }
}

