/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.stream;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.booterclient.output.DeserializedStacktraceWriter;
import org.apache.maven.surefire.api.booter.Constants;
import org.apache.maven.surefire.api.booter.ForkedProcessEventType;
import org.apache.maven.surefire.api.event.ConsoleDebugEvent;
import org.apache.maven.surefire.api.event.ConsoleErrorEvent;
import org.apache.maven.surefire.api.event.ConsoleInfoEvent;
import org.apache.maven.surefire.api.event.ConsoleWarningEvent;
import org.apache.maven.surefire.api.event.ControlByeEvent;
import org.apache.maven.surefire.api.event.ControlNextTestEvent;
import org.apache.maven.surefire.api.event.ControlStopOnNextTestEvent;
import org.apache.maven.surefire.api.event.Event;
import org.apache.maven.surefire.api.event.JvmExitErrorEvent;
import org.apache.maven.surefire.api.event.StandardStreamErrEvent;
import org.apache.maven.surefire.api.event.StandardStreamErrWithNewLineEvent;
import org.apache.maven.surefire.api.event.StandardStreamOutEvent;
import org.apache.maven.surefire.api.event.StandardStreamOutWithNewLineEvent;
import org.apache.maven.surefire.api.event.SystemPropertyEvent;
import org.apache.maven.surefire.api.event.TestAssumptionFailureEvent;
import org.apache.maven.surefire.api.event.TestErrorEvent;
import org.apache.maven.surefire.api.event.TestFailedEvent;
import org.apache.maven.surefire.api.event.TestSkippedEvent;
import org.apache.maven.surefire.api.event.TestStartingEvent;
import org.apache.maven.surefire.api.event.TestSucceededEvent;
import org.apache.maven.surefire.api.event.TestsetCompletedEvent;
import org.apache.maven.surefire.api.event.TestsetStartingEvent;
import org.apache.maven.surefire.api.fork.ForkNodeArguments;
import org.apache.maven.surefire.api.report.CategorizedReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.api.stream.AbstractStreamDecoder;
import org.apache.maven.surefire.api.stream.SegmentType;
import org.apache.maven.surefire.shared.utils.cli.ShutdownHookUtils;

public class EventDecoder
extends AbstractStreamDecoder<Event, ForkedProcessEventType, SegmentType> {
    private static final int DEBUG_SINK_BUFFER_SIZE = 65536;
    private static final Map<AbstractStreamDecoder.Segment, ForkedProcessEventType> EVENT_TYPES = EventDecoder.segmentsToEvents();
    private static final Map<AbstractStreamDecoder.Segment, RunMode> RUN_MODES = EventDecoder.segmentsToRunModes();
    private static final SegmentType[] EVENT_WITHOUT_DATA = new SegmentType[]{SegmentType.END_OF_FRAME};
    private static final SegmentType[] EVENT_WITH_ERROR_TRACE = new SegmentType[]{SegmentType.STRING_ENCODING, SegmentType.DATA_STRING, SegmentType.DATA_STRING, SegmentType.DATA_STRING, SegmentType.END_OF_FRAME};
    private static final SegmentType[] EVENT_WITH_ONE_STRING = new SegmentType[]{SegmentType.STRING_ENCODING, SegmentType.DATA_STRING, SegmentType.END_OF_FRAME};
    private static final SegmentType[] EVENT_WITH_RUNMODE_TID_AND_ONE_STRING = new SegmentType[]{SegmentType.RUN_MODE, SegmentType.TEST_RUN_ID, SegmentType.STRING_ENCODING, SegmentType.DATA_STRING, SegmentType.END_OF_FRAME};
    private static final SegmentType[] EVENT_WITH_RUNMODE_TID_AND_TWO_STRINGS = new SegmentType[]{SegmentType.RUN_MODE, SegmentType.TEST_RUN_ID, SegmentType.STRING_ENCODING, SegmentType.DATA_STRING, SegmentType.DATA_STRING, SegmentType.END_OF_FRAME};
    private static final SegmentType[] EVENT_TEST_CONTROL = new SegmentType[]{SegmentType.RUN_MODE, SegmentType.TEST_RUN_ID, SegmentType.STRING_ENCODING, SegmentType.DATA_STRING, SegmentType.DATA_STRING, SegmentType.DATA_STRING, SegmentType.DATA_STRING, SegmentType.DATA_STRING, SegmentType.DATA_STRING, SegmentType.DATA_INTEGER, SegmentType.DATA_STRING, SegmentType.DATA_STRING, SegmentType.DATA_STRING, SegmentType.END_OF_FRAME};
    private static final int NO_POSITION = -1;
    private final OutputStream debugSink;

    public EventDecoder(@Nonnull ReadableByteChannel channel, @Nonnull ForkNodeArguments arguments) {
        super(channel, arguments, EVENT_TYPES);
        this.debugSink = this.newDebugSink(arguments);
    }

    public Event decode(@Nonnull AbstractStreamDecoder.Memento memento) throws IOException {
        try {
            ForkedProcessEventType eventType = (ForkedProcessEventType)this.readMessageType(memento);
            if (eventType == null) {
                throw new AbstractStreamDecoder.MalformedFrameException(memento.getLine().getPositionByteBuffer(), memento.getByteBuffer().position());
            }
            block18: for (SegmentType segmentType : this.nextSegmentType(eventType)) {
                switch (segmentType) {
                    case RUN_MODE: {
                        memento.getData().add(RUN_MODES.get(this.readSegment(memento)));
                        continue block18;
                    }
                    case TEST_RUN_ID: {
                        memento.getData().add(this.readLong(memento));
                        continue block18;
                    }
                    case STRING_ENCODING: {
                        memento.setCharset(this.readCharset(memento));
                        continue block18;
                    }
                    case DATA_STRING: {
                        memento.getData().add(this.readString(memento));
                        continue block18;
                    }
                    case DATA_INTEGER: {
                        memento.getData().add(this.readInteger(memento));
                        continue block18;
                    }
                    case END_OF_FRAME: {
                        memento.getLine().setPositionByteBuffer(memento.getByteBuffer().position());
                        memento.getLine().clear();
                        Event event = this.toMessage(eventType, memento);
                        return event;
                    }
                    default: {
                        memento.getLine().setPositionByteBuffer(-1);
                        this.getArguments().dumpStreamText("Unknown enum (" + SegmentType.class.getSimpleName() + ") " + segmentType);
                    }
                }
            }
        }
        catch (AbstractStreamDecoder.MalformedFrameException e) {
            if (e.hasValidPositions()) {
                int length = e.readTo() - e.readFrom();
                memento.getLine().write(memento.getByteBuffer(), e.readFrom(), length);
            }
            Event event = null;
            return event;
        }
        catch (RuntimeException e) {
            this.getArguments().dumpStreamException((Throwable)e);
            SegmentType[] segmentTypeArray = null;
            return segmentTypeArray;
        }
        catch (IOException e) {
            if (!(e.getCause() instanceof InterruptedException)) {
                this.printRemainingStream(memento);
            }
            throw e;
        }
        finally {
            memento.reset();
        }
        throw new IOException("unreachable statement");
    }

    @Nonnull
    protected final byte[] getEncodedMagicNumber() {
        return Constants.MAGIC_NUMBER_FOR_EVENTS_BYTES;
    }

    @Nonnull
    protected final SegmentType[] nextSegmentType(@Nonnull ForkedProcessEventType eventType) {
        switch (eventType) {
            case BOOTERCODE_BYE: 
            case BOOTERCODE_STOP_ON_NEXT_TEST: 
            case BOOTERCODE_NEXT_TEST: {
                return EVENT_WITHOUT_DATA;
            }
            case BOOTERCODE_CONSOLE_ERROR: 
            case BOOTERCODE_JVM_EXIT_ERROR: {
                return EVENT_WITH_ERROR_TRACE;
            }
            case BOOTERCODE_CONSOLE_INFO: 
            case BOOTERCODE_CONSOLE_DEBUG: 
            case BOOTERCODE_CONSOLE_WARNING: {
                return EVENT_WITH_ONE_STRING;
            }
            case BOOTERCODE_STDOUT: 
            case BOOTERCODE_STDOUT_NEW_LINE: 
            case BOOTERCODE_STDERR: 
            case BOOTERCODE_STDERR_NEW_LINE: {
                return EVENT_WITH_RUNMODE_TID_AND_ONE_STRING;
            }
            case BOOTERCODE_SYSPROPS: {
                return EVENT_WITH_RUNMODE_TID_AND_TWO_STRINGS;
            }
            case BOOTERCODE_TESTSET_STARTING: 
            case BOOTERCODE_TESTSET_COMPLETED: 
            case BOOTERCODE_TEST_STARTING: 
            case BOOTERCODE_TEST_SUCCEEDED: 
            case BOOTERCODE_TEST_FAILED: 
            case BOOTERCODE_TEST_SKIPPED: 
            case BOOTERCODE_TEST_ERROR: 
            case BOOTERCODE_TEST_ASSUMPTIONFAILURE: {
                return EVENT_TEST_CONTROL;
            }
        }
        throw new IllegalArgumentException("Unknown enum " + eventType);
    }

    @Nonnull
    protected final Event toMessage(@Nonnull ForkedProcessEventType eventType, @Nonnull AbstractStreamDecoder.Memento memento) throws AbstractStreamDecoder.MalformedFrameException {
        switch (eventType) {
            case BOOTERCODE_BYE: {
                this.checkArguments(memento, 0);
                return new ControlByeEvent();
            }
            case BOOTERCODE_STOP_ON_NEXT_TEST: {
                this.checkArguments(memento, 0);
                return new ControlStopOnNextTestEvent();
            }
            case BOOTERCODE_NEXT_TEST: {
                this.checkArguments(memento, 0);
                return new ControlNextTestEvent();
            }
            case BOOTERCODE_JVM_EXIT_ERROR: {
                this.checkArguments(memento, 3);
                return new JvmExitErrorEvent(EventDecoder.toStackTraceWriter(memento.getData()));
            }
            case BOOTERCODE_CONSOLE_ERROR: {
                this.checkArguments(memento, 3);
                return new ConsoleErrorEvent(EventDecoder.toStackTraceWriter(memento.getData()));
            }
            case BOOTERCODE_CONSOLE_INFO: {
                this.checkArguments(memento, 1);
                return new ConsoleInfoEvent((String)memento.getData().get(0));
            }
            case BOOTERCODE_CONSOLE_DEBUG: {
                this.checkArguments(memento, 1);
                return new ConsoleDebugEvent((String)memento.getData().get(0));
            }
            case BOOTERCODE_CONSOLE_WARNING: {
                this.checkArguments(memento, 1);
                return new ConsoleWarningEvent((String)memento.getData().get(0));
            }
            case BOOTERCODE_STDOUT: {
                this.checkArguments(memento, 3);
                return new StandardStreamOutEvent((RunMode)memento.ofDataAt(0), (Long)memento.ofDataAt(1), (String)memento.ofDataAt(2));
            }
            case BOOTERCODE_STDOUT_NEW_LINE: {
                this.checkArguments(memento, 3);
                return new StandardStreamOutWithNewLineEvent((RunMode)memento.ofDataAt(0), (Long)memento.ofDataAt(1), (String)memento.ofDataAt(2));
            }
            case BOOTERCODE_STDERR: {
                this.checkArguments(memento, 3);
                return new StandardStreamErrEvent((RunMode)memento.ofDataAt(0), (Long)memento.ofDataAt(1), (String)memento.ofDataAt(2));
            }
            case BOOTERCODE_STDERR_NEW_LINE: {
                this.checkArguments(memento, 3);
                return new StandardStreamErrWithNewLineEvent((RunMode)memento.ofDataAt(0), (Long)memento.ofDataAt(1), (String)memento.ofDataAt(2));
            }
            case BOOTERCODE_SYSPROPS: {
                this.checkArguments(memento, 4);
                return new SystemPropertyEvent((RunMode)memento.ofDataAt(0), (Long)memento.ofDataAt(1), (String)memento.ofDataAt(2), (String)memento.ofDataAt(3));
            }
            case BOOTERCODE_TESTSET_STARTING: {
                this.checkArguments(memento, 12);
                return new TestsetStartingEvent(EventDecoder.toReportEntry(memento.getData()));
            }
            case BOOTERCODE_TESTSET_COMPLETED: {
                this.checkArguments(memento, 12);
                return new TestsetCompletedEvent(EventDecoder.toReportEntry(memento.getData()));
            }
            case BOOTERCODE_TEST_STARTING: {
                this.checkArguments(memento, 12);
                return new TestStartingEvent((ReportEntry)EventDecoder.toReportEntry(memento.getData()));
            }
            case BOOTERCODE_TEST_SUCCEEDED: {
                this.checkArguments(memento, 12);
                return new TestSucceededEvent((ReportEntry)EventDecoder.toReportEntry(memento.getData()));
            }
            case BOOTERCODE_TEST_FAILED: {
                this.checkArguments(memento, 12);
                return new TestFailedEvent((ReportEntry)EventDecoder.toReportEntry(memento.getData()));
            }
            case BOOTERCODE_TEST_SKIPPED: {
                this.checkArguments(memento, 12);
                return new TestSkippedEvent((ReportEntry)EventDecoder.toReportEntry(memento.getData()));
            }
            case BOOTERCODE_TEST_ERROR: {
                this.checkArguments(memento, 12);
                return new TestErrorEvent((ReportEntry)EventDecoder.toReportEntry(memento.getData()));
            }
            case BOOTERCODE_TEST_ASSUMPTIONFAILURE: {
                this.checkArguments(memento, 12);
                return new TestAssumptionFailureEvent((ReportEntry)EventDecoder.toReportEntry(memento.getData()));
            }
        }
        throw new IllegalArgumentException("Missing a branch for the event type " + eventType);
    }

    @Nonnull
    private static TestSetReportEntry toReportEntry(List<Object> args) {
        RunMode runMode = (RunMode)args.get(0);
        long testRunId = (Long)args.get(1);
        String source = (String)args.get(2);
        String sourceText = (String)args.get(3);
        String name = (String)args.get(4);
        String nameText = (String)args.get(5);
        String group = (String)args.get(6);
        String message = (String)args.get(7);
        Integer timeElapsed = (Integer)args.get(8);
        String traceMessage = (String)args.get(9);
        String smartTrimmedStackTrace = (String)args.get(10);
        String stackTrace = (String)args.get(11);
        return EventDecoder.newReportEntry(runMode, testRunId, source, sourceText, name, nameText, group, message, timeElapsed, traceMessage, smartTrimmedStackTrace, stackTrace);
    }

    private static StackTraceWriter toStackTraceWriter(List<Object> args) {
        String traceMessage = (String)args.get(0);
        String smartTrimmedStackTrace = (String)args.get(1);
        String stackTrace = (String)args.get(2);
        return EventDecoder.toTrace(traceMessage, smartTrimmedStackTrace, stackTrace);
    }

    private static StackTraceWriter toTrace(String traceMessage, String smartTrimmedStackTrace, String stackTrace) {
        boolean exists = traceMessage != null || stackTrace != null || smartTrimmedStackTrace != null;
        return exists ? new DeserializedStacktraceWriter(traceMessage, smartTrimmedStackTrace, stackTrace) : null;
    }

    static TestSetReportEntry newReportEntry(RunMode runMode, long testRunId, String source, String sourceText, String name, String nameText, String group, String message, Integer timeElapsed, String traceMessage, String smartTrimmedStackTrace, String stackTrace) throws NumberFormatException {
        StackTraceWriter stackTraceWriter = EventDecoder.toTrace(traceMessage, smartTrimmedStackTrace, stackTrace);
        return CategorizedReportEntry.reportEntry((RunMode)runMode, (Long)testRunId, (String)source, (String)sourceText, (String)name, (String)nameText, (String)group, (StackTraceWriter)stackTraceWriter, (Integer)timeElapsed, (String)message, Collections.emptyMap());
    }

    private static Map<AbstractStreamDecoder.Segment, ForkedProcessEventType> segmentsToEvents() {
        HashMap<AbstractStreamDecoder.Segment, ForkedProcessEventType> events = new HashMap<AbstractStreamDecoder.Segment, ForkedProcessEventType>();
        for (ForkedProcessEventType event : ForkedProcessEventType.values()) {
            byte[] array = event.getOpcodeBinary();
            events.put(new AbstractStreamDecoder.Segment(array, 0, array.length), event);
        }
        return events;
    }

    private static Map<AbstractStreamDecoder.Segment, RunMode> segmentsToRunModes() {
        HashMap<AbstractStreamDecoder.Segment, RunMode> runModes = new HashMap<AbstractStreamDecoder.Segment, RunMode>();
        for (RunMode runMode : RunMode.values()) {
            byte[] array = runMode.getRunmodeBinary();
            runModes.put(new AbstractStreamDecoder.Segment(array, 0, array.length), runMode);
        }
        return runModes;
    }

    protected void debugStream(byte[] array, int position, int remaining) {
        if (this.debugSink == null) {
            return;
        }
        try {
            this.debugSink.write(array, position, remaining);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private OutputStream newDebugSink(ForkNodeArguments arguments) {
        File sink = arguments.getEventStreamBinaryFile();
        if (sink == null) {
            return null;
        }
        try {
            FileOutputStream fos = new FileOutputStream(sink, true);
            BufferedOutputStream os = new BufferedOutputStream(fos, 65536);
            ShutdownHookUtils.addShutDownHook((Thread)new Thread(new FutureTask<Object>(() -> {
                os.close();
                return null;
            })));
            return os;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public void close() throws IOException {
        if (this.debugSink != null) {
            this.debugSink.close();
        }
    }
}

