/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;

public class PluginHelpGenerator
extends AbstractLogEnabled
implements Generator {
    private static final String HELP_MOJO_CLASS_NAME = "HelpMojo";
    private static final String HELP_PROPERTIES_FILENAME = "maven-plugin-help.properties";
    private static final String HELP_GOAL = "help";
    private String helpPackageName;
    private boolean useAnnotations;
    private VelocityComponent velocityComponent;

    public PluginHelpGenerator() {
        this.enableLogging((Logger)new ConsoleLogger(1, "PluginHelpGenerator"));
    }

    @Override
    public void execute(File destinationDirectory, PluginToolsRequest request) throws GeneratorException {
        MojoDescriptor descriptor;
        PluginDescriptor pluginDescriptor = request.getPluginDescriptor();
        String helpImplementation = this.getImplementation(pluginDescriptor);
        List mojoDescriptors = pluginDescriptor.getMojos();
        if (mojoDescriptors != null && (descriptor = pluginDescriptor.getMojo(HELP_GOAL)) != null && !descriptor.getImplementation().equals(helpImplementation)) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("\n\nA help goal (" + descriptor.getImplementation() + ") already exists in this plugin. SKIPPED THE " + helpImplementation + " GENERATION.\n");
            }
            return;
        }
        this.writeHelpPropertiesFile(request, destinationDirectory);
        this.useAnnotations = request.getProject().getArtifactMap().containsKey("org.apache.maven.plugin-tools:maven-plugin-annotations");
        try {
            String sourcePath = helpImplementation.replace('.', File.separatorChar) + ".java";
            File helpClass = new File(destinationDirectory, sourcePath);
            helpClass.getParentFile().mkdirs();
            String helpClassSources = this.getHelpClassSources(PluginHelpGenerator.getPluginHelpPath(request.getProject()), pluginDescriptor);
            FileUtils.fileWrite((File)helpClass, (String)request.getEncoding(), (String)helpClassSources);
        }
        catch (IOException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
    }

    public PluginHelpGenerator setHelpPackageName(String helpPackageName) {
        this.helpPackageName = helpPackageName;
        return this;
    }

    public VelocityComponent getVelocityComponent() {
        return this.velocityComponent;
    }

    public PluginHelpGenerator setVelocityComponent(VelocityComponent velocityComponent) {
        this.velocityComponent = velocityComponent;
        return this;
    }

    private String getHelpClassSources(String pluginHelpPath, PluginDescriptor pluginDescriptor) throws IOException {
        Properties properties = new Properties();
        VelocityContext context = new VelocityContext((Map)properties);
        if (this.helpPackageName != null) {
            properties.put("helpPackageName", this.helpPackageName);
        } else {
            properties.put("helpPackageName", "");
        }
        properties.put("pluginHelpPath", pluginHelpPath);
        properties.put("artifactId", pluginDescriptor.getArtifactId());
        properties.put("goalPrefix", pluginDescriptor.getGoalPrefix());
        properties.put("useAnnotations", (Object)this.useAnnotations);
        StringWriter stringWriter = new StringWriter();
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("help-class-source.vm");
             InputStreamReader isReader = new InputStreamReader(is, "UTF-8");){
            this.velocityComponent.getEngine().evaluate((Context)context, (Writer)stringWriter, "", (Reader)isReader);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    private String getImplementation(PluginDescriptor pluginDescriptor) {
        if (StringUtils.isEmpty((String)this.helpPackageName)) {
            this.helpPackageName = GeneratorUtils.discoverPackageName(pluginDescriptor);
        }
        return StringUtils.isEmpty((String)this.helpPackageName) ? HELP_MOJO_CLASS_NAME : this.helpPackageName + '.' + HELP_MOJO_CLASS_NAME;
    }

    private void writeHelpPropertiesFile(PluginToolsRequest request, File destinationDirectory) throws GeneratorException {
        Properties properties = new Properties();
        properties.put("helpPackageName", this.helpPackageName == null ? "" : this.helpPackageName);
        properties.put("destinationDirectory", destinationDirectory.getAbsolutePath());
        File tmpPropertiesFile = new File(request.getProject().getBuild().getDirectory(), HELP_PROPERTIES_FILENAME);
        if (tmpPropertiesFile.exists()) {
            tmpPropertiesFile.delete();
        } else if (!tmpPropertiesFile.getParentFile().exists()) {
            tmpPropertiesFile.getParentFile().mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(tmpPropertiesFile);){
            properties.store(fos, "maven plugin help mojo generation informations");
        }
        catch (IOException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
    }

    static String getPluginHelpPath(MavenProject mavenProject) {
        return "META-INF/maven/" + mavenProject.getGroupId() + "/" + mavenProject.getArtifactId() + "/plugin-help.xml";
    }

    static void rewriteHelpMojo(PluginToolsRequest request, Log log) throws GeneratorException {
        File tmpPropertiesFile = new File(request.getProject().getBuild().getDirectory(), HELP_PROPERTIES_FILENAME);
        if (!tmpPropertiesFile.exists()) {
            return;
        }
        Properties properties = PropertyUtils.loadProperties((File)tmpPropertiesFile);
        String helpPackageName = properties.getProperty("helpPackageName");
        if (StringUtils.isEmpty((String)helpPackageName)) {
            File destinationDirectory;
            String destDir = properties.getProperty("destinationDirectory");
            if (StringUtils.isEmpty((String)destDir)) {
                log.warn((CharSequence)"\n\nUnexpected situation: destinationDirectory not defined in maven-plugin-help.properties during help mojo source generation but expected during XML descriptor generation.");
                log.warn((CharSequence)"Please check helpmojo goal version used in previous build phase.");
                log.warn((CharSequence)"If you just upgraded to plugin-tools >= 3.2 you must run a clean build at least once.");
                destinationDirectory = new File("target/generated-sources/plugin");
                log.warn((CharSequence)("Trying default location: " + destinationDirectory));
            } else {
                destinationDirectory = new File(destDir);
            }
            String helpMojoImplementation = PluginHelpGenerator.rewriteHelpClassToMojoPackage(request, destinationDirectory, log);
            if (helpMojoImplementation != null) {
                PluginHelpGenerator.updateHelpMojoDescriptor(request.getPluginDescriptor(), helpMojoImplementation);
            }
        }
    }

    private static String rewriteHelpClassToMojoPackage(PluginToolsRequest request, File destinationDirectory, Log log) throws GeneratorException {
        ClassReader cr;
        Object sourceWriter;
        String destinationPackage = GeneratorUtils.discoverPackageName(request.getPluginDescriptor());
        if (StringUtils.isEmpty((String)destinationPackage)) {
            return null;
        }
        String packageAsDirectory = StringUtils.replace((String)destinationPackage, (char)'.', (char)'/');
        String outputDirectory = request.getProject().getBuild().getOutputDirectory();
        File helpClassFile = new File(outputDirectory, "HelpMojo.class");
        if (!helpClassFile.exists()) {
            return null;
        }
        File helpSourceFile = new File(destinationDirectory, "HelpMojo.java");
        if (!helpSourceFile.exists()) {
            log.warn((CharSequence)("HelpMojo.java not found in default location: " + helpSourceFile.getAbsolutePath()));
            log.warn((CharSequence)("Help goal source won't be moved to package: " + destinationPackage));
        } else {
            File helpSourceFileNew = new File(destinationDirectory, packageAsDirectory + '/' + HELP_MOJO_CLASS_NAME + ".java");
            if (!helpSourceFileNew.getParentFile().exists()) {
                helpSourceFileNew.getParentFile().mkdirs();
            }
            try (InputStreamReader sourceReader = new InputStreamReader((InputStream)new FileInputStream(helpSourceFile), request.getEncoding());){
                sourceWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(helpSourceFileNew), request.getEncoding()));
                Throwable throwable = null;
                try {
                    ((PrintWriter)sourceWriter).println("package " + destinationPackage + ";");
                    IOUtil.copy((Reader)sourceReader, (Writer)sourceWriter);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (sourceWriter != null) {
                        if (throwable != null) {
                            try {
                                ((PrintWriter)sourceWriter).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((PrintWriter)sourceWriter).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new GeneratorException(e.getMessage(), e);
            }
            helpSourceFileNew.setLastModified(helpSourceFile.lastModified());
            helpSourceFile.delete();
        }
        File rewriteHelpClassFile = new File(outputDirectory + '/' + packageAsDirectory, "HelpMojo.class");
        if (!rewriteHelpClassFile.getParentFile().exists()) {
            rewriteHelpClassFile.getParentFile().mkdirs();
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(helpClassFile);
            sourceWriter = null;
            try {
                cr = new ClassReader((InputStream)fileInputStream);
            }
            catch (Throwable throwable) {
                sourceWriter = throwable;
                throw throwable;
            }
            finally {
                if (fileInputStream != null) {
                    if (sourceWriter != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)sourceWriter).addSuppressed(throwable);
                        }
                    } else {
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
        ClassWriter cw = new ClassWriter(0);
        SimpleRemapper packageRemapper = new SimpleRemapper(HELP_MOJO_CLASS_NAME, packageAsDirectory + '/' + HELP_MOJO_CLASS_NAME);
        ClassRemapper cv = new ClassRemapper((ClassVisitor)cw, (Remapper)packageRemapper);
        try {
            cr.accept((ClassVisitor)cv, 8);
        }
        catch (Throwable e) {
            throw new GeneratorException("ASM issue processing class-file " + helpClassFile.getPath(), e);
        }
        byte[] renamedClass = cw.toByteArray();
        try (FileOutputStream fos = new FileOutputStream(rewriteHelpClassFile);){
            fos.write(renamedClass);
        }
        catch (IOException e) {
            throw new GeneratorException("Error rewriting help class: " + e.getMessage(), e);
        }
        helpClassFile.delete();
        return destinationPackage + ".HelpMojo";
    }

    private static void updateHelpMojoDescriptor(PluginDescriptor pluginDescriptor, String helpMojoImplementation) {
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(HELP_GOAL);
        if (mojoDescriptor != null) {
            mojoDescriptor.setImplementation(helpMojoImplementation);
        }
    }
}

