/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.plugin.surefire.report.FileReporterUtils;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.Utf8RecodingDeferredFileOutputStream;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.extensions.StatelessReportEventListener;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.xml.PrettyPrintXMLWriter;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.xml.XMLWriter;
import org.apache.maven.surefire.util.internal.StringUtils;

public class StatelessXmlReporter
implements StatelessReportEventListener<WrappedReportEntry, TestSetStats> {
    private final File reportsDirectory;
    private final String reportNameSuffix;
    private final boolean trimStackTrace;
    private final int rerunFailingTestsCount;
    private final String xsdSchemaLocation;
    private final String xsdVersion;
    private final Map<String, Deque<WrappedReportEntry>> testClassMethodRunHistoryMap;
    private final boolean phrasedFileName;
    private final boolean phrasedSuiteName;
    private final boolean phrasedClassName;
    private final boolean phrasedMethodName;

    public StatelessXmlReporter(File reportsDirectory, String reportNameSuffix, boolean trimStackTrace, int rerunFailingTestsCount, Map<String, Deque<WrappedReportEntry>> testClassMethodRunHistoryMap, String xsdSchemaLocation, String xsdVersion, boolean phrasedFileName, boolean phrasedSuiteName, boolean phrasedClassName, boolean phrasedMethodName) {
        this.reportsDirectory = reportsDirectory;
        this.reportNameSuffix = reportNameSuffix;
        this.trimStackTrace = trimStackTrace;
        this.rerunFailingTestsCount = rerunFailingTestsCount;
        this.testClassMethodRunHistoryMap = testClassMethodRunHistoryMap;
        this.xsdSchemaLocation = xsdSchemaLocation;
        this.xsdVersion = xsdVersion;
        this.phrasedFileName = phrasedFileName;
        this.phrasedSuiteName = phrasedSuiteName;
        this.phrasedClassName = phrasedClassName;
        this.phrasedMethodName = phrasedMethodName;
    }

    public void testSetCompleted(WrappedReportEntry testSetReportEntry, TestSetStats testSetStats) {
        Map<String, Map<String, List<WrappedReportEntry>>> classMethodStatistics = this.arrangeMethodStatistics(testSetReportEntry, testSetStats);
        OutputStream outputStream = this.getOutputStream(testSetReportEntry);
        try (OutputStreamWriter fw = StatelessXmlReporter.getWriter(outputStream);){
            PrettyPrintXMLWriter ppw = new PrettyPrintXMLWriter(fw);
            ppw.setEncoding(StandardCharsets.UTF_8.name());
            this.createTestSuiteElement(ppw, testSetReportEntry, testSetStats);
            StatelessXmlReporter.showProperties(ppw, testSetReportEntry.getSystemProperties());
            for (Map.Entry<String, Map<String, List<WrappedReportEntry>>> statistics : classMethodStatistics.entrySet()) {
                for (Map.Entry<String, List<WrappedReportEntry>> thisMethodRuns : statistics.getValue().entrySet()) {
                    this.serializeTestClass(outputStream, fw, ppw, thisMethodRuns.getValue());
                }
            }
            ppw.endElement();
        }
        catch (Exception e) {
            InPluginProcessDumpSingleton.getSingleton().dumpException(e, e.getLocalizedMessage(), this.reportsDirectory);
        }
    }

    private Map<String, Map<String, List<WrappedReportEntry>>> arrangeMethodStatistics(WrappedReportEntry testSetReportEntry, TestSetStats testSetStats) {
        LinkedHashMap<String, Map<String, List<WrappedReportEntry>>> classMethodStatistics = new LinkedHashMap<String, Map<String, List<WrappedReportEntry>>>();
        for (WrappedReportEntry methodEntry : this.aggregateCacheFromMultipleReruns(testSetReportEntry, testSetStats)) {
            String methodName;
            ArrayList<WrappedReportEntry> methodRuns;
            String testClassName = methodEntry.getSourceName();
            LinkedHashMap<String, ArrayList<WrappedReportEntry>> stats = (LinkedHashMap<String, ArrayList<WrappedReportEntry>>)classMethodStatistics.get(testClassName);
            if (stats == null) {
                stats = new LinkedHashMap<String, ArrayList<WrappedReportEntry>>();
                classMethodStatistics.put(testClassName, stats);
            }
            if ((methodRuns = (ArrayList<WrappedReportEntry>)stats.get(methodName = methodEntry.getName())) == null) {
                methodRuns = new ArrayList<WrappedReportEntry>();
                stats.put(methodName, methodRuns);
            }
            methodRuns.add(methodEntry);
        }
        return classMethodStatistics;
    }

    private Deque<WrappedReportEntry> aggregateCacheFromMultipleReruns(WrappedReportEntry testSetReportEntry, TestSetStats testSetStats) {
        String suiteClassName = testSetReportEntry.getSourceName();
        Deque<WrappedReportEntry> methodRunHistory = this.getAddMethodRunHistoryMap(suiteClassName);
        methodRunHistory.addAll(testSetStats.getReportEntries());
        return methodRunHistory;
    }

    private void serializeTestClass(OutputStream outputStream, OutputStreamWriter fw, XMLWriter ppw, List<WrappedReportEntry> methodEntries) {
        if (this.rerunFailingTestsCount > 0) {
            this.serializeTestClassWithRerun(outputStream, fw, ppw, methodEntries);
        } else {
            this.serializeTestClassWithoutRerun(outputStream, fw, ppw, methodEntries);
        }
    }

    private void serializeTestClassWithoutRerun(OutputStream outputStream, OutputStreamWriter fw, XMLWriter ppw, List<WrappedReportEntry> methodEntries) {
        for (WrappedReportEntry methodEntry : methodEntries) {
            this.startTestElement(ppw, methodEntry);
            if (methodEntry.getReportEntryType() != ReportEntryType.SUCCESS) {
                StatelessXmlReporter.getTestProblems(fw, ppw, methodEntry, this.trimStackTrace, outputStream, methodEntry.getReportEntryType().getXmlTag(), false);
                StatelessXmlReporter.createOutErrElements(fw, ppw, methodEntry, outputStream);
            }
            ppw.endElement();
        }
    }

    private void serializeTestClassWithRerun(OutputStream outputStream, OutputStreamWriter fw, XMLWriter ppw, List<WrappedReportEntry> methodEntries) {
        WrappedReportEntry firstMethodEntry = methodEntries.get(0);
        switch (this.getTestResultType(methodEntries)) {
            case success: {
                for (WrappedReportEntry methodEntry : methodEntries) {
                    if (methodEntry.getReportEntryType() != ReportEntryType.SUCCESS) continue;
                    this.startTestElement(ppw, methodEntry);
                    ppw.endElement();
                }
                break;
            }
            case error: 
            case failure: {
                this.startTestElement(ppw, firstMethodEntry);
                boolean firstRun = true;
                for (WrappedReportEntry singleRunEntry : methodEntries) {
                    if (firstRun) {
                        firstRun = false;
                        StatelessXmlReporter.getTestProblems(fw, ppw, singleRunEntry, this.trimStackTrace, outputStream, singleRunEntry.getReportEntryType().getXmlTag(), false);
                        StatelessXmlReporter.createOutErrElements(fw, ppw, singleRunEntry, outputStream);
                        continue;
                    }
                    StatelessXmlReporter.getTestProblems(fw, ppw, singleRunEntry, this.trimStackTrace, outputStream, singleRunEntry.getReportEntryType().getRerunXmlTag(), true);
                }
                ppw.endElement();
                break;
            }
            case flake: {
                WrappedReportEntry successful = null;
                for (WrappedReportEntry singleRunEntry : methodEntries) {
                    if (singleRunEntry.getReportEntryType() != ReportEntryType.SUCCESS) continue;
                    successful = singleRunEntry;
                    break;
                }
                WrappedReportEntry firstOrSuccessful = successful == null ? methodEntries.get(0) : successful;
                this.startTestElement(ppw, firstOrSuccessful);
                for (WrappedReportEntry singleRunEntry : methodEntries) {
                    if (singleRunEntry.getReportEntryType() == ReportEntryType.SUCCESS) continue;
                    StatelessXmlReporter.getTestProblems(fw, ppw, singleRunEntry, this.trimStackTrace, outputStream, singleRunEntry.getReportEntryType().getFlakyXmlTag(), true);
                }
                ppw.endElement();
                break;
            }
            case skipped: {
                this.startTestElement(ppw, firstMethodEntry);
                StatelessXmlReporter.getTestProblems(fw, ppw, firstMethodEntry, this.trimStackTrace, outputStream, firstMethodEntry.getReportEntryType().getXmlTag(), false);
                ppw.endElement();
                break;
            }
            default: {
                throw new IllegalStateException("Get unknown test result type");
            }
        }
    }

    public void cleanTestHistoryMap() {
        this.testClassMethodRunHistoryMap.clear();
    }

    private DefaultReporterFactory.TestResultType getTestResultType(List<WrappedReportEntry> methodEntryList) {
        ArrayList<ReportEntryType> testResultTypeList = new ArrayList<ReportEntryType>();
        for (WrappedReportEntry singleRunEntry : methodEntryList) {
            testResultTypeList.add(singleRunEntry.getReportEntryType());
        }
        return DefaultReporterFactory.getTestResultType(testResultTypeList, this.rerunFailingTestsCount);
    }

    private Deque<WrappedReportEntry> getAddMethodRunHistoryMap(String testClassName) {
        Deque<WrappedReportEntry> methodRunHistory = this.testClassMethodRunHistoryMap.get(testClassName);
        if (methodRunHistory == null) {
            methodRunHistory = new ConcurrentLinkedDeque<WrappedReportEntry>();
            this.testClassMethodRunHistoryMap.put(testClassName == null ? "null" : testClassName, methodRunHistory);
        }
        return methodRunHistory;
    }

    private OutputStream getOutputStream(WrappedReportEntry testSetReportEntry) {
        File reportFile = this.getReportFile(testSetReportEntry);
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        try {
            return new BufferedOutputStream(new FileOutputStream(reportFile), 65536);
        }
        catch (Exception e) {
            throw new ReporterException("When writing report", e);
        }
    }

    private static OutputStreamWriter getWriter(OutputStream fos) {
        return new OutputStreamWriter(fos, StandardCharsets.UTF_8);
    }

    private File getReportFile(WrappedReportEntry report) {
        String reportName = "TEST-" + (this.phrasedFileName ? report.getReportSourceName() : report.getSourceName());
        String customizedReportName = StringUtils.isBlank((String)this.reportNameSuffix) ? reportName : reportName + "-" + this.reportNameSuffix;
        return new File(this.reportsDirectory, FileReporterUtils.stripIllegalFilenameChars(customizedReportName + ".xml"));
    }

    private void startTestElement(XMLWriter ppw, WrappedReportEntry report) {
        String className;
        ppw.startElement("testcase");
        String name = this.phrasedMethodName ? report.getReportName() : report.getName();
        ppw.addAttribute("name", name == null ? "" : StatelessXmlReporter.extraEscapeAttribute(name));
        if (report.getGroup() != null) {
            ppw.addAttribute("group", report.getGroup());
        }
        String string = className = this.phrasedClassName ? report.getReportSourceName(this.reportNameSuffix) : report.getSourceName(this.reportNameSuffix);
        if (className != null) {
            ppw.addAttribute("classname", StatelessXmlReporter.extraEscapeAttribute(className));
        }
        ppw.addAttribute("time", report.elapsedTimeAsString());
    }

    private void createTestSuiteElement(XMLWriter ppw, WrappedReportEntry report, TestSetStats testSetStats) {
        ppw.startElement("testsuite");
        ppw.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        ppw.addAttribute("xsi:noNamespaceSchemaLocation", this.xsdSchemaLocation);
        ppw.addAttribute("version", this.xsdVersion);
        String reportName = this.phrasedSuiteName ? report.getReportSourceName(this.reportNameSuffix) : report.getSourceName(this.reportNameSuffix);
        ppw.addAttribute("name", reportName == null ? "" : StatelessXmlReporter.extraEscapeAttribute(reportName));
        if (report.getGroup() != null) {
            ppw.addAttribute("group", report.getGroup());
        }
        ppw.addAttribute("time", report.elapsedTimeAsString());
        ppw.addAttribute("tests", String.valueOf(testSetStats.getCompletedCount()));
        ppw.addAttribute("errors", String.valueOf(testSetStats.getErrors()));
        ppw.addAttribute("skipped", String.valueOf(testSetStats.getSkipped()));
        ppw.addAttribute("failures", String.valueOf(testSetStats.getFailures()));
    }

    private static void getTestProblems(OutputStreamWriter outputStreamWriter, XMLWriter ppw, WrappedReportEntry report, boolean trimStackTrace, OutputStream fw, String testErrorType, boolean createOutErrElementsInside) {
        SafeThrowable t;
        ppw.startElement(testErrorType);
        String stackTrace = report.getStackTrace(trimStackTrace);
        if (report.getMessage() != null && !report.getMessage().isEmpty()) {
            ppw.addAttribute("message", StatelessXmlReporter.extraEscapeAttribute(report.getMessage()));
        }
        if (report.getStackTraceWriter() != null && (t = report.getStackTraceWriter().getThrowable()) != null) {
            if (t.getMessage() != null) {
                int delimiter = stackTrace.indexOf(":");
                String type = delimiter == -1 ? stackTrace : stackTrace.substring(0, delimiter);
                ppw.addAttribute("type", type);
            } else {
                ppw.addAttribute("type", new StringTokenizer(stackTrace).nextToken());
            }
        }
        boolean hasNestedElements = createOutErrElementsInside & stackTrace != null;
        if (stackTrace != null) {
            if (hasNestedElements) {
                ppw.startElement("stackTrace");
            }
            StatelessXmlReporter.extraEscapeElementValue(stackTrace, outputStreamWriter, ppw, fw);
            if (hasNestedElements) {
                ppw.endElement();
            }
        }
        if (createOutErrElementsInside) {
            StatelessXmlReporter.createOutErrElements(outputStreamWriter, ppw, report, fw);
        }
        ppw.endElement();
    }

    private static void createOutErrElements(OutputStreamWriter outputStreamWriter, XMLWriter ppw, WrappedReportEntry report, OutputStream fw) {
        EncodingOutputStream eos = new EncodingOutputStream(fw);
        StatelessXmlReporter.addOutputStreamElement(outputStreamWriter, eos, ppw, report.getStdout(), "system-out");
        StatelessXmlReporter.addOutputStreamElement(outputStreamWriter, eos, ppw, report.getStdErr(), "system-err");
    }

    private static void addOutputStreamElement(OutputStreamWriter outputStreamWriter, EncodingOutputStream eos, XMLWriter xmlWriter, Utf8RecodingDeferredFileOutputStream utf8RecodingDeferredFileOutputStream, String name) {
        if (utf8RecodingDeferredFileOutputStream != null && utf8RecodingDeferredFileOutputStream.getByteCount() > 0L) {
            xmlWriter.startElement(name);
            try {
                xmlWriter.writeText("");
                outputStreamWriter.flush();
                utf8RecodingDeferredFileOutputStream.close();
                eos.getUnderlying().write(ByteConstantsHolder.CDATA_START_BYTES);
                utf8RecodingDeferredFileOutputStream.writeTo(eos);
                eos.getUnderlying().write(ByteConstantsHolder.CDATA_END_BYTES);
                eos.flush();
            }
            catch (IOException e) {
                throw new ReporterException("When writing xml report stdout/stderr", (Exception)e);
            }
            xmlWriter.endElement();
        }
    }

    private static void showProperties(XMLWriter xmlWriter, Map<String, String> systemProperties) {
        xmlWriter.startElement("properties");
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = "null";
            }
            xmlWriter.startElement("property");
            xmlWriter.addAttribute("name", key);
            xmlWriter.addAttribute("value", StatelessXmlReporter.extraEscapeAttribute(value));
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    private static String extraEscapeAttribute(String message) {
        return StatelessXmlReporter.containsEscapesIllegalXml10(message) ? StatelessXmlReporter.escapeXml(message, true) : message;
    }

    private static void extraEscapeElementValue(String message, OutputStreamWriter outputStreamWriter, XMLWriter xmlWriter, OutputStream fw) {
        if (StatelessXmlReporter.containsEscapesIllegalXml10(message)) {
            xmlWriter.writeText(StatelessXmlReporter.escapeXml(message, false));
        } else {
            try {
                EncodingOutputStream eos = new EncodingOutputStream(fw);
                xmlWriter.writeText("");
                outputStreamWriter.flush();
                eos.getUnderlying().write(ByteConstantsHolder.CDATA_START_BYTES);
                eos.write(message.getBytes(StandardCharsets.UTF_8));
                eos.getUnderlying().write(ByteConstantsHolder.CDATA_END_BYTES);
                eos.flush();
            }
            catch (IOException e) {
                throw new ReporterException("When writing xml element", (Exception)e);
            }
        }
    }

    private static boolean containsEscapesIllegalXml10(String message) {
        int size = message.length();
        for (int i = 0; i < size; ++i) {
            if (!StatelessXmlReporter.isIllegalEscape(message.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isIllegalEscape(char c) {
        return StatelessXmlReporter.isIllegalEscape((int)c);
    }

    private static boolean isIllegalEscape(int c) {
        return c >= 0 && c < 32 && c != 10 && c != 13 && c != 9;
    }

    private static String escapeXml(String text, boolean attribute) {
        StringBuilder sb = new StringBuilder(text.length() * 2);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (StatelessXmlReporter.isIllegalEscape(c)) {
                sb.append(attribute ? "&#" : "&amp#").append((int)c).append(';');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static final class ByteConstantsHolder {
        private static final byte[] CDATA_START_BYTES = "<![CDATA[".getBytes(StandardCharsets.UTF_8);
        private static final byte[] CDATA_END_BYTES = "]]>".getBytes(StandardCharsets.UTF_8);
        private static final byte[] CDATA_ESCAPE_STRING_BYTES = "]]><![CDATA[>".getBytes(StandardCharsets.UTF_8);
        private static final byte[] AMP_BYTES = "&amp#".getBytes(StandardCharsets.UTF_8);

        private ByteConstantsHolder() {
        }
    }

    private static final class EncodingOutputStream
    extends FilterOutputStream {
        private int c1;
        private int c2;

        EncodingOutputStream(OutputStream out) {
            super(out);
        }

        OutputStream getUnderlying() {
            return this.out;
        }

        private boolean isCdataEndBlock(int c) {
            return this.c1 == 93 && this.c2 == 93 && c == 62;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.isCdataEndBlock(b)) {
                this.out.write(ByteConstantsHolder.CDATA_ESCAPE_STRING_BYTES);
            } else if (StatelessXmlReporter.isIllegalEscape(b)) {
                this.out.write(ByteConstantsHolder.AMP_BYTES);
                this.out.write(String.valueOf(b).getBytes(StandardCharsets.UTF_8));
                this.out.write(59);
            } else {
                this.out.write(b);
            }
            this.c1 = this.c2;
            this.c2 = b;
        }
    }
}

