/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.aether.spi.io.FileProcessor;

@Component(role=FileProcessor.class)
public class DefaultFileProcessor
implements FileProcessor {
    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (this.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copy(File src, File target, FileProcessor.ProgressListener listener) throws IOException {
        long l;
        RandomAccessFile in = null;
        RandomAccessFile out = null;
        try {
            in = new RandomAccessFile(src, "r");
            this.mkdirs(target.getParentFile());
            out = new RandomAccessFile(target, "rw");
            FileChannel outChannel = out.getChannel();
            out.setLength(0L);
            WritableByteChannel realChannel = outChannel;
            if (listener != null) {
                realChannel = new ProgressingChannel(outChannel, listener);
            }
            l = DefaultFileProcessor.copy(in.getChannel(), realChannel);
        }
        catch (Throwable throwable) {
            DefaultFileProcessor.close(in);
            DefaultFileProcessor.close(out);
            throw throwable;
        }
        DefaultFileProcessor.close(in);
        DefaultFileProcessor.close(out);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(FileChannel src, WritableByteChannel target) throws IOException {
        long total = 0L;
        try {
            long size = src.size();
            long chunk = 67076096L;
            while ((total += src.transferTo(total, chunk, target)) < size) {
            }
        }
        finally {
            DefaultFileProcessor.close(src);
            DefaultFileProcessor.close(target);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, String data) throws IOException {
        FileChannel channel;
        RandomAccessFile out;
        block3: {
            out = null;
            channel = null;
            try {
                out = new RandomAccessFile(file, "rw");
                channel = out.getChannel();
                out.setLength(0L);
                if (data == null) {
                    channel.truncate(0L);
                    break block3;
                }
                out.write(data.getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                DefaultFileProcessor.close(channel);
                DefaultFileProcessor.close(out);
                throw throwable;
            }
        }
        DefaultFileProcessor.close(channel);
        DefaultFileProcessor.close(out);
    }

    private static final class ProgressingChannel
    implements WritableByteChannel {
        private final FileChannel delegate;
        private final FileProcessor.ProgressListener listener;

        public ProgressingChannel(FileChannel delegate, FileProcessor.ProgressListener listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public int write(ByteBuffer src) throws IOException {
            ByteBuffer eventBuffer = src.asReadOnlyBuffer();
            int count = this.delegate.write(src);
            this.listener.progressed(eventBuffer);
            return count;
        }
    }
}

