/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.wagon.git;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import net.trajano.wagon.git.internal.AbstractGitWagon;
import net.trajano.wagon.git.internal.GitUri;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

@Component(role=Wagon.class, hint="git", instantiationStrategy="per-lookup")
public class GitWagon
extends AbstractGitWagon {
    private static final Logger LOG = Logger.getLogger("net.trajano.wagon.git", "META-INF/Messages");
    private static final String MESSAGES = "META-INF/Messages";
    private static final ResourceBundle R = ResourceBundle.getBundle("META-INF/Messages");

    @Override
    public GitUri buildGitUri(URI gitUri) {
        String branchName = gitUri.getQuery();
        String asciiUriString = gitUri.toASCIIString();
        String gitRepositoryUri = asciiUriString.substring(0, asciiUriString.indexOf(63));
        String resource = gitUri.getFragment();
        return new GitUri(gitRepositoryUri, branchName, resource);
    }

    @Override
    public File getFileForResource(String resourceName) throws GitAPIException, IOException, URISyntaxException {
        Git resourceGit;
        GitUri resolved = this.getGitUri().resolve(resourceName);
        try {
            resourceGit = this.getGit(resolved.getGitRepositoryUri());
        }
        catch (ResourceDoesNotExistException e) {
            LOG.throwing(((Object)((Object)this)).getClass().getName(), "getFileForResource", e);
            return null;
        }
        File workTree = resourceGit.getRepository().getWorkTree();
        File resolvedFile = new File(workTree, resolved.getResource());
        if (!resolvedFile.getCanonicalPath().startsWith(workTree.getCanonicalPath())) {
            throw new IOException(String.format(R.getString("notInWorkTree"), resolvedFile, workTree));
        }
        return resolvedFile;
    }
}

