/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.shared.utils.io.FileUtils;

class Expand {
    private File source;
    private File dest;
    private boolean overwrite = false;
    private static final int BUFFER_SIZE = 18;

    Expand() {
    }

    public void setSrc(File sourceArchive) {
        this.source = sourceArchive;
    }

    public void setDest(File destinationDirectory) {
        this.dest = destinationDirectory;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void execute() throws Exception {
        this.expandFile(this.source, this.dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expandFile(File srcFile, File destination) throws Exception {
        if (this.source == null) {
            throw new NullPointerException("Source Archive must not be null!");
        }
        File destDir = destination;
        if (destDir == null) {
            destDir = new File(System.getProperty("user.dir"));
        }
        FileInputStream fileInputStream = new FileInputStream(srcFile);
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String zipEntryName = zipEntry.getName();
                Date zipEntryDate = new Date(zipEntry.getTime());
                this.extractFile(this.source, destDir, zipInputStream, zipEntryName, zipEntryDate, zipEntry.isDirectory());
            }
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void extractFile(File archive, File destDir, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory) throws Exception {
        File targetFile = new File(destDir, entryName);
        if (this.overwrite && targetFile.exists() && targetFile.isDirectory() != isDirectory) {
            this.deleteFileOrDir(targetFile);
        }
        if (!targetFile.exists() || this.overwrite || targetFile.lastModified() <= entryDate.getTime()) {
            if (isDirectory) {
                targetFile.mkdirs();
            } else {
                byte[] buffer = new byte[18];
                FileOutputStream fileOutputStream = new FileOutputStream(targetFile);
                try {
                    int len;
                    while ((len = compressedInputStream.read(buffer)) > 0) {
                        fileOutputStream.write(buffer, 0, len);
                    }
                }
                finally {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException ioe) {}
                }
                targetFile.setLastModified(entryDate.getTime());
            }
        }
    }

    private void deleteFileOrDir(File targetFile) throws IOException {
        if (targetFile.isDirectory()) {
            FileUtils.deleteDirectory(targetFile);
        } else {
            FileUtils.delete(targetFile);
        }
    }
}

