/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.dir;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.ArchiveEntryUtils;
import org.codehaus.plexus.util.FileUtils;

public class DirectoryArchiver
extends AbstractArchiver {
    public void resetArchiver() {
        this.cleanUp();
    }

    public void execute() throws ArchiverException, IOException {
        String fileName;
        Map listFiles = this.getFiles();
        if (listFiles == null || listFiles.size() == 0) {
            throw new ArchiverException("You must set at least one file.");
        }
        File destDirectory = this.getDestFile();
        if (destDirectory == null) {
            throw new ArchiverException("You must set the destination directory.");
        }
        if (destDirectory.exists() && !destDirectory.isDirectory()) {
            throw new ArchiverException(destDirectory + " is not a directory.");
        }
        if (destDirectory.exists() && !destDirectory.canWrite()) {
            throw new ArchiverException(destDirectory + " is not writable.");
        }
        Iterator iter = this.getFiles().keySet().iterator();
        while (iter.hasNext()) {
            fileName = (String)iter.next();
            ArchiveEntry fileToAdd = (ArchiveEntry)this.getFiles().get(fileName);
            if (!destDirectory.equals(fileToAdd.getFile())) continue;
            throw new ArchiverException("The destination directory cannot include itself.");
        }
        this.getLogger().info("Copying " + listFiles.size() + " files to " + destDirectory.getAbsolutePath());
        try {
            iter = this.getFiles().keySet().iterator();
            while (iter.hasNext()) {
                fileName = (String)iter.next();
                ArchiveEntry f = (ArchiveEntry)this.getFiles().get(fileName);
                String destDir = destDirectory.getCanonicalPath();
                fileName = destDir + File.separator + fileName;
                this.copyFile(f, fileName);
            }
        }
        catch (IOException ioe) {
            String message = "Problem copying files : " + ioe.getMessage();
            throw new ArchiverException(message, ioe);
        }
    }

    protected void copyFile(ArchiveEntry entry, String vPath) throws ArchiverException, IOException {
        if (vPath.length() <= 0) {
            return;
        }
        File inFile = entry.getFile();
        File outFile = new File(vPath);
        if (outFile.exists() && outFile.lastModified() >= inFile.lastModified()) {
            return;
        }
        outFile.setLastModified(inFile.lastModified());
        if (!inFile.isDirectory()) {
            if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                throw new ArchiverException("Unable to create directory or parent directory of " + outFile);
            }
            FileUtils.copyFile((File)inFile, (File)outFile);
            ArchiveEntryUtils.chmod(outFile, entry.getMode(), this.getLogger());
        } else if (outFile.exists()) {
            if (!outFile.isDirectory()) {
                throw new ArchiverException("Expected directory and found file at copy destination of " + inFile + " to " + outFile);
            }
        } else if (!outFile.mkdirs()) {
            throw new ArchiverException("Unable to create directory or parent directory of " + outFile);
        }
    }

    protected void cleanUp() {
        this.setIncludeEmptyDirs(false);
        this.getDirs().clear();
        this.getFiles().clear();
        this.setIncludeEmptyDirs(true);
    }

    protected void close() throws IOException {
    }

    protected String getArchiveType() {
        return "directory";
    }
}

