/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.runtime.nodes.ExpectStringOrTruffleObjectNodeGen;

@GenerateUncached
public abstract class ExpectStringOrTruffleObjectNode
extends Node {
    public abstract Object execute(Object var1) throws UnsupportedTypeException;

    @Specialization
    static Object doString(String input) {
        return input;
    }

    @Specialization(guards={"inputs.isString(input)"}, limit="2")
    static Object doBoxedString(Object input, @CachedLibrary(value="input") InteropLibrary inputs) throws UnsupportedTypeException {
        try {
            return inputs.asString(input);
        }
        catch (UnsupportedMessageException e) {
            throw UnsupportedTypeException.create((Object[])new Object[]{input});
        }
    }

    @Specialization(guards={"inputs.hasArrayElements(input)"}, limit="2")
    static Object doBoxedCharArray(Object input, @CachedLibrary(value="input") InteropLibrary inputs) throws UnsupportedTypeException {
        try {
            long inputLength = inputs.getArraySize(input);
            if (inputLength > Integer.MAX_VALUE) {
                throw UnsupportedTypeException.create((Object[])new Object[]{input});
            }
            return input;
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedTypeException.create((Object[])new Object[]{input});
        }
    }

    public static ExpectStringOrTruffleObjectNode create() {
        return ExpectStringOrTruffleObjectNodeGen.create();
    }
}

