/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nodes.input.InputCharAtNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputEqualsNodeGen;
import com.oracle.truffle.regex.tregex.nodes.input.InputLengthNode;

public abstract class InputEqualsNode
extends Node {
    public static InputEqualsNode create() {
        return InputEqualsNodeGen.create();
    }

    public abstract boolean execute(Object var1, String var2, String var3);

    @Specialization(guards={"mask == null"})
    public boolean execEquals(String input, String string, String mask) {
        return input.equals(string);
    }

    @Specialization(guards={"mask != null"})
    public boolean execEqualsWithMask(String input, String string, String mask) {
        return input.length() == string.length() && ArrayUtils.regionEqualsWithOrMask((String)input, (int)0, (String)string, (int)0, (int)mask.length(), (String)mask);
    }

    @Specialization(guards={"mask == null"})
    public boolean equalsTruffleObjNoMask(TruffleObject input, String string, String mask, @Cached(value="create()") InputLengthNode lengthNode, @Cached(value="create()") InputCharAtNode charAtNode) {
        return InputEqualsNode.equalsTruffleObj(input, string, mask, lengthNode, charAtNode);
    }

    @Specialization(guards={"mask != null"})
    public boolean equalsTruffleObjWithMask(TruffleObject input, String string, String mask, @Cached(value="create()") InputLengthNode lengthNode, @Cached(value="create()") InputCharAtNode charAtNode) {
        return InputEqualsNode.equalsTruffleObj(input, string, mask, lengthNode, charAtNode);
    }

    private static boolean equalsTruffleObj(TruffleObject input, String string, String mask, InputLengthNode lengthNode, InputCharAtNode charAtNode) {
        if (lengthNode.execute(input) != string.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (InputCharAtNode.charAtWithMask(input, i, mask, i, charAtNode) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

