/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

public final class PolyglotException
extends RuntimeException {
    final AbstractPolyglotImpl.AbstractExceptionImpl impl;

    PolyglotException(String message, AbstractPolyglotImpl.AbstractExceptionImpl impl) {
        super(message);
        this.impl = impl;
        impl.onCreate(this);
        super.setStackTrace(this.getStackTrace());
    }

    @Override
    public void printStackTrace() {
        this.impl.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.impl.printStackTrace(s);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.impl.printStackTrace(s);
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.impl.getStackTrace();
    }

    @Override
    public String getMessage() {
        return this.impl.getMessage();
    }

    public SourceSection getSourceLocation() {
        return this.impl.getSourceLocation();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PolyglotException) {
            return this.impl.equals(((PolyglotException)obj).impl);
        }
        return false;
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length; ++i) {
            if (stackTrace[i] != null) continue;
            throw new NullPointerException("stackTrace[" + i + "]");
        }
    }

    public Iterable<StackFrame> getPolyglotStackTrace() {
        return this.impl.getPolyglotStackTrace();
    }

    public boolean isHostException() {
        return this.impl.isHostException();
    }

    public boolean isGuestException() {
        return !this.impl.isHostException();
    }

    public Throwable asHostException() {
        return this.impl.asHostException();
    }

    public boolean isInternalError() {
        return this.impl.isInternalError();
    }

    public boolean isCancelled() {
        return this.impl.isCancelled();
    }

    public boolean isExit() {
        return this.impl.isExit();
    }

    public boolean isSyntaxError() {
        return this.impl.isSyntaxError();
    }

    public boolean isIncompleteSource() {
        return this.impl.isIncompleteSource();
    }

    public Value getGuestObject() {
        return this.impl.getGuestObject();
    }

    public int getExitStatus() {
        return this.impl.getExitStatus();
    }

    public final class StackFrame {
        final AbstractPolyglotImpl.AbstractStackFrameImpl impl;

        StackFrame(AbstractPolyglotImpl.AbstractStackFrameImpl impl) {
            this.impl = impl;
        }

        public boolean isHostFrame() {
            return this.impl.isHostFrame();
        }

        public boolean isGuestFrame() {
            return !this.impl.isHostFrame();
        }

        public StackTraceElement toHostFrame() {
            return this.impl.toHostFrame();
        }

        public SourceSection getSourceLocation() {
            return this.impl.getSourceLocation();
        }

        public String getRootName() {
            return this.impl.getRootName();
        }

        public Language getLanguage() {
            return this.impl.getLanguage();
        }

        public String toString() {
            return this.impl.toStringImpl(0);
        }
    }
}

