-- ******************************
-- * Test suite for the Postgres NUMERIC data type
-- ******************************

CREATE TABLE num_data (id int4, val numeric(300,100));
CREATE TABLE num_exp_add (id1 int4, id2 int4, expected numeric(300,100));
CREATE TABLE num_exp_sub (id1 int4, id2 int4, expected numeric(300,100));
CREATE TABLE num_exp_div (id1 int4, id2 int4, expected numeric(300,100));
CREATE TABLE num_exp_mul (id1 int4, id2 int4, expected numeric(300,100));
CREATE TABLE num_exp_sqrt (id int4, expected numeric(300,100));
CREATE TABLE num_exp_ln (id int4, expected numeric(300,100));
CREATE TABLE num_exp_log10 (id int4, expected numeric(300,100));
CREATE TABLE num_exp_power_10_ln (id int4, expected numeric(300,100));

CREATE TABLE num_result (id1 int4, id2 int4, result numeric(300,100));


-- ******************************
-- * The following EXPECTED results are computed by bc(1)
-- * with a scale of 300
-- ******************************

BEGIN TRANSACTION;
INSERT INTO num_exp_add VALUES (0,0,'0');
INSERT INTO num_exp_sub VALUES (0,0,'0');
INSERT INTO num_exp_mul VALUES (0,0,'0');
INSERT INTO num_exp_div VALUES (0,0,'NaN');
INSERT INTO num_exp_add VALUES (0,1,'6852398049310715');
INSERT INTO num_exp_sub VALUES (0,1,'-6852398049310715');
INSERT INTO num_exp_mul VALUES (0,1,'0');
INSERT INTO num_exp_div VALUES (0,1,'0');
INSERT INTO num_exp_add VALUES (0,2,'525431716055.9015691580565052917944596016796880085633089915820638527');
INSERT INTO num_exp_sub VALUES (0,2,'-525431716055.9015691580565052917944596016796880085633089915820638527');
INSERT INTO num_exp_mul VALUES (0,2,'0');
INSERT INTO num_exp_div VALUES (0,2,'0');
INSERT INTO num_exp_add VALUES (0,3,'-7183563573679774924366799392868392833.5301026242198333296741957378887077660318525485624537205656408078348');
INSERT INTO num_exp_sub VALUES (0,3,'7183563573679774924366799392868392833.5301026242198333296741957378887077660318525485624537205656408078348');
INSERT INTO num_exp_mul VALUES (0,3,'0');
INSERT INTO num_exp_div VALUES (0,3,'0');
INSERT INTO num_exp_add VALUES (0,4,'-8017.65083172522815926582280177128402125550786396441005929613300980559517228382913472514');
INSERT INTO num_exp_sub VALUES (0,4,'8017.65083172522815926582280177128402125550786396441005929613300980559517228382913472514');
INSERT INTO num_exp_mul VALUES (0,4,'0');
INSERT INTO num_exp_div VALUES (0,4,'0');
INSERT INTO num_exp_add VALUES (0,5,'4747823160689824275992795.7435482860759268553304894546094806090945079504233968784096390051002696894595');
INSERT INTO num_exp_sub VALUES (0,5,'-4747823160689824275992795.7435482860759268553304894546094806090945079504233968784096390051002696894595');
INSERT INTO num_exp_mul VALUES (0,5,'0');
INSERT INTO num_exp_div VALUES (0,5,'0');
INSERT INTO num_exp_add VALUES (0,6,'9701245686868266153803441967720286769.407169905329625973842950739045885275761695735066657060982526493385549754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (0,6,'-9701245686868266153803441967720286769.407169905329625973842950739045885275761695735066657060982526493385549754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (0,6,'0');
INSERT INTO num_exp_div VALUES (0,6,'0');
INSERT INTO num_exp_add VALUES (0,7,'53434539.68545099977243923072935225137418842885023333327396090427200310074108059093125006857544132591');
INSERT INTO num_exp_sub VALUES (0,7,'-53434539.68545099977243923072935225137418842885023333327396090427200310074108059093125006857544132591');
INSERT INTO num_exp_mul VALUES (0,7,'0');
INSERT INTO num_exp_div VALUES (0,7,'0');
INSERT INTO num_exp_add VALUES (0,8,'-457327386.06988997533660667782229300572256009704377756762897876252237581486843');
INSERT INTO num_exp_sub VALUES (0,8,'457327386.06988997533660667782229300572256009704377756762897876252237581486843');
INSERT INTO num_exp_mul VALUES (0,8,'0');
INSERT INTO num_exp_div VALUES (0,8,'0');
INSERT INTO num_exp_add VALUES (0,9,'-88.46458030244467528082162887102125086097032072434060205');
INSERT INTO num_exp_sub VALUES (0,9,'88.46458030244467528082162887102125086097032072434060205');
INSERT INTO num_exp_mul VALUES (0,9,'0');
INSERT INTO num_exp_div VALUES (0,9,'0');
INSERT INTO num_exp_add VALUES (1,0,'6852398049310715');
INSERT INTO num_exp_sub VALUES (1,0,'6852398049310715');
INSERT INTO num_exp_mul VALUES (1,0,'0');
INSERT INTO num_exp_div VALUES (1,0,'NaN');
INSERT INTO num_exp_add VALUES (1,1,'13704796098621430');
INSERT INTO num_exp_sub VALUES (1,1,'0');
INSERT INTO num_exp_mul VALUES (1,1,'46955359026197292120686613811225');
INSERT INTO num_exp_div VALUES (1,1,'1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
INSERT INTO num_exp_add VALUES (1,2,'6852923481026770.9015691580565052917944596016796880085633089915820638527');
INSERT INTO num_exp_sub VALUES (1,2,'6851872617594659.0984308419434947082055403983203119914366910084179361473');
INSERT INTO num_exp_mul VALUES (1,2,'3600467266147441403089014425.5541960577252991267479438180864818403209543243522916805');
INSERT INTO num_exp_div VALUES (1,2,'13041.46255339804569229508591213994397015575245900117122118955181562389218923779048729758262833024493179626088334628');
INSERT INTO num_exp_add VALUES (1,3,'-7183563573679774924359946994819082118.5301026242198333296741957378887077660318525485624537205656408078348');
INSERT INTO num_exp_sub VALUES (1,3,'7183563573679774924373651790917703548.5301026242198333296741957378887077660318525485624537205656408078348');
INSERT INTO num_exp_mul VALUES (1,3,'-49224637019382798398286089985690389639602359684244071.8922490981929824142037859047091476226940833710558275205179115898820');
INSERT INTO num_exp_div VALUES (1,3,'-.00000000000000000000095389954846610752011339200947088050119215342248625968059695305811628936066357124751029522');
INSERT INTO num_exp_add VALUES (1,4,'6852398049302697.34916827477184073417719822871597874449213603558994070386699019440482771617086527486');
INSERT INTO num_exp_sub VALUES (1,4,'6852398049318732.65083172522815926582280177128402125550786396441005929613300980559517228382913472514');
INSERT INTO num_exp_mul VALUES (1,4,'-54940134919368385120.81248970674354050332848113219828602170849782121055619598327514099607745684798187510');
INSERT INTO num_exp_div VALUES (1,4,'-854664064715.35309911226020771070940019422228278351569218979570098037472670246888235920622757240622598318683302025848981052');
INSERT INTO num_exp_add VALUES (1,5,'4747823167542222325303510.7435482860759268553304894546094806090945079504233968784096390051002696894595');
INSERT INTO num_exp_sub VALUES (1,5,'-4747823153837426226682080.7435482860759268553304894546094806090945079504233968784096390051002696894595');
INSERT INTO num_exp_mul VALUES (1,5,'32533974164783185236339609841060881373431.6550414328018350920135515227035510735313827063024184400528958439610759085425');
INSERT INTO num_exp_div VALUES (1,5,'.00000000144327154095501553056995066374088123864817940925759336929056755983657662675588749627446067324624955846');
INSERT INTO num_exp_add VALUES (1,6,'9701245686868266153810294365769597484.407169905329625973842950739045885275761695735066657060982526493385549754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (1,6,'-9701245686868266153796589569670976054.407169905329625973842950739045885275761695735066657060982526493385549754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (1,6,'66476797020580094465930712987070250507406412849448592.522195655411103744823989913087360677019949974915069138259147140772652577099849554445015124212516425');
INSERT INTO num_exp_div VALUES (1,6,'.00000000000000000000070634207920187107398465954304992037673604087551275840261421484560438951119409119228358599');
INSERT INTO num_exp_add VALUES (1,7,'6852398102745254.68545099977243923072935225137418842885023333327396090427200310074108059093125006857544132591');
INSERT INTO num_exp_sub VALUES (1,7,'6852397995876175.31454900022756076927064774862581157114976666672603909572799689925891940906874993142455867409');
INSERT INTO num_exp_mul VALUES (1,7,'366154735506400417524126.93601516766992631704359744516379145673308396857521100653889582991884867371603707540117012565');
INSERT INTO num_exp_div VALUES (1,7,'128239114.43138090520585793163352899949315764107209783134973172830134337338301750228626553646806130348366969432201461594');
INSERT INTO num_exp_add VALUES (1,8,'6852397591983328.93011002466339332217770699427743990295622243237102123747762418513157');
INSERT INTO num_exp_sub VALUES (1,8,'6852398506638101.06988997533660667782229300572256009704377756762897876252237581486843');
INSERT INTO num_exp_mul VALUES (1,8,'-3133789288201682323403927.58107656590501917041554111733256373697509660048884635492500991422745');
INSERT INTO num_exp_div VALUES (1,8,'-14983572.50852131012973097522758686514275190244256289893022945850962088894207780677166406982475205389104657596671339859');
INSERT INTO num_exp_add VALUES (1,9,'6852398049310626.53541969755532471917837112897874913902967927565939795');
INSERT INTO num_exp_sub VALUES (1,9,'6852398049310803.46458030244467528082162887102125086097032072434060205');
INSERT INTO num_exp_mul VALUES (1,9,'-606194517497562994.89341475407266858445191196393964220150276889061596575');
INSERT INTO num_exp_div VALUES (1,9,'-77459227477071.43467129820271405026833985013219953424863995585984145440369861313798048378625360744179520587193601530050882329');
INSERT INTO num_exp_add VALUES (2,0,'525431716055.9015691580565052917944596016796880085633089915820638527');
INSERT INTO num_exp_sub VALUES (2,0,'525431716055.9015691580565052917944596016796880085633089915820638527');
INSERT INTO num_exp_mul VALUES (2,0,'0');
INSERT INTO num_exp_div VALUES (2,0,'NaN');
INSERT INTO num_exp_add VALUES (2,1,'6852923481026770.9015691580565052917944596016796880085633089915820638527');
INSERT INTO num_exp_sub VALUES (2,1,'-6851872617594659.0984308419434947082055403983203119914366910084179361473');
INSERT INTO num_exp_mul VALUES (2,1,'3600467266147441403089014425.5541960577252991267479438180864818403209543243522916805');
INSERT INTO num_exp_div VALUES (2,1,'.00007667851637847496619376827100180877879374819040166705295419829536146613257795614824127102535155331478582821');
INSERT INTO num_exp_add VALUES (2,2,'1050863432111.8031383161130105835889192033593760171266179831641277054');
INSERT INTO num_exp_sub VALUES (2,2,'0');
INSERT INTO num_exp_mul VALUES (2,2,'276078488237449570822745.59503519426155352455500490515347754310943329808764005078383006832354368281625006253813852766281758001996729729');
INSERT INTO num_exp_div VALUES (2,2,'1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
INSERT INTO num_exp_add VALUES (2,3,'-7183563573679774924366798867436676777.6285334661633280378797361362090197574685435569803898678656408078348');
INSERT INTO num_exp_sub VALUES (2,3,'7183563573679774924366799918300108889.4316717822763386214686553395683957745951615401445175732656408078348');
INSERT INTO num_exp_mul VALUES (2,3,'-3774472135915229048919173094258817490981671232574.22203865332130617508231578047416281508452598961984268046704900939735473619694991646440650698614873696613219453');
INSERT INTO num_exp_div VALUES (2,3,'-.00000000000000000000000007314360215047830029669591305542916852101489402767459015891820532158506374880041348927');
INSERT INTO num_exp_add VALUES (2,4,'525431708038.25073743282834602597165783039566675305544502717200455656699019440482771617086527486');
INSERT INTO num_exp_sub VALUES (2,4,'525431724073.55240088328466455761726137296370926407117295599212314883300980559517228382913472514');
INSERT INTO num_exp_mul VALUES (2,4,'-4212728035250413.13466939967698489376040601268372297374532033798117977784826615228955031213040636232537556861571449758815681560');
INSERT INTO num_exp_div VALUES (2,4,'-65534372.48437019105610087210488824181611681155961689263714312790543038694225521700947180193173431473723487811752616430');
INSERT INTO num_exp_add VALUES (2,5,'4747823160690349707708851.6451174441324321471249490562891686176578169420054607311096390051002696894595');
INSERT INTO num_exp_sub VALUES (2,5,'-4747823160689298844276739.8419791280194215635360298529297926005311989588413330257096390051002696894595');
INSERT INTO num_exp_mul VALUES (2,5,'2494656870851208877840876907054433704.07942750555417292727776660040838906237723218446425550572053529378630604327878156697802532047429883705655085239');
INSERT INTO num_exp_div VALUES (2,5,'.00000000000011066792049170596131243379262776942708637839245203178830001803871967108524319207973337784587056810');
INSERT INTO num_exp_add VALUES (2,6,'9701245686868266153803442493152002825.308739063386131265637410340725573284325004726648720913682526493385549754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (2,6,'-9701245686868266153803441442288570713.505600747273120682048491137366197267198386743484593208282526493385549754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (2,6,'5097342169131106607821426204356386895200533068775.30124525237572891490807564576482672317687284944564210294934413834578926974593163851282632737917359455084186066');
INSERT INTO num_exp_div VALUES (2,6,'.00000000000000000000000005416126268888673292363404581180274802858759824646842823929607172446083208018426017461');
INSERT INTO num_exp_add VALUES (2,7,'525485150595.58702015782894452252381185305387643741354232485602475697200310074108059093125006857544132591');
INSERT INTO num_exp_sub VALUES (2,7,'525378281516.21611815828406606106510735030549957971307565830810294842799689925891940906874993142455867409');
INSERT INTO num_exp_mul VALUES (2,7,'28076201883583693660.00350847229956796729521143402294494056204979681151714785658178143895121870236433600734608395863553464022984154');
INSERT INTO num_exp_div VALUES (2,7,'9833.18503628776614105752961349654553479681240849842718495167945412332464258748775035248452586503483744431376012295');
INSERT INTO num_exp_add VALUES (2,8,'524974388669.83167918271989861397216659595712791151953142395308509017762418513157');
INSERT INTO num_exp_sub VALUES (2,8,'525889043441.97145913339311196961675260740224810560708655921104261522237581486843');
INSERT INTO num_exp_mul VALUES (2,8,'-240294313262062104172.57008604035226619329878446787997689662213618394614525847877837975225596982199796733079277898459628666403053781');
INSERT INTO num_exp_div VALUES (2,8,'-1148.91811000271851374801715971591851734688357010023954906962661537125015475644625449259349651987266983243610072484');
INSERT INTO num_exp_add VALUES (2,9,'525431715967.4369888556118300109728307306584371475929882672414618027');
INSERT INTO num_exp_sub VALUES (2,9,'525431716144.3661494605011805726160884727009388695336297159226659027');
INSERT INTO num_exp_mul VALUES (2,9,'-46482096238478.613581680444636219005909359701263673629654426638484216602633133680256167198216278769487022282377046260518035');
INSERT INTO num_exp_div VALUES (2,9,'-5939458642.76464013736611157573928602155032485228720402587891547068098316492886011735924005751195173267038163125368045370');
INSERT INTO num_exp_add VALUES (3,0,'-7183563573679774924366799392868392833.5301026242198333296741957378887077660318525485624537205656408078348');
INSERT INTO num_exp_sub VALUES (3,0,'-7183563573679774924366799392868392833.5301026242198333296741957378887077660318525485624537205656408078348');
INSERT INTO num_exp_mul VALUES (3,0,'0');
INSERT INTO num_exp_div VALUES (3,0,'NaN');
INSERT INTO num_exp_add VALUES (3,1,'-7183563573679774924359946994819082118.5301026242198333296741957378887077660318525485624537205656408078348');
INSERT INTO num_exp_sub VALUES (3,1,'-7183563573679774924373651790917703548.5301026242198333296741957378887077660318525485624537205656408078348');
INSERT INTO num_exp_mul VALUES (3,1,'-49224637019382798398286089985690389639602359684244071.8922490981929824142037859047091476226940833710558275205179115898820');
INSERT INTO num_exp_div VALUES (3,1,'-1048328413204538223616.83870981986014423494924141758231887079501555686241962110833031233341385137098756271787964246589464681741659646');
INSERT INTO num_exp_add VALUES (3,2,'-7183563573679774924366798867436676777.6285334661633280378797361362090197574685435569803898678656408078348');
INSERT INTO num_exp_sub VALUES (3,2,'-7183563573679774924366799918300108889.4316717822763386214686553395683957745951615401445175732656408078348');
INSERT INTO num_exp_mul VALUES (3,2,'-3774472135915229048919173094258817490981671232574.22203865332130617508231578047416281508452598961984268046704900939735473619694991646440650698614873696613219453');
INSERT INTO num_exp_div VALUES (3,2,'-13671735744470178581942751.55514923599826566081072956430574817469782885830643971502793463196658362414068847200071795541997895400816956370');
INSERT INTO num_exp_add VALUES (3,3,'-14367127147359549848733598785736785667.0602052484396666593483914757774155320637050971249074411312816156696');
INSERT INTO num_exp_sub VALUES (3,3,'0');
INSERT INTO num_exp_mul VALUES (3,3,'51603585617098939098502434366213693318957453976033366420006284269331559985.05274679693102499865376052995498024288250618515081928629613406283908516451953935454379799045434631985636543956');
INSERT INTO num_exp_div VALUES (3,3,'1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
INSERT INTO num_exp_add VALUES (3,4,'-7183563573679774924366799392868400851.18093434944799259549699750917272902153971651297251301669865061342997228382913472514');
INSERT INTO num_exp_sub VALUES (3,4,'-7183563573679774924366799392868384815.87927089899167406385139396660468651052398858415239442443263100223962771617086527486');
INSERT INTO num_exp_mul VALUES (3,4,'57595304461264699737751230320832158887296.40355296269205089302272508719588143723389531993768561430506586762802488135976655849659621518959339741583690583');
INSERT INTO num_exp_div VALUES (3,4,'895968622785986880713012655110798.79051406335338191176037340903117431208019792743085503663854112195123581861104650696546905938769916269907661219');
INSERT INTO num_exp_add VALUES (3,5,'-7183563573675027101206109568592400037.7865543381439064743437062832792271569373445981390568421560018027345303105405');
INSERT INTO num_exp_sub VALUES (3,5,'-7183563573684522747527489217144385629.2736509102957601850046851924981883751263604989858505989752798129350696894595');
INSERT INTO num_exp_mul VALUES (3,5,'-34106289511404598350757809651356796825361611751366995016687971.19553888517016770369359040577180883693724279001534595310232787381107408586640771977050886691340378405658515884');
INSERT INTO num_exp_div VALUES (3,5,'-1513022564352.64013273642571961036777878204545219132834148284307468933332473870580288426424642781603650342400032493736988022');
INSERT INTO num_exp_add VALUES (3,6,'2517682113188491229436642574851893935.877067281109792644168755001157177509729843186504203340416885685550749754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (3,6,'-16884809260548041078170241360588679602.937272529549459303517146476934593041793548283629110781548167301220349754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (3,6,'-69689515135504904745185835572058795604473166270056401031240587138801160717.95996927214551166025033782935420363748599419831326330925071268417759778591606429829710090337188981091015067409');
INSERT INTO num_exp_div VALUES (3,6,'-.74047847106929176376671882968511162311027940289423881065394040465609318470458881768641112615167333912847536986');
INSERT INTO num_exp_add VALUES (3,7,'-7183563573679774924366799392814958293.84465162444739409894484348651451933718161921528849281629363770709371940906874993142455867409');
INSERT INTO num_exp_sub VALUES (3,7,'-7183563573679774924366799392921827373.21555362399227256040354798926289619488208588183641462483764390857588059093125006857544132591');
INSERT INTO num_exp_mul VALUES (3,7,'-383850412860752140214977941214376419508971441.64853766387328157503303617779220482878356507136939255459801715605967618584200514415782027107678311360637469279');
INSERT INTO num_exp_div VALUES (3,7,'-134436707342604742416951639454.07198966362415850211110235159541219155720268009638748684295744143666706568492144594122675913515401925851443703');
INSERT INTO num_exp_add VALUES (3,8,'-7183563573679774924366799393325720219.59999259955644000749648874361126786307563011619143248308801662270323');
INSERT INTO num_exp_sub VALUES (3,8,'-7183563573679774924366799392411065447.46021264888322665185190273216614766898807498093347495804326499296637');
INSERT INTO num_exp_mul VALUES (3,8,'3285240351817848948222441668458099419176314234.83026886164131999404846585810047193235776483532725591898875533198446748528511630887584555789179109742052077784');
INSERT INTO num_exp_div VALUES (3,8,'15707704791993287329308746043.49413565325673713610988485542293297250401458505900134708489414142692025529531074712602918868905934326627102299');
INSERT INTO num_exp_add VALUES (3,9,'-7183563573679774924366799392868392921.9946829266645086104958246089099586270021732729030557705656408078348');
INSERT INTO num_exp_sub VALUES (3,9,'-7183563573679774924366799392868392745.0655223217751580488525668668674569050615318242218516705656408078348');
INSERT INTO num_exp_mul VALUES (3,9,'635490936621510895579358779166912464979.64999728795126299308567330855891403287469456952463171290912677155132266356781303629278882882222680636499242710');
INSERT INTO num_exp_div VALUES (3,9,'81202709029087663787488035933300338.37226580534606612747683781215576275875391074786273119632853429035178684758864249408857251805714813477941009860');
INSERT INTO num_exp_add VALUES (4,0,'-8017.65083172522815926582280177128402125550786396441005929613300980559517228382913472514');
INSERT INTO num_exp_sub VALUES (4,0,'-8017.65083172522815926582280177128402125550786396441005929613300980559517228382913472514');
INSERT INTO num_exp_mul VALUES (4,0,'0');
INSERT INTO num_exp_div VALUES (4,0,'NaN');
INSERT INTO num_exp_add VALUES (4,1,'6852398049302697.34916827477184073417719822871597874449213603558994070386699019440482771617086527486');
INSERT INTO num_exp_sub VALUES (4,1,'-6852398049318732.65083172522815926582280177128402125550786396441005929613300980559517228382913472514');
INSERT INTO num_exp_mul VALUES (4,1,'-54940134919368385120.81248970674354050332848113219828602170849782121055619598327514099607745684798187510');
INSERT INTO num_exp_div VALUES (4,1,'-.00000000000117005036397903451104991071041477541213236384216122215349708574239624534337018339240086276944040469');
INSERT INTO num_exp_add VALUES (4,2,'525431708038.25073743282834602597165783039566675305544502717200455656699019440482771617086527486');
INSERT INTO num_exp_sub VALUES (4,2,'-525431724073.55240088328466455761726137296370926407117295599212314883300980559517228382913472514');
INSERT INTO num_exp_mul VALUES (4,2,'-4212728035250413.13466939967698489376040601268372297374532033798117977784826615228955031213040636232537556861571449758815681560');
INSERT INTO num_exp_div VALUES (4,2,'-.00000001525916800742233216010222728821509083128467209995318857574134394317769976389712546222953692237980546561');
INSERT INTO num_exp_add VALUES (4,3,'-7183563573679774924366799392868400851.18093434944799259549699750917272902153971651297251301669865061342997228382913472514');
INSERT INTO num_exp_sub VALUES (4,3,'7183563573679774924366799392868384815.87927089899167406385139396660468651052398858415239442443263100223962771617086527486');
INSERT INTO num_exp_mul VALUES (4,3,'57595304461264699737751230320832158887296.40355296269205089302272508719588143723389531993768561430506586762802488135976655849659621518959339741583690583');
INSERT INTO num_exp_div VALUES (4,3,'.00000000000000000000000000000000111611051388220577512895030199861749450623610461901310997189362775369596765273');
INSERT INTO num_exp_add VALUES (4,4,'-16035.30166345045631853164560354256804251101572792882011859226601961119034456765826945028');
INSERT INTO num_exp_sub VALUES (4,4,'0');
INSERT INTO num_exp_mul VALUES (4,4,'64282724.85946424286913040495603266085328077083922660756565490761555471291910875811084280063286474952865506726028112743');
INSERT INTO num_exp_div VALUES (4,4,'1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
INSERT INTO num_exp_add VALUES (4,5,'4747823160689824275984778.09271656084776758950768768332545935358664398601333758227662919950509740563036527486');
INSERT INTO num_exp_sub VALUES (4,5,'-4747823160689824276000813.39438001130408612115329122589350186460237191483345617454264881069544197328863472514');
INSERT INTO num_exp_mul VALUES (4,5,'-38066388313189071191004334227.87410422046632535017595427052984048482633076932627325954800883393480502973892709858911591682877403206681557038');
INSERT INTO num_exp_div VALUES (4,5,'-.00000000000000000000168870039181499793562515318190155868200017239017354938195673807973495473342972430276663366');
INSERT INTO num_exp_add VALUES (4,6,'9701245686868266153803441967720278751.756338180101466708020148967761864020253831770656597764849516687790377470266134074211802753812697995');
INSERT INTO num_exp_sub VALUES (4,6,'-9701245686868266153803441967720294787.058001630557785239665752510329906531269559699476716357115536298980722037924403524491802753812697995');
INSERT INTO num_exp_mul VALUES (4,6,'-77781200550090136467644315750552620669981.75769650322452360656313602095347331913277958437120210712686423765553084953835471012823477538535147680837873589');
INSERT INTO num_exp_div VALUES (4,6,'-.00000000000000000000000000000000082645580686385727254033190694940438679088737047131900989414380871975437997538');
INSERT INTO num_exp_add VALUES (4,7,'53426522.03461927454427996490655048009016717334236936886390160813899329514590830710211534343544132591');
INSERT INTO num_exp_sub VALUES (4,7,'-53442557.33628272500059849655215402265820968435809729768402020040501290633625287476038479371544132591');
INSERT INTO num_exp_mul VALUES (4,7,'-428419481551.91091979257439585441278691349893536293534140263104157048723659713838420705474109022651735367098087738801229971');
INSERT INTO num_exp_div VALUES (4,7,'-.00015004622251678628542218321552142616205933185728987838446193075893672967134353867558842728176414227244203548');
INSERT INTO num_exp_add VALUES (4,8,'-457335403.72072170056476594364509477700658135255164153203903805865538562046360228382913472514');
INSERT INTO num_exp_sub VALUES (4,8,'457319368.41905825010844741199949123443853884153591360321891946638936600927325771617086527486');
INSERT INTO num_exp_mul VALUES (4,8,'3666691297293.97788321743063439981529428519197889561260417645723204001221361540886128079152654913432878259494652243560834573');
INSERT INTO num_exp_div VALUES (4,8,'.00001753153446730161409518834960177412816894467872588771344550294454067983538169836945603676724635424349317213');
INSERT INTO num_exp_add VALUES (4,9,'-8106.11541202767283454664443064230527211647818468875066134613300980559517228382913472514');
INSERT INTO num_exp_sub VALUES (4,9,'-7929.18625142278348398500117290026277039453754324006945724613300980559517228382913472514');
INSERT INTO num_exp_mul VALUES (4,9,'709278.11584011878682977020872729678966266393583171903113139348667196307625463972329472789053139421561199495187375671');
INSERT INTO num_exp_div VALUES (4,9,'90.63119730308226321340168859386531032603806758729324998110026695479872314183797074613785827326216152750534768883');
INSERT INTO num_exp_add VALUES (5,0,'4747823160689824275992795.7435482860759268553304894546094806090945079504233968784096390051002696894595');
INSERT INTO num_exp_sub VALUES (5,0,'4747823160689824275992795.7435482860759268553304894546094806090945079504233968784096390051002696894595');
INSERT INTO num_exp_mul VALUES (5,0,'0');
INSERT INTO num_exp_div VALUES (5,0,'NaN');
INSERT INTO num_exp_add VALUES (5,1,'4747823167542222325303510.7435482860759268553304894546094806090945079504233968784096390051002696894595');
INSERT INTO num_exp_sub VALUES (5,1,'4747823153837426226682080.7435482860759268553304894546094806090945079504233968784096390051002696894595');
INSERT INTO num_exp_mul VALUES (5,1,'32533974164783185236339609841060881373431.6550414328018350920135515227035510735313827063024184400528958439610759085425');
INSERT INTO num_exp_div VALUES (5,1,'692870310.00299368009177593562743277176021762608670934051733707184252717294522240313265991960478491937355918387584091704');
INSERT INTO num_exp_add VALUES (5,2,'4747823160690349707708851.6451174441324321471249490562891686176578169420054607311096390051002696894595');
INSERT INTO num_exp_sub VALUES (5,2,'4747823160689298844276739.8419791280194215635360298529297926005311989588413330257096390051002696894595');
INSERT INTO num_exp_mul VALUES (5,2,'2494656870851208877840876907054433704.07942750555417292727776660040838906237723218446425550572053529378630604327878156697802532047429883705655085239');
INSERT INTO num_exp_div VALUES (5,2,'9036042202265.33743902840987663737976304662684525224712627861787682752188511541270382246577972924347641802354054080784820539');
INSERT INTO num_exp_add VALUES (5,3,'-7183563573675027101206109568592400037.7865543381439064743437062832792271569373445981390568421560018027345303105405');
INSERT INTO num_exp_sub VALUES (5,3,'7183563573684522747527489217144385629.2736509102957601850046851924981883751263604989858505989752798129350696894595');
INSERT INTO num_exp_mul VALUES (5,3,'-34106289511404598350757809651356796825361611751366995016687971.19553888517016770369359040577180883693724279001534595310232787381107408586640771977050886691340378405658515884');
INSERT INTO num_exp_div VALUES (5,3,'-.00000000000066092867585742761204209419706948763936872324582391553864392372691883517808885871750438169660187437');
INSERT INTO num_exp_add VALUES (5,4,'4747823160689824275984778.09271656084776758950768768332545935358664398601333758227662919950509740563036527486');
INSERT INTO num_exp_sub VALUES (5,4,'4747823160689824276000813.39438001130408612115329122589350186460237191483345617454264881069544197328863472514');
INSERT INTO num_exp_mul VALUES (5,4,'-38066388313189071191004334227.87410422046632535017595427052984048482633076932627325954800883393480502973892709858911591682877403206681557038');
INSERT INTO num_exp_div VALUES (5,4,'-592171355467745354337.06710736933028614548760792320670298821170071218865151371593678788568969289004530239782262461860957546558141902');
INSERT INTO num_exp_add VALUES (5,5,'9495646321379648551985591.4870965721518537106609789092189612181890159008467937568192780102005393789190');
INSERT INTO num_exp_sub VALUES (5,5,'0');
INSERT INTO num_exp_mul VALUES (5,5,'22541824765182712948253512780484931253200292536179.84353764446082591253689274671203233889442672284844723195054200371283045647044305074119836639582577488919258316');
INSERT INTO num_exp_div VALUES (5,5,'1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
INSERT INTO num_exp_add VALUES (5,6,'9701245686873013976964131791996279565.150718191405552829173440193655365884856203685490053939392165498485819443554768799351802753812697995');
INSERT INTO num_exp_sub VALUES (5,6,'-9701245686863518330642752143444293973.663621619253699118512461284436404666667187784643260182572887488285280064635768799351802753812697995');
INSERT INTO num_exp_mul VALUES (5,6,'46059798959655416696244238007151831342062533383163561341526107.75148015605542267384967666784288083629649903361790363642120220851584757146226231663611257285498487347657346324');
INSERT INTO num_exp_div VALUES (5,6,'.00000000000048940345538475952583227425542600101261415655543364047555045576670792835125295912899372186986302113');
INSERT INTO num_exp_add VALUES (5,7,'4747823160689824329427335.42899928584836608605984170598366903794474128369735778268164210584135028039075006857544132591');
INSERT INTO num_exp_sub VALUES (5,7,'4747823160689824222558256.05809728630348762460113720323529218024427461714943597413763590435918909852824993142455867409');
INSERT INTO num_exp_mul VALUES (5,7,'253697745099383814416266256873628.09388421217492703014141892022030299188757972499344598114027622363729613814809560594993029524206557051553047087');
INSERT INTO num_exp_div VALUES (5,7,'88853074970580268.40192360000615211597775766575081506237799450372770188648395129263165045023792698876711685026298005976377025399');
INSERT INTO num_exp_add VALUES (5,8,'4747823160689823818665409.6736583107393201775081964488869205120507303827944181158872631902318396894595');
INSERT INTO num_exp_sub VALUES (5,8,'4747823160689824733320181.8134382614125335331527824603320407061382855180523756409320148199686996894595');
INSERT INTO num_exp_mul VALUES (5,8,'-2171309555600360536542309614639934.18527920929237061669865442023163442513541166788766161660729207417673317666205633343522420482590845063570299430');
INSERT INTO num_exp_div VALUES (5,8,'-10381672528931493.81391528248426062796377878134485611495340457045814153086678259595429537193781064868459787233483897950879128352');
INSERT INTO num_exp_add VALUES (5,9,'4747823160689824275992707.2789679836312515745088605835882297481241872260827948284096390051002696894595');
INSERT INTO num_exp_sub VALUES (5,9,'4747823160689824275992884.2081285885206021361521183256307314700648286747639989284096390051002696894595');
INSERT INTO num_exp_mul VALUES (5,9,'-420014183260651648975104871.01501517293451674610509452693657236642010482464239698862725619913226384637831008184195891630734293511490447273');
INSERT INTO num_exp_div VALUES (5,9,'-53669198954630890980069.58610416000255681009392774517979438098999310092256203840661813080513990715620623268120357873664864032321338415');
INSERT INTO num_exp_add VALUES (6,0,'9701245686868266153803441967720286769.407169905329625973842950739045885275761695735066657060982526493385549754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (6,0,'9701245686868266153803441967720286769.407169905329625973842950739045885275761695735066657060982526493385549754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (6,0,'0');
INSERT INTO num_exp_div VALUES (6,0,'NaN');
INSERT INTO num_exp_add VALUES (6,1,'9701245686868266153810294365769597484.407169905329625973842950739045885275761695735066657060982526493385549754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (6,1,'9701245686868266153796589569670976054.407169905329625973842950739045885275761695735066657060982526493385549754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (6,1,'66476797020580094465930712987070250507406412849448592.522195655411103744823989913087360677019949974915069138259147140772652577099849554445015124212516425');
INSERT INTO num_exp_div VALUES (6,1,'1415744622109936781278.26939971820211065992157988776644696463449528328310756013853162853654550265104727130447146363161170484135393837');
INSERT INTO num_exp_add VALUES (6,2,'9701245686868266153803442493152002825.308739063386131265637410340725573284325004726648720913682526493385549754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (6,2,'9701245686868266153803441442288570713.505600747273120682048491137366197267198386743484593208282526493385549754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (6,2,'5097342169131106607821426204356386895200533068775.30124525237572891490807564576482672317687284944564210294934413834578926974593163851282632737917359455084186066');
INSERT INTO num_exp_div VALUES (6,2,'18463380474421407430458696.42842341394894074845358634060230083533728137123664407910580325097795094865867895737881769169541087645799110952');
INSERT INTO num_exp_add VALUES (6,3,'2517682113188491229436642574851893935.877067281109792644168755001157177509729843186504203340416885685550749754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (6,3,'16884809260548041078170241360588679602.937272529549459303517146476934593041793548283629110781548167301220349754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (6,3,'-69689515135504904745185835572058795604473166270056401031240587138801160717.95996927214551166025033782935420363748599419831326330925071268417759778591606429829710090337188981091015067409');
INSERT INTO num_exp_div VALUES (6,3,'-1.35047815577398871689544997069045898823704449985769854251346147154111519791345470897545967233561108048498360038');
INSERT INTO num_exp_add VALUES (6,4,'9701245686868266153803441967720278751.756338180101466708020148967761864020253831770656597764849516687790377470266134074211802753812697995');
INSERT INTO num_exp_sub VALUES (6,4,'9701245686868266153803441967720294787.058001630557785239665752510329906531269559699476716357115536298980722037924403524491802753812697995');
INSERT INTO num_exp_mul VALUES (6,4,'-77781200550090136467644315750552620669981.75769650322452360656313602095347331913277958437120210712686423765553084953835471012823477538535147680837873589');
INSERT INTO num_exp_div VALUES (6,4,'-1209986053331380127248223820574875.55814643320957611386552997629639167060925827914336148375660833987268107329820837087327984797460678836739146812');
INSERT INTO num_exp_add VALUES (6,5,'9701245686873013976964131791996279565.150718191405552829173440193655365884856203685490053939392165498485819443554768799351802753812697995');
INSERT INTO num_exp_sub VALUES (6,5,'9701245686863518330642752143444293973.663621619253699118512461284436404666667187784643260182572887488285280064635768799351802753812697995');
INSERT INTO num_exp_mul VALUES (6,5,'46059798959655416696244238007151831342062533383163561341526107.75148015605542267384967666784288083629649903361790363642120220851584757146226231663611257285498487347657346324');
INSERT INTO num_exp_div VALUES (6,5,'2043303922351.38460905400662556426721115400035353886770912589995839060487208634908517694586579296541108085476688505126084834');
INSERT INTO num_exp_add VALUES (6,6,'19402491373736532307606883935440573538.814339810659251947685901478091770551523391470133314121965052986771099508190537598703605507625395990');
INSERT INTO num_exp_sub VALUES (6,6,'0');
INSERT INTO num_exp_mul VALUES (6,6,'94114167876980137154524793876436188895376373785250294109262763535299302007.63885108433794599083667612312067629245432282209245987889889245896447323972669378806715684712553240236642446990');
INSERT INTO num_exp_div VALUES (6,6,'1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
INSERT INTO num_exp_add VALUES (6,7,'9701245686868266153803441967773721309.092620905102065204572302990420073704611929068340617965254529594126630345026518867927244079722697995');
INSERT INTO num_exp_sub VALUES (6,7,'9701245686868266153803441967666852229.721718905557186743113598487671696846911462401792696156710523392644469163164018730776361427902697995');
INSERT INTO num_exp_mul VALUES (6,7,'518381597653272710759706990161813353013964971.94112444700333252670142309548723486749319488170608125761686480864823834293745732846727621192832091587815446146');
INSERT INTO num_exp_div VALUES (6,7,'181553836600368300053246853102.62471314607393926702451246827137236185780277265902670188041412377771812745503593379141779737193982302316767179');
INSERT INTO num_exp_add VALUES (6,8,'9701245686868266153803441967262959383.337279929993019296020657733323325178717918167437678298460150678517119754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (6,8,'9701245686868266153803441968177614155.477059880666232651665243744768445372805473302695635823504902308253979754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (6,8,'-4436645331597258508260787104077459923352563583.38551761185282728687457271297095310642520858060188574119238150655388750414010358247884581354136410723689271932');
INSERT INTO num_exp_div VALUES (6,8,'-21212912198933339722197148118.41702692554074178059026988242924859282616187917395375063086690687391369945784583250315131425601161852716068260');
INSERT INTO num_exp_add VALUES (6,9,'9701245686868266153803441967720286680.942589602884950693021321868024634414791375010726055010982526493385549754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (6,9,'9701245686868266153803441967720286857.871750207774301254664579610067136136732016459407259110982526493385549754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (6,9,'-858216628099702782208781036793646622277.65610398967427400471733149082793407744696447437421019075363746945591972108471938285467415479627326793725863718');
INSERT INTO num_exp_div VALUES (6,9,'-109662484733454130094845285818177123.80743745311517631425445057405119226571585991618849099485877148606520558390425842783512060828799894079015723175');
INSERT INTO num_exp_add VALUES (7,0,'53434539.68545099977243923072935225137418842885023333327396090427200310074108059093125006857544132591');
INSERT INTO num_exp_sub VALUES (7,0,'53434539.68545099977243923072935225137418842885023333327396090427200310074108059093125006857544132591');
INSERT INTO num_exp_mul VALUES (7,0,'0');
INSERT INTO num_exp_div VALUES (7,0,'NaN');
INSERT INTO num_exp_add VALUES (7,1,'6852398102745254.68545099977243923072935225137418842885023333327396090427200310074108059093125006857544132591');
INSERT INTO num_exp_sub VALUES (7,1,'-6852397995876175.31454900022756076927064774862581157114976666672603909572799689925891940906874993142455867409');
INSERT INTO num_exp_mul VALUES (7,1,'366154735506400417524126.93601516766992631704359744516379145673308396857521100653889582991884867371603707540117012565');
INSERT INTO num_exp_div VALUES (7,1,'.00000000779793282598724659616057330460929544868690852884436405723181707915992034007559391895791493459289515525');
INSERT INTO num_exp_add VALUES (7,2,'525485150595.58702015782894452252381185305387643741354232485602475697200310074108059093125006857544132591');
INSERT INTO num_exp_sub VALUES (7,2,'-525378281516.21611815828406606106510735030549957971307565830810294842799689925891940906874993142455867409');
INSERT INTO num_exp_mul VALUES (7,2,'28076201883583693660.00350847229956796729521143402294494056204979681151714785658178143895121870236433600734608395863553464022984154');
INSERT INTO num_exp_div VALUES (7,2,'.00010169644894402607530959549960237942647478704453960777621522060502442478551239823775126610901837201019464396');
INSERT INTO num_exp_add VALUES (7,3,'-7183563573679774924366799392814958293.84465162444739409894484348651451933718161921528849281629363770709371940906874993142455867409');
INSERT INTO num_exp_sub VALUES (7,3,'7183563573679774924366799392921827373.21555362399227256040354798926289619488208588183641462483764390857588059093125006857544132591');
INSERT INTO num_exp_mul VALUES (7,3,'-383850412860752140214977941214376419508971441.64853766387328157503303617779220482878356507136939255459801715605967618584200514415782027107678311360637469279');
INSERT INTO num_exp_div VALUES (7,3,'-.00000000000000000000000000000743844460167827231337383974611015540717122158096017871960134734329353616955505428');
INSERT INTO num_exp_add VALUES (7,4,'53426522.03461927454427996490655048009016717334236936886390160813899329514590830710211534343544132591');
INSERT INTO num_exp_sub VALUES (7,4,'53442557.33628272500059849655215402265820968435809729768402020040501290633625287476038479371544132591');
INSERT INTO num_exp_mul VALUES (7,4,'-428419481551.91091979257439585441278691349893536293534140263104157048723659713838420705474109022651735367098087738801229971');
INSERT INTO num_exp_div VALUES (7,4,'-6664.61296543554040178396452288744543917765130516235249626222613692257679922774603469209234287872286532205450509370');
INSERT INTO num_exp_add VALUES (7,5,'4747823160689824329427335.42899928584836608605984170598366903794474128369735778268164210584135028039075006857544132591');
INSERT INTO num_exp_sub VALUES (7,5,'-4747823160689824222558256.05809728630348762460113720323529218024427461714943597413763590435918909852824993142455867409');
INSERT INTO num_exp_mul VALUES (7,5,'253697745099383814416266256873628.09388421217492703014141892022030299188757972499344598114027622363729613814809560594993029524206557051553047087');
INSERT INTO num_exp_div VALUES (7,5,'.00000000000000001125453452602631237035947379187756977818558451849436510997229930267202542984369886433646981009');
INSERT INTO num_exp_add VALUES (7,6,'9701245686868266153803441967773721309.092620905102065204572302990420073704611929068340617965254529594126630345026518867927244079722697995');
INSERT INTO num_exp_sub VALUES (7,6,'-9701245686868266153803441967666852229.721718905557186743113598487671696846911462401792696156710523392644469163164018730776361427902697995');
INSERT INTO num_exp_mul VALUES (7,6,'518381597653272710759706990161813353013964971.94112444700333252670142309548723486749319488170608125761686480864823834293745732846727621192832091587815446146');
INSERT INTO num_exp_div VALUES (7,6,'.00000000000000000000000000000550800808578435406266000949366273914488678199879617817021132050626643874807083102');
INSERT INTO num_exp_add VALUES (7,7,'106869079.37090199954487846145870450274837685770046666654792180854400620148216118186250013715088265182');
INSERT INTO num_exp_sub VALUES (7,7,'0');
INSERT INTO num_exp_mul VALUES (7,7,'2855250031396037.82970186348811162897869811421391968258356445289563350707881869291919939436929675446969102848541921470313601432');
INSERT INTO num_exp_div VALUES (7,7,'1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
INSERT INTO num_exp_add VALUES (7,8,'-403892846.38443897556416744709294075434837166819354423435501785825037271412734940906874993142455867409');
INSERT INTO num_exp_sub VALUES (7,8,'510761925.75534097510904590855164525709674852589401090090293966679437891560951059093125006857544132591');
INSERT INTO num_exp_mul VALUES (7,8,'-24437078360195106.61775532935560945664594561185624591770686495291418879951545200038466124920668253672412650608767322893412836080');
INSERT INTO num_exp_div VALUES (7,8,'-.11684089191475839742999698631804494238116071933969015468084869409845327368400453085026864345646229985682752428');
INSERT INTO num_exp_add VALUES (7,9,'53434451.22087069732776394990772338035293756787991260893335885427200310074108059093125006857544132591');
INSERT INTO num_exp_sub VALUES (7,9,'53434628.15003130221711451155098112239543928982055405761456295427200310074108059093125006857544132591');
INSERT INTO num_exp_mul VALUES (7,9,'-4727064126.92774680939533644903727495138666053724481166215518840234455422542936620586652093286659770638097126714773847381');
INSERT INTO num_exp_div VALUES (7,9,'-604021.85261906863396112566636394870498751375013754545184252388569969607878133650023991212612393325494917285573742290');
INSERT INTO num_exp_add VALUES (8,0,'-457327386.06988997533660667782229300572256009704377756762897876252237581486843');
INSERT INTO num_exp_sub VALUES (8,0,'-457327386.06988997533660667782229300572256009704377756762897876252237581486843');
INSERT INTO num_exp_mul VALUES (8,0,'0');
INSERT INTO num_exp_div VALUES (8,0,'NaN');
INSERT INTO num_exp_add VALUES (8,1,'6852397591983328.93011002466339332217770699427743990295622243237102123747762418513157');
INSERT INTO num_exp_sub VALUES (8,1,'-6852398506638101.06988997533660667782229300572256009704377756762897876252237581486843');
INSERT INTO num_exp_mul VALUES (8,1,'-3133789288201682323403927.58107656590501917041554111733256373697509660048884635492500991422745');
INSERT INTO num_exp_div VALUES (8,1,'-.00000006673975778682218982925202527292602156449579134093954877058233349370395355398796916438043136234182508291');
INSERT INTO num_exp_add VALUES (8,2,'524974388669.83167918271989861397216659595712791151953142395308509017762418513157');
INSERT INTO num_exp_sub VALUES (8,2,'-525889043441.97145913339311196961675260740224810560708655921104261522237581486843');
INSERT INTO num_exp_mul VALUES (8,2,'-240294313262062104172.57008604035226619329878446787997689662213618394614525847877837975225596982199796733079277898459628666403053781');
INSERT INTO num_exp_div VALUES (8,2,'-.00087038405199969721861950974093033765335432881469015912643295936426586929062451906280027148164045320955252424');
INSERT INTO num_exp_add VALUES (8,3,'-7183563573679774924366799393325720219.59999259955644000749648874361126786307563011619143248308801662270323');
INSERT INTO num_exp_sub VALUES (8,3,'7183563573679774924366799392411065447.46021264888322665185190273216614766898807498093347495804326499296637');
INSERT INTO num_exp_mul VALUES (8,3,'3285240351817848948222441668458099419176314234.83026886164131999404846585810047193235776483532725591898875533198446748528511630887584555789179109742052077784');
INSERT INTO num_exp_div VALUES (8,3,'.00000000000000000000000000006366302481758707022947783891525820598937167019529123941506335989490366951291651770');
INSERT INTO num_exp_add VALUES (8,4,'-457335403.72072170056476594364509477700658135255164153203903805865538562046360228382913472514');
INSERT INTO num_exp_sub VALUES (8,4,'-457319368.41905825010844741199949123443853884153591360321891946638936600927325771617086527486');
INSERT INTO num_exp_mul VALUES (8,4,'3666691297293.97788321743063439981529428519197889561260417645723204001221361540886128079152654913432878259494652243560834573');
INSERT INTO num_exp_div VALUES (8,4,'57040.07266820359097165285592802247402088276302456353580160923735114406538678397757173567075990953280972427783183890');
INSERT INTO num_exp_add VALUES (8,5,'4747823160689823818665409.6736583107393201775081964488869205120507303827944181158872631902318396894595');
INSERT INTO num_exp_sub VALUES (8,5,'-4747823160689824733320181.8134382614125335331527824603320407061382855180523756409320148199686996894595');
INSERT INTO num_exp_mul VALUES (8,5,'-2171309555600360536542309614639934.18527920929237061669865442023163442513541166788766161660729207417673317666205633343522420482590845063570299430');
INSERT INTO num_exp_div VALUES (8,5,'-.00000000000000009632359306395135881392889744782354604153423868858633005566396619968061838330569793195435408337');
INSERT INTO num_exp_add VALUES (8,6,'9701245686868266153803441967262959383.337279929993019296020657733323325178717918167437678298460150678517119754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (8,6,'-9701245686868266153803441968177614155.477059880666232651665243744768445372805473302695635823504902308253979754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (8,6,'-4436645331597258508260787104077459923352563583.38551761185282728687457271297095310642520858060188574119238150655388750414010358247884581354136410723689271932');
INSERT INTO num_exp_div VALUES (8,6,'-.00000000000000000000000000004714109928057325094922837067291460432585431221676080602577444958004594990961984129');
INSERT INTO num_exp_add VALUES (8,7,'-403892846.38443897556416744709294075434837166819354423435501785825037271412734940906874993142455867409');
INSERT INTO num_exp_sub VALUES (8,7,'-510761925.75534097510904590855164525709674852589401090090293966679437891560951059093125006857544132591');
INSERT INTO num_exp_mul VALUES (8,7,'-24437078360195106.61775532935560945664594561185624591770686495291418879951545200038466124920668253672412650608767322893412836080');
INSERT INTO num_exp_div VALUES (8,7,'-8.55864743594693562654215282204810236853373734846335142833731740131780088028223221047887965810090089076885869815');
INSERT INTO num_exp_add VALUES (8,8,'-914654772.13977995067321335564458601144512019408755513525795752504475162973686');
INSERT INTO num_exp_sub VALUES (8,8,'0');
INSERT INTO num_exp_mul VALUES (8,8,'209148338049518195.46147421280977835537533318159768437140456419049969529946123627635829712381272479085491544481928872224876381196');
INSERT INTO num_exp_div VALUES (8,8,'1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
INSERT INTO num_exp_add VALUES (8,9,'-457327474.53447027778128195864392187674381095801409829196958081252237581486843');
INSERT INTO num_exp_sub VALUES (8,9,'-457327297.60530967289193139700066413470130923607345684328837671252237581486843');
INSERT INTO num_exp_mul VALUES (8,9,'40457275269.48690009129809073865538418745618658277549727740379099106561690468240315984956219546180862526146449715460933575');
INSERT INTO num_exp_div VALUES (8,9,'5169610.08017410960759533172255156978562679171902589850282633922525554782047599255059091712428841316058723921289942593');
INSERT INTO num_exp_add VALUES (9,0,'-88.46458030244467528082162887102125086097032072434060205');
INSERT INTO num_exp_sub VALUES (9,0,'-88.46458030244467528082162887102125086097032072434060205');
INSERT INTO num_exp_mul VALUES (9,0,'0');
INSERT INTO num_exp_div VALUES (9,0,'NaN');
INSERT INTO num_exp_add VALUES (9,1,'6852398049310626.53541969755532471917837112897874913902967927565939795');
INSERT INTO num_exp_sub VALUES (9,1,'-6852398049310803.46458030244467528082162887102125086097032072434060205');
INSERT INTO num_exp_mul VALUES (9,1,'-606194517497562994.89341475407266858445191196393964220150276889061596575');
INSERT INTO num_exp_div VALUES (9,1,'-.00000000000001291001772895305707629215101096663323149542611747604575326508888330550598865593274976060455294460');
INSERT INTO num_exp_add VALUES (9,2,'525431715967.4369888556118300109728307306584371475929882672414618027');
INSERT INTO num_exp_sub VALUES (9,2,'-525431716144.3661494605011805726160884727009388695336297159226659027');
INSERT INTO num_exp_mul VALUES (9,2,'-46482096238478.613581680444636219005909359701263673629654426638484216602633133680256167198216278769487022282377046260518035');
INSERT INTO num_exp_div VALUES (9,2,'-.00000000016836551277584617469979870389408160645267825773282170473200797176185987414552840286438934378841124881');
INSERT INTO num_exp_add VALUES (9,3,'-7183563573679774924366799392868392921.9946829266645086104958246089099586270021732729030557705656408078348');
INSERT INTO num_exp_sub VALUES (9,3,'7183563573679774924366799392868392745.0655223217751580488525668668674569050615318242218516705656408078348');
INSERT INTO num_exp_mul VALUES (9,3,'635490936621510895579358779166912464979.64999728795126299308567330855891403287469456952463171290912677155132266356781303629278882882222680636499242710');
INSERT INTO num_exp_div VALUES (9,3,'.00000000000000000000000000000000001231486008233776400655551884814848001297385164241726426027649606859895876556');
INSERT INTO num_exp_add VALUES (9,4,'-8106.11541202767283454664443064230527211647818468875066134613300980559517228382913472514');
INSERT INTO num_exp_sub VALUES (9,4,'7929.18625142278348398500117290026277039453754324006945724613300980559517228382913472514');
INSERT INTO num_exp_mul VALUES (9,4,'709278.11584011878682977020872729678966266393583171903113139348667196307625463972329472789053139421561199495187375671');
INSERT INTO num_exp_div VALUES (9,4,'.01103372822777429141804860051118513201840667235263710024328865278488911767880810093730155091044225188213147928');
INSERT INTO num_exp_add VALUES (9,5,'4747823160689824275992707.2789679836312515745088605835882297481241872260827948284096390051002696894595');
INSERT INTO num_exp_sub VALUES (9,5,'-4747823160689824275992884.2081285885206021361521183256307314700648286747639989284096390051002696894595');
INSERT INTO num_exp_mul VALUES (9,5,'-420014183260651648975104871.01501517293451674610509452693657236642010482464239698862725619913226384637831008184195891630734293511490447273');
INSERT INTO num_exp_div VALUES (9,5,'-.00000000000000000000001863266118142264870529164360186910776772016528944048239429544787827650862323300013747557');
INSERT INTO num_exp_add VALUES (9,6,'9701245686868266153803441967720286680.942589602884950693021321868024634414791375010726055010982526493385549754095268799351802753812697995');
INSERT INTO num_exp_sub VALUES (9,6,'-9701245686868266153803441967720286857.871750207774301254664579610067136136732016459407259110982526493385549754095268799351802753812697995');
INSERT INTO num_exp_mul VALUES (9,6,'-858216628099702782208781036793646622277.65610398967427400471733149082793407744696447437421019075363746945591972108471938285467415479627326793725863718');
INSERT INTO num_exp_div VALUES (9,6,'-.00000000000000000000000000000000000911888876520171997277860851284675090031988557709556641805481108109429450354');
INSERT INTO num_exp_add VALUES (9,7,'53434451.22087069732776394990772338035293756787991260893335885427200310074108059093125006857544132591');
INSERT INTO num_exp_sub VALUES (9,7,'-53434628.15003130221711451155098112239543928982055405761456295427200310074108059093125006857544132591');
INSERT INTO num_exp_mul VALUES (9,7,'-4727064126.92774680939533644903727495138666053724481166215518840234455422542936620586652093286659770638097126714773847381');
INSERT INTO num_exp_div VALUES (9,7,'-.00000165556924085436732119457986192259321779035032416299324257235051659933468822744404083112985306222572146505');
INSERT INTO num_exp_add VALUES (9,8,'-457327474.53447027778128195864392187674381095801409829196958081252237581486843');
INSERT INTO num_exp_sub VALUES (9,8,'457327297.60530967289193139700066413470130923607345684328837671252237581486843');
INSERT INTO num_exp_mul VALUES (9,8,'40457275269.48690009129809073865538418745618658277549727740379099106561690468240315984956219546180862526146449715460933575');
INSERT INTO num_exp_div VALUES (9,8,'.00000019343818672806374464799564083106220104408680110606787008963930094478177102234986342203583926735871213746');
INSERT INTO num_exp_add VALUES (9,9,'-176.92916060488935056164325774204250172194064144868120410');
INSERT INTO num_exp_sub VALUES (9,9,'0');
INSERT INTO num_exp_mul VALUES (9,9,'7825.9819680876824353813165117031758895748211419410480842648876550254923700642812148610453966316197781564642025');
INSERT INTO num_exp_div VALUES (9,9,'1.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
COMMIT TRANSACTION;
BEGIN TRANSACTION;
INSERT INTO num_exp_sqrt VALUES (0,'0');
INSERT INTO num_exp_sqrt VALUES (1,'82779212.66423542760222999415652009344925738073915837614821193109309420118605390083060198169171955941073427419591528140');
INSERT INTO num_exp_sqrt VALUES (2,'724866.68847168137000632397007099860124058043374219941099882409384303152232224978118925807488122600343974343607479118');
INSERT INTO num_exp_sqrt VALUES (3,'2680217075850345171.88196640406923417693382574660773345330139700357974434460287117998802805478786898714039958802540677940512519495');
INSERT INTO num_exp_sqrt VALUES (4,'89.54133588307261880475968288318953098365925657601845689456257739132706954213162805873882344888656742804582878111');
INSERT INTO num_exp_sqrt VALUES (5,'2178950013352.72128724790150499667966249074035360831306312229438701962852691684443455740530726878600840905532152033691064519');
INSERT INTO num_exp_sqrt VALUES (6,'3114682277033769323.17554353241862821115650235534388404280399992637692640572843023530728264618381575495312944763519151785658407213');
INSERT INTO num_exp_sqrt VALUES (7,'7309.89327455955404473707846916853816170421796014731086138308666459834271573417555928214224682985588993775252802327');
INSERT INTO num_exp_sqrt VALUES (8,'21385.21419275219640503007028264963482813608132312938753322325042084013505029094611890910078304232461297074648087266');
INSERT INTO num_exp_sqrt VALUES (9,'9.40556113703189296752644199571926126204602876253113544890661913896835858572275106318243130910533476203148601594');
COMMIT TRANSACTION;
BEGIN TRANSACTION;
INSERT INTO num_exp_ln VALUES (0,'NaN');
INSERT INTO num_exp_ln VALUES (1,'36.46337506611239198986575740778513692194134286874513006225055942324201086327621984120722262103932876899014975359');
INSERT INTO num_exp_ln VALUES (2,'26.98748607791818112968750282499850253559536483581550507614403780986631630186652602499252334298586709637493624849');
INSERT INTO num_exp_ln VALUES (3,'84.86485892717402299827721048180943121028719763473094180534985564178056662742225319896152863612515389095027398911');
INSERT INTO num_exp_ln VALUES (4,'8.98940074420297714273104754476252661430682228679548550393721697461941316027767535122998871806261239725664779265');
INSERT INTO num_exp_ln VALUES (5,'56.81972846290033763186095118143442918373184116016016474242637596705166691197023256454643279568542744413735877216');
INSERT INTO num_exp_ln VALUES (6,'85.16531764637629448175560344023324881119282232216042017574614223256908753122186246182556464878786246589214396382');
INSERT INTO num_exp_ln VALUES (7,'17.79396790542758129777975238612587915276488642586236571392837700902243218530603078445629165401804087123861556216');
INSERT INTO num_exp_ln VALUES (8,'19.94091007327708214347415998348955208131504232514390799118860762820960020292347388375284056259258130846057482620');
INSERT INTO num_exp_ln VALUES (9,'4.48260224933220857711249879372697349030869469317922543884460969328037781902570995461908287745493326827937078089');
COMMIT TRANSACTION;
BEGIN TRANSACTION;
INSERT INTO num_exp_log10 VALUES (0,'NaN');
INSERT INTO num_exp_log10 VALUES (1,'15.83584258278123213770192821212081742830773247004161905643899382782954604164648848181226042719003073457528515836');
INSERT INTO num_exp_log10 VALUES (2,'11.72051628408069815777062182766771521909166097665532470231385118953593238718671157769558111470021426080817879662');
INSERT INTO num_exp_log10 VALUES (3,'36.85633993956959804404402508772011848195489303403783164511977332160036365297292239808202245285151168111022310476');
INSERT INTO num_exp_log10 VALUES (4,'3.90404713882433836854700076733103391688236710975934656964433614134726648364872644670053136969958643346242090238');
INSERT INTO num_exp_log10 VALUES (5,'24.67649453467875346730942090958601169021888957288714443592613105401972889964301393253496027104368022186207952396');
INSERT INTO num_exp_log10 VALUES (6,'36.98682750335886315923554289332794652291912278437661323543343807706047756030192311535682403510858764457686379022');
INSERT INTO num_exp_log10 VALUES (7,'7.72782207249076253454755712374947142777322910878349538169972139565819659394083248393369439896816719921473506746');
INSERT INTO num_exp_log10 VALUES (8,'8.66022720895320582740880938848882145147317451337213564363792947633197342190723411841775648178111348220302282953');
INSERT INTO num_exp_log10 VALUES (9,'1.94676942145208279492320002599754012465133710817685895586772814489736732110149811031399821981369003787605647079');
COMMIT TRANSACTION;
BEGIN TRANSACTION;
INSERT INTO num_exp_power_10_ln VALUES (0,'NaN');
INSERT INTO num_exp_power_10_ln VALUES (1,'2906531714553154916496462727917559523.86022124735372689754732927246362590772805600359563208762119559195331727942269696078292177491165624502108655438');
INSERT INTO num_exp_power_10_ln VALUES (2,'971596804814741079659294731.68435443259482866141583768792447375212463769203800808847909329354866117780781823020353758843090997034291396605');
INSERT INTO num_exp_power_10_ln VALUES (3,'7325865268019135022923480718584171235633662265228693243843601711744666931876619050667.91239964006293664748622752497418229452458402580475754363473941354551275628367131147170043511402847011870828369');
INSERT INTO num_exp_power_10_ln VALUES (4,'975889722.30439026472980946764530801756145231094840877960035980201151060076626894834061230173586346699988357789956085079');
INSERT INTO num_exp_power_10_ln VALUES (5,'660280486947429814254371608411133699198293665761246148918.75868060507615128497381215590536661505740705203009954484325506265900851308650709525713997971911507509225797577');
INSERT INTO num_exp_power_10_ln VALUES (6,'14632470134596428117644007742714007365205662768345829235167404819574353498209677300041.81338477441842153092807585776307603200640668955685156219007480174545151692124936760009644664491385965105537248');
INSERT INTO num_exp_power_10_ln VALUES (7,'622254298576118026.41579097094571851978652956749676514252627267361713463656094570175503004157521758087630036590505934841626033503');
INSERT INTO num_exp_power_10_ln VALUES (8,'87279062621759112378.26525304580557738925726591128525867144801776230682819936112762028929220374156316791455786720004543246868098174');
INSERT INTO num_exp_power_10_ln VALUES (9,'30381.01291598443394068317207312518955056869537011331054783886740569791317573951925984082753760470539381137645474531');
COMMIT TRANSACTION;
BEGIN TRANSACTION;
INSERT INTO num_data VALUES (0, '0');
INSERT INTO num_data VALUES (1, '6852398049310715');
INSERT INTO num_data VALUES (2, '525431716055.9015691580565052917944596016796880085633089915820638527');
INSERT INTO num_data VALUES (3, '-7183563573679774924366799392868392833.5301026242198333296741957378887077660318525485624537205656408078348');
INSERT INTO num_data VALUES (4, '-8017.65083172522815926582280177128402125550786396441005929613300980559517228382913472514');
INSERT INTO num_data VALUES (5, '4747823160689824275992795.7435482860759268553304894546094806090945079504233968784096390051002696894595');
INSERT INTO num_data VALUES (6, '9701245686868266153803441967720286769.407169905329625973842950739045885275761695735066657060982526493385549754095268799351802753812697995');
INSERT INTO num_data VALUES (7, '53434539.68545099977243923072935225137418842885023333327396090427200310074108059093125006857544132591');
INSERT INTO num_data VALUES (8, '-457327386.06988997533660667782229300572256009704377756762897876252237581486843');
INSERT INTO num_data VALUES (9, '-88.46458030244467528082162887102125086097032072434060205');
COMMIT TRANSACTION;

-- ******************************
-- * Create indices for faster checks
-- ******************************

CREATE UNIQUE INDEX num_exp_add_idx ON num_exp_add (id1, id2);
CREATE UNIQUE INDEX num_exp_sub_idx ON num_exp_sub (id1, id2);
CREATE UNIQUE INDEX num_exp_div_idx ON num_exp_div (id1, id2);
CREATE UNIQUE INDEX num_exp_mul_idx ON num_exp_mul (id1, id2);
CREATE UNIQUE INDEX num_exp_sqrt_idx ON num_exp_sqrt (id);
CREATE UNIQUE INDEX num_exp_ln_idx ON num_exp_ln (id);
CREATE UNIQUE INDEX num_exp_log10_idx ON num_exp_log10 (id);
CREATE UNIQUE INDEX num_exp_power_10_ln_idx ON num_exp_power_10_ln (id);

VACUUM ANALYZE num_exp_add;
VACUUM ANALYZE num_exp_sub;
VACUUM ANALYZE num_exp_div;
VACUUM ANALYZE num_exp_mul;
VACUUM ANALYZE num_exp_sqrt;
VACUUM ANALYZE num_exp_ln;
VACUUM ANALYZE num_exp_log10;
VACUUM ANALYZE num_exp_power_10_ln;

-- ******************************
-- * Now check the behaviour of the NUMERIC type
-- ******************************

-- ******************************
-- * Addition check
-- ******************************
DELETE FROM num_result;
INSERT INTO num_result SELECT t1.id, t2.id, t1.val + t2.val
    FROM num_data t1, num_data t2;
SELECT t1.id1, t1.id2, t1.result, t2.expected
    FROM num_result t1, num_exp_add t2
    WHERE t1.id1 = t2.id1 AND t1.id2 = t2.id2
    AND t1.result != t2.expected;

DELETE FROM num_result;
INSERT INTO num_result SELECT t1.id, t2.id, round(t1.val + t2.val, 10)
    FROM num_data t1, num_data t2;
SELECT t1.id1, t1.id2, t1.result, round(t2.expected, 10) as expected
    FROM num_result t1, num_exp_add t2
    WHERE t1.id1 = t2.id1 AND t1.id2 = t2.id2
    AND t1.result != round(t2.expected, 10);

-- ******************************
-- * Subtraction check
-- ******************************
DELETE FROM num_result;
INSERT INTO num_result SELECT t1.id, t2.id, t1.val - t2.val
    FROM num_data t1, num_data t2;
SELECT t1.id1, t1.id2, t1.result, t2.expected
    FROM num_result t1, num_exp_sub t2
    WHERE t1.id1 = t2.id1 AND t1.id2 = t2.id2
    AND t1.result != t2.expected;

DELETE FROM num_result;
INSERT INTO num_result SELECT t1.id, t2.id, round(t1.val - t2.val, 40)
    FROM num_data t1, num_data t2;
SELECT t1.id1, t1.id2, t1.result, round(t2.expected, 40)
    FROM num_result t1, num_exp_sub t2
    WHERE t1.id1 = t2.id1 AND t1.id2 = t2.id2
    AND t1.result != round(t2.expected, 40);

-- ******************************
-- * Multiply check
-- ******************************
DELETE FROM num_result;
INSERT INTO num_result SELECT t1.id, t2.id, t1.val * t2.val
    FROM num_data t1, num_data t2;
SELECT t1.id1, t1.id2, t1.result, t2.expected
    FROM num_result t1, num_exp_mul t2
    WHERE t1.id1 = t2.id1 AND t1.id2 = t2.id2
    AND t1.result != t2.expected;

DELETE FROM num_result;
INSERT INTO num_result SELECT t1.id, t2.id, round(t1.val * t2.val, 30)
    FROM num_data t1, num_data t2;
SELECT t1.id1, t1.id2, t1.result, round(t2.expected, 30) as expected
    FROM num_result t1, num_exp_mul t2
    WHERE t1.id1 = t2.id1 AND t1.id2 = t2.id2
    AND t1.result != round(t2.expected, 30);

-- ******************************
-- * Division check
-- ******************************
DELETE FROM num_result;
INSERT INTO num_result SELECT t1.id, t2.id, t1.val / t2.val
    FROM num_data t1, num_data t2
    WHERE t2.val != '0.0';
SELECT t1.id1, t1.id2, t1.result, t2.expected
    FROM num_result t1, num_exp_div t2
    WHERE t1.id1 = t2.id1 AND t1.id2 = t2.id2
    AND t1.result != t2.expected;

DELETE FROM num_result;
INSERT INTO num_result SELECT t1.id, t2.id, round(t1.val / t2.val, 80)
    FROM num_data t1, num_data t2
    WHERE t2.val != '0.0';
SELECT t1.id1, t1.id2, t1.result, round(t2.expected, 80) as expected
    FROM num_result t1, num_exp_div t2
    WHERE t1.id1 = t2.id1 AND t1.id2 = t2.id2
    AND t1.result != round(t2.expected, 80);

-- ******************************
-- * Square root check
-- ******************************
DELETE FROM num_result;
INSERT INTO num_result SELECT id, 0, SQRT(ABS(val))
    FROM num_data;
SELECT t1.id1, t1.result, t2.expected
    FROM num_result t1, num_exp_sqrt t2
    WHERE t1.id1 = t2.id
    AND t1.result != t2.expected;

-- ******************************
-- * Natural logarithm check
-- ******************************
DELETE FROM num_result;
INSERT INTO num_result SELECT id, 0, LN(ABS(val))
    FROM num_data
    WHERE val != '0.0';
SELECT t1.id1, t1.result, t2.expected
    FROM num_result t1, num_exp_ln t2
    WHERE t1.id1 = t2.id
    AND t1.result != t2.expected;

-- ******************************
-- * Logarithm base 10 check
-- ******************************
DELETE FROM num_result;
INSERT INTO num_result SELECT id, 0, LOG('10'::numeric, ABS(val))
    FROM num_data
    WHERE val != '0.0';
SELECT t1.id1, t1.result, t2.expected
    FROM num_result t1, num_exp_log10 t2
    WHERE t1.id1 = t2.id
    AND t1.result != t2.expected;

-- ******************************
-- * POWER(10, LN(value)) check
-- ******************************
DELETE FROM num_result;
INSERT INTO num_result SELECT id, 0, POWER('10'::numeric, LN(ABS(round(val,300))))
    FROM num_data
    WHERE val != '0.0';
SELECT t1.id1, t1.result, t2.expected
    FROM num_result t1, num_exp_power_10_ln t2
    WHERE t1.id1 = t2.id
    AND t1.result != t2.expected;

-- ******************************
-- * Tidy up in case numeric_big will follow
-- ******************************
DROP TABLE num_data;
DROP TABLE num_exp_add;
DROP TABLE num_exp_sub;
DROP TABLE num_exp_div;
DROP TABLE num_exp_mul;
DROP TABLE num_exp_sqrt;
DROP TABLE num_exp_ln;
DROP TABLE num_exp_log10;
DROP TABLE num_exp_power_10_ln;
DROP TABLE num_result;
