.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP TRIGGER" "" "2010-12-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP TRIGGER \- remove a trigger

.SH SYNOPSIS
.sp
.nf
DROP TRIGGER \fIname\fR ON \fItable\fR [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP TRIGGER\fR will remove an existing
trigger definition. To execute this command, the current
user must be the owner of the table for which the trigger is defined.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the trigger to remove.
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of the table for which
the trigger is defined.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the trigger.
.TP
\fBRESTRICT\fR
Refuse to drop the trigger if any objects depend on it. This is
the default.
.SH "EXAMPLES"
.PP
Destroy the trigger if_dist_exists on the table
films:
.sp
.nf
DROP TRIGGER if_dist_exists ON films;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBDROP TRIGGER\fR statement in
PostgreSQL is incompatible with the SQL
standard. In the SQL standard, trigger names are not local to
tables, so the command is simply DROP TRIGGER
\fIname\fR.
.SH "SEE ALSO"
CREATE TRIGGER [\fBcreate_trigger\fR(l)]
