.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "GRANT" "" "2011-01-27" "SQL - Language Statements" "SQL Commands"
.SH NAME
GRANT \- define access privileges

.SH SYNOPSIS
.sp
.nf
GRANT { { SELECT | INSERT | UPDATE | DELETE | REFERENCES | TRIGGER }
    [,...] | ALL [ PRIVILEGES ] }
    ON [ TABLE ] \fItablename\fR [, ...]
    TO { [ GROUP ] \fIrolename\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT { { USAGE | SELECT | UPDATE }
    [,...] | ALL [ PRIVILEGES ] }
    ON SEQUENCE \fIsequencename\fR [, ...]
    TO { [ GROUP ] \fIrolename\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT { { CREATE | CONNECT | TEMPORARY | TEMP } [,...] | ALL [ PRIVILEGES ] }
    ON DATABASE \fIdbname\fR [, ...]
    TO { [ GROUP ] \fIrolename\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT { EXECUTE | ALL [ PRIVILEGES ] }
    ON FUNCTION \fIfuncname\fR ( [ [ \fIargmode\fR ] [ \fIargname\fR ] \fIargtype\fR [, ...] ] ) [, ...]
    TO { [ GROUP ] \fIrolename\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT { USAGE | ALL [ PRIVILEGES ] }
    ON LANGUAGE \fIlangname\fR [, ...]
    TO { [ GROUP ] \fIrolename\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT { { CREATE | USAGE } [,...] | ALL [ PRIVILEGES ] }
    ON SCHEMA \fIschemaname\fR [, ...]
    TO { [ GROUP ] \fIrolename\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT { CREATE | ALL [ PRIVILEGES ] }
    ON TABLESPACE \fItablespacename\fR [, ...]
    TO { [ GROUP ] \fIrolename\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT \fIrole\fR [, ...] TO \fIrolename\fR [, ...] [ WITH ADMIN OPTION ]
.sp
.fi
.SH "DESCRIPTION"
.PP
The \fBGRANT\fR command has two basic variants: one
that grants privileges on a database object (table, view, sequence,
database, function, procedural language, schema, or tablespace),
and one that grants membership in a role. These variants are
similar in many ways, but they are different enough to be described
separately.
.PP
As of PostgreSQL 8.1, the concepts of users and
groups have been unified into a single kind of entity called a role.
It is therefore no longer necessary to use the keyword GROUP
to identify whether a grantee is a user or a group. GROUP
is still allowed in the command, but it is a noise word.
.SS "GRANT ON DATABASE OBJECTS"
.PP
This variant of the \fBGRANT\fR command gives specific
privileges on a database object to
one or more roles. These privileges are added
to those already granted, if any.
.PP
The key word PUBLIC indicates that the
privileges are to be granted to all roles, including those that might
be created later. PUBLIC can be thought of as an
implicitly defined group that always includes all roles.
Any particular role will have the sum
of privileges granted directly to it, privileges granted to any role it
is presently a member of, and privileges granted to
PUBLIC.
.PP
If WITH GRANT OPTION is specified, the recipient
of the privilege can in turn grant it to others. Without a grant
option, the recipient cannot do that. Grant options cannot be granted
to PUBLIC.
.PP
There is no need to grant privileges to the owner of an object
(usually the user that created it),
as the owner has all privileges by default. (The owner could,
however, choose to revoke some of his own privileges for safety.)
The right to drop an object, or to alter its definition in any way is
not described by a grantable privilege; it is inherent in the owner,
and cannot be granted or revoked. The owner implicitly has all grant
options for the object, too.
.PP
Depending on the type of object, the initial default privileges might
include granting some privileges to PUBLIC.
The default is no public access for tables, schemas, and tablespaces;
CONNECT privilege and TEMP table creation privilege
for databases;
EXECUTE privilege for functions; and
USAGE privilege for languages.
The object owner can of course revoke these privileges. (For maximum
security, issue the \fBREVOKE\fR in the same transaction that
creates the object; then there is no window in which another user
can use the object.)
.PP
The possible privileges are:
.TP
\fBSELECT\fR
Allows SELECT [\fBselect\fR(l)] from
any column of the specified table, view, or sequence.
Also allows the use of
COPY [\fBcopy\fR(l)] TO.
This privilege is also needed to reference existing column values in
UPDATE [\fBupdate\fR(l)] or
DELETE [\fBdelete\fR(l)].
For sequences, this privilege also allows the use of the
\fBcurrval\fR function.
.TP
\fBINSERT\fR
Allows INSERT [\fBinsert\fR(l)] of a new
row into the specified table.
Also allows COPY [\fBcopy\fR(l)] FROM.
.TP
\fBUPDATE\fR
Allows UPDATE [\fBupdate\fR(l)] of any
column of the specified table.
(In practice, any nontrivial \fBUPDATE\fR command will require
SELECT privilege as well, since it must reference table
columns to determine which rows to update, and/or to compute new
values for columns.)
SELECT ... FOR UPDATE
and SELECT ... FOR SHARE
also require this privilege, in addition to the
SELECT privilege. For sequences, this
privilege allows the use of the \fBnextval\fR and
\fBsetval\fR functions.
.TP
\fBDELETE\fR
Allows DELETE [\fBdelete\fR(l)] of a row
from the specified table.
(In practice, any nontrivial \fBDELETE\fR command will require
SELECT privilege as well, since it must reference table
columns to determine which rows to delete.)
.TP
\fBREFERENCES\fR
To create a foreign key constraint, it is
necessary to have this privilege on both the referencing and
referenced tables.
.TP
\fBTRIGGER\fR
Allows the creation of a trigger on the specified table. (See the
CREATE TRIGGER [\fBcreate_trigger\fR(l)] statement.)
.TP
\fBCREATE\fR
For databases, allows new schemas to be created within the database.

For schemas, allows new objects to be created within the schema.
To rename an existing object, you must own the object \fBand\fR
have this privilege for the containing schema.

For tablespaces, allows tables, indexes, and temporary files to be
created within the tablespace, and allows databases to be created that
have the tablespace as their default tablespace. (Note that revoking
this privilege will not alter the placement of existing objects.)
.TP
\fBCONNECT\fR
Allows the user to connect to the specified database. This
privilege is checked at connection startup (in addition to checking
any restrictions imposed by \fIpg_hba.conf\fR).
.TP
\fBTEMPORARY\fR
.TP
\fBTEMP\fR
Allows temporary tables to be created while using the specified database.
.TP
\fBEXECUTE\fR
Allows the use of the specified function and the use of any
operators that are implemented on top of the function. This is
the only type of privilege that is applicable to functions.
(This syntax works for aggregate functions, as well.)
.TP
\fBUSAGE\fR
For procedural languages, allows the use of the specified language for
the creation of functions in that language. This is the only type
of privilege that is applicable to procedural languages.

For schemas, allows access to objects contained in the specified
schema (assuming that the objects' own privilege requirements are
also met). Essentially this allows the grantee to ``look up''
objects within the schema. Without this permission, it is still
possible to see the object names, e.g. by querying the system tables.
Also, after revoking this permission, existing backends might have
statements that have previously performed this lookup, so this is not
a completely secure way to prevent object access.

For sequences, this privilege allows the use of the
\fBcurrval\fR and \fBnextval\fR functions.
.TP
\fBALL PRIVILEGES\fR
Grant all of the available privileges at once.
The PRIVILEGES key word is optional in
PostgreSQL, though it is required by
strict SQL.
.PP
The privileges required by other commands are listed on the
reference page of the respective command.
.SS "GRANT ON ROLES"
.PP
This variant of the \fBGRANT\fR command grants membership
in a role to one or more other roles. Membership in a role is significant
because it conveys the privileges granted to a role to each of its
members.
.PP
If WITH ADMIN OPTION is specified, the member can
in turn grant membership in the role to others, and revoke membership
in the role as well. Without the admin option, ordinary users cannot do
that. However,
database superusers can grant or revoke membership in any role to anyone.
Roles having CREATEROLE privilege can grant or revoke
membership in any role that is not a superuser.
.PP
Unlike the case with privileges, membership in a role cannot be granted
to PUBLIC. Note also that this form of the command does not
allow the noise word GROUP.
.SH "NOTES"
.PP
The REVOKE [\fBrevoke\fR(l)] command is used
to revoke access privileges.
.PP
When a non-owner of an object attempts to \fBGRANT\fR privileges
on the object, the command will fail outright if the user has no
privileges whatsoever on the object. As long as some privilege is
available, the command will proceed, but it will grant only those
privileges for which the user has grant options. The \fBGRANT ALL
PRIVILEGES\fR forms will issue a warning message if no grant options are
held, while the other forms will issue a warning if grant options for
any of the privileges specifically named in the command are not held.
(In principle these statements apply to the object owner as well, but
since the owner is always treated as holding all grant options, the
cases can never occur.)
.PP
It should be noted that database superusers can access
all objects regardless of object privilege settings. This
is comparable to the rights of root in a Unix system.
As with root, it's unwise to operate as a superuser
except when absolutely necessary.
.PP
If a superuser chooses to issue a \fBGRANT\fR or \fBREVOKE\fR
command, the command is performed as though it were issued by the
owner of the affected object. In particular, privileges granted via
such a command will appear to have been granted by the object owner.
(For role membership, the membership appears to have been granted
by the containing role itself.)
.PP
\fBGRANT\fR and \fBREVOKE\fR can also be done by a role
that is not the owner of the affected object, but is a member of the role
that owns the object, or is a member of a role that holds privileges
WITH GRANT OPTION on the object. In this case the
privileges will be recorded as having been granted by the role that
actually owns the object or holds the privileges
WITH GRANT OPTION. For example, if table
t1 is owned by role g1, of which role
u1 is a member, then u1 can grant privileges
on t1 to u2, but those privileges will appear
to have been granted directly by g1. Any other member
of role g1 could revoke them later.
.PP
If the role executing \fBGRANT\fR holds the required privileges
indirectly via more than one role membership path, it is unspecified
which containing role will be recorded as having done the grant. In such
cases it is best practice to use \fBSET ROLE\fR to become the
specific role you want to do the \fBGRANT\fR as.
.PP
Granting permission on a table does not automatically extend 
permissions to any sequences used by the table, including 
sequences tied to \fBSERIAL\fR columns. Permissions on 
sequence must be set separately.
.PP
Currently, PostgreSQL does not support
granting or revoking privileges for individual columns of a table.
One possible workaround is to create a view having just the desired
columns and then grant privileges to that view.
.PP
Use \fBpsql\fR(1)'s \fB\\z\fR command
to obtain information about existing privileges, for example:
.sp
.nf
=> \\z mytable
                  Access privileges for database "lusitania"
 Schema |  Name   | Type  |                 Access privileges                 
--------+---------+-------+---------------------------------------------------
 public | mytable | table | {miriam=arwdxt/miriam,=r/miriam,admin=arw/miriam}
(1 row)
.sp
.fi
The entries shown by \fB\\z\fR are interpreted thus:
.sp
.nf
      rolename=xxxx -- privileges granted to a role
              =xxxx -- privileges granted to PUBLIC

                  r -- SELECT ("read")
                  w -- UPDATE ("write")
                  a -- INSERT ("append")
                  d -- DELETE
                  x -- REFERENCES
                  t -- TRIGGER
                  X -- EXECUTE
                  U -- USAGE
                  C -- CREATE
                  c -- CONNECT
                  T -- TEMPORARY
             arwdxt -- ALL PRIVILEGES (for tables)
                  * -- grant option for preceding privilege

              /yyyy -- role that granted this privilege
.sp
.fi
The above example display would be seen by user miriam after
creating table mytable and doing:
.sp
.nf
GRANT SELECT ON mytable TO PUBLIC;
GRANT SELECT, UPDATE, INSERT ON mytable TO admin;
.sp
.fi
.PP
If the ``Access privileges'' column is empty for a given object,
it means the object has default privileges (that is, its privileges column
is null). Default privileges always include all privileges for the owner,
and can include some privileges for PUBLIC depending on the
object type, as explained above. The first \fBGRANT\fR or
\fBREVOKE\fR on an object
will instantiate the default privileges (producing, for example,
{miriam=arwdxt/miriam}) and then modify them per the
specified request.
.PP
Notice that the owner's implicit grant options are not marked in the
access privileges display. A * will appear only when
grant options have been explicitly granted to someone.
.SH "EXAMPLES"
.PP
Grant insert privilege to all users on table films:
.sp
.nf
GRANT INSERT ON films TO PUBLIC;
.sp
.fi
.PP
Grant all available privileges to user manuel on view
kinds:
.sp
.nf
GRANT ALL PRIVILEGES ON kinds TO manuel;
.sp
.fi
Note that while the above will indeed grant all privileges if executed by a
superuser or the owner of kinds, when executed by someone
else it will only grant those permissions for which the someone else has
grant options.
.PP
Grant membership in role admins to user joe:
.sp
.nf
GRANT admins TO joe;
.sp
.fi
.SH "COMPATIBILITY"
.PP
According to the SQL standard, the PRIVILEGES
key word in ALL PRIVILEGES is required. The
SQL standard does not support setting the privileges on more than
one object per command.
.PP
PostgreSQL allows an object owner to revoke his
own ordinary privileges: for example, a table owner can make the table
read-only to himself by revoking his own INSERT, UPDATE, and DELETE
privileges. This is not possible according to the SQL standard. The
reason is that PostgreSQL treats the owner's
privileges as having been granted by the owner to himself; therefore he
can revoke them too. In the SQL standard, the owner's privileges are
granted by an assumed entity ``_SYSTEM''. Not being
``_SYSTEM'', the owner cannot revoke these rights.
.PP
PostgreSQL does not support the SQL-standard 
functionality of setting privileges for individual columns.
.PP
The SQL standard provides for a USAGE privilege
on other kinds of objects: character sets, collations,
translations, domains.
.PP
Privileges on databases, tablespaces, schemas, and languages are
PostgreSQL extensions.
.SH "SEE ALSO"
.PP
REVOKE [\fBrevoke\fR(l)]
