/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtWaylandCompositor module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef WLDATADEVICE_H
#define WLDATADEVICE_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QtWaylandCompositor/private/qwayland-server-wayland.h>
#include <QtWaylandCompositor/private/qtwaylandcompositorglobal_p.h>
#include <QtWaylandCompositor/QWaylandSeat>

QT_REQUIRE_CONFIG(wayland_datadevice);

QT_BEGIN_NAMESPACE

namespace QtWayland {

class Compositor;
class DataSource;
class Seat;
class Surface;

class DataDevice : public QtWaylandServer::wl_data_device
{
public:
    DataDevice(QWaylandSeat *seat);

    void setFocus(QWaylandClient *client);
    void sourceDestroyed(DataSource *source);

#if QT_CONFIG(draganddrop)
    void setDragFocus(QWaylandSurface *focus, const QPointF &localPosition);

    QWaylandSurface *dragIcon() const;
    QWaylandSurface *dragOrigin() const;

    void dragMove(QWaylandSurface *target, const QPointF &pos);
    void drop();
    void cancelDrag();
#endif

protected:
#if QT_CONFIG(draganddrop)
    void data_device_start_drag(Resource *resource, struct ::wl_resource *source, struct ::wl_resource *origin, struct ::wl_resource *icon, uint32_t serial) override;
#endif
    void data_device_set_selection(Resource *resource, struct ::wl_resource *source, uint32_t serial) override;

private:
#if QT_CONFIG(draganddrop)
    void setDragIcon(QWaylandSurface *icon);
#endif

    QWaylandCompositor *m_compositor = nullptr;
    QWaylandSeat *m_seat = nullptr;

    DataSource *m_selectionSource = nullptr;

#if QT_CONFIG(draganddrop)
    struct ::wl_client *m_dragClient = nullptr;
    DataSource *m_dragDataSource = nullptr;

    QWaylandSurface *m_dragFocus = nullptr;
    Resource *m_dragFocusResource = nullptr;

    QWaylandSurface *m_dragIcon = nullptr;
    QWaylandSurface *m_dragOrigin = nullptr;
#endif
};

}

QT_END_NAMESPACE

#endif // WLDATADEVICE_H
