// Copyright (C) 2017 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
#include "qquickdragaxis_p.h"
#include <limits>

QT_BEGIN_NAMESPACE

QQuickDragAxis::QQuickDragAxis()
  : m_minimum(-std::numeric_limits<qreal>::max())
  , m_maximum(std::numeric_limits<qreal>::max())
  , m_enabled(true)
{
}

void QQuickDragAxis::setMinimum(qreal minimum)
{
    if (m_minimum == minimum)
        return;

    m_minimum = minimum;
    emit minimumChanged();
}

void QQuickDragAxis::setMaximum(qreal maximum)
{
    if (m_maximum == maximum)
        return;

    m_maximum = maximum;
    emit maximumChanged();
}

void QQuickDragAxis::setEnabled(bool enabled)
{
    if (m_enabled == enabled)
        return;

    m_enabled = enabled;
    emit enabledChanged();
}

QT_END_NAMESPACE

#include "moc_qquickdragaxis_p.cpp"
