import QtQuick
import QtQuick3D
Node {
    id: rootNode
    property real chargeVal: 0.5
    Model {
        id: battery
        x: -3.62646
        y: 3.39142
        z: -0.205271
        rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
        scale.x: 100
        scale.y: 100
        scale.z: 100
        source: "meshes/battery.mesh"

        CustomMaterial {
            id: customMaterial
            property real chargeValue: rootNode.chargeVal
            property color charge: "#4f444f"
            property color base: "white"
            shadingMode: CustomMaterial.Shaded
            depthDrawMode: Material.OpaqueOnlyDepthDraw
            alwaysDirty: true
            destinationBlend: CustomMaterial.NoBlend
            sourceBlend: CustomMaterial.NoBlend
            vertexShader: "../../../Outrun_ClusterContent/charger.vert"
            fragmentShader: "../../../Outrun_ClusterContent/charger.frag"
        }
        materials: [
            customMaterial
        ]
    }
}
