import QtQuick
import QtQuick3D
import QtQuick.Timeline 1.0
Node {
    id: rootNode
    property real bending: 0
    property real moving: 0
    property bool night: false
    property bool citymode: false
    property color currentsky: "black"
    property real terrainZ: 0
    property real terrainZLeftover: 0

    onTerrainZChanged: {
        if (terrainZ + terrainZLeftover <= -80000) {
            // This will cause a jump if speed has changed, but it will prevent the tearing of
            // the terrain.
            // TODO: There might be a more elegant way to handlee this.
            terrainZLeftover = 0;
        }
    }

    Terrain {
        id: terrain
        skycolor: currentsky
        y: (z >= -40000 && z <= 40000) ? -165.25999 : 15000
        city: citymode
        z: terrainZ + terrainZLeftover
        b:bending
        m:moving
        n: night
    }

    Terrain {
        id: terrain1
        skycolor: currentsky
        y: (z >= -40000 && z <= 40000) ? -165.25999 : 15000
        city: citymode
        z: 40000 + terrain.z
        b:bending
        m:moving
        n: night
    }

    Terrain {
        id: terrain2
        skycolor: currentsky
        y: (z >= -40000 && z <= 40000) ? -165.25999 : 15000
        city: citymode
        z: terrain.z < 0 ? 40000 + terrain1.z : terrain.z - 40000
        b:bending
        m:moving
        n: night
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                duration: (250 - mainScreen.globalDrivespeed) * 1000
                loops: -1
                running: true
                to: 60000
                from: 0
                onDurationChanged: {
                    if (duration === 250000) {
                        stop();
                        return;
                    }

                    if (timeline.currentFrame === 0)
                        return;

                    terrainZLeftover += terrainZ;

                    restart();
                }
            }
        ]
        startFrame: 0
        enabled: true
        endFrame: 60000

        KeyframeGroup {
            target: rootNode
            property: "terrainZ"

            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 20000
                value: -40000
            }

            Keyframe {
                frame: 39999
                value: -80000
            }

            Keyframe {
                frame: 40000
                value: 40000
            }

            Keyframe {
                frame: 60000
                value: 0
            }
        }
/*
        KeyframeGroup {
            target: rootNode
            property: "terrain1Z"

            Keyframe {
                frame: 0
                value: 40000
            }

            Keyframe {
                frame: 20000
                value: 0
            }

            Keyframe {
                frame: 40000
                value: -40000
            }

            Keyframe {
                frame: 40001
                value: 40000
            }
        }

        KeyframeGroup {
            target: rootNode
            property: "terrain2Z"

            Keyframe {
                frame: 0
                value: 40000
            }

            Keyframe {
                frame: 20000
                value: 40000
            }

            Keyframe {
                frame: 40000
                value: 0
            }

            Keyframe {
                frame: 60000
                value: -40000
            }
        }

        KeyframeGroup {
            target: rootNode
            property: "terrainY"

            Keyframe {
                frame: 0
                value: -165.25999
            }

            Keyframe {
                frame: 20000
                value: -165.25999
            }

            Keyframe {
                frame: 20001
                value: -15000
            }

            Keyframe {
                frame: 39999
                value: -15000
            }

            Keyframe {
                frame: 40000
                value: -165.25999
            }
        }

        KeyframeGroup {
            target: rootNode
            property: "terrain1Y"

            Keyframe {
                frame: 0
                value: -165.25999
            }

            Keyframe {
                frame: 20000
                value: -165.25999
            }

            Keyframe {
                frame: 40000
                value: -165.25999
            }

            Keyframe {
                frame: 40001
                value: -15000
            }
        }

        KeyframeGroup {
            target: rootNode
            property: "terrain2Y"

            Keyframe {
                frame: 0
                value: -15000
            }

            Keyframe {
                frame: 19999
                value: -15000
            }

            Keyframe {
                frame: 20000
                value: -165.25999
            }

            Keyframe {
                frame: 60000
                value: -165.25999
            }
        }*/
    }

}
