/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "common.h"
#include "calc.h"
#include "variant.h"
#include "variant_io.h"
#include "st_inst.h"

#define NOTHING		0x01
#define ARRY		0x10
#define IF			0x11
#define FOR			0x12
#define NEXT		0x13
#define GOTO		0x14
#define GOSUB		0x15
#define RETURN		0x16
#define INPUT		0x17
#define PRINT		0x18
#define CLR			0x19
#define LOCATION	0x1A
#define WAIT		0x1B
#define ABS			0x1C
#define SHELL		0x1D
#define LEN			0x1E
#define MID			0x1F
#define VAL			0x20
#define STR			0x21
#define EXP			0x22

unsigned int p_counter; //vOJE^
std::vector<std::string> source; //basic̃vOi[z
std::vector<unsigned long> jmp; //basic̃vȌz
std::vector<unsigned long> func; //basic̃vO̖߂z

void instcpy(char*out,char*in);
int basic_init(char*filename);
void basic_start(int adder);
void basic_end();

//ߕ̕
void instcpy(char*out,char*in){
	while(' '==*in || '\t'==*in) in++;//ŏ̃Xy[X菜
	while(*out=*in){
		if('\r'==*out || '\n'==*out || EOF==*out){//EOFAsR[h𖳎
			*out='\0';
			break;
		}

		//""ň͂܂ꂽ͏O
		if('\"'==*in){
			*out++=*in++;
			while('\"'!=*in){
				if('\0'==*in){*out='\0';return;}//"̖G[
				if('\\'==*in){
					*out++=*in++;//GXP[vV[PX̓ǂݍ
					if('\0'==*in){*out='\0';return;}//"̖G[
				}
				*out++=*in++;
			}
			*out=*in;
		}

		if('\''==*out){//'̓Rgƍl
			*out='\0';
			break;
		}

		if('\t'==*out){//tabXy[Xɒu
			*out=' ';
		}
		if(' '==*in && ' '==*(in+1))  out--;//AȂXy[X폜

		out++;in++;
	}
}

int basic_init(char*filename){
	//basicvOǂݍ݁AHăxN^[zɊi[
	FILE * fp;
	if((fp=fopen(filename,"r"))==NULL){
		//G[
		printf("%s\n","file open error");
		return 1;
	}else{
		char buff[MAX_STR_LEN]="";
		char buff2[MAX_STR_LEN]="";
		while(fgets(buff,MAX_STR_LEN,fp)!=NULL){
			instcpy(buff2,buff);
			if(*buff2){
				source.push_back(buff2);
				jmp.push_back(0);
				func.push_back(0);
			}
		}
		fclose(fp);
		source.push_back("\377");//EOFŌɒǉ
		jmp.push_back(0);
		jmp.push_back(0);
		func.push_back(0);
		func.push_back(0);
	}
	return 0;
}

void basic_start(int adder){
	static char buff[MAX_STR_LEN];
	p_counter=adder;
	int rst;
	unsigned int pos;
	while(1){
		char*str=buff;
		_strcpy(str,source[p_counter++].c_str());
		rst=0;

		//EOF̏
		if(*str==EOF){//EOF
			break;
		}

		//z񕶂̏
		if(!(func[p_counter]&0x80000000)) if(!arry_(str)) func[p_counter]|=0x80000000;

		//if̌ʂɂVtgl
		int if_shift=0;
		
		//IF̏
		if(!(func[p_counter]&0x40000000)){
			rst=if_(str,&p_counter,&jmp);
			//߂lɕ򌋉ʂĂ
			if(2==rst){
				//FALSȄꍇ
				if_shift=8;//Vtglݒ
			}else if(0==rst){
				//IFŖꍇ 1𗧂Ă
				func[p_counter]|=0x40000000;
			}
		}
		//ߕ󕶎̏ꍇ͎̍sɐi
		if('\0'==*str) {func[p_counter]|=(NOTHING<<if_shift);goto LOOP_LAST;}

		if(0==(func[p_counter]&(0x000000FF<<if_shift))){
			pos=p_counter;
			//foȑ
			if(for_(str)){func[pos]|=(FOR<<if_shift);}
			//next̏
			else if(next_(str,&source,&p_counter,&jmp)){func[pos]|=(NEXT<<if_shift);}
			//gotȍ
			else if(goto_(str,&source,&p_counter,&jmp)){func[pos]|=(GOTO<<if_shift);}
			//gosub̏
			else if(gosub_(str,&source,&p_counter,&jmp)){func[pos]|=(GOSUB<<if_shift);}
			//return̏
			else if(rst=return_(str,&source,&p_counter)){func[pos]|=(RETURN<<if_shift);}
			//input̏
			else if(input_(str)){func[pos]|=(INPUT<<if_shift);}
			//print̏
			else if(print_(str)){func[pos]|=(PRINT<<if_shift);}
			//clȑ
			else if(clr_(str)){func[pos]|=(CLR<<if_shift);}
			//location̏
			else if(location_(str)){func[pos]|=(LOCATION<<if_shift);}
			//wait̏
			else if(wait_(str)){func[pos]|=(WAIT<<if_shift);}
			//abs̏
			else if(abs_(str)){func[pos]|=(ABS<<if_shift);}
			//shell̏
			else if(shell_(str)){func[pos]|=(SHELL<<if_shift);}
			//len̏
			else if(len_(str)){func[pos]|=(LEN<<if_shift);}
			//mid̏
			else if(mid_(str)){func[pos]|=(MID<<if_shift);}
			//val̏
			else if(val_(str)){func[pos]|=(VAL<<if_shift);}
			//stȑ
			else if(str_(str)){func[pos]|=(STR<<if_shift);}
			//END̏
			else if(0==strncmp(str,"end",sizeof("end")-1)){//END
				trim(str);
				if(strlen(str)==strlen("end")) break;
			}
			//̏
			else if(strstr(str,"=")){
				func[pos]|=(EXP<<if_shift);
				trim(str);
				calculation(str);
			}
			//\G[̏
			else func[pos]|=(NOTHING<<if_shift);
		}else{
			switch ((func[p_counter]&(0x000000FF<<if_shift))>>if_shift){
				case FOR:
					//foȑ
					for_(str);
					break;
				case NEXT:
					//next̏
					next_(str,&source,&p_counter,&jmp);
					break;
				case GOTO:
					//gotȍ
					goto_(str,&source,&p_counter,&jmp);
					break;
				case GOSUB:
					//gosub̏
					gosub_(str,&source,&p_counter,&jmp);
					break;
				case RETURN:
					//return̏
					rst=return_(str,&source,&p_counter);
					break;
				case INPUT:
					//input̏
					input_(str);
					break;
				case PRINT:
					//print̏
					print_(str);
					break;
				case CLR:
					//clȑ
					clr_(str);
					break;
				case LOCATION:	
					//location̏
					location_(str);
					break;
				case WAIT:
					//wait̏
					wait_(str);
					break;
				case ABS:
					//abs̏
					abs_(str);
					break;
				case SHELL:
					//shell̏
					shell_(str);
					break;
				case LEN:
					//len̏
					len_(str);
					break;
				case MID:
					//mid̏
					mid_(str);
					break;
				case VAL:
					//val̏
					val_(str);
					break;
				case STR:
					//stȑ
					str_(str);
					break;
				case EXP:
					//̏
					trim(str);
					calculation(str);
					break;
			}
		}
		if(-1==rst) break;//returnŖ߂lꍇɂ͏I
LOOP_LAST:;
	}
}

void basic_end(){

}

int main(int argc, char* argv[]){
	srand((unsigned)time(NULL));//̎
	if(argc>1){
		if(basic_init(argv[1])) return 1;
		basic_start(0);//basicC^v^̊Jn
		basic_end();
	}else{
		printf("%s\n","basic [basic program text file name]");
	}
	return 0;
}

//-------------------------------------------------------------------------------
