/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//lXC++AvP[VɃC^v^gݍނ߂̃\[X

#include "./common.h"
#include "./calc.h"
#include "./vari.h"
#include "./variant.h"
#include "./variant_io.h"
#include "./st_inst.h"
#include "./ap_if.h"

extern std::map<std::string,std::string> variable_table;//̃}bv
extern std::vector<std::string> source; //basic̃vOi[z
extern int basic_init(char*filename);
extern void basic_start(int);
extern void basic_end();

HANDLE     ap_if_hIOMutex = CreateMutex (NULL, FALSE, NULL);//Xbh΍
std::map<std::string,unsigned int> goto_table;//goto邽߂̔z
static char str_pos[MAX_STR_LEN+1];

//C^v^̏
volatile int basic_init(){
	int result;
	WaitForSingleObject( ap_if_hIOMutex, INFINITE );
	result=basic_init("basic.txt");
	ReleaseMutex( ap_if_hIOMutex);
	return result;
}

//C^v^擪s
volatile void basic_run(){
	WaitForSingleObject( ap_if_hIOMutex, INFINITE );
	basic_start(0);
	ReleaseMutex( ap_if_hIOMutex);
}

//Tu[`̎s ֐ gosub ł邪Agotos
volatile int basic_gosub(char*label){
	WaitForSingleObject( ap_if_hIOMutex, INFINITE );
	int resolt=0;
	if(goto_table.count(label)){
			basic_start(goto_table[label]);
			resolt=1;//goto
	}else{
		std::vector<unsigned long> dumy; //gotoĂяo߂̃_~[z
		dumy.push_back(0);
		unsigned int p_cont=0;
		_strcpy(str_pos,"goto ");
		strcat(str_pos,label);
		if(goto_(str_pos,&source,&p_cont,&dumy)){
			goto_table[label]=p_cont;
			basic_start(p_cont);
			resolt=1;//goto
		}
	}
	ReleaseMutex( ap_if_hIOMutex);
	return resolt;
}

//ϐɒlݒ肷
volatile void basic_setVari(char*name,char*val){
	WaitForSingleObject( ap_if_hIOMutex, INFINITE );
	//Sĕ^Ƃ
	char*str_ptr=str_pos+1;
	_strcpy(str_ptr,val);
	str_ptr--;
	*str_ptr='\"';
	//CR  LF 菜
	char*pos=str_ptr;
	while(*pos){
		if(0x0D==*pos || 0x0A==*pos){
			*pos='\0';
			break;
		}
		pos++;
	}

	setVariable(name,str_ptr);
//	variable_table[name]=str_ptr;
	ReleaseMutex( ap_if_hIOMutex);
}

//ϐ̒l擾
volatile char* basic_getVari(char*name){
	WaitForSingleObject( ap_if_hIOMutex, INFINITE );
	char*resolt;
	_strcpy(str_pos,variable_table[name].c_str());
	if('\"'==*str_pos){
		resolt=str_pos+1;
	}else {
		resolt=str_pos;
	}
	ReleaseMutex( ap_if_hIOMutex);
	return resolt;
}


//-------------------------------------------------------------------------------
