/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "common.h"
#include "vari.h"

//̕
void _strcpy(char*out,const char*in){
	char*start=out;
	while(*out++=*in++){
		if((out-start)>=MAX_STR_LEN){
			*out='\0';
			break;
		}
	}
}

//̎w蕶ׂĎ菜
void trim_a(char*str,char c){
	if(c==*str){
		_strcpy(str,str+1);
	}else str++;
	if(*str) trim_a(str,c);
}

//̃Xy[XׂĎ菜
void trim_a(char*str){
	if(!str) return;
	if('\"'==*str){//""ň͂܂ꂽ͏O
		while('\"'!=*++str){
			if('\0'==*str) return;//"̖G[
			if('\\'==*str){
				str++;//GXP[vV[PX̓ǂݍ
				if('\0'==*str)return;//"̖G[
			}
		}
	}
	if(' '==*str){
		_strcpy(str,str+1);
	}else str++;
	if(*str) trim_a(str);
}

//̉ẼXy[X菜
void trim_r(char*str){
	char*i=str;
	while(*++i);
	while(str<--i && (' '==*i || '\t'==*i)) *i='\0';
}

//̍̃Xy[X菜
void trim_l(char*str){
	if(' '==*str || '\t'==*str) {
		_strcpy(str,str+1);
		trim_l(str);
	}
}

//^uXy[XɕϊA
//AXy[X̃Xy[Xɂ
void trim_c(char*str){
	if('\t'==*str) *str=' ';
	while(*str){
		if('\t'==*(str+1)) *(str+1)=' ';
		if((' '==*str)&&(' '==*(str+1))){
			_strcpy(str,str+1);	
		}else str++;
	}
}

//[̃Xy[X菜
void trim_rl(char*str){
	trim_r(str);
	trim_l(str);
}

//̐`
void trim_rlc(char*str){
	trim_rl(str);
	trim_c(str);
}

//̃JEg
int count_c(const char*str,const char c){
	int i=0;
	do{
		if(*str==c) i++;
	}while(*str++);
	return i;
}

//̐؂o
char*_strchop(char*str,const char c){
	static char*pos;
	if(str){
		if('\0'==*str){
			pos=NULL;
			goto exit;
		}
		pos=str;
		while(*str){
			if('\"'==*str){//""ň͂܂ꂽ͏O
				while('\"'!=*++str){
					if('\0'==*str) goto exit;//"̖G[
					if('\\'==*str){
						str++;//GXP[vV[PX̓ǂݍ
						if('\0'==*str) goto exit;//"̖G[
					}
				}
			}
			if(c==*str) *str='\0';
			str++;
		}
		*++str=EOF;//̏I[
	}else{
		while(*pos++);
		if(EOF==*pos) pos=NULL;//̏I[̂NULLԂ
	}
exit:;
	return pos;
}

//̒u
//buff:ƃobt@ str:Ώە a: b:u
//ǔʂ͖߂l̃|C^
char*replace(char*buff,char*str,const char*a,const char*b){
	char*ptr=str;
	char*st_ptr=str;
	if(!*a) return str;
	*buff='\0';
	while((ptr=strstr(st_ptr,a)) && (ptr)){
		*ptr='\0';
		strcat(buff,st_ptr);
		strcat(buff,b);
		st_ptr=ptr+strlen(a);
	}
	strcat(buff,st_ptr);
	return buff;
}

//s
void shell(char*str){

	str++;//擪菜
	trim_a(str,'\"');// "菜

#ifdef _WIN32 //gݍ݃}NɂVCG++̐؂蕪

//Windows
	STARTUPINFO si;// X^[gAbv
	PROCESS_INFORMATION pi;// vZX

	//STARTUPINFO \̂̓e擾 
	GetStartupInfo(&si);

	//ȂԂŋNɂ́A
	//si.dwFlags = STARTF_USESHOWWINDOW;
	//si.wShowWindow = SW_HIDE;

	if(0!=CreateProcess(
			NULL,					// s\W[̖O
			str,					// R}hC̕
			NULL,					// ZLeBLqq
			NULL,					// ZLeBLqq
			FALSE,					// nȟpIvV
			NULL,					// 쐬̃tO 
									// CREATE_NEW_PROCESS_GROUP	: VȃvZX
			NULL,					// VubN
			NULL,					// JgfBNg̖O
			&si,					// X^[gAbv
			&pi						// vZX
			)){

		//vZX̏Iҋ@
		CloseHandle(pi.hThread);
		WaitForSingleObject(pi.hProcess,INFINITE);
		CloseHandle(pi.hProcess);
	}else{
		//G[
		setVariable("system.err","ERR");
	}

#else
//Linux
	system(str);
#endif
}

//-------------------------------------------------------------------------------
