/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "calc.h"

//vg^Cv錾
void buf_init();
std::string*getString(char*str);
void token(const char*str,std::string*data[],int*data_size);
int Priority(const char*str);
void Analyzer(std::string*data[],int*data_size,std::string*out[],int*out_size,int*i);
VARIANT_*calc(std::string*out[],int*out_size);
int calculation_(char*str,int,std::string**string_buf,char*buff);
void substitution_(char*str,int);


//obt@
static char buf[MAX_STR_LEN];
static char str_buf[MAX_STR_LEN];
static char str_buf2[MAX_STR_LEN];
static char str_buf3[MAX_STR_LEN];

//stringNX̃Oobt@
static std::string*stringBuf[STRING_RING_BUF];
static int str_ring_ptr;

//Oobt@̏ _Iɂ͕KvȂ
void buf_init(){
	str_ring_ptr=0;
}
//Oobt@std::string擾
std::string*getString(char*str){
	if((STRING_RING_BUF-1)<str_ring_ptr) str_ring_ptr=0;
	while(NULL==stringBuf[str_ring_ptr]) stringBuf[str_ring_ptr]=new std::string();
	*stringBuf[str_ring_ptr]=str;
	return stringBuf[str_ring_ptr++];
}



//g[NƂɐ؂o
void token(const char*str,std::string*data[],int*data_size){
	char pos;
	int flag=1;//O񏈗 g[N or "(" ̏ꍇɂ 1@ȊO 0
	std::string*strpos=getString("");
	while(pos=*str++){
		switch (pos){
		case '\"':
			flag=0;//g[NłȂ
			*strpos=*strpos+pos;
			pos=*str++;
			while('\"'!=pos && '\0'!=pos){
#ifdef SHIFT_JIS
				//VtgJIS̓ǂݍ
				if((0x81<=(unsigned char)pos && 0x9F>=(unsigned char)pos) || (0xE0<=(unsigned char)pos && 0xFC>=(unsigned char)pos)){
					*strpos=*strpos+pos;
					pos=*str++;
					if('\0'==pos){setVariable("system.err","ERR");return;}//vIȃG[
					*strpos=*strpos+pos;
					pos=*str++;
				}else 
#endif
				if('\\'==pos){//GXP[vV[PX̓ǂݍ
					//*strpos=*strpos+pos;
					pos=*str++;
					if('\0'==pos){setVariable("system.err","ERR");return;}//vIȃG[
					else if('n'==pos) pos='\n';
					else if('a'==pos) pos='\a';
					else if('x'==pos){
						pos=(char)getHex2(str);
						if(!*++str){setVariable("system.err","ERR");return;}//vIȃG[
						if(!*++str){setVariable("system.err","ERR");return;}//vIȃG[
					}
					*strpos=*strpos+pos;
					pos=*str++;
				}else{
					*strpos=*strpos+pos;
					pos=*str++;//""ň͂܂ꂽǂݔ΂
				}
			}
			//͐擪"̂ƍl
			*strpos=*strpos+pos;
			break;
		case '[':
			flag=0;//g[NłȂ
			//z̒g͓ǂݔ΂
			*strpos=*strpos+pos;
			pos=*str++;
			while(']'!=pos){
					*strpos=*strpos+pos;
					pos=*str++;//͂܂ꂽǂݔ΂
					if('\0'==pos){setVariable("system.err","ERR");return;}//vIȃG[
			}
			*strpos=*strpos+pos;
			break;
		case '+':
			if(*strpos!="") {data[(*data_size)++]=strpos;};
			strpos=getString("");
			if(flag){
				//Og[Nłߍ̓g[NłȂ
				flag=0;//g[NłȂ
				*strpos=*strpos+pos;
			}else{
				//Og[NłȂ
				flag=1;//g[Nł
				data[(*data_size)++]=getString("+");
			}
			break;
		case '-':
			if(*strpos!="") data[(*data_size)++]=strpos;
			strpos=getString("");
			if(flag){
				//Og[Nłߍ̓g[NłȂ
				flag=0;//g[NłȂ
				*strpos=*strpos+pos;
			}else{
				//Og[NłȂ
				flag=1;//g[Nł
				data[(*data_size)++]=getString("-");
			}
			break;
		case '*':
			flag=1;//g[Nł
			if(*strpos!="") data[(*data_size)++]=strpos;
			strpos=getString("");
			data[(*data_size)++]=getString("*");
			break;
		case '/':
			flag=1;//g[Nł
			if(*strpos!="") data[(*data_size)++]=strpos;
			strpos=getString("");
			data[(*data_size)++]=getString("/");
			break;
		case '(':
			flag=1;//(ł
			if(*strpos!="") data[(*data_size)++]=strpos;
			strpos=getString("");
			data[(*data_size)++]=getString("(");
			break;
		case ')':
			flag=0;//g[NłȂ
			if(*strpos!="") data[(*data_size)++]=strpos;
			strpos=getString("");
			data[(*data_size)++]=getString(")");
			break;
//------------------------------------------------
		case '=':
			flag=1;//g[Nł
			if(*strpos!="") data[(*data_size)++]=strpos;
			strpos=getString("");
			data[(*data_size)++]=getString("=");
			break;
		case '<':
			flag=1;//g[Nł
			if(*strpos!="") data[(*data_size)++]=strpos;
			strpos=getString("");
			if('='==*(str)){
				data[(*data_size)++]=getString("<=");
				str++;
			}else if('>'==*(str)){
				data[(*data_size)++]=getString("<>");
				str++;
			}else{
				data[(*data_size)++]=getString("<");
			}
			break;
		case '>':
			flag=1;//g[Nł
			if(*strpos!="") data[(*data_size)++]=strpos;
			strpos=getString("");
			if('='==*(str)){
				data[(*data_size)++]=getString(">=");
				str++;
			}else{
				data[(*data_size)++]=getString(">");
			}
			break;
		case '&':
			flag=1;//g[Nł
			if(0==strncmp((str-1),"&&",sizeof("&&")-1)){
				str++;
				if(*strpos!="") data[(*data_size)++]=strpos;
				strpos=getString("");
				data[(*data_size)++]=getString("&&");
				break;
			}
		case '|':
			flag=1;//g[Nł
			if(0==strncmp((str-1),"||",sizeof("||")-1)){
				str++;
				if(*strpos!="") data[(*data_size)++]=strpos;
				strpos=getString("");
				data[(*data_size)++]=getString("||");
				break;
			}
//------------------------------------------------
		default:
			flag=0;//g[NłȂ
			*strpos=*strpos+pos;
			break;
		}
	}
	if(*strpos!="") data[(*data_size)++]=strpos;
}


//t|[h@ɕϊ邽߂̉Zq̗D揇ʂ
int Priority(const char*str){
	switch (*str){
		case '+'://+
			if('\0'==*(str+1)){
				return 10;
			}else{
				return 0;
			}
		case '-'://-
			if('\0'==*(str+1)){
				return 10;
			}else{
				return 0;
			}
		case '='://"=" 
		case '<'://"<" 
				 //"<="
				 //"<>"
		case '>'://">" 
				 //">="
			return 5;
		case '&'://"&&"
		case '|'://"||"
			return 4;
		case '*'://"*" 
			return 20;
		case '/'://"/" 
			return 25;
		default:
			return 0;
	}
}

//t|[h@ɕϊ邽߂̃X^bNobt@
static const char*stack[MAX_STR_LEN/2];
static int stack_ptr=0;

//t|[h@ɕϊ
void Analyzer(std::string*data[],int*data_size,std::string*out[],int*out_size,int*i){
	stack[++stack_ptr]=NULL;//X^bNɋ؂蕶
	const char*pos;
	unsigned int size=*data_size;
	for(;(unsigned int)*i<size;(*i)++){
		pos=data[*i]->c_str();
		if(Priority(pos)){
			if(stack[stack_ptr]){//false : X^bNɒl
				if(Priority(pos)==Priority(stack[stack_ptr])){
					stack[++stack_ptr]=pos;//l̒ǉ
				}
				if(Priority(pos)<Priority(stack[stack_ptr])){
					while(stack[stack_ptr]){//false : X^bNɒl
						const char*str=stack[stack_ptr--];	//Ō̒l̎擾
						out[(*out_size)++]=getString((char*)str);
					}
					stack[++stack_ptr]=pos;//l̒ǉ
				}
				if(Priority(pos)>Priority(stack[stack_ptr])){
					stack[++stack_ptr]=pos;//l̒ǉ
				}
			}else{
				stack[++stack_ptr]=pos;//l̒ǉ
			}
		}else{
			if(*(pos)=='('){
				*i=*i+1;
				Analyzer(data,data_size,out,out_size,i);
			}else{
				if(*(pos)==')'){
					goto end;
				}else{
					out[(*out_size)++]=data[*i];
				}
			}
		}
	}
end:
	while(stack[stack_ptr]){//false : X^bNɒl
		const char*str=stack[stack_ptr--];	//Ō̒l̎擾
		out[(*out_size)++]=getString((char*)str);
	}
	stack_ptr--;//X^bN̋؂蕶폜
}


//t|[h@\ĽvZvZ
VARIANT_*calc(std::string*out[],int*out_size){
	int c=*out_size;
	VARIANT_ *j,*k;
	for(int i=0;i<c;i++){
		char*str=(char*)out[i]->c_str();
		switch (*str){
			case '+':
				if('\0'==*(str+1)){
					j=vari_top();
					vari_pop();
					k=vari_top();
					vari_pop();
					vari_push((*k)+j);
					break;
				}
				goto default_;
			case '=':
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)==j);
				break;
			case '-':
				if('\0'==*(str+1)){
					j=vari_top();
					vari_pop();
					k=vari_top();
					vari_pop();
					vari_push((*k)-j);
					break;
				}
				goto default_;
			case '*':
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)*j);
				break;
			case '/':
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)/j);
				break;
			case '&':
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k) && j);
				break;
			case '|':
				j=vari_top();
				vari_pop();
				k=vari_top();
				vari_pop();
				vari_push((*k)||j);
				break;
			case '<':
				if('='==*(str+1)){
					//<=
					j=vari_top();
					vari_pop();
					k=vari_top();
					vari_pop();
					vari_push((*k)<=j);
				}else if('>'==*(str+1)){
					//<>
					j=vari_top();
					vari_pop();
					k=vari_top();
					vari_pop();
					vari_push((*k)!=j);
				}else{
					//<
					j=vari_top();
					vari_pop();
					k=vari_top();
					vari_pop();
					vari_push((*k)<j);
				}
				break;
			case '>':
				if('='==*(str+1)){
					//>=
					j=vari_top();
					vari_pop();
					k=vari_top();
					vari_pop();
					vari_push((*k)>=j);
				}else{
					//>
					j=vari_top();
					vari_pop();
					k=vari_top();
					vari_pop();
					vari_push((*k)>j);
				}
				break;
			default:
default_:;
				//ϐ܂͒loX^bNɃvbV
				getVariable(str,vari_push());
				break;
		}
	}
	j=vari_top();
	vari_pop();
	return j;
}


//vZvZĕϐe[uɊi[+z̏
//߂l@vZKv:1 ̂:0
int calculation(char*str,int write_mode){
	buf_init();//Oobt@̏
	static std::string*string_buf[STRING_RING_BUF];
	static char buff_pos[MAX_STR_LEN];//ƃobt@
	return calculation_(str,write_mode,string_buf,buff_pos);
}
//vZvZĕϐe[uɊi[
//߂l@vZKv:1 ̂:0
//std::string**string_buf,char*buff ֐ċAĂяoꍇ邽ߍƃobt@𕪂
int calculation_(char*str,int write_mode,std::string**string_buf,char*buff){
	int r=0;
	int string_buf1_size=0;
	int string_buf_size=0;
	
	static std::string*string_buf1[STRING_RING_BUF];
	
	char*st_ptr=strstr(str,"=");
	*st_ptr++='\0';
			
	if(NULL!=st_ptr){

		//t|[hϊ̕ۑ
		str_buf2[0]='\xFF';
		str_buf2[1]='\0';
		
		unsigned int re;
		void*pos=getVariable(st_ptr,&re);
		if(pos && '\xFF'==*((char*)pos)){
			char*ptr=(char*)pos;
			ptr++;
			char*ptr2=str_buf;
			while(*ptr){
				*ptr2++=*ptr++;
				if('\xFF'==*ptr){
					ptr++;
					*ptr2='\0';
					ptr2=str_buf;
					string_buf[string_buf_size++]=getString(ptr2);
				}
			}
			*ptr2='\0';
			ptr2=str_buf;
			string_buf[string_buf_size++]=getString(ptr2);
			r=string_buf_size;
		}else{
			token(st_ptr,string_buf1,&string_buf1_size);
			r=(int)string_buf1_size;
	//		{printf("\ng[N؂o %d : ",data_size);for(int a=0;a<data_size;a++) printf("%s ",data[a]->c_str());}
			int c=0;
			Analyzer(string_buf1,&string_buf1_size,string_buf,&string_buf_size,&c);
				if(string_buf_size>1){
				str_buf[0]='\0';
				for(int i=0;i<string_buf_size;i++){
					strcat(str_buf,"\xFF");
					strcat(str_buf,string_buf[i]->c_str());
				}
				setVariable(st_ptr,str_buf);//t|[hL@̐ۑ
			}
		}

		for(int i=0;i<string_buf_size;i++){
			if(arry(buff,(const char*)string_buf[i]->c_str())) *string_buf[i]=buff;
		}
		if(arry(buff,str)) str=buff;

		VARIANT_*obj=calc(string_buf,&string_buf_size);
		
		if(TYPE_VAL==obj->flag){
			//l^̏o
			setVariable(str,obj->d_val,write_mode);
		}else{
			//^̏o
			setVariable(str,obj->str_val,write_mode);
		}
	}
	if(r<2){
		return 0;
	}else{
		return 1;
	}
}


//݂̂̌vZ+z̏
void substitution(char*str,int write_mode){
	buf_init();//Oobt@̏
	arry(buf,(const char*)str);
	substitution_(buf,write_mode);
}
//݂̂̌vZ
void substitution_(char*str,int write_mode){
	char*ptr=str;
	while('='!=*str) str++;
	*str++='\0';
	//̏ꍇ̂ݕϊs
	if('\"'==*str){
		char*pos=str_buf;
		*pos=*str;
		while(*str){
#ifdef SHIFT_JIS
			//VtgJIS̓ǂݍ
			if((0x81<=(unsigned char)*str && 0x9F>=(unsigned char)*str) || (0xE0<=(unsigned char)*str && 0xFC>=(unsigned char)*str)){
				*pos++=*str++;
				if('\0'==*str){*pos='\0';setVariable("system.err","ERR");break;}//vIȃG[
				*pos++=*str++;
				if('\0'==*str){*pos='\0';setVariable("system.err","ERR");break;}//vIȃG[
			}else 
#endif
			if('\\'==*str){//GXP[vV[PX̓ǂݍ
				*pos=*++str;
				if('\0'==*str){*pos='\0';setVariable("system.err","ERR");break;}//vIȃG[
				else if('n'==*str) *pos='\n';
				else if('a'==*str) *pos='\a';
				pos++;
				str++;
			}else{
				*pos++=*str++;
			}
		}
		*pos='\0';
		setVariableEtc(ptr,str_buf,write_mode);
	}else{
		setVariableEtc(ptr,str,write_mode);
	}
}


//z܂񂾌vZ̔zJbRvZ̌vZɂ
int arry(char*buff,const char*str){
	int resolt=0;//sꂽԂtO
	char*buff_ptr;
	char*str_buf_ptr;
	while(*str){
		//""ň͂܂Ă镔͖
		switch(*str){
			case '\"':
				while(*buff++=*str++){
					if(*str=='\"'){
						*buff++=*str++;
						break;
					}
#ifdef SHIFT_JIS
					//VtgJIS̓ǂݍ
					if((0x81<=(unsigned char)*str && 0x9F>=(unsigned char)*str) || (0xE0<=(unsigned char)*str && 0xFC>=(unsigned char)*str)){
						*buff++=*str++;
					}else 
#endif
					if(*str=='\\'){//GXP[vV[PX̓ǂݍ
						*buff++=*str++;
					}
				}
				break;
			case '[':
				*buff++=*str++;//[Rs[
				buff_ptr=str_buf3;
				_strcpy(buff_ptr,"=");//擪Ɂ@=@ǉ
				buff_ptr+=sizeof("=")-1;
				for(int i=0;i<MAX_STR_LEN;i++){
					if(*str!=']'){
						*buff_ptr++=*str++;
					}else{
					//	*buff_ptr='\0';
						break;
					}
				}
				
				*buff_ptr='\0';
				trim_a(str_buf3);

				if('\0'!=str_buf3[1]){
					static std::string*string_buf[STRING_RING_BUF];
					static char buff_pos[MAX_STR_LEN];//ƃobt@
					calculation_(str_buf3,WRITE_REG,string_buf,buff_pos);
					resolt=1;//sꂽ1
					str_buf_ptr=str_buf;
					if(TYPE_VAL==reg1.flag){
						sprintf(str_buf,"%g",reg1.d_val);
						str_buf_ptr=str_buf;
					}else{
						str_buf_ptr=reg1.str_val;
						//vZʂ񂾂ꍇA擪̃_uNI[e[V폜
						if('\"'==*str_buf_ptr) str_buf_ptr++;
					}

					*buff++='\"';
					while(*buff++=*str_buf_ptr++);
					buff--;
					*buff++='\"';
				}
				break;
			default:
				*buff++=*str++;
		}
	}
	*buff='\0';
	return resolt;
}


//-------------------------------------------------------------------------------
