/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


//Shift_jis̗ӓ_
//Shift_jis1oCgڂƂ肤͈́@0x81~0x9F,E0~FC
//Shift_jis2oCgڂƂ肤͈́@0x40~0xFC

#include "common.h"
#include "vari.h"

//̕
void _strcpy(char*out,const char*in){
	char*start=out;
	while(*out++=*in++){
		if((out-start)>=MAX_STR_LEN){
			*out='\0';
			break;
		}
	}
}

//̌ ab ȂNULLԂ
char*_strstr(const char*a,const char*b){
	const char*pos_a;
	const char*pos_b;
	
	while(*a){
		pos_a=a;
		pos_b=b;
		while(*pos_a++==*pos_b++){
			if(!*pos_b) return (char*)a;
		}
#ifdef SHIFT_JIS
		//VtgJIS̓ǂݍ
		if((0x81<=(unsigned char)*a && 0x9F>=(unsigned char)*a) || (0xE0<=(unsigned char)*a && 0xFC>=(unsigned char)*a)){
			a++;a++;
		}else
#endif
		{
			a++;
		}
	}
	return NULL;
}

//̌ ab _uNI[e[Vň͂܂ꂽ͖錩ȂNULLԂ
char*_strstr2(const char*a,const char*b){
	const char*pos_a;
	const char*pos_b;
	
	while(*a){
		pos_a=a;
		pos_b=b;
		while(*pos_a++==*pos_b++){
			if(!*pos_b) return (char*)a;
		}
		if('\"'==*a){//""ň͂܂ꂽ͏O
			while('\"'!=*++a){
				if('\0'==*a) return NULL;//"̖G[
				
				if('\\'==*a){
					a++;//GXP[vV[PX̓ǂݍ
					if('\0'==*a)return NULL;//"̖G[
				}
				
#ifdef SHIFT_JIS
				//VtgJIS̓ǂݍ
				else if((0x81<=(unsigned char)*a && 0x9F>=(unsigned char)*a) || (0xE0<=(unsigned char)*a && 0xFC>=(unsigned char)*a)){
					a++;
					if('\0'==*a) return NULL;//"̖G[
				}
#endif

			}
		}
		
#ifdef SHIFT_JIS
		//VtgJIS̓ǂݍ
		if((0x81<=(unsigned char)*a && 0x9F>=(unsigned char)*a) || (0xE0<=(unsigned char)*a && 0xFC>=(unsigned char)*a)){
			a++;a++;
		}else
#endif
		{
			a++;
		}
	}
	return NULL;
}

//̎w蕶ׂĎ菜@SĂ̕菜܂
void trim_a(char*str,char c){
	if(c==*str){
		_strcpy(str,str+1);
	}else str++;
	if(*str) trim_a(str,c);
}

//̃Xy[XׂĎ菜@_uNI[e[Vň͂܂ꂽ͖܂
void trim_a(char*str){
	if(!str) return;
	if('\"'==*str){//""ň͂܂ꂽ͏O
		while('\"'!=*++str){
			if('\0'==*str) return;//"̖G[
			
			if('\\'==*str){
				str++;//GXP[vV[PX̓ǂݍ
				if('\0'==*str)return;//"̖G[
			}
			
#ifdef SHIFT_JIS
			//VtgJIS̓ǂݍ
			else if((0x81<=(unsigned char)*str && 0x9F>=(unsigned char)*str) || (0xE0<=(unsigned char)*str && 0xFC>=(unsigned char)*str)){
				str++;
				if('\0'==*str) return;//"̖G[
			}
#endif
			
		}
	}
	if(' '==*str){
		_strcpy(str,str+1);
	}else str++;
	if(*str) trim_a(str);
}

//̉ẼXy[Xƃ^u菜
void trim_r(char*str){
	char*i=str;
	while(*++i);
	while(str<--i && (' '==*i || '\t'==*i)) *i='\0';
}

//̍̃Xy[Xƃ^u菜
void trim_l(char*str){
	if(' '==*str || '\t'==*str) {
		_strcpy(str,str+1);
		trim_l(str);
	}
}

//^uXy[XɕϊA
//AXy[X̃Xy[Xɂ
void trim_c(char*str){
	if('\t'==*str) *str=' ';
	while(*str){
		if('\t'==*(str+1)) *(str+1)=' ';
		if((' '==*str)&&(' '==*(str+1))){
			_strcpy(str,str+1);	
		}else str++;
	}
}

//[̃Xy[Xƃ^u菜
void trim_rl(char*str){
	trim_r(str);
	trim_l(str);
}

//̐`@[̃Xy[X菜AAXy[X̃Xy[Xɂ
void trim_rlc(char*str){
	trim_rl(str);
	trim_c(str);
}

//̃JEg
int count_c(const char*str,const char c){
	int i=0;
	do{
		if(*str==c) i++;
	}while(*str++);
	return i;
}

//̐؂o@_uNI[e[Vň͂܂ꂽ͖܂
//strɐ؂o̕AcɃf~^ݒ肵܂B
//strNULLČĂяoƂɂAɐ؂oꂽĂяo܂B
char*_strchop(char*str,const char c){
	static char*pos;
	if(str){
		if('\0'==*str){
			pos=NULL;
			goto exit;
		}
		pos=str;
		while(*str){
			if('\"'==*str){//""ň͂܂ꂽ͏O
				while('\"'!=*++str){
					if('\0'==*str) goto exit;//"̖G[
#ifdef SHIFT_JIS
					//VtgJIS̓ǂݍ
					if((0x81<=(unsigned char)*str && 0x9F>=(unsigned char)*str) || (0xE0<=(unsigned char)*str && 0xFC>=(unsigned char)*str)){
						str++;//GXP[vV[PX̓ǂݍ
						if('\0'==*str) goto exit;//"̖G[
					}else 
#endif
					if('\\'==*str){
						str++;//GXP[vV[PX̓ǂݍ
						if('\0'==*str) goto exit;//"̖G[
					}
				}
			}
			if(c==*str) *str='\0';
			str++;
		}
		*++str=EOF;//̏I[
	}else{
		while(*pos++);
		if(EOF==*pos) pos=NULL;//̏I[̂NULLԂ
	}
exit:;
	return pos;
}

//̒u SĂ̕u܂
//buff:ƃobt@ str:Ώە a: b:u
//ǔʂ͖߂l̃|C^
char*replace(char*buff,char*str,const char*a,const char*b){
	char*ptr;
	char*st_ptr=str;
	if(!*a) return NULL;
	*buff='\0';
	while(ptr=_strstr((const char*)st_ptr,(const char*)a)){
		*ptr='\0';
		strcat(buff,st_ptr);
		strcat(buff,b);
		st_ptr=ptr+strlen(a);
	}
	strcat(buff,st_ptr);
	return buff;
}


//ChJ[h܂ޕ
//pat:* ?܂ރp^[
//str:
//len:ꂽ̒
//߂l:ꂽ̐擪AhX łȂƂNULL
char*match(const char *pat,const char *str,int*len)
{
	char*pat_pos;
	char*str_pos;
	pat_pos=(char*)pat;
	str_pos=(char*)str;
	do{
		if('*'==*pat_pos){
			pat_pos++;
			while(*str_pos){
				if(*str_pos==*pat_pos){
					break;
				}else{
					str_pos++;
				}
			}
		}
		if(!*pat_pos){
			*len=(int)(str_pos-str);
			return (char*)str;
		}
		if(*str_pos==*pat_pos || '?'==*pat_pos){
			pat_pos++;
		}else{
			pat_pos=(char*)pat;
			str_pos=(char*)str++;
		}
	}while(*str_pos++);
	return NULL;
}


//ߕ̕
void instcpy(char*out,const char*in){
	const char*pos=in;
	while(' '==*in || '\t'==*in) in++;//ŏ̃Xy[X菜
	while(*out=*in){
		if('\r'==*out || '\n'==*out || EOF==*out){//EOFAsR[h𖳎
			*out='\0';
			break;
		}

		//""ň͂܂ꂽ͏O
		if('\"'==*in){
			*out++=*in++;
			while('\"'!=*in){
				if('\0'==*in){*out='\0';setVariable("system.err",pos);return;}//"̖G[
#ifdef SHIFT_JIS
				//VtgJIS̓ǂݍ
				if((0x81<=(unsigned char)*in && 0x9F>=(unsigned char)*in) || (0xE0<=(unsigned char)*in && 0xFC>=(unsigned char)*in)){
					*out++=*in++;
					if('\0'==*in){*out='\0';setVariable("system.err",pos);break;}//vIȃG[
					*out++=*in++;
					if('\0'==*in){*out='\0';setVariable("system.err",pos);break;}//vIȃG[
				}else 
#endif
				if('\\'==*in){
					*out++=*in++;//GXP[vV[PX̓ǂݍ
					if('\0'==*in){*out='\0';setVariable("system.err",pos);return;}//"̖G[
					*out++=*in++;//GXP[vV[PX̓ǂݍ
					if('\0'==*in){*out='\0';setVariable("system.err",pos);return;}//"̖G[
				}else{
					*out++=*in++;
				}
			}
			*out=*in;
		}

		if('\''==*out){//'̓Rgƍl
			*out='\0';
			break;
		}

		if('\t'==*out){//tabXy[Xɒu
			*out=' ';
		}
		if((' '==*in || '\t'==*in) && (' '==*(in+1) || '\t'==*(in+1)))  out--;//AȂXy[X폜

		out++;in++;
	}
}


//s
void shell(char*str){

	str++;//擪菜
	trim_a(str,'\"');// "菜

#ifdef _WIN32 //gݍ݃}NɂVCG++̐؂蕪

//Windows
	STARTUPINFO si;// X^[gAbv
	PROCESS_INFORMATION pi;// vZX

	//STARTUPINFO \̂̓e擾 
	GetStartupInfo(&si);

	//ȂԂŋNɂ́A
	//si.dwFlags = STARTF_USESHOWWINDOW;
	//si.wShowWindow = SW_HIDE;

	if(0!=CreateProcess(
			NULL,					// s\W[̖O
			str,					// R}hC̕
			NULL,					// ZLeBLqq
			NULL,					// ZLeBLqq
			FALSE,					// nȟpIvV
			NULL,					// 쐬̃tO 
									// CREATE_NEW_PROCESS_GROUP	: VȃvZX
			NULL,					// VubN
			NULL,					// JgfBNg̖O
			&si,					// X^[gAbv
			&pi						// vZX
			)){

		//vZX̏Iҋ@
		CloseHandle(pi.hThread);
		WaitForSingleObject(pi.hProcess,INFINITE);
		CloseHandle(pi.hProcess);
	}else{
		//G[
		setVariable("system.err","ERR");
	}

#else
//Linux
	system(str);
#endif
}

static int nonblock_mode;
#ifdef _WIN32 //gݍ݃}NɂVCG++̐؂蕪
//Windows
#else
//Linux
static struct termios s_termios;
static int fileFlag;
#endif

void nonblock_start(){
	if(!nonblock_mode){
#ifdef _WIN32 //gݍ݃}NɂVCG++̐؂蕪
//Windows
#else
//Linux
		//^[~iݒ
		tcgetattr(0, &s_termios);
		struct termios _termios = s_termios;
		fileFlag = fcntl(0,F_GETFL);
		_termios.c_lflag &= ~(ICANON|ECHO);
		_termios.c_cc[VMIN] = 1;
		_termios.c_cc[VTIME] = 0;
		tcsetattr(0, TCSANOW, &_termios);
		fcntl(0, F_SETFL, fileFlag | O_NONBLOCK);
#endif
		nonblock_mode=1;
	}
}

int _getchar(){

	if(!nonblock_mode){
		return getchar();
	}else{
#ifdef _WIN32 //gݍ݃}NɂVCG++̐؂蕪
//Windows
		if(_kbhit()){
			return _getch();
		}else{
			return '\n';
		}
#else
//Linux
		char c;
		if(1==read(0, &c, 1)){
			return c;
		}else{
			return '\n';
		}
#endif
	}
}

void nonblock_end(){
	if(nonblock_mode){
#ifdef _WIN32 //gݍ݃}NɂVCG++̐؂蕪
//Windows
#else
//Linux
		//^[~iɖ߂
		tcsetattr(0, TCSANOW, &s_termios);
		fcntl(0, F_SETFL, fileFlag);
#endif
		nonblock_mode=0;
	}
}

//Q16i𐔎ɕϊ "FF"FF
unsigned char getHex2(const char*str){
	unsigned char r=0;
	int w;
	for(w=0x10;w>0;w-=0x0F){
		switch (*str++){
			case '1':
				r=(unsigned char)(r+w*0x01);
				break;
			case '2':
				r=(unsigned char)(r+w*0x02);
				break;
			case '3':
				r=(unsigned char)(r+w*0x03);
				break;
			case '4':
				r=(unsigned char)(r+w*0x04);
				break;
			case '5':
				r=(unsigned char)(r+w*0x05);
				break;
			case '6':
				r=(unsigned char)(r+w*0x06);
				break;
			case '7':
				r=(unsigned char)(r+w*0x07);
				break;
			case '8':
				r=(unsigned char)(r+w*0x08);
				break;
			case '9':
				r=(unsigned char)(r+w*0x09);
				break;
			case 'A':
				r=(unsigned char)(r+w*0x0A);
				break;
			case 'B':
				r=(unsigned char)(r+w*0x0B);
				break;
			case 'C':
				r=(unsigned char)(r+w*0x0C);
				break;
			case 'D':
				r=(unsigned char)(r+w*0x0D);
				break;
			case 'E':
				r=(unsigned char)(r+w*0x0E);
				break;
			case 'F':
				r=(unsigned char)(r+w*0x0F);
				break;
			case 'a':
				r=(unsigned char)(r+w*0x0A);
				break;
			case 'b':
				r=(unsigned char)(r+w*0x0B);
				break;
			case 'c':
				r=(unsigned char)(r+w*0x0C);
				break;
			case 'd':
				r=(unsigned char)(r+w*0x0D);
				break;
			case 'e':
				r=(unsigned char)(r+w*0x0E);
				break;
			case 'f':
				r=(unsigned char)(r+w*0x0F);
				break;
				default:
			break;
		}
	}
	return r;
}

//̔]
void reverse(char*str){
	char*last=str;
	char*bigin=str;
	while(*last) last++;
	last--;
	while(bigin<last){
		char pos=*bigin;
		*bigin=*last;
		*last=pos;
		bigin++;last--;
	}	
}

//str1ɏ]Astr2̏C
//ʂbufɓ
void format(char*buf,char*str1,char*str2){
	char flag;
	flag=0x03;
	reverse(str1);
	reverse(str2);
	char*buf_st=buf;
	while(flag){
		if( '0'<=*str1 && '9'>=*str1 ||
			'A'<=*str1 && 'Z'>=*str1 ||
			'a'<=*str1 && 'z'>=*str1 ||
			'#'==*str1
		){
			if(flag&0x01 && *str2){
				*buf=*str2;
			}else{
				flag&=(~0x01);
			}
			if(flag&0x02 && *str1){
				if(!(flag&0x01)) *buf=*str1;
			}else{
				flag&=(~0x02);
			}
			buf++;str1++;str2++;
		}else{
			*buf++=*str1++;
			if(!*str1) flag&=(~0x02);
		}
	}
	*buf='\0';
	char*pos=buf_st;
	while(*pos){
		if('#'==*pos){
			*pos='\0';
			if(pos!=buf_st){
				pos--;
				if(!( '0'<=*pos && '9'>=*pos ||
					  'A'<=*pos && 'Z'>=*pos ||
					  'a'<=*pos && 'z'>=*pos )){
					*pos='\0';
				}
			}
			break;
		}
		pos++;
	}
	reverse(buf_st);
}

//֐񂩂A֐ƈ̕
//str : ֐ ߂l : 
char*cut_func(char*str){
	//ŏ̃Xy[Xŕ؂
	while(*str){
		//JbRǂݔ΂
		if('['==*str){
			str++;
			while(']'!=*str){
				if('\"'==*str && '\\'!=*(str-1)){
					while('\"'!=*++str){
						//GXP[vĂꍇ
						if('\\'==*(str) 
#ifdef SHIFT_JIS
						//VtgJIS2oCg̏ꍇ
						|| (0x81<=(unsigned char)*(str) && 0x9F>=(unsigned char)*(str)) || (0xE0<=(unsigned char)*(str) && 0xFC>=(unsigned char)*(str))
#endif
						) str++;
					}
				}
				str++;
			}
		}
		
		if(' '==*str){
			*str++='\0';
			break;	
		}
		
		//GXP[vĂꍇ
		if('\\'==*(str) 
#ifdef SHIFT_JIS
		//VtgJIS2oCg̏ꍇ
		|| (0x81<=(unsigned char)*(str) && 0x9F>=(unsigned char)*(str)) || (0xE0<=(unsigned char)*(str) && 0xFC>=(unsigned char)*(str))
#endif
		) str++;
		str++;
	}
	return str;
}

//֐̔z񂩂zvf菜AftHg̊֐ɂ
void default_func(char*defstr,const char*str){
	//ŏ̃Xy[Xŕ؂
	while(*str){
		//JbRǂݔ΂
		if('['==*str){
			*defstr++=*str++;
			while(']'!=*str){
				if('\"'==*str && '\\'!=*(str-1)){
					while('\"'!=*++str){
						//GXP[vĂꍇ
						if('\\'==*(str) 
#ifdef SHIFT_JIS
						//VtgJIS2oCg̏ꍇ
						|| (0x81<=(unsigned char)*(str) && 0x9F>=(unsigned char)*(str)) || (0xE0<=(unsigned char)*(str) && 0xFC>=(unsigned char)*(str))
#endif
						) str++;
					}
				}
				str++;
			}
		}
		
		if(' '==*str){
			*defstr='\0';
			break;	
		}
		
		*defstr++=*str++;
	}
	*defstr='\0';
}



//-------------------------------------------------------------------------------
