/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Point3d;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.Action3DData;
import jp.sourceforge.acerola3d.a3.Motion;

class ActionBehavior
extends Behavior
implements Cloneable {
    static BoundingSphere bounding = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
    int actionNo = 0;
    boolean immediatelyFlag = false;
    int playCount;
    boolean loopFlag;
    ArrayList<Integer> actionQueue = new ArrayList();
    static final int ACTION_QUEUE_SIZE = 3;
    Action3DData a3Data;
    BranchGroup allBranchGroup = null;
    long motionLength;
    int elapsedTime;
    Motion.Mode mode = Motion.Mode.PLAY;
    long timeOffset = 0L;
    long pauseTime;
    Action3D a3;
    long previousTime;

    public ActionBehavior(Action3D action3d, Action3DData action3DData) {
        this.a3 = action3d;
        this.a3Data = action3DData;
        this.a3Data.construct3DNode(this.a3);
        this.actionNo = 0;
        Action3DData.Action action = this.a3Data.actions[this.actionNo];
        Motion motion = action.motion;
        this.motionLength = (long)(motion.getMotionLength() * 1000.0);
        this.elapsedTime = (int)(1000.0 * motion.getDefaultFrameTime());
        this.loopFlag = action.loopFlag;
        this.setSchedulingBounds((Bounds)bounding);
        this.allBranchGroup = new BranchGroup();
        this.allBranchGroup.addChild(this.a3Data.getNode());
        this.allBranchGroup.addChild((Node)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        ArrayList<Integer> arrayList = this.actionQueue;
        synchronized (arrayList) {
            this.actionNo = this.actionQueue.remove(0);
            Group n = this.a3Data.actions[this.actionNo].getRootGroup();
            this.a3Data.allActionBranchGroup.removeAllChildren();
            this.a3Data.allActionBranchGroup.addChild((Node)n);
            this.a3Data.actions[this.actionNo].start();
        }
    }

    public void initialize() {
        if (this.elapsedTime == 0) {
            return;
        }
        WakeupOnElapsedTime w = new WakeupOnElapsedTime((long)this.elapsedTime);
        this.wakeupOn((WakeupCondition)w);
        this.timeOffset = System.currentTimeMillis();
        this.previousTime = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration criteria) {
        ArrayList<Integer> arrayList = this.actionQueue;
        synchronized (arrayList) {
            double ls;
            WakeupOnElapsedTime w = new WakeupOnElapsedTime((long)this.elapsedTime);
            this.wakeupOn((WakeupCondition)w);
            if (this.a3Data.autoActionControl && (ls = this.a3.getSpeed()) > 0.001) {
                int i = -1;
                i = ls <= this.a3Data.getMinWalkSpeed() ? this.a3Data.getHaltActionNo() : (ls > this.a3Data.getMinWalkSpeed() && ls < this.a3Data.getMinRunSpeed() ? this.a3Data.getWalkActionNo() : this.a3Data.getRunActionNo());
                if (this.actionQueue.size() < 3) {
                    this.actionQueue.add(i);
                } else {
                    this.actionQueue.set(2, i);
                }
            }
            if (this.immediatelyFlag) {
                if (this.actionQueue.size() > 0) {
                    this.a3Data.actions[this.actionNo].stop();
                    this.actionNo = this.actionQueue.remove(0);
                    Group n = this.a3Data.actions[this.actionNo].getRootGroup();
                    this.a3Data.allActionBranchGroup.removeAllChildren();
                    this.a3Data.allActionBranchGroup.addChild((Node)n);
                    this.a3Data.actions[this.actionNo].start();
                    this.immediatelyFlag = false;
                    this.timeOffset = System.currentTimeMillis();
                    this.previousTime = -1L;
                    this.loopFlag = this.a3Data.actions[this.actionNo].loopFlag;
                    this.motionLength = (long)(this.a3Data.actions[this.actionNo].getMotionLength() * 1000.0);
                    this.elapsedTime = (int)(this.a3Data.actions[this.actionNo].motion.getDefaultFrameTime() * 1000.0);
                }
            } else if (this.playCount >= 1 && this.actionQueue.size() > 0) {
                this.a3Data.actions[this.actionNo].stop();
                this.actionNo = this.actionQueue.remove(0);
                Group n = this.a3Data.actions[this.actionNo].getRootGroup();
                this.a3Data.allActionBranchGroup.removeAllChildren();
                this.a3Data.allActionBranchGroup.addChild((Node)n);
                this.a3Data.actions[this.actionNo].start();
                this.timeOffset = System.currentTimeMillis();
                this.previousTime = -1L;
                this.loopFlag = this.a3Data.actions[this.actionNo].loopFlag;
                this.motionLength = (long)(this.a3Data.actions[this.actionNo].getMotionLength() * 1000.0);
                this.elapsedTime = (int)(this.a3Data.actions[this.actionNo].motion.getDefaultFrameTime() * 1000.0);
            }
            long nowTime = System.currentTimeMillis();
            long time = this.mode == Motion.Mode.PLAY ? nowTime - this.timeOffset : this.pauseTime;
            this.playCount = (int)(time / this.motionLength);
            if (!this.loopFlag && this.playCount > 0) {
                if (this.previousTime >= this.motionLength - 1L) {
                    return;
                }
                time = this.motionLength - 1L;
            }
            this.previousTime = time;
            double timeD = (double)(time %= this.motionLength) / 1000.0;
            Action3DData.Action a = this.a3Data.actions[this.actionNo];
            for (String boneName : a.tgMap.keySet()) {
                TransformGroup tg = a.tgMap.get(boneName);
                Transform3D t = a.motion.getTransform3D(boneName, timeD);
                tg.setTransform(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initAction(int initActionNo) {
        ArrayList<Integer> arrayList = this.actionQueue;
        synchronized (arrayList) {
            if (initActionNo < 0 || initActionNo >= this.a3Data.actions.length) {
                initActionNo = 0;
            }
            this.actionQueue.clear();
            this.actionQueue.add(initActionNo);
        }
    }

    void initAction(Serializable s) {
        if (s instanceof Integer) {
            this.initAction((Integer)s);
        }
        if (s instanceof String) {
            this.initAction(this.a3Data.getActionNoFromActionName((String)((Object)s)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void change(int newActionNo) {
        ArrayList<Integer> arrayList = this.actionQueue;
        synchronized (arrayList) {
            if (newActionNo < 0 || newActionNo >= this.a3Data.actions.length) {
                return;
            }
            if (this.actionQueue.size() < 3) {
                this.actionQueue.add(newActionNo);
            } else {
                this.actionQueue.set(2, newActionNo);
            }
        }
    }

    void change(Serializable s) {
        if (s instanceof Integer) {
            this.change((Integer)s);
        }
        if (s instanceof String) {
            this.change(this.a3Data.getActionNoFromActionName((String)((Object)s)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeImmediately(int newActionNo) {
        ArrayList<Integer> arrayList = this.actionQueue;
        synchronized (arrayList) {
            if (newActionNo < 0 || newActionNo >= this.a3Data.actions.length) {
                return;
            }
            this.actionQueue.clear();
            this.actionQueue.add(newActionNo);
            this.immediatelyFlag = true;
        }
    }

    void changeImmediately(Serializable s) {
        if (s instanceof Integer) {
            this.changeImmediately((Integer)s);
        }
        if (s instanceof String) {
            this.changeImmediately(this.a3Data.getActionNoFromActionName((String)((Object)s)));
        }
    }

    public void setFrameTime(double d) {
        this.elapsedTime = (int)(1000.0 * d);
    }

    public void setPauseTime(double t) {
        this.pauseTime = (long)(1000.0 * t);
    }

    public void setMode(Motion.Mode m) {
        this.mode = m;
    }

    public boolean isStoped() {
        return !this.loopFlag && this.playCount > 0;
    }

    Node getNode() {
        return this.allBranchGroup;
    }

    int getActionNo() {
        return 0;
    }

    String getActionName() {
        return null;
    }

    String getActionNameFromActionNo(int an) {
        return this.a3Data.actions[an].actionName;
    }

    int getActionNoFromActionName(String an) {
        return this.a3Data.getActionNoFromActionName(an);
    }

    int getActionCount() {
        return this.a3Data.actions.length;
    }

    String[] getActionNames() {
        return (String[])this.a3Data.actionNames.clone();
    }

    boolean isStoped(int actionNo) {
        return this.a3Data.actions[actionNo].isStoped();
    }

    double getMotionLength(int actionNo) {
        return this.a3Data.actions[actionNo].getMotionLength();
    }

    double getMotionLength(String actionName) {
        int actionNo = this.getActionNoFromActionName(actionName);
        return this.a3Data.actions[actionNo].getMotionLength();
    }

    String getActionName(int i) {
        return null;
    }

    String getComment() {
        return this.a3Data.comment;
    }

    int getFrameCount() {
        return this.a3Data.actionNames.length;
    }

    void setAutoActionControl(boolean b) {
        this.a3Data.autoActionControl = b;
    }

    boolean autoActionControl() {
        return this.a3Data.autoActionControl;
    }

    void setHaltAction(int i) {
        this.a3Data.haltActionNo = i;
    }

    void setHaltAction(Serializable s) {
        if (s instanceof String) {
            this.setHaltAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setHaltAction((Integer)s);
        }
    }

    int getHaltActionNo() {
        return this.a3Data.haltActionNo;
    }

    void setWalkAction(int i) {
        this.a3Data.walkActionNo = i;
    }

    void setWalkAction(Serializable s) {
        if (s instanceof String) {
            this.setWalkAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setWalkAction((Integer)s);
        }
    }

    int getWalkActionNo() {
        return this.a3Data.walkActionNo;
    }

    void setMinWalkSpeed(double d) {
        this.a3Data.minWalkSpeed = d;
    }

    double getMinWalkSpeed() {
        return this.a3Data.minWalkSpeed;
    }

    void setRunAction(int i) {
        this.a3Data.runActionNo = i;
    }

    void setRunAction(Serializable s) {
        if (s instanceof String) {
            this.setRunAction(this.getActionNoFromActionName((String)((Object)s)));
        } else if (s instanceof Integer) {
            this.setRunAction((Integer)s);
        }
    }

    int getRunActionNo() {
        return this.a3Data.runActionNo;
    }

    void setMinRunSpeed(double d) {
        this.a3Data.minRunSpeed = d;
    }

    double getMinRunSpeed() {
        return this.a3Data.minRunSpeed;
    }

    void setMotion(int actionNo, Motion motion) {
        String actionName = this.a3Data.getActionName(actionNo);
        this.a3Data.motions.put(actionName, motion);
    }

    void setMotion(Serializable action, Motion motion) {
        String actionName = null;
        if (action instanceof String) {
            actionName = (String)((Object)action);
        }
        if (action instanceof Integer) {
            actionName = this.a3Data.getActionName((Integer)action);
        }
        this.a3Data.motions.put(actionName, motion);
    }

    void setShape(int actionNo, String boneName, Node shape) {
    }

    void setShape(Serializable action, String boneName, Node shape) {
    }

    void setSound(int actionNo, MediaContainer sound) {
    }

    void setSound(Serializable action, MediaContainer sound) {
    }
}

