/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Object;

public class ChaseController
extends A3Controller
implements Runnable {
    Thread t;
    volatile boolean stopRequest = false;
    Matrix4d mc;

    public ChaseController() {
        this.mc = new Matrix4d(new Quat4d(0.0, 1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -5.0), 1.0);
    }

    public ChaseController(Matrix4d mc) {
        this.mc = new Matrix4d(mc);
    }

    @Override
    public void init() {
        this.stopRequest = false;
        this.t = new Thread(this);
        this.t.start();
    }

    @Override
    public void stop() {
        this.stopRequest = true;
    }

    @Override
    public void run() {
        while (!this.stopRequest) {
            A3Object avatar = this.a3canvas.getAvatar();
            if (avatar == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {}
                continue;
            }
            Vector3d av = avatar.getLoc();
            Quat4d aq = avatar.getQuat();
            double as = avatar.getScale();
            Matrix4d ma = new Matrix4d(aq, av, as);
            ma.mul(this.mc);
            ma.get(av);
            ma.get(aq);
            as = ma.getScale();
            this.a3canvas.setCameraLoc(av);
            this.a3canvas.setCameraQuat(aq);
            this.a3canvas.setCameraScale(as);
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
    }
}

