package jp.sourceforge.acerola3d.a3editor;

import java.io.*;
import java.util.*;

class A3eFile {
    static final A3eFile noneFile = new A3eFile();
    A3eFileManager fileManager;
    String name;
    A3eFile parent;
    ArrayList<A3eFile> children = new ArrayList<A3eFile>();
    A3eFileType type;
    boolean isIgnored = false;
    A3eFile() {
        name="[none]";
    }
    A3eFile(A3eFileManager fileManager,A3eFile parent,String name) {
        this.fileManager = fileManager;
        this.parent = parent;
        this.name = name;
        type = autoDetectFileType();
        if (type==A3eFileType.UNKNOWN)
            isIgnored = true;
    }
    File toFile() {
        if (parent==null)
            return fileManager.rootDir;
        return new File(parent.toFile(),name);
    }
    A3eFileType autoDetectFileType() {
        File f = toFile();
        if (f.isDirectory()) {
            return A3eFileType.DIR;
        } else {
            String path = getPath();
            if (path.equals("CATALOG.XML")) {
                return A3eFileType.CATALOG;
            }
            if (path.equals("catalog.xml")) {
                return A3eFileType.CATALOG;
            }
            String s = name.toLowerCase();
            int i = s.lastIndexOf('.');
            if (i!=-1)
                s = s.substring(i);
            if (s.equals(".bvh")) {
                return A3eFileType.BVH;
            } else if (s.equals(".wrl")) {
                return A3eFileType.VRML;
            } else if (s.equals(".jpg")||s.equals(".png")||s.equals(".gif")) {
                return A3eFileType.IMAGE;
            } else if (s.equals(".jpeg")||s.equals(".bmp")) {
                return A3eFileType.IMAGE;
            } else if (s.equals(".wav")||s.equals(".au")||s.equals(".aiff")) {
                return A3eFileType.SOUND;
            } else if (s.equals(".mp3")||s.equals(".ogg")) {
                return A3eFileType.SOUND;
            } else if (s.equals(".html")||s.equals(".htm")||s.equals(".xhtml")) {
                return A3eFileType.HTML;
            }
        }
        return A3eFileType.UNKNOWN;
    }
    String getPath() {
        if (parent==null)
            return "";
        String pp = parent.getPath();
        if (pp.equals(""))
            return name;
        else
            return pp+"/"+name;
    }
    String getURLString() {
        return fileManager.path2UrlString(getPath());
    }
    void setIgnored(boolean b) {
        if (b==true) {
            isIgnored=true;
            for (A3eFile f:children) {
                f.setIgnored(true);
            }
        } else {
            isIgnored=false;
            if (parent!=null)
                parent.setIgnored(false);
        }
    }
    boolean isIgnored() {
        return isIgnored;
    }
    void setFileType(A3eFileType t) {
        type = t;
    }
    boolean isDirectory() {
        if (type==A3eFileType.DIR)
            return true;
        else
            return false;
    }
    public String toString() {
        return name;
    }
}
