package jp.sourceforge.acerola3d.a3editor;

import java.awt.*;
import java.awt.event.*;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.*;

class A3eFileGUI extends JPanel implements MouseListener, ActionListener {
    private static final long serialVersionUID = 1L;
    A3eFileManagerGUI fileManagerGUI;
    A3eFile file;
    JLabel filenameL;
    static String fileTypeS[] = {"ディレクトリ","カタログ","BVH","VRML","画像","音声","HTML","UNKNOWN"};
    JCheckBox isIgnoredCB;
    JComboBox filetypeCB;
    A3eFileGUI(A3eFile f,A3eFileManagerGUI fmGUI) {
        fileManagerGUI = fmGUI;
        file = f;
        this.setLayout(new BoxLayout(this,BoxLayout.X_AXIS));

        isIgnoredCB = new JCheckBox("除外");
        if (file.isIgnored)
            isIgnoredCB.setSelected(true);
        else
            isIgnoredCB.setSelected(false);
        isIgnoredCB.addActionListener(this);
        this.add(isIgnoredCB);
        filetypeCB = new JComboBox(fileTypeS);
        filetypeCB.setMaximumSize(new Dimension(30,20));
        if (file.type==A3eFileType.DIR)
            filetypeCB.setSelectedItem(fileTypeS[0]);
        else if (file.type==A3eFileType.CATALOG)
            filetypeCB.setSelectedItem(fileTypeS[1]);
        else if (file.type==A3eFileType.BVH)
            filetypeCB.setSelectedItem(fileTypeS[2]);
        else if (file.type==A3eFileType.VRML)
            filetypeCB.setSelectedItem(fileTypeS[3]);
        else if (file.type==A3eFileType.IMAGE)
            filetypeCB.setSelectedItem(fileTypeS[4]);
        else if (file.type==A3eFileType.SOUND)
            filetypeCB.setSelectedItem(fileTypeS[5]);
        else if (file.type==A3eFileType.HTML)
            filetypeCB.setSelectedItem(fileTypeS[6]);
        else if (file.type==A3eFileType.UNKNOWN)
            filetypeCB.setSelectedItem(fileTypeS[7]);
        filetypeCB.addActionListener(this);
        this.add(filetypeCB);

        ImageIcon icon = null;
        try {
            URL url = null;
            if (file.type==A3eFileType.DIR)
                url = new URL("x-res:///jp/sourceforge/acerola3d/a3editor/resources/directory.png");
            else
                url = new URL("x-res:///jp/sourceforge/acerola3d/a3editor/resources/file.png");
            icon = new ImageIcon(url);
        } catch(MalformedURLException e) {
            e.printStackTrace();
        }
        filenameL = new JLabel(f.name,icon,JLabel.CENTER);
        filenameL.addMouseListener(this);
        this.add(filenameL);
        this.add(Box.createHorizontalGlue());
        setSelected(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource()==isIgnoredCB) {
            if (isIgnoredCB.isSelected())
                file.setIgnored(true);
            else
                file.setIgnored(false);
        } else if (e.getSource()==filetypeCB) {
            if (filetypeCB.getSelectedIndex()==0)
                file.setFileType(A3eFileType.DIR);
            else if (filetypeCB.getSelectedIndex()==1)
                file.setFileType(A3eFileType.CATALOG);
            else if (filetypeCB.getSelectedIndex()==2)
                file.setFileType(A3eFileType.BVH);
            else if (filetypeCB.getSelectedIndex()==3)
                file.setFileType(A3eFileType.VRML);
            else if (filetypeCB.getSelectedIndex()==4)
                file.setFileType(A3eFileType.IMAGE);
            else if (filetypeCB.getSelectedIndex()==5)
                file.setFileType(A3eFileType.SOUND);
            else if (filetypeCB.getSelectedIndex()==6)
                file.setFileType(A3eFileType.HTML);
            else if (filetypeCB.getSelectedIndex()==7)
                file.setFileType(A3eFileType.UNKNOWN);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton()!=MouseEvent.BUTTON1)
            return;
        int clickCount = e.getClickCount();
        if (file.type==A3eFileType.DIR && clickCount==2) {
            fileManagerGUI.currentDir=file;
            fileManagerGUI.refresh();
        }
        fileManagerGUI.openViewer(file,this);
    }
    public void mouseEntered(MouseEvent e) {;}
    public void mouseExited(MouseEvent e) {;}
    public void mousePressed(MouseEvent e) {;}
    public void mouseReleased(MouseEvent e) {;}
    void setSelected(boolean b) {
        if (b==true) {
            this.setBackground(Color.red);
            isIgnoredCB.setBackground(Color.red);
        } else {
            setBackground(Color.white);
            isIgnoredCB.setBackground(Color.white);
        }
    }
}
